/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./modules/vendor-verification/src/admin/index.tsx":
/*!*********************************************************!*\
  !*** ./modules/vendor-verification/src/admin/index.tsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/dom-ready */ "@wordpress/dom-ready");
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_admin_VerificationAdmin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../components/admin/VerificationAdmin */ "./modules/vendor-verification/src/components/admin/VerificationAdmin.tsx");
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./style.scss */ "./modules/vendor-verification/src/admin/style.scss");




_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1___default()(() => {
  // @ts-ignore
  wp.hooks.addFilter('dokan-admin-dashboard-routes', 'dokan-admin-vendor-verifications-panel', routes => {
    routes.push({
      id: 'verifications',
      element: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_admin_VerificationAdmin__WEBPACK_IMPORTED_MODULE_2__["default"], null),
      path: '/verifications'
    });
    return routes;
  });
});

/***/ }),

/***/ "./modules/vendor-verification/src/admin/style.scss":
/*!**********************************************************!*\
  !*** ./modules/vendor-verification/src/admin/style.scss ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./modules/vendor-verification/src/components/admin/VerificationAdmin.tsx":
/*!********************************************************************************!*\
  !*** ./modules/vendor-verification/src/components/admin/VerificationAdmin.tsx ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _VerificationList__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./VerificationList */ "./modules/vendor-verification/src/components/admin/VerificationList.tsx");



const VerificationAdmin = () => {
  const [currentStatus, setCurrentStatus] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('pending');
  const handleStatusChange = status => {
    setCurrentStatus(status);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "dokan-verification-admin"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "dokan-admin-content"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_VerificationList__WEBPACK_IMPORTED_MODULE_2__["default"], {
    currentStatus: currentStatus,
    onStatusChange: handleStatusChange
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VerificationAdmin);

/***/ }),

/***/ "./modules/vendor-verification/src/components/admin/VerificationList.tsx":
/*!*******************************************************************************!*\
  !*** ./modules/vendor-verification/src/components/admin/VerificationList.tsx ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/funnel.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/check.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/circle-x.js");
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @dokan/components */ "@dokan/components");
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_dokan_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _dokan_utilities__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @dokan/utilities */ "@dokan/utilities");
/* harmony import */ var _dokan_utilities__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_dokan_utilities__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @getdokan/dokan-ui */ "./node_modules/@getdokan/dokan-ui/dist/index.js");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var tailwind_merge__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! tailwind-merge */ "./node_modules/tailwind-merge/dist/bundle-mjs.mjs");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_url__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/lucide-react.js");











const VerificationList = ({
  currentStatus = 'pending',
  onStatusChange
}) => {
  const [data, setData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const [isLoading, setIsLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(true);
  const [error, setError] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
  const [totalItems, setTotalItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(0);
  const [statusCounts, setStatusCounts] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({
    pending: 0,
    approved: 0,
    rejected: 0,
    cancelled: 0,
    total: 0
  });
  const [filterArgs, setFilterArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
  const [activeStatus, setActiveStatus] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(currentStatus);
  const [showFilters, setShowFilters] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);

  // Modal state management
  const [modalState, setModalState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({
    isOpen: false,
    type: '',
    items: []
  });

  // Note state for add-note modal
  const [noteState, setNoteState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');
  const [localNoteState, setLocalNoteState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');

  // Set for handling bulk selection
  const [selection, setSelection] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const perPage = 20;

  // Set data view default layout
  const defaultLayouts = {
    table: {},
    grid: {},
    list: {},
    density: 'comfortable'
  };

  // Set view state for handling the table view
  const [view, setView] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({
    perPage,
    page: 1,
    search: '',
    type: 'table',
    titleField: 'id',
    status: activeStatus,
    layout: {
      ...defaultLayouts
    },
    fields: ['method', 'documents', 'status', 'vendor', 'note', 'created_at']
  });

  // Optimized handlers to prevent re-renders
  const handleNoteChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(event => {
    setLocalNoteState(event.target.value);
  }, []);
  const handleNoteBlur = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    setNoteState(localNoteState);
  }, [localNoteState]);

  // Modal helper functions
  const openModal = (type, items) => {
    setModalState({
      isOpen: true,
      type,
      items
    });

    // Initialize note state for add-note modal
    if (type === 'add-note' && items.length > 0) {
      const initialNote = items[0].note || '';
      setNoteState(initialNote);
      setLocalNoteState(initialNote);
    }
  };
  const closeModal = () => {
    setModalState({
      isOpen: false,
      type: '',
      items: []
    });
    setNoteState('');
    setLocalNoteState('');
  };

  // Handle data fetching from the server
  const fetchVerifications = async () => {
    setIsLoading(true);
    setError(null);
    try {
      var _view$perPage, _view$page, _view$search;
      const queryArgs = {
        per_page: (_view$perPage = view?.perPage) !== null && _view$perPage !== void 0 ? _view$perPage : 20,
        page: (_view$page = view?.page) !== null && _view$page !== void 0 ? _view$page : 1,
        search: (_view$search = view?.search) !== null && _view$search !== void 0 ? _view$search : '',
        status: view?.status,
        ...filterArgs
      };

      // Handle sorting
      if (view?.sort?.field) {
        queryArgs.orderby = view.sort.field;
      }
      if (view?.sort?.direction) {
        queryArgs.order = view.sort.direction;
      }

      // Handle filters
      if (view?.filters) {
        view.filters.forEach(filter => {
          if (filter.field === 'status' && filter.operator === 'isAny') {
            queryArgs.status = filter.value?.join(',');
          }
        });
      }

      // Fetch data from the REST API
      const response = await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default()({
        path: (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.addQueryArgs)('/dokan/v1/verification-requests', queryArgs),
        parse: false // Get raw response to access headers
      });
      const responseData = await response.json();
      const totalItemsFromHeader = parseInt(response.headers.get('X-WP-Total') || '0');
      setTotalItems(totalItemsFromHeader);
      setData(responseData);

      // Extract status counts from response headers
      const pendingCount = parseInt(response.headers.get('X-Status-Pending') || '0');
      const approvedCount = parseInt(response.headers.get('X-Status-Approved') || '0');
      const rejectedCount = parseInt(response.headers.get('X-Status-Rejected') || '0');
      const cancelledCount = parseInt(response.headers.get('X-Status-Cancelled') || '0');
      setStatusCounts({
        pending: pendingCount,
        approved: approvedCount,
        rejected: rejectedCount,
        cancelled: cancelledCount,
        total: totalItemsFromHeader
      });
    } catch (err) {
      setError(err instanceof Error ? err.message : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Failed to fetch verifications', 'dokan'));
    } finally {
      setIsLoading(false);
    }
  };

  // Handle bulk actions
  const handleBulkAction = async (action, ids) => {
    try {
      const updateData = {};
      if (action === 'approved') {
        updateData.status = 'approved';
        updateData.note = 'Approved by admin';
      } else if (action === 'rejected') {
        updateData.status = 'rejected';
        updateData.note = 'Rejected by admin';
      } else if (action === 'cancelled') {
        updateData.status = 'cancelled';
        updateData.note = 'Cancelled by admin';
      } else if (action === 'pending') {
        updateData.status = 'pending';
        updateData.note = 'Moved back to pending by admin';
      }

      // Handle bulk updates
      for (const id of ids) {
        await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default()({
          path: `/dokan/v1/verification-requests/${id}`,
          method: 'PATCH',
          body: JSON.stringify(updateData),
          headers: {
            'Content-Type': 'application/json'
          }
        });
      }
      fetchVerifications(); // Refresh data
      setSelection([]); // Clear selection
    } catch (error) {
      setError(error instanceof Error ? error.message : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Failed to perform bulk action', 'dokan'));
    }
  };

  // Handle update note
  const handleUpdateNote = async (id, note) => {
    try {
      await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default()({
        path: `/dokan/v1/verification-requests/${id}`,
        method: 'PATCH',
        body: JSON.stringify({
          note
        }),
        headers: {
          'Content-Type': 'application/json'
        }
      });
      fetchVerifications(); // Refresh data
    } catch (error) {
      setError(error instanceof Error ? error.message : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Failed to update note', 'dokan'));
    }
  };

  // Handle filter
  const handleFilter = () => {
    setView(prevView => ({
      ...prevView,
      page: 1 // Reset to first page when applying filters
    }));
    fetchVerifications();
  };

  // Clear filters
  const clearFilter = () => {
    setFilterArgs({});
    fetchVerifications();
  };

  // Handle tab selection for status filtering
  const handleTabSelect = tabName => {
    setActiveStatus(tabName);
    onStatusChange?.(tabName);
    setView(prevView => ({
      ...prevView,
      status: tabName,
      page: 1 // Reset to first page when changing status
    }));
  };

  // Fetch verifications when view changes
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    fetchVerifications();
  }, [view]);

  // Custom filter fields
  const VendorFilter = ({
    filterArgs,
    setFilterArgs
  }) => {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "min-w-48"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      className: "block text-sm font-medium text-gray-700 mb-1"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Vendor', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_3__.VendorAsyncSelect, {
      value: filterArgs.vendor || null,
      onChange: value => setFilterArgs({
        ...filterArgs,
        vendor: value
      }),
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Search vendors', 'dokan'),
      isClearable: true,
      defaultOptions: true,
      prefetch: true,
      strictPrefetchValidation: false
    }));
  };
  const MethodFilter = ({
    filterArgs,
    setFilterArgs
  }) => {
    const loadVerificationMethods = async inputValue => {
      try {
        const response = await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default()({
          path: (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.addQueryArgs)('/dokan/v1/verification-methods', {
            search: inputValue,
            per_page: 20
          })
        });
        if (Array.isArray(response)) {
          return response.map(method => ({
            value: method.id,
            label: method.title,
            raw: method
          }));
        }
        return [];
      } catch (error) {
        // Silently handle error and return empty array
        return [];
      }
    };
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "min-w-48"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      className: "block text-sm font-medium text-gray-700 mb-1"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Verification Method', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_3__.AsyncSelect, {
      value: filterArgs.method || null,
      onChange: value => setFilterArgs({
        ...filterArgs,
        method: value
      }),
      loadOptions: loadVerificationMethods,
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Search verification methods', 'dokan'),
      isClearable: true,
      defaultOptions: true,
      cacheOptions: true
    }));
  };

  // Define fields for the table columns
  const fields = [{
    id: 'id',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Request ID', 'dokan'),
    enableSorting: false,
    render: ({
      item
    }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "font-medium text-[#575757]"
    }, isLoading ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "block w-16 h-3 rounded bg-gray-200 animate-pulse"
    }) :
    // translators: %d: verification request ID
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('#%d', 'dokan'), item?.id))
  }, {
    id: 'method',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Method', 'dokan'),
    enableSorting: false,
    render: ({
      item
    }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "m-0 space-x-2 flex flex-wrap max-w-44 w-fit text-wrap leading-6 text-sm text-[#575757]"
    }, isLoading ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "block w-24 h-3 rounded bg-gray-200 animate-pulse"
    }) : (0,_dokan_utilities__WEBPACK_IMPORTED_MODULE_4__.truncate)(item?.method?.title, 45) || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('N/A', 'dokan'))
  }, {
    id: 'documents',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Documents', 'dokan'),
    enableSorting: false,
    render: ({
      item
    }) => {
      if (isLoading) {
        return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
          className: "block w-32 h-3 rounded bg-gray-200 animate-pulse"
        });
      }
      if (!item?.document_urls || Object.keys(item.document_urls).length === 0) {
        return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('No documents found', 'dokan');
      }
      const documentName = Object.values(item.document_urls).map(doc => doc.title).join(', ');
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
        content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.RawHTML, null, documentName)
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
        className: "m-0 space-x-2 flex flex-wrap max-w-44 w-fit text-wrap leading-6 text-sm text-[#575757]"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.RawHTML, null, (0,_dokan_utilities__WEBPACK_IMPORTED_MODULE_4__.truncate)(documentName, 45))));
    }
  }, {
    id: 'status',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Status', 'dokan'),
    enableSorting: false,
    render: ({
      item
    }) => {
      if (isLoading) {
        return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
          className: "block w-20 h-3 rounded bg-gray-200 animate-pulse"
        });
      }
      const statusColors = {
        pending: 'bg-[#FFEADB] text-[#A02020]',
        approved: 'bg-[#DFFFE0] text-[#0A5F1D]',
        rejected: 'bg-[#FFE5E5] text-[#B00020]',
        cancelled: 'bg-[#F0F0F0] text-[#333333]'
      };
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "w-fit max-w-28"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: `inline-flex items-center px-3.5 py-1.5 rounded-md text-xs font-medium ${statusColors[item?.status] || 'bg-gray-100 text-[#575757]'}`
      }, item?.status_title || item?.status));
    }
  }, {
    id: 'vendor',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Vendor', 'dokan'),
    enableSorting: false,
    render: ({
      item
    }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "text-sm text-[#575757] w-fit max-w-28"
    }, isLoading ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "block w-24 h-3 rounded bg-gray-200 animate-pulse"
    }) : (0,_dokan_utilities__WEBPACK_IMPORTED_MODULE_4__.truncate)(item?.vendor?.store_name || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Unknown', 'dokan'), 30))
  }, {
    id: 'note',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Note', 'dokan'),
    enableSorting: false,
    render: ({
      item
    }) => {
      if (isLoading) {
        return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
          className: "block w-32 h-3 rounded bg-gray-200 animate-pulse"
        });
      }
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
        content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.RawHTML, null, item?.note || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('No note found', 'dokan'))
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
        className: "m-0 space-x-2 flex flex-wrap max-w-40 w-fit text-wrap leading-6 text-sm text-[#575757]"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.RawHTML, null, item?.note ? (0,_dokan_utilities__WEBPACK_IMPORTED_MODULE_4__.truncate)(item?.note, 45) : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('-', 'dokan'))));
    }
  }, {
    id: 'created_at',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Date', 'dokan'),
    enableSorting: false,
    render: ({
      item
    }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "text-[#575757]"
    }, isLoading ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "block w-24 h-3 rounded bg-gray-200 animate-pulse"
    }) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_3__.DateTimeHtml.Date, {
      date: item?.created_at
    }))
  }];
  const getActionLabel = (iconName, label) => {
    if (!(iconName && label)) {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null);
    }
    const Icon = lucide_react__WEBPACK_IMPORTED_MODULE_8__[iconName];
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "dokan-layout"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "inline-flex items-center gap-2.5"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(Icon, {
      size: 16,
      className: "!fill-none"
    }), label));
  };

  // Define actions for table rows
  const actions = [
  // APPROVE ACTION - pending: bulk + ellipsis
  {
    id: 'approved',
    label: () => getActionLabel('Check', (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Approve', 'dokan')),
    icon: () => {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: 'px-2 py-1.5 inline-flex items-center rounded-md border border-[#E9E9E9]'
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Approve', 'dokan'));
    },
    isPrimary: false,
    supportsBulk: true,
    // pending: bulk
    isEligible: item => item?.status === 'pending',
    callback: items => {
      openModal('approve', items);
    }
  },
  // CANCEL ACTION - pending: bulk + ellipsis
  // {
  //     id: 'cancelled',
  //     label: () => getActionLabel( 'XCircle', __( 'Cancel', 'dokan' ) ),
  //     icon: () => {
  //         return (
  //             <span
  //                 className={
  //                     'px-2 py-1.5 inline-flex items-center rounded-md border border-[#E9E9E9]'
  //                 }
  //             >
  //                 { __( 'Cancel', 'dokan' ) }
  //             </span>
  //         );
  //     },
  //     isPrimary: false,
  //     disabled: true,
  //     supportsBulk: true, // pending: bulk
  //     isEligible: ( item ) => item?.status === 'pending',
  //     callback: ( items ) => {
  //         openModal( 'cancel', items );
  //     },
  // },
  // PENDING ACTION - approved: bulk + ellipsis, rejected: bulk + ellipsis, cancelled: bulk + ellipsis
  {
    id: 'pending',
    label: () => getActionLabel('RotateCw', (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Pending', 'dokan')),
    icon: () => {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: 'px-2 py-1.5 inline-flex items-center rounded-md border border-[#E9E9E9]'
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Pending', 'dokan'));
    },
    isPrimary: false,
    supportsBulk: true,
    // approved: bulk, rejected: bulk, cancelled: bulk
    isEligible: item => ['approved', 'rejected', 'cancelled'].includes(item?.status),
    callback: items => {
      openModal('pending', items);
    }
  },
  // REJECT ACTION - pending: bulk + ellipsis, approved: bulk, cancelled: ellipsis
  {
    id: 'rejected',
    label: () => getActionLabel('XCircle', (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Reject', 'dokan')),
    icon: () => {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: 'px-2 py-1.5 inline-flex items-center rounded-md border border-[#E9E9E9]'
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Reject', 'dokan'));
    },
    isPrimary: false,
    supportsBulk: true,
    // pending: bulk, approved: bulk
    isEligible: item => ['pending', 'approved', 'cancelled'].includes(item?.status),
    callback: items => {
      openModal('reject', items);
    }
  },
  // ADD/EDIT NOTE ACTION - all statuses: ellipsis only for pending/rejected/cancelled, approved: bulk + ellipsis
  {
    id: 'add-note',
    label: item => {
      const hasNote = item?.note && item.note.trim() !== '';
      return getActionLabel('Pen', hasNote ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Edit Note', 'dokan') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Add Note', 'dokan'));
    },
    icon: item => {
      const hasNote = item?.note && item.note.trim() !== '';
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: 'px-2 py-1.5 inline-flex items-center rounded-md border border-[#E9E9E9]'
      }, hasNote ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Edit Note', 'dokan') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Add Note', 'dokan'));
    },
    isPrimary: false,
    supportsBulk: false,
    callback: items => {
      openModal('add-note', items);
    }
  }];

  // Status filter tabs
  const statusTabs = [{
    key: 'pending',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Pending', 'dokan'),
    count: statusCounts.pending
  }, {
    key: 'approved',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Approved', 'dokan'),
    count: statusCounts.approved
  }, {
    key: 'rejected',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Rejected', 'dokan'),
    count: statusCounts.rejected
  }, {
    key: 'cancelled',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Cancelled', 'dokan'),
    count: statusCounts.cancelled
  }];

  // Create tabs with status counts - always show count, even if 0
  const tabs = statusTabs.map(tab => ({
    name: tab.key,
    title: `${tab.label} (${tab.count || 0})`
  }));
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "verification-admin-page"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mb-6 flex items-center justify-between gap-3"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_3__.DokanTab, {
    namespace: "verification_status_tabs",
    tabs: tabs,
    variant: "primary",
    onSelect: handleTabSelect,
    initialTabName: activeStatus
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    type: "button",
    className: (0,tailwind_merge__WEBPACK_IMPORTED_MODULE_9__.twMerge)('inline-flex items-center gap-2 rounded-md border border-gray-300 bg-white px-3 py-1.5 text-sm hover:bg-[#7047EB] hover:text-white', showFilters ? 'bg-[#7047EB] text-white' : 'text-[#575757] bg-white'),
    onClick: () => setShowFilters(v => !v)
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_10__["default"], {
    size: 16
  }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Filter', 'dokan')))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: `mb-6 dokan-dashboard-filters ${showFilters ? '' : 'hidden'}`
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_3__.Filter, {
    fields: [(0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(VendorFilter, {
      key: "vendor_filter",
      filterArgs: filterArgs,
      setFilterArgs: setFilterArgs
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(MethodFilter, {
      key: "method_filter",
      filterArgs: filterArgs,
      setFilterArgs: setFilterArgs
    })],
    onFilter: handleFilter,
    onReset: clearFilter,
    showFilter: true,
    showReset: true,
    namespace: "verification_filters"
  })), error && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded mb-4"
  }, error), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_3__.DataViews, {
    data: data,
    namespace: "verification-data-view",
    defaultLayouts: defaultLayouts,
    fields: fields,
    getItemId: item => item.id,
    onChangeView: setView,
    paginationInfo: {
      totalItems,
      totalPages: Math.ceil(totalItems / view.perPage)
    },
    view: view,
    selection: selection,
    onChangeSelection: setSelection,
    actions: actions
  }), modalState.isOpen && modalState.type === 'approve' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_3__.DokanModal, {
    isOpen: modalState.isOpen,
    namespace: `approve-verification-${modalState.items.length}`,
    onClose: closeModal,
    onConfirm: async () => {
      await handleBulkAction('approved', modalState.items.map(item => item.id));
      closeModal();
    },
    dialogTitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Approve Verification', 'dokan'),
    confirmButtonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Approve', 'dokan'),
    confirmationTitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Confirm Approval', 'dokan'),
    confirmationDescription: modalState.items.length === 1 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Are you sure you want to approve this verification request?', 'dokan') : `${(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Are you sure you want to approve these', 'dokan')} ${modalState.items.length} ${(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('verification requests?', 'dokan')}`,
    confirmButtonVariant: "primary",
    dialogIcon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex items-center justify-center flex-shrink-0 w-14 h-14 bg-green-50 border border-green-50 rounded-full"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_11__["default"], {
      size: 24,
      className: "text-green-600"
    }))
  }), modalState.isOpen && modalState.type === 'reject' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_3__.DokanModal, {
    isOpen: modalState.isOpen,
    namespace: `reject-verification-${modalState.items.length}`,
    onClose: closeModal,
    onConfirm: async () => {
      await handleBulkAction('rejected', modalState.items.map(item => item.id));
      closeModal();
    },
    dialogTitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Reject Verification', 'dokan'),
    confirmButtonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Reject', 'dokan'),
    confirmationTitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Confirm Rejection', 'dokan'),
    confirmationDescription: modalState.items.length === 1 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Are you sure you want to reject this verification request?', 'dokan') : `${(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Are you sure you want to reject these', 'dokan')} ${modalState.items.length} ${(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('verification requests?', 'dokan')}`,
    confirmButtonVariant: "primary",
    dialogIcon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex items-center justify-center flex-shrink-0 w-14 h-14 bg-red-50 border border-red-50 rounded-full"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_12__["default"], {
      size: 24,
      className: "text-red-600"
    }))
  }), modalState.isOpen && modalState.type === 'pending' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_3__.DokanModal, {
    isOpen: modalState.isOpen,
    namespace: `pending-verification-${modalState.items.length}`,
    onClose: closeModal,
    onConfirm: async () => {
      await handleBulkAction('pending', modalState.items.map(item => item.id));
      closeModal();
    },
    dialogTitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Mark as Pending', 'dokan'),
    confirmButtonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Mark as Pending', 'dokan'),
    confirmationTitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Confirm Status Change', 'dokan'),
    confirmationDescription: modalState.items.length === 1 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Are you sure you want to mark this verification request as pending?', 'dokan') : `${(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Are you sure you want to mark these', 'dokan')} ${modalState.items.length} ${(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('verification requests as pending?', 'dokan')}`,
    confirmButtonVariant: "primary",
    dialogIcon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex items-center justify-center flex-shrink-0 w-14 h-14 bg-orange-50 border border-orange-50 rounded-full"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      className: "w-6 h-6 text-orange-600",
      fill: "none",
      stroke: "currentColor",
      viewBox: "0 0 24 24"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      strokeLinecap: "round",
      strokeLinejoin: "round",
      strokeWidth: "2",
      d: "M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"
    })))
  }), modalState.isOpen && modalState.type === 'add-note' && modalState.items.length > 0 && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_3__.DokanModal, {
    className: `w-96 max-w-full`,
    isOpen: modalState.isOpen,
    namespace: `add-note-verification-${modalState.items[0]?.id}`,
    onClose: closeModal,
    onConfirm: async () => {
      await handleUpdateNote(modalState.items[0]?.id, noteState);
      closeModal();
    },
    dialogTitle: modalState.items[0]?.note ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Edit note for this verification', 'dokan') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Add note for this verification', 'dokan'),
    confirmButtonText: modalState.items[0]?.note ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Update Note', 'dokan') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Add Note', 'dokan'),
    dialogIcon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null),
    dialogContent: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "sm:text-left flex-1"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "mt-2"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_5__.TextArea, {
      disabled: isLoading,
      className: "min-h-48",
      input: {
        id: 'dokan-verification-note-modal',
        defaultValue: localNoteState,
        onChange: handleNoteChange,
        onBlur: handleNoteBlur,
        placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Write here', 'dokan')
      }
    })))
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VerificationList);

/***/ }),

/***/ "./node_modules/@getdokan/dokan-ui/dist/index.js":
/*!*******************************************************!*\
  !*** ./node_modules/@getdokan/dokan-ui/dist/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

var react__WEBPACK_IMPORTED_MODULE_0___namespace_cache;
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AsyncSearchableSelect: () => (/* binding */ W_),
/* harmony export */   Badge: () => (/* binding */ d_),
/* harmony export */   Box: () => (/* binding */ c_),
/* harmony export */   Button: () => (/* binding */ $d),
/* harmony export */   Card: () => (/* binding */ sr),
/* harmony export */   ConfirmModal: () => (/* binding */ L_),
/* harmony export */   Container: () => (/* binding */ f_),
/* harmony export */   Divider: () => (/* binding */ p_),
/* harmony export */   DokanIcon: () => (/* binding */ ON),
/* harmony export */   DokanToaster: () => (/* binding */ G_),
/* harmony export */   Drawer: () => (/* binding */ m_),
/* harmony export */   Dropdown: () => (/* binding */ Nc),
/* harmony export */   ErrorIcon: () => (/* binding */ SC),
/* harmony export */   ErrorMessage: () => (/* binding */ Pu),
/* harmony export */   FancyCheckbox: () => (/* binding */ v_),
/* harmony export */   FormInput: () => (/* binding */ DF),
/* harmony export */   FormLabel: () => (/* binding */ T5),
/* harmony export */   FormSelect: () => (/* binding */ H_),
/* harmony export */   FormTextarea: () => (/* binding */ MF),
/* harmony export */   GoogleIcon: () => (/* binding */ b_),
/* harmony export */   GooglePlaceAutocomplete: () => (/* binding */ D_),
/* harmony export */   Loader: () => (/* binding */ M_),
/* harmony export */   MaskedInput: () => (/* binding */ B_),
/* harmony export */   Modal: () => (/* binding */ wt),
/* harmony export */   MultipleTextInput: () => (/* binding */ y_),
/* harmony export */   Popover: () => (/* binding */ hr),
/* harmony export */   RadioGroup: () => (/* binding */ O_),
/* harmony export */   SearchableSelect: () => (/* binding */ $_),
/* harmony export */   Select: () => (/* binding */ uu),
/* harmony export */   SimpleAlert: () => (/* binding */ x_),
/* harmony export */   SimpleCheckbox: () => (/* binding */ RN),
/* harmony export */   SimpleCheckboxGroup: () => (/* binding */ C_),
/* harmony export */   SimpleHeader: () => (/* binding */ w_),
/* harmony export */   SimpleInput: () => (/* binding */ I_),
/* harmony export */   SimpleRadio: () => (/* binding */ E_),
/* harmony export */   SimpleSelect: () => (/* binding */ A_),
/* harmony export */   TaggableSelect: () => (/* binding */ S_),
/* harmony export */   TextArea: () => (/* binding */ P_),
/* harmony export */   ToggleSwitch: () => (/* binding */ T_),
/* harmony export */   Tooltip: () => (/* binding */ __),
/* harmony export */   TrailingInput: () => (/* binding */ R_),
/* harmony export */   useToast: () => (/* binding */ j_)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "react-dom");




var Jn = typeof globalThis < "u" ? globalThis : typeof window < "u" ? window : typeof global < "u" ? global : typeof self < "u" ? self : {};
function ia(l) {
  return l && l.__esModule && Object.prototype.hasOwnProperty.call(l, "default") ? l.default : l;
}
var bd = { exports: {} }, Dr = {};
/**
 * @license React
 * react-jsx-runtime.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var V2;
function Ab() {
  if (V2) return Dr;
  V2 = 1;
  var l = react__WEBPACK_IMPORTED_MODULE_0__, n = Symbol.for("react.element"), u = Symbol.for("react.fragment"), t = Object.prototype.hasOwnProperty, r = l.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner, o = { key: !0, ref: !0, __self: !0, __source: !0 };
  function s(d, a, f) {
    var p, g = {}, m = null, v = null;
    f !== void 0 && (m = "" + f), a.key !== void 0 && (m = "" + a.key), a.ref !== void 0 && (v = a.ref);
    for (p in a) t.call(a, p) && !o.hasOwnProperty(p) && (g[p] = a[p]);
    if (d && d.defaultProps) for (p in a = d.defaultProps, a) g[p] === void 0 && (g[p] = a[p]);
    return { $$typeof: n, type: d, key: m, ref: v, props: g, _owner: r.current };
  }
  return Dr.Fragment = u, Dr.jsx = s, Dr.jsxs = s, Dr;
}
var Mr = {};
/**
 * @license React
 * react-jsx-runtime.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var k2;
function Sb() {
  return k2 || (k2 = 1,  true && function() {
    var l = react__WEBPACK_IMPORTED_MODULE_0__, n = Symbol.for("react.element"), u = Symbol.for("react.portal"), t = Symbol.for("react.fragment"), r = Symbol.for("react.strict_mode"), o = Symbol.for("react.profiler"), s = Symbol.for("react.provider"), d = Symbol.for("react.context"), a = Symbol.for("react.forward_ref"), f = Symbol.for("react.suspense"), p = Symbol.for("react.suspense_list"), g = Symbol.for("react.memo"), m = Symbol.for("react.lazy"), v = Symbol.for("react.offscreen"), $ = Symbol.iterator, b = "@@iterator";
    function E(D) {
      if (D === null || typeof D != "object")
        return null;
      var nl = $ && D[$] || D[b];
      return typeof nl == "function" ? nl : null;
    }
    var S = l.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;
    function A(D) {
      {
        for (var nl = arguments.length, gl = new Array(nl > 1 ? nl - 1 : 0), _l = 1; _l < nl; _l++)
          gl[_l - 1] = arguments[_l];
        x("error", D, gl);
      }
    }
    function x(D, nl, gl) {
      {
        var _l = S.ReactDebugCurrentFrame, Ql = _l.getStackAddendum();
        Ql !== "" && (nl += "%s", gl = gl.concat([Ql]));
        var un = gl.map(function(zl) {
          return String(zl);
        });
        un.unshift("Warning: " + nl), Function.prototype.apply.call(console[D], console, un);
      }
    }
    var I = !1, P = !1, O = !1, _ = !1, j = !1, z;
    z = Symbol.for("react.module.reference");
    function Y(D) {
      return !!(typeof D == "string" || typeof D == "function" || D === t || D === o || j || D === r || D === f || D === p || _ || D === v || I || P || O || typeof D == "object" && D !== null && (D.$$typeof === m || D.$$typeof === g || D.$$typeof === s || D.$$typeof === d || D.$$typeof === a || // This needs to include all possible module reference object
      // types supported by any Flight configuration anywhere since
      // we don't know which Flight build this will end up being used
      // with.
      D.$$typeof === z || D.getModuleId !== void 0));
    }
    function el(D, nl, gl) {
      var _l = D.displayName;
      if (_l)
        return _l;
      var Ql = nl.displayName || nl.name || "";
      return Ql !== "" ? gl + "(" + Ql + ")" : gl;
    }
    function U(D) {
      return D.displayName || "Context";
    }
    function ul(D) {
      if (D == null)
        return null;
      if (typeof D.tag == "number" && A("Received an unexpected object in getComponentNameFromType(). This is likely a bug in React. Please file an issue."), typeof D == "function")
        return D.displayName || D.name || null;
      if (typeof D == "string")
        return D;
      switch (D) {
        case t:
          return "Fragment";
        case u:
          return "Portal";
        case o:
          return "Profiler";
        case r:
          return "StrictMode";
        case f:
          return "Suspense";
        case p:
          return "SuspenseList";
      }
      if (typeof D == "object")
        switch (D.$$typeof) {
          case d:
            var nl = D;
            return U(nl) + ".Consumer";
          case s:
            var gl = D;
            return U(gl._context) + ".Provider";
          case a:
            return el(D, D.render, "ForwardRef");
          case g:
            var _l = D.displayName || null;
            return _l !== null ? _l : ul(D.type) || "Memo";
          case m: {
            var Ql = D, un = Ql._payload, zl = Ql._init;
            try {
              return ul(zl(un));
            } catch {
              return null;
            }
          }
        }
      return null;
    }
    var il = Object.assign, rl = 0, tl, sl, ll, H, V, X, dl;
    function fl() {
    }
    fl.__reactDisabledLog = !0;
    function $l() {
      {
        if (rl === 0) {
          tl = console.log, sl = console.info, ll = console.warn, H = console.error, V = console.group, X = console.groupCollapsed, dl = console.groupEnd;
          var D = {
            configurable: !0,
            enumerable: !0,
            value: fl,
            writable: !0
          };
          Object.defineProperties(console, {
            info: D,
            log: D,
            warn: D,
            error: D,
            group: D,
            groupCollapsed: D,
            groupEnd: D
          });
        }
        rl++;
      }
    }
    function cl() {
      {
        if (rl--, rl === 0) {
          var D = {
            configurable: !0,
            enumerable: !0,
            writable: !0
          };
          Object.defineProperties(console, {
            log: il({}, D, {
              value: tl
            }),
            info: il({}, D, {
              value: sl
            }),
            warn: il({}, D, {
              value: ll
            }),
            error: il({}, D, {
              value: H
            }),
            group: il({}, D, {
              value: V
            }),
            groupCollapsed: il({}, D, {
              value: X
            }),
            groupEnd: il({}, D, {
              value: dl
            })
          });
        }
        rl < 0 && A("disabledDepth fell below zero. This is a bug in React. Please file an issue.");
      }
    }
    var xl = S.ReactCurrentDispatcher, ol;
    function ml(D, nl, gl) {
      {
        if (ol === void 0)
          try {
            throw Error();
          } catch (Ql) {
            var _l = Ql.stack.trim().match(/\n( *(at )?)/);
            ol = _l && _l[1] || "";
          }
        return `
` + ol + D;
      }
    }
    var Sl = !1, Ol;
    {
      var Cl = typeof WeakMap == "function" ? WeakMap : Map;
      Ol = new Cl();
    }
    function Q(D, nl) {
      if (!D || Sl)
        return "";
      {
        var gl = Ol.get(D);
        if (gl !== void 0)
          return gl;
      }
      var _l;
      Sl = !0;
      var Ql = Error.prepareStackTrace;
      Error.prepareStackTrace = void 0;
      var un;
      un = xl.current, xl.current = null, $l();
      try {
        if (nl) {
          var zl = function() {
            throw Error();
          };
          if (Object.defineProperty(zl.prototype, "props", {
            set: function() {
              throw Error();
            }
          }), typeof Reflect == "object" && Reflect.construct) {
            try {
              Reflect.construct(zl, []);
            } catch (au) {
              _l = au;
            }
            Reflect.construct(D, [], zl);
          } else {
            try {
              zl.call();
            } catch (au) {
              _l = au;
            }
            D.call(zl.prototype);
          }
        } else {
          try {
            throw Error();
          } catch (au) {
            _l = au;
          }
          D();
        }
      } catch (au) {
        if (au && _l && typeof au.stack == "string") {
          for (var kl = au.stack.split(`
`), Xn = _l.stack.split(`
`), Cn = kl.length - 1, Sn = Xn.length - 1; Cn >= 1 && Sn >= 0 && kl[Cn] !== Xn[Sn]; )
            Sn--;
          for (; Cn >= 1 && Sn >= 0; Cn--, Sn--)
            if (kl[Cn] !== Xn[Sn]) {
              if (Cn !== 1 || Sn !== 1)
                do
                  if (Cn--, Sn--, Sn < 0 || kl[Cn] !== Xn[Sn]) {
                    var ou = `
` + kl[Cn].replace(" at new ", " at ");
                    return D.displayName && ou.includes("<anonymous>") && (ou = ou.replace("<anonymous>", D.displayName)), typeof D == "function" && Ol.set(D, ou), ou;
                  }
                while (Cn >= 1 && Sn >= 0);
              break;
            }
        }
      } finally {
        Sl = !1, xl.current = un, cl(), Error.prepareStackTrace = Ql;
      }
      var Hu = D ? D.displayName || D.name : "", xi = Hu ? ml(Hu) : "";
      return typeof D == "function" && Ol.set(D, xi), xi;
    }
    function Xl(D, nl, gl) {
      return Q(D, !1);
    }
    function Bl(D) {
      var nl = D.prototype;
      return !!(nl && nl.isReactComponent);
    }
    function Kl(D, nl, gl) {
      if (D == null)
        return "";
      if (typeof D == "function")
        return Q(D, Bl(D));
      if (typeof D == "string")
        return ml(D);
      switch (D) {
        case f:
          return ml("Suspense");
        case p:
          return ml("SuspenseList");
      }
      if (typeof D == "object")
        switch (D.$$typeof) {
          case a:
            return Xl(D.render);
          case g:
            return Kl(D.type, nl, gl);
          case m: {
            var _l = D, Ql = _l._payload, un = _l._init;
            try {
              return Kl(un(Ql), nl, gl);
            } catch {
            }
          }
        }
      return "";
    }
    var fn = Object.prototype.hasOwnProperty, dn = {}, Fn = S.ReactDebugCurrentFrame;
    function sn(D) {
      if (D) {
        var nl = D._owner, gl = Kl(D.type, D._source, nl ? nl.type : null);
        Fn.setExtraStackFrame(gl);
      } else
        Fn.setExtraStackFrame(null);
    }
    function gn(D, nl, gl, _l, Ql) {
      {
        var un = Function.call.bind(fn);
        for (var zl in D)
          if (un(D, zl)) {
            var kl = void 0;
            try {
              if (typeof D[zl] != "function") {
                var Xn = Error((_l || "React class") + ": " + gl + " type `" + zl + "` is invalid; it must be a function, usually from the `prop-types` package, but received `" + typeof D[zl] + "`.This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.");
                throw Xn.name = "Invariant Violation", Xn;
              }
              kl = D[zl](nl, zl, _l, gl, null, "SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED");
            } catch (Cn) {
              kl = Cn;
            }
            kl && !(kl instanceof Error) && (sn(Ql), A("%s: type specification of %s `%s` is invalid; the type checker function must return `null` or an `Error` but returned a %s. You may have forgotten to pass an argument to the type checker creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and shape all require an argument).", _l || "React class", gl, zl, typeof kl), sn(null)), kl instanceof Error && !(kl.message in dn) && (dn[kl.message] = !0, sn(Ql), A("Failed %s type: %s", gl, kl.message), sn(null));
          }
      }
    }
    var _n = Array.isArray;
    function Zn(D) {
      return _n(D);
    }
    function ne(D) {
      {
        var nl = typeof Symbol == "function" && Symbol.toStringTag, gl = nl && D[Symbol.toStringTag] || D.constructor.name || "Object";
        return gl;
      }
    }
    function _e(D) {
      try {
        return Nu(D), !1;
      } catch {
        return !0;
      }
    }
    function Nu(D) {
      return "" + D;
    }
    function ue(D) {
      if (_e(D))
        return A("The provided key is an unsupported type %s. This value must be coerced to a string before before using it here.", ne(D)), Nu(D);
    }
    var Kn = S.ReactCurrentOwner, mu = {
      key: !0,
      ref: !0,
      __self: !0,
      __source: !0
    }, R, G, W;
    W = {};
    function al(D) {
      if (fn.call(D, "ref")) {
        var nl = Object.getOwnPropertyDescriptor(D, "ref").get;
        if (nl && nl.isReactWarning)
          return !1;
      }
      return D.ref !== void 0;
    }
    function Pl(D) {
      if (fn.call(D, "key")) {
        var nl = Object.getOwnPropertyDescriptor(D, "key").get;
        if (nl && nl.isReactWarning)
          return !1;
      }
      return D.key !== void 0;
    }
    function Fl(D, nl) {
      if (typeof D.ref == "string" && Kn.current && nl && Kn.current.stateNode !== nl) {
        var gl = ul(Kn.current.type);
        W[gl] || (A('Component "%s" contains the string ref "%s". Support for string refs will be removed in a future major release. This case cannot be automatically converted to an arrow function. We ask you to manually fix this case by using useRef() or createRef() instead. Learn more about using refs safely here: https://reactjs.org/link/strict-mode-string-ref', ul(Kn.current.type), D.ref), W[gl] = !0);
      }
    }
    function on(D, nl) {
      {
        var gl = function() {
          R || (R = !0, A("%s: `key` is not a prop. Trying to access it will result in `undefined` being returned. If you need to access the same value within the child component, you should pass it as a different prop. (https://reactjs.org/link/special-props)", nl));
        };
        gl.isReactWarning = !0, Object.defineProperty(D, "key", {
          get: gl,
          configurable: !0
        });
      }
    }
    function xn(D, nl) {
      {
        var gl = function() {
          G || (G = !0, A("%s: `ref` is not a prop. Trying to access it will result in `undefined` being returned. If you need to access the same value within the child component, you should pass it as a different prop. (https://reactjs.org/link/special-props)", nl));
        };
        gl.isReactWarning = !0, Object.defineProperty(D, "ref", {
          get: gl,
          configurable: !0
        });
      }
    }
    var Dn = function(D, nl, gl, _l, Ql, un, zl) {
      var kl = {
        // This tag allows us to uniquely identify this as a React Element
        $$typeof: n,
        // Built-in properties that belong on the element
        type: D,
        key: nl,
        ref: gl,
        props: zl,
        // Record the component responsible for creating this element.
        _owner: un
      };
      return kl._store = {}, Object.defineProperty(kl._store, "validated", {
        configurable: !1,
        enumerable: !1,
        writable: !0,
        value: !1
      }), Object.defineProperty(kl, "_self", {
        configurable: !1,
        enumerable: !1,
        writable: !1,
        value: _l
      }), Object.defineProperty(kl, "_source", {
        configurable: !1,
        enumerable: !1,
        writable: !1,
        value: Ql
      }), Object.freeze && (Object.freeze(kl.props), Object.freeze(kl)), kl;
    };
    function ku(D, nl, gl, _l, Ql) {
      {
        var un, zl = {}, kl = null, Xn = null;
        gl !== void 0 && (ue(gl), kl = "" + gl), Pl(nl) && (ue(nl.key), kl = "" + nl.key), al(nl) && (Xn = nl.ref, Fl(nl, Ql));
        for (un in nl)
          fn.call(nl, un) && !mu.hasOwnProperty(un) && (zl[un] = nl[un]);
        if (D && D.defaultProps) {
          var Cn = D.defaultProps;
          for (un in Cn)
            zl[un] === void 0 && (zl[un] = Cn[un]);
        }
        if (kl || Xn) {
          var Sn = typeof D == "function" ? D.displayName || D.name || "Unknown" : D;
          kl && on(zl, Sn), Xn && xn(zl, Sn);
        }
        return Dn(D, kl, Xn, Ql, _l, Kn.current, zl);
      }
    }
    var at = S.ReactCurrentOwner, pi = S.ReactDebugCurrentFrame;
    function pe(D) {
      if (D) {
        var nl = D._owner, gl = Kl(D.type, D._source, nl ? nl.type : null);
        pi.setExtraStackFrame(gl);
      } else
        pi.setExtraStackFrame(null);
    }
    var Rt;
    Rt = !1;
    function vr(D) {
      return typeof D == "object" && D !== null && D.$$typeof === n;
    }
    function gi() {
      {
        if (at.current) {
          var D = ul(at.current.type);
          if (D)
            return `

Check the render method of \`` + D + "`.";
        }
        return "";
      }
    }
    function Ma(D) {
      return "";
    }
    var hi = {};
    function mi(D) {
      {
        var nl = gi();
        if (!nl) {
          var gl = typeof D == "string" ? D : D.displayName || D.name;
          gl && (nl = `

Check the top-level render call using <` + gl + ">.");
        }
        return nl;
      }
    }
    function bi(D, nl) {
      {
        if (!D._store || D._store.validated || D.key != null)
          return;
        D._store.validated = !0;
        var gl = mi(nl);
        if (hi[gl])
          return;
        hi[gl] = !0;
        var _l = "";
        D && D._owner && D._owner !== at.current && (_l = " It was passed a child from " + ul(D._owner.type) + "."), pe(D), A('Each child in a list should have a unique "key" prop.%s%s See https://reactjs.org/link/warning-keys for more information.', gl, _l), pe(null);
      }
    }
    function yi(D, nl) {
      {
        if (typeof D != "object")
          return;
        if (Zn(D))
          for (var gl = 0; gl < D.length; gl++) {
            var _l = D[gl];
            vr(_l) && bi(_l, nl);
          }
        else if (vr(D))
          D._store && (D._store.validated = !0);
        else if (D) {
          var Ql = E(D);
          if (typeof Ql == "function" && Ql !== D.entries)
            for (var un = Ql.call(D), zl; !(zl = un.next()).done; )
              vr(zl.value) && bi(zl.value, nl);
        }
      }
    }
    function Ba(D) {
      {
        var nl = D.type;
        if (nl == null || typeof nl == "string")
          return;
        var gl;
        if (typeof nl == "function")
          gl = nl.propTypes;
        else if (typeof nl == "object" && (nl.$$typeof === a || // Note: Memo only checks outer props here.
        // Inner props are checked in the reconciler.
        nl.$$typeof === g))
          gl = nl.propTypes;
        else
          return;
        if (gl) {
          var _l = ul(nl);
          gn(gl, D.props, "prop", _l, D);
        } else if (nl.PropTypes !== void 0 && !Rt) {
          Rt = !0;
          var Ql = ul(nl);
          A("Component %s declared `PropTypes` instead of `propTypes`. Did you misspell the property assignment?", Ql || "Unknown");
        }
        typeof nl.getDefaultProps == "function" && !nl.getDefaultProps.isReactClassApproved && A("getDefaultProps is only used on classic React.createClass definitions. Use a static property named `defaultProps` instead.");
      }
    }
    function br(D) {
      {
        for (var nl = Object.keys(D.props), gl = 0; gl < nl.length; gl++) {
          var _l = nl[gl];
          if (_l !== "children" && _l !== "key") {
            pe(D), A("Invalid prop `%s` supplied to `React.Fragment`. React.Fragment can only have `key` and `children` props.", _l), pe(null);
            break;
          }
        }
        D.ref !== null && (pe(D), A("Invalid attribute `ref` supplied to `React.Fragment`."), pe(null));
      }
    }
    function $i(D, nl, gl, _l, Ql, un) {
      {
        var zl = Y(D);
        if (!zl) {
          var kl = "";
          (D === void 0 || typeof D == "object" && D !== null && Object.keys(D).length === 0) && (kl += " You likely forgot to export your component from the file it's defined in, or you might have mixed up default and named imports.");
          var Xn = Ma();
          Xn ? kl += Xn : kl += gi();
          var Cn;
          D === null ? Cn = "null" : Zn(D) ? Cn = "array" : D !== void 0 && D.$$typeof === n ? (Cn = "<" + (ul(D.type) || "Unknown") + " />", kl = " Did you accidentally export a JSX literal instead of a component?") : Cn = typeof D, A("React.jsx: type is invalid -- expected a string (for built-in components) or a class/function (for composite components) but got: %s.%s", Cn, kl);
        }
        var Sn = ku(D, nl, gl, Ql, un);
        if (Sn == null)
          return Sn;
        if (zl) {
          var ou = nl.children;
          if (ou !== void 0)
            if (_l)
              if (Zn(ou)) {
                for (var Hu = 0; Hu < ou.length; Hu++)
                  yi(ou[Hu], D);
                Object.freeze && Object.freeze(ou);
              } else
                A("React.jsx: Static children should always be an array. You are likely explicitly calling React.jsxs or React.jsxDEV. Use the Babel transform instead.");
            else
              yi(ou, D);
        }
        return D === t ? br(Sn) : Ba(Sn), Sn;
      }
    }
    function yr(D, nl, gl) {
      return $i(D, nl, gl, !0);
    }
    function La(D, nl, gl) {
      return $i(D, nl, gl, !1);
    }
    var Ga = La, ja = yr;
    Mr.Fragment = t, Mr.jsx = Ga, Mr.jsxs = ja;
  }()), Mr;
}
 false ? 0 : bd.exports = Sb();
var y = bd.exports;
function D3(l) {
  var n, u, t = "";
  if (typeof l == "string" || typeof l == "number") t += l;
  else if (typeof l == "object") if (Array.isArray(l)) {
    var r = l.length;
    for (n = 0; n < r; n++) l[n] && (u = D3(l[n])) && (t && (t += " "), t += u);
  } else for (u in l) l[u] && (t && (t += " "), t += u);
  return t;
}
function Pb() {
  for (var l, n, u = 0, t = "", r = arguments.length; u < r; u++) (l = arguments[u]) && (n = D3(l)) && (t && (t += " "), t += n);
  return t;
}
var Mo = { exports: {} };
/**
 * @license
 * Lodash <https://lodash.com/>
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */
Mo.exports;
(function(l, n) {
  (function() {
    var u, t = "4.17.21", r = 200, o = "Unsupported core-js use. Try https://npms.io/search?q=ponyfill.", s = "Expected a function", d = "Invalid `variable` option passed into `_.template`", a = "__lodash_hash_undefined__", f = 500, p = "__lodash_placeholder__", g = 1, m = 2, v = 4, $ = 1, b = 2, E = 1, S = 2, A = 4, x = 8, I = 16, P = 32, O = 64, _ = 128, j = 256, z = 512, Y = 30, el = "...", U = 800, ul = 16, il = 1, rl = 2, tl = 3, sl = 1 / 0, ll = 9007199254740991, H = 17976931348623157e292, V = NaN, X = 4294967295, dl = X - 1, fl = X >>> 1, $l = [
      ["ary", _],
      ["bind", E],
      ["bindKey", S],
      ["curry", x],
      ["curryRight", I],
      ["flip", z],
      ["partial", P],
      ["partialRight", O],
      ["rearg", j]
    ], cl = "[object Arguments]", xl = "[object Array]", ol = "[object AsyncFunction]", ml = "[object Boolean]", Sl = "[object Date]", Ol = "[object DOMException]", Cl = "[object Error]", Q = "[object Function]", Xl = "[object GeneratorFunction]", Bl = "[object Map]", Kl = "[object Number]", fn = "[object Null]", dn = "[object Object]", Fn = "[object Promise]", sn = "[object Proxy]", gn = "[object RegExp]", _n = "[object Set]", Zn = "[object String]", ne = "[object Symbol]", _e = "[object Undefined]", Nu = "[object WeakMap]", ue = "[object WeakSet]", Kn = "[object ArrayBuffer]", mu = "[object DataView]", R = "[object Float32Array]", G = "[object Float64Array]", W = "[object Int8Array]", al = "[object Int16Array]", Pl = "[object Int32Array]", Fl = "[object Uint8Array]", on = "[object Uint8ClampedArray]", xn = "[object Uint16Array]", Dn = "[object Uint32Array]", ku = /\b__p \+= '';/g, at = /\b(__p \+=) '' \+/g, pi = /(__e\(.*?\)|\b__t\)) \+\n'';/g, pe = /&(?:amp|lt|gt|quot|#39);/g, Rt = /[&<>"']/g, vr = RegExp(pe.source), gi = RegExp(Rt.source), Ma = /<%-([\s\S]+?)%>/g, hi = /<%([\s\S]+?)%>/g, mi = /<%=([\s\S]+?)%>/g, bi = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, yi = /^\w*$/, Ba = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g, br = /[\\^$.*+?()[\]{}|]/g, $i = RegExp(br.source), yr = /^\s+/, La = /\s/, Ga = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/, ja = /\{\n\/\* \[wrapped with (.+)\] \*/, D = /,? & /, nl = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g, gl = /[()=,{}\[\]\/\s]/, _l = /\\(\\)?/g, Ql = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g, un = /\w*$/, zl = /^[-+]0x[0-9a-f]+$/i, kl = /^0b[01]+$/i, Xn = /^\[object .+?Constructor\]$/, Cn = /^0o[0-7]+$/i, Sn = /^(?:0|[1-9]\d*)$/, ou = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g, Hu = /($^)/, xi = /['\n\r\u2028\u2029\\]/g, au = "\\ud800-\\udfff", p9 = "\\u0300-\\u036f", g9 = "\\ufe20-\\ufe2f", h9 = "\\u20d0-\\u20ff", v0 = p9 + g9 + h9, b0 = "\\u2700-\\u27bf", y0 = "a-z\\xdf-\\xf6\\xf8-\\xff", m9 = "\\xac\\xb1\\xd7\\xf7", v9 = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf", b9 = "\\u2000-\\u206f", y9 = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000", $0 = "A-Z\\xc0-\\xd6\\xd8-\\xde", x0 = "\\ufe0e\\ufe0f", C0 = m9 + v9 + b9 + y9, Wa = "['’]", $9 = "[" + au + "]", w0 = "[" + C0 + "]", Ci = "[" + v0 + "]", I0 = "\\d+", x9 = "[" + b0 + "]", E0 = "[" + y0 + "]", A0 = "[^" + au + C0 + I0 + b0 + y0 + $0 + "]", Va = "\\ud83c[\\udffb-\\udfff]", C9 = "(?:" + Ci + "|" + Va + ")", S0 = "[^" + au + "]", ka = "(?:\\ud83c[\\udde6-\\uddff]){2}", Ha = "[\\ud800-\\udbff][\\udc00-\\udfff]", Ot = "[" + $0 + "]", P0 = "\\u200d", N0 = "(?:" + E0 + "|" + A0 + ")", w9 = "(?:" + Ot + "|" + A0 + ")", T0 = "(?:" + Wa + "(?:d|ll|m|re|s|t|ve))?", R0 = "(?:" + Wa + "(?:D|LL|M|RE|S|T|VE))?", O0 = C9 + "?", F0 = "[" + x0 + "]?", I9 = "(?:" + P0 + "(?:" + [S0, ka, Ha].join("|") + ")" + F0 + O0 + ")*", E9 = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])", A9 = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])", _0 = F0 + O0 + I9, S9 = "(?:" + [x9, ka, Ha].join("|") + ")" + _0, P9 = "(?:" + [S0 + Ci + "?", Ci, ka, Ha, $9].join("|") + ")", N9 = RegExp(Wa, "g"), T9 = RegExp(Ci, "g"), Za = RegExp(Va + "(?=" + Va + ")|" + P9 + _0, "g"), R9 = RegExp([
      Ot + "?" + E0 + "+" + T0 + "(?=" + [w0, Ot, "$"].join("|") + ")",
      w9 + "+" + R0 + "(?=" + [w0, Ot + N0, "$"].join("|") + ")",
      Ot + "?" + N0 + "+" + T0,
      Ot + "+" + R0,
      A9,
      E9,
      I0,
      S9
    ].join("|"), "g"), O9 = RegExp("[" + P0 + au + v0 + x0 + "]"), F9 = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/, _9 = [
      "Array",
      "Buffer",
      "DataView",
      "Date",
      "Error",
      "Float32Array",
      "Float64Array",
      "Function",
      "Int8Array",
      "Int16Array",
      "Int32Array",
      "Map",
      "Math",
      "Object",
      "Promise",
      "RegExp",
      "Set",
      "String",
      "Symbol",
      "TypeError",
      "Uint8Array",
      "Uint8ClampedArray",
      "Uint16Array",
      "Uint32Array",
      "WeakMap",
      "_",
      "clearTimeout",
      "isFinite",
      "parseInt",
      "setTimeout"
    ], D9 = -1, hn = {};
    hn[R] = hn[G] = hn[W] = hn[al] = hn[Pl] = hn[Fl] = hn[on] = hn[xn] = hn[Dn] = !0, hn[cl] = hn[xl] = hn[Kn] = hn[ml] = hn[mu] = hn[Sl] = hn[Cl] = hn[Q] = hn[Bl] = hn[Kl] = hn[dn] = hn[gn] = hn[_n] = hn[Zn] = hn[Nu] = !1;
    var pn = {};
    pn[cl] = pn[xl] = pn[Kn] = pn[mu] = pn[ml] = pn[Sl] = pn[R] = pn[G] = pn[W] = pn[al] = pn[Pl] = pn[Bl] = pn[Kl] = pn[dn] = pn[gn] = pn[_n] = pn[Zn] = pn[ne] = pn[Fl] = pn[on] = pn[xn] = pn[Dn] = !0, pn[Cl] = pn[Q] = pn[Nu] = !1;
    var M9 = {
      // Latin-1 Supplement block.
      À: "A",
      Á: "A",
      Â: "A",
      Ã: "A",
      Ä: "A",
      Å: "A",
      à: "a",
      á: "a",
      â: "a",
      ã: "a",
      ä: "a",
      å: "a",
      Ç: "C",
      ç: "c",
      Ð: "D",
      ð: "d",
      È: "E",
      É: "E",
      Ê: "E",
      Ë: "E",
      è: "e",
      é: "e",
      ê: "e",
      ë: "e",
      Ì: "I",
      Í: "I",
      Î: "I",
      Ï: "I",
      ì: "i",
      í: "i",
      î: "i",
      ï: "i",
      Ñ: "N",
      ñ: "n",
      Ò: "O",
      Ó: "O",
      Ô: "O",
      Õ: "O",
      Ö: "O",
      Ø: "O",
      ò: "o",
      ó: "o",
      ô: "o",
      õ: "o",
      ö: "o",
      ø: "o",
      Ù: "U",
      Ú: "U",
      Û: "U",
      Ü: "U",
      ù: "u",
      ú: "u",
      û: "u",
      ü: "u",
      Ý: "Y",
      ý: "y",
      ÿ: "y",
      Æ: "Ae",
      æ: "ae",
      Þ: "Th",
      þ: "th",
      ß: "ss",
      // Latin Extended-A block.
      Ā: "A",
      Ă: "A",
      Ą: "A",
      ā: "a",
      ă: "a",
      ą: "a",
      Ć: "C",
      Ĉ: "C",
      Ċ: "C",
      Č: "C",
      ć: "c",
      ĉ: "c",
      ċ: "c",
      č: "c",
      Ď: "D",
      Đ: "D",
      ď: "d",
      đ: "d",
      Ē: "E",
      Ĕ: "E",
      Ė: "E",
      Ę: "E",
      Ě: "E",
      ē: "e",
      ĕ: "e",
      ė: "e",
      ę: "e",
      ě: "e",
      Ĝ: "G",
      Ğ: "G",
      Ġ: "G",
      Ģ: "G",
      ĝ: "g",
      ğ: "g",
      ġ: "g",
      ģ: "g",
      Ĥ: "H",
      Ħ: "H",
      ĥ: "h",
      ħ: "h",
      Ĩ: "I",
      Ī: "I",
      Ĭ: "I",
      Į: "I",
      İ: "I",
      ĩ: "i",
      ī: "i",
      ĭ: "i",
      į: "i",
      ı: "i",
      Ĵ: "J",
      ĵ: "j",
      Ķ: "K",
      ķ: "k",
      ĸ: "k",
      Ĺ: "L",
      Ļ: "L",
      Ľ: "L",
      Ŀ: "L",
      Ł: "L",
      ĺ: "l",
      ļ: "l",
      ľ: "l",
      ŀ: "l",
      ł: "l",
      Ń: "N",
      Ņ: "N",
      Ň: "N",
      Ŋ: "N",
      ń: "n",
      ņ: "n",
      ň: "n",
      ŋ: "n",
      Ō: "O",
      Ŏ: "O",
      Ő: "O",
      ō: "o",
      ŏ: "o",
      ő: "o",
      Ŕ: "R",
      Ŗ: "R",
      Ř: "R",
      ŕ: "r",
      ŗ: "r",
      ř: "r",
      Ś: "S",
      Ŝ: "S",
      Ş: "S",
      Š: "S",
      ś: "s",
      ŝ: "s",
      ş: "s",
      š: "s",
      Ţ: "T",
      Ť: "T",
      Ŧ: "T",
      ţ: "t",
      ť: "t",
      ŧ: "t",
      Ũ: "U",
      Ū: "U",
      Ŭ: "U",
      Ů: "U",
      Ű: "U",
      Ų: "U",
      ũ: "u",
      ū: "u",
      ŭ: "u",
      ů: "u",
      ű: "u",
      ų: "u",
      Ŵ: "W",
      ŵ: "w",
      Ŷ: "Y",
      ŷ: "y",
      Ÿ: "Y",
      Ź: "Z",
      Ż: "Z",
      Ž: "Z",
      ź: "z",
      ż: "z",
      ž: "z",
      Ĳ: "IJ",
      ĳ: "ij",
      Œ: "Oe",
      œ: "oe",
      ŉ: "'n",
      ſ: "s"
    }, B9 = {
      "&": "&amp;",
      "<": "&lt;",
      ">": "&gt;",
      '"': "&quot;",
      "'": "&#39;"
    }, L9 = {
      "&amp;": "&",
      "&lt;": "<",
      "&gt;": ">",
      "&quot;": '"',
      "&#39;": "'"
    }, G9 = {
      "\\": "\\",
      "'": "'",
      "\n": "n",
      "\r": "r",
      "\u2028": "u2028",
      "\u2029": "u2029"
    }, j9 = parseFloat, W9 = parseInt, D0 = typeof Jn == "object" && Jn && Jn.Object === Object && Jn, V9 = typeof self == "object" && self && self.Object === Object && self, zn = D0 || V9 || Function("return this")(), Xa = n && !n.nodeType && n, st = Xa && !0 && l && !l.nodeType && l, M0 = st && st.exports === Xa, za = M0 && D0.process, Tu = function() {
      try {
        var B = st && st.require && st.require("util").types;
        return B || za && za.binding && za.binding("util");
      } catch {
      }
    }(), B0 = Tu && Tu.isArrayBuffer, L0 = Tu && Tu.isDate, G0 = Tu && Tu.isMap, j0 = Tu && Tu.isRegExp, W0 = Tu && Tu.isSet, V0 = Tu && Tu.isTypedArray;
    function vu(B, Z, k) {
      switch (k.length) {
        case 0:
          return B.call(Z);
        case 1:
          return B.call(Z, k[0]);
        case 2:
          return B.call(Z, k[0], k[1]);
        case 3:
          return B.call(Z, k[0], k[1], k[2]);
      }
      return B.apply(Z, k);
    }
    function k9(B, Z, k, vl) {
      for (var Dl = -1, ql = B == null ? 0 : B.length; ++Dl < ql; ) {
        var jn = B[Dl];
        Z(vl, jn, k(jn), B);
      }
      return vl;
    }
    function Ru(B, Z) {
      for (var k = -1, vl = B == null ? 0 : B.length; ++k < vl && Z(B[k], k, B) !== !1; )
        ;
      return B;
    }
    function H9(B, Z) {
      for (var k = B == null ? 0 : B.length; k-- && Z(B[k], k, B) !== !1; )
        ;
      return B;
    }
    function k0(B, Z) {
      for (var k = -1, vl = B == null ? 0 : B.length; ++k < vl; )
        if (!Z(B[k], k, B))
          return !1;
      return !0;
    }
    function De(B, Z) {
      for (var k = -1, vl = B == null ? 0 : B.length, Dl = 0, ql = []; ++k < vl; ) {
        var jn = B[k];
        Z(jn, k, B) && (ql[Dl++] = jn);
      }
      return ql;
    }
    function wi(B, Z) {
      var k = B == null ? 0 : B.length;
      return !!k && Ft(B, Z, 0) > -1;
    }
    function Ya(B, Z, k) {
      for (var vl = -1, Dl = B == null ? 0 : B.length; ++vl < Dl; )
        if (k(Z, B[vl]))
          return !0;
      return !1;
    }
    function $n(B, Z) {
      for (var k = -1, vl = B == null ? 0 : B.length, Dl = Array(vl); ++k < vl; )
        Dl[k] = Z(B[k], k, B);
      return Dl;
    }
    function Me(B, Z) {
      for (var k = -1, vl = Z.length, Dl = B.length; ++k < vl; )
        B[Dl + k] = Z[k];
      return B;
    }
    function Ua(B, Z, k, vl) {
      var Dl = -1, ql = B == null ? 0 : B.length;
      for (vl && ql && (k = B[++Dl]); ++Dl < ql; )
        k = Z(k, B[Dl], Dl, B);
      return k;
    }
    function Z9(B, Z, k, vl) {
      var Dl = B == null ? 0 : B.length;
      for (vl && Dl && (k = B[--Dl]); Dl--; )
        k = Z(k, B[Dl], Dl, B);
      return k;
    }
    function Ja(B, Z) {
      for (var k = -1, vl = B == null ? 0 : B.length; ++k < vl; )
        if (Z(B[k], k, B))
          return !0;
      return !1;
    }
    var X9 = Ka("length");
    function z9(B) {
      return B.split("");
    }
    function Y9(B) {
      return B.match(nl) || [];
    }
    function H0(B, Z, k) {
      var vl;
      return k(B, function(Dl, ql, jn) {
        if (Z(Dl, ql, jn))
          return vl = ql, !1;
      }), vl;
    }
    function Ii(B, Z, k, vl) {
      for (var Dl = B.length, ql = k + (vl ? 1 : -1); vl ? ql-- : ++ql < Dl; )
        if (Z(B[ql], ql, B))
          return ql;
      return -1;
    }
    function Ft(B, Z, k) {
      return Z === Z ? ih(B, Z, k) : Ii(B, Z0, k);
    }
    function U9(B, Z, k, vl) {
      for (var Dl = k - 1, ql = B.length; ++Dl < ql; )
        if (vl(B[Dl], Z))
          return Dl;
      return -1;
    }
    function Z0(B) {
      return B !== B;
    }
    function X0(B, Z) {
      var k = B == null ? 0 : B.length;
      return k ? qa(B, Z) / k : V;
    }
    function Ka(B) {
      return function(Z) {
        return Z == null ? u : Z[B];
      };
    }
    function Qa(B) {
      return function(Z) {
        return B == null ? u : B[Z];
      };
    }
    function z0(B, Z, k, vl, Dl) {
      return Dl(B, function(ql, jn, cn) {
        k = vl ? (vl = !1, ql) : Z(k, ql, jn, cn);
      }), k;
    }
    function J9(B, Z) {
      var k = B.length;
      for (B.sort(Z); k--; )
        B[k] = B[k].value;
      return B;
    }
    function qa(B, Z) {
      for (var k, vl = -1, Dl = B.length; ++vl < Dl; ) {
        var ql = Z(B[vl]);
        ql !== u && (k = k === u ? ql : k + ql);
      }
      return k;
    }
    function ls(B, Z) {
      for (var k = -1, vl = Array(B); ++k < B; )
        vl[k] = Z(k);
      return vl;
    }
    function K9(B, Z) {
      return $n(Z, function(k) {
        return [k, B[k]];
      });
    }
    function Y0(B) {
      return B && B.slice(0, Q0(B) + 1).replace(yr, "");
    }
    function bu(B) {
      return function(Z) {
        return B(Z);
      };
    }
    function ns(B, Z) {
      return $n(Z, function(k) {
        return B[k];
      });
    }
    function $r(B, Z) {
      return B.has(Z);
    }
    function U0(B, Z) {
      for (var k = -1, vl = B.length; ++k < vl && Ft(Z, B[k], 0) > -1; )
        ;
      return k;
    }
    function J0(B, Z) {
      for (var k = B.length; k-- && Ft(Z, B[k], 0) > -1; )
        ;
      return k;
    }
    function Q9(B, Z) {
      for (var k = B.length, vl = 0; k--; )
        B[k] === Z && ++vl;
      return vl;
    }
    var q9 = Qa(M9), lh = Qa(B9);
    function nh(B) {
      return "\\" + G9[B];
    }
    function uh(B, Z) {
      return B == null ? u : B[Z];
    }
    function _t(B) {
      return O9.test(B);
    }
    function eh(B) {
      return F9.test(B);
    }
    function th(B) {
      for (var Z, k = []; !(Z = B.next()).done; )
        k.push(Z.value);
      return k;
    }
    function us(B) {
      var Z = -1, k = Array(B.size);
      return B.forEach(function(vl, Dl) {
        k[++Z] = [Dl, vl];
      }), k;
    }
    function K0(B, Z) {
      return function(k) {
        return B(Z(k));
      };
    }
    function Be(B, Z) {
      for (var k = -1, vl = B.length, Dl = 0, ql = []; ++k < vl; ) {
        var jn = B[k];
        (jn === Z || jn === p) && (B[k] = p, ql[Dl++] = k);
      }
      return ql;
    }
    function Ei(B) {
      var Z = -1, k = Array(B.size);
      return B.forEach(function(vl) {
        k[++Z] = vl;
      }), k;
    }
    function rh(B) {
      var Z = -1, k = Array(B.size);
      return B.forEach(function(vl) {
        k[++Z] = [vl, vl];
      }), k;
    }
    function ih(B, Z, k) {
      for (var vl = k - 1, Dl = B.length; ++vl < Dl; )
        if (B[vl] === Z)
          return vl;
      return -1;
    }
    function oh(B, Z, k) {
      for (var vl = k + 1; vl--; )
        if (B[vl] === Z)
          return vl;
      return vl;
    }
    function Dt(B) {
      return _t(B) ? sh(B) : X9(B);
    }
    function Zu(B) {
      return _t(B) ? dh(B) : z9(B);
    }
    function Q0(B) {
      for (var Z = B.length; Z-- && La.test(B.charAt(Z)); )
        ;
      return Z;
    }
    var ah = Qa(L9);
    function sh(B) {
      for (var Z = Za.lastIndex = 0; Za.test(B); )
        ++Z;
      return Z;
    }
    function dh(B) {
      return B.match(Za) || [];
    }
    function ch(B) {
      return B.match(R9) || [];
    }
    var fh = function B(Z) {
      Z = Z == null ? zn : Mt.defaults(zn.Object(), Z, Mt.pick(zn, _9));
      var k = Z.Array, vl = Z.Date, Dl = Z.Error, ql = Z.Function, jn = Z.Math, cn = Z.Object, es = Z.RegExp, ph = Z.String, Ou = Z.TypeError, Ai = k.prototype, gh = ql.prototype, Bt = cn.prototype, Si = Z["__core-js_shared__"], Pi = gh.toString, an = Bt.hasOwnProperty, hh = 0, q0 = function() {
        var e = /[^.]+$/.exec(Si && Si.keys && Si.keys.IE_PROTO || "");
        return e ? "Symbol(src)_1." + e : "";
      }(), Ni = Bt.toString, mh = Pi.call(cn), vh = zn._, bh = es(
        "^" + Pi.call(an).replace(br, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
      ), Ti = M0 ? Z.Buffer : u, Le = Z.Symbol, Ri = Z.Uint8Array, l1 = Ti ? Ti.allocUnsafe : u, Oi = K0(cn.getPrototypeOf, cn), n1 = cn.create, u1 = Bt.propertyIsEnumerable, Fi = Ai.splice, e1 = Le ? Le.isConcatSpreadable : u, xr = Le ? Le.iterator : u, dt = Le ? Le.toStringTag : u, _i = function() {
        try {
          var e = ht(cn, "defineProperty");
          return e({}, "", {}), e;
        } catch {
        }
      }(), yh = Z.clearTimeout !== zn.clearTimeout && Z.clearTimeout, $h = vl && vl.now !== zn.Date.now && vl.now, xh = Z.setTimeout !== zn.setTimeout && Z.setTimeout, Di = jn.ceil, Mi = jn.floor, ts = cn.getOwnPropertySymbols, Ch = Ti ? Ti.isBuffer : u, t1 = Z.isFinite, wh = Ai.join, Ih = K0(cn.keys, cn), Wn = jn.max, Qn = jn.min, Eh = vl.now, Ah = Z.parseInt, r1 = jn.random, Sh = Ai.reverse, rs = ht(Z, "DataView"), Cr = ht(Z, "Map"), is = ht(Z, "Promise"), Lt = ht(Z, "Set"), wr = ht(Z, "WeakMap"), Ir = ht(cn, "create"), Bi = wr && new wr(), Gt = {}, Ph = mt(rs), Nh = mt(Cr), Th = mt(is), Rh = mt(Lt), Oh = mt(wr), Li = Le ? Le.prototype : u, Er = Li ? Li.valueOf : u, i1 = Li ? Li.toString : u;
      function N(e) {
        if (Pn(e) && !Ml(e) && !(e instanceof Yl)) {
          if (e instanceof Fu)
            return e;
          if (an.call(e, "__wrapped__"))
            return o2(e);
        }
        return new Fu(e);
      }
      var jt = /* @__PURE__ */ function() {
        function e() {
        }
        return function(i) {
          if (!wn(i))
            return {};
          if (n1)
            return n1(i);
          e.prototype = i;
          var c = new e();
          return e.prototype = u, c;
        };
      }();
      function Gi() {
      }
      function Fu(e, i) {
        this.__wrapped__ = e, this.__actions__ = [], this.__chain__ = !!i, this.__index__ = 0, this.__values__ = u;
      }
      N.templateSettings = {
        /**
         * Used to detect `data` property values to be HTML-escaped.
         *
         * @memberOf _.templateSettings
         * @type {RegExp}
         */
        escape: Ma,
        /**
         * Used to detect code to be evaluated.
         *
         * @memberOf _.templateSettings
         * @type {RegExp}
         */
        evaluate: hi,
        /**
         * Used to detect `data` property values to inject.
         *
         * @memberOf _.templateSettings
         * @type {RegExp}
         */
        interpolate: mi,
        /**
         * Used to reference the data object in the template text.
         *
         * @memberOf _.templateSettings
         * @type {string}
         */
        variable: "",
        /**
         * Used to import variables into the compiled template.
         *
         * @memberOf _.templateSettings
         * @type {Object}
         */
        imports: {
          /**
           * A reference to the `lodash` function.
           *
           * @memberOf _.templateSettings.imports
           * @type {Function}
           */
          _: N
        }
      }, N.prototype = Gi.prototype, N.prototype.constructor = N, Fu.prototype = jt(Gi.prototype), Fu.prototype.constructor = Fu;
      function Yl(e) {
        this.__wrapped__ = e, this.__actions__ = [], this.__dir__ = 1, this.__filtered__ = !1, this.__iteratees__ = [], this.__takeCount__ = X, this.__views__ = [];
      }
      function Fh() {
        var e = new Yl(this.__wrapped__);
        return e.__actions__ = su(this.__actions__), e.__dir__ = this.__dir__, e.__filtered__ = this.__filtered__, e.__iteratees__ = su(this.__iteratees__), e.__takeCount__ = this.__takeCount__, e.__views__ = su(this.__views__), e;
      }
      function _h() {
        if (this.__filtered__) {
          var e = new Yl(this);
          e.__dir__ = -1, e.__filtered__ = !0;
        } else
          e = this.clone(), e.__dir__ *= -1;
        return e;
      }
      function Dh() {
        var e = this.__wrapped__.value(), i = this.__dir__, c = Ml(e), h = i < 0, w = c ? e.length : 0, T = z6(0, w, this.__views__), F = T.start, M = T.end, L = M - F, J = h ? M : F - 1, K = this.__iteratees__, q = K.length, pl = 0, bl = Qn(L, this.__takeCount__);
        if (!c || !h && w == L && bl == L)
          return T1(e, this.__actions__);
        var Nl = [];
        l:
          for (; L-- && pl < bl; ) {
            J += i;
            for (var jl = -1, Tl = e[J]; ++jl < q; ) {
              var Zl = K[jl], Jl = Zl.iteratee, xu = Zl.type, ru = Jl(Tl);
              if (xu == rl)
                Tl = ru;
              else if (!ru) {
                if (xu == il)
                  continue l;
                break l;
              }
            }
            Nl[pl++] = Tl;
          }
        return Nl;
      }
      Yl.prototype = jt(Gi.prototype), Yl.prototype.constructor = Yl;
      function ct(e) {
        var i = -1, c = e == null ? 0 : e.length;
        for (this.clear(); ++i < c; ) {
          var h = e[i];
          this.set(h[0], h[1]);
        }
      }
      function Mh() {
        this.__data__ = Ir ? Ir(null) : {}, this.size = 0;
      }
      function Bh(e) {
        var i = this.has(e) && delete this.__data__[e];
        return this.size -= i ? 1 : 0, i;
      }
      function Lh(e) {
        var i = this.__data__;
        if (Ir) {
          var c = i[e];
          return c === a ? u : c;
        }
        return an.call(i, e) ? i[e] : u;
      }
      function Gh(e) {
        var i = this.__data__;
        return Ir ? i[e] !== u : an.call(i, e);
      }
      function jh(e, i) {
        var c = this.__data__;
        return this.size += this.has(e) ? 0 : 1, c[e] = Ir && i === u ? a : i, this;
      }
      ct.prototype.clear = Mh, ct.prototype.delete = Bh, ct.prototype.get = Lh, ct.prototype.has = Gh, ct.prototype.set = jh;
      function ge(e) {
        var i = -1, c = e == null ? 0 : e.length;
        for (this.clear(); ++i < c; ) {
          var h = e[i];
          this.set(h[0], h[1]);
        }
      }
      function Wh() {
        this.__data__ = [], this.size = 0;
      }
      function Vh(e) {
        var i = this.__data__, c = ji(i, e);
        if (c < 0)
          return !1;
        var h = i.length - 1;
        return c == h ? i.pop() : Fi.call(i, c, 1), --this.size, !0;
      }
      function kh(e) {
        var i = this.__data__, c = ji(i, e);
        return c < 0 ? u : i[c][1];
      }
      function Hh(e) {
        return ji(this.__data__, e) > -1;
      }
      function Zh(e, i) {
        var c = this.__data__, h = ji(c, e);
        return h < 0 ? (++this.size, c.push([e, i])) : c[h][1] = i, this;
      }
      ge.prototype.clear = Wh, ge.prototype.delete = Vh, ge.prototype.get = kh, ge.prototype.has = Hh, ge.prototype.set = Zh;
      function he(e) {
        var i = -1, c = e == null ? 0 : e.length;
        for (this.clear(); ++i < c; ) {
          var h = e[i];
          this.set(h[0], h[1]);
        }
      }
      function Xh() {
        this.size = 0, this.__data__ = {
          hash: new ct(),
          map: new (Cr || ge)(),
          string: new ct()
        };
      }
      function zh(e) {
        var i = Qi(this, e).delete(e);
        return this.size -= i ? 1 : 0, i;
      }
      function Yh(e) {
        return Qi(this, e).get(e);
      }
      function Uh(e) {
        return Qi(this, e).has(e);
      }
      function Jh(e, i) {
        var c = Qi(this, e), h = c.size;
        return c.set(e, i), this.size += c.size == h ? 0 : 1, this;
      }
      he.prototype.clear = Xh, he.prototype.delete = zh, he.prototype.get = Yh, he.prototype.has = Uh, he.prototype.set = Jh;
      function ft(e) {
        var i = -1, c = e == null ? 0 : e.length;
        for (this.__data__ = new he(); ++i < c; )
          this.add(e[i]);
      }
      function Kh(e) {
        return this.__data__.set(e, a), this;
      }
      function Qh(e) {
        return this.__data__.has(e);
      }
      ft.prototype.add = ft.prototype.push = Kh, ft.prototype.has = Qh;
      function Xu(e) {
        var i = this.__data__ = new ge(e);
        this.size = i.size;
      }
      function qh() {
        this.__data__ = new ge(), this.size = 0;
      }
      function l6(e) {
        var i = this.__data__, c = i.delete(e);
        return this.size = i.size, c;
      }
      function n6(e) {
        return this.__data__.get(e);
      }
      function u6(e) {
        return this.__data__.has(e);
      }
      function e6(e, i) {
        var c = this.__data__;
        if (c instanceof ge) {
          var h = c.__data__;
          if (!Cr || h.length < r - 1)
            return h.push([e, i]), this.size = ++c.size, this;
          c = this.__data__ = new he(h);
        }
        return c.set(e, i), this.size = c.size, this;
      }
      Xu.prototype.clear = qh, Xu.prototype.delete = l6, Xu.prototype.get = n6, Xu.prototype.has = u6, Xu.prototype.set = e6;
      function o1(e, i) {
        var c = Ml(e), h = !c && vt(e), w = !c && !h && ke(e), T = !c && !h && !w && Ht(e), F = c || h || w || T, M = F ? ls(e.length, ph) : [], L = M.length;
        for (var J in e)
          (i || an.call(e, J)) && !(F && // Safari 9 has enumerable `arguments.length` in strict mode.
          (J == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
          w && (J == "offset" || J == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
          T && (J == "buffer" || J == "byteLength" || J == "byteOffset") || // Skip index properties.
          ye(J, L))) && M.push(J);
        return M;
      }
      function a1(e) {
        var i = e.length;
        return i ? e[vs(0, i - 1)] : u;
      }
      function t6(e, i) {
        return qi(su(e), pt(i, 0, e.length));
      }
      function r6(e) {
        return qi(su(e));
      }
      function os(e, i, c) {
        (c !== u && !zu(e[i], c) || c === u && !(i in e)) && me(e, i, c);
      }
      function Ar(e, i, c) {
        var h = e[i];
        (!(an.call(e, i) && zu(h, c)) || c === u && !(i in e)) && me(e, i, c);
      }
      function ji(e, i) {
        for (var c = e.length; c--; )
          if (zu(e[c][0], i))
            return c;
        return -1;
      }
      function i6(e, i, c, h) {
        return Ge(e, function(w, T, F) {
          i(h, w, c(w), F);
        }), h;
      }
      function s1(e, i) {
        return e && te(i, Vn(i), e);
      }
      function o6(e, i) {
        return e && te(i, cu(i), e);
      }
      function me(e, i, c) {
        i == "__proto__" && _i ? _i(e, i, {
          configurable: !0,
          enumerable: !0,
          value: c,
          writable: !0
        }) : e[i] = c;
      }
      function as(e, i) {
        for (var c = -1, h = i.length, w = k(h), T = e == null; ++c < h; )
          w[c] = T ? u : Vs(e, i[c]);
        return w;
      }
      function pt(e, i, c) {
        return e === e && (c !== u && (e = e <= c ? e : c), i !== u && (e = e >= i ? e : i)), e;
      }
      function _u(e, i, c, h, w, T) {
        var F, M = i & g, L = i & m, J = i & v;
        if (c && (F = w ? c(e, h, w, T) : c(e)), F !== u)
          return F;
        if (!wn(e))
          return e;
        var K = Ml(e);
        if (K) {
          if (F = U6(e), !M)
            return su(e, F);
        } else {
          var q = qn(e), pl = q == Q || q == Xl;
          if (ke(e))
            return F1(e, M);
          if (q == dn || q == cl || pl && !w) {
            if (F = L || pl ? {} : Q1(e), !M)
              return L ? L6(e, o6(F, e)) : B6(e, s1(F, e));
          } else {
            if (!pn[q])
              return w ? e : {};
            F = J6(e, q, M);
          }
        }
        T || (T = new Xu());
        var bl = T.get(e);
        if (bl)
          return bl;
        T.set(e, F), S2(e) ? e.forEach(function(Tl) {
          F.add(_u(Tl, i, c, Tl, e, T));
        }) : E2(e) && e.forEach(function(Tl, Zl) {
          F.set(Zl, _u(Tl, i, c, Zl, e, T));
        });
        var Nl = J ? L ? Ps : Ss : L ? cu : Vn, jl = K ? u : Nl(e);
        return Ru(jl || e, function(Tl, Zl) {
          jl && (Zl = Tl, Tl = e[Zl]), Ar(F, Zl, _u(Tl, i, c, Zl, e, T));
        }), F;
      }
      function a6(e) {
        var i = Vn(e);
        return function(c) {
          return d1(c, e, i);
        };
      }
      function d1(e, i, c) {
        var h = c.length;
        if (e == null)
          return !h;
        for (e = cn(e); h--; ) {
          var w = c[h], T = i[w], F = e[w];
          if (F === u && !(w in e) || !T(F))
            return !1;
        }
        return !0;
      }
      function c1(e, i, c) {
        if (typeof e != "function")
          throw new Ou(s);
        return Fr(function() {
          e.apply(u, c);
        }, i);
      }
      function Sr(e, i, c, h) {
        var w = -1, T = wi, F = !0, M = e.length, L = [], J = i.length;
        if (!M)
          return L;
        c && (i = $n(i, bu(c))), h ? (T = Ya, F = !1) : i.length >= r && (T = $r, F = !1, i = new ft(i));
        l:
          for (; ++w < M; ) {
            var K = e[w], q = c == null ? K : c(K);
            if (K = h || K !== 0 ? K : 0, F && q === q) {
              for (var pl = J; pl--; )
                if (i[pl] === q)
                  continue l;
              L.push(K);
            } else T(i, q, h) || L.push(K);
          }
        return L;
      }
      var Ge = L1(ee), f1 = L1(ds, !0);
      function s6(e, i) {
        var c = !0;
        return Ge(e, function(h, w, T) {
          return c = !!i(h, w, T), c;
        }), c;
      }
      function Wi(e, i, c) {
        for (var h = -1, w = e.length; ++h < w; ) {
          var T = e[h], F = i(T);
          if (F != null && (M === u ? F === F && !$u(F) : c(F, M)))
            var M = F, L = T;
        }
        return L;
      }
      function d6(e, i, c, h) {
        var w = e.length;
        for (c = Ll(c), c < 0 && (c = -c > w ? 0 : w + c), h = h === u || h > w ? w : Ll(h), h < 0 && (h += w), h = c > h ? 0 : N2(h); c < h; )
          e[c++] = i;
        return e;
      }
      function p1(e, i) {
        var c = [];
        return Ge(e, function(h, w, T) {
          i(h, w, T) && c.push(h);
        }), c;
      }
      function Yn(e, i, c, h, w) {
        var T = -1, F = e.length;
        for (c || (c = Q6), w || (w = []); ++T < F; ) {
          var M = e[T];
          i > 0 && c(M) ? i > 1 ? Yn(M, i - 1, c, h, w) : Me(w, M) : h || (w[w.length] = M);
        }
        return w;
      }
      var ss = G1(), g1 = G1(!0);
      function ee(e, i) {
        return e && ss(e, i, Vn);
      }
      function ds(e, i) {
        return e && g1(e, i, Vn);
      }
      function Vi(e, i) {
        return De(i, function(c) {
          return $e(e[c]);
        });
      }
      function gt(e, i) {
        i = We(i, e);
        for (var c = 0, h = i.length; e != null && c < h; )
          e = e[re(i[c++])];
        return c && c == h ? e : u;
      }
      function h1(e, i, c) {
        var h = i(e);
        return Ml(e) ? h : Me(h, c(e));
      }
      function eu(e) {
        return e == null ? e === u ? _e : fn : dt && dt in cn(e) ? X6(e) : rm(e);
      }
      function cs(e, i) {
        return e > i;
      }
      function c6(e, i) {
        return e != null && an.call(e, i);
      }
      function f6(e, i) {
        return e != null && i in cn(e);
      }
      function p6(e, i, c) {
        return e >= Qn(i, c) && e < Wn(i, c);
      }
      function fs(e, i, c) {
        for (var h = c ? Ya : wi, w = e[0].length, T = e.length, F = T, M = k(T), L = 1 / 0, J = []; F--; ) {
          var K = e[F];
          F && i && (K = $n(K, bu(i))), L = Qn(K.length, L), M[F] = !c && (i || w >= 120 && K.length >= 120) ? new ft(F && K) : u;
        }
        K = e[0];
        var q = -1, pl = M[0];
        l:
          for (; ++q < w && J.length < L; ) {
            var bl = K[q], Nl = i ? i(bl) : bl;
            if (bl = c || bl !== 0 ? bl : 0, !(pl ? $r(pl, Nl) : h(J, Nl, c))) {
              for (F = T; --F; ) {
                var jl = M[F];
                if (!(jl ? $r(jl, Nl) : h(e[F], Nl, c)))
                  continue l;
              }
              pl && pl.push(Nl), J.push(bl);
            }
          }
        return J;
      }
      function g6(e, i, c, h) {
        return ee(e, function(w, T, F) {
          i(h, c(w), T, F);
        }), h;
      }
      function Pr(e, i, c) {
        i = We(i, e), e = u2(e, i);
        var h = e == null ? e : e[re(Mu(i))];
        return h == null ? u : vu(h, e, c);
      }
      function m1(e) {
        return Pn(e) && eu(e) == cl;
      }
      function h6(e) {
        return Pn(e) && eu(e) == Kn;
      }
      function m6(e) {
        return Pn(e) && eu(e) == Sl;
      }
      function Nr(e, i, c, h, w) {
        return e === i ? !0 : e == null || i == null || !Pn(e) && !Pn(i) ? e !== e && i !== i : v6(e, i, c, h, Nr, w);
      }
      function v6(e, i, c, h, w, T) {
        var F = Ml(e), M = Ml(i), L = F ? xl : qn(e), J = M ? xl : qn(i);
        L = L == cl ? dn : L, J = J == cl ? dn : J;
        var K = L == dn, q = J == dn, pl = L == J;
        if (pl && ke(e)) {
          if (!ke(i))
            return !1;
          F = !0, K = !1;
        }
        if (pl && !K)
          return T || (T = new Xu()), F || Ht(e) ? U1(e, i, c, h, w, T) : H6(e, i, L, c, h, w, T);
        if (!(c & $)) {
          var bl = K && an.call(e, "__wrapped__"), Nl = q && an.call(i, "__wrapped__");
          if (bl || Nl) {
            var jl = bl ? e.value() : e, Tl = Nl ? i.value() : i;
            return T || (T = new Xu()), w(jl, Tl, c, h, T);
          }
        }
        return pl ? (T || (T = new Xu()), Z6(e, i, c, h, w, T)) : !1;
      }
      function b6(e) {
        return Pn(e) && qn(e) == Bl;
      }
      function ps(e, i, c, h) {
        var w = c.length, T = w, F = !h;
        if (e == null)
          return !T;
        for (e = cn(e); w--; ) {
          var M = c[w];
          if (F && M[2] ? M[1] !== e[M[0]] : !(M[0] in e))
            return !1;
        }
        for (; ++w < T; ) {
          M = c[w];
          var L = M[0], J = e[L], K = M[1];
          if (F && M[2]) {
            if (J === u && !(L in e))
              return !1;
          } else {
            var q = new Xu();
            if (h)
              var pl = h(J, K, L, e, i, q);
            if (!(pl === u ? Nr(K, J, $ | b, h, q) : pl))
              return !1;
          }
        }
        return !0;
      }
      function v1(e) {
        if (!wn(e) || lm(e))
          return !1;
        var i = $e(e) ? bh : Xn;
        return i.test(mt(e));
      }
      function y6(e) {
        return Pn(e) && eu(e) == gn;
      }
      function $6(e) {
        return Pn(e) && qn(e) == _n;
      }
      function x6(e) {
        return Pn(e) && ro(e.length) && !!hn[eu(e)];
      }
      function b1(e) {
        return typeof e == "function" ? e : e == null ? fu : typeof e == "object" ? Ml(e) ? x1(e[0], e[1]) : $1(e) : j2(e);
      }
      function gs(e) {
        if (!Or(e))
          return Ih(e);
        var i = [];
        for (var c in cn(e))
          an.call(e, c) && c != "constructor" && i.push(c);
        return i;
      }
      function C6(e) {
        if (!wn(e))
          return tm(e);
        var i = Or(e), c = [];
        for (var h in e)
          h == "constructor" && (i || !an.call(e, h)) || c.push(h);
        return c;
      }
      function hs(e, i) {
        return e < i;
      }
      function y1(e, i) {
        var c = -1, h = du(e) ? k(e.length) : [];
        return Ge(e, function(w, T, F) {
          h[++c] = i(w, T, F);
        }), h;
      }
      function $1(e) {
        var i = Ts(e);
        return i.length == 1 && i[0][2] ? l2(i[0][0], i[0][1]) : function(c) {
          return c === e || ps(c, e, i);
        };
      }
      function x1(e, i) {
        return Os(e) && q1(i) ? l2(re(e), i) : function(c) {
          var h = Vs(c, e);
          return h === u && h === i ? ks(c, e) : Nr(i, h, $ | b);
        };
      }
      function ki(e, i, c, h, w) {
        e !== i && ss(i, function(T, F) {
          if (w || (w = new Xu()), wn(T))
            w6(e, i, F, c, ki, h, w);
          else {
            var M = h ? h(_s(e, F), T, F + "", e, i, w) : u;
            M === u && (M = T), os(e, F, M);
          }
        }, cu);
      }
      function w6(e, i, c, h, w, T, F) {
        var M = _s(e, c), L = _s(i, c), J = F.get(L);
        if (J) {
          os(e, c, J);
          return;
        }
        var K = T ? T(M, L, c + "", e, i, F) : u, q = K === u;
        if (q) {
          var pl = Ml(L), bl = !pl && ke(L), Nl = !pl && !bl && Ht(L);
          K = L, pl || bl || Nl ? Ml(M) ? K = M : Tn(M) ? K = su(M) : bl ? (q = !1, K = F1(L, !0)) : Nl ? (q = !1, K = _1(L, !0)) : K = [] : _r(L) || vt(L) ? (K = M, vt(M) ? K = T2(M) : (!wn(M) || $e(M)) && (K = Q1(L))) : q = !1;
        }
        q && (F.set(L, K), w(K, L, h, T, F), F.delete(L)), os(e, c, K);
      }
      function C1(e, i) {
        var c = e.length;
        if (c)
          return i += i < 0 ? c : 0, ye(i, c) ? e[i] : u;
      }
      function w1(e, i, c) {
        i.length ? i = $n(i, function(T) {
          return Ml(T) ? function(F) {
            return gt(F, T.length === 1 ? T[0] : T);
          } : T;
        }) : i = [fu];
        var h = -1;
        i = $n(i, bu(Al()));
        var w = y1(e, function(T, F, M) {
          var L = $n(i, function(J) {
            return J(T);
          });
          return { criteria: L, index: ++h, value: T };
        });
        return J9(w, function(T, F) {
          return M6(T, F, c);
        });
      }
      function I6(e, i) {
        return I1(e, i, function(c, h) {
          return ks(e, h);
        });
      }
      function I1(e, i, c) {
        for (var h = -1, w = i.length, T = {}; ++h < w; ) {
          var F = i[h], M = gt(e, F);
          c(M, F) && Tr(T, We(F, e), M);
        }
        return T;
      }
      function E6(e) {
        return function(i) {
          return gt(i, e);
        };
      }
      function ms(e, i, c, h) {
        var w = h ? U9 : Ft, T = -1, F = i.length, M = e;
        for (e === i && (i = su(i)), c && (M = $n(e, bu(c))); ++T < F; )
          for (var L = 0, J = i[T], K = c ? c(J) : J; (L = w(M, K, L, h)) > -1; )
            M !== e && Fi.call(M, L, 1), Fi.call(e, L, 1);
        return e;
      }
      function E1(e, i) {
        for (var c = e ? i.length : 0, h = c - 1; c--; ) {
          var w = i[c];
          if (c == h || w !== T) {
            var T = w;
            ye(w) ? Fi.call(e, w, 1) : $s(e, w);
          }
        }
        return e;
      }
      function vs(e, i) {
        return e + Mi(r1() * (i - e + 1));
      }
      function A6(e, i, c, h) {
        for (var w = -1, T = Wn(Di((i - e) / (c || 1)), 0), F = k(T); T--; )
          F[h ? T : ++w] = e, e += c;
        return F;
      }
      function bs(e, i) {
        var c = "";
        if (!e || i < 1 || i > ll)
          return c;
        do
          i % 2 && (c += e), i = Mi(i / 2), i && (e += e);
        while (i);
        return c;
      }
      function Wl(e, i) {
        return Ds(n2(e, i, fu), e + "");
      }
      function S6(e) {
        return a1(Zt(e));
      }
      function P6(e, i) {
        var c = Zt(e);
        return qi(c, pt(i, 0, c.length));
      }
      function Tr(e, i, c, h) {
        if (!wn(e))
          return e;
        i = We(i, e);
        for (var w = -1, T = i.length, F = T - 1, M = e; M != null && ++w < T; ) {
          var L = re(i[w]), J = c;
          if (L === "__proto__" || L === "constructor" || L === "prototype")
            return e;
          if (w != F) {
            var K = M[L];
            J = h ? h(K, L, M) : u, J === u && (J = wn(K) ? K : ye(i[w + 1]) ? [] : {});
          }
          Ar(M, L, J), M = M[L];
        }
        return e;
      }
      var A1 = Bi ? function(e, i) {
        return Bi.set(e, i), e;
      } : fu, N6 = _i ? function(e, i) {
        return _i(e, "toString", {
          configurable: !0,
          enumerable: !1,
          value: Zs(i),
          writable: !0
        });
      } : fu;
      function T6(e) {
        return qi(Zt(e));
      }
      function Du(e, i, c) {
        var h = -1, w = e.length;
        i < 0 && (i = -i > w ? 0 : w + i), c = c > w ? w : c, c < 0 && (c += w), w = i > c ? 0 : c - i >>> 0, i >>>= 0;
        for (var T = k(w); ++h < w; )
          T[h] = e[h + i];
        return T;
      }
      function R6(e, i) {
        var c;
        return Ge(e, function(h, w, T) {
          return c = i(h, w, T), !c;
        }), !!c;
      }
      function Hi(e, i, c) {
        var h = 0, w = e == null ? h : e.length;
        if (typeof i == "number" && i === i && w <= fl) {
          for (; h < w; ) {
            var T = h + w >>> 1, F = e[T];
            F !== null && !$u(F) && (c ? F <= i : F < i) ? h = T + 1 : w = T;
          }
          return w;
        }
        return ys(e, i, fu, c);
      }
      function ys(e, i, c, h) {
        var w = 0, T = e == null ? 0 : e.length;
        if (T === 0)
          return 0;
        i = c(i);
        for (var F = i !== i, M = i === null, L = $u(i), J = i === u; w < T; ) {
          var K = Mi((w + T) / 2), q = c(e[K]), pl = q !== u, bl = q === null, Nl = q === q, jl = $u(q);
          if (F)
            var Tl = h || Nl;
          else J ? Tl = Nl && (h || pl) : M ? Tl = Nl && pl && (h || !bl) : L ? Tl = Nl && pl && !bl && (h || !jl) : bl || jl ? Tl = !1 : Tl = h ? q <= i : q < i;
          Tl ? w = K + 1 : T = K;
        }
        return Qn(T, dl);
      }
      function S1(e, i) {
        for (var c = -1, h = e.length, w = 0, T = []; ++c < h; ) {
          var F = e[c], M = i ? i(F) : F;
          if (!c || !zu(M, L)) {
            var L = M;
            T[w++] = F === 0 ? 0 : F;
          }
        }
        return T;
      }
      function P1(e) {
        return typeof e == "number" ? e : $u(e) ? V : +e;
      }
      function yu(e) {
        if (typeof e == "string")
          return e;
        if (Ml(e))
          return $n(e, yu) + "";
        if ($u(e))
          return i1 ? i1.call(e) : "";
        var i = e + "";
        return i == "0" && 1 / e == -sl ? "-0" : i;
      }
      function je(e, i, c) {
        var h = -1, w = wi, T = e.length, F = !0, M = [], L = M;
        if (c)
          F = !1, w = Ya;
        else if (T >= r) {
          var J = i ? null : V6(e);
          if (J)
            return Ei(J);
          F = !1, w = $r, L = new ft();
        } else
          L = i ? [] : M;
        l:
          for (; ++h < T; ) {
            var K = e[h], q = i ? i(K) : K;
            if (K = c || K !== 0 ? K : 0, F && q === q) {
              for (var pl = L.length; pl--; )
                if (L[pl] === q)
                  continue l;
              i && L.push(q), M.push(K);
            } else w(L, q, c) || (L !== M && L.push(q), M.push(K));
          }
        return M;
      }
      function $s(e, i) {
        return i = We(i, e), e = u2(e, i), e == null || delete e[re(Mu(i))];
      }
      function N1(e, i, c, h) {
        return Tr(e, i, c(gt(e, i)), h);
      }
      function Zi(e, i, c, h) {
        for (var w = e.length, T = h ? w : -1; (h ? T-- : ++T < w) && i(e[T], T, e); )
          ;
        return c ? Du(e, h ? 0 : T, h ? T + 1 : w) : Du(e, h ? T + 1 : 0, h ? w : T);
      }
      function T1(e, i) {
        var c = e;
        return c instanceof Yl && (c = c.value()), Ua(i, function(h, w) {
          return w.func.apply(w.thisArg, Me([h], w.args));
        }, c);
      }
      function xs(e, i, c) {
        var h = e.length;
        if (h < 2)
          return h ? je(e[0]) : [];
        for (var w = -1, T = k(h); ++w < h; )
          for (var F = e[w], M = -1; ++M < h; )
            M != w && (T[w] = Sr(T[w] || F, e[M], i, c));
        return je(Yn(T, 1), i, c);
      }
      function R1(e, i, c) {
        for (var h = -1, w = e.length, T = i.length, F = {}; ++h < w; ) {
          var M = h < T ? i[h] : u;
          c(F, e[h], M);
        }
        return F;
      }
      function Cs(e) {
        return Tn(e) ? e : [];
      }
      function ws(e) {
        return typeof e == "function" ? e : fu;
      }
      function We(e, i) {
        return Ml(e) ? e : Os(e, i) ? [e] : i2(en(e));
      }
      var O6 = Wl;
      function Ve(e, i, c) {
        var h = e.length;
        return c = c === u ? h : c, !i && c >= h ? e : Du(e, i, c);
      }
      var O1 = yh || function(e) {
        return zn.clearTimeout(e);
      };
      function F1(e, i) {
        if (i)
          return e.slice();
        var c = e.length, h = l1 ? l1(c) : new e.constructor(c);
        return e.copy(h), h;
      }
      function Is(e) {
        var i = new e.constructor(e.byteLength);
        return new Ri(i).set(new Ri(e)), i;
      }
      function F6(e, i) {
        var c = i ? Is(e.buffer) : e.buffer;
        return new e.constructor(c, e.byteOffset, e.byteLength);
      }
      function _6(e) {
        var i = new e.constructor(e.source, un.exec(e));
        return i.lastIndex = e.lastIndex, i;
      }
      function D6(e) {
        return Er ? cn(Er.call(e)) : {};
      }
      function _1(e, i) {
        var c = i ? Is(e.buffer) : e.buffer;
        return new e.constructor(c, e.byteOffset, e.length);
      }
      function D1(e, i) {
        if (e !== i) {
          var c = e !== u, h = e === null, w = e === e, T = $u(e), F = i !== u, M = i === null, L = i === i, J = $u(i);
          if (!M && !J && !T && e > i || T && F && L && !M && !J || h && F && L || !c && L || !w)
            return 1;
          if (!h && !T && !J && e < i || J && c && w && !h && !T || M && c && w || !F && w || !L)
            return -1;
        }
        return 0;
      }
      function M6(e, i, c) {
        for (var h = -1, w = e.criteria, T = i.criteria, F = w.length, M = c.length; ++h < F; ) {
          var L = D1(w[h], T[h]);
          if (L) {
            if (h >= M)
              return L;
            var J = c[h];
            return L * (J == "desc" ? -1 : 1);
          }
        }
        return e.index - i.index;
      }
      function M1(e, i, c, h) {
        for (var w = -1, T = e.length, F = c.length, M = -1, L = i.length, J = Wn(T - F, 0), K = k(L + J), q = !h; ++M < L; )
          K[M] = i[M];
        for (; ++w < F; )
          (q || w < T) && (K[c[w]] = e[w]);
        for (; J--; )
          K[M++] = e[w++];
        return K;
      }
      function B1(e, i, c, h) {
        for (var w = -1, T = e.length, F = -1, M = c.length, L = -1, J = i.length, K = Wn(T - M, 0), q = k(K + J), pl = !h; ++w < K; )
          q[w] = e[w];
        for (var bl = w; ++L < J; )
          q[bl + L] = i[L];
        for (; ++F < M; )
          (pl || w < T) && (q[bl + c[F]] = e[w++]);
        return q;
      }
      function su(e, i) {
        var c = -1, h = e.length;
        for (i || (i = k(h)); ++c < h; )
          i[c] = e[c];
        return i;
      }
      function te(e, i, c, h) {
        var w = !c;
        c || (c = {});
        for (var T = -1, F = i.length; ++T < F; ) {
          var M = i[T], L = h ? h(c[M], e[M], M, c, e) : u;
          L === u && (L = e[M]), w ? me(c, M, L) : Ar(c, M, L);
        }
        return c;
      }
      function B6(e, i) {
        return te(e, Rs(e), i);
      }
      function L6(e, i) {
        return te(e, J1(e), i);
      }
      function Xi(e, i) {
        return function(c, h) {
          var w = Ml(c) ? k9 : i6, T = i ? i() : {};
          return w(c, e, Al(h, 2), T);
        };
      }
      function Wt(e) {
        return Wl(function(i, c) {
          var h = -1, w = c.length, T = w > 1 ? c[w - 1] : u, F = w > 2 ? c[2] : u;
          for (T = e.length > 3 && typeof T == "function" ? (w--, T) : u, F && tu(c[0], c[1], F) && (T = w < 3 ? u : T, w = 1), i = cn(i); ++h < w; ) {
            var M = c[h];
            M && e(i, M, h, T);
          }
          return i;
        });
      }
      function L1(e, i) {
        return function(c, h) {
          if (c == null)
            return c;
          if (!du(c))
            return e(c, h);
          for (var w = c.length, T = i ? w : -1, F = cn(c); (i ? T-- : ++T < w) && h(F[T], T, F) !== !1; )
            ;
          return c;
        };
      }
      function G1(e) {
        return function(i, c, h) {
          for (var w = -1, T = cn(i), F = h(i), M = F.length; M--; ) {
            var L = F[e ? M : ++w];
            if (c(T[L], L, T) === !1)
              break;
          }
          return i;
        };
      }
      function G6(e, i, c) {
        var h = i & E, w = Rr(e);
        function T() {
          var F = this && this !== zn && this instanceof T ? w : e;
          return F.apply(h ? c : this, arguments);
        }
        return T;
      }
      function j1(e) {
        return function(i) {
          i = en(i);
          var c = _t(i) ? Zu(i) : u, h = c ? c[0] : i.charAt(0), w = c ? Ve(c, 1).join("") : i.slice(1);
          return h[e]() + w;
        };
      }
      function Vt(e) {
        return function(i) {
          return Ua(L2(B2(i).replace(N9, "")), e, "");
        };
      }
      function Rr(e) {
        return function() {
          var i = arguments;
          switch (i.length) {
            case 0:
              return new e();
            case 1:
              return new e(i[0]);
            case 2:
              return new e(i[0], i[1]);
            case 3:
              return new e(i[0], i[1], i[2]);
            case 4:
              return new e(i[0], i[1], i[2], i[3]);
            case 5:
              return new e(i[0], i[1], i[2], i[3], i[4]);
            case 6:
              return new e(i[0], i[1], i[2], i[3], i[4], i[5]);
            case 7:
              return new e(i[0], i[1], i[2], i[3], i[4], i[5], i[6]);
          }
          var c = jt(e.prototype), h = e.apply(c, i);
          return wn(h) ? h : c;
        };
      }
      function j6(e, i, c) {
        var h = Rr(e);
        function w() {
          for (var T = arguments.length, F = k(T), M = T, L = kt(w); M--; )
            F[M] = arguments[M];
          var J = T < 3 && F[0] !== L && F[T - 1] !== L ? [] : Be(F, L);
          if (T -= J.length, T < c)
            return Z1(
              e,
              i,
              zi,
              w.placeholder,
              u,
              F,
              J,
              u,
              u,
              c - T
            );
          var K = this && this !== zn && this instanceof w ? h : e;
          return vu(K, this, F);
        }
        return w;
      }
      function W1(e) {
        return function(i, c, h) {
          var w = cn(i);
          if (!du(i)) {
            var T = Al(c, 3);
            i = Vn(i), c = function(M) {
              return T(w[M], M, w);
            };
          }
          var F = e(i, c, h);
          return F > -1 ? w[T ? i[F] : F] : u;
        };
      }
      function V1(e) {
        return be(function(i) {
          var c = i.length, h = c, w = Fu.prototype.thru;
          for (e && i.reverse(); h--; ) {
            var T = i[h];
            if (typeof T != "function")
              throw new Ou(s);
            if (w && !F && Ki(T) == "wrapper")
              var F = new Fu([], !0);
          }
          for (h = F ? h : c; ++h < c; ) {
            T = i[h];
            var M = Ki(T), L = M == "wrapper" ? Ns(T) : u;
            L && Fs(L[0]) && L[1] == (_ | x | P | j) && !L[4].length && L[9] == 1 ? F = F[Ki(L[0])].apply(F, L[3]) : F = T.length == 1 && Fs(T) ? F[M]() : F.thru(T);
          }
          return function() {
            var J = arguments, K = J[0];
            if (F && J.length == 1 && Ml(K))
              return F.plant(K).value();
            for (var q = 0, pl = c ? i[q].apply(this, J) : K; ++q < c; )
              pl = i[q].call(this, pl);
            return pl;
          };
        });
      }
      function zi(e, i, c, h, w, T, F, M, L, J) {
        var K = i & _, q = i & E, pl = i & S, bl = i & (x | I), Nl = i & z, jl = pl ? u : Rr(e);
        function Tl() {
          for (var Zl = arguments.length, Jl = k(Zl), xu = Zl; xu--; )
            Jl[xu] = arguments[xu];
          if (bl)
            var ru = kt(Tl), Cu = Q9(Jl, ru);
          if (h && (Jl = M1(Jl, h, w, bl)), T && (Jl = B1(Jl, T, F, bl)), Zl -= Cu, bl && Zl < J) {
            var Rn = Be(Jl, ru);
            return Z1(
              e,
              i,
              zi,
              Tl.placeholder,
              c,
              Jl,
              Rn,
              M,
              L,
              J - Zl
            );
          }
          var Yu = q ? c : this, Ce = pl ? Yu[e] : e;
          return Zl = Jl.length, M ? Jl = im(Jl, M) : Nl && Zl > 1 && Jl.reverse(), K && L < Zl && (Jl.length = L), this && this !== zn && this instanceof Tl && (Ce = jl || Rr(Ce)), Ce.apply(Yu, Jl);
        }
        return Tl;
      }
      function k1(e, i) {
        return function(c, h) {
          return g6(c, e, i(h), {});
        };
      }
      function Yi(e, i) {
        return function(c, h) {
          var w;
          if (c === u && h === u)
            return i;
          if (c !== u && (w = c), h !== u) {
            if (w === u)
              return h;
            typeof c == "string" || typeof h == "string" ? (c = yu(c), h = yu(h)) : (c = P1(c), h = P1(h)), w = e(c, h);
          }
          return w;
        };
      }
      function Es(e) {
        return be(function(i) {
          return i = $n(i, bu(Al())), Wl(function(c) {
            var h = this;
            return e(i, function(w) {
              return vu(w, h, c);
            });
          });
        });
      }
      function Ui(e, i) {
        i = i === u ? " " : yu(i);
        var c = i.length;
        if (c < 2)
          return c ? bs(i, e) : i;
        var h = bs(i, Di(e / Dt(i)));
        return _t(i) ? Ve(Zu(h), 0, e).join("") : h.slice(0, e);
      }
      function W6(e, i, c, h) {
        var w = i & E, T = Rr(e);
        function F() {
          for (var M = -1, L = arguments.length, J = -1, K = h.length, q = k(K + L), pl = this && this !== zn && this instanceof F ? T : e; ++J < K; )
            q[J] = h[J];
          for (; L--; )
            q[J++] = arguments[++M];
          return vu(pl, w ? c : this, q);
        }
        return F;
      }
      function H1(e) {
        return function(i, c, h) {
          return h && typeof h != "number" && tu(i, c, h) && (c = h = u), i = xe(i), c === u ? (c = i, i = 0) : c = xe(c), h = h === u ? i < c ? 1 : -1 : xe(h), A6(i, c, h, e);
        };
      }
      function Ji(e) {
        return function(i, c) {
          return typeof i == "string" && typeof c == "string" || (i = Bu(i), c = Bu(c)), e(i, c);
        };
      }
      function Z1(e, i, c, h, w, T, F, M, L, J) {
        var K = i & x, q = K ? F : u, pl = K ? u : F, bl = K ? T : u, Nl = K ? u : T;
        i |= K ? P : O, i &= ~(K ? O : P), i & A || (i &= ~(E | S));
        var jl = [
          e,
          i,
          w,
          bl,
          q,
          Nl,
          pl,
          M,
          L,
          J
        ], Tl = c.apply(u, jl);
        return Fs(e) && e2(Tl, jl), Tl.placeholder = h, t2(Tl, e, i);
      }
      function As(e) {
        var i = jn[e];
        return function(c, h) {
          if (c = Bu(c), h = h == null ? 0 : Qn(Ll(h), 292), h && t1(c)) {
            var w = (en(c) + "e").split("e"), T = i(w[0] + "e" + (+w[1] + h));
            return w = (en(T) + "e").split("e"), +(w[0] + "e" + (+w[1] - h));
          }
          return i(c);
        };
      }
      var V6 = Lt && 1 / Ei(new Lt([, -0]))[1] == sl ? function(e) {
        return new Lt(e);
      } : Ys;
      function X1(e) {
        return function(i) {
          var c = qn(i);
          return c == Bl ? us(i) : c == _n ? rh(i) : K9(i, e(i));
        };
      }
      function ve(e, i, c, h, w, T, F, M) {
        var L = i & S;
        if (!L && typeof e != "function")
          throw new Ou(s);
        var J = h ? h.length : 0;
        if (J || (i &= ~(P | O), h = w = u), F = F === u ? F : Wn(Ll(F), 0), M = M === u ? M : Ll(M), J -= w ? w.length : 0, i & O) {
          var K = h, q = w;
          h = w = u;
        }
        var pl = L ? u : Ns(e), bl = [
          e,
          i,
          c,
          h,
          w,
          K,
          q,
          T,
          F,
          M
        ];
        if (pl && em(bl, pl), e = bl[0], i = bl[1], c = bl[2], h = bl[3], w = bl[4], M = bl[9] = bl[9] === u ? L ? 0 : e.length : Wn(bl[9] - J, 0), !M && i & (x | I) && (i &= ~(x | I)), !i || i == E)
          var Nl = G6(e, i, c);
        else i == x || i == I ? Nl = j6(e, i, M) : (i == P || i == (E | P)) && !w.length ? Nl = W6(e, i, c, h) : Nl = zi.apply(u, bl);
        var jl = pl ? A1 : e2;
        return t2(jl(Nl, bl), e, i);
      }
      function z1(e, i, c, h) {
        return e === u || zu(e, Bt[c]) && !an.call(h, c) ? i : e;
      }
      function Y1(e, i, c, h, w, T) {
        return wn(e) && wn(i) && (T.set(i, e), ki(e, i, u, Y1, T), T.delete(i)), e;
      }
      function k6(e) {
        return _r(e) ? u : e;
      }
      function U1(e, i, c, h, w, T) {
        var F = c & $, M = e.length, L = i.length;
        if (M != L && !(F && L > M))
          return !1;
        var J = T.get(e), K = T.get(i);
        if (J && K)
          return J == i && K == e;
        var q = -1, pl = !0, bl = c & b ? new ft() : u;
        for (T.set(e, i), T.set(i, e); ++q < M; ) {
          var Nl = e[q], jl = i[q];
          if (h)
            var Tl = F ? h(jl, Nl, q, i, e, T) : h(Nl, jl, q, e, i, T);
          if (Tl !== u) {
            if (Tl)
              continue;
            pl = !1;
            break;
          }
          if (bl) {
            if (!Ja(i, function(Zl, Jl) {
              if (!$r(bl, Jl) && (Nl === Zl || w(Nl, Zl, c, h, T)))
                return bl.push(Jl);
            })) {
              pl = !1;
              break;
            }
          } else if (!(Nl === jl || w(Nl, jl, c, h, T))) {
            pl = !1;
            break;
          }
        }
        return T.delete(e), T.delete(i), pl;
      }
      function H6(e, i, c, h, w, T, F) {
        switch (c) {
          case mu:
            if (e.byteLength != i.byteLength || e.byteOffset != i.byteOffset)
              return !1;
            e = e.buffer, i = i.buffer;
          case Kn:
            return !(e.byteLength != i.byteLength || !T(new Ri(e), new Ri(i)));
          case ml:
          case Sl:
          case Kl:
            return zu(+e, +i);
          case Cl:
            return e.name == i.name && e.message == i.message;
          case gn:
          case Zn:
            return e == i + "";
          case Bl:
            var M = us;
          case _n:
            var L = h & $;
            if (M || (M = Ei), e.size != i.size && !L)
              return !1;
            var J = F.get(e);
            if (J)
              return J == i;
            h |= b, F.set(e, i);
            var K = U1(M(e), M(i), h, w, T, F);
            return F.delete(e), K;
          case ne:
            if (Er)
              return Er.call(e) == Er.call(i);
        }
        return !1;
      }
      function Z6(e, i, c, h, w, T) {
        var F = c & $, M = Ss(e), L = M.length, J = Ss(i), K = J.length;
        if (L != K && !F)
          return !1;
        for (var q = L; q--; ) {
          var pl = M[q];
          if (!(F ? pl in i : an.call(i, pl)))
            return !1;
        }
        var bl = T.get(e), Nl = T.get(i);
        if (bl && Nl)
          return bl == i && Nl == e;
        var jl = !0;
        T.set(e, i), T.set(i, e);
        for (var Tl = F; ++q < L; ) {
          pl = M[q];
          var Zl = e[pl], Jl = i[pl];
          if (h)
            var xu = F ? h(Jl, Zl, pl, i, e, T) : h(Zl, Jl, pl, e, i, T);
          if (!(xu === u ? Zl === Jl || w(Zl, Jl, c, h, T) : xu)) {
            jl = !1;
            break;
          }
          Tl || (Tl = pl == "constructor");
        }
        if (jl && !Tl) {
          var ru = e.constructor, Cu = i.constructor;
          ru != Cu && "constructor" in e && "constructor" in i && !(typeof ru == "function" && ru instanceof ru && typeof Cu == "function" && Cu instanceof Cu) && (jl = !1);
        }
        return T.delete(e), T.delete(i), jl;
      }
      function be(e) {
        return Ds(n2(e, u, d2), e + "");
      }
      function Ss(e) {
        return h1(e, Vn, Rs);
      }
      function Ps(e) {
        return h1(e, cu, J1);
      }
      var Ns = Bi ? function(e) {
        return Bi.get(e);
      } : Ys;
      function Ki(e) {
        for (var i = e.name + "", c = Gt[i], h = an.call(Gt, i) ? c.length : 0; h--; ) {
          var w = c[h], T = w.func;
          if (T == null || T == e)
            return w.name;
        }
        return i;
      }
      function kt(e) {
        var i = an.call(N, "placeholder") ? N : e;
        return i.placeholder;
      }
      function Al() {
        var e = N.iteratee || Xs;
        return e = e === Xs ? b1 : e, arguments.length ? e(arguments[0], arguments[1]) : e;
      }
      function Qi(e, i) {
        var c = e.__data__;
        return q6(i) ? c[typeof i == "string" ? "string" : "hash"] : c.map;
      }
      function Ts(e) {
        for (var i = Vn(e), c = i.length; c--; ) {
          var h = i[c], w = e[h];
          i[c] = [h, w, q1(w)];
        }
        return i;
      }
      function ht(e, i) {
        var c = uh(e, i);
        return v1(c) ? c : u;
      }
      function X6(e) {
        var i = an.call(e, dt), c = e[dt];
        try {
          e[dt] = u;
          var h = !0;
        } catch {
        }
        var w = Ni.call(e);
        return h && (i ? e[dt] = c : delete e[dt]), w;
      }
      var Rs = ts ? function(e) {
        return e == null ? [] : (e = cn(e), De(ts(e), function(i) {
          return u1.call(e, i);
        }));
      } : Us, J1 = ts ? function(e) {
        for (var i = []; e; )
          Me(i, Rs(e)), e = Oi(e);
        return i;
      } : Us, qn = eu;
      (rs && qn(new rs(new ArrayBuffer(1))) != mu || Cr && qn(new Cr()) != Bl || is && qn(is.resolve()) != Fn || Lt && qn(new Lt()) != _n || wr && qn(new wr()) != Nu) && (qn = function(e) {
        var i = eu(e), c = i == dn ? e.constructor : u, h = c ? mt(c) : "";
        if (h)
          switch (h) {
            case Ph:
              return mu;
            case Nh:
              return Bl;
            case Th:
              return Fn;
            case Rh:
              return _n;
            case Oh:
              return Nu;
          }
        return i;
      });
      function z6(e, i, c) {
        for (var h = -1, w = c.length; ++h < w; ) {
          var T = c[h], F = T.size;
          switch (T.type) {
            case "drop":
              e += F;
              break;
            case "dropRight":
              i -= F;
              break;
            case "take":
              i = Qn(i, e + F);
              break;
            case "takeRight":
              e = Wn(e, i - F);
              break;
          }
        }
        return { start: e, end: i };
      }
      function Y6(e) {
        var i = e.match(ja);
        return i ? i[1].split(D) : [];
      }
      function K1(e, i, c) {
        i = We(i, e);
        for (var h = -1, w = i.length, T = !1; ++h < w; ) {
          var F = re(i[h]);
          if (!(T = e != null && c(e, F)))
            break;
          e = e[F];
        }
        return T || ++h != w ? T : (w = e == null ? 0 : e.length, !!w && ro(w) && ye(F, w) && (Ml(e) || vt(e)));
      }
      function U6(e) {
        var i = e.length, c = new e.constructor(i);
        return i && typeof e[0] == "string" && an.call(e, "index") && (c.index = e.index, c.input = e.input), c;
      }
      function Q1(e) {
        return typeof e.constructor == "function" && !Or(e) ? jt(Oi(e)) : {};
      }
      function J6(e, i, c) {
        var h = e.constructor;
        switch (i) {
          case Kn:
            return Is(e);
          case ml:
          case Sl:
            return new h(+e);
          case mu:
            return F6(e, c);
          case R:
          case G:
          case W:
          case al:
          case Pl:
          case Fl:
          case on:
          case xn:
          case Dn:
            return _1(e, c);
          case Bl:
            return new h();
          case Kl:
          case Zn:
            return new h(e);
          case gn:
            return _6(e);
          case _n:
            return new h();
          case ne:
            return D6(e);
        }
      }
      function K6(e, i) {
        var c = i.length;
        if (!c)
          return e;
        var h = c - 1;
        return i[h] = (c > 1 ? "& " : "") + i[h], i = i.join(c > 2 ? ", " : " "), e.replace(Ga, `{
/* [wrapped with ` + i + `] */
`);
      }
      function Q6(e) {
        return Ml(e) || vt(e) || !!(e1 && e && e[e1]);
      }
      function ye(e, i) {
        var c = typeof e;
        return i = i ?? ll, !!i && (c == "number" || c != "symbol" && Sn.test(e)) && e > -1 && e % 1 == 0 && e < i;
      }
      function tu(e, i, c) {
        if (!wn(c))
          return !1;
        var h = typeof i;
        return (h == "number" ? du(c) && ye(i, c.length) : h == "string" && i in c) ? zu(c[i], e) : !1;
      }
      function Os(e, i) {
        if (Ml(e))
          return !1;
        var c = typeof e;
        return c == "number" || c == "symbol" || c == "boolean" || e == null || $u(e) ? !0 : yi.test(e) || !bi.test(e) || i != null && e in cn(i);
      }
      function q6(e) {
        var i = typeof e;
        return i == "string" || i == "number" || i == "symbol" || i == "boolean" ? e !== "__proto__" : e === null;
      }
      function Fs(e) {
        var i = Ki(e), c = N[i];
        if (typeof c != "function" || !(i in Yl.prototype))
          return !1;
        if (e === c)
          return !0;
        var h = Ns(c);
        return !!h && e === h[0];
      }
      function lm(e) {
        return !!q0 && q0 in e;
      }
      var nm = Si ? $e : Js;
      function Or(e) {
        var i = e && e.constructor, c = typeof i == "function" && i.prototype || Bt;
        return e === c;
      }
      function q1(e) {
        return e === e && !wn(e);
      }
      function l2(e, i) {
        return function(c) {
          return c == null ? !1 : c[e] === i && (i !== u || e in cn(c));
        };
      }
      function um(e) {
        var i = eo(e, function(h) {
          return c.size === f && c.clear(), h;
        }), c = i.cache;
        return i;
      }
      function em(e, i) {
        var c = e[1], h = i[1], w = c | h, T = w < (E | S | _), F = h == _ && c == x || h == _ && c == j && e[7].length <= i[8] || h == (_ | j) && i[7].length <= i[8] && c == x;
        if (!(T || F))
          return e;
        h & E && (e[2] = i[2], w |= c & E ? 0 : A);
        var M = i[3];
        if (M) {
          var L = e[3];
          e[3] = L ? M1(L, M, i[4]) : M, e[4] = L ? Be(e[3], p) : i[4];
        }
        return M = i[5], M && (L = e[5], e[5] = L ? B1(L, M, i[6]) : M, e[6] = L ? Be(e[5], p) : i[6]), M = i[7], M && (e[7] = M), h & _ && (e[8] = e[8] == null ? i[8] : Qn(e[8], i[8])), e[9] == null && (e[9] = i[9]), e[0] = i[0], e[1] = w, e;
      }
      function tm(e) {
        var i = [];
        if (e != null)
          for (var c in cn(e))
            i.push(c);
        return i;
      }
      function rm(e) {
        return Ni.call(e);
      }
      function n2(e, i, c) {
        return i = Wn(i === u ? e.length - 1 : i, 0), function() {
          for (var h = arguments, w = -1, T = Wn(h.length - i, 0), F = k(T); ++w < T; )
            F[w] = h[i + w];
          w = -1;
          for (var M = k(i + 1); ++w < i; )
            M[w] = h[w];
          return M[i] = c(F), vu(e, this, M);
        };
      }
      function u2(e, i) {
        return i.length < 2 ? e : gt(e, Du(i, 0, -1));
      }
      function im(e, i) {
        for (var c = e.length, h = Qn(i.length, c), w = su(e); h--; ) {
          var T = i[h];
          e[h] = ye(T, c) ? w[T] : u;
        }
        return e;
      }
      function _s(e, i) {
        if (!(i === "constructor" && typeof e[i] == "function") && i != "__proto__")
          return e[i];
      }
      var e2 = r2(A1), Fr = xh || function(e, i) {
        return zn.setTimeout(e, i);
      }, Ds = r2(N6);
      function t2(e, i, c) {
        var h = i + "";
        return Ds(e, K6(h, om(Y6(h), c)));
      }
      function r2(e) {
        var i = 0, c = 0;
        return function() {
          var h = Eh(), w = ul - (h - c);
          if (c = h, w > 0) {
            if (++i >= U)
              return arguments[0];
          } else
            i = 0;
          return e.apply(u, arguments);
        };
      }
      function qi(e, i) {
        var c = -1, h = e.length, w = h - 1;
        for (i = i === u ? h : i; ++c < i; ) {
          var T = vs(c, w), F = e[T];
          e[T] = e[c], e[c] = F;
        }
        return e.length = i, e;
      }
      var i2 = um(function(e) {
        var i = [];
        return e.charCodeAt(0) === 46 && i.push(""), e.replace(Ba, function(c, h, w, T) {
          i.push(w ? T.replace(_l, "$1") : h || c);
        }), i;
      });
      function re(e) {
        if (typeof e == "string" || $u(e))
          return e;
        var i = e + "";
        return i == "0" && 1 / e == -sl ? "-0" : i;
      }
      function mt(e) {
        if (e != null) {
          try {
            return Pi.call(e);
          } catch {
          }
          try {
            return e + "";
          } catch {
          }
        }
        return "";
      }
      function om(e, i) {
        return Ru($l, function(c) {
          var h = "_." + c[0];
          i & c[1] && !wi(e, h) && e.push(h);
        }), e.sort();
      }
      function o2(e) {
        if (e instanceof Yl)
          return e.clone();
        var i = new Fu(e.__wrapped__, e.__chain__);
        return i.__actions__ = su(e.__actions__), i.__index__ = e.__index__, i.__values__ = e.__values__, i;
      }
      function am(e, i, c) {
        (c ? tu(e, i, c) : i === u) ? i = 1 : i = Wn(Ll(i), 0);
        var h = e == null ? 0 : e.length;
        if (!h || i < 1)
          return [];
        for (var w = 0, T = 0, F = k(Di(h / i)); w < h; )
          F[T++] = Du(e, w, w += i);
        return F;
      }
      function sm(e) {
        for (var i = -1, c = e == null ? 0 : e.length, h = 0, w = []; ++i < c; ) {
          var T = e[i];
          T && (w[h++] = T);
        }
        return w;
      }
      function dm() {
        var e = arguments.length;
        if (!e)
          return [];
        for (var i = k(e - 1), c = arguments[0], h = e; h--; )
          i[h - 1] = arguments[h];
        return Me(Ml(c) ? su(c) : [c], Yn(i, 1));
      }
      var cm = Wl(function(e, i) {
        return Tn(e) ? Sr(e, Yn(i, 1, Tn, !0)) : [];
      }), fm = Wl(function(e, i) {
        var c = Mu(i);
        return Tn(c) && (c = u), Tn(e) ? Sr(e, Yn(i, 1, Tn, !0), Al(c, 2)) : [];
      }), pm = Wl(function(e, i) {
        var c = Mu(i);
        return Tn(c) && (c = u), Tn(e) ? Sr(e, Yn(i, 1, Tn, !0), u, c) : [];
      });
      function gm(e, i, c) {
        var h = e == null ? 0 : e.length;
        return h ? (i = c || i === u ? 1 : Ll(i), Du(e, i < 0 ? 0 : i, h)) : [];
      }
      function hm(e, i, c) {
        var h = e == null ? 0 : e.length;
        return h ? (i = c || i === u ? 1 : Ll(i), i = h - i, Du(e, 0, i < 0 ? 0 : i)) : [];
      }
      function mm(e, i) {
        return e && e.length ? Zi(e, Al(i, 3), !0, !0) : [];
      }
      function vm(e, i) {
        return e && e.length ? Zi(e, Al(i, 3), !0) : [];
      }
      function bm(e, i, c, h) {
        var w = e == null ? 0 : e.length;
        return w ? (c && typeof c != "number" && tu(e, i, c) && (c = 0, h = w), d6(e, i, c, h)) : [];
      }
      function a2(e, i, c) {
        var h = e == null ? 0 : e.length;
        if (!h)
          return -1;
        var w = c == null ? 0 : Ll(c);
        return w < 0 && (w = Wn(h + w, 0)), Ii(e, Al(i, 3), w);
      }
      function s2(e, i, c) {
        var h = e == null ? 0 : e.length;
        if (!h)
          return -1;
        var w = h - 1;
        return c !== u && (w = Ll(c), w = c < 0 ? Wn(h + w, 0) : Qn(w, h - 1)), Ii(e, Al(i, 3), w, !0);
      }
      function d2(e) {
        var i = e == null ? 0 : e.length;
        return i ? Yn(e, 1) : [];
      }
      function ym(e) {
        var i = e == null ? 0 : e.length;
        return i ? Yn(e, sl) : [];
      }
      function $m(e, i) {
        var c = e == null ? 0 : e.length;
        return c ? (i = i === u ? 1 : Ll(i), Yn(e, i)) : [];
      }
      function xm(e) {
        for (var i = -1, c = e == null ? 0 : e.length, h = {}; ++i < c; ) {
          var w = e[i];
          h[w[0]] = w[1];
        }
        return h;
      }
      function c2(e) {
        return e && e.length ? e[0] : u;
      }
      function Cm(e, i, c) {
        var h = e == null ? 0 : e.length;
        if (!h)
          return -1;
        var w = c == null ? 0 : Ll(c);
        return w < 0 && (w = Wn(h + w, 0)), Ft(e, i, w);
      }
      function wm(e) {
        var i = e == null ? 0 : e.length;
        return i ? Du(e, 0, -1) : [];
      }
      var Im = Wl(function(e) {
        var i = $n(e, Cs);
        return i.length && i[0] === e[0] ? fs(i) : [];
      }), Em = Wl(function(e) {
        var i = Mu(e), c = $n(e, Cs);
        return i === Mu(c) ? i = u : c.pop(), c.length && c[0] === e[0] ? fs(c, Al(i, 2)) : [];
      }), Am = Wl(function(e) {
        var i = Mu(e), c = $n(e, Cs);
        return i = typeof i == "function" ? i : u, i && c.pop(), c.length && c[0] === e[0] ? fs(c, u, i) : [];
      });
      function Sm(e, i) {
        return e == null ? "" : wh.call(e, i);
      }
      function Mu(e) {
        var i = e == null ? 0 : e.length;
        return i ? e[i - 1] : u;
      }
      function Pm(e, i, c) {
        var h = e == null ? 0 : e.length;
        if (!h)
          return -1;
        var w = h;
        return c !== u && (w = Ll(c), w = w < 0 ? Wn(h + w, 0) : Qn(w, h - 1)), i === i ? oh(e, i, w) : Ii(e, Z0, w, !0);
      }
      function Nm(e, i) {
        return e && e.length ? C1(e, Ll(i)) : u;
      }
      var Tm = Wl(f2);
      function f2(e, i) {
        return e && e.length && i && i.length ? ms(e, i) : e;
      }
      function Rm(e, i, c) {
        return e && e.length && i && i.length ? ms(e, i, Al(c, 2)) : e;
      }
      function Om(e, i, c) {
        return e && e.length && i && i.length ? ms(e, i, u, c) : e;
      }
      var Fm = be(function(e, i) {
        var c = e == null ? 0 : e.length, h = as(e, i);
        return E1(e, $n(i, function(w) {
          return ye(w, c) ? +w : w;
        }).sort(D1)), h;
      });
      function _m(e, i) {
        var c = [];
        if (!(e && e.length))
          return c;
        var h = -1, w = [], T = e.length;
        for (i = Al(i, 3); ++h < T; ) {
          var F = e[h];
          i(F, h, e) && (c.push(F), w.push(h));
        }
        return E1(e, w), c;
      }
      function Ms(e) {
        return e == null ? e : Sh.call(e);
      }
      function Dm(e, i, c) {
        var h = e == null ? 0 : e.length;
        return h ? (c && typeof c != "number" && tu(e, i, c) ? (i = 0, c = h) : (i = i == null ? 0 : Ll(i), c = c === u ? h : Ll(c)), Du(e, i, c)) : [];
      }
      function Mm(e, i) {
        return Hi(e, i);
      }
      function Bm(e, i, c) {
        return ys(e, i, Al(c, 2));
      }
      function Lm(e, i) {
        var c = e == null ? 0 : e.length;
        if (c) {
          var h = Hi(e, i);
          if (h < c && zu(e[h], i))
            return h;
        }
        return -1;
      }
      function Gm(e, i) {
        return Hi(e, i, !0);
      }
      function jm(e, i, c) {
        return ys(e, i, Al(c, 2), !0);
      }
      function Wm(e, i) {
        var c = e == null ? 0 : e.length;
        if (c) {
          var h = Hi(e, i, !0) - 1;
          if (zu(e[h], i))
            return h;
        }
        return -1;
      }
      function Vm(e) {
        return e && e.length ? S1(e) : [];
      }
      function km(e, i) {
        return e && e.length ? S1(e, Al(i, 2)) : [];
      }
      function Hm(e) {
        var i = e == null ? 0 : e.length;
        return i ? Du(e, 1, i) : [];
      }
      function Zm(e, i, c) {
        return e && e.length ? (i = c || i === u ? 1 : Ll(i), Du(e, 0, i < 0 ? 0 : i)) : [];
      }
      function Xm(e, i, c) {
        var h = e == null ? 0 : e.length;
        return h ? (i = c || i === u ? 1 : Ll(i), i = h - i, Du(e, i < 0 ? 0 : i, h)) : [];
      }
      function zm(e, i) {
        return e && e.length ? Zi(e, Al(i, 3), !1, !0) : [];
      }
      function Ym(e, i) {
        return e && e.length ? Zi(e, Al(i, 3)) : [];
      }
      var Um = Wl(function(e) {
        return je(Yn(e, 1, Tn, !0));
      }), Jm = Wl(function(e) {
        var i = Mu(e);
        return Tn(i) && (i = u), je(Yn(e, 1, Tn, !0), Al(i, 2));
      }), Km = Wl(function(e) {
        var i = Mu(e);
        return i = typeof i == "function" ? i : u, je(Yn(e, 1, Tn, !0), u, i);
      });
      function Qm(e) {
        return e && e.length ? je(e) : [];
      }
      function qm(e, i) {
        return e && e.length ? je(e, Al(i, 2)) : [];
      }
      function l7(e, i) {
        return i = typeof i == "function" ? i : u, e && e.length ? je(e, u, i) : [];
      }
      function Bs(e) {
        if (!(e && e.length))
          return [];
        var i = 0;
        return e = De(e, function(c) {
          if (Tn(c))
            return i = Wn(c.length, i), !0;
        }), ls(i, function(c) {
          return $n(e, Ka(c));
        });
      }
      function p2(e, i) {
        if (!(e && e.length))
          return [];
        var c = Bs(e);
        return i == null ? c : $n(c, function(h) {
          return vu(i, u, h);
        });
      }
      var n7 = Wl(function(e, i) {
        return Tn(e) ? Sr(e, i) : [];
      }), u7 = Wl(function(e) {
        return xs(De(e, Tn));
      }), e7 = Wl(function(e) {
        var i = Mu(e);
        return Tn(i) && (i = u), xs(De(e, Tn), Al(i, 2));
      }), t7 = Wl(function(e) {
        var i = Mu(e);
        return i = typeof i == "function" ? i : u, xs(De(e, Tn), u, i);
      }), r7 = Wl(Bs);
      function i7(e, i) {
        return R1(e || [], i || [], Ar);
      }
      function o7(e, i) {
        return R1(e || [], i || [], Tr);
      }
      var a7 = Wl(function(e) {
        var i = e.length, c = i > 1 ? e[i - 1] : u;
        return c = typeof c == "function" ? (e.pop(), c) : u, p2(e, c);
      });
      function g2(e) {
        var i = N(e);
        return i.__chain__ = !0, i;
      }
      function s7(e, i) {
        return i(e), e;
      }
      function lo(e, i) {
        return i(e);
      }
      var d7 = be(function(e) {
        var i = e.length, c = i ? e[0] : 0, h = this.__wrapped__, w = function(T) {
          return as(T, e);
        };
        return i > 1 || this.__actions__.length || !(h instanceof Yl) || !ye(c) ? this.thru(w) : (h = h.slice(c, +c + (i ? 1 : 0)), h.__actions__.push({
          func: lo,
          args: [w],
          thisArg: u
        }), new Fu(h, this.__chain__).thru(function(T) {
          return i && !T.length && T.push(u), T;
        }));
      });
      function c7() {
        return g2(this);
      }
      function f7() {
        return new Fu(this.value(), this.__chain__);
      }
      function p7() {
        this.__values__ === u && (this.__values__ = P2(this.value()));
        var e = this.__index__ >= this.__values__.length, i = e ? u : this.__values__[this.__index__++];
        return { done: e, value: i };
      }
      function g7() {
        return this;
      }
      function h7(e) {
        for (var i, c = this; c instanceof Gi; ) {
          var h = o2(c);
          h.__index__ = 0, h.__values__ = u, i ? w.__wrapped__ = h : i = h;
          var w = h;
          c = c.__wrapped__;
        }
        return w.__wrapped__ = e, i;
      }
      function m7() {
        var e = this.__wrapped__;
        if (e instanceof Yl) {
          var i = e;
          return this.__actions__.length && (i = new Yl(this)), i = i.reverse(), i.__actions__.push({
            func: lo,
            args: [Ms],
            thisArg: u
          }), new Fu(i, this.__chain__);
        }
        return this.thru(Ms);
      }
      function v7() {
        return T1(this.__wrapped__, this.__actions__);
      }
      var b7 = Xi(function(e, i, c) {
        an.call(e, c) ? ++e[c] : me(e, c, 1);
      });
      function y7(e, i, c) {
        var h = Ml(e) ? k0 : s6;
        return c && tu(e, i, c) && (i = u), h(e, Al(i, 3));
      }
      function $7(e, i) {
        var c = Ml(e) ? De : p1;
        return c(e, Al(i, 3));
      }
      var x7 = W1(a2), C7 = W1(s2);
      function w7(e, i) {
        return Yn(no(e, i), 1);
      }
      function I7(e, i) {
        return Yn(no(e, i), sl);
      }
      function E7(e, i, c) {
        return c = c === u ? 1 : Ll(c), Yn(no(e, i), c);
      }
      function h2(e, i) {
        var c = Ml(e) ? Ru : Ge;
        return c(e, Al(i, 3));
      }
      function m2(e, i) {
        var c = Ml(e) ? H9 : f1;
        return c(e, Al(i, 3));
      }
      var A7 = Xi(function(e, i, c) {
        an.call(e, c) ? e[c].push(i) : me(e, c, [i]);
      });
      function S7(e, i, c, h) {
        e = du(e) ? e : Zt(e), c = c && !h ? Ll(c) : 0;
        var w = e.length;
        return c < 0 && (c = Wn(w + c, 0)), io(e) ? c <= w && e.indexOf(i, c) > -1 : !!w && Ft(e, i, c) > -1;
      }
      var P7 = Wl(function(e, i, c) {
        var h = -1, w = typeof i == "function", T = du(e) ? k(e.length) : [];
        return Ge(e, function(F) {
          T[++h] = w ? vu(i, F, c) : Pr(F, i, c);
        }), T;
      }), N7 = Xi(function(e, i, c) {
        me(e, c, i);
      });
      function no(e, i) {
        var c = Ml(e) ? $n : y1;
        return c(e, Al(i, 3));
      }
      function T7(e, i, c, h) {
        return e == null ? [] : (Ml(i) || (i = i == null ? [] : [i]), c = h ? u : c, Ml(c) || (c = c == null ? [] : [c]), w1(e, i, c));
      }
      var R7 = Xi(function(e, i, c) {
        e[c ? 0 : 1].push(i);
      }, function() {
        return [[], []];
      });
      function O7(e, i, c) {
        var h = Ml(e) ? Ua : z0, w = arguments.length < 3;
        return h(e, Al(i, 4), c, w, Ge);
      }
      function F7(e, i, c) {
        var h = Ml(e) ? Z9 : z0, w = arguments.length < 3;
        return h(e, Al(i, 4), c, w, f1);
      }
      function _7(e, i) {
        var c = Ml(e) ? De : p1;
        return c(e, to(Al(i, 3)));
      }
      function D7(e) {
        var i = Ml(e) ? a1 : S6;
        return i(e);
      }
      function M7(e, i, c) {
        (c ? tu(e, i, c) : i === u) ? i = 1 : i = Ll(i);
        var h = Ml(e) ? t6 : P6;
        return h(e, i);
      }
      function B7(e) {
        var i = Ml(e) ? r6 : T6;
        return i(e);
      }
      function L7(e) {
        if (e == null)
          return 0;
        if (du(e))
          return io(e) ? Dt(e) : e.length;
        var i = qn(e);
        return i == Bl || i == _n ? e.size : gs(e).length;
      }
      function G7(e, i, c) {
        var h = Ml(e) ? Ja : R6;
        return c && tu(e, i, c) && (i = u), h(e, Al(i, 3));
      }
      var j7 = Wl(function(e, i) {
        if (e == null)
          return [];
        var c = i.length;
        return c > 1 && tu(e, i[0], i[1]) ? i = [] : c > 2 && tu(i[0], i[1], i[2]) && (i = [i[0]]), w1(e, Yn(i, 1), []);
      }), uo = $h || function() {
        return zn.Date.now();
      };
      function W7(e, i) {
        if (typeof i != "function")
          throw new Ou(s);
        return e = Ll(e), function() {
          if (--e < 1)
            return i.apply(this, arguments);
        };
      }
      function v2(e, i, c) {
        return i = c ? u : i, i = e && i == null ? e.length : i, ve(e, _, u, u, u, u, i);
      }
      function b2(e, i) {
        var c;
        if (typeof i != "function")
          throw new Ou(s);
        return e = Ll(e), function() {
          return --e > 0 && (c = i.apply(this, arguments)), e <= 1 && (i = u), c;
        };
      }
      var Ls = Wl(function(e, i, c) {
        var h = E;
        if (c.length) {
          var w = Be(c, kt(Ls));
          h |= P;
        }
        return ve(e, h, i, c, w);
      }), y2 = Wl(function(e, i, c) {
        var h = E | S;
        if (c.length) {
          var w = Be(c, kt(y2));
          h |= P;
        }
        return ve(i, h, e, c, w);
      });
      function $2(e, i, c) {
        i = c ? u : i;
        var h = ve(e, x, u, u, u, u, u, i);
        return h.placeholder = $2.placeholder, h;
      }
      function x2(e, i, c) {
        i = c ? u : i;
        var h = ve(e, I, u, u, u, u, u, i);
        return h.placeholder = x2.placeholder, h;
      }
      function C2(e, i, c) {
        var h, w, T, F, M, L, J = 0, K = !1, q = !1, pl = !0;
        if (typeof e != "function")
          throw new Ou(s);
        i = Bu(i) || 0, wn(c) && (K = !!c.leading, q = "maxWait" in c, T = q ? Wn(Bu(c.maxWait) || 0, i) : T, pl = "trailing" in c ? !!c.trailing : pl);
        function bl(Rn) {
          var Yu = h, Ce = w;
          return h = w = u, J = Rn, F = e.apply(Ce, Yu), F;
        }
        function Nl(Rn) {
          return J = Rn, M = Fr(Zl, i), K ? bl(Rn) : F;
        }
        function jl(Rn) {
          var Yu = Rn - L, Ce = Rn - J, W2 = i - Yu;
          return q ? Qn(W2, T - Ce) : W2;
        }
        function Tl(Rn) {
          var Yu = Rn - L, Ce = Rn - J;
          return L === u || Yu >= i || Yu < 0 || q && Ce >= T;
        }
        function Zl() {
          var Rn = uo();
          if (Tl(Rn))
            return Jl(Rn);
          M = Fr(Zl, jl(Rn));
        }
        function Jl(Rn) {
          return M = u, pl && h ? bl(Rn) : (h = w = u, F);
        }
        function xu() {
          M !== u && O1(M), J = 0, h = L = w = M = u;
        }
        function ru() {
          return M === u ? F : Jl(uo());
        }
        function Cu() {
          var Rn = uo(), Yu = Tl(Rn);
          if (h = arguments, w = this, L = Rn, Yu) {
            if (M === u)
              return Nl(L);
            if (q)
              return O1(M), M = Fr(Zl, i), bl(L);
          }
          return M === u && (M = Fr(Zl, i)), F;
        }
        return Cu.cancel = xu, Cu.flush = ru, Cu;
      }
      var V7 = Wl(function(e, i) {
        return c1(e, 1, i);
      }), k7 = Wl(function(e, i, c) {
        return c1(e, Bu(i) || 0, c);
      });
      function H7(e) {
        return ve(e, z);
      }
      function eo(e, i) {
        if (typeof e != "function" || i != null && typeof i != "function")
          throw new Ou(s);
        var c = function() {
          var h = arguments, w = i ? i.apply(this, h) : h[0], T = c.cache;
          if (T.has(w))
            return T.get(w);
          var F = e.apply(this, h);
          return c.cache = T.set(w, F) || T, F;
        };
        return c.cache = new (eo.Cache || he)(), c;
      }
      eo.Cache = he;
      function to(e) {
        if (typeof e != "function")
          throw new Ou(s);
        return function() {
          var i = arguments;
          switch (i.length) {
            case 0:
              return !e.call(this);
            case 1:
              return !e.call(this, i[0]);
            case 2:
              return !e.call(this, i[0], i[1]);
            case 3:
              return !e.call(this, i[0], i[1], i[2]);
          }
          return !e.apply(this, i);
        };
      }
      function Z7(e) {
        return b2(2, e);
      }
      var X7 = O6(function(e, i) {
        i = i.length == 1 && Ml(i[0]) ? $n(i[0], bu(Al())) : $n(Yn(i, 1), bu(Al()));
        var c = i.length;
        return Wl(function(h) {
          for (var w = -1, T = Qn(h.length, c); ++w < T; )
            h[w] = i[w].call(this, h[w]);
          return vu(e, this, h);
        });
      }), Gs = Wl(function(e, i) {
        var c = Be(i, kt(Gs));
        return ve(e, P, u, i, c);
      }), w2 = Wl(function(e, i) {
        var c = Be(i, kt(w2));
        return ve(e, O, u, i, c);
      }), z7 = be(function(e, i) {
        return ve(e, j, u, u, u, i);
      });
      function Y7(e, i) {
        if (typeof e != "function")
          throw new Ou(s);
        return i = i === u ? i : Ll(i), Wl(e, i);
      }
      function U7(e, i) {
        if (typeof e != "function")
          throw new Ou(s);
        return i = i == null ? 0 : Wn(Ll(i), 0), Wl(function(c) {
          var h = c[i], w = Ve(c, 0, i);
          return h && Me(w, h), vu(e, this, w);
        });
      }
      function J7(e, i, c) {
        var h = !0, w = !0;
        if (typeof e != "function")
          throw new Ou(s);
        return wn(c) && (h = "leading" in c ? !!c.leading : h, w = "trailing" in c ? !!c.trailing : w), C2(e, i, {
          leading: h,
          maxWait: i,
          trailing: w
        });
      }
      function K7(e) {
        return v2(e, 1);
      }
      function Q7(e, i) {
        return Gs(ws(i), e);
      }
      function q7() {
        if (!arguments.length)
          return [];
        var e = arguments[0];
        return Ml(e) ? e : [e];
      }
      function l8(e) {
        return _u(e, v);
      }
      function n8(e, i) {
        return i = typeof i == "function" ? i : u, _u(e, v, i);
      }
      function u8(e) {
        return _u(e, g | v);
      }
      function e8(e, i) {
        return i = typeof i == "function" ? i : u, _u(e, g | v, i);
      }
      function t8(e, i) {
        return i == null || d1(e, i, Vn(i));
      }
      function zu(e, i) {
        return e === i || e !== e && i !== i;
      }
      var r8 = Ji(cs), i8 = Ji(function(e, i) {
        return e >= i;
      }), vt = m1(/* @__PURE__ */ function() {
        return arguments;
      }()) ? m1 : function(e) {
        return Pn(e) && an.call(e, "callee") && !u1.call(e, "callee");
      }, Ml = k.isArray, o8 = B0 ? bu(B0) : h6;
      function du(e) {
        return e != null && ro(e.length) && !$e(e);
      }
      function Tn(e) {
        return Pn(e) && du(e);
      }
      function a8(e) {
        return e === !0 || e === !1 || Pn(e) && eu(e) == ml;
      }
      var ke = Ch || Js, s8 = L0 ? bu(L0) : m6;
      function d8(e) {
        return Pn(e) && e.nodeType === 1 && !_r(e);
      }
      function c8(e) {
        if (e == null)
          return !0;
        if (du(e) && (Ml(e) || typeof e == "string" || typeof e.splice == "function" || ke(e) || Ht(e) || vt(e)))
          return !e.length;
        var i = qn(e);
        if (i == Bl || i == _n)
          return !e.size;
        if (Or(e))
          return !gs(e).length;
        for (var c in e)
          if (an.call(e, c))
            return !1;
        return !0;
      }
      function f8(e, i) {
        return Nr(e, i);
      }
      function p8(e, i, c) {
        c = typeof c == "function" ? c : u;
        var h = c ? c(e, i) : u;
        return h === u ? Nr(e, i, u, c) : !!h;
      }
      function js(e) {
        if (!Pn(e))
          return !1;
        var i = eu(e);
        return i == Cl || i == Ol || typeof e.message == "string" && typeof e.name == "string" && !_r(e);
      }
      function g8(e) {
        return typeof e == "number" && t1(e);
      }
      function $e(e) {
        if (!wn(e))
          return !1;
        var i = eu(e);
        return i == Q || i == Xl || i == ol || i == sn;
      }
      function I2(e) {
        return typeof e == "number" && e == Ll(e);
      }
      function ro(e) {
        return typeof e == "number" && e > -1 && e % 1 == 0 && e <= ll;
      }
      function wn(e) {
        var i = typeof e;
        return e != null && (i == "object" || i == "function");
      }
      function Pn(e) {
        return e != null && typeof e == "object";
      }
      var E2 = G0 ? bu(G0) : b6;
      function h8(e, i) {
        return e === i || ps(e, i, Ts(i));
      }
      function m8(e, i, c) {
        return c = typeof c == "function" ? c : u, ps(e, i, Ts(i), c);
      }
      function v8(e) {
        return A2(e) && e != +e;
      }
      function b8(e) {
        if (nm(e))
          throw new Dl(o);
        return v1(e);
      }
      function y8(e) {
        return e === null;
      }
      function $8(e) {
        return e == null;
      }
      function A2(e) {
        return typeof e == "number" || Pn(e) && eu(e) == Kl;
      }
      function _r(e) {
        if (!Pn(e) || eu(e) != dn)
          return !1;
        var i = Oi(e);
        if (i === null)
          return !0;
        var c = an.call(i, "constructor") && i.constructor;
        return typeof c == "function" && c instanceof c && Pi.call(c) == mh;
      }
      var Ws = j0 ? bu(j0) : y6;
      function x8(e) {
        return I2(e) && e >= -ll && e <= ll;
      }
      var S2 = W0 ? bu(W0) : $6;
      function io(e) {
        return typeof e == "string" || !Ml(e) && Pn(e) && eu(e) == Zn;
      }
      function $u(e) {
        return typeof e == "symbol" || Pn(e) && eu(e) == ne;
      }
      var Ht = V0 ? bu(V0) : x6;
      function C8(e) {
        return e === u;
      }
      function w8(e) {
        return Pn(e) && qn(e) == Nu;
      }
      function I8(e) {
        return Pn(e) && eu(e) == ue;
      }
      var E8 = Ji(hs), A8 = Ji(function(e, i) {
        return e <= i;
      });
      function P2(e) {
        if (!e)
          return [];
        if (du(e))
          return io(e) ? Zu(e) : su(e);
        if (xr && e[xr])
          return th(e[xr]());
        var i = qn(e), c = i == Bl ? us : i == _n ? Ei : Zt;
        return c(e);
      }
      function xe(e) {
        if (!e)
          return e === 0 ? e : 0;
        if (e = Bu(e), e === sl || e === -sl) {
          var i = e < 0 ? -1 : 1;
          return i * H;
        }
        return e === e ? e : 0;
      }
      function Ll(e) {
        var i = xe(e), c = i % 1;
        return i === i ? c ? i - c : i : 0;
      }
      function N2(e) {
        return e ? pt(Ll(e), 0, X) : 0;
      }
      function Bu(e) {
        if (typeof e == "number")
          return e;
        if ($u(e))
          return V;
        if (wn(e)) {
          var i = typeof e.valueOf == "function" ? e.valueOf() : e;
          e = wn(i) ? i + "" : i;
        }
        if (typeof e != "string")
          return e === 0 ? e : +e;
        e = Y0(e);
        var c = kl.test(e);
        return c || Cn.test(e) ? W9(e.slice(2), c ? 2 : 8) : zl.test(e) ? V : +e;
      }
      function T2(e) {
        return te(e, cu(e));
      }
      function S8(e) {
        return e ? pt(Ll(e), -ll, ll) : e === 0 ? e : 0;
      }
      function en(e) {
        return e == null ? "" : yu(e);
      }
      var P8 = Wt(function(e, i) {
        if (Or(i) || du(i)) {
          te(i, Vn(i), e);
          return;
        }
        for (var c in i)
          an.call(i, c) && Ar(e, c, i[c]);
      }), R2 = Wt(function(e, i) {
        te(i, cu(i), e);
      }), oo = Wt(function(e, i, c, h) {
        te(i, cu(i), e, h);
      }), N8 = Wt(function(e, i, c, h) {
        te(i, Vn(i), e, h);
      }), T8 = be(as);
      function R8(e, i) {
        var c = jt(e);
        return i == null ? c : s1(c, i);
      }
      var O8 = Wl(function(e, i) {
        e = cn(e);
        var c = -1, h = i.length, w = h > 2 ? i[2] : u;
        for (w && tu(i[0], i[1], w) && (h = 1); ++c < h; )
          for (var T = i[c], F = cu(T), M = -1, L = F.length; ++M < L; ) {
            var J = F[M], K = e[J];
            (K === u || zu(K, Bt[J]) && !an.call(e, J)) && (e[J] = T[J]);
          }
        return e;
      }), F8 = Wl(function(e) {
        return e.push(u, Y1), vu(O2, u, e);
      });
      function _8(e, i) {
        return H0(e, Al(i, 3), ee);
      }
      function D8(e, i) {
        return H0(e, Al(i, 3), ds);
      }
      function M8(e, i) {
        return e == null ? e : ss(e, Al(i, 3), cu);
      }
      function B8(e, i) {
        return e == null ? e : g1(e, Al(i, 3), cu);
      }
      function L8(e, i) {
        return e && ee(e, Al(i, 3));
      }
      function G8(e, i) {
        return e && ds(e, Al(i, 3));
      }
      function j8(e) {
        return e == null ? [] : Vi(e, Vn(e));
      }
      function W8(e) {
        return e == null ? [] : Vi(e, cu(e));
      }
      function Vs(e, i, c) {
        var h = e == null ? u : gt(e, i);
        return h === u ? c : h;
      }
      function V8(e, i) {
        return e != null && K1(e, i, c6);
      }
      function ks(e, i) {
        return e != null && K1(e, i, f6);
      }
      var k8 = k1(function(e, i, c) {
        i != null && typeof i.toString != "function" && (i = Ni.call(i)), e[i] = c;
      }, Zs(fu)), H8 = k1(function(e, i, c) {
        i != null && typeof i.toString != "function" && (i = Ni.call(i)), an.call(e, i) ? e[i].push(c) : e[i] = [c];
      }, Al), Z8 = Wl(Pr);
      function Vn(e) {
        return du(e) ? o1(e) : gs(e);
      }
      function cu(e) {
        return du(e) ? o1(e, !0) : C6(e);
      }
      function X8(e, i) {
        var c = {};
        return i = Al(i, 3), ee(e, function(h, w, T) {
          me(c, i(h, w, T), h);
        }), c;
      }
      function z8(e, i) {
        var c = {};
        return i = Al(i, 3), ee(e, function(h, w, T) {
          me(c, w, i(h, w, T));
        }), c;
      }
      var Y8 = Wt(function(e, i, c) {
        ki(e, i, c);
      }), O2 = Wt(function(e, i, c, h) {
        ki(e, i, c, h);
      }), U8 = be(function(e, i) {
        var c = {};
        if (e == null)
          return c;
        var h = !1;
        i = $n(i, function(T) {
          return T = We(T, e), h || (h = T.length > 1), T;
        }), te(e, Ps(e), c), h && (c = _u(c, g | m | v, k6));
        for (var w = i.length; w--; )
          $s(c, i[w]);
        return c;
      });
      function J8(e, i) {
        return F2(e, to(Al(i)));
      }
      var K8 = be(function(e, i) {
        return e == null ? {} : I6(e, i);
      });
      function F2(e, i) {
        if (e == null)
          return {};
        var c = $n(Ps(e), function(h) {
          return [h];
        });
        return i = Al(i), I1(e, c, function(h, w) {
          return i(h, w[0]);
        });
      }
      function Q8(e, i, c) {
        i = We(i, e);
        var h = -1, w = i.length;
        for (w || (w = 1, e = u); ++h < w; ) {
          var T = e == null ? u : e[re(i[h])];
          T === u && (h = w, T = c), e = $e(T) ? T.call(e) : T;
        }
        return e;
      }
      function q8(e, i, c) {
        return e == null ? e : Tr(e, i, c);
      }
      function lv(e, i, c, h) {
        return h = typeof h == "function" ? h : u, e == null ? e : Tr(e, i, c, h);
      }
      var _2 = X1(Vn), D2 = X1(cu);
      function nv(e, i, c) {
        var h = Ml(e), w = h || ke(e) || Ht(e);
        if (i = Al(i, 4), c == null) {
          var T = e && e.constructor;
          w ? c = h ? new T() : [] : wn(e) ? c = $e(T) ? jt(Oi(e)) : {} : c = {};
        }
        return (w ? Ru : ee)(e, function(F, M, L) {
          return i(c, F, M, L);
        }), c;
      }
      function uv(e, i) {
        return e == null ? !0 : $s(e, i);
      }
      function ev(e, i, c) {
        return e == null ? e : N1(e, i, ws(c));
      }
      function tv(e, i, c, h) {
        return h = typeof h == "function" ? h : u, e == null ? e : N1(e, i, ws(c), h);
      }
      function Zt(e) {
        return e == null ? [] : ns(e, Vn(e));
      }
      function rv(e) {
        return e == null ? [] : ns(e, cu(e));
      }
      function iv(e, i, c) {
        return c === u && (c = i, i = u), c !== u && (c = Bu(c), c = c === c ? c : 0), i !== u && (i = Bu(i), i = i === i ? i : 0), pt(Bu(e), i, c);
      }
      function ov(e, i, c) {
        return i = xe(i), c === u ? (c = i, i = 0) : c = xe(c), e = Bu(e), p6(e, i, c);
      }
      function av(e, i, c) {
        if (c && typeof c != "boolean" && tu(e, i, c) && (i = c = u), c === u && (typeof i == "boolean" ? (c = i, i = u) : typeof e == "boolean" && (c = e, e = u)), e === u && i === u ? (e = 0, i = 1) : (e = xe(e), i === u ? (i = e, e = 0) : i = xe(i)), e > i) {
          var h = e;
          e = i, i = h;
        }
        if (c || e % 1 || i % 1) {
          var w = r1();
          return Qn(e + w * (i - e + j9("1e-" + ((w + "").length - 1))), i);
        }
        return vs(e, i);
      }
      var sv = Vt(function(e, i, c) {
        return i = i.toLowerCase(), e + (c ? M2(i) : i);
      });
      function M2(e) {
        return Hs(en(e).toLowerCase());
      }
      function B2(e) {
        return e = en(e), e && e.replace(ou, q9).replace(T9, "");
      }
      function dv(e, i, c) {
        e = en(e), i = yu(i);
        var h = e.length;
        c = c === u ? h : pt(Ll(c), 0, h);
        var w = c;
        return c -= i.length, c >= 0 && e.slice(c, w) == i;
      }
      function cv(e) {
        return e = en(e), e && gi.test(e) ? e.replace(Rt, lh) : e;
      }
      function fv(e) {
        return e = en(e), e && $i.test(e) ? e.replace(br, "\\$&") : e;
      }
      var pv = Vt(function(e, i, c) {
        return e + (c ? "-" : "") + i.toLowerCase();
      }), gv = Vt(function(e, i, c) {
        return e + (c ? " " : "") + i.toLowerCase();
      }), hv = j1("toLowerCase");
      function mv(e, i, c) {
        e = en(e), i = Ll(i);
        var h = i ? Dt(e) : 0;
        if (!i || h >= i)
          return e;
        var w = (i - h) / 2;
        return Ui(Mi(w), c) + e + Ui(Di(w), c);
      }
      function vv(e, i, c) {
        e = en(e), i = Ll(i);
        var h = i ? Dt(e) : 0;
        return i && h < i ? e + Ui(i - h, c) : e;
      }
      function bv(e, i, c) {
        e = en(e), i = Ll(i);
        var h = i ? Dt(e) : 0;
        return i && h < i ? Ui(i - h, c) + e : e;
      }
      function yv(e, i, c) {
        return c || i == null ? i = 0 : i && (i = +i), Ah(en(e).replace(yr, ""), i || 0);
      }
      function $v(e, i, c) {
        return (c ? tu(e, i, c) : i === u) ? i = 1 : i = Ll(i), bs(en(e), i);
      }
      function xv() {
        var e = arguments, i = en(e[0]);
        return e.length < 3 ? i : i.replace(e[1], e[2]);
      }
      var Cv = Vt(function(e, i, c) {
        return e + (c ? "_" : "") + i.toLowerCase();
      });
      function wv(e, i, c) {
        return c && typeof c != "number" && tu(e, i, c) && (i = c = u), c = c === u ? X : c >>> 0, c ? (e = en(e), e && (typeof i == "string" || i != null && !Ws(i)) && (i = yu(i), !i && _t(e)) ? Ve(Zu(e), 0, c) : e.split(i, c)) : [];
      }
      var Iv = Vt(function(e, i, c) {
        return e + (c ? " " : "") + Hs(i);
      });
      function Ev(e, i, c) {
        return e = en(e), c = c == null ? 0 : pt(Ll(c), 0, e.length), i = yu(i), e.slice(c, c + i.length) == i;
      }
      function Av(e, i, c) {
        var h = N.templateSettings;
        c && tu(e, i, c) && (i = u), e = en(e), i = oo({}, i, h, z1);
        var w = oo({}, i.imports, h.imports, z1), T = Vn(w), F = ns(w, T), M, L, J = 0, K = i.interpolate || Hu, q = "__p += '", pl = es(
          (i.escape || Hu).source + "|" + K.source + "|" + (K === mi ? Ql : Hu).source + "|" + (i.evaluate || Hu).source + "|$",
          "g"
        ), bl = "//# sourceURL=" + (an.call(i, "sourceURL") ? (i.sourceURL + "").replace(/\s/g, " ") : "lodash.templateSources[" + ++D9 + "]") + `
`;
        e.replace(pl, function(Tl, Zl, Jl, xu, ru, Cu) {
          return Jl || (Jl = xu), q += e.slice(J, Cu).replace(xi, nh), Zl && (M = !0, q += `' +
__e(` + Zl + `) +
'`), ru && (L = !0, q += `';
` + ru + `;
__p += '`), Jl && (q += `' +
((__t = (` + Jl + `)) == null ? '' : __t) +
'`), J = Cu + Tl.length, Tl;
        }), q += `';
`;
        var Nl = an.call(i, "variable") && i.variable;
        if (!Nl)
          q = `with (obj) {
` + q + `
}
`;
        else if (gl.test(Nl))
          throw new Dl(d);
        q = (L ? q.replace(ku, "") : q).replace(at, "$1").replace(pi, "$1;"), q = "function(" + (Nl || "obj") + `) {
` + (Nl ? "" : `obj || (obj = {});
`) + "var __t, __p = ''" + (M ? ", __e = _.escape" : "") + (L ? `, __j = Array.prototype.join;
function print() { __p += __j.call(arguments, '') }
` : `;
`) + q + `return __p
}`;
        var jl = G2(function() {
          return ql(T, bl + "return " + q).apply(u, F);
        });
        if (jl.source = q, js(jl))
          throw jl;
        return jl;
      }
      function Sv(e) {
        return en(e).toLowerCase();
      }
      function Pv(e) {
        return en(e).toUpperCase();
      }
      function Nv(e, i, c) {
        if (e = en(e), e && (c || i === u))
          return Y0(e);
        if (!e || !(i = yu(i)))
          return e;
        var h = Zu(e), w = Zu(i), T = U0(h, w), F = J0(h, w) + 1;
        return Ve(h, T, F).join("");
      }
      function Tv(e, i, c) {
        if (e = en(e), e && (c || i === u))
          return e.slice(0, Q0(e) + 1);
        if (!e || !(i = yu(i)))
          return e;
        var h = Zu(e), w = J0(h, Zu(i)) + 1;
        return Ve(h, 0, w).join("");
      }
      function Rv(e, i, c) {
        if (e = en(e), e && (c || i === u))
          return e.replace(yr, "");
        if (!e || !(i = yu(i)))
          return e;
        var h = Zu(e), w = U0(h, Zu(i));
        return Ve(h, w).join("");
      }
      function Ov(e, i) {
        var c = Y, h = el;
        if (wn(i)) {
          var w = "separator" in i ? i.separator : w;
          c = "length" in i ? Ll(i.length) : c, h = "omission" in i ? yu(i.omission) : h;
        }
        e = en(e);
        var T = e.length;
        if (_t(e)) {
          var F = Zu(e);
          T = F.length;
        }
        if (c >= T)
          return e;
        var M = c - Dt(h);
        if (M < 1)
          return h;
        var L = F ? Ve(F, 0, M).join("") : e.slice(0, M);
        if (w === u)
          return L + h;
        if (F && (M += L.length - M), Ws(w)) {
          if (e.slice(M).search(w)) {
            var J, K = L;
            for (w.global || (w = es(w.source, en(un.exec(w)) + "g")), w.lastIndex = 0; J = w.exec(K); )
              var q = J.index;
            L = L.slice(0, q === u ? M : q);
          }
        } else if (e.indexOf(yu(w), M) != M) {
          var pl = L.lastIndexOf(w);
          pl > -1 && (L = L.slice(0, pl));
        }
        return L + h;
      }
      function Fv(e) {
        return e = en(e), e && vr.test(e) ? e.replace(pe, ah) : e;
      }
      var _v = Vt(function(e, i, c) {
        return e + (c ? " " : "") + i.toUpperCase();
      }), Hs = j1("toUpperCase");
      function L2(e, i, c) {
        return e = en(e), i = c ? u : i, i === u ? eh(e) ? ch(e) : Y9(e) : e.match(i) || [];
      }
      var G2 = Wl(function(e, i) {
        try {
          return vu(e, u, i);
        } catch (c) {
          return js(c) ? c : new Dl(c);
        }
      }), Dv = be(function(e, i) {
        return Ru(i, function(c) {
          c = re(c), me(e, c, Ls(e[c], e));
        }), e;
      });
      function Mv(e) {
        var i = e == null ? 0 : e.length, c = Al();
        return e = i ? $n(e, function(h) {
          if (typeof h[1] != "function")
            throw new Ou(s);
          return [c(h[0]), h[1]];
        }) : [], Wl(function(h) {
          for (var w = -1; ++w < i; ) {
            var T = e[w];
            if (vu(T[0], this, h))
              return vu(T[1], this, h);
          }
        });
      }
      function Bv(e) {
        return a6(_u(e, g));
      }
      function Zs(e) {
        return function() {
          return e;
        };
      }
      function Lv(e, i) {
        return e == null || e !== e ? i : e;
      }
      var Gv = V1(), jv = V1(!0);
      function fu(e) {
        return e;
      }
      function Xs(e) {
        return b1(typeof e == "function" ? e : _u(e, g));
      }
      function Wv(e) {
        return $1(_u(e, g));
      }
      function Vv(e, i) {
        return x1(e, _u(i, g));
      }
      var kv = Wl(function(e, i) {
        return function(c) {
          return Pr(c, e, i);
        };
      }), Hv = Wl(function(e, i) {
        return function(c) {
          return Pr(e, c, i);
        };
      });
      function zs(e, i, c) {
        var h = Vn(i), w = Vi(i, h);
        c == null && !(wn(i) && (w.length || !h.length)) && (c = i, i = e, e = this, w = Vi(i, Vn(i)));
        var T = !(wn(c) && "chain" in c) || !!c.chain, F = $e(e);
        return Ru(w, function(M) {
          var L = i[M];
          e[M] = L, F && (e.prototype[M] = function() {
            var J = this.__chain__;
            if (T || J) {
              var K = e(this.__wrapped__), q = K.__actions__ = su(this.__actions__);
              return q.push({ func: L, args: arguments, thisArg: e }), K.__chain__ = J, K;
            }
            return L.apply(e, Me([this.value()], arguments));
          });
        }), e;
      }
      function Zv() {
        return zn._ === this && (zn._ = vh), this;
      }
      function Ys() {
      }
      function Xv(e) {
        return e = Ll(e), Wl(function(i) {
          return C1(i, e);
        });
      }
      var zv = Es($n), Yv = Es(k0), Uv = Es(Ja);
      function j2(e) {
        return Os(e) ? Ka(re(e)) : E6(e);
      }
      function Jv(e) {
        return function(i) {
          return e == null ? u : gt(e, i);
        };
      }
      var Kv = H1(), Qv = H1(!0);
      function Us() {
        return [];
      }
      function Js() {
        return !1;
      }
      function qv() {
        return {};
      }
      function lb() {
        return "";
      }
      function nb() {
        return !0;
      }
      function ub(e, i) {
        if (e = Ll(e), e < 1 || e > ll)
          return [];
        var c = X, h = Qn(e, X);
        i = Al(i), e -= X;
        for (var w = ls(h, i); ++c < e; )
          i(c);
        return w;
      }
      function eb(e) {
        return Ml(e) ? $n(e, re) : $u(e) ? [e] : su(i2(en(e)));
      }
      function tb(e) {
        var i = ++hh;
        return en(e) + i;
      }
      var rb = Yi(function(e, i) {
        return e + i;
      }, 0), ib = As("ceil"), ob = Yi(function(e, i) {
        return e / i;
      }, 1), ab = As("floor");
      function sb(e) {
        return e && e.length ? Wi(e, fu, cs) : u;
      }
      function db(e, i) {
        return e && e.length ? Wi(e, Al(i, 2), cs) : u;
      }
      function cb(e) {
        return X0(e, fu);
      }
      function fb(e, i) {
        return X0(e, Al(i, 2));
      }
      function pb(e) {
        return e && e.length ? Wi(e, fu, hs) : u;
      }
      function gb(e, i) {
        return e && e.length ? Wi(e, Al(i, 2), hs) : u;
      }
      var hb = Yi(function(e, i) {
        return e * i;
      }, 1), mb = As("round"), vb = Yi(function(e, i) {
        return e - i;
      }, 0);
      function bb(e) {
        return e && e.length ? qa(e, fu) : 0;
      }
      function yb(e, i) {
        return e && e.length ? qa(e, Al(i, 2)) : 0;
      }
      return N.after = W7, N.ary = v2, N.assign = P8, N.assignIn = R2, N.assignInWith = oo, N.assignWith = N8, N.at = T8, N.before = b2, N.bind = Ls, N.bindAll = Dv, N.bindKey = y2, N.castArray = q7, N.chain = g2, N.chunk = am, N.compact = sm, N.concat = dm, N.cond = Mv, N.conforms = Bv, N.constant = Zs, N.countBy = b7, N.create = R8, N.curry = $2, N.curryRight = x2, N.debounce = C2, N.defaults = O8, N.defaultsDeep = F8, N.defer = V7, N.delay = k7, N.difference = cm, N.differenceBy = fm, N.differenceWith = pm, N.drop = gm, N.dropRight = hm, N.dropRightWhile = mm, N.dropWhile = vm, N.fill = bm, N.filter = $7, N.flatMap = w7, N.flatMapDeep = I7, N.flatMapDepth = E7, N.flatten = d2, N.flattenDeep = ym, N.flattenDepth = $m, N.flip = H7, N.flow = Gv, N.flowRight = jv, N.fromPairs = xm, N.functions = j8, N.functionsIn = W8, N.groupBy = A7, N.initial = wm, N.intersection = Im, N.intersectionBy = Em, N.intersectionWith = Am, N.invert = k8, N.invertBy = H8, N.invokeMap = P7, N.iteratee = Xs, N.keyBy = N7, N.keys = Vn, N.keysIn = cu, N.map = no, N.mapKeys = X8, N.mapValues = z8, N.matches = Wv, N.matchesProperty = Vv, N.memoize = eo, N.merge = Y8, N.mergeWith = O2, N.method = kv, N.methodOf = Hv, N.mixin = zs, N.negate = to, N.nthArg = Xv, N.omit = U8, N.omitBy = J8, N.once = Z7, N.orderBy = T7, N.over = zv, N.overArgs = X7, N.overEvery = Yv, N.overSome = Uv, N.partial = Gs, N.partialRight = w2, N.partition = R7, N.pick = K8, N.pickBy = F2, N.property = j2, N.propertyOf = Jv, N.pull = Tm, N.pullAll = f2, N.pullAllBy = Rm, N.pullAllWith = Om, N.pullAt = Fm, N.range = Kv, N.rangeRight = Qv, N.rearg = z7, N.reject = _7, N.remove = _m, N.rest = Y7, N.reverse = Ms, N.sampleSize = M7, N.set = q8, N.setWith = lv, N.shuffle = B7, N.slice = Dm, N.sortBy = j7, N.sortedUniq = Vm, N.sortedUniqBy = km, N.split = wv, N.spread = U7, N.tail = Hm, N.take = Zm, N.takeRight = Xm, N.takeRightWhile = zm, N.takeWhile = Ym, N.tap = s7, N.throttle = J7, N.thru = lo, N.toArray = P2, N.toPairs = _2, N.toPairsIn = D2, N.toPath = eb, N.toPlainObject = T2, N.transform = nv, N.unary = K7, N.union = Um, N.unionBy = Jm, N.unionWith = Km, N.uniq = Qm, N.uniqBy = qm, N.uniqWith = l7, N.unset = uv, N.unzip = Bs, N.unzipWith = p2, N.update = ev, N.updateWith = tv, N.values = Zt, N.valuesIn = rv, N.without = n7, N.words = L2, N.wrap = Q7, N.xor = u7, N.xorBy = e7, N.xorWith = t7, N.zip = r7, N.zipObject = i7, N.zipObjectDeep = o7, N.zipWith = a7, N.entries = _2, N.entriesIn = D2, N.extend = R2, N.extendWith = oo, zs(N, N), N.add = rb, N.attempt = G2, N.camelCase = sv, N.capitalize = M2, N.ceil = ib, N.clamp = iv, N.clone = l8, N.cloneDeep = u8, N.cloneDeepWith = e8, N.cloneWith = n8, N.conformsTo = t8, N.deburr = B2, N.defaultTo = Lv, N.divide = ob, N.endsWith = dv, N.eq = zu, N.escape = cv, N.escapeRegExp = fv, N.every = y7, N.find = x7, N.findIndex = a2, N.findKey = _8, N.findLast = C7, N.findLastIndex = s2, N.findLastKey = D8, N.floor = ab, N.forEach = h2, N.forEachRight = m2, N.forIn = M8, N.forInRight = B8, N.forOwn = L8, N.forOwnRight = G8, N.get = Vs, N.gt = r8, N.gte = i8, N.has = V8, N.hasIn = ks, N.head = c2, N.identity = fu, N.includes = S7, N.indexOf = Cm, N.inRange = ov, N.invoke = Z8, N.isArguments = vt, N.isArray = Ml, N.isArrayBuffer = o8, N.isArrayLike = du, N.isArrayLikeObject = Tn, N.isBoolean = a8, N.isBuffer = ke, N.isDate = s8, N.isElement = d8, N.isEmpty = c8, N.isEqual = f8, N.isEqualWith = p8, N.isError = js, N.isFinite = g8, N.isFunction = $e, N.isInteger = I2, N.isLength = ro, N.isMap = E2, N.isMatch = h8, N.isMatchWith = m8, N.isNaN = v8, N.isNative = b8, N.isNil = $8, N.isNull = y8, N.isNumber = A2, N.isObject = wn, N.isObjectLike = Pn, N.isPlainObject = _r, N.isRegExp = Ws, N.isSafeInteger = x8, N.isSet = S2, N.isString = io, N.isSymbol = $u, N.isTypedArray = Ht, N.isUndefined = C8, N.isWeakMap = w8, N.isWeakSet = I8, N.join = Sm, N.kebabCase = pv, N.last = Mu, N.lastIndexOf = Pm, N.lowerCase = gv, N.lowerFirst = hv, N.lt = E8, N.lte = A8, N.max = sb, N.maxBy = db, N.mean = cb, N.meanBy = fb, N.min = pb, N.minBy = gb, N.stubArray = Us, N.stubFalse = Js, N.stubObject = qv, N.stubString = lb, N.stubTrue = nb, N.multiply = hb, N.nth = Nm, N.noConflict = Zv, N.noop = Ys, N.now = uo, N.pad = mv, N.padEnd = vv, N.padStart = bv, N.parseInt = yv, N.random = av, N.reduce = O7, N.reduceRight = F7, N.repeat = $v, N.replace = xv, N.result = Q8, N.round = mb, N.runInContext = B, N.sample = D7, N.size = L7, N.snakeCase = Cv, N.some = G7, N.sortedIndex = Mm, N.sortedIndexBy = Bm, N.sortedIndexOf = Lm, N.sortedLastIndex = Gm, N.sortedLastIndexBy = jm, N.sortedLastIndexOf = Wm, N.startCase = Iv, N.startsWith = Ev, N.subtract = vb, N.sum = bb, N.sumBy = yb, N.template = Av, N.times = ub, N.toFinite = xe, N.toInteger = Ll, N.toLength = N2, N.toLower = Sv, N.toNumber = Bu, N.toSafeInteger = S8, N.toString = en, N.toUpper = Pv, N.trim = Nv, N.trimEnd = Tv, N.trimStart = Rv, N.truncate = Ov, N.unescape = Fv, N.uniqueId = tb, N.upperCase = _v, N.upperFirst = Hs, N.each = h2, N.eachRight = m2, N.first = c2, zs(N, function() {
        var e = {};
        return ee(N, function(i, c) {
          an.call(N.prototype, c) || (e[c] = i);
        }), e;
      }(), { chain: !1 }), N.VERSION = t, Ru(["bind", "bindKey", "curry", "curryRight", "partial", "partialRight"], function(e) {
        N[e].placeholder = N;
      }), Ru(["drop", "take"], function(e, i) {
        Yl.prototype[e] = function(c) {
          c = c === u ? 1 : Wn(Ll(c), 0);
          var h = this.__filtered__ && !i ? new Yl(this) : this.clone();
          return h.__filtered__ ? h.__takeCount__ = Qn(c, h.__takeCount__) : h.__views__.push({
            size: Qn(c, X),
            type: e + (h.__dir__ < 0 ? "Right" : "")
          }), h;
        }, Yl.prototype[e + "Right"] = function(c) {
          return this.reverse()[e](c).reverse();
        };
      }), Ru(["filter", "map", "takeWhile"], function(e, i) {
        var c = i + 1, h = c == il || c == tl;
        Yl.prototype[e] = function(w) {
          var T = this.clone();
          return T.__iteratees__.push({
            iteratee: Al(w, 3),
            type: c
          }), T.__filtered__ = T.__filtered__ || h, T;
        };
      }), Ru(["head", "last"], function(e, i) {
        var c = "take" + (i ? "Right" : "");
        Yl.prototype[e] = function() {
          return this[c](1).value()[0];
        };
      }), Ru(["initial", "tail"], function(e, i) {
        var c = "drop" + (i ? "" : "Right");
        Yl.prototype[e] = function() {
          return this.__filtered__ ? new Yl(this) : this[c](1);
        };
      }), Yl.prototype.compact = function() {
        return this.filter(fu);
      }, Yl.prototype.find = function(e) {
        return this.filter(e).head();
      }, Yl.prototype.findLast = function(e) {
        return this.reverse().find(e);
      }, Yl.prototype.invokeMap = Wl(function(e, i) {
        return typeof e == "function" ? new Yl(this) : this.map(function(c) {
          return Pr(c, e, i);
        });
      }), Yl.prototype.reject = function(e) {
        return this.filter(to(Al(e)));
      }, Yl.prototype.slice = function(e, i) {
        e = Ll(e);
        var c = this;
        return c.__filtered__ && (e > 0 || i < 0) ? new Yl(c) : (e < 0 ? c = c.takeRight(-e) : e && (c = c.drop(e)), i !== u && (i = Ll(i), c = i < 0 ? c.dropRight(-i) : c.take(i - e)), c);
      }, Yl.prototype.takeRightWhile = function(e) {
        return this.reverse().takeWhile(e).reverse();
      }, Yl.prototype.toArray = function() {
        return this.take(X);
      }, ee(Yl.prototype, function(e, i) {
        var c = /^(?:filter|find|map|reject)|While$/.test(i), h = /^(?:head|last)$/.test(i), w = N[h ? "take" + (i == "last" ? "Right" : "") : i], T = h || /^find/.test(i);
        w && (N.prototype[i] = function() {
          var F = this.__wrapped__, M = h ? [1] : arguments, L = F instanceof Yl, J = M[0], K = L || Ml(F), q = function(Zl) {
            var Jl = w.apply(N, Me([Zl], M));
            return h && pl ? Jl[0] : Jl;
          };
          K && c && typeof J == "function" && J.length != 1 && (L = K = !1);
          var pl = this.__chain__, bl = !!this.__actions__.length, Nl = T && !pl, jl = L && !bl;
          if (!T && K) {
            F = jl ? F : new Yl(this);
            var Tl = e.apply(F, M);
            return Tl.__actions__.push({ func: lo, args: [q], thisArg: u }), new Fu(Tl, pl);
          }
          return Nl && jl ? e.apply(this, M) : (Tl = this.thru(q), Nl ? h ? Tl.value()[0] : Tl.value() : Tl);
        });
      }), Ru(["pop", "push", "shift", "sort", "splice", "unshift"], function(e) {
        var i = Ai[e], c = /^(?:push|sort|unshift)$/.test(e) ? "tap" : "thru", h = /^(?:pop|shift)$/.test(e);
        N.prototype[e] = function() {
          var w = arguments;
          if (h && !this.__chain__) {
            var T = this.value();
            return i.apply(Ml(T) ? T : [], w);
          }
          return this[c](function(F) {
            return i.apply(Ml(F) ? F : [], w);
          });
        };
      }), ee(Yl.prototype, function(e, i) {
        var c = N[i];
        if (c) {
          var h = c.name + "";
          an.call(Gt, h) || (Gt[h] = []), Gt[h].push({ name: i, func: c });
        }
      }), Gt[zi(u, S).name] = [{
        name: "wrapper",
        func: u
      }], Yl.prototype.clone = Fh, Yl.prototype.reverse = _h, Yl.prototype.value = Dh, N.prototype.at = d7, N.prototype.chain = c7, N.prototype.commit = f7, N.prototype.next = p7, N.prototype.plant = h7, N.prototype.reverse = m7, N.prototype.toJSON = N.prototype.valueOf = N.prototype.value = v7, N.prototype.first = N.prototype.head, xr && (N.prototype[xr] = g7), N;
    }, Mt = fh();
    st ? ((st.exports = Mt)._ = Mt, Xa._ = Mt) : zn._ = Mt;
  }).call(Jn);
})(Mo, Mo.exports);
var M3 = Mo.exports;
const ie = /* @__PURE__ */ ia(M3), cc = "-";
function Nb(l) {
  const n = Rb(l), {
    conflictingClassGroups: u,
    conflictingClassGroupModifiers: t
  } = l;
  function r(s) {
    const d = s.split(cc);
    return d[0] === "" && d.length !== 1 && d.shift(), B3(d, n) || Tb(s);
  }
  function o(s, d) {
    const a = u[s] || [];
    return d && t[s] ? [...a, ...t[s]] : a;
  }
  return {
    getClassGroupId: r,
    getConflictingClassGroupIds: o
  };
}
function B3(l, n) {
  var s;
  if (l.length === 0)
    return n.classGroupId;
  const u = l[0], t = n.nextPart.get(u), r = t ? B3(l.slice(1), t) : void 0;
  if (r)
    return r;
  if (n.validators.length === 0)
    return;
  const o = l.join(cc);
  return (s = n.validators.find(({
    validator: d
  }) => d(o))) == null ? void 0 : s.classGroupId;
}
const H2 = /^\[(.+)\]$/;
function Tb(l) {
  if (H2.test(l)) {
    const n = H2.exec(l)[1], u = n == null ? void 0 : n.substring(0, n.indexOf(":"));
    if (u)
      return "arbitrary.." + u;
  }
}
function Rb(l) {
  const {
    theme: n,
    prefix: u
  } = l, t = {
    nextPart: /* @__PURE__ */ new Map(),
    validators: []
  };
  return Fb(Object.entries(l.classGroups), u).forEach(([o, s]) => {
    yd(s, t, o, n);
  }), t;
}
function yd(l, n, u, t) {
  l.forEach((r) => {
    if (typeof r == "string") {
      const o = r === "" ? n : Z2(n, r);
      o.classGroupId = u;
      return;
    }
    if (typeof r == "function") {
      if (Ob(r)) {
        yd(r(t), n, u, t);
        return;
      }
      n.validators.push({
        validator: r,
        classGroupId: u
      });
      return;
    }
    Object.entries(r).forEach(([o, s]) => {
      yd(s, Z2(n, o), u, t);
    });
  });
}
function Z2(l, n) {
  let u = l;
  return n.split(cc).forEach((t) => {
    u.nextPart.has(t) || u.nextPart.set(t, {
      nextPart: /* @__PURE__ */ new Map(),
      validators: []
    }), u = u.nextPart.get(t);
  }), u;
}
function Ob(l) {
  return l.isThemeGetter;
}
function Fb(l, n) {
  return n ? l.map(([u, t]) => {
    const r = t.map((o) => typeof o == "string" ? n + o : typeof o == "object" ? Object.fromEntries(Object.entries(o).map(([s, d]) => [n + s, d])) : o);
    return [u, r];
  }) : l;
}
function _b(l) {
  if (l < 1)
    return {
      get: () => {
      },
      set: () => {
      }
    };
  let n = 0, u = /* @__PURE__ */ new Map(), t = /* @__PURE__ */ new Map();
  function r(o, s) {
    u.set(o, s), n++, n > l && (n = 0, t = u, u = /* @__PURE__ */ new Map());
  }
  return {
    get(o) {
      let s = u.get(o);
      if (s !== void 0)
        return s;
      if ((s = t.get(o)) !== void 0)
        return r(o, s), s;
    },
    set(o, s) {
      u.has(o) ? u.set(o, s) : r(o, s);
    }
  };
}
const L3 = "!";
function Db(l) {
  const n = l.separator, u = n.length === 1, t = n[0], r = n.length;
  return function(s) {
    const d = [];
    let a = 0, f = 0, p;
    for (let b = 0; b < s.length; b++) {
      let E = s[b];
      if (a === 0) {
        if (E === t && (u || s.slice(b, b + r) === n)) {
          d.push(s.slice(f, b)), f = b + r;
          continue;
        }
        if (E === "/") {
          p = b;
          continue;
        }
      }
      E === "[" ? a++ : E === "]" && a--;
    }
    const g = d.length === 0 ? s : s.substring(f), m = g.startsWith(L3), v = m ? g.substring(1) : g, $ = p && p > f ? p - f : void 0;
    return {
      modifiers: d,
      hasImportantModifier: m,
      baseClassName: v,
      maybePostfixModifierPosition: $
    };
  };
}
function Mb(l) {
  if (l.length <= 1)
    return l;
  const n = [];
  let u = [];
  return l.forEach((t) => {
    t[0] === "[" ? (n.push(...u.sort(), t), u = []) : u.push(t);
  }), n.push(...u.sort()), n;
}
function Bb(l) {
  return {
    cache: _b(l.cacheSize),
    splitModifiers: Db(l),
    ...Nb(l)
  };
}
const Lb = /\s+/;
function Gb(l, n) {
  const {
    splitModifiers: u,
    getClassGroupId: t,
    getConflictingClassGroupIds: r
  } = n, o = /* @__PURE__ */ new Set();
  return l.trim().split(Lb).map((s) => {
    const {
      modifiers: d,
      hasImportantModifier: a,
      baseClassName: f,
      maybePostfixModifierPosition: p
    } = u(s);
    let g = t(p ? f.substring(0, p) : f), m = !!p;
    if (!g) {
      if (!p)
        return {
          isTailwindClass: !1,
          originalClassName: s
        };
      if (g = t(f), !g)
        return {
          isTailwindClass: !1,
          originalClassName: s
        };
      m = !1;
    }
    const v = Mb(d).join(":");
    return {
      isTailwindClass: !0,
      modifierId: a ? v + L3 : v,
      classGroupId: g,
      originalClassName: s,
      hasPostfixModifier: m
    };
  }).reverse().filter((s) => {
    if (!s.isTailwindClass)
      return !0;
    const {
      modifierId: d,
      classGroupId: a,
      hasPostfixModifier: f
    } = s, p = d + a;
    return o.has(p) ? !1 : (o.add(p), r(a, f).forEach((g) => o.add(d + g)), !0);
  }).reverse().map((s) => s.originalClassName).join(" ");
}
function jb() {
  let l = 0, n, u, t = "";
  for (; l < arguments.length; )
    (n = arguments[l++]) && (u = G3(n)) && (t && (t += " "), t += u);
  return t;
}
function G3(l) {
  if (typeof l == "string")
    return l;
  let n, u = "";
  for (let t = 0; t < l.length; t++)
    l[t] && (n = G3(l[t])) && (u && (u += " "), u += n);
  return u;
}
function Wb(l, ...n) {
  let u, t, r, o = s;
  function s(a) {
    const f = n.reduce((p, g) => g(p), l());
    return u = Bb(f), t = u.cache.get, r = u.cache.set, o = d, d(a);
  }
  function d(a) {
    const f = t(a);
    if (f)
      return f;
    const p = Gb(a, u);
    return r(a, p), p;
  }
  return function() {
    return o(jb.apply(null, arguments));
  };
}
function mn(l) {
  const n = (u) => u[l] || [];
  return n.isThemeGetter = !0, n;
}
const j3 = /^\[(?:([a-z-]+):)?(.+)\]$/i, Vb = /^\d+\/\d+$/, kb = /* @__PURE__ */ new Set(["px", "full", "screen"]), Hb = /^(\d+(\.\d+)?)?(xs|sm|md|lg|xl)$/, Zb = /\d+(%|px|r?em|[sdl]?v([hwib]|min|max)|pt|pc|in|cm|mm|cap|ch|ex|r?lh|cq(w|h|i|b|min|max))|\b(calc|min|max|clamp)\(.+\)|^0$/, Xb = /^(rgba?|hsla?|hwb|(ok)?(lab|lch))\(.+\)$/, zb = /^(inset_)?-?((\d+)?\.?(\d+)[a-z]+|0)_-?((\d+)?\.?(\d+)[a-z]+|0)/, Yb = /^(url|image|image-set|cross-fade|element|(repeating-)?(linear|radial|conic)-gradient)\(.+\)$/;
function we(l) {
  return xt(l) || kb.has(l) || Vb.test(l);
}
function He(l) {
  return ar(l, "length", uy);
}
function xt(l) {
  return !!l && !Number.isNaN(Number(l));
}
function ao(l) {
  return ar(l, "number", xt);
}
function Br(l) {
  return !!l && Number.isInteger(Number(l));
}
function Ub(l) {
  return l.endsWith("%") && xt(l.slice(0, -1));
}
function Gl(l) {
  return j3.test(l);
}
function Ze(l) {
  return Hb.test(l);
}
const Jb = /* @__PURE__ */ new Set(["length", "size", "percentage"]);
function Kb(l) {
  return ar(l, Jb, W3);
}
function Qb(l) {
  return ar(l, "position", W3);
}
const qb = /* @__PURE__ */ new Set(["image", "url"]);
function ly(l) {
  return ar(l, qb, ty);
}
function ny(l) {
  return ar(l, "", ey);
}
function Lr() {
  return !0;
}
function ar(l, n, u) {
  const t = j3.exec(l);
  return t ? t[1] ? typeof n == "string" ? t[1] === n : n.has(t[1]) : u(t[2]) : !1;
}
function uy(l) {
  return Zb.test(l) && !Xb.test(l);
}
function W3() {
  return !1;
}
function ey(l) {
  return zb.test(l);
}
function ty(l) {
  return Yb.test(l);
}
function ry() {
  const l = mn("colors"), n = mn("spacing"), u = mn("blur"), t = mn("brightness"), r = mn("borderColor"), o = mn("borderRadius"), s = mn("borderSpacing"), d = mn("borderWidth"), a = mn("contrast"), f = mn("grayscale"), p = mn("hueRotate"), g = mn("invert"), m = mn("gap"), v = mn("gradientColorStops"), $ = mn("gradientColorStopPositions"), b = mn("inset"), E = mn("margin"), S = mn("opacity"), A = mn("padding"), x = mn("saturate"), I = mn("scale"), P = mn("sepia"), O = mn("skew"), _ = mn("space"), j = mn("translate"), z = () => ["auto", "contain", "none"], Y = () => ["auto", "hidden", "clip", "visible", "scroll"], el = () => ["auto", Gl, n], U = () => [Gl, n], ul = () => ["", we, He], il = () => ["auto", xt, Gl], rl = () => ["bottom", "center", "left", "left-bottom", "left-top", "right", "right-bottom", "right-top", "top"], tl = () => ["solid", "dashed", "dotted", "double", "none"], sl = () => ["normal", "multiply", "screen", "overlay", "darken", "lighten", "color-dodge", "color-burn", "hard-light", "soft-light", "difference", "exclusion", "hue", "saturation", "color", "luminosity", "plus-lighter"], ll = () => ["start", "end", "center", "between", "around", "evenly", "stretch"], H = () => ["", "0", Gl], V = () => ["auto", "avoid", "all", "avoid-page", "page", "left", "right", "column"], X = () => [xt, ao], dl = () => [xt, Gl];
  return {
    cacheSize: 500,
    separator: ":",
    theme: {
      colors: [Lr],
      spacing: [we, He],
      blur: ["none", "", Ze, Gl],
      brightness: X(),
      borderColor: [l],
      borderRadius: ["none", "", "full", Ze, Gl],
      borderSpacing: U(),
      borderWidth: ul(),
      contrast: X(),
      grayscale: H(),
      hueRotate: dl(),
      invert: H(),
      gap: U(),
      gradientColorStops: [l],
      gradientColorStopPositions: [Ub, He],
      inset: el(),
      margin: el(),
      opacity: X(),
      padding: U(),
      saturate: X(),
      scale: X(),
      sepia: H(),
      skew: dl(),
      space: U(),
      translate: U()
    },
    classGroups: {
      // Layout
      /**
       * Aspect Ratio
       * @see https://tailwindcss.com/docs/aspect-ratio
       */
      aspect: [{
        aspect: ["auto", "square", "video", Gl]
      }],
      /**
       * Container
       * @see https://tailwindcss.com/docs/container
       */
      container: ["container"],
      /**
       * Columns
       * @see https://tailwindcss.com/docs/columns
       */
      columns: [{
        columns: [Ze]
      }],
      /**
       * Break After
       * @see https://tailwindcss.com/docs/break-after
       */
      "break-after": [{
        "break-after": V()
      }],
      /**
       * Break Before
       * @see https://tailwindcss.com/docs/break-before
       */
      "break-before": [{
        "break-before": V()
      }],
      /**
       * Break Inside
       * @see https://tailwindcss.com/docs/break-inside
       */
      "break-inside": [{
        "break-inside": ["auto", "avoid", "avoid-page", "avoid-column"]
      }],
      /**
       * Box Decoration Break
       * @see https://tailwindcss.com/docs/box-decoration-break
       */
      "box-decoration": [{
        "box-decoration": ["slice", "clone"]
      }],
      /**
       * Box Sizing
       * @see https://tailwindcss.com/docs/box-sizing
       */
      box: [{
        box: ["border", "content"]
      }],
      /**
       * Display
       * @see https://tailwindcss.com/docs/display
       */
      display: ["block", "inline-block", "inline", "flex", "inline-flex", "table", "inline-table", "table-caption", "table-cell", "table-column", "table-column-group", "table-footer-group", "table-header-group", "table-row-group", "table-row", "flow-root", "grid", "inline-grid", "contents", "list-item", "hidden"],
      /**
       * Floats
       * @see https://tailwindcss.com/docs/float
       */
      float: [{
        float: ["right", "left", "none", "start", "end"]
      }],
      /**
       * Clear
       * @see https://tailwindcss.com/docs/clear
       */
      clear: [{
        clear: ["left", "right", "both", "none", "start", "end"]
      }],
      /**
       * Isolation
       * @see https://tailwindcss.com/docs/isolation
       */
      isolation: ["isolate", "isolation-auto"],
      /**
       * Object Fit
       * @see https://tailwindcss.com/docs/object-fit
       */
      "object-fit": [{
        object: ["contain", "cover", "fill", "none", "scale-down"]
      }],
      /**
       * Object Position
       * @see https://tailwindcss.com/docs/object-position
       */
      "object-position": [{
        object: [...rl(), Gl]
      }],
      /**
       * Overflow
       * @see https://tailwindcss.com/docs/overflow
       */
      overflow: [{
        overflow: Y()
      }],
      /**
       * Overflow X
       * @see https://tailwindcss.com/docs/overflow
       */
      "overflow-x": [{
        "overflow-x": Y()
      }],
      /**
       * Overflow Y
       * @see https://tailwindcss.com/docs/overflow
       */
      "overflow-y": [{
        "overflow-y": Y()
      }],
      /**
       * Overscroll Behavior
       * @see https://tailwindcss.com/docs/overscroll-behavior
       */
      overscroll: [{
        overscroll: z()
      }],
      /**
       * Overscroll Behavior X
       * @see https://tailwindcss.com/docs/overscroll-behavior
       */
      "overscroll-x": [{
        "overscroll-x": z()
      }],
      /**
       * Overscroll Behavior Y
       * @see https://tailwindcss.com/docs/overscroll-behavior
       */
      "overscroll-y": [{
        "overscroll-y": z()
      }],
      /**
       * Position
       * @see https://tailwindcss.com/docs/position
       */
      position: ["static", "fixed", "absolute", "relative", "sticky"],
      /**
       * Top / Right / Bottom / Left
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      inset: [{
        inset: [b]
      }],
      /**
       * Right / Left
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      "inset-x": [{
        "inset-x": [b]
      }],
      /**
       * Top / Bottom
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      "inset-y": [{
        "inset-y": [b]
      }],
      /**
       * Start
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      start: [{
        start: [b]
      }],
      /**
       * End
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      end: [{
        end: [b]
      }],
      /**
       * Top
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      top: [{
        top: [b]
      }],
      /**
       * Right
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      right: [{
        right: [b]
      }],
      /**
       * Bottom
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      bottom: [{
        bottom: [b]
      }],
      /**
       * Left
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      left: [{
        left: [b]
      }],
      /**
       * Visibility
       * @see https://tailwindcss.com/docs/visibility
       */
      visibility: ["visible", "invisible", "collapse"],
      /**
       * Z-Index
       * @see https://tailwindcss.com/docs/z-index
       */
      z: [{
        z: ["auto", Br, Gl]
      }],
      // Flexbox and Grid
      /**
       * Flex Basis
       * @see https://tailwindcss.com/docs/flex-basis
       */
      basis: [{
        basis: el()
      }],
      /**
       * Flex Direction
       * @see https://tailwindcss.com/docs/flex-direction
       */
      "flex-direction": [{
        flex: ["row", "row-reverse", "col", "col-reverse"]
      }],
      /**
       * Flex Wrap
       * @see https://tailwindcss.com/docs/flex-wrap
       */
      "flex-wrap": [{
        flex: ["wrap", "wrap-reverse", "nowrap"]
      }],
      /**
       * Flex
       * @see https://tailwindcss.com/docs/flex
       */
      flex: [{
        flex: ["1", "auto", "initial", "none", Gl]
      }],
      /**
       * Flex Grow
       * @see https://tailwindcss.com/docs/flex-grow
       */
      grow: [{
        grow: H()
      }],
      /**
       * Flex Shrink
       * @see https://tailwindcss.com/docs/flex-shrink
       */
      shrink: [{
        shrink: H()
      }],
      /**
       * Order
       * @see https://tailwindcss.com/docs/order
       */
      order: [{
        order: ["first", "last", "none", Br, Gl]
      }],
      /**
       * Grid Template Columns
       * @see https://tailwindcss.com/docs/grid-template-columns
       */
      "grid-cols": [{
        "grid-cols": [Lr]
      }],
      /**
       * Grid Column Start / End
       * @see https://tailwindcss.com/docs/grid-column
       */
      "col-start-end": [{
        col: ["auto", {
          span: ["full", Br, Gl]
        }, Gl]
      }],
      /**
       * Grid Column Start
       * @see https://tailwindcss.com/docs/grid-column
       */
      "col-start": [{
        "col-start": il()
      }],
      /**
       * Grid Column End
       * @see https://tailwindcss.com/docs/grid-column
       */
      "col-end": [{
        "col-end": il()
      }],
      /**
       * Grid Template Rows
       * @see https://tailwindcss.com/docs/grid-template-rows
       */
      "grid-rows": [{
        "grid-rows": [Lr]
      }],
      /**
       * Grid Row Start / End
       * @see https://tailwindcss.com/docs/grid-row
       */
      "row-start-end": [{
        row: ["auto", {
          span: [Br, Gl]
        }, Gl]
      }],
      /**
       * Grid Row Start
       * @see https://tailwindcss.com/docs/grid-row
       */
      "row-start": [{
        "row-start": il()
      }],
      /**
       * Grid Row End
       * @see https://tailwindcss.com/docs/grid-row
       */
      "row-end": [{
        "row-end": il()
      }],
      /**
       * Grid Auto Flow
       * @see https://tailwindcss.com/docs/grid-auto-flow
       */
      "grid-flow": [{
        "grid-flow": ["row", "col", "dense", "row-dense", "col-dense"]
      }],
      /**
       * Grid Auto Columns
       * @see https://tailwindcss.com/docs/grid-auto-columns
       */
      "auto-cols": [{
        "auto-cols": ["auto", "min", "max", "fr", Gl]
      }],
      /**
       * Grid Auto Rows
       * @see https://tailwindcss.com/docs/grid-auto-rows
       */
      "auto-rows": [{
        "auto-rows": ["auto", "min", "max", "fr", Gl]
      }],
      /**
       * Gap
       * @see https://tailwindcss.com/docs/gap
       */
      gap: [{
        gap: [m]
      }],
      /**
       * Gap X
       * @see https://tailwindcss.com/docs/gap
       */
      "gap-x": [{
        "gap-x": [m]
      }],
      /**
       * Gap Y
       * @see https://tailwindcss.com/docs/gap
       */
      "gap-y": [{
        "gap-y": [m]
      }],
      /**
       * Justify Content
       * @see https://tailwindcss.com/docs/justify-content
       */
      "justify-content": [{
        justify: ["normal", ...ll()]
      }],
      /**
       * Justify Items
       * @see https://tailwindcss.com/docs/justify-items
       */
      "justify-items": [{
        "justify-items": ["start", "end", "center", "stretch"]
      }],
      /**
       * Justify Self
       * @see https://tailwindcss.com/docs/justify-self
       */
      "justify-self": [{
        "justify-self": ["auto", "start", "end", "center", "stretch"]
      }],
      /**
       * Align Content
       * @see https://tailwindcss.com/docs/align-content
       */
      "align-content": [{
        content: ["normal", ...ll(), "baseline"]
      }],
      /**
       * Align Items
       * @see https://tailwindcss.com/docs/align-items
       */
      "align-items": [{
        items: ["start", "end", "center", "baseline", "stretch"]
      }],
      /**
       * Align Self
       * @see https://tailwindcss.com/docs/align-self
       */
      "align-self": [{
        self: ["auto", "start", "end", "center", "stretch", "baseline"]
      }],
      /**
       * Place Content
       * @see https://tailwindcss.com/docs/place-content
       */
      "place-content": [{
        "place-content": [...ll(), "baseline"]
      }],
      /**
       * Place Items
       * @see https://tailwindcss.com/docs/place-items
       */
      "place-items": [{
        "place-items": ["start", "end", "center", "baseline", "stretch"]
      }],
      /**
       * Place Self
       * @see https://tailwindcss.com/docs/place-self
       */
      "place-self": [{
        "place-self": ["auto", "start", "end", "center", "stretch"]
      }],
      // Spacing
      /**
       * Padding
       * @see https://tailwindcss.com/docs/padding
       */
      p: [{
        p: [A]
      }],
      /**
       * Padding X
       * @see https://tailwindcss.com/docs/padding
       */
      px: [{
        px: [A]
      }],
      /**
       * Padding Y
       * @see https://tailwindcss.com/docs/padding
       */
      py: [{
        py: [A]
      }],
      /**
       * Padding Start
       * @see https://tailwindcss.com/docs/padding
       */
      ps: [{
        ps: [A]
      }],
      /**
       * Padding End
       * @see https://tailwindcss.com/docs/padding
       */
      pe: [{
        pe: [A]
      }],
      /**
       * Padding Top
       * @see https://tailwindcss.com/docs/padding
       */
      pt: [{
        pt: [A]
      }],
      /**
       * Padding Right
       * @see https://tailwindcss.com/docs/padding
       */
      pr: [{
        pr: [A]
      }],
      /**
       * Padding Bottom
       * @see https://tailwindcss.com/docs/padding
       */
      pb: [{
        pb: [A]
      }],
      /**
       * Padding Left
       * @see https://tailwindcss.com/docs/padding
       */
      pl: [{
        pl: [A]
      }],
      /**
       * Margin
       * @see https://tailwindcss.com/docs/margin
       */
      m: [{
        m: [E]
      }],
      /**
       * Margin X
       * @see https://tailwindcss.com/docs/margin
       */
      mx: [{
        mx: [E]
      }],
      /**
       * Margin Y
       * @see https://tailwindcss.com/docs/margin
       */
      my: [{
        my: [E]
      }],
      /**
       * Margin Start
       * @see https://tailwindcss.com/docs/margin
       */
      ms: [{
        ms: [E]
      }],
      /**
       * Margin End
       * @see https://tailwindcss.com/docs/margin
       */
      me: [{
        me: [E]
      }],
      /**
       * Margin Top
       * @see https://tailwindcss.com/docs/margin
       */
      mt: [{
        mt: [E]
      }],
      /**
       * Margin Right
       * @see https://tailwindcss.com/docs/margin
       */
      mr: [{
        mr: [E]
      }],
      /**
       * Margin Bottom
       * @see https://tailwindcss.com/docs/margin
       */
      mb: [{
        mb: [E]
      }],
      /**
       * Margin Left
       * @see https://tailwindcss.com/docs/margin
       */
      ml: [{
        ml: [E]
      }],
      /**
       * Space Between X
       * @see https://tailwindcss.com/docs/space
       */
      "space-x": [{
        "space-x": [_]
      }],
      /**
       * Space Between X Reverse
       * @see https://tailwindcss.com/docs/space
       */
      "space-x-reverse": ["space-x-reverse"],
      /**
       * Space Between Y
       * @see https://tailwindcss.com/docs/space
       */
      "space-y": [{
        "space-y": [_]
      }],
      /**
       * Space Between Y Reverse
       * @see https://tailwindcss.com/docs/space
       */
      "space-y-reverse": ["space-y-reverse"],
      // Sizing
      /**
       * Width
       * @see https://tailwindcss.com/docs/width
       */
      w: [{
        w: ["auto", "min", "max", "fit", "svw", "lvw", "dvw", Gl, n]
      }],
      /**
       * Min-Width
       * @see https://tailwindcss.com/docs/min-width
       */
      "min-w": [{
        "min-w": [Gl, n, "min", "max", "fit"]
      }],
      /**
       * Max-Width
       * @see https://tailwindcss.com/docs/max-width
       */
      "max-w": [{
        "max-w": [Gl, n, "none", "full", "min", "max", "fit", "prose", {
          screen: [Ze]
        }, Ze]
      }],
      /**
       * Height
       * @see https://tailwindcss.com/docs/height
       */
      h: [{
        h: [Gl, n, "auto", "min", "max", "fit", "svh", "lvh", "dvh"]
      }],
      /**
       * Min-Height
       * @see https://tailwindcss.com/docs/min-height
       */
      "min-h": [{
        "min-h": [Gl, n, "min", "max", "fit", "svh", "lvh", "dvh"]
      }],
      /**
       * Max-Height
       * @see https://tailwindcss.com/docs/max-height
       */
      "max-h": [{
        "max-h": [Gl, n, "min", "max", "fit", "svh", "lvh", "dvh"]
      }],
      /**
       * Size
       * @see https://tailwindcss.com/docs/size
       */
      size: [{
        size: [Gl, n, "auto", "min", "max", "fit"]
      }],
      // Typography
      /**
       * Font Size
       * @see https://tailwindcss.com/docs/font-size
       */
      "font-size": [{
        text: ["base", Ze, He]
      }],
      /**
       * Font Smoothing
       * @see https://tailwindcss.com/docs/font-smoothing
       */
      "font-smoothing": ["antialiased", "subpixel-antialiased"],
      /**
       * Font Style
       * @see https://tailwindcss.com/docs/font-style
       */
      "font-style": ["italic", "not-italic"],
      /**
       * Font Weight
       * @see https://tailwindcss.com/docs/font-weight
       */
      "font-weight": [{
        font: ["thin", "extralight", "light", "normal", "medium", "semibold", "bold", "extrabold", "black", ao]
      }],
      /**
       * Font Family
       * @see https://tailwindcss.com/docs/font-family
       */
      "font-family": [{
        font: [Lr]
      }],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-normal": ["normal-nums"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-ordinal": ["ordinal"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-slashed-zero": ["slashed-zero"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-figure": ["lining-nums", "oldstyle-nums"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-spacing": ["proportional-nums", "tabular-nums"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-fraction": ["diagonal-fractions", "stacked-fractons"],
      /**
       * Letter Spacing
       * @see https://tailwindcss.com/docs/letter-spacing
       */
      tracking: [{
        tracking: ["tighter", "tight", "normal", "wide", "wider", "widest", Gl]
      }],
      /**
       * Line Clamp
       * @see https://tailwindcss.com/docs/line-clamp
       */
      "line-clamp": [{
        "line-clamp": ["none", xt, ao]
      }],
      /**
       * Line Height
       * @see https://tailwindcss.com/docs/line-height
       */
      leading: [{
        leading: ["none", "tight", "snug", "normal", "relaxed", "loose", we, Gl]
      }],
      /**
       * List Style Image
       * @see https://tailwindcss.com/docs/list-style-image
       */
      "list-image": [{
        "list-image": ["none", Gl]
      }],
      /**
       * List Style Type
       * @see https://tailwindcss.com/docs/list-style-type
       */
      "list-style-type": [{
        list: ["none", "disc", "decimal", Gl]
      }],
      /**
       * List Style Position
       * @see https://tailwindcss.com/docs/list-style-position
       */
      "list-style-position": [{
        list: ["inside", "outside"]
      }],
      /**
       * Placeholder Color
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/placeholder-color
       */
      "placeholder-color": [{
        placeholder: [l]
      }],
      /**
       * Placeholder Opacity
       * @see https://tailwindcss.com/docs/placeholder-opacity
       */
      "placeholder-opacity": [{
        "placeholder-opacity": [S]
      }],
      /**
       * Text Alignment
       * @see https://tailwindcss.com/docs/text-align
       */
      "text-alignment": [{
        text: ["left", "center", "right", "justify", "start", "end"]
      }],
      /**
       * Text Color
       * @see https://tailwindcss.com/docs/text-color
       */
      "text-color": [{
        text: [l]
      }],
      /**
       * Text Opacity
       * @see https://tailwindcss.com/docs/text-opacity
       */
      "text-opacity": [{
        "text-opacity": [S]
      }],
      /**
       * Text Decoration
       * @see https://tailwindcss.com/docs/text-decoration
       */
      "text-decoration": ["underline", "overline", "line-through", "no-underline"],
      /**
       * Text Decoration Style
       * @see https://tailwindcss.com/docs/text-decoration-style
       */
      "text-decoration-style": [{
        decoration: [...tl(), "wavy"]
      }],
      /**
       * Text Decoration Thickness
       * @see https://tailwindcss.com/docs/text-decoration-thickness
       */
      "text-decoration-thickness": [{
        decoration: ["auto", "from-font", we, He]
      }],
      /**
       * Text Underline Offset
       * @see https://tailwindcss.com/docs/text-underline-offset
       */
      "underline-offset": [{
        "underline-offset": ["auto", we, Gl]
      }],
      /**
       * Text Decoration Color
       * @see https://tailwindcss.com/docs/text-decoration-color
       */
      "text-decoration-color": [{
        decoration: [l]
      }],
      /**
       * Text Transform
       * @see https://tailwindcss.com/docs/text-transform
       */
      "text-transform": ["uppercase", "lowercase", "capitalize", "normal-case"],
      /**
       * Text Overflow
       * @see https://tailwindcss.com/docs/text-overflow
       */
      "text-overflow": ["truncate", "text-ellipsis", "text-clip"],
      /**
       * Text Wrap
       * @see https://tailwindcss.com/docs/text-wrap
       */
      "text-wrap": [{
        text: ["wrap", "nowrap", "balance", "pretty"]
      }],
      /**
       * Text Indent
       * @see https://tailwindcss.com/docs/text-indent
       */
      indent: [{
        indent: U()
      }],
      /**
       * Vertical Alignment
       * @see https://tailwindcss.com/docs/vertical-align
       */
      "vertical-align": [{
        align: ["baseline", "top", "middle", "bottom", "text-top", "text-bottom", "sub", "super", Gl]
      }],
      /**
       * Whitespace
       * @see https://tailwindcss.com/docs/whitespace
       */
      whitespace: [{
        whitespace: ["normal", "nowrap", "pre", "pre-line", "pre-wrap", "break-spaces"]
      }],
      /**
       * Word Break
       * @see https://tailwindcss.com/docs/word-break
       */
      break: [{
        break: ["normal", "words", "all", "keep"]
      }],
      /**
       * Hyphens
       * @see https://tailwindcss.com/docs/hyphens
       */
      hyphens: [{
        hyphens: ["none", "manual", "auto"]
      }],
      /**
       * Content
       * @see https://tailwindcss.com/docs/content
       */
      content: [{
        content: ["none", Gl]
      }],
      // Backgrounds
      /**
       * Background Attachment
       * @see https://tailwindcss.com/docs/background-attachment
       */
      "bg-attachment": [{
        bg: ["fixed", "local", "scroll"]
      }],
      /**
       * Background Clip
       * @see https://tailwindcss.com/docs/background-clip
       */
      "bg-clip": [{
        "bg-clip": ["border", "padding", "content", "text"]
      }],
      /**
       * Background Opacity
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/background-opacity
       */
      "bg-opacity": [{
        "bg-opacity": [S]
      }],
      /**
       * Background Origin
       * @see https://tailwindcss.com/docs/background-origin
       */
      "bg-origin": [{
        "bg-origin": ["border", "padding", "content"]
      }],
      /**
       * Background Position
       * @see https://tailwindcss.com/docs/background-position
       */
      "bg-position": [{
        bg: [...rl(), Qb]
      }],
      /**
       * Background Repeat
       * @see https://tailwindcss.com/docs/background-repeat
       */
      "bg-repeat": [{
        bg: ["no-repeat", {
          repeat: ["", "x", "y", "round", "space"]
        }]
      }],
      /**
       * Background Size
       * @see https://tailwindcss.com/docs/background-size
       */
      "bg-size": [{
        bg: ["auto", "cover", "contain", Kb]
      }],
      /**
       * Background Image
       * @see https://tailwindcss.com/docs/background-image
       */
      "bg-image": [{
        bg: ["none", {
          "gradient-to": ["t", "tr", "r", "br", "b", "bl", "l", "tl"]
        }, ly]
      }],
      /**
       * Background Color
       * @see https://tailwindcss.com/docs/background-color
       */
      "bg-color": [{
        bg: [l]
      }],
      /**
       * Gradient Color Stops From Position
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-from-pos": [{
        from: [$]
      }],
      /**
       * Gradient Color Stops Via Position
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-via-pos": [{
        via: [$]
      }],
      /**
       * Gradient Color Stops To Position
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-to-pos": [{
        to: [$]
      }],
      /**
       * Gradient Color Stops From
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-from": [{
        from: [v]
      }],
      /**
       * Gradient Color Stops Via
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-via": [{
        via: [v]
      }],
      /**
       * Gradient Color Stops To
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-to": [{
        to: [v]
      }],
      // Borders
      /**
       * Border Radius
       * @see https://tailwindcss.com/docs/border-radius
       */
      rounded: [{
        rounded: [o]
      }],
      /**
       * Border Radius Start
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-s": [{
        "rounded-s": [o]
      }],
      /**
       * Border Radius End
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-e": [{
        "rounded-e": [o]
      }],
      /**
       * Border Radius Top
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-t": [{
        "rounded-t": [o]
      }],
      /**
       * Border Radius Right
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-r": [{
        "rounded-r": [o]
      }],
      /**
       * Border Radius Bottom
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-b": [{
        "rounded-b": [o]
      }],
      /**
       * Border Radius Left
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-l": [{
        "rounded-l": [o]
      }],
      /**
       * Border Radius Start Start
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-ss": [{
        "rounded-ss": [o]
      }],
      /**
       * Border Radius Start End
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-se": [{
        "rounded-se": [o]
      }],
      /**
       * Border Radius End End
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-ee": [{
        "rounded-ee": [o]
      }],
      /**
       * Border Radius End Start
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-es": [{
        "rounded-es": [o]
      }],
      /**
       * Border Radius Top Left
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-tl": [{
        "rounded-tl": [o]
      }],
      /**
       * Border Radius Top Right
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-tr": [{
        "rounded-tr": [o]
      }],
      /**
       * Border Radius Bottom Right
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-br": [{
        "rounded-br": [o]
      }],
      /**
       * Border Radius Bottom Left
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-bl": [{
        "rounded-bl": [o]
      }],
      /**
       * Border Width
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w": [{
        border: [d]
      }],
      /**
       * Border Width X
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-x": [{
        "border-x": [d]
      }],
      /**
       * Border Width Y
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-y": [{
        "border-y": [d]
      }],
      /**
       * Border Width Start
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-s": [{
        "border-s": [d]
      }],
      /**
       * Border Width End
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-e": [{
        "border-e": [d]
      }],
      /**
       * Border Width Top
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-t": [{
        "border-t": [d]
      }],
      /**
       * Border Width Right
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-r": [{
        "border-r": [d]
      }],
      /**
       * Border Width Bottom
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-b": [{
        "border-b": [d]
      }],
      /**
       * Border Width Left
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-l": [{
        "border-l": [d]
      }],
      /**
       * Border Opacity
       * @see https://tailwindcss.com/docs/border-opacity
       */
      "border-opacity": [{
        "border-opacity": [S]
      }],
      /**
       * Border Style
       * @see https://tailwindcss.com/docs/border-style
       */
      "border-style": [{
        border: [...tl(), "hidden"]
      }],
      /**
       * Divide Width X
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-x": [{
        "divide-x": [d]
      }],
      /**
       * Divide Width X Reverse
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-x-reverse": ["divide-x-reverse"],
      /**
       * Divide Width Y
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-y": [{
        "divide-y": [d]
      }],
      /**
       * Divide Width Y Reverse
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-y-reverse": ["divide-y-reverse"],
      /**
       * Divide Opacity
       * @see https://tailwindcss.com/docs/divide-opacity
       */
      "divide-opacity": [{
        "divide-opacity": [S]
      }],
      /**
       * Divide Style
       * @see https://tailwindcss.com/docs/divide-style
       */
      "divide-style": [{
        divide: tl()
      }],
      /**
       * Border Color
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color": [{
        border: [r]
      }],
      /**
       * Border Color X
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-x": [{
        "border-x": [r]
      }],
      /**
       * Border Color Y
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-y": [{
        "border-y": [r]
      }],
      /**
       * Border Color Top
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-t": [{
        "border-t": [r]
      }],
      /**
       * Border Color Right
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-r": [{
        "border-r": [r]
      }],
      /**
       * Border Color Bottom
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-b": [{
        "border-b": [r]
      }],
      /**
       * Border Color Left
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-l": [{
        "border-l": [r]
      }],
      /**
       * Divide Color
       * @see https://tailwindcss.com/docs/divide-color
       */
      "divide-color": [{
        divide: [r]
      }],
      /**
       * Outline Style
       * @see https://tailwindcss.com/docs/outline-style
       */
      "outline-style": [{
        outline: ["", ...tl()]
      }],
      /**
       * Outline Offset
       * @see https://tailwindcss.com/docs/outline-offset
       */
      "outline-offset": [{
        "outline-offset": [we, Gl]
      }],
      /**
       * Outline Width
       * @see https://tailwindcss.com/docs/outline-width
       */
      "outline-w": [{
        outline: [we, He]
      }],
      /**
       * Outline Color
       * @see https://tailwindcss.com/docs/outline-color
       */
      "outline-color": [{
        outline: [l]
      }],
      /**
       * Ring Width
       * @see https://tailwindcss.com/docs/ring-width
       */
      "ring-w": [{
        ring: ul()
      }],
      /**
       * Ring Width Inset
       * @see https://tailwindcss.com/docs/ring-width
       */
      "ring-w-inset": ["ring-inset"],
      /**
       * Ring Color
       * @see https://tailwindcss.com/docs/ring-color
       */
      "ring-color": [{
        ring: [l]
      }],
      /**
       * Ring Opacity
       * @see https://tailwindcss.com/docs/ring-opacity
       */
      "ring-opacity": [{
        "ring-opacity": [S]
      }],
      /**
       * Ring Offset Width
       * @see https://tailwindcss.com/docs/ring-offset-width
       */
      "ring-offset-w": [{
        "ring-offset": [we, He]
      }],
      /**
       * Ring Offset Color
       * @see https://tailwindcss.com/docs/ring-offset-color
       */
      "ring-offset-color": [{
        "ring-offset": [l]
      }],
      // Effects
      /**
       * Box Shadow
       * @see https://tailwindcss.com/docs/box-shadow
       */
      shadow: [{
        shadow: ["", "inner", "none", Ze, ny]
      }],
      /**
       * Box Shadow Color
       * @see https://tailwindcss.com/docs/box-shadow-color
       */
      "shadow-color": [{
        shadow: [Lr]
      }],
      /**
       * Opacity
       * @see https://tailwindcss.com/docs/opacity
       */
      opacity: [{
        opacity: [S]
      }],
      /**
       * Mix Blend Mode
       * @see https://tailwindcss.com/docs/mix-blend-mode
       */
      "mix-blend": [{
        "mix-blend": sl()
      }],
      /**
       * Background Blend Mode
       * @see https://tailwindcss.com/docs/background-blend-mode
       */
      "bg-blend": [{
        "bg-blend": sl()
      }],
      // Filters
      /**
       * Filter
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/filter
       */
      filter: [{
        filter: ["", "none"]
      }],
      /**
       * Blur
       * @see https://tailwindcss.com/docs/blur
       */
      blur: [{
        blur: [u]
      }],
      /**
       * Brightness
       * @see https://tailwindcss.com/docs/brightness
       */
      brightness: [{
        brightness: [t]
      }],
      /**
       * Contrast
       * @see https://tailwindcss.com/docs/contrast
       */
      contrast: [{
        contrast: [a]
      }],
      /**
       * Drop Shadow
       * @see https://tailwindcss.com/docs/drop-shadow
       */
      "drop-shadow": [{
        "drop-shadow": ["", "none", Ze, Gl]
      }],
      /**
       * Grayscale
       * @see https://tailwindcss.com/docs/grayscale
       */
      grayscale: [{
        grayscale: [f]
      }],
      /**
       * Hue Rotate
       * @see https://tailwindcss.com/docs/hue-rotate
       */
      "hue-rotate": [{
        "hue-rotate": [p]
      }],
      /**
       * Invert
       * @see https://tailwindcss.com/docs/invert
       */
      invert: [{
        invert: [g]
      }],
      /**
       * Saturate
       * @see https://tailwindcss.com/docs/saturate
       */
      saturate: [{
        saturate: [x]
      }],
      /**
       * Sepia
       * @see https://tailwindcss.com/docs/sepia
       */
      sepia: [{
        sepia: [P]
      }],
      /**
       * Backdrop Filter
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/backdrop-filter
       */
      "backdrop-filter": [{
        "backdrop-filter": ["", "none"]
      }],
      /**
       * Backdrop Blur
       * @see https://tailwindcss.com/docs/backdrop-blur
       */
      "backdrop-blur": [{
        "backdrop-blur": [u]
      }],
      /**
       * Backdrop Brightness
       * @see https://tailwindcss.com/docs/backdrop-brightness
       */
      "backdrop-brightness": [{
        "backdrop-brightness": [t]
      }],
      /**
       * Backdrop Contrast
       * @see https://tailwindcss.com/docs/backdrop-contrast
       */
      "backdrop-contrast": [{
        "backdrop-contrast": [a]
      }],
      /**
       * Backdrop Grayscale
       * @see https://tailwindcss.com/docs/backdrop-grayscale
       */
      "backdrop-grayscale": [{
        "backdrop-grayscale": [f]
      }],
      /**
       * Backdrop Hue Rotate
       * @see https://tailwindcss.com/docs/backdrop-hue-rotate
       */
      "backdrop-hue-rotate": [{
        "backdrop-hue-rotate": [p]
      }],
      /**
       * Backdrop Invert
       * @see https://tailwindcss.com/docs/backdrop-invert
       */
      "backdrop-invert": [{
        "backdrop-invert": [g]
      }],
      /**
       * Backdrop Opacity
       * @see https://tailwindcss.com/docs/backdrop-opacity
       */
      "backdrop-opacity": [{
        "backdrop-opacity": [S]
      }],
      /**
       * Backdrop Saturate
       * @see https://tailwindcss.com/docs/backdrop-saturate
       */
      "backdrop-saturate": [{
        "backdrop-saturate": [x]
      }],
      /**
       * Backdrop Sepia
       * @see https://tailwindcss.com/docs/backdrop-sepia
       */
      "backdrop-sepia": [{
        "backdrop-sepia": [P]
      }],
      // Tables
      /**
       * Border Collapse
       * @see https://tailwindcss.com/docs/border-collapse
       */
      "border-collapse": [{
        border: ["collapse", "separate"]
      }],
      /**
       * Border Spacing
       * @see https://tailwindcss.com/docs/border-spacing
       */
      "border-spacing": [{
        "border-spacing": [s]
      }],
      /**
       * Border Spacing X
       * @see https://tailwindcss.com/docs/border-spacing
       */
      "border-spacing-x": [{
        "border-spacing-x": [s]
      }],
      /**
       * Border Spacing Y
       * @see https://tailwindcss.com/docs/border-spacing
       */
      "border-spacing-y": [{
        "border-spacing-y": [s]
      }],
      /**
       * Table Layout
       * @see https://tailwindcss.com/docs/table-layout
       */
      "table-layout": [{
        table: ["auto", "fixed"]
      }],
      /**
       * Caption Side
       * @see https://tailwindcss.com/docs/caption-side
       */
      caption: [{
        caption: ["top", "bottom"]
      }],
      // Transitions and Animation
      /**
       * Tranisition Property
       * @see https://tailwindcss.com/docs/transition-property
       */
      transition: [{
        transition: ["none", "all", "", "colors", "opacity", "shadow", "transform", Gl]
      }],
      /**
       * Transition Duration
       * @see https://tailwindcss.com/docs/transition-duration
       */
      duration: [{
        duration: dl()
      }],
      /**
       * Transition Timing Function
       * @see https://tailwindcss.com/docs/transition-timing-function
       */
      ease: [{
        ease: ["linear", "in", "out", "in-out", Gl]
      }],
      /**
       * Transition Delay
       * @see https://tailwindcss.com/docs/transition-delay
       */
      delay: [{
        delay: dl()
      }],
      /**
       * Animation
       * @see https://tailwindcss.com/docs/animation
       */
      animate: [{
        animate: ["none", "spin", "ping", "pulse", "bounce", Gl]
      }],
      // Transforms
      /**
       * Transform
       * @see https://tailwindcss.com/docs/transform
       */
      transform: [{
        transform: ["", "gpu", "none"]
      }],
      /**
       * Scale
       * @see https://tailwindcss.com/docs/scale
       */
      scale: [{
        scale: [I]
      }],
      /**
       * Scale X
       * @see https://tailwindcss.com/docs/scale
       */
      "scale-x": [{
        "scale-x": [I]
      }],
      /**
       * Scale Y
       * @see https://tailwindcss.com/docs/scale
       */
      "scale-y": [{
        "scale-y": [I]
      }],
      /**
       * Rotate
       * @see https://tailwindcss.com/docs/rotate
       */
      rotate: [{
        rotate: [Br, Gl]
      }],
      /**
       * Translate X
       * @see https://tailwindcss.com/docs/translate
       */
      "translate-x": [{
        "translate-x": [j]
      }],
      /**
       * Translate Y
       * @see https://tailwindcss.com/docs/translate
       */
      "translate-y": [{
        "translate-y": [j]
      }],
      /**
       * Skew X
       * @see https://tailwindcss.com/docs/skew
       */
      "skew-x": [{
        "skew-x": [O]
      }],
      /**
       * Skew Y
       * @see https://tailwindcss.com/docs/skew
       */
      "skew-y": [{
        "skew-y": [O]
      }],
      /**
       * Transform Origin
       * @see https://tailwindcss.com/docs/transform-origin
       */
      "transform-origin": [{
        origin: ["center", "top", "top-right", "right", "bottom-right", "bottom", "bottom-left", "left", "top-left", Gl]
      }],
      // Interactivity
      /**
       * Accent Color
       * @see https://tailwindcss.com/docs/accent-color
       */
      accent: [{
        accent: ["auto", l]
      }],
      /**
       * Appearance
       * @see https://tailwindcss.com/docs/appearance
       */
      appearance: [{
        appearance: ["none", "auto"]
      }],
      /**
       * Cursor
       * @see https://tailwindcss.com/docs/cursor
       */
      cursor: [{
        cursor: ["auto", "default", "pointer", "wait", "text", "move", "help", "not-allowed", "none", "context-menu", "progress", "cell", "crosshair", "vertical-text", "alias", "copy", "no-drop", "grab", "grabbing", "all-scroll", "col-resize", "row-resize", "n-resize", "e-resize", "s-resize", "w-resize", "ne-resize", "nw-resize", "se-resize", "sw-resize", "ew-resize", "ns-resize", "nesw-resize", "nwse-resize", "zoom-in", "zoom-out", Gl]
      }],
      /**
       * Caret Color
       * @see https://tailwindcss.com/docs/just-in-time-mode#caret-color-utilities
       */
      "caret-color": [{
        caret: [l]
      }],
      /**
       * Pointer Events
       * @see https://tailwindcss.com/docs/pointer-events
       */
      "pointer-events": [{
        "pointer-events": ["none", "auto"]
      }],
      /**
       * Resize
       * @see https://tailwindcss.com/docs/resize
       */
      resize: [{
        resize: ["none", "y", "x", ""]
      }],
      /**
       * Scroll Behavior
       * @see https://tailwindcss.com/docs/scroll-behavior
       */
      "scroll-behavior": [{
        scroll: ["auto", "smooth"]
      }],
      /**
       * Scroll Margin
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-m": [{
        "scroll-m": U()
      }],
      /**
       * Scroll Margin X
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mx": [{
        "scroll-mx": U()
      }],
      /**
       * Scroll Margin Y
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-my": [{
        "scroll-my": U()
      }],
      /**
       * Scroll Margin Start
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-ms": [{
        "scroll-ms": U()
      }],
      /**
       * Scroll Margin End
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-me": [{
        "scroll-me": U()
      }],
      /**
       * Scroll Margin Top
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mt": [{
        "scroll-mt": U()
      }],
      /**
       * Scroll Margin Right
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mr": [{
        "scroll-mr": U()
      }],
      /**
       * Scroll Margin Bottom
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mb": [{
        "scroll-mb": U()
      }],
      /**
       * Scroll Margin Left
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-ml": [{
        "scroll-ml": U()
      }],
      /**
       * Scroll Padding
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-p": [{
        "scroll-p": U()
      }],
      /**
       * Scroll Padding X
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-px": [{
        "scroll-px": U()
      }],
      /**
       * Scroll Padding Y
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-py": [{
        "scroll-py": U()
      }],
      /**
       * Scroll Padding Start
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-ps": [{
        "scroll-ps": U()
      }],
      /**
       * Scroll Padding End
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pe": [{
        "scroll-pe": U()
      }],
      /**
       * Scroll Padding Top
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pt": [{
        "scroll-pt": U()
      }],
      /**
       * Scroll Padding Right
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pr": [{
        "scroll-pr": U()
      }],
      /**
       * Scroll Padding Bottom
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pb": [{
        "scroll-pb": U()
      }],
      /**
       * Scroll Padding Left
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pl": [{
        "scroll-pl": U()
      }],
      /**
       * Scroll Snap Align
       * @see https://tailwindcss.com/docs/scroll-snap-align
       */
      "snap-align": [{
        snap: ["start", "end", "center", "align-none"]
      }],
      /**
       * Scroll Snap Stop
       * @see https://tailwindcss.com/docs/scroll-snap-stop
       */
      "snap-stop": [{
        snap: ["normal", "always"]
      }],
      /**
       * Scroll Snap Type
       * @see https://tailwindcss.com/docs/scroll-snap-type
       */
      "snap-type": [{
        snap: ["none", "x", "y", "both"]
      }],
      /**
       * Scroll Snap Type Strictness
       * @see https://tailwindcss.com/docs/scroll-snap-type
       */
      "snap-strictness": [{
        snap: ["mandatory", "proximity"]
      }],
      /**
       * Touch Action
       * @see https://tailwindcss.com/docs/touch-action
       */
      touch: [{
        touch: ["auto", "none", "manipulation"]
      }],
      /**
       * Touch Action X
       * @see https://tailwindcss.com/docs/touch-action
       */
      "touch-x": [{
        "touch-pan": ["x", "left", "right"]
      }],
      /**
       * Touch Action Y
       * @see https://tailwindcss.com/docs/touch-action
       */
      "touch-y": [{
        "touch-pan": ["y", "up", "down"]
      }],
      /**
       * Touch Action Pinch Zoom
       * @see https://tailwindcss.com/docs/touch-action
       */
      "touch-pz": ["touch-pinch-zoom"],
      /**
       * User Select
       * @see https://tailwindcss.com/docs/user-select
       */
      select: [{
        select: ["none", "text", "all", "auto"]
      }],
      /**
       * Will Change
       * @see https://tailwindcss.com/docs/will-change
       */
      "will-change": [{
        "will-change": ["auto", "scroll", "contents", "transform", Gl]
      }],
      // SVG
      /**
       * Fill
       * @see https://tailwindcss.com/docs/fill
       */
      fill: [{
        fill: [l, "none"]
      }],
      /**
       * Stroke Width
       * @see https://tailwindcss.com/docs/stroke-width
       */
      "stroke-w": [{
        stroke: [we, He, ao]
      }],
      /**
       * Stroke
       * @see https://tailwindcss.com/docs/stroke
       */
      stroke: [{
        stroke: [l, "none"]
      }],
      // Accessibility
      /**
       * Screen Readers
       * @see https://tailwindcss.com/docs/screen-readers
       */
      sr: ["sr-only", "not-sr-only"],
      /**
       * Forced Color Adjust
       * @see https://tailwindcss.com/docs/forced-color-adjust
       */
      "forced-color-adjust": [{
        "forced-color-adjust": ["auto", "none"]
      }]
    },
    conflictingClassGroups: {
      overflow: ["overflow-x", "overflow-y"],
      overscroll: ["overscroll-x", "overscroll-y"],
      inset: ["inset-x", "inset-y", "start", "end", "top", "right", "bottom", "left"],
      "inset-x": ["right", "left"],
      "inset-y": ["top", "bottom"],
      flex: ["basis", "grow", "shrink"],
      gap: ["gap-x", "gap-y"],
      p: ["px", "py", "ps", "pe", "pt", "pr", "pb", "pl"],
      px: ["pr", "pl"],
      py: ["pt", "pb"],
      m: ["mx", "my", "ms", "me", "mt", "mr", "mb", "ml"],
      mx: ["mr", "ml"],
      my: ["mt", "mb"],
      size: ["w", "h"],
      "font-size": ["leading"],
      "fvn-normal": ["fvn-ordinal", "fvn-slashed-zero", "fvn-figure", "fvn-spacing", "fvn-fraction"],
      "fvn-ordinal": ["fvn-normal"],
      "fvn-slashed-zero": ["fvn-normal"],
      "fvn-figure": ["fvn-normal"],
      "fvn-spacing": ["fvn-normal"],
      "fvn-fraction": ["fvn-normal"],
      "line-clamp": ["display", "overflow"],
      rounded: ["rounded-s", "rounded-e", "rounded-t", "rounded-r", "rounded-b", "rounded-l", "rounded-ss", "rounded-se", "rounded-ee", "rounded-es", "rounded-tl", "rounded-tr", "rounded-br", "rounded-bl"],
      "rounded-s": ["rounded-ss", "rounded-es"],
      "rounded-e": ["rounded-se", "rounded-ee"],
      "rounded-t": ["rounded-tl", "rounded-tr"],
      "rounded-r": ["rounded-tr", "rounded-br"],
      "rounded-b": ["rounded-br", "rounded-bl"],
      "rounded-l": ["rounded-tl", "rounded-bl"],
      "border-spacing": ["border-spacing-x", "border-spacing-y"],
      "border-w": ["border-w-s", "border-w-e", "border-w-t", "border-w-r", "border-w-b", "border-w-l"],
      "border-w-x": ["border-w-r", "border-w-l"],
      "border-w-y": ["border-w-t", "border-w-b"],
      "border-color": ["border-color-t", "border-color-r", "border-color-b", "border-color-l"],
      "border-color-x": ["border-color-r", "border-color-l"],
      "border-color-y": ["border-color-t", "border-color-b"],
      "scroll-m": ["scroll-mx", "scroll-my", "scroll-ms", "scroll-me", "scroll-mt", "scroll-mr", "scroll-mb", "scroll-ml"],
      "scroll-mx": ["scroll-mr", "scroll-ml"],
      "scroll-my": ["scroll-mt", "scroll-mb"],
      "scroll-p": ["scroll-px", "scroll-py", "scroll-ps", "scroll-pe", "scroll-pt", "scroll-pr", "scroll-pb", "scroll-pl"],
      "scroll-px": ["scroll-pr", "scroll-pl"],
      "scroll-py": ["scroll-pt", "scroll-pb"],
      touch: ["touch-x", "touch-y", "touch-pz"],
      "touch-x": ["touch"],
      "touch-y": ["touch"],
      "touch-pz": ["touch"]
    },
    conflictingClassGroupModifiers: {
      "font-size": ["leading"]
    }
  };
}
const Oe = /* @__PURE__ */ Wb(ry);
var V3 = {}, k3 = {}, fc = { exports: {} }, vn = String, H3 = function() {
  return { isColorSupported: !1, reset: vn, bold: vn, dim: vn, italic: vn, underline: vn, inverse: vn, hidden: vn, strikethrough: vn, black: vn, red: vn, green: vn, yellow: vn, blue: vn, magenta: vn, cyan: vn, white: vn, gray: vn, bgBlack: vn, bgRed: vn, bgGreen: vn, bgYellow: vn, bgBlue: vn, bgMagenta: vn, bgCyan: vn, bgWhite: vn };
};
fc.exports = H3();
fc.exports.createColors = H3;
var iy = fc.exports;
(function(l) {
  Object.defineProperty(l, "__esModule", {
    value: !0
  });
  function n(a, f) {
    for (var p in f) Object.defineProperty(a, p, {
      enumerable: !0,
      get: f[p]
    });
  }
  n(l, {
    dim: function() {
      return s;
    },
    default: function() {
      return d;
    }
  });
  const u = /* @__PURE__ */ t(iy);
  function t(a) {
    return a && a.__esModule ? a : {
      default: a
    };
  }
  let r = /* @__PURE__ */ new Set();
  function o(a, f, p) {
    typeof process < "u" && process.env.JEST_WORKER_ID || p && r.has(p) || (p && r.add(p), console.warn(""), f.forEach((g) => console.warn(a, "-", g)));
  }
  function s(a) {
    return u.default.dim(a);
  }
  const d = {
    info(a, f) {
      o(u.default.bold(u.default.cyan("info")), ...Array.isArray(a) ? [
        a
      ] : [
        f,
        a
      ]);
    },
    warn(a, f) {
      o(u.default.bold(u.default.yellow("warn")), ...Array.isArray(a) ? [
        a
      ] : [
        f,
        a
      ]);
    },
    risk(a, f) {
      o(u.default.bold(u.default.magenta("risk")), ...Array.isArray(a) ? [
        a
      ] : [
        f,
        a
      ]);
    }
  };
})(k3);
(function(l) {
  Object.defineProperty(l, "__esModule", {
    value: !0
  }), Object.defineProperty(l, "default", {
    enumerable: !0,
    get: function() {
      return r;
    }
  });
  const n = /* @__PURE__ */ u(k3);
  function u(o) {
    return o && o.__esModule ? o : {
      default: o
    };
  }
  function t({ version: o, from: s, to: d }) {
    n.default.warn(`${s}-color-renamed`, [
      `As of Tailwind CSS ${o}, \`${s}\` has been renamed to \`${d}\`.`,
      "Update your configuration file to silence this warning."
    ]);
  }
  const r = {
    inherit: "inherit",
    current: "currentColor",
    transparent: "transparent",
    black: "#000",
    white: "#fff",
    slate: {
      50: "#f8fafc",
      100: "#f1f5f9",
      200: "#e2e8f0",
      300: "#cbd5e1",
      400: "#94a3b8",
      500: "#64748b",
      600: "#475569",
      700: "#334155",
      800: "#1e293b",
      900: "#0f172a",
      950: "#020617"
    },
    gray: {
      50: "#f9fafb",
      100: "#f3f4f6",
      200: "#e5e7eb",
      300: "#d1d5db",
      400: "#9ca3af",
      500: "#6b7280",
      600: "#4b5563",
      700: "#374151",
      800: "#1f2937",
      900: "#111827",
      950: "#030712"
    },
    zinc: {
      50: "#fafafa",
      100: "#f4f4f5",
      200: "#e4e4e7",
      300: "#d4d4d8",
      400: "#a1a1aa",
      500: "#71717a",
      600: "#52525b",
      700: "#3f3f46",
      800: "#27272a",
      900: "#18181b",
      950: "#09090b"
    },
    neutral: {
      50: "#fafafa",
      100: "#f5f5f5",
      200: "#e5e5e5",
      300: "#d4d4d4",
      400: "#a3a3a3",
      500: "#737373",
      600: "#525252",
      700: "#404040",
      800: "#262626",
      900: "#171717",
      950: "#0a0a0a"
    },
    stone: {
      50: "#fafaf9",
      100: "#f5f5f4",
      200: "#e7e5e4",
      300: "#d6d3d1",
      400: "#a8a29e",
      500: "#78716c",
      600: "#57534e",
      700: "#44403c",
      800: "#292524",
      900: "#1c1917",
      950: "#0c0a09"
    },
    red: {
      50: "#fef2f2",
      100: "#fee2e2",
      200: "#fecaca",
      300: "#fca5a5",
      400: "#f87171",
      500: "#ef4444",
      600: "#dc2626",
      700: "#b91c1c",
      800: "#991b1b",
      900: "#7f1d1d",
      950: "#450a0a"
    },
    orange: {
      50: "#fff7ed",
      100: "#ffedd5",
      200: "#fed7aa",
      300: "#fdba74",
      400: "#fb923c",
      500: "#f97316",
      600: "#ea580c",
      700: "#c2410c",
      800: "#9a3412",
      900: "#7c2d12",
      950: "#431407"
    },
    amber: {
      50: "#fffbeb",
      100: "#fef3c7",
      200: "#fde68a",
      300: "#fcd34d",
      400: "#fbbf24",
      500: "#f59e0b",
      600: "#d97706",
      700: "#b45309",
      800: "#92400e",
      900: "#78350f",
      950: "#451a03"
    },
    yellow: {
      50: "#fefce8",
      100: "#fef9c3",
      200: "#fef08a",
      300: "#fde047",
      400: "#facc15",
      500: "#eab308",
      600: "#ca8a04",
      700: "#a16207",
      800: "#854d0e",
      900: "#713f12",
      950: "#422006"
    },
    lime: {
      50: "#f7fee7",
      100: "#ecfccb",
      200: "#d9f99d",
      300: "#bef264",
      400: "#a3e635",
      500: "#84cc16",
      600: "#65a30d",
      700: "#4d7c0f",
      800: "#3f6212",
      900: "#365314",
      950: "#1a2e05"
    },
    green: {
      50: "#f0fdf4",
      100: "#dcfce7",
      200: "#bbf7d0",
      300: "#86efac",
      400: "#4ade80",
      500: "#22c55e",
      600: "#16a34a",
      700: "#15803d",
      800: "#166534",
      900: "#14532d",
      950: "#052e16"
    },
    emerald: {
      50: "#ecfdf5",
      100: "#d1fae5",
      200: "#a7f3d0",
      300: "#6ee7b7",
      400: "#34d399",
      500: "#10b981",
      600: "#059669",
      700: "#047857",
      800: "#065f46",
      900: "#064e3b",
      950: "#022c22"
    },
    teal: {
      50: "#f0fdfa",
      100: "#ccfbf1",
      200: "#99f6e4",
      300: "#5eead4",
      400: "#2dd4bf",
      500: "#14b8a6",
      600: "#0d9488",
      700: "#0f766e",
      800: "#115e59",
      900: "#134e4a",
      950: "#042f2e"
    },
    cyan: {
      50: "#ecfeff",
      100: "#cffafe",
      200: "#a5f3fc",
      300: "#67e8f9",
      400: "#22d3ee",
      500: "#06b6d4",
      600: "#0891b2",
      700: "#0e7490",
      800: "#155e75",
      900: "#164e63",
      950: "#083344"
    },
    sky: {
      50: "#f0f9ff",
      100: "#e0f2fe",
      200: "#bae6fd",
      300: "#7dd3fc",
      400: "#38bdf8",
      500: "#0ea5e9",
      600: "#0284c7",
      700: "#0369a1",
      800: "#075985",
      900: "#0c4a6e",
      950: "#082f49"
    },
    blue: {
      50: "#eff6ff",
      100: "#dbeafe",
      200: "#bfdbfe",
      300: "#93c5fd",
      400: "#60a5fa",
      500: "#3b82f6",
      600: "#2563eb",
      700: "#1d4ed8",
      800: "#1e40af",
      900: "#1e3a8a",
      950: "#172554"
    },
    indigo: {
      50: "#eef2ff",
      100: "#e0e7ff",
      200: "#c7d2fe",
      300: "#a5b4fc",
      400: "#818cf8",
      500: "#6366f1",
      600: "#4f46e5",
      700: "#4338ca",
      800: "#3730a3",
      900: "#312e81",
      950: "#1e1b4b"
    },
    violet: {
      50: "#f5f3ff",
      100: "#ede9fe",
      200: "#ddd6fe",
      300: "#c4b5fd",
      400: "#a78bfa",
      500: "#8b5cf6",
      600: "#7c3aed",
      700: "#6d28d9",
      800: "#5b21b6",
      900: "#4c1d95",
      950: "#2e1065"
    },
    purple: {
      50: "#faf5ff",
      100: "#f3e8ff",
      200: "#e9d5ff",
      300: "#d8b4fe",
      400: "#c084fc",
      500: "#a855f7",
      600: "#9333ea",
      700: "#7e22ce",
      800: "#6b21a8",
      900: "#581c87",
      950: "#3b0764"
    },
    fuchsia: {
      50: "#fdf4ff",
      100: "#fae8ff",
      200: "#f5d0fe",
      300: "#f0abfc",
      400: "#e879f9",
      500: "#d946ef",
      600: "#c026d3",
      700: "#a21caf",
      800: "#86198f",
      900: "#701a75",
      950: "#4a044e"
    },
    pink: {
      50: "#fdf2f8",
      100: "#fce7f3",
      200: "#fbcfe8",
      300: "#f9a8d4",
      400: "#f472b6",
      500: "#ec4899",
      600: "#db2777",
      700: "#be185d",
      800: "#9d174d",
      900: "#831843",
      950: "#500724"
    },
    rose: {
      50: "#fff1f2",
      100: "#ffe4e6",
      200: "#fecdd3",
      300: "#fda4af",
      400: "#fb7185",
      500: "#f43f5e",
      600: "#e11d48",
      700: "#be123c",
      800: "#9f1239",
      900: "#881337",
      950: "#4c0519"
    },
    get lightBlue() {
      return t({
        version: "v2.2",
        from: "lightBlue",
        to: "sky"
      }), this.sky;
    },
    get warmGray() {
      return t({
        version: "v3.0",
        from: "warmGray",
        to: "stone"
      }), this.stone;
    },
    get trueGray() {
      return t({
        version: "v3.0",
        from: "trueGray",
        to: "neutral"
      }), this.neutral;
    },
    get coolGray() {
      return t({
        version: "v3.0",
        from: "coolGray",
        to: "gray"
      }), this.gray;
    },
    get blueGray() {
      return t({
        version: "v3.0",
        from: "blueGray",
        to: "slate"
      }), this.slate;
    }
  };
})(V3);
let Ks = V3;
var oy = (Ks.__esModule ? Ks : { default: Ks }).default;
const Lu = /* @__PURE__ */ ia(oy);
function wl(...l) {
  return Oe(Pb(l));
}
M3.debounce(async (l, n) => {
  try {
    const t = await (await fetch(`https://jsonplaceholder.typicode.com/todos?search=${l}&_limit=10`)).json();
    n(t.map((r) => ({ label: r.title, value: r.title })));
  } catch (u) {
    console.error("Error fetching data:", u);
  }
}, 300);
Lu.amber, Lu.cyan, Lu.emerald, Lu.fuchsia, Lu.indigo, Lu.lime, Lu.orange, Lu.purple, Lu.rose, Lu.sky, Lu.teal, Lu.violet;
const ay = {
  amber: "bg-amber-200 text-amber-900",
  blue: "bg-blue-200 text-blue-900",
  cyan: "bg-cyan-200 text-cyan-900",
  emerald: "bg-emerald-200 text-emerald-900",
  fuchsia: "bg-fuchsia-200 text-fuchsia-900",
  green: "bg-green-200 text-green-900",
  gray: "bg-gray-200 text-gray-900",
  indigo: "bg-indigo-200 text-indigo-900",
  lime: "bg-lime-200 text-lime-900",
  orange: "bg-orange-200 text-orange-900",
  pink: "bg-pink-200 text-pink-900",
  purple: "bg-purple-200 text-purple-900",
  red: "bg-red-200 text-red-900",
  rose: "bg-rose-200 text-rose-900",
  sky: "bg-sky-200 text-sky-900",
  teal: "bg-teal-200 text-teal-900",
  violet: "bg-violet-200 text-violet-900",
  yellow: "bg-yellow-200 text-yellow-900",
  primary: "bg-primary-200 text-primary-900",
  secondary: "bg-secondary-200 text-secondary-900",
  danger: "bg-danger-200 text-danger-900"
}, d_ = ({ color: l, label: n, className: u }) => /* @__PURE__ */ y.jsx("span", { className: wl("text-xs px-2 py-1 rounded-full whitespace-nowrap", ay[l], u), children: n }), c_ = (l) => /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsx(
  "div",
  {
    className: wl(
      "bg-white overflow-hidden border border-gray-300 rounded p-4",
      l.shadow && "shadow",
      l.className
    ),
    children: l.children
  }
) });
var Z3 = {
  color: void 0,
  size: void 0,
  className: void 0,
  style: void 0,
  attr: void 0
}, X2 = react__WEBPACK_IMPORTED_MODULE_0__.createContext && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createContext(Z3), sy = ["attr", "size", "title"];
function dy(l, n) {
  if (l == null) return {};
  var u = cy(l, n), t, r;
  if (Object.getOwnPropertySymbols) {
    var o = Object.getOwnPropertySymbols(l);
    for (r = 0; r < o.length; r++)
      t = o[r], !(n.indexOf(t) >= 0) && Object.prototype.propertyIsEnumerable.call(l, t) && (u[t] = l[t]);
  }
  return u;
}
function cy(l, n) {
  if (l == null) return {};
  var u = {}, t = Object.keys(l), r, o;
  for (o = 0; o < t.length; o++)
    r = t[o], !(n.indexOf(r) >= 0) && (u[r] = l[r]);
  return u;
}
function Bo() {
  return Bo = Object.assign ? Object.assign.bind() : function(l) {
    for (var n = 1; n < arguments.length; n++) {
      var u = arguments[n];
      for (var t in u)
        Object.prototype.hasOwnProperty.call(u, t) && (l[t] = u[t]);
    }
    return l;
  }, Bo.apply(this, arguments);
}
function z2(l, n) {
  var u = Object.keys(l);
  if (Object.getOwnPropertySymbols) {
    var t = Object.getOwnPropertySymbols(l);
    n && (t = t.filter(function(r) {
      return Object.getOwnPropertyDescriptor(l, r).enumerable;
    })), u.push.apply(u, t);
  }
  return u;
}
function Lo(l) {
  for (var n = 1; n < arguments.length; n++) {
    var u = arguments[n] != null ? arguments[n] : {};
    n % 2 ? z2(Object(u), !0).forEach(function(t) {
      fy(l, t, u[t]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(l, Object.getOwnPropertyDescriptors(u)) : z2(Object(u)).forEach(function(t) {
      Object.defineProperty(l, t, Object.getOwnPropertyDescriptor(u, t));
    });
  }
  return l;
}
function fy(l, n, u) {
  return n = py(n), n in l ? Object.defineProperty(l, n, { value: u, enumerable: !0, configurable: !0, writable: !0 }) : l[n] = u, l;
}
function py(l) {
  var n = gy(l, "string");
  return typeof n == "symbol" ? n : String(n);
}
function gy(l, n) {
  if (typeof l != "object" || l === null) return l;
  var u = l[Symbol.toPrimitive];
  if (u !== void 0) {
    var t = u.call(l, n || "default");
    if (typeof t != "object") return t;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (n === "string" ? String : Number)(l);
}
function X3(l) {
  return l && l.map((n, u) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(n.tag, Lo({
    key: u
  }, n.attr), X3(n.child)));
}
function Wu(l) {
  return (n) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(hy, Bo({
    attr: Lo({}, l.attr)
  }, n), X3(l.child));
}
function hy(l) {
  var n = (u) => {
    var {
      attr: t,
      size: r,
      title: o
    } = l, s = dy(l, sy), d = r || u.size || "1em", a;
    return u.className && (a = u.className), l.className && (a = (a ? a + " " : "") + l.className), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", Bo({
      stroke: "currentColor",
      fill: "currentColor",
      strokeWidth: "0"
    }, u.attr, t, s, {
      className: a,
      style: Lo(Lo({
        color: l.color || u.color
      }, u.style), l.style),
      height: d,
      width: d,
      xmlns: "http://www.w3.org/2000/svg"
    }), o && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("title", null, o), l.children);
  };
  return X2 !== void 0 ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(X2.Consumer, null, (u) => n(u)) : n(Z3);
}
function z3(l) {
  return Wu({ tag: "svg", attr: { viewBox: "0 0 24 24", fill: "none" }, child: [{ tag: "path", attr: { opacity: "0.2", fillRule: "evenodd", clipRule: "evenodd", d: "M12 19C15.866 19 19 15.866 19 12C19 8.13401 15.866 5 12 5C8.13401 5 5 8.13401 5 12C5 15.866 8.13401 19 12 19ZM12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z", fill: "currentColor" }, child: [] }, { tag: "path", attr: { d: "M2 12C2 6.47715 6.47715 2 12 2V5C8.13401 5 5 8.13401 5 12H2Z", fill: "currentColor" }, child: [] }] })(l);
}
const $d = (l) => {
  const n = l.icon, u = {
    amber: "text-amber-600",
    blue: "text-blue-600",
    cyan: "text-cyan-600",
    emerald: "text-emerald-600",
    fuchsia: "text-fuchsia-600",
    green: "text-green-600",
    gray: "text-gray-600",
    indigo: "text-indigo-600",
    lime: "text-lime-600",
    orange: "text-orange-600",
    pink: "text-pink-600",
    purple: "text-purple-600",
    red: "text-red-600",
    rose: "text-rose-600",
    sky: "text-sky-600",
    teal: "text-teal-600",
    violet: "text-violet-600",
    yellow: "text-yellow-600",
    primary: "text-primary-600",
    secondary: "text-secondary-600",
    danger: "text-danger-600",
    white: "text-white-600"
  }, t = {
    amber: `${l.outlined ? "border border-amber-600 text-amber-600 hover:bg-amber-100" : "text-white bg-amber-600 hover:bg-amber-700"} focus:ring-amber-600`,
    blue: `${l.outlined ? "border border-blue-600 text-blue-600 hover:bg-blue-100" : "text-white bg-blue-600  hover:bg-blue-700"} focus:ring-blue-600`,
    cyan: `${l.outlined ? "border border-cyan-600 text-cyan-600 hover:bg-cyan-100" : "text-white bg-cyan-600 hover:bg-cyan-700"} focus:ring-cyan-600`,
    emerald: `${l.outlined ? "border border-emerald-600 text-emerald-600 hover:bg-emerald-100" : "text-white bg-emerald-600 hover:bg-emerald-700"} focus:ring-emerald-600`,
    fuchsia: `${l.outlined ? "border border-fuchsia-600 text-fuchsia-600 hover:bg-fuchsia-100" : "text-white bg-fuchsia-600 hover:bg-fuchsia-700"} focus:ring-fuchsia-600`,
    green: `${l.outlined ? "border border-green-600 text-green-600 hover:bg-green-100" : "text-white bg-green-600 hover:bg-green-700"} focus:ring-green-600`,
    gray: `${l.outlined ? "border border-gray-600 text-gray-600 hover:bg-gray-100" : "text-white bg-gray-600 hover:bg-gray-700"} focus:ring-gray-600`,
    indigo: `${l.outlined ? "border border-indigo-600 text-indigo-600 hover:bg-indigo-100" : "text-white bg-indigo-600 hover:bg-indigo-700"} focus:ring-indigo-600`,
    lime: `${l.outlined ? "border border-lime-600 text-lime-600 hover:bg-lime-100" : "text-white bg-lime-600 hover:bg-lime-700"} focus:ring-lime-600`,
    orange: `${l.outlined ? "border border-orange-600 text-orange-600 hover:bg-orange-100" : "text-white bg-orange-600 hover:bg-orange-700"} focus:ring-orange-600`,
    pink: `${l.outlined ? "border border-pink-600 text-pink-600 hover:bg-pink-100" : "text-white bg-pink-600 hover:bg-pink-700"} focus:ring-pink-600`,
    purple: `${l.outlined ? "border border-purple-600 text-purple-600 hover:bg-purple-100" : "text-white bg-purple-600 hover:bg-purple-700"} focus:ring-purple-600`,
    red: `${l.outlined ? "border border-red-600 text-red-600 hover:bg-red-100" : "text-white bg-red-600 hover:bg-red-700"} focus:ring-red-600`,
    rose: `${l.outlined ? "border border-rose-600 text-rose-600 hover:bg-rose-100" : "text-white bg-rose-600 hover:bg-rose-700"} focus:ring-rose-600`,
    sky: `${l.outlined ? "border border-sky-600 text-sky-600 hover:bg-sky-100" : "text-white bg-sky-600 hover:bg-sky-700"} focus:ring-sky-600`,
    teal: `${l.outlined ? "border border-teal-600 text-teal-600 hover:bg-teal-100" : "text-white bg-teal-600 hover:bg-teal-700"} focus:ring-teal-600`,
    violet: `${l.outlined ? "border border-violet-600 text-violet-600 hover:bg-violet-100" : "text-white bg-violet-600 hover:bg-violet-700"} focus:ring-violet-600`,
    yellow: `${l.outlined ? "border border-yellow-600 text-yellow-600 hover:bg-yellow-100" : "text-white bg-yellow-600 hover:bg-yellow-700"} focus:ring-yellow-600`,
    primary: `${l.outlined ? "border border-primary-600 text-primary-600 hover:bg-primary-100" : "text-white bg-primary-600 hover:bg-primary-700"} focus:ring-primary-600`,
    secondary: `${l.outlined ? "border border-secondary-600 text-secondary-600 hover:bg-secondary-100" : "text-gray-600 bg-secondary-600 hover:bg-secondary-700"} focus:ring-secondary-600`,
    danger: `${l.outlined ? "border border-danger-600 text-danger-600 hover:bg-danger-100" : "text-white bg-danger-600 hover:bg-danger-700"} focus:ring-danger-600`,
    white: "bg-transparent text-gray-600 hover:bg-gray-100"
  }, r = {
    lg: "px-6 py-2.5 text-sm",
    md: "px-5 py-2 text-sm",
    sm: "px-4 py-1.5 text-xs"
  }, o = {
    lg: "h-5 w-5",
    md: "h-4 w-4",
    sm: "h-3 w-3"
  };
  return l.link ? /* @__PURE__ */ y.jsxs(
    "a",
    {
      target: l.target,
      href: l.href,
      type: l.type || "submit",
      onClick: l.onClick,
      className: `${l.block ? "w-full" : ""} ${l.disabled ? "opacity-50 cursor-not-allowed" : ""} ${l.underline ? "underline decoration-2" : ""} ${l.underlineOnHover ? "hover:underline decoration-2" : ""} hover:cursor-pointer rounded my-2 mx-4 text-sm font-medium ${u[l.color]} ${l.className || ""}`,
      children: [
        l.label && /* @__PURE__ */ y.jsx("span", { children: l.label }),
        l.children
      ]
    }
  ) : /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsx(
    "button",
    {
      type: l.type || "button",
      disabled: l.disabled || !1,
      onClick: l.onClick,
      className: Oe(
        "inline-flex items-center gap-2 justify-center border rounded shadow-sm font-medium focus:outline-none focus:ring-2 focus:ring-offset-2 transition-colors duration-300",
        l.block ? "w-full" : "",
        l.disabled ? "opacity-50 cursor-not-allowed" : "",
        t[l.color],
        l.size ? r[l.size] : r.md,
        l.className || ""
      ),
      children: l.children || /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
        l.loading && /* @__PURE__ */ y.jsx(z3, { className: `animate-spin ${o[l.size || "md"]}` }),
        l.icon && /* @__PURE__ */ y.jsx(n, { className: "w-5 h-5" }),
        l.label && /* @__PURE__ */ y.jsx("span", { className: `${l.iconOnMobile ? "hidden sm:inline-block" : ""}`, children: l.label })
      ] })
    }
  ) });
};
$d.propTypes = {};
const sr = ({ className: l, children: n, clickable: u, onClick: t, ...r }) => /* @__PURE__ */ y.jsx(
  "div",
  {
    className: wl(
      "w-full rounded transition-all duration-300 border",
      u && "cursor-pointer hover:shadow-lg",
      l
    ),
    onClick: () => u && (t == null ? void 0 : t()),
    ...r,
    children: n
  }
), my = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("border-b px-6 py-4 first:rounded-t bg-gray-50", l), ...u, children: n }), vy = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("h4", { className: wl("text-base font-medium", l), ...u, children: n }), by = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("p", { className: wl("text-sm text-gray-500", l), ...u, children: n }), yy = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("text-sm", l), ...u, children: n }), $y = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("p-6 first:rounded-t", l), ...u, children: n }), xy = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("border-t px-6 py-4 last:rounded-b", l), ...u, children: n });
sr.Header = my;
sr.Title = vy;
sr.Subtitle = by;
sr.Text = yy;
sr.Body = $y;
sr.Footer = xy;
const f_ = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("container mx-auto px-4", l), ...u, children: n }), p_ = (l) => /* @__PURE__ */ y.jsxs("div", { className: "mt-6 relative", children: [
  /* @__PURE__ */ y.jsx("div", { className: "absolute inset-0 flex items-center", "aria-hidden": "true", children: /* @__PURE__ */ y.jsx("div", { className: "w-full border-t border-gray-300" }) }),
  /* @__PURE__ */ y.jsx("div", { className: "relative flex justify-center text-sm", children: /* @__PURE__ */ y.jsx("span", { className: "px-2 bg-white text-gray-500", children: l.label }) })
] });
var Cy = Object.defineProperty, wy = (l, n, u) => n in l ? Cy(l, n, { enumerable: !0, configurable: !0, writable: !0, value: u }) : l[n] = u, Qs = (l, n, u) => (wy(l, typeof n != "symbol" ? n + "" : n, u), u);
let Iy = class {
  constructor() {
    Qs(this, "current", this.detect()), Qs(this, "handoffState", "pending"), Qs(this, "currentId", 0);
  }
  set(n) {
    this.current !== n && (this.handoffState = "pending", this.currentId = 0, this.current = n);
  }
  reset() {
    this.set(this.detect());
  }
  nextId() {
    return ++this.currentId;
  }
  get isServer() {
    return this.current === "server";
  }
  get isClient() {
    return this.current === "client";
  }
  detect() {
    return typeof window > "u" || typeof document > "u" ? "server" : "client";
  }
  handoff() {
    this.handoffState === "pending" && (this.handoffState = "complete");
  }
  get isHandoffComplete() {
    return this.handoffState === "complete";
  }
}, It = new Iy();
function oa(l) {
  var n, u;
  return It.isServer ? null : l ? "ownerDocument" in l ? l.ownerDocument : "current" in l ? (u = (n = l.current) == null ? void 0 : n.ownerDocument) != null ? u : document : null : document;
}
function aa(l) {
  typeof queueMicrotask == "function" ? queueMicrotask(l) : Promise.resolve().then(l).catch((n) => setTimeout(() => {
    throw n;
  }));
}
function nt() {
  let l = [], n = { addEventListener(u, t, r, o) {
    return u.addEventListener(t, r, o), n.add(() => u.removeEventListener(t, r, o));
  }, requestAnimationFrame(...u) {
    let t = requestAnimationFrame(...u);
    return n.add(() => cancelAnimationFrame(t));
  }, nextFrame(...u) {
    return n.requestAnimationFrame(() => n.requestAnimationFrame(...u));
  }, setTimeout(...u) {
    let t = setTimeout(...u);
    return n.add(() => clearTimeout(t));
  }, microTask(...u) {
    let t = { current: !0 };
    return aa(() => {
      t.current && u[0]();
    }), n.add(() => {
      t.current = !1;
    });
  }, style(u, t, r) {
    let o = u.style.getPropertyValue(t);
    return Object.assign(u.style, { [t]: r }), this.add(() => {
      Object.assign(u.style, { [t]: o });
    });
  }, group(u) {
    let t = nt();
    return u(t), this.add(() => t.dispose());
  }, add(u) {
    return l.includes(u) || l.push(u), () => {
      let t = l.indexOf(u);
      if (t >= 0) for (let r of l.splice(t, 1)) r();
    };
  }, dispose() {
    for (let u of l.splice(0)) u();
  } };
  return n;
}
function pc() {
  let [l] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(nt);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => () => l.dispose(), [l]), l;
}
let iu = (l, n) => {
  It.isServer ? (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(l, n) : (0,react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect)(l, n);
};
function Pt(l) {
  let n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(l);
  return iu(() => {
    n.current = l;
  }, [l]), n;
}
let En = function(l) {
  let n = Pt(l);
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback((...u) => n.current(...u), [n]);
}, Ey = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(void 0);
function Ay() {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(Ey);
}
function xd(...l) {
  return Array.from(new Set(l.flatMap((n) => typeof n == "string" ? n.split(" ") : []))).filter(Boolean).join(" ");
}
function Ke(l, n, ...u) {
  if (l in n) {
    let r = n[l];
    return typeof r == "function" ? r(...u) : r;
  }
  let t = new Error(`Tried to handle "${l}" but there is no handler defined. Only defined handlers are: ${Object.keys(n).map((r) => `"${r}"`).join(", ")}.`);
  throw Error.captureStackTrace && Error.captureStackTrace(t, Ke), t;
}
var Go = ((l) => (l[l.None = 0] = "None", l[l.RenderStrategy = 1] = "RenderStrategy", l[l.Static = 2] = "Static", l))(Go || {}), Ue = ((l) => (l[l.Unmount = 0] = "Unmount", l[l.Hidden = 1] = "Hidden", l))(Ue || {});
function Vu() {
  let l = Py();
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((n) => Sy({ mergeRefs: l, ...n }), [l]);
}
function Sy({ ourProps: l, theirProps: n, slot: u, defaultTag: t, features: r, visible: o = !0, name: s, mergeRefs: d }) {
  d = d ?? Ny;
  let a = Y3(n, l);
  if (o) return so(a, u, t, s, d);
  let f = r ?? 0;
  if (f & 2) {
    let { static: p = !1, ...g } = a;
    if (p) return so(g, u, t, s, d);
  }
  if (f & 1) {
    let { unmount: p = !0, ...g } = a;
    return Ke(p ? 0 : 1, { 0() {
      return null;
    }, 1() {
      return so({ ...g, hidden: !0, style: { display: "none" } }, u, t, s, d);
    } });
  }
  return so(a, u, t, s, d);
}
function so(l, n = {}, u, t, r) {
  let { as: o = u, children: s, refName: d = "ref", ...a } = qs(l, ["unmount", "static"]), f = l.ref !== void 0 ? { [d]: l.ref } : {}, p = typeof s == "function" ? s(n) : s;
  "className" in a && a.className && typeof a.className == "function" && (a.className = a.className(n)), a["aria-labelledby"] && a["aria-labelledby"] === a.id && (a["aria-labelledby"] = void 0);
  let g = {};
  if (n) {
    let m = !1, v = [];
    for (let [$, b] of Object.entries(n)) typeof b == "boolean" && (m = !0), b === !0 && v.push($.replace(/([A-Z])/g, (E) => `-${E.toLowerCase()}`));
    if (m) {
      g["data-headlessui-state"] = v.join(" ");
      for (let $ of v) g[`data-${$}`] = "";
    }
  }
  if (o === react__WEBPACK_IMPORTED_MODULE_0__.Fragment && (Object.keys(bt(a)).length > 0 || Object.keys(bt(g)).length > 0)) if (!(0,react__WEBPACK_IMPORTED_MODULE_0__.isValidElement)(p) || Array.isArray(p) && p.length > 1) {
    if (Object.keys(bt(a)).length > 0) throw new Error(['Passing props on "Fragment"!', "", `The current component <${t} /> is rendering a "Fragment".`, "However we need to passthrough the following props:", Object.keys(bt(a)).concat(Object.keys(bt(g))).map((m) => `  - ${m}`).join(`
`), "", "You can apply a few solutions:", ['Add an `as="..."` prop, to ensure that we render an actual element instead of a "Fragment".', "Render a single element as the child so that we can forward the props onto that element."].map((m) => `  - ${m}`).join(`
`)].join(`
`));
  } else {
    let m = p.props, v = m == null ? void 0 : m.className, $ = typeof v == "function" ? (...S) => xd(v(...S), a.className) : xd(v, a.className), b = $ ? { className: $ } : {}, E = Y3(p.props, bt(qs(a, ["ref"])));
    for (let S in g) S in E && delete g[S];
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(p, Object.assign({}, E, g, f, { ref: r(Ty(p), f.ref) }, b));
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(o, Object.assign({}, qs(a, ["ref"]), o !== react__WEBPACK_IMPORTED_MODULE_0__.Fragment && f, o !== react__WEBPACK_IMPORTED_MODULE_0__.Fragment && g), p);
}
function Py() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([]), n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((u) => {
    for (let t of l.current) t != null && (typeof t == "function" ? t(u) : t.current = u);
  }, []);
  return (...u) => {
    if (!u.every((t) => t == null)) return l.current = u, n;
  };
}
function Ny(...l) {
  return l.every((n) => n == null) ? void 0 : (n) => {
    for (let u of l) u != null && (typeof u == "function" ? u(n) : u.current = n);
  };
}
function Y3(...l) {
  if (l.length === 0) return {};
  if (l.length === 1) return l[0];
  let n = {}, u = {};
  for (let t of l) for (let r in t) r.startsWith("on") && typeof t[r] == "function" ? (u[r] != null || (u[r] = []), u[r].push(t[r])) : n[r] = t[r];
  if (n.disabled || n["aria-disabled"]) for (let t in u) /^(on(?:Click|Pointer|Mouse|Key)(?:Down|Up|Press)?)$/.test(t) && (u[t] = [(r) => {
    var o;
    return (o = r == null ? void 0 : r.preventDefault) == null ? void 0 : o.call(r);
  }]);
  for (let t in u) Object.assign(n, { [t](r, ...o) {
    let s = u[t];
    for (let d of s) {
      if ((r instanceof Event || (r == null ? void 0 : r.nativeEvent) instanceof Event) && r.defaultPrevented) return;
      d(r, ...o);
    }
  } });
  return n;
}
function hu(l) {
  var n;
  return Object.assign((0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(l), { displayName: (n = l.displayName) != null ? n : l.name });
}
function bt(l) {
  let n = Object.assign({}, l);
  for (let u in n) n[u] === void 0 && delete n[u];
  return n;
}
function qs(l, n = []) {
  let u = Object.assign({}, l);
  for (let t of n) t in u && delete u[t];
  return u;
}
function Ty(l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.version.split(".")[0] >= "19" ? l.props.ref : l.ref;
}
let Ry = "span";
var jo = ((l) => (l[l.None = 1] = "None", l[l.Focusable = 2] = "Focusable", l[l.Hidden = 4] = "Hidden", l))(jo || {});
function Oy(l, n) {
  var u;
  let { features: t = 1, ...r } = l, o = { ref: n, "aria-hidden": (t & 2) === 2 ? !0 : (u = r["aria-hidden"]) != null ? u : void 0, hidden: (t & 4) === 4 ? !0 : void 0, style: { position: "fixed", top: 1, left: 1, width: 1, height: 0, padding: 0, margin: -1, overflow: "hidden", clip: "rect(0, 0, 0, 0)", whiteSpace: "nowrap", borderWidth: "0", ...(t & 4) === 4 && (t & 2) !== 2 && { display: "none" } } };
  return Vu()({ ourProps: o, theirProps: r, slot: {}, defaultTag: Ry, name: "Hidden" });
}
let Cd = hu(Oy), U3 = Symbol();
function Fy(l, n = !0) {
  return Object.assign(l, { [U3]: n });
}
function fe(...l) {
  let n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(l);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    n.current = l;
  }, [l]);
  let u = En((t) => {
    for (let r of n.current) r != null && (typeof r == "function" ? r(t) : r.current = t);
  });
  return l.every((t) => t == null || (t == null ? void 0 : t[U3])) ? void 0 : u;
}
let gc = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
gc.displayName = "DescriptionContext";
function J3() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(gc);
  if (l === null) {
    let n = new Error("You used a <Description /> component, but it is not inside a relevant parent.");
    throw Error.captureStackTrace && Error.captureStackTrace(n, J3), n;
  }
  return l;
}
function _y() {
  let [l, n] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
  return [l.length > 0 ? l.join(" ") : void 0, (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => function(u) {
    let t = En((o) => (n((s) => [...s, o]), () => n((s) => {
      let d = s.slice(), a = d.indexOf(o);
      return a !== -1 && d.splice(a, 1), d;
    }))), r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ register: t, slot: u.slot, name: u.name, props: u.props, value: u.value }), [t, u.slot, u.name, u.props, u.value]);
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement(gc.Provider, { value: r }, u.children);
  }, [n])];
}
let Dy = "p";
function My(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), t = Ay(), { id: r = `headlessui-description-${u}`, ...o } = l, s = J3(), d = fe(n);
  iu(() => s.register(r), [r, s.register]);
  let a = t || !1, f = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ ...s.slot, disabled: a }), [s.slot, a]), p = { ref: d, ...s.props, id: r };
  return Vu()({ ourProps: p, theirProps: o, slot: f, defaultTag: Dy, name: s.name || "Description" });
}
let By = hu(My), Ly = Object.assign(By, {});
var K3 = ((l) => (l.Space = " ", l.Enter = "Enter", l.Escape = "Escape", l.Backspace = "Backspace", l.Delete = "Delete", l.ArrowLeft = "ArrowLeft", l.ArrowUp = "ArrowUp", l.ArrowRight = "ArrowRight", l.ArrowDown = "ArrowDown", l.Home = "Home", l.End = "End", l.PageUp = "PageUp", l.PageDown = "PageDown", l.Tab = "Tab", l))(K3 || {});
let Gy = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(() => {
});
function jy({ value: l, children: n }) {
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(Gy.Provider, { value: l }, n);
}
let Wy = class extends Map {
  constructor(n) {
    super(), this.factory = n;
  }
  get(n) {
    let u = super.get(n);
    return u === void 0 && (u = this.factory(n), this.set(n, u)), u;
  }
};
function Q3(l, n) {
  let u = l(), t = /* @__PURE__ */ new Set();
  return { getSnapshot() {
    return u;
  }, subscribe(r) {
    return t.add(r), () => t.delete(r);
  }, dispatch(r, ...o) {
    let s = n[r].call(u, ...o);
    s && (u = s, t.forEach((d) => d()));
  } };
}
function q3(l) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useSyncExternalStore)(l.subscribe, l.getSnapshot, l.getSnapshot);
}
let Vy = new Wy(() => Q3(() => [], { ADD(l) {
  return this.includes(l) ? this : [...this, l];
}, REMOVE(l) {
  let n = this.indexOf(l);
  if (n === -1) return this;
  let u = this.slice();
  return u.splice(n, 1), u;
} }));
function dr(l, n) {
  let u = Vy.get(n), t = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), r = q3(u);
  if (iu(() => {
    if (l) return u.dispatch("ADD", t), () => u.dispatch("REMOVE", t);
  }, [u, l]), !l) return !1;
  let o = r.indexOf(t), s = r.length;
  return o === -1 && (o = s, s += 1), o === s - 1;
}
let wd = /* @__PURE__ */ new Map(), Xr = /* @__PURE__ */ new Map();
function Y2(l) {
  var n;
  let u = (n = Xr.get(l)) != null ? n : 0;
  return Xr.set(l, u + 1), u !== 0 ? () => U2(l) : (wd.set(l, { "aria-hidden": l.getAttribute("aria-hidden"), inert: l.inert }), l.setAttribute("aria-hidden", "true"), l.inert = !0, () => U2(l));
}
function U2(l) {
  var n;
  let u = (n = Xr.get(l)) != null ? n : 1;
  if (u === 1 ? Xr.delete(l) : Xr.set(l, u - 1), u !== 1) return;
  let t = wd.get(l);
  t && (t["aria-hidden"] === null ? l.removeAttribute("aria-hidden") : l.setAttribute("aria-hidden", t["aria-hidden"]), l.inert = t.inert, wd.delete(l));
}
function ky(l, { allowed: n, disallowed: u } = {}) {
  let t = dr(l, "inert-others");
  iu(() => {
    var r, o;
    if (!t) return;
    let s = nt();
    for (let a of (r = u == null ? void 0 : u()) != null ? r : []) a && s.add(Y2(a));
    let d = (o = n == null ? void 0 : n()) != null ? o : [];
    for (let a of d) {
      if (!a) continue;
      let f = oa(a);
      if (!f) continue;
      let p = a.parentElement;
      for (; p && p !== f.body; ) {
        for (let g of p.children) d.some((m) => g.contains(m)) || s.add(Y2(g));
        p = p.parentElement;
      }
    }
    return s.dispose;
  }, [t, n, u]);
}
function Hy(l, n, u) {
  let t = Pt((r) => {
    let o = r.getBoundingClientRect();
    o.x === 0 && o.y === 0 && o.width === 0 && o.height === 0 && u();
  });
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!l) return;
    let r = n === null ? null : n instanceof HTMLElement ? n : n.current;
    if (!r) return;
    let o = nt();
    if (typeof ResizeObserver < "u") {
      let s = new ResizeObserver(() => t.current(r));
      s.observe(r), o.add(() => s.disconnect());
    }
    if (typeof IntersectionObserver < "u") {
      let s = new IntersectionObserver(() => t.current(r));
      s.observe(r), o.add(() => s.disconnect());
    }
    return () => o.dispose();
  }, [n, t, l]);
}
let Wo = ["[contentEditable=true]", "[tabindex]", "a[href]", "area[href]", "button:not([disabled])", "iframe", "input:not([disabled])", "select:not([disabled])", "textarea:not([disabled])"].map((l) => `${l}:not([tabindex='-1'])`).join(","), Zy = ["[data-autofocus]"].map((l) => `${l}:not([tabindex='-1'])`).join(",");
var Ae = ((l) => (l[l.First = 1] = "First", l[l.Previous = 2] = "Previous", l[l.Next = 4] = "Next", l[l.Last = 8] = "Last", l[l.WrapAround = 16] = "WrapAround", l[l.NoScroll = 32] = "NoScroll", l[l.AutoFocus = 64] = "AutoFocus", l))(Ae || {}), Id = ((l) => (l[l.Error = 0] = "Error", l[l.Overflow = 1] = "Overflow", l[l.Success = 2] = "Success", l[l.Underflow = 3] = "Underflow", l))(Id || {}), Xy = ((l) => (l[l.Previous = -1] = "Previous", l[l.Next = 1] = "Next", l))(Xy || {});
function zy(l = document.body) {
  return l == null ? [] : Array.from(l.querySelectorAll(Wo)).sort((n, u) => Math.sign((n.tabIndex || Number.MAX_SAFE_INTEGER) - (u.tabIndex || Number.MAX_SAFE_INTEGER)));
}
function Yy(l = document.body) {
  return l == null ? [] : Array.from(l.querySelectorAll(Zy)).sort((n, u) => Math.sign((n.tabIndex || Number.MAX_SAFE_INTEGER) - (u.tabIndex || Number.MAX_SAFE_INTEGER)));
}
var l4 = ((l) => (l[l.Strict = 0] = "Strict", l[l.Loose = 1] = "Loose", l))(l4 || {});
function Uy(l, n = 0) {
  var u;
  return l === ((u = oa(l)) == null ? void 0 : u.body) ? !1 : Ke(n, { 0() {
    return l.matches(Wo);
  }, 1() {
    let t = l;
    for (; t !== null; ) {
      if (t.matches(Wo)) return !0;
      t = t.parentElement;
    }
    return !1;
  } });
}
var Jy = ((l) => (l[l.Keyboard = 0] = "Keyboard", l[l.Mouse = 1] = "Mouse", l))(Jy || {});
typeof window < "u" && typeof document < "u" && (document.addEventListener("keydown", (l) => {
  l.metaKey || l.altKey || l.ctrlKey || (document.documentElement.dataset.headlessuiFocusVisible = "");
}, !0), document.addEventListener("click", (l) => {
  l.detail === 1 ? delete document.documentElement.dataset.headlessuiFocusVisible : l.detail === 0 && (document.documentElement.dataset.headlessuiFocusVisible = "");
}, !0));
function Se(l) {
  l == null || l.focus({ preventScroll: !0 });
}
let Ky = ["textarea", "input"].join(",");
function Qy(l) {
  var n, u;
  return (u = (n = l == null ? void 0 : l.matches) == null ? void 0 : n.call(l, Ky)) != null ? u : !1;
}
function qy(l, n = (u) => u) {
  return l.slice().sort((u, t) => {
    let r = n(u), o = n(t);
    if (r === null || o === null) return 0;
    let s = r.compareDocumentPosition(o);
    return s & Node.DOCUMENT_POSITION_FOLLOWING ? -1 : s & Node.DOCUMENT_POSITION_PRECEDING ? 1 : 0;
  });
}
function zr(l, n, { sorted: u = !0, relativeTo: t = null, skipElements: r = [] } = {}) {
  let o = Array.isArray(l) ? l.length > 0 ? l[0].ownerDocument : document : l.ownerDocument, s = Array.isArray(l) ? u ? qy(l) : l : n & 64 ? Yy(l) : zy(l);
  r.length > 0 && s.length > 1 && (s = s.filter((v) => !r.some(($) => $ != null && "current" in $ ? ($ == null ? void 0 : $.current) === v : $ === v))), t = t ?? o.activeElement;
  let d = (() => {
    if (n & 5) return 1;
    if (n & 10) return -1;
    throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
  })(), a = (() => {
    if (n & 1) return 0;
    if (n & 2) return Math.max(0, s.indexOf(t)) - 1;
    if (n & 4) return Math.max(0, s.indexOf(t)) + 1;
    if (n & 8) return s.length - 1;
    throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
  })(), f = n & 32 ? { preventScroll: !0 } : {}, p = 0, g = s.length, m;
  do {
    if (p >= g || p + g <= 0) return 0;
    let v = a + p;
    if (n & 16) v = (v + g) % g;
    else {
      if (v < 0) return 3;
      if (v >= g) return 1;
    }
    m = s[v], m == null || m.focus(f), p += d;
  } while (m !== o.activeElement);
  return n & 6 && Qy(m) && m.select(), 2;
}
function n4() {
  return /iPhone/gi.test(window.navigator.platform) || /Mac/gi.test(window.navigator.platform) && window.navigator.maxTouchPoints > 0;
}
function l$() {
  return /Android/gi.test(window.navigator.userAgent);
}
function n$() {
  return n4() || l$();
}
function Gr(l, n, u, t) {
  let r = Pt(u);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!l) return;
    function o(s) {
      r.current(s);
    }
    return document.addEventListener(n, o, t), () => document.removeEventListener(n, o, t);
  }, [l, n, t]);
}
function u4(l, n, u, t) {
  let r = Pt(u);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!l) return;
    function o(s) {
      r.current(s);
    }
    return window.addEventListener(n, o, t), () => window.removeEventListener(n, o, t);
  }, [l, n, t]);
}
const J2 = 30;
function u$(l, n, u) {
  let t = dr(l, "outside-click"), r = Pt(u), o = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(a, f) {
    if (a.defaultPrevented) return;
    let p = f(a);
    if (p === null || !p.getRootNode().contains(p) || !p.isConnected) return;
    let g = function m(v) {
      return typeof v == "function" ? m(v()) : Array.isArray(v) || v instanceof Set ? v : [v];
    }(n);
    for (let m of g) if (m !== null && (m.contains(p) || a.composed && a.composedPath().includes(m))) return;
    return !Uy(p, l4.Loose) && p.tabIndex !== -1 && a.preventDefault(), r.current(a, p);
  }, [r, n]), s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  Gr(t, "pointerdown", (a) => {
    var f, p;
    s.current = ((p = (f = a.composedPath) == null ? void 0 : f.call(a)) == null ? void 0 : p[0]) || a.target;
  }, !0), Gr(t, "mousedown", (a) => {
    var f, p;
    s.current = ((p = (f = a.composedPath) == null ? void 0 : f.call(a)) == null ? void 0 : p[0]) || a.target;
  }, !0), Gr(t, "click", (a) => {
    n$() || s.current && (o(a, () => s.current), s.current = null);
  }, !0);
  let d = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)({ x: 0, y: 0 });
  Gr(t, "touchstart", (a) => {
    d.current.x = a.touches[0].clientX, d.current.y = a.touches[0].clientY;
  }, !0), Gr(t, "touchend", (a) => {
    let f = { x: a.changedTouches[0].clientX, y: a.changedTouches[0].clientY };
    if (!(Math.abs(f.x - d.current.x) >= J2 || Math.abs(f.y - d.current.y) >= J2)) return o(a, () => a.target instanceof HTMLElement ? a.target : null);
  }, !0), u4(t, "blur", (a) => o(a, () => window.document.activeElement instanceof HTMLIFrameElement ? window.document.activeElement : null), !0);
}
function sa(...l) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => oa(...l), [...l]);
}
function e4(l, n, u, t) {
  let r = Pt(u);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    l = l ?? window;
    function o(s) {
      r.current(s);
    }
    return l.addEventListener(n, o, t), () => l.removeEventListener(n, o, t);
  }, [l, n, t]);
}
function e$() {
  let l;
  return { before({ doc: n }) {
    var u;
    let t = n.documentElement, r = (u = n.defaultView) != null ? u : window;
    l = Math.max(0, r.innerWidth - t.clientWidth);
  }, after({ doc: n, d: u }) {
    let t = n.documentElement, r = Math.max(0, t.clientWidth - t.offsetWidth), o = Math.max(0, l - r);
    u.style(t, "paddingRight", `${o}px`);
  } };
}
function t$() {
  return n4() ? { before({ doc: l, d: n, meta: u }) {
    function t(r) {
      return u.containers.flatMap((o) => o()).some((o) => o.contains(r));
    }
    n.microTask(() => {
      var r;
      if (window.getComputedStyle(l.documentElement).scrollBehavior !== "auto") {
        let d = nt();
        d.style(l.documentElement, "scrollBehavior", "auto"), n.add(() => n.microTask(() => d.dispose()));
      }
      let o = (r = window.scrollY) != null ? r : window.pageYOffset, s = null;
      n.addEventListener(l, "click", (d) => {
        if (d.target instanceof HTMLElement) try {
          let a = d.target.closest("a");
          if (!a) return;
          let { hash: f } = new URL(a.href), p = l.querySelector(f);
          p && !t(p) && (s = p);
        } catch {
        }
      }, !0), n.addEventListener(l, "touchstart", (d) => {
        if (d.target instanceof HTMLElement) if (t(d.target)) {
          let a = d.target;
          for (; a.parentElement && t(a.parentElement); ) a = a.parentElement;
          n.style(a, "overscrollBehavior", "contain");
        } else n.style(d.target, "touchAction", "none");
      }), n.addEventListener(l, "touchmove", (d) => {
        if (d.target instanceof HTMLElement) {
          if (d.target.tagName === "INPUT") return;
          if (t(d.target)) {
            let a = d.target;
            for (; a.parentElement && a.dataset.headlessuiPortal !== "" && !(a.scrollHeight > a.clientHeight || a.scrollWidth > a.clientWidth); ) a = a.parentElement;
            a.dataset.headlessuiPortal === "" && d.preventDefault();
          } else d.preventDefault();
        }
      }, { passive: !1 }), n.add(() => {
        var d;
        let a = (d = window.scrollY) != null ? d : window.pageYOffset;
        o !== a && window.scrollTo(0, o), s && s.isConnected && (s.scrollIntoView({ block: "nearest" }), s = null);
      });
    });
  } } : {};
}
function r$() {
  return { before({ doc: l, d: n }) {
    n.style(l.documentElement, "overflow", "hidden");
  } };
}
function i$(l) {
  let n = {};
  for (let u of l) Object.assign(n, u(n));
  return n;
}
let Ct = Q3(() => /* @__PURE__ */ new Map(), { PUSH(l, n) {
  var u;
  let t = (u = this.get(l)) != null ? u : { doc: l, count: 0, d: nt(), meta: /* @__PURE__ */ new Set() };
  return t.count++, t.meta.add(n), this.set(l, t), this;
}, POP(l, n) {
  let u = this.get(l);
  return u && (u.count--, u.meta.delete(n)), this;
}, SCROLL_PREVENT({ doc: l, d: n, meta: u }) {
  let t = { doc: l, d: n, meta: i$(u) }, r = [t$(), e$(), r$()];
  r.forEach(({ before: o }) => o == null ? void 0 : o(t)), r.forEach(({ after: o }) => o == null ? void 0 : o(t));
}, SCROLL_ALLOW({ d: l }) {
  l.dispose();
}, TEARDOWN({ doc: l }) {
  this.delete(l);
} });
Ct.subscribe(() => {
  let l = Ct.getSnapshot(), n = /* @__PURE__ */ new Map();
  for (let [u] of l) n.set(u, u.documentElement.style.overflow);
  for (let u of l.values()) {
    let t = n.get(u.doc) === "hidden", r = u.count !== 0;
    (r && !t || !r && t) && Ct.dispatch(u.count > 0 ? "SCROLL_PREVENT" : "SCROLL_ALLOW", u), u.count === 0 && Ct.dispatch("TEARDOWN", u);
  }
});
function o$(l, n, u = () => ({ containers: [] })) {
  let t = q3(Ct), r = n ? t.get(n) : void 0, o = r ? r.count > 0 : !1;
  return iu(() => {
    if (!(!n || !l)) return Ct.dispatch("PUSH", n, u), () => Ct.dispatch("POP", n, u);
  }, [l, n]), o;
}
function a$(l, n, u = () => [document.body]) {
  let t = dr(l, "scroll-lock");
  o$(t, n, (r) => {
    var o;
    return { containers: [...(o = r.containers) != null ? o : [], u] };
  });
}
function s$(l = 0) {
  let [n, u] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(l), t = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((a) => u(a), [n]), r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((a) => u((f) => f | a), [n]), o = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((a) => (n & a) === a, [n]), s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((a) => u((f) => f & ~a), [u]), d = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((a) => u((f) => f ^ a), [u]);
  return { flags: n, setFlag: t, addFlag: r, hasFlag: o, removeFlag: s, toggleFlag: d };
}
var K2, Q2;
typeof process < "u" && typeof globalThis < "u" && typeof Element < "u" && ((K2 = process == null ? void 0 : process.env) == null ? void 0 : K2.NODE_ENV) === "test" && typeof ((Q2 = Element == null ? void 0 : Element.prototype) == null ? void 0 : Q2.getAnimations) > "u" && (Element.prototype.getAnimations = function() {
  return console.warn(["Headless UI has polyfilled `Element.prototype.getAnimations` for your tests.", "Please install a proper polyfill e.g. `jsdom-testing-mocks`, to silence these warnings.", "", "Example usage:", "```js", "import { mockAnimationsApi } from 'jsdom-testing-mocks'", "mockAnimationsApi()", "```"].join(`
`)), [];
});
var d$ = ((l) => (l[l.None = 0] = "None", l[l.Closed = 1] = "Closed", l[l.Enter = 2] = "Enter", l[l.Leave = 4] = "Leave", l))(d$ || {});
function c$(l) {
  let n = {};
  for (let u in l) l[u] === !0 && (n[`data-${u}`] = "");
  return n;
}
function f$(l, n, u, t) {
  let [r, o] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(u), { hasFlag: s, addFlag: d, removeFlag: a } = s$(l && r ? 3 : 0), f = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1), p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1), g = pc();
  return iu(() => {
    var m;
    if (l) {
      if (u && o(!0), !n) {
        u && d(3);
        return;
      }
      return (m = t == null ? void 0 : t.start) == null || m.call(t, u), p$(n, { inFlight: f, prepare() {
        p.current ? p.current = !1 : p.current = f.current, f.current = !0, !p.current && (u ? (d(3), a(4)) : (d(4), a(2)));
      }, run() {
        p.current ? u ? (a(3), d(4)) : (a(4), d(3)) : u ? a(1) : d(1);
      }, done() {
        var v;
        p.current && typeof n.getAnimations == "function" && n.getAnimations().length > 0 || (f.current = !1, a(7), u || o(!1), (v = t == null ? void 0 : t.end) == null || v.call(t, u));
      } });
    }
  }, [l, u, n, g]), l ? [r, { closed: s(1), enter: s(2), leave: s(4), transition: s(2) || s(4) }] : [u, { closed: void 0, enter: void 0, leave: void 0, transition: void 0 }];
}
function p$(l, { prepare: n, run: u, done: t, inFlight: r }) {
  let o = nt();
  return h$(l, { prepare: n, inFlight: r }), o.nextFrame(() => {
    u(), o.requestAnimationFrame(() => {
      o.add(g$(l, t));
    });
  }), o.dispose;
}
function g$(l, n) {
  var u, t;
  let r = nt();
  if (!l) return r.dispose;
  let o = !1;
  r.add(() => {
    o = !0;
  });
  let s = (t = (u = l.getAnimations) == null ? void 0 : u.call(l).filter((d) => d instanceof CSSTransition)) != null ? t : [];
  return s.length === 0 ? (n(), r.dispose) : (Promise.allSettled(s.map((d) => d.finished)).then(() => {
    o || n();
  }), r.dispose);
}
function h$(l, { inFlight: n, prepare: u }) {
  if (n != null && n.current) {
    u();
    return;
  }
  let t = l.style.transition;
  l.style.transition = "none", u(), l.offsetHeight, l.style.transition = t;
}
function hc(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([]), t = En(l);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    let r = [...u.current];
    for (let [o, s] of n.entries()) if (u.current[o] !== s) {
      let d = t(n, r);
      return u.current = n, d;
    }
  }, [t, ...n]);
}
const m$ = ["top", "right", "bottom", "left"], Qe = Math.min, wu = Math.max, Vo = Math.round, co = Math.floor, qe = (l) => ({
  x: l,
  y: l
}), v$ = {
  left: "right",
  right: "left",
  bottom: "top",
  top: "bottom"
}, b$ = {
  start: "end",
  end: "start"
};
function Ed(l, n, u) {
  return wu(l, Qe(n, u));
}
function Pe(l, n) {
  return typeof l == "function" ? l(n) : l;
}
function Ne(l) {
  return l.split("-")[0];
}
function cr(l) {
  return l.split("-")[1];
}
function mc(l) {
  return l === "x" ? "y" : "x";
}
function vc(l) {
  return l === "y" ? "height" : "width";
}
function fr(l) {
  return ["top", "bottom"].includes(Ne(l)) ? "y" : "x";
}
function bc(l) {
  return mc(fr(l));
}
function y$(l, n, u) {
  u === void 0 && (u = !1);
  const t = cr(l), r = bc(l), o = vc(r);
  let s = r === "x" ? t === (u ? "end" : "start") ? "right" : "left" : t === "start" ? "bottom" : "top";
  return n.reference[o] > n.floating[o] && (s = ko(s)), [s, ko(s)];
}
function $$(l) {
  const n = ko(l);
  return [Ad(l), n, Ad(n)];
}
function Ad(l) {
  return l.replace(/start|end/g, (n) => b$[n]);
}
function x$(l, n, u) {
  const t = ["left", "right"], r = ["right", "left"], o = ["top", "bottom"], s = ["bottom", "top"];
  switch (l) {
    case "top":
    case "bottom":
      return u ? n ? r : t : n ? t : r;
    case "left":
    case "right":
      return n ? o : s;
    default:
      return [];
  }
}
function C$(l, n, u, t) {
  const r = cr(l);
  let o = x$(Ne(l), u === "start", t);
  return r && (o = o.map((s) => s + "-" + r), n && (o = o.concat(o.map(Ad)))), o;
}
function ko(l) {
  return l.replace(/left|right|bottom|top/g, (n) => v$[n]);
}
function w$(l) {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...l
  };
}
function t4(l) {
  return typeof l != "number" ? w$(l) : {
    top: l,
    right: l,
    bottom: l,
    left: l
  };
}
function Ho(l) {
  return {
    ...l,
    top: l.y,
    left: l.x,
    right: l.x + l.width,
    bottom: l.y + l.height
  };
}
function q2(l, n, u) {
  let {
    reference: t,
    floating: r
  } = l;
  const o = fr(n), s = bc(n), d = vc(s), a = Ne(n), f = o === "y", p = t.x + t.width / 2 - r.width / 2, g = t.y + t.height / 2 - r.height / 2, m = t[d] / 2 - r[d] / 2;
  let v;
  switch (a) {
    case "top":
      v = {
        x: p,
        y: t.y - r.height
      };
      break;
    case "bottom":
      v = {
        x: p,
        y: t.y + t.height
      };
      break;
    case "right":
      v = {
        x: t.x + t.width,
        y: g
      };
      break;
    case "left":
      v = {
        x: t.x - r.width,
        y: g
      };
      break;
    default:
      v = {
        x: t.x,
        y: t.y
      };
  }
  switch (cr(n)) {
    case "start":
      v[s] -= m * (u && f ? -1 : 1);
      break;
    case "end":
      v[s] += m * (u && f ? -1 : 1);
      break;
  }
  return v;
}
const I$ = async (l, n, u) => {
  const {
    placement: t = "bottom",
    strategy: r = "absolute",
    middleware: o = [],
    platform: s
  } = u, d = o.filter(Boolean), a = await (s.isRTL == null ? void 0 : s.isRTL(n));
  let f = await s.getElementRects({
    reference: l,
    floating: n,
    strategy: r
  }), {
    x: p,
    y: g
  } = q2(f, t, a), m = t, v = {}, $ = 0;
  for (let b = 0; b < d.length; b++) {
    const {
      name: E,
      fn: S
    } = d[b], {
      x: A,
      y: x,
      data: I,
      reset: P
    } = await S({
      x: p,
      y: g,
      initialPlacement: t,
      placement: m,
      strategy: r,
      middlewareData: v,
      rects: f,
      platform: s,
      elements: {
        reference: l,
        floating: n
      }
    });
    p = A ?? p, g = x ?? g, v = {
      ...v,
      [E]: {
        ...v[E],
        ...I
      }
    }, P && $ <= 50 && ($++, typeof P == "object" && (P.placement && (m = P.placement), P.rects && (f = P.rects === !0 ? await s.getElementRects({
      reference: l,
      floating: n,
      strategy: r
    }) : P.rects), {
      x: p,
      y: g
    } = q2(f, m, a)), b = -1);
  }
  return {
    x: p,
    y: g,
    placement: m,
    strategy: r,
    middlewareData: v
  };
};
async function Yr(l, n) {
  var u;
  n === void 0 && (n = {});
  const {
    x: t,
    y: r,
    platform: o,
    rects: s,
    elements: d,
    strategy: a
  } = l, {
    boundary: f = "clippingAncestors",
    rootBoundary: p = "viewport",
    elementContext: g = "floating",
    altBoundary: m = !1,
    padding: v = 0
  } = Pe(n, l), $ = t4(v), E = d[m ? g === "floating" ? "reference" : "floating" : g], S = Ho(await o.getClippingRect({
    element: (u = await (o.isElement == null ? void 0 : o.isElement(E))) == null || u ? E : E.contextElement || await (o.getDocumentElement == null ? void 0 : o.getDocumentElement(d.floating)),
    boundary: f,
    rootBoundary: p,
    strategy: a
  })), A = g === "floating" ? {
    ...s.floating,
    x: t,
    y: r
  } : s.reference, x = await (o.getOffsetParent == null ? void 0 : o.getOffsetParent(d.floating)), I = await (o.isElement == null ? void 0 : o.isElement(x)) ? await (o.getScale == null ? void 0 : o.getScale(x)) || {
    x: 1,
    y: 1
  } : {
    x: 1,
    y: 1
  }, P = Ho(o.convertOffsetParentRelativeRectToViewportRelativeRect ? await o.convertOffsetParentRelativeRectToViewportRelativeRect({
    elements: d,
    rect: A,
    offsetParent: x,
    strategy: a
  }) : A);
  return {
    top: (S.top - P.top + $.top) / I.y,
    bottom: (P.bottom - S.bottom + $.bottom) / I.y,
    left: (S.left - P.left + $.left) / I.x,
    right: (P.right - S.right + $.right) / I.x
  };
}
const E$ = (l) => ({
  name: "arrow",
  options: l,
  async fn(n) {
    const {
      x: u,
      y: t,
      placement: r,
      rects: o,
      platform: s,
      elements: d,
      middlewareData: a
    } = n, {
      element: f,
      padding: p = 0
    } = Pe(l, n) || {};
    if (f == null)
      return {};
    const g = t4(p), m = {
      x: u,
      y: t
    }, v = bc(r), $ = vc(v), b = await s.getDimensions(f), E = v === "y", S = E ? "top" : "left", A = E ? "bottom" : "right", x = E ? "clientHeight" : "clientWidth", I = o.reference[$] + o.reference[v] - m[v] - o.floating[$], P = m[v] - o.reference[v], O = await (s.getOffsetParent == null ? void 0 : s.getOffsetParent(f));
    let _ = O ? O[x] : 0;
    (!_ || !await (s.isElement == null ? void 0 : s.isElement(O))) && (_ = d.floating[x] || o.floating[$]);
    const j = I / 2 - P / 2, z = _ / 2 - b[$] / 2 - 1, Y = Qe(g[S], z), el = Qe(g[A], z), U = Y, ul = _ - b[$] - el, il = _ / 2 - b[$] / 2 + j, rl = Ed(U, il, ul), tl = !a.arrow && cr(r) != null && il !== rl && o.reference[$] / 2 - (il < U ? Y : el) - b[$] / 2 < 0, sl = tl ? il < U ? il - U : il - ul : 0;
    return {
      [v]: m[v] + sl,
      data: {
        [v]: rl,
        centerOffset: il - rl - sl,
        ...tl && {
          alignmentOffset: sl
        }
      },
      reset: tl
    };
  }
}), A$ = function(l) {
  return l === void 0 && (l = {}), {
    name: "flip",
    options: l,
    async fn(n) {
      var u, t;
      const {
        placement: r,
        middlewareData: o,
        rects: s,
        initialPlacement: d,
        platform: a,
        elements: f
      } = n, {
        mainAxis: p = !0,
        crossAxis: g = !0,
        fallbackPlacements: m,
        fallbackStrategy: v = "bestFit",
        fallbackAxisSideDirection: $ = "none",
        flipAlignment: b = !0,
        ...E
      } = Pe(l, n);
      if ((u = o.arrow) != null && u.alignmentOffset)
        return {};
      const S = Ne(r), A = Ne(d) === d, x = await (a.isRTL == null ? void 0 : a.isRTL(f.floating)), I = m || (A || !b ? [ko(d)] : $$(d));
      !m && $ !== "none" && I.push(...C$(d, b, $, x));
      const P = [d, ...I], O = await Yr(n, E), _ = [];
      let j = ((t = o.flip) == null ? void 0 : t.overflows) || [];
      if (p && _.push(O[S]), g) {
        const U = y$(r, s, x);
        _.push(O[U[0]], O[U[1]]);
      }
      if (j = [...j, {
        placement: r,
        overflows: _
      }], !_.every((U) => U <= 0)) {
        var z, Y;
        const U = (((z = o.flip) == null ? void 0 : z.index) || 0) + 1, ul = P[U];
        if (ul)
          return {
            data: {
              index: U,
              overflows: j
            },
            reset: {
              placement: ul
            }
          };
        let il = (Y = j.filter((rl) => rl.overflows[0] <= 0).sort((rl, tl) => rl.overflows[1] - tl.overflows[1])[0]) == null ? void 0 : Y.placement;
        if (!il)
          switch (v) {
            case "bestFit": {
              var el;
              const rl = (el = j.map((tl) => [tl.placement, tl.overflows.filter((sl) => sl > 0).reduce((sl, ll) => sl + ll, 0)]).sort((tl, sl) => tl[1] - sl[1])[0]) == null ? void 0 : el[0];
              rl && (il = rl);
              break;
            }
            case "initialPlacement":
              il = d;
              break;
          }
        if (r !== il)
          return {
            reset: {
              placement: il
            }
          };
      }
      return {};
    }
  };
};
function lf(l, n) {
  return {
    top: l.top - n.height,
    right: l.right - n.width,
    bottom: l.bottom - n.height,
    left: l.left - n.width
  };
}
function nf(l) {
  return m$.some((n) => l[n] >= 0);
}
const S$ = function(l) {
  return l === void 0 && (l = {}), {
    name: "hide",
    options: l,
    async fn(n) {
      const {
        rects: u
      } = n, {
        strategy: t = "referenceHidden",
        ...r
      } = Pe(l, n);
      switch (t) {
        case "referenceHidden": {
          const o = await Yr(n, {
            ...r,
            elementContext: "reference"
          }), s = lf(o, u.reference);
          return {
            data: {
              referenceHiddenOffsets: s,
              referenceHidden: nf(s)
            }
          };
        }
        case "escaped": {
          const o = await Yr(n, {
            ...r,
            altBoundary: !0
          }), s = lf(o, u.floating);
          return {
            data: {
              escapedOffsets: s,
              escaped: nf(s)
            }
          };
        }
        default:
          return {};
      }
    }
  };
};
async function P$(l, n) {
  const {
    placement: u,
    platform: t,
    elements: r
  } = l, o = await (t.isRTL == null ? void 0 : t.isRTL(r.floating)), s = Ne(u), d = cr(u), a = fr(u) === "y", f = ["left", "top"].includes(s) ? -1 : 1, p = o && a ? -1 : 1, g = Pe(n, l);
  let {
    mainAxis: m,
    crossAxis: v,
    alignmentAxis: $
  } = typeof g == "number" ? {
    mainAxis: g,
    crossAxis: 0,
    alignmentAxis: null
  } : {
    mainAxis: 0,
    crossAxis: 0,
    alignmentAxis: null,
    ...g
  };
  return d && typeof $ == "number" && (v = d === "end" ? $ * -1 : $), a ? {
    x: v * p,
    y: m * f
  } : {
    x: m * f,
    y: v * p
  };
}
const N$ = function(l) {
  return l === void 0 && (l = 0), {
    name: "offset",
    options: l,
    async fn(n) {
      var u, t;
      const {
        x: r,
        y: o,
        placement: s,
        middlewareData: d
      } = n, a = await P$(n, l);
      return s === ((u = d.offset) == null ? void 0 : u.placement) && (t = d.arrow) != null && t.alignmentOffset ? {} : {
        x: r + a.x,
        y: o + a.y,
        data: {
          ...a,
          placement: s
        }
      };
    }
  };
}, T$ = function(l) {
  return l === void 0 && (l = {}), {
    name: "shift",
    options: l,
    async fn(n) {
      const {
        x: u,
        y: t,
        placement: r
      } = n, {
        mainAxis: o = !0,
        crossAxis: s = !1,
        limiter: d = {
          fn: (E) => {
            let {
              x: S,
              y: A
            } = E;
            return {
              x: S,
              y: A
            };
          }
        },
        ...a
      } = Pe(l, n), f = {
        x: u,
        y: t
      }, p = await Yr(n, a), g = fr(Ne(r)), m = mc(g);
      let v = f[m], $ = f[g];
      if (o) {
        const E = m === "y" ? "top" : "left", S = m === "y" ? "bottom" : "right", A = v + p[E], x = v - p[S];
        v = Ed(A, v, x);
      }
      if (s) {
        const E = g === "y" ? "top" : "left", S = g === "y" ? "bottom" : "right", A = $ + p[E], x = $ - p[S];
        $ = Ed(A, $, x);
      }
      const b = d.fn({
        ...n,
        [m]: v,
        [g]: $
      });
      return {
        ...b,
        data: {
          x: b.x - u,
          y: b.y - t
        }
      };
    }
  };
}, R$ = function(l) {
  return l === void 0 && (l = {}), {
    options: l,
    fn(n) {
      const {
        x: u,
        y: t,
        placement: r,
        rects: o,
        middlewareData: s
      } = n, {
        offset: d = 0,
        mainAxis: a = !0,
        crossAxis: f = !0
      } = Pe(l, n), p = {
        x: u,
        y: t
      }, g = fr(r), m = mc(g);
      let v = p[m], $ = p[g];
      const b = Pe(d, n), E = typeof b == "number" ? {
        mainAxis: b,
        crossAxis: 0
      } : {
        mainAxis: 0,
        crossAxis: 0,
        ...b
      };
      if (a) {
        const x = m === "y" ? "height" : "width", I = o.reference[m] - o.floating[x] + E.mainAxis, P = o.reference[m] + o.reference[x] - E.mainAxis;
        v < I ? v = I : v > P && (v = P);
      }
      if (f) {
        var S, A;
        const x = m === "y" ? "width" : "height", I = ["top", "left"].includes(Ne(r)), P = o.reference[g] - o.floating[x] + (I && ((S = s.offset) == null ? void 0 : S[g]) || 0) + (I ? 0 : E.crossAxis), O = o.reference[g] + o.reference[x] + (I ? 0 : ((A = s.offset) == null ? void 0 : A[g]) || 0) - (I ? E.crossAxis : 0);
        $ < P ? $ = P : $ > O && ($ = O);
      }
      return {
        [m]: v,
        [g]: $
      };
    }
  };
}, O$ = function(l) {
  return l === void 0 && (l = {}), {
    name: "size",
    options: l,
    async fn(n) {
      const {
        placement: u,
        rects: t,
        platform: r,
        elements: o
      } = n, {
        apply: s = () => {
        },
        ...d
      } = Pe(l, n), a = await Yr(n, d), f = Ne(u), p = cr(u), g = fr(u) === "y", {
        width: m,
        height: v
      } = t.floating;
      let $, b;
      f === "top" || f === "bottom" ? ($ = f, b = p === (await (r.isRTL == null ? void 0 : r.isRTL(o.floating)) ? "start" : "end") ? "left" : "right") : (b = f, $ = p === "end" ? "top" : "bottom");
      const E = v - a[$], S = m - a[b], A = !n.middlewareData.shift;
      let x = E, I = S;
      if (g) {
        const O = m - a.left - a.right;
        I = p || A ? Qe(S, O) : O;
      } else {
        const O = v - a.top - a.bottom;
        x = p || A ? Qe(E, O) : O;
      }
      if (A && !p) {
        const O = wu(a.left, 0), _ = wu(a.right, 0), j = wu(a.top, 0), z = wu(a.bottom, 0);
        g ? I = m - 2 * (O !== 0 || _ !== 0 ? O + _ : wu(a.left, a.right)) : x = v - 2 * (j !== 0 || z !== 0 ? j + z : wu(a.top, a.bottom));
      }
      await s({
        ...n,
        availableWidth: I,
        availableHeight: x
      });
      const P = await r.getDimensions(o.floating);
      return m !== P.width || v !== P.height ? {
        reset: {
          rects: !0
        }
      } : {};
    }
  };
};
function lt(l) {
  return r4(l) ? (l.nodeName || "").toLowerCase() : "#document";
}
function Eu(l) {
  var n;
  return (l == null || (n = l.ownerDocument) == null ? void 0 : n.defaultView) || window;
}
function Fe(l) {
  var n;
  return (n = (r4(l) ? l.ownerDocument : l.document) || window.document) == null ? void 0 : n.documentElement;
}
function r4(l) {
  return l instanceof Node || l instanceof Eu(l).Node;
}
function Te(l) {
  return l instanceof Element || l instanceof Eu(l).Element;
}
function de(l) {
  return l instanceof HTMLElement || l instanceof Eu(l).HTMLElement;
}
function uf(l) {
  return typeof ShadowRoot > "u" ? !1 : l instanceof ShadowRoot || l instanceof Eu(l).ShadowRoot;
}
function ei(l) {
  const {
    overflow: n,
    overflowX: u,
    overflowY: t,
    display: r
  } = Gu(l);
  return /auto|scroll|overlay|hidden|clip/.test(n + t + u) && !["inline", "contents"].includes(r);
}
function F$(l) {
  return ["table", "td", "th"].includes(lt(l));
}
function yc(l) {
  const n = $c(), u = Gu(l);
  return u.transform !== "none" || u.perspective !== "none" || (u.containerType ? u.containerType !== "normal" : !1) || !n && (u.backdropFilter ? u.backdropFilter !== "none" : !1) || !n && (u.filter ? u.filter !== "none" : !1) || ["transform", "perspective", "filter"].some((t) => (u.willChange || "").includes(t)) || ["paint", "layout", "strict", "content"].some((t) => (u.contain || "").includes(t));
}
function _$(l) {
  let n = ur(l);
  for (; de(n) && !da(n); ) {
    if (yc(n))
      return n;
    n = ur(n);
  }
  return null;
}
function $c() {
  return typeof CSS > "u" || !CSS.supports ? !1 : CSS.supports("-webkit-backdrop-filter", "none");
}
function da(l) {
  return ["html", "body", "#document"].includes(lt(l));
}
function Gu(l) {
  return Eu(l).getComputedStyle(l);
}
function ca(l) {
  return Te(l) ? {
    scrollLeft: l.scrollLeft,
    scrollTop: l.scrollTop
  } : {
    scrollLeft: l.pageXOffset,
    scrollTop: l.pageYOffset
  };
}
function ur(l) {
  if (lt(l) === "html")
    return l;
  const n = (
    // Step into the shadow DOM of the parent of a slotted node.
    l.assignedSlot || // DOM Element detected.
    l.parentNode || // ShadowRoot detected.
    uf(l) && l.host || // Fallback.
    Fe(l)
  );
  return uf(n) ? n.host : n;
}
function i4(l) {
  const n = ur(l);
  return da(n) ? l.ownerDocument ? l.ownerDocument.body : l.body : de(n) && ei(n) ? n : i4(n);
}
function Ur(l, n, u) {
  var t;
  n === void 0 && (n = []), u === void 0 && (u = !0);
  const r = i4(l), o = r === ((t = l.ownerDocument) == null ? void 0 : t.body), s = Eu(r);
  return o ? n.concat(s, s.visualViewport || [], ei(r) ? r : [], s.frameElement && u ? Ur(s.frameElement) : []) : n.concat(r, Ur(r, [], u));
}
function o4(l) {
  const n = Gu(l);
  let u = parseFloat(n.width) || 0, t = parseFloat(n.height) || 0;
  const r = de(l), o = r ? l.offsetWidth : u, s = r ? l.offsetHeight : t, d = Vo(u) !== o || Vo(t) !== s;
  return d && (u = o, t = s), {
    width: u,
    height: t,
    $: d
  };
}
function xc(l) {
  return Te(l) ? l : l.contextElement;
}
function Qt(l) {
  const n = xc(l);
  if (!de(n))
    return qe(1);
  const u = n.getBoundingClientRect(), {
    width: t,
    height: r,
    $: o
  } = o4(n);
  let s = (o ? Vo(u.width) : u.width) / t, d = (o ? Vo(u.height) : u.height) / r;
  return (!s || !Number.isFinite(s)) && (s = 1), (!d || !Number.isFinite(d)) && (d = 1), {
    x: s,
    y: d
  };
}
const D$ = /* @__PURE__ */ qe(0);
function a4(l) {
  const n = Eu(l);
  return !$c() || !n.visualViewport ? D$ : {
    x: n.visualViewport.offsetLeft,
    y: n.visualViewport.offsetTop
  };
}
function M$(l, n, u) {
  return n === void 0 && (n = !1), !u || n && u !== Eu(l) ? !1 : n;
}
function Et(l, n, u, t) {
  n === void 0 && (n = !1), u === void 0 && (u = !1);
  const r = l.getBoundingClientRect(), o = xc(l);
  let s = qe(1);
  n && (t ? Te(t) && (s = Qt(t)) : s = Qt(l));
  const d = M$(o, u, t) ? a4(o) : qe(0);
  let a = (r.left + d.x) / s.x, f = (r.top + d.y) / s.y, p = r.width / s.x, g = r.height / s.y;
  if (o) {
    const m = Eu(o), v = t && Te(t) ? Eu(t) : t;
    let $ = m, b = $.frameElement;
    for (; b && t && v !== $; ) {
      const E = Qt(b), S = b.getBoundingClientRect(), A = Gu(b), x = S.left + (b.clientLeft + parseFloat(A.paddingLeft)) * E.x, I = S.top + (b.clientTop + parseFloat(A.paddingTop)) * E.y;
      a *= E.x, f *= E.y, p *= E.x, g *= E.y, a += x, f += I, $ = Eu(b), b = $.frameElement;
    }
  }
  return Ho({
    width: p,
    height: g,
    x: a,
    y: f
  });
}
const B$ = [":popover-open", ":modal"];
function s4(l) {
  return B$.some((n) => {
    try {
      return l.matches(n);
    } catch {
      return !1;
    }
  });
}
function L$(l) {
  let {
    elements: n,
    rect: u,
    offsetParent: t,
    strategy: r
  } = l;
  const o = r === "fixed", s = Fe(t), d = n ? s4(n.floating) : !1;
  if (t === s || d && o)
    return u;
  let a = {
    scrollLeft: 0,
    scrollTop: 0
  }, f = qe(1);
  const p = qe(0), g = de(t);
  if ((g || !g && !o) && ((lt(t) !== "body" || ei(s)) && (a = ca(t)), de(t))) {
    const m = Et(t);
    f = Qt(t), p.x = m.x + t.clientLeft, p.y = m.y + t.clientTop;
  }
  return {
    width: u.width * f.x,
    height: u.height * f.y,
    x: u.x * f.x - a.scrollLeft * f.x + p.x,
    y: u.y * f.y - a.scrollTop * f.y + p.y
  };
}
function G$(l) {
  return Array.from(l.getClientRects());
}
function d4(l) {
  return Et(Fe(l)).left + ca(l).scrollLeft;
}
function j$(l) {
  const n = Fe(l), u = ca(l), t = l.ownerDocument.body, r = wu(n.scrollWidth, n.clientWidth, t.scrollWidth, t.clientWidth), o = wu(n.scrollHeight, n.clientHeight, t.scrollHeight, t.clientHeight);
  let s = -u.scrollLeft + d4(l);
  const d = -u.scrollTop;
  return Gu(t).direction === "rtl" && (s += wu(n.clientWidth, t.clientWidth) - r), {
    width: r,
    height: o,
    x: s,
    y: d
  };
}
function W$(l, n) {
  const u = Eu(l), t = Fe(l), r = u.visualViewport;
  let o = t.clientWidth, s = t.clientHeight, d = 0, a = 0;
  if (r) {
    o = r.width, s = r.height;
    const f = $c();
    (!f || f && n === "fixed") && (d = r.offsetLeft, a = r.offsetTop);
  }
  return {
    width: o,
    height: s,
    x: d,
    y: a
  };
}
function V$(l, n) {
  const u = Et(l, !0, n === "fixed"), t = u.top + l.clientTop, r = u.left + l.clientLeft, o = de(l) ? Qt(l) : qe(1), s = l.clientWidth * o.x, d = l.clientHeight * o.y, a = r * o.x, f = t * o.y;
  return {
    width: s,
    height: d,
    x: a,
    y: f
  };
}
function ef(l, n, u) {
  let t;
  if (n === "viewport")
    t = W$(l, u);
  else if (n === "document")
    t = j$(Fe(l));
  else if (Te(n))
    t = V$(n, u);
  else {
    const r = a4(l);
    t = {
      ...n,
      x: n.x - r.x,
      y: n.y - r.y
    };
  }
  return Ho(t);
}
function c4(l, n) {
  const u = ur(l);
  return u === n || !Te(u) || da(u) ? !1 : Gu(u).position === "fixed" || c4(u, n);
}
function k$(l, n) {
  const u = n.get(l);
  if (u)
    return u;
  let t = Ur(l, [], !1).filter((d) => Te(d) && lt(d) !== "body"), r = null;
  const o = Gu(l).position === "fixed";
  let s = o ? ur(l) : l;
  for (; Te(s) && !da(s); ) {
    const d = Gu(s), a = yc(s);
    !a && d.position === "fixed" && (r = null), (o ? !a && !r : !a && d.position === "static" && !!r && ["absolute", "fixed"].includes(r.position) || ei(s) && !a && c4(l, s)) ? t = t.filter((p) => p !== s) : r = d, s = ur(s);
  }
  return n.set(l, t), t;
}
function H$(l) {
  let {
    element: n,
    boundary: u,
    rootBoundary: t,
    strategy: r
  } = l;
  const s = [...u === "clippingAncestors" ? k$(n, this._c) : [].concat(u), t], d = s[0], a = s.reduce((f, p) => {
    const g = ef(n, p, r);
    return f.top = wu(g.top, f.top), f.right = Qe(g.right, f.right), f.bottom = Qe(g.bottom, f.bottom), f.left = wu(g.left, f.left), f;
  }, ef(n, d, r));
  return {
    width: a.right - a.left,
    height: a.bottom - a.top,
    x: a.left,
    y: a.top
  };
}
function Z$(l) {
  const {
    width: n,
    height: u
  } = o4(l);
  return {
    width: n,
    height: u
  };
}
function X$(l, n, u) {
  const t = de(n), r = Fe(n), o = u === "fixed", s = Et(l, !0, o, n);
  let d = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const a = qe(0);
  if (t || !t && !o)
    if ((lt(n) !== "body" || ei(r)) && (d = ca(n)), t) {
      const g = Et(n, !0, o, n);
      a.x = g.x + n.clientLeft, a.y = g.y + n.clientTop;
    } else r && (a.x = d4(r));
  const f = s.left + d.scrollLeft - a.x, p = s.top + d.scrollTop - a.y;
  return {
    x: f,
    y: p,
    width: s.width,
    height: s.height
  };
}
function tf(l, n) {
  return !de(l) || Gu(l).position === "fixed" ? null : n ? n(l) : l.offsetParent;
}
function f4(l, n) {
  const u = Eu(l);
  if (!de(l) || s4(l))
    return u;
  let t = tf(l, n);
  for (; t && F$(t) && Gu(t).position === "static"; )
    t = tf(t, n);
  return t && (lt(t) === "html" || lt(t) === "body" && Gu(t).position === "static" && !yc(t)) ? u : t || _$(l) || u;
}
const z$ = async function(l) {
  const n = this.getOffsetParent || f4, u = this.getDimensions;
  return {
    reference: X$(l.reference, await n(l.floating), l.strategy),
    floating: {
      x: 0,
      y: 0,
      ...await u(l.floating)
    }
  };
};
function Y$(l) {
  return Gu(l).direction === "rtl";
}
const U$ = {
  convertOffsetParentRelativeRectToViewportRelativeRect: L$,
  getDocumentElement: Fe,
  getClippingRect: H$,
  getOffsetParent: f4,
  getElementRects: z$,
  getClientRects: G$,
  getDimensions: Z$,
  getScale: Qt,
  isElement: Te,
  isRTL: Y$
};
function J$(l, n) {
  let u = null, t;
  const r = Fe(l);
  function o() {
    var d;
    clearTimeout(t), (d = u) == null || d.disconnect(), u = null;
  }
  function s(d, a) {
    d === void 0 && (d = !1), a === void 0 && (a = 1), o();
    const {
      left: f,
      top: p,
      width: g,
      height: m
    } = l.getBoundingClientRect();
    if (d || n(), !g || !m)
      return;
    const v = co(p), $ = co(r.clientWidth - (f + g)), b = co(r.clientHeight - (p + m)), E = co(f), A = {
      rootMargin: -v + "px " + -$ + "px " + -b + "px " + -E + "px",
      threshold: wu(0, Qe(1, a)) || 1
    };
    let x = !0;
    function I(P) {
      const O = P[0].intersectionRatio;
      if (O !== a) {
        if (!x)
          return s();
        O ? s(!1, O) : t = setTimeout(() => {
          s(!1, 1e-7);
        }, 100);
      }
      x = !1;
    }
    try {
      u = new IntersectionObserver(I, {
        ...A,
        // Handle <iframe>s
        root: r.ownerDocument
      });
    } catch {
      u = new IntersectionObserver(I, A);
    }
    u.observe(l);
  }
  return s(!0), o;
}
function Cc(l, n, u, t) {
  t === void 0 && (t = {});
  const {
    ancestorScroll: r = !0,
    ancestorResize: o = !0,
    elementResize: s = typeof ResizeObserver == "function",
    layoutShift: d = typeof IntersectionObserver == "function",
    animationFrame: a = !1
  } = t, f = xc(l), p = r || o ? [...f ? Ur(f) : [], ...Ur(n)] : [];
  p.forEach((S) => {
    r && S.addEventListener("scroll", u, {
      passive: !0
    }), o && S.addEventListener("resize", u);
  });
  const g = f && d ? J$(f, u) : null;
  let m = -1, v = null;
  s && (v = new ResizeObserver((S) => {
    let [A] = S;
    A && A.target === f && v && (v.unobserve(n), cancelAnimationFrame(m), m = requestAnimationFrame(() => {
      var x;
      (x = v) == null || x.observe(n);
    })), u();
  }), f && !a && v.observe(f), v.observe(n));
  let $, b = a ? Et(l) : null;
  a && E();
  function E() {
    const S = Et(l);
    b && (S.x !== b.x || S.y !== b.y || S.width !== b.width || S.height !== b.height) && u(), b = S, $ = requestAnimationFrame(E);
  }
  return u(), () => {
    var S;
    p.forEach((A) => {
      r && A.removeEventListener("scroll", u), o && A.removeEventListener("resize", u);
    }), g == null || g(), (S = v) == null || S.disconnect(), v = null, a && cancelAnimationFrame($);
  };
}
const K$ = T$, Q$ = A$, q$ = O$, lx = S$, rf = E$, nx = R$, ux = (l, n, u) => {
  const t = /* @__PURE__ */ new Map(), r = {
    platform: U$,
    ...u
  }, o = {
    ...r.platform,
    _c: t
  };
  return I$(l, n, {
    ...r,
    platform: o
  });
};
var Ao = typeof document < "u" ? react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_0__.useEffect;
function Zo(l, n) {
  if (l === n)
    return !0;
  if (typeof l != typeof n)
    return !1;
  if (typeof l == "function" && l.toString() === n.toString())
    return !0;
  let u, t, r;
  if (l && n && typeof l == "object") {
    if (Array.isArray(l)) {
      if (u = l.length, u !== n.length) return !1;
      for (t = u; t-- !== 0; )
        if (!Zo(l[t], n[t]))
          return !1;
      return !0;
    }
    if (r = Object.keys(l), u = r.length, u !== Object.keys(n).length)
      return !1;
    for (t = u; t-- !== 0; )
      if (!{}.hasOwnProperty.call(n, r[t]))
        return !1;
    for (t = u; t-- !== 0; ) {
      const o = r[t];
      if (!(o === "_owner" && l.$$typeof) && !Zo(l[o], n[o]))
        return !1;
    }
    return !0;
  }
  return l !== l && n !== n;
}
function p4(l) {
  return typeof window > "u" ? 1 : (l.ownerDocument.defaultView || window).devicePixelRatio || 1;
}
function of(l, n) {
  const u = p4(l);
  return Math.round(n * u) / u;
}
function ld(l) {
  const n = react__WEBPACK_IMPORTED_MODULE_0__.useRef(l);
  return Ao(() => {
    n.current = l;
  }), n;
}
function g4(l) {
  l === void 0 && (l = {});
  const {
    placement: n = "bottom",
    strategy: u = "absolute",
    middleware: t = [],
    platform: r,
    elements: {
      reference: o,
      floating: s
    } = {},
    transform: d = !0,
    whileElementsMounted: a,
    open: f
  } = l, [p, g] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    x: 0,
    y: 0,
    strategy: u,
    placement: n,
    middlewareData: {},
    isPositioned: !1
  }), [m, v] = react__WEBPACK_IMPORTED_MODULE_0__.useState(t);
  Zo(m, t) || v(t);
  const [$, b] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), [E, S] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), A = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((ll) => {
    ll !== O.current && (O.current = ll, b(ll));
  }, []), x = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((ll) => {
    ll !== _.current && (_.current = ll, S(ll));
  }, []), I = o || $, P = s || E, O = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), _ = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), j = react__WEBPACK_IMPORTED_MODULE_0__.useRef(p), z = a != null, Y = ld(a), el = ld(r), U = ld(f), ul = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    if (!O.current || !_.current)
      return;
    const ll = {
      placement: n,
      strategy: u,
      middleware: m
    };
    el.current && (ll.platform = el.current), ux(O.current, _.current, ll).then((H) => {
      const V = {
        ...H,
        // The floating element's position may be recomputed while it's closed
        // but still mounted (such as when transitioning out). To ensure
        // `isPositioned` will be `false` initially on the next open, avoid
        // setting it to `true` when `open === false` (must be specified).
        isPositioned: U.current !== !1
      };
      il.current && !Zo(j.current, V) && (j.current = V, react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync(() => {
        g(V);
      }));
    });
  }, [m, n, u, el, U]);
  Ao(() => {
    f === !1 && j.current.isPositioned && (j.current.isPositioned = !1, g((ll) => ({
      ...ll,
      isPositioned: !1
    })));
  }, [f]);
  const il = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1);
  Ao(() => (il.current = !0, () => {
    il.current = !1;
  }), []), Ao(() => {
    if (I && (O.current = I), P && (_.current = P), I && P) {
      if (Y.current)
        return Y.current(I, P, ul);
      ul();
    }
  }, [I, P, ul, Y, z]);
  const rl = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    reference: O,
    floating: _,
    setReference: A,
    setFloating: x
  }), [A, x]), tl = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    reference: I,
    floating: P
  }), [I, P]), sl = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    const ll = {
      position: u,
      left: 0,
      top: 0
    };
    if (!tl.floating)
      return ll;
    const H = of(tl.floating, p.x), V = of(tl.floating, p.y);
    return d ? {
      ...ll,
      transform: "translate(" + H + "px, " + V + "px)",
      ...p4(tl.floating) >= 1.5 && {
        willChange: "transform"
      }
    } : {
      position: u,
      left: H,
      top: V
    };
  }, [u, d, tl.floating, p.x, p.y]);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    ...p,
    update: ul,
    refs: rl,
    elements: tl,
    floatingStyles: sl
  }), [p, ul, rl, tl, sl]);
}
const ex = (l) => {
  function n(u) {
    return {}.hasOwnProperty.call(u, "current");
  }
  return {
    name: "arrow",
    options: l,
    fn(u) {
      const {
        element: t,
        padding: r
      } = typeof l == "function" ? l(u) : l;
      return t && n(t) ? t.current != null ? rf({
        element: t.current,
        padding: r
      }).fn(u) : {} : t ? rf({
        element: t,
        padding: r
      }).fn(u) : {};
    }
  };
}, h4 = (l, n) => ({
  ...N$(l),
  options: [l, n]
}), m4 = (l, n) => ({
  ...K$(l),
  options: [l, n]
}), v4 = (l, n) => ({
  ...nx(l),
  options: [l, n]
}), b4 = (l, n) => ({
  ...Q$(l),
  options: [l, n]
}), y4 = (l, n) => ({
  ...q$(l),
  options: [l, n]
}), $4 = (l, n) => ({
  ...lx(l),
  options: [l, n]
}), x4 = (l, n) => ({
  ...ex(l),
  options: [l, n]
});
let fa = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
fa.displayName = "OpenClosedContext";
var qu = ((l) => (l[l.Open = 1] = "Open", l[l.Closed = 2] = "Closed", l[l.Closing = 4] = "Closing", l[l.Opening = 8] = "Opening", l))(qu || {});
function pa() {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(fa);
}
function tx({ value: l, children: n }) {
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(fa.Provider, { value: l }, n);
}
function rx({ children: l }) {
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(fa.Provider, { value: null }, l);
}
function ix(l) {
  function n() {
    document.readyState !== "loading" && (l(), document.removeEventListener("DOMContentLoaded", n));
  }
  typeof window < "u" && typeof document < "u" && (document.addEventListener("DOMContentLoaded", n), n());
}
let ze = [];
ix(() => {
  function l(n) {
    if (!(n.target instanceof HTMLElement) || n.target === document.body || ze[0] === n.target) return;
    let u = n.target;
    u = u.closest(Wo), ze.unshift(u ?? n.target), ze = ze.filter((t) => t != null && t.isConnected), ze.splice(10);
  }
  window.addEventListener("click", l, { capture: !0 }), window.addEventListener("mousedown", l, { capture: !0 }), window.addEventListener("focus", l, { capture: !0 }), document.body.addEventListener("click", l, { capture: !0 }), document.body.addEventListener("mousedown", l, { capture: !0 }), document.body.addEventListener("focus", l, { capture: !0 });
});
function C4(l) {
  let n = En(l), u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => (u.current = !1, () => {
    u.current = !0, aa(() => {
      u.current && n();
    });
  }), [n]);
}
function ox() {
  let l = typeof document > "u";
  return "useSyncExternalStore" in /*#__PURE__*/ (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache || (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache = __webpack_require__.t(react__WEBPACK_IMPORTED_MODULE_0__, 2))) ? ((n) => n.useSyncExternalStore)(/*#__PURE__*/ (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache || (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache = __webpack_require__.t(react__WEBPACK_IMPORTED_MODULE_0__, 2))))(() => () => {
  }, () => !1, () => !l) : !1;
}
function ti() {
  let l = ox(), [n, u] = react__WEBPACK_IMPORTED_MODULE_0__.useState(It.isHandoffComplete);
  return n && It.isHandoffComplete === !1 && u(!1), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    n !== !0 && u(!0);
  }, [n]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => It.handoff(), []), l ? !1 : n;
}
let w4 = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(!1);
function ax() {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(w4);
}
function af(l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(w4.Provider, { value: l.force }, l.children);
}
function sx(l) {
  let n = ax(), u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(E4), [t, r] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(() => {
    var o;
    if (!n && u !== null) return (o = u.current) != null ? o : null;
    if (It.isServer) return null;
    let s = l == null ? void 0 : l.getElementById("headlessui-portal-root");
    if (s) return s;
    if (l === null) return null;
    let d = l.createElement("div");
    return d.setAttribute("id", "headlessui-portal-root"), l.body.appendChild(d);
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    t !== null && (l != null && l.body.contains(t) || l == null || l.body.appendChild(t));
  }, [t, l]), (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    n || u !== null && r(u.current);
  }, [u, r, n]), t;
}
let I4 = react__WEBPACK_IMPORTED_MODULE_0__.Fragment, dx = hu(function(l, n) {
  let { ownerDocument: u = null, ...t } = l, r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), o = fe(Fy((v) => {
    r.current = v;
  }), n), s = sa(r), d = u ?? s, a = sx(d), [f] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(() => {
    var v;
    return It.isServer ? null : (v = d == null ? void 0 : d.createElement("div")) != null ? v : null;
  }), p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(Sd), g = ti();
  iu(() => {
    !a || !f || a.contains(f) || (f.setAttribute("data-headlessui-portal", ""), a.appendChild(f));
  }, [a, f]), iu(() => {
    if (f && p) return p.register(f);
  }, [p, f]), C4(() => {
    var v;
    !a || !f || (f instanceof Node && a.contains(f) && a.removeChild(f), a.childNodes.length <= 0 && ((v = a.parentElement) == null || v.removeChild(a)));
  });
  let m = Vu();
  return g ? !a || !f ? null : (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal)(m({ ourProps: { ref: o }, theirProps: t, slot: {}, defaultTag: I4, name: "Portal" }), f) : null;
});
function cx(l, n) {
  let u = fe(n), { enabled: t = !0, ownerDocument: r, ...o } = l, s = Vu();
  return t ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(dx, { ...o, ownerDocument: r, ref: u }) : s({ ourProps: { ref: u }, theirProps: o, slot: {}, defaultTag: I4, name: "Portal" });
}
let fx = react__WEBPACK_IMPORTED_MODULE_0__.Fragment, E4 = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
function px(l, n) {
  let { target: u, ...t } = l, r = { ref: fe(n) }, o = Vu();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(E4.Provider, { value: u }, o({ ourProps: r, theirProps: t, defaultTag: fx, name: "Popover.Group" }));
}
let Sd = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
function gx() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(Sd), n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([]), u = En((o) => (n.current.push(o), l && l.register(o), () => t(o))), t = En((o) => {
    let s = n.current.indexOf(o);
    s !== -1 && n.current.splice(s, 1), l && l.unregister(o);
  }), r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ register: u, unregister: t, portals: n }), [u, t, n]);
  return [n, (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => function({ children: o }) {
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement(Sd.Provider, { value: r }, o);
  }, [r])];
}
let hx = hu(cx), A4 = hu(px), mx = Object.assign(hx, { Group: A4 });
function vx(l, n = typeof document < "u" ? document.defaultView : null, u) {
  let t = dr(l, "escape");
  e4(n, "keydown", (r) => {
    t && (r.defaultPrevented || r.key === K3.Escape && u(r));
  });
}
function bx() {
  var l;
  let [n] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(() => typeof window < "u" && typeof window.matchMedia == "function" ? window.matchMedia("(pointer: coarse)") : null), [u, t] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)((l = n == null ? void 0 : n.matches) != null ? l : !1);
  return iu(() => {
    if (!n) return;
    function r(o) {
      t(o.matches);
    }
    return n.addEventListener("change", r), () => n.removeEventListener("change", r);
  }, [n]), u;
}
function yx({ defaultContainers: l = [], portals: n, mainTreeNode: u } = {}) {
  let t = sa(u), r = En(() => {
    var o, s;
    let d = [];
    for (let a of l) a !== null && (a instanceof HTMLElement ? d.push(a) : "current" in a && a.current instanceof HTMLElement && d.push(a.current));
    if (n != null && n.current) for (let a of n.current) d.push(a);
    for (let a of (o = t == null ? void 0 : t.querySelectorAll("html > *, body > *")) != null ? o : []) a !== document.body && a !== document.head && a instanceof HTMLElement && a.id !== "headlessui-portal-root" && (u && (a.contains(u) || a.contains((s = u == null ? void 0 : u.getRootNode()) == null ? void 0 : s.host)) || d.some((f) => a.contains(f)) || d.push(a));
    return d;
  });
  return { resolveContainers: r, contains: En((o) => r().some((s) => s.contains(o))) };
}
let S4 = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
function sf({ children: l, node: n }) {
  let [u, t] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null), r = P4(n ?? u);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(S4.Provider, { value: r }, l, r === null && react__WEBPACK_IMPORTED_MODULE_0__.createElement(Cd, { features: jo.Hidden, ref: (o) => {
    var s, d;
    if (o) {
      for (let a of (d = (s = oa(o)) == null ? void 0 : s.querySelectorAll("html > *, body > *")) != null ? d : []) if (a !== document.body && a !== document.head && a instanceof HTMLElement && a != null && a.contains(o)) {
        t(a);
        break;
      }
    }
  } }));
}
function P4(l = null) {
  var n;
  return (n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(S4)) != null ? n : l;
}
function wc() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1);
  return iu(() => (l.current = !0, () => {
    l.current = !1;
  }), []), l;
}
var kr = ((l) => (l[l.Forwards = 0] = "Forwards", l[l.Backwards = 1] = "Backwards", l))(kr || {});
function $x() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(0);
  return u4(!0, "keydown", (n) => {
    n.key === "Tab" && (l.current = n.shiftKey ? 1 : 0);
  }, !0), l;
}
function N4(l) {
  if (!l) return /* @__PURE__ */ new Set();
  if (typeof l == "function") return new Set(l());
  let n = /* @__PURE__ */ new Set();
  for (let u of l.current) u.current instanceof HTMLElement && n.add(u.current);
  return n;
}
let xx = "div";
var $t = ((l) => (l[l.None = 0] = "None", l[l.InitialFocus = 1] = "InitialFocus", l[l.TabLock = 2] = "TabLock", l[l.FocusLock = 4] = "FocusLock", l[l.RestoreFocus = 8] = "RestoreFocus", l[l.AutoFocus = 16] = "AutoFocus", l))($t || {});
function Cx(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), t = fe(u, n), { initialFocus: r, initialFocusFallback: o, containers: s, features: d = 15, ...a } = l;
  ti() || (d = 0);
  let f = sa(u);
  Ax(d, { ownerDocument: f });
  let p = Sx(d, { ownerDocument: f, container: u, initialFocus: r, initialFocusFallback: o });
  Px(d, { ownerDocument: f, container: u, containers: s, previousActiveElement: p });
  let g = $x(), m = En((A) => {
    let x = u.current;
    x && ((I) => I())(() => {
      Ke(g.current, { [kr.Forwards]: () => {
        zr(x, Ae.First, { skipElements: [A.relatedTarget, o] });
      }, [kr.Backwards]: () => {
        zr(x, Ae.Last, { skipElements: [A.relatedTarget, o] });
      } });
    });
  }), v = dr(!!(d & 2), "focus-trap#tab-lock"), $ = pc(), b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1), E = { ref: t, onKeyDown(A) {
    A.key == "Tab" && (b.current = !0, $.requestAnimationFrame(() => {
      b.current = !1;
    }));
  }, onBlur(A) {
    if (!(d & 4)) return;
    let x = N4(s);
    u.current instanceof HTMLElement && x.add(u.current);
    let I = A.relatedTarget;
    I instanceof HTMLElement && I.dataset.headlessuiFocusGuard !== "true" && (T4(x, I) || (b.current ? zr(u.current, Ke(g.current, { [kr.Forwards]: () => Ae.Next, [kr.Backwards]: () => Ae.Previous }) | Ae.WrapAround, { relativeTo: A.target }) : A.target instanceof HTMLElement && Se(A.target)));
  } }, S = Vu();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, v && react__WEBPACK_IMPORTED_MODULE_0__.createElement(Cd, { as: "button", type: "button", "data-headlessui-focus-guard": !0, onFocus: m, features: jo.Focusable }), S({ ourProps: E, theirProps: a, defaultTag: xx, name: "FocusTrap" }), v && react__WEBPACK_IMPORTED_MODULE_0__.createElement(Cd, { as: "button", type: "button", "data-headlessui-focus-guard": !0, onFocus: m, features: jo.Focusable }));
}
let wx = hu(Cx), Ix = Object.assign(wx, { features: $t });
function Ex(l = !0) {
  let n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(ze.slice());
  return hc(([u], [t]) => {
    t === !0 && u === !1 && aa(() => {
      n.current.splice(0);
    }), t === !1 && u === !0 && (n.current = ze.slice());
  }, [l, ze, n]), En(() => {
    var u;
    return (u = n.current.find((t) => t != null && t.isConnected)) != null ? u : null;
  });
}
function Ax(l, { ownerDocument: n }) {
  let u = !!(l & 8), t = Ex(u);
  hc(() => {
    u || (n == null ? void 0 : n.activeElement) === (n == null ? void 0 : n.body) && Se(t());
  }, [u]), C4(() => {
    u && Se(t());
  });
}
function Sx(l, { ownerDocument: n, container: u, initialFocus: t, initialFocusFallback: r }) {
  let o = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), s = dr(!!(l & 1), "focus-trap#initial-focus"), d = wc();
  return hc(() => {
    if (l === 0) return;
    if (!s) {
      r != null && r.current && Se(r.current);
      return;
    }
    let a = u.current;
    a && aa(() => {
      if (!d.current) return;
      let f = n == null ? void 0 : n.activeElement;
      if (t != null && t.current) {
        if ((t == null ? void 0 : t.current) === f) {
          o.current = f;
          return;
        }
      } else if (a.contains(f)) {
        o.current = f;
        return;
      }
      if (t != null && t.current) Se(t.current);
      else {
        if (l & 16) {
          if (zr(a, Ae.First | Ae.AutoFocus) !== Id.Error) return;
        } else if (zr(a, Ae.First) !== Id.Error) return;
        if (r != null && r.current && (Se(r.current), (n == null ? void 0 : n.activeElement) === r.current)) return;
        console.warn("There are no focusable elements inside the <FocusTrap />");
      }
      o.current = n == null ? void 0 : n.activeElement;
    });
  }, [r, s, l]), o;
}
function Px(l, { ownerDocument: n, container: u, containers: t, previousActiveElement: r }) {
  let o = wc(), s = !!(l & 4);
  e4(n == null ? void 0 : n.defaultView, "focus", (d) => {
    if (!s || !o.current) return;
    let a = N4(t);
    u.current instanceof HTMLElement && a.add(u.current);
    let f = r.current;
    if (!f) return;
    let p = d.target;
    p && p instanceof HTMLElement ? T4(a, p) ? (r.current = p, Se(p)) : (d.preventDefault(), d.stopPropagation(), Se(f)) : Se(r.current);
  }, !0);
}
function T4(l, n) {
  for (let u of l) if (u.contains(n)) return !0;
  return !1;
}
function R4(l) {
  var n;
  return !!(l.enter || l.enterFrom || l.enterTo || l.leave || l.leaveFrom || l.leaveTo) || ((n = l.as) != null ? n : F4) !== react__WEBPACK_IMPORTED_MODULE_0__.Fragment || react__WEBPACK_IMPORTED_MODULE_0__.Children.count(l.children) === 1;
}
let ga = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
ga.displayName = "TransitionContext";
var Nx = ((l) => (l.Visible = "visible", l.Hidden = "hidden", l))(Nx || {});
function Tx() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(ga);
  if (l === null) throw new Error("A <Transition.Child /> is used but it is missing a parent <Transition /> or <Transition.Root />.");
  return l;
}
function Rx() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(ha);
  if (l === null) throw new Error("A <Transition.Child /> is used but it is missing a parent <Transition /> or <Transition.Root />.");
  return l;
}
let ha = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
ha.displayName = "NestingContext";
function ma(l) {
  return "children" in l ? ma(l.children) : l.current.filter(({ el: n }) => n.current !== null).filter(({ state: n }) => n === "visible").length > 0;
}
function O4(l, n) {
  let u = Pt(l), t = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([]), r = wc(), o = pc(), s = En((v, $ = Ue.Hidden) => {
    let b = t.current.findIndex(({ el: E }) => E === v);
    b !== -1 && (Ke($, { [Ue.Unmount]() {
      t.current.splice(b, 1);
    }, [Ue.Hidden]() {
      t.current[b].state = "hidden";
    } }), o.microTask(() => {
      var E;
      !ma(t) && r.current && ((E = u.current) == null || E.call(u));
    }));
  }), d = En((v) => {
    let $ = t.current.find(({ el: b }) => b === v);
    return $ ? $.state !== "visible" && ($.state = "visible") : t.current.push({ el: v, state: "visible" }), () => s(v, Ue.Unmount);
  }), a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([]), f = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(Promise.resolve()), p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)({ enter: [], leave: [] }), g = En((v, $, b) => {
    a.current.splice(0), n && (n.chains.current[$] = n.chains.current[$].filter(([E]) => E !== v)), n == null || n.chains.current[$].push([v, new Promise((E) => {
      a.current.push(E);
    })]), n == null || n.chains.current[$].push([v, new Promise((E) => {
      Promise.all(p.current[$].map(([S, A]) => A)).then(() => E());
    })]), $ === "enter" ? f.current = f.current.then(() => n == null ? void 0 : n.wait.current).then(() => b($)) : b($);
  }), m = En((v, $, b) => {
    Promise.all(p.current[$].splice(0).map(([E, S]) => S)).then(() => {
      var E;
      (E = a.current.shift()) == null || E();
    }).then(() => b($));
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ children: t, register: d, unregister: s, onStart: g, onStop: m, wait: f, chains: p }), [d, s, t, g, m, p, f]);
}
let F4 = react__WEBPACK_IMPORTED_MODULE_0__.Fragment, _4 = Go.RenderStrategy;
function Ox(l, n) {
  var u, t;
  let { transition: r = !0, beforeEnter: o, afterEnter: s, beforeLeave: d, afterLeave: a, enter: f, enterFrom: p, enterTo: g, entered: m, leave: v, leaveFrom: $, leaveTo: b, ...E } = l, [S, A] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null), x = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), I = R4(l), P = fe(...I ? [x, n, A] : n === null ? [] : [n]), O = (u = E.unmount) == null || u ? Ue.Unmount : Ue.Hidden, { show: _, appear: j, initial: z } = Tx(), [Y, el] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(_ ? "visible" : "hidden"), U = Rx(), { register: ul, unregister: il } = U;
  iu(() => ul(x), [ul, x]), iu(() => {
    if (O === Ue.Hidden && x.current) {
      if (_ && Y !== "visible") {
        el("visible");
        return;
      }
      return Ke(Y, { hidden: () => il(x), visible: () => ul(x) });
    }
  }, [Y, x, ul, il, _, O]);
  let rl = ti();
  iu(() => {
    if (I && rl && Y === "visible" && x.current === null) throw new Error("Did you forget to passthrough the `ref` to the actual DOM node?");
  }, [x, Y, rl, I]);
  let tl = z && !j, sl = j && _ && z, ll = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1), H = O4(() => {
    ll.current || (el("hidden"), il(x));
  }, U), V = En((ol) => {
    ll.current = !0;
    let ml = ol ? "enter" : "leave";
    H.onStart(x, ml, (Sl) => {
      Sl === "enter" ? o == null || o() : Sl === "leave" && (d == null || d());
    });
  }), X = En((ol) => {
    let ml = ol ? "enter" : "leave";
    ll.current = !1, H.onStop(x, ml, (Sl) => {
      Sl === "enter" ? s == null || s() : Sl === "leave" && (a == null || a());
    }), ml === "leave" && !ma(H) && (el("hidden"), il(x));
  });
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    I && r || (V(_), X(_));
  }, [_, I, r]);
  let dl = !(!r || !I || !rl || tl), [, fl] = f$(dl, S, _, { start: V, end: X }), $l = bt({ ref: P, className: ((t = xd(E.className, sl && f, sl && p, fl.enter && f, fl.enter && fl.closed && p, fl.enter && !fl.closed && g, fl.leave && v, fl.leave && !fl.closed && $, fl.leave && fl.closed && b, !fl.transition && _ && m)) == null ? void 0 : t.trim()) || void 0, ...c$(fl) }), cl = 0;
  Y === "visible" && (cl |= qu.Open), Y === "hidden" && (cl |= qu.Closed), _ && Y === "hidden" && (cl |= qu.Opening), !_ && Y === "visible" && (cl |= qu.Closing);
  let xl = Vu();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(ha.Provider, { value: H }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(tx, { value: cl }, xl({ ourProps: $l, theirProps: E, defaultTag: F4, features: _4, visible: Y === "visible", name: "Transition.Child" })));
}
function Fx(l, n) {
  let { show: u, appear: t = !1, unmount: r = !0, ...o } = l, s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), d = R4(l), a = fe(...d ? [s, n] : n === null ? [] : [n]);
  ti();
  let f = pa();
  if (u === void 0 && f !== null && (u = (f & qu.Open) === qu.Open), u === void 0) throw new Error("A <Transition /> is used but it is missing a `show={true | false}` prop.");
  let [p, g] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(u ? "visible" : "hidden"), m = O4(() => {
    u || g("hidden");
  }), [v, $] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(!0), b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([u]);
  iu(() => {
    v !== !1 && b.current[b.current.length - 1] !== u && (b.current.push(u), $(!1));
  }, [b, u]);
  let E = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ show: u, appear: t, initial: v }), [u, t, v]);
  iu(() => {
    u ? g("visible") : !ma(m) && s.current !== null && g("hidden");
  }, [u, m]);
  let S = { unmount: r }, A = En(() => {
    var P;
    v && $(!1), (P = l.beforeEnter) == null || P.call(l);
  }), x = En(() => {
    var P;
    v && $(!1), (P = l.beforeLeave) == null || P.call(l);
  }), I = Vu();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(ha.Provider, { value: m }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(ga.Provider, { value: E }, I({ ourProps: { ...S, as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment, children: react__WEBPACK_IMPORTED_MODULE_0__.createElement(D4, { ref: a, ...S, ...o, beforeEnter: A, beforeLeave: x }) }, theirProps: {}, defaultTag: react__WEBPACK_IMPORTED_MODULE_0__.Fragment, features: _4, visible: p === "visible", name: "Transition" })));
}
function _x(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(ga) !== null, t = pa() !== null;
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !u && t ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(Pd, { ref: n, ...l }) : react__WEBPACK_IMPORTED_MODULE_0__.createElement(D4, { ref: n, ...l }));
}
let Pd = hu(Fx), D4 = hu(Ox), Ic = hu(_x), Je = Object.assign(Pd, { Child: Ic, Root: Pd });
var Dx = ((l) => (l[l.Open = 0] = "Open", l[l.Closed = 1] = "Closed", l))(Dx || {}), Mx = ((l) => (l[l.SetTitleId = 0] = "SetTitleId", l))(Mx || {});
let Bx = { 0(l, n) {
  return l.titleId === n.id ? l : { ...l, titleId: n.id };
} }, Ec = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
Ec.displayName = "DialogContext";
function va(l) {
  let n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(Ec);
  if (n === null) {
    let u = new Error(`<${l} /> is missing a parent <Dialog /> component.`);
    throw Error.captureStackTrace && Error.captureStackTrace(u, va), u;
  }
  return n;
}
function Lx(l, n) {
  return Ke(n.type, Bx, l, n);
}
let df = hu(function(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), { id: t = `headlessui-dialog-${u}`, open: r, onClose: o, initialFocus: s, role: d = "dialog", autoFocus: a = !0, __demoMode: f = !1, unmount: p = !1, ...g } = l, m = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1);
  d = function() {
    return d === "dialog" || d === "alertdialog" ? d : (m.current || (m.current = !0, console.warn(`Invalid role [${d}] passed to <Dialog />. Only \`dialog\` and and \`alertdialog\` are supported. Using \`dialog\` instead.`)), "dialog");
  }();
  let v = pa();
  r === void 0 && v !== null && (r = (v & qu.Open) === qu.Open);
  let $ = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), b = fe($, n), E = sa($), S = r ? 0 : 1, [A, x] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useReducer)(Lx, { titleId: null, descriptionId: null, panelRef: (0,react__WEBPACK_IMPORTED_MODULE_0__.createRef)() }), I = En(() => o(!1)), P = En((X) => x({ type: 0, id: X })), O = ti() ? S === 0 : !1, [_, j] = gx(), z = { get current() {
    var X;
    return (X = A.panelRef.current) != null ? X : $.current;
  } }, Y = P4(), { resolveContainers: el } = yx({ mainTreeNode: Y, portals: _, defaultContainers: [z] }), U = v !== null ? (v & qu.Closing) === qu.Closing : !1;
  ky(f || U ? !1 : O, { allowed: En(() => {
    var X, dl;
    return [(dl = (X = $.current) == null ? void 0 : X.closest("[data-headlessui-portal]")) != null ? dl : null];
  }), disallowed: En(() => {
    var X;
    return [(X = Y == null ? void 0 : Y.closest("body > *:not(#headlessui-portal-root)")) != null ? X : null];
  }) }), u$(O, el, (X) => {
    X.preventDefault(), I();
  }), vx(O, E == null ? void 0 : E.defaultView, (X) => {
    X.preventDefault(), X.stopPropagation(), document.activeElement && "blur" in document.activeElement && typeof document.activeElement.blur == "function" && document.activeElement.blur(), I();
  }), a$(f || U ? !1 : O, E, el), Hy(O, $, I);
  let [ul, il] = _y(), rl = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => [{ dialogState: S, close: I, setTitleId: P, unmount: p }, A], [S, A, I, P, p]), tl = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ open: S === 0 }), [S]), sl = { ref: b, id: t, role: d, tabIndex: -1, "aria-modal": f ? void 0 : S === 0 ? !0 : void 0, "aria-labelledby": A.titleId, "aria-describedby": ul, unmount: p }, ll = !bx(), H = $t.None;
  O && !f && (H |= $t.RestoreFocus, H |= $t.TabLock, a && (H |= $t.AutoFocus), ll && (H |= $t.InitialFocus));
  let V = Vu();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(rx, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(af, { force: !0 }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(mx, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(Ec.Provider, { value: rl }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(A4, { target: $ }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(af, { force: !1 }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(il, { slot: tl }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(j, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(Ix, { initialFocus: s, initialFocusFallback: $, containers: el, features: H }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(jy, { value: I }, V({ ourProps: sl, theirProps: g, slot: tl, defaultTag: Gx, features: jx, visible: S === 0, name: "Dialog" })))))))))));
}), Gx = "div", jx = Go.RenderStrategy | Go.Static;
function Wx(l, n) {
  let { transition: u = !1, open: t, ...r } = l, o = pa(), s = l.hasOwnProperty("open") || o !== null, d = l.hasOwnProperty("onClose");
  if (!s && !d) throw new Error("You have to provide an `open` and an `onClose` prop to the `Dialog` component.");
  if (!s) throw new Error("You provided an `onClose` prop to the `Dialog`, but forgot an `open` prop.");
  if (!d) throw new Error("You provided an `open` prop to the `Dialog`, but forgot an `onClose` prop.");
  if (!o && typeof l.open != "boolean") throw new Error(`You provided an \`open\` prop to the \`Dialog\`, but the value is not a boolean. Received: ${l.open}`);
  if (typeof l.onClose != "function") throw new Error(`You provided an \`onClose\` prop to the \`Dialog\`, but the value is not a function. Received: ${l.onClose}`);
  return (t !== void 0 || u) && !r.static ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(sf, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(Je, { show: t, transition: u, unmount: r.unmount }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(df, { ref: n, ...r }))) : react__WEBPACK_IMPORTED_MODULE_0__.createElement(sf, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(df, { ref: n, open: t, ...r }));
}
let Vx = "div";
function kx(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), { id: t = `headlessui-dialog-panel-${u}`, transition: r = !1, ...o } = l, [{ dialogState: s, unmount: d }, a] = va("Dialog.Panel"), f = fe(n, a.panelRef), p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ open: s === 0 }), [s]), g = En((E) => {
    E.stopPropagation();
  }), m = { ref: f, id: t, onClick: g }, v = r ? Ic : react__WEBPACK_IMPORTED_MODULE_0__.Fragment, $ = r ? { unmount: d } : {}, b = Vu();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(v, { ...$ }, b({ ourProps: m, theirProps: o, slot: p, defaultTag: Vx, name: "Dialog.Panel" }));
}
let Hx = "div";
function Zx(l, n) {
  let { transition: u = !1, ...t } = l, [{ dialogState: r, unmount: o }] = va("Dialog.Backdrop"), s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ open: r === 0 }), [r]), d = { ref: n, "aria-hidden": !0 }, a = u ? Ic : react__WEBPACK_IMPORTED_MODULE_0__.Fragment, f = u ? { unmount: o } : {}, p = Vu();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(a, { ...f }, p({ ourProps: d, theirProps: t, slot: s, defaultTag: Hx, name: "Dialog.Backdrop" }));
}
let Xx = "h2";
function zx(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), { id: t = `headlessui-dialog-title-${u}`, ...r } = l, [{ dialogState: o, setTitleId: s }] = va("Dialog.Title"), d = fe(n);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => (s(t), () => s(null)), [t, s]);
  let a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ open: o === 0 }), [o]), f = { ref: d, id: t };
  return Vu()({ ourProps: f, theirProps: r, slot: a, defaultTag: Xx, name: "Dialog.Title" });
}
let Yx = hu(Wx), Ux = hu(kx), Jx = hu(Zx), Kx = hu(zx), Nd = Object.assign(Yx, { Panel: Ux, Title: Kx, Description: Ly });
function Ac(l) {
  return Wu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z", clipRule: "evenodd" }, child: [] }] })(l);
}
function M4(l) {
  return Wu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z", clipRule: "evenodd" }, child: [] }] })(l);
}
function Sc(l) {
  return Wu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z", clipRule: "evenodd" }, child: [] }] })(l);
}
function Qx(l) {
  return Wu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z", clipRule: "evenodd" }, child: [] }] })(l);
}
function B4(l) {
  return Wu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z", clipRule: "evenodd" }, child: [] }] })(l);
}
function L4(l) {
  return Wu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z", clipRule: "evenodd" }, child: [] }] })(l);
}
function G4(l) {
  return Wu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z", clipRule: "evenodd" }, child: [] }] })(l);
}
const m_ = ({ direction: l = "ltr", isOpen: n, onClose: u, children: t }) => /* @__PURE__ */ y.jsx(Je.Root, { show: n, as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment, children: /* @__PURE__ */ y.jsxs(Nd, { as: "div", className: "relative z-40", onClose: u, children: [
  /* @__PURE__ */ y.jsx(
    Je.Child,
    {
      as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
      enter: "transition-opacity ease-linear duration-300",
      enterFrom: "opacity-0",
      enterTo: "opacity-100",
      leave: "transition-opacity ease-linear duration-300",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      children: /* @__PURE__ */ y.jsx("div", { className: "fixed inset-0 bg-gray-600 bg-opacity-75" })
    }
  ),
  /* @__PURE__ */ y.jsx("div", { className: wl("fixed inset-0 flex z-40", l === "ltr" ? "justify-end" : "justify-start"), children: /* @__PURE__ */ y.jsx(
    Je.Child,
    {
      as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
      enter: "transition ease-in-out duration-300 transform",
      enterFrom: l === "ltr" ? "translate-x-full" : "-translate-x-full",
      enterTo: "translate-x-0",
      leave: "transition ease-in-out duration-300 transform",
      leaveFrom: "translate-x-0",
      leaveTo: l === "ltr" ? "translate-x-full" : "-translate-x-full",
      children: /* @__PURE__ */ y.jsxs(Nd.Panel, { className: "relative flex-1 flex flex-col max-w-xs w-full pt-5 pb-4 bg-white", children: [
        /* @__PURE__ */ y.jsx(
          Je.Child,
          {
            as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
            enter: "ease-in-out duration-300",
            enterFrom: "opacity-0",
            enterTo: "opacity-100",
            leave: "ease-in-out duration-300",
            leaveFrom: "opacity-100",
            leaveTo: "opacity-0",
            children: /* @__PURE__ */ y.jsx("div", { className: `absolute pt-2 top-0 ${l === "ltr" ? "-left-12" : "-right-12"}`, children: /* @__PURE__ */ y.jsxs(
              "button",
              {
                type: "button",
                className: "ms-1 flex items-center justify-center h-10 w-10 rounded-full focus:outline-none focus:ring-2 focus:ring-inset focus:ring-white",
                onClick: u,
                children: [
                  /* @__PURE__ */ y.jsx("span", { className: "sr-only", children: "Close sidebar" }),
                  /* @__PURE__ */ y.jsx(G4, { className: "h-6 w-6 text-white", "aria-hidden": "true" })
                ]
              }
            ) })
          }
        ),
        /* @__PURE__ */ y.jsx("div", { className: "mt-5 flex-1 h-full overflow-y-auto", dir: l, children: t })
      ] })
    }
  ) })
] }) });
var qx = "development" === "production";
function Td(l, n) {
  if (!qx) {
    if (l)
      return;
    var u = "Warning: " + n;
    typeof console < "u" && console.warn(u);
    try {
      throw Error(u);
    } catch {
    }
  }
}
function lC(l, n) {
  for (var u = 0; u < n.length; u++) {
    var t = n[u];
    t.enumerable = t.enumerable || !1, t.configurable = !0, "value" in t && (t.writable = !0), Object.defineProperty(l, t.key, t);
  }
}
function ba(l, n, u) {
  return n && lC(l.prototype, n), l;
}
function Au() {
  return Au = Object.assign || function(l) {
    for (var n = 1; n < arguments.length; n++) {
      var u = arguments[n];
      for (var t in u)
        Object.prototype.hasOwnProperty.call(u, t) && (l[t] = u[t]);
    }
    return l;
  }, Au.apply(this, arguments);
}
function nC(l, n) {
  l.prototype = Object.create(n.prototype), l.prototype.constructor = l, Rd(l, n);
}
function Rd(l, n) {
  return Rd = Object.setPrototypeOf || function(t, r) {
    return t.__proto__ = r, t;
  }, Rd(l, n);
}
function uC(l, n) {
  if (l) {
    if (typeof l == "string") return cf(l, n);
    var u = Object.prototype.toString.call(l).slice(8, -1);
    if (u === "Object" && l.constructor && (u = l.constructor.name), u === "Map" || u === "Set") return Array.from(l);
    if (u === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(u)) return cf(l, n);
  }
}
function cf(l, n) {
  (n == null || n > l.length) && (n = l.length);
  for (var u = 0, t = new Array(n); u < n; u++) t[u] = l[u];
  return t;
}
function er(l, n) {
  var u = typeof Symbol < "u" && l[Symbol.iterator] || l["@@iterator"];
  if (u) return (u = u.call(l)).next.bind(u);
  if (Array.isArray(l) || (u = uC(l)) || n) {
    u && (l = u);
    var t = 0;
    return function() {
      return t >= l.length ? {
        done: !0
      } : {
        done: !1,
        value: l[t++]
      };
    };
  }
  throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function ff(l) {
  var n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  function u(t) {
    !t || t === n.current || (n.current = t, l(t));
  }
  return u;
}
function eC(l) {
  var n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(l);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    function u(r) {
      typeof r == "function" ? n.current = r(n.current) : n.current = r;
    }
    function t() {
      return n.current;
    }
    return [t, u];
  }, []);
}
function tC() {
  var l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    function n() {
      return l.current.length > 0;
    }
    function u() {
      for (var r = er(l.current), o; !(o = r()).done; ) {
        var s = o.value;
        s();
      }
      l.current = [];
    }
    function t(r) {
      l.current.push(r);
    }
    return {
      hasEventSubscriptions: n,
      removeAllEventSubscriptions: u,
      addEventSubscription: t
    };
  }, []);
}
var nd = typeof window < "u" ? react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_0__.useEffect;
function rC(l, n) {
  var u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(l);
  return n ? (u.current = l, u) : (u.current = null, u);
}
function Jr(l) {
  return parseFloat(l.replace("px", ""));
}
function Od(l, n, u) {
  return l < n ? n : l > u ? u : l;
}
function pf(l) {
  return l != null;
}
function gf() {
  for (var l = arguments.length, n = new Array(l), u = 0; u < l; u++)
    n[u] = arguments[u];
  return function(t) {
    for (var r = er(n), o; !(o = r()).done; ) {
      var s = o.value;
      s && (typeof s == "function" ? s(t) : s.current = t);
    }
  };
}
function iC(l, n) {
  if (!(typeof l > "u"))
    return n || l.ResizeObserver;
}
function j4(l, n) {
  var u = [];
  if (!l || !n || l === document.body)
    return u;
  var t = n.getComputedStyle(l), r = t.overflow, o = t.overflowX, s = t.overflowY;
  return [r, o, s].some(function(d) {
    return ["auto", "scroll"].includes(d);
  }) && u.push(l), [].concat(u, j4(l.parentElement, n));
}
function fo(l) {
  return "react-laag: Could not find a valid reference for the " + l + ` element. There might be 2 causes:
   - Make sure that the 'ref' is set correctly on the ` + l + ` element when isOpen: true. Also make sure your component forwards the ref with "forwardRef()".
   - Make sure that you are actually rendering the ` + l + " when the isOpen prop is set to true";
}
function oC(l) {
  var n = l.enabled, u = l.onChange, t = l.environment, r = l.ResizeObserverPolyfill, o = l.overflowContainer, s = l.triggerOption, d = iC(t, r);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
     true && Td(d, "This browser does not support ResizeObserver out of the box. We recommend to add a polyfill in order to utilize the full capabilities of react-laag. See: https://github.com/everweij/react-laag#resize-observer");
  }, [d]);
  var a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), f = !!s, p = eC({
    scrollContainers: [],
    trigger: null,
    layer: null
  }), g = p[0], m = p[1], v = tC(), $ = v.hasEventSubscriptions, b = v.addEventSubscription, E = v.removeAllEventSubscriptions, S = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function() {
    var z = g(), Y = z.layer, el = z.trigger, U = z.scrollContainers, ul = U[0];
    if (!Y)
      throw new Error(fo("layer"));
    if (!el && !f)
      throw new Error(fo("trigger"));
    var il = {
      top: 0,
      left: 0
    };
    if (ul) {
      var rl = ul.scrollLeft, tl = ul.scrollTop;
      il = {
        top: tl,
        left: rl
      };
    } else {
      var sl = t.scrollX, ll = t.scrollY;
      il = {
        top: ll,
        left: sl
      };
    }
    var H = {
      left: 0,
      top: 0
    };
    if (ul) {
      var V = t.getComputedStyle(ul), X = V.borderLeftWidth, dl = V.borderTopWidth;
      H = {
        left: Jr(X) || 0,
        top: Jr(dl) || 0
      };
    }
    u({
      layer: Y,
      trigger: el,
      scrollContainers: U,
      arrow: a.current
    }, il, H);
  }, [g, u, t, a, f]), A = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function() {
    var z = g(), Y = z.trigger, el = z.layer, U = z.scrollContainers;
    if (!el)
      throw new Error(fo("layer"));
    if (!Y && !f)
      throw new Error(fo("trigger"));
    if (d) {
      for (var ul = !1, il = function() {
        if (!ul) {
          ul = !0;
          return;
        }
        S();
      }, rl = new d(il), tl = 0, sl = [Y, el, document.body]; tl < sl.length; tl++) {
        var ll = sl[tl];
        ll && rl.observe(ll);
      }
      b(function() {
        for (var fl = 0, $l = [Y, el, document.body]; fl < $l.length; fl++) {
          var cl = $l[fl];
          cl && rl.unobserve(cl);
        }
        rl.disconnect();
      });
    }
    for (var H = [t].concat(U), V = function() {
      var $l = dl.value;
      $l.addEventListener("scroll", S), b(function() {
        return $l.removeEventListener("scroll", S);
      });
    }, X = er(H), dl; !(dl = X()).done; )
      V();
  }, [g, b, S, t, d, f]), x = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(j, z) {
    n && j && j !== z && (E(), A(), S());
  }, [E, A, S, n]), I = ff((0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(j) {
    var z = g(), Y = z.layer;
    m(function(el) {
      return Au({}, el, {
        layer: j
      });
    }), x(Y, j);
  }, [g, m, x])), P = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(z) {
    var Y = j4(z, t), el = Y[0];
    if (el) {
      var U = t.getComputedStyle(el).position, ul = ["relative", "absolute", "fixed"].includes(U) || o;
      ul || (el.style.position = "relative"),  true && Td(ul, `react-laag: Set the 'position' style of the nearest scroll-container to 'relative', 'absolute' or 'fixed', or set the 'overflowContainer' prop to true. This is needed in order to position the layer properly. Currently the scroll-container is positioned: "` + U + '". For now, "position: relative;" is added for you, but this behavior might be removed in the future. Visit https://react-laag.com/docs/#position-relative for more info.');
    }
    return Y;
  }, [t, o]), O = ff((0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(j) {
    var z = P(j), Y = g(), el = Y.trigger;
    m(function(U) {
      return Au({}, U, {
        trigger: j,
        scrollContainers: z
      });
    }), x(el, j);
  }, [g, m, x, P])), _ = s == null || s.getParent == null ? void 0 : s.getParent();
  return nd(function() {
    _ && m(function(j) {
      return Au({}, j, {
        scrollContainers: P(_)
      });
    });
  }, [_, m, P]), nd(function() {
    return n && ($() || A()), function() {
      $() && E();
    };
  }, [n, $, A, E]), nd(function() {
    n && S();
  }), {
    triggerRef: O,
    layerRef: I,
    arrowRef: a,
    closestScrollContainer: g().scrollContainers[0] || null
  };
}
var W4 = /* @__PURE__ */ (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({});
function aC(l) {
  var n = l.children, u = l.registrations, t = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(o) {
    return u.current.add(o), function() {
      return u.current.delete(o);
    };
  }, [u]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(W4.Provider, {
    value: t
  }, n);
}
function sC(l, n) {
  for (var u = er(l), t; !(t = u()).done; ) {
    var r = t.value.shouldCloseWhenClickedOutside;
    if (!r(n))
      return !1;
  }
  return !0;
}
function dC(l) {
  var n = l.isOpen, u = l.onOutsideClick, t = l.onParentClose, r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), o = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(/* @__PURE__ */ new Set()), d = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(W4), a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(p) {
    var g = p.target, m = r.current && r.current.contains(g), v = o.current && o.current.contains(g), $ = sC(s.current, p);
    return v && $ && s.current.forEach(function(b) {
      var E = b.closeChild;
      return E();
    }), !m && !v && $;
  }, [r, o, s]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
    if (typeof d == "function")
      return d({
        shouldCloseWhenClickedOutside: a,
        closeChild: function() {
           true && Td(t, "react-laag: You are using useLayer() in a nested setting but forgot to set the 'onParentClose()' callback in the options. This could lead to unexpected behavior."), t && t();
        }
      });
  }, [d, a, t, s]), (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
    var f = typeof d == "function", p = !n || !u || f;
    if (p)
      return;
    function g(m) {
      a(m) && u();
    }
    return document.addEventListener("click", g, !0), function() {
      return document.removeEventListener("click", g, !0);
    };
  }, [n, u, a, d]), (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
    n || s.current.forEach(function(f) {
      var p = f.closeChild;
      return p();
    });
  }, [n]), {
    closeOnOutsideClickRefs: {
      trigger: r,
      layer: o
    },
    registrations: s
  };
}
var cC = ["bottom-start", "bottom-end", "bottom-center", "top-start", "top-center", "top-end", "left-end", "left-center", "left-start", "right-end", "right-center", "right-start", "center"], fC = {
  top: "bottom",
  left: "right",
  bottom: "top",
  right: "left",
  center: "center"
}, pC = /* @__PURE__ */ function() {
  function l(u, t, r, o, s, d, a, f, p) {
    this.prop = void 0, this.opposite = void 0, this.isHorizontal = void 0, this.sizeProp = void 0, this.oppositeSizeProp = void 0, this.cssProp = void 0, this.oppositeCssProp = void 0, this.isCenter = void 0, this.isPush = void 0, this.prop = u, this.opposite = t, this.isHorizontal = r, this.sizeProp = o, this.oppositeSizeProp = s, this.cssProp = d, this.oppositeCssProp = a, this.isCenter = f, this.isPush = p;
  }
  var n = l.prototype;
  return n.factor = function(t) {
    return t * (this.isPush ? 1 : -1);
  }, n.isOppositeDirection = function(t) {
    return this.isHorizontal !== t.isHorizontal;
  }, l;
}();
function Jt(l, n) {
  n === void 0 && (n = !0);
  var u = ["left", "right"].includes(l);
  return new pC(l, n ? Jt(fC[l], !1) : null, u, u ? "width" : "height", u ? "height" : "width", u ? "left" : "top", u ? "top" : "left", l === "center", !["right", "bottom"].includes(l));
}
var kn = {
  top: /* @__PURE__ */ Jt("top"),
  bottom: /* @__PURE__ */ Jt("bottom"),
  left: /* @__PURE__ */ Jt("left"),
  right: /* @__PURE__ */ Jt("right")
}, Mn = /* @__PURE__ */ Au({}, kn, {
  center: /* @__PURE__ */ Jt("center")
}), po = ["top", "left", "bottom", "right"], Pc = /* @__PURE__ */ function() {
  function l(n) {
    return this.top = void 0, this.left = void 0, this.right = void 0, this.bottom = void 0, Object.assign(this, n);
  }
  return l.mergeSmallestSides = function(u) {
    var t = u[0], r = u.slice(1);
    if (!t)
      throw new Error("Please provide at least 1 bounds objects in order to merge");
    for (var o = Object.fromEntries(po.map(function(m) {
      return [m, t[m]];
    })), s = er(r), d; !(d = s()).done; )
      for (var a = d.value, f = er(po), p; !(p = f()).done; ) {
        var g = p.value;
        o[g] = Math.min(o[g], a[g]);
      }
    return new l(o);
  }, ba(l, [{
    key: "allSidesArePositive",
    get: function() {
      var u = this;
      return po.every(function(t) {
        return u[t] >= 0;
      });
    }
    /**
     * Returns a partial IBoundsOffsets with sides that are negative, meaning sides aren't entirely
     * visible in respect to a parent Bounds instance
     */
  }, {
    key: "negativeSides",
    get: function() {
      var u = this;
      return Object.fromEntries(po.filter(function(t) {
        return u[t] < 0;
      }).map(function(t) {
        return [t, u[t]];
      }));
    }
  }]), l;
}();
function hf() {
  for (var l = arguments.length, n = new Array(l), u = 0; u < l; u++)
    n[u] = arguments[u];
  return n.reduce(function(t, r) {
    return t + (r ? Jr(r) : 0);
  }, 0);
}
function Fd(l) {
  var n = l.top, u = l.left, t = l.right, r = l.bottom, o = l.width, s = l.height;
  return {
    top: n,
    left: u,
    right: t,
    bottom: r,
    width: o,
    height: s
  };
}
var gC = {
  top: 0,
  left: 0,
  right: 0,
  bottom: 0,
  width: 0,
  height: 0
}, Ku = /* @__PURE__ */ function() {
  l.create = function(t) {
    return new l(t);
  }, l.fromElement = function(t, r) {
    r === void 0 && (r = {});
    var o = r, s = o.withTransform, d = s === void 0 ? !0 : s, a = o.environment, f = a === void 0 ? window : a, p = o.withScrollbars, g = p === void 0 ? !0 : p, m = Fd(t.getBoundingClientRect()), v = new l(m);
    if (!d) {
      var $ = f.getComputedStyle(t), b = $.width, E = $.height, S = $.boxSizing, A = $.borderLeft, x = $.borderRight, I = $.borderTop, P = $.borderBottom, O = $.paddingLeft, _ = $.paddingRight, j = $.paddingTop, z = $.paddingBottom, Y = S === "border-box" ? Jr(b) : hf(b, A, x, O, _), el = S === "border-box" ? Jr(E) : hf(E, I, P, j, z);
      v = new l(Au({}, v, {
        width: Y,
        height: el
      }));
    }
    if (!g) {
      var U = v.width - t.clientWidth, ul = v.height - t.clientHeight;
      return v.substract({
        right: U,
        bottom: ul
      });
    }
    return v;
  }, l.empty = function() {
    return new l();
  }, l.fromWindow = function(t) {
    var r, o = (r = t == null ? void 0 : t.document.scrollingElement) != null ? r : t == null ? void 0 : t.document.documentElement, s = o ?? {}, d = s.clientWidth, a = d === void 0 ? 0 : d, f = s.clientHeight, p = f === void 0 ? 0 : f;
    return new l({
      width: a,
      height: p,
      right: a,
      bottom: p
    });
  };
  function l(u) {
    return u === void 0 && (u = {}), this.top = void 0, this.left = void 0, this.right = void 0, this.bottom = void 0, this.width = void 0, this.height = void 0, Object.assign(this, gC, u);
  }
  var n = l.prototype;
  return n.toObject = function() {
    return Fd(this);
  }, n.merge = function(t) {
    var r = this.toObject();
    return new l(Au({}, r, typeof t == "function" ? t(r) : t));
  }, n.substract = function(t) {
    for (var r = this.toObject(), o = Object.entries(t), s = 0, d = o; s < d.length; s++) {
      var a = d[s], f = a[0], p = a[1];
      if (f in kn) {
        var g = kn[f];
        r[f] += g.factor(p), r[g.isHorizontal ? "width" : "height"] -= p;
      } else
        r[f] -= p || 0;
    }
    return new l(r);
  }, n.offsetsTo = function(t) {
    return new Pc({
      top: t.top - this.top,
      bottom: this.bottom - t.bottom,
      left: t.left - this.left,
      right: this.right - t.right
    });
  }, n.mapSides = function(t) {
    for (var r = this.toObject(), o = Object.values(kn), s = 0, d = o; s < d.length; s++) {
      var a = d[s];
      r[a.prop] = t(a, r[a.prop]);
    }
    return new l(r);
  }, ba(l, [{
    key: "surface",
    get: function() {
      return this.width * this.height;
    }
  }]), l;
}(), V4 = /* @__PURE__ */ function() {
  function l(u, t, r, o, s) {
    this.primary = void 0, this.secondary = void 0, this.offsets = void 0, this.subjectsBounds = void 0, this._cachedLayerBounds = null, this._cachedContainerOffsets = null, this.primary = u, this.secondary = t, this.offsets = s, this.setSubjectsBounds(r, o);
  }
  var n = l.prototype;
  return n.setSubjectsBounds = function(t, r) {
    if (!r) {
      this.subjectsBounds = t;
      return;
    }
    var o = (
      // if the user passed a callback, call it with the layerSide corresponding to
      // the placement
      typeof r == "function" ? r(this.primary.prop) : r
    );
    this.subjectsBounds = t.merge({
      layer: Au({}, t.layer, o)
    });
  }, n.getLayerBounds = function(t) {
    if (t === void 0 && (t = 0), this._cachedLayerBounds && t === 0)
      return this._cachedLayerBounds;
    var r = this.primary, o = this.secondary, s = this.subjectsBounds, d = s.trigger, a = s.layer, f = s.arrow, p = r.isHorizontal, g = r.oppositeCssProp, m = r.oppositeSizeProp, v = r.prop, $ = r.opposite, b = Ku.empty();
    b[$.prop] = d[v] - r.factor(this.offsets.trigger), b[v] = b[$.prop] - r.factor(a[r.sizeProp]);
    var E = this.offsets.arrow * 2, S = d[g] - (a[m] - f[m]) + E, A = d[g] + (d[m] - f[m]) - E;
    if (o.isPush || (S += a[m], A += a[m]), o.isCenter) {
      var x = (p ? kn.top : kn.left).prop, I = (p ? kn.bottom : kn.right).prop;
      b[x] = Od(d[x] + d[m] / 2 - a[m] / 2 + t, S, A), b[I] = b[x] + a[m];
    } else {
      var P = o, O = d[P.prop], _ = O < S ? S - O : O > A ? A - O : 0;
      b[P.prop] = Od(O + t + _, S, A), b[P.opposite.prop] = b[P.prop] + o.factor(a[m]);
    }
    b.width = b.right - b.left, b.height = b.bottom - b.top;
    var j = Ku.create(b);
    return t === 0 && (this._cachedLayerBounds = j), j;
  }, n.getLayerCollisionBounds = function() {
    var t = this.offsets.container;
    return this.getLayerBounds().mapSides(function(r, o) {
      return o -= r.factor(t);
    }).merge(function(r) {
      var o = r.width, s = r.height;
      return {
        width: o + t * 2,
        height: s + t * 2
      };
    });
  }, n.getContainerOffsets = function(t) {
    if (this._cachedContainerOffsets && !t)
      return this._cachedContainerOffsets;
    var r = this.subjectsBounds.merge({
      layer: t || this.getLayerCollisionBounds()
    }), o = Pc.mergeSmallestSides(r.layerOffsetsToScrollContainers);
    return t || (this._cachedContainerOffsets = o), o;
  }, ba(l, [{
    key: "type",
    get: function() {
      return this.primary.prop + "-" + (this.secondary.prop === "center" ? "center" : ["bottom", "right"].includes(this.secondary.prop) ? "end" : "start");
    }
  }, {
    key: "triggerIsBigger",
    get: function() {
      var t = this.secondary.isHorizontal, r = this.subjectsBounds, o = r.triggerHasBiggerWidth, s = r.triggerHasBiggerHeight;
      return t && o || !t && s;
    }
    /**
     * Checks whether the placement fits within all it's container (including container-offset)
     */
  }, {
    key: "fitsContainer",
    get: function() {
      return this.getContainerOffsets().allSidesArePositive;
    }
    /**
     * Returns the surface in square pixels of the visible part of the layer
     */
  }, {
    key: "visibleSurface",
    get: function() {
      var t = this.getLayerBounds(), r = this.getContainerOffsets(t), o = r.negativeSides;
      for (var s in o)
        o[s] = -o[s];
      return t.substract(o).surface;
    }
    /**
     * Returns a BoundSide by looking at the most negative offset that is the opposite direction
     */
  }, {
    key: "secondaryOffsetSide",
    get: function() {
      var t, r, o = this, s = this.getContainerOffsets(), d = (t = (r = Object.entries(s.negativeSides).map(function(f) {
        var p = f[0], g = f[1];
        return [kn[p], g];
      }).filter(function(f) {
        var p = f[0];
        return o.primary.isOppositeDirection(p);
      }).sort(function(f, p) {
        var g = f[1], m = p[1];
        return m - g;
      })) == null ? void 0 : r[0]) != null ? t : [], a = d[0];
      return a || null;
    }
  }]), l;
}(), mf = /* @__PURE__ */ function(l) {
  nC(n, l);
  function n() {
    return l.apply(this, arguments) || this;
  }
  var u = n.prototype;
  return u.getLayerBounds = function() {
    var r = this.subjectsBounds, o = r.trigger, s = r.layer, d = Ku.empty();
    return d.top = o.top + o.height / 2 - s.height / 2, d.bottom = d.top + s.height, d.left = o.left + o.width / 2 - s.width / 2, d.right = d.left + s.width, d.width = d.right - d.left, d.height = d.bottom - d.top, d;
  }, n;
}(V4);
function hC(l, n, u) {
  var t = l.layer, r = l.trigger, o = l.arrow, s = n.primary.oppositeSizeProp, d = n.primary.isHorizontal ? ["top", "bottom"] : ["left", "right"], a = d[0], f = d[1], p = t[a] + t[s] / 2 - r[a] - o[s] / 2 - u, g = t[f] - t[s] / 2 - r[f] + o[s] / 2 + u;
  return (p < 0 ? -p : 0) + (g > 0 ? -g : 0);
}
var vf = {
  position: "absolute",
  willChange: "top, left",
  left: null,
  right: null,
  top: null,
  bottom: null
};
function mC(l, n, u) {
  var t;
  if (n.primary.isCenter)
    return vf;
  var r = l.layer, o = l.trigger, s = l.arrow, d = n.primary.oppositeSizeProp, a = o[d] > r[d], f = u + s[d] / 2, p = r[d] - s[d] / 2 - u, g = hC(l, n, u), m = n.primary.prop, v = n.primary.oppositeCssProp, $ = a ? r[d] / 2 + g : o[v] + o[d] / 2 - r[v];
  return Au({}, vf, (t = {}, t[m] = "100%", t[v] = Od($, f, p), t));
}
var bf = /* @__PURE__ */ function() {
  function l(u, t, r) {
    this.placements = void 0, this.config = void 0, this.subjectsBounds = void 0, this.placements = u, this.config = t, this.subjectsBounds = r;
  }
  l.getSidesFromPlacementType = function(t) {
    var r = t.split("-"), o = r[0], s = r[1], d = kn[o], a;
    return s === "center" ? a = Mn.center : d.isHorizontal ? a = s === "start" ? Mn.top : Mn.bottom : a = s === "start" ? Mn.left : Mn.right, [d, a];
  }, l.create = function(t, r) {
    var o = {
      arrow: r.arrowOffset,
      container: r.containerOffset,
      trigger: r.triggerOffset
    };
    function s(d) {
      d === void 0 && (d = r.placement);
      var a = l.getSidesFromPlacementType(d), f = a[0], p = a[1], g = kn[f.isHorizontal ? r.preferY : r.preferX], m = !f.isHorizontal && t.triggerHasBiggerWidth || f.isHorizontal && t.triggerHasBiggerHeight;
      function v(b, E) {
        return new V4(b, E, t, r.layerDimensions, o);
      }
      var $ = [];
      return $[0] = v(f, p), $[1] = v(f, p.isCenter ? g : Mn.center), $[2] = v(f, Mn[(p.opposite.isCenter ? g.opposite : p.opposite).prop]), $[3] = v(g, m ? f : Mn[f.opposite.prop]), $[4] = v(g, Mn.center), $[5] = v(g, m ? Mn[f.opposite.prop] : f), $[6] = v(kn[g.opposite.prop], m ? f : Mn[f.opposite.prop]), $[7] = v(kn[g.opposite.prop], Mn.center), $[8] = v(kn[g.opposite.prop], m ? Mn[f.opposite.prop] : f), $[9] = v(kn[f.opposite.prop], p), $[10] = v(kn[f.opposite.prop], p.isCenter ? g : Mn.center), $[11] = v(kn[f.opposite.prop], Mn[(p.opposite.isCenter ? g.opposite : p.opposite).prop]), $ = $.filter(function(b) {
        return b.type === r.placement || r.possiblePlacements.includes(b.type);
      }), $;
    }
    return r.placement === "center" ? new l([new mf(Mn.center, Mn.center, t, r.layerDimensions, o)].concat(s(r.preferY + "-" + r.preferX)), r, t) : new l(s(), r, t);
  };
  var n = l.prototype;
  return n.filterPlacementsBySide = function(t) {
    return this.placements.filter(function(r) {
      return r.primary === t;
    });
  }, n.findFirstPlacementThatFits = function() {
    return this.placements.find(function(t) {
      return t.fitsContainer;
    });
  }, n.placementWithBiggestVisibleSurface = function() {
    var t = this.placements.map(function(o) {
      return {
        placement: o,
        surface: o.visibleSurface
      };
    }).sort(function(o, s) {
      return s.surface - o.surface;
    }), r = t[0].placement;
    return r;
  }, n.findSuitablePlacement = function() {
    return this.config.auto ? this.findFirstPlacementThatFits() || this.placementWithBiggestVisibleSurface() : this.placements[0];
  }, n.getSecondaryOffset = function(t) {
    var r = this.config, o = r.auto, s = r.snap;
    if (!o || s || t instanceof mf)
      return 0;
    var d = this.filterPlacementsBySide(t.primary), a = d.indexOf(t) === 0;
    if (a && t.fitsContainer)
      return 0;
    var f = d.find(function(b) {
      return !b.fitsContainer;
    });
    if (!f)
      return 0;
    var p = f.secondaryOffsetSide;
    if (!p)
      return 0;
    var g = t.getContainerOffsets(), m = t.secondary, v;
    t.triggerIsBigger || f === t ? v = p.isPush ? -1 : 1 : v = m === Mn.left || [Mn.top, Mn.center].includes(m) && p.isPush ? -1 : 1;
    var $ = g[p.prop];
    return $ * v;
  }, n.getStyles = function(t, r, o, s) {
    var d = {
      willChange: "top, left, width, height"
    }, a = mC(this.subjectsBounds.merge({
      layer: t
    }), r, this.config.arrowOffset), f = this.config.overflowContainer ? Au({}, d, {
      position: "fixed",
      top: t.top,
      left: t.left
    }) : Au({}, d, {
      position: "absolute",
      top: t.top - this.subjectsBounds.parent.top + o.top - s.top,
      left: t.left - this.subjectsBounds.parent.left + o.left - s.left
    });
    return {
      arrow: a,
      layer: f
    };
  }, n.getHasDisappeared = function(t) {
    var r = this.config.overflowContainer ? this.subjectsBounds.trigger : t, o = Pc.mergeSmallestSides(this.subjectsBounds.offsetsToScrollContainers(r, !0)), s = Object.entries(o.negativeSides), d = s.some(function(a) {
      var f = a[0], p = a[1], g = kn[f];
      return p <= -r[g.sizeProp];
    });
    return d ? "full" : o.allSidesArePositive ? null : "partial";
  }, n.result = function(t, r) {
    var o = this.findSuitablePlacement(), s = this.getSecondaryOffset(o), d = o.getLayerBounds(s), a = this.getStyles(d, o, t, r), f = o.primary.prop;
    return {
      styles: a,
      layerSide: f,
      placement: o,
      layerBounds: d,
      hasDisappeared: this.getHasDisappeared(d)
    };
  }, l;
}(), vC = /* @__PURE__ */ function() {
  function l(u, t) {
    this.overflowContainer = void 0, this.trigger = void 0, this.layer = void 0, this.arrow = void 0, this.parent = void 0, this.window = void 0, this.scrollContainers = void 0, this.overflowContainer = t, Object.assign(this, u);
  }
  l.create = function(t, r, o, s, d, a, f, p) {
    var g = Ku.fromWindow(t);
    return new l({
      layer: Ku.fromElement(r, {
        environment: t,
        withTransform: !1
      }),
      trigger: p ? Ku.create(Fd(p())) : Ku.fromElement(o),
      arrow: d ? Ku.fromElement(d) : Ku.empty(),
      parent: s ? Ku.fromElement(s) : g,
      window: g,
      scrollContainers: [g].concat(a.map(function(m) {
        return Ku.fromElement(m, {
          withScrollbars: !1
        });
      }))
    }, f);
  };
  var n = l.prototype;
  return n.merge = function(t) {
    return new l(Au({}, this, t), this.overflowContainer);
  }, n.offsetsToScrollContainers = function(t, r) {
    r === void 0 && (r = !1);
    var o = this.overflowContainer && !r ? [this.window] : this.scrollContainers;
    return o.map(function(s) {
      return s.offsetsTo(t);
    });
  }, ba(l, [{
    key: "layerOffsetsToScrollContainers",
    get: function() {
      return this.offsetsToScrollContainers(this.layer);
    }
  }, {
    key: "triggerHasBiggerWidth",
    get: function() {
      return this.trigger.width > this.layer.width;
    }
  }, {
    key: "triggerHasBiggerHeight",
    get: function() {
      return this.trigger.height > this.layer.height;
    }
  }]), l;
}(), yf = null, Uu = {
  auto: !1,
  arrowOffset: 0,
  containerOffset: 10,
  triggerOffset: 0,
  overflowContainer: !0,
  placement: "top-center",
  possiblePlacements: cC,
  preferX: "right",
  preferY: "bottom",
  snap: !1,
  container: void 0,
  trigger: void 0
};
function bC(l) {
  var n, u = l.isOpen, t = u === void 0 ? !1 : u, r = l.overflowContainer, o = r === void 0 ? Uu.overflowContainer : r, s = l.environment, d = s === void 0 ? typeof window < "u" ? window : void 0 : s, a = l.ResizeObserver, f = l.placement, p = f === void 0 ? Uu.placement : f, g = l.possiblePlacements, m = g === void 0 ? Uu.possiblePlacements : g, v = l.preferX, $ = v === void 0 ? Uu.preferX : v, b = l.preferY, E = b === void 0 ? Uu.preferY : b, S = l.auto, A = S === void 0 ? Uu.auto : S, x = l.snap, I = x === void 0 ? Uu.snap : x, P = l.triggerOffset, O = P === void 0 ? Uu.triggerOffset : P, _ = l.containerOffset, j = _ === void 0 ? Uu.containerOffset : _, z = l.arrowOffset, Y = z === void 0 ? Uu.arrowOffset : z, el = l.container, U = el === void 0 ? Uu.container : el, ul = l.layerDimensions, il = ul === void 0 ? null : ul, rl = l.onDisappear, tl = l.onOutsideClick, sl = l.onParentClose, ll = l.trigger, H = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(function() {
    return {
      layerSide: p === "center" ? "center" : bf.getSidesFromPlacementType(p)[0].prop,
      styles: {
        layer: {
          position: o ? "fixed" : "absolute",
          top: 0,
          left: 0
        },
        arrow: {
          position: "absolute",
          top: 0,
          left: 0
        }
      }
    };
  }), V = H[0], X = H[1], dl = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), fl = rC(V, t), $l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)({
    cancelled: !1
  });
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
    return function() {
      $l.current.cancelled = !0;
    };
  }, []);
  var cl = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(fn, dn, Fn) {
    var sn = fn.arrow, gn = fn.layer, _n = fn.scrollContainers, Zn = fn.trigger, ne = _n[0], _e = vC.create(d, gn, Zn, ne, sn, _n, o, ll == null ? void 0 : ll.getBounds), Nu = {
      placement: p,
      possiblePlacements: m,
      auto: A,
      layerDimensions: il,
      arrowOffset: Y,
      containerOffset: j,
      triggerOffset: O,
      preferX: $,
      preferY: E,
      snap: I,
      overflowContainer: o
    }, ue = bf.create(_e, Nu).result(dn, Fn), Kn = ue.hasDisappeared, mu = ue.layerSide, R = ue.styles, G = {
      layerSide: mu,
      styles: R
    };
    if (!fl.current || yC(fl.current, G)) {
      fl.current = G, $l.current.cancelled = !0;
      var W = {
        cancelled: !1
      };
      $l.current = W, Promise.resolve().then(function() {
        W.cancelled || X(G);
      });
    }
    pf(Kn) && pf(rl) && rl(Kn);
  }, [Y, A, j, d, il, rl, o, p, m, $, E, I, O, fl, ll]), xl = oC({
    ResizeObserverPolyfill: a,
    environment: d,
    enabled: t,
    overflowContainer: o,
    onChange: cl,
    triggerOption: ll
  }), ol = xl.triggerRef, ml = xl.layerRef, Sl = xl.arrowRef, Ol = xl.closestScrollContainer, Cl = dC({
    isOpen: t,
    onOutsideClick: tl,
    onParentClose: sl
  }), Q = Cl.closeOnOutsideClickRefs, Xl = Cl.registrations, Bl = {
    triggerProps: ll ? {} : {
      ref: gf(ol, Q.trigger, dl)
    },
    layerProps: {
      ref: gf(ml, Q.layer),
      style: V.styles.layer
    },
    arrowProps: {
      ref: Sl,
      style: V.styles.arrow,
      layerSide: V.layerSide
    },
    layerSide: V.layerSide,
    triggerBounds: t ? ll ? ll.getBounds() : (n = dl.current) == null ? void 0 : n.getBoundingClientRect() : null,
    renderLayer: function(fn) {
      return typeof document < "u" ? (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal)((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(aC, {
        registrations: Xl,
        children: fn
      }), o || !Ol ? $C(U) : Ol) : null;
    }
  };
  return Bl;
}
function yC(l, n) {
  if (l.layerSide !== n.layerSide)
    return !0;
  for (var u = ["position", "top", "left", "right", "bottom"], t = 0, r = u; t < r.length; t++) {
    var o = r[t];
    if (l.styles.layer[o] !== n.styles.layer[o] || l.styles.arrow[o] !== n.styles.arrow[o])
      return !0;
  }
  return !1;
}
var $f = "layers";
function $C(l) {
  var n;
  if (typeof l == "function") {
    if (n = l(), !n || !(n instanceof HTMLElement))
      throw new Error("react-laag: You've passed a function to the 'container' prop, but it returned no valid HTMLElement");
  } else if (l instanceof HTMLElement)
    n = l;
  else if (typeof l == "string") {
    if (n = document.getElementById(l), !n)
      throw new Error("react-laag: You've passed element with id '" + l + "' to the 'container' prop, but it returned no valid HTMLElement");
  } else {
    if (yf instanceof HTMLElement)
      return yf;
    n = document.getElementById($f), n || (n = document.createElement("div"), n.id = $f, n.style.cssText = `
        position: absolute;
        top: 0px;
        left: 0px;
        right: 0px;
      `, document.body.appendChild(n));
  }
  return n;
}
var xf;
(function(l) {
  l[l.ENTERING = 0] = "ENTERING", l[l.LEAVING = 1] = "LEAVING", l[l.IDLE = 2] = "IDLE";
})(xf || (xf = {}));
const k4 = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(void 0), Nc = ({
  initialOpen: l = !1,
  isOpen: n,
  setIsOpen: u,
  className: t,
  placement: r = "bottom-end",
  children: o
}) => {
  const [s, d] = react__WEBPACK_IMPORTED_MODULE_0__.useState(l), a = n ?? s, f = u ?? d, p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => f(!1), [f]), { renderLayer: g, triggerProps: m, layerProps: v } = bC({
    isOpen: a,
    onOutsideClick: p,
    // close the menu when the user clicks outside
    onDisappear: p,
    // close the menu when the menu gets scrolled out of sight
    overflowContainer: !0,
    // keep the menu positioned inside the container
    auto: !0,
    // automatically find the best placement
    placement: r,
    // we prefer to place the menu "top-end"
    triggerOffset: 8,
    // keep some distance to the trigger
    containerOffset: 16,
    // give the menu some room to breath relative to the container
    arrowOffset: 16
    // let the arrow have some room to breath also
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (n && !u)
      throw new Error("Must provide setIsOpen prop when using isOpen prop");
  }, []), /* @__PURE__ */ y.jsx(
    k4.Provider,
    {
      value: {
        isOpen: a,
        setIsOpen: f,
        renderLayer: g,
        triggerProps: m,
        layerProps: v
      },
      children: /* @__PURE__ */ y.jsx("div", { className: Oe("relative inline-block", t), children: o })
    }
  );
}, Tc = () => {
  const l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(k4);
  if (l === void 0)
    throw new Error("Must be used in a Dropdown component");
  return l;
}, xC = ({ children: l, className: n }) => {
  const { isOpen: u, setIsOpen: t, triggerProps: r } = Tc();
  return /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsx(
    "div",
    {
      role: "button",
      ...r,
      className: n,
      onClick: () => {
        t(!u);
      },
      children: l
    }
  ) });
}, CC = ({ className: l, children: n }) => {
  const { isOpen: u, renderLayer: t, layerProps: r } = Tc();
  return /* @__PURE__ */ y.jsx(y.Fragment, { children: t(
    u && /* @__PURE__ */ y.jsx("div", { ...r, className: Oe("relative z-20 rounded border bg-white shadow-lg", l), children: n })
  ) });
}, wC = ({ children: l, className: n }) => {
  const { setIsOpen: u } = Tc();
  return /* @__PURE__ */ y.jsx(
    "div",
    {
      className: Oe(
        "flex w-full items-center px-4 py-2 text-left text-sm leading-5 text-gray-800 transition duration-150 ease-in-out first:rounded-t last:rounded-b hover:bg-gray-100 focus:outline-none",
        n
      ),
      onClick: () => u(!1),
      children: l
    }
  );
};
Nc.Trigger = xC;
Nc.Content = CC;
Nc.Item = wC;
const v_ = (l) => /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsxs("fieldset", { className: "space-y-5", children: [
  /* @__PURE__ */ y.jsx("legend", { className: "sr-only", children: "List" }),
  l.inputs.map((n) => /* @__PURE__ */ y.jsxs("div", { className: "relative flex items-start", children: [
    /* @__PURE__ */ y.jsx("div", { className: "flex items-center h-5", children: /* @__PURE__ */ y.jsx(
      "input",
      {
        ...(({ label: u, description: t, ...r }) => r)(n),
        onChange: l.onChange,
        id: n.id,
        type: "checkbox",
        className: "focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded"
      }
    ) }),
    /* @__PURE__ */ y.jsxs("div", { className: "ml-3 text-sm", children: [
      /* @__PURE__ */ y.jsx("label", { htmlFor: n.id, className: "font-medium text-gray-700", children: n.label }),
      /* @__PURE__ */ y.jsx("p", { id: `${n.id}-description`, className: "text-gray-500", children: n.description })
    ] })
  ] }, n.id))
] }) }), b_ = (l) => /* @__PURE__ */ y.jsxs(
  "svg",
  {
    className: l.className,
    xmlns: "http://www.w3.org/2000/svg",
    width: l.width || "48",
    height: l.height || "48",
    viewBox: "0 0 48 48",
    children: [
      /* @__PURE__ */ y.jsx(
        "path",
        {
          fill: "#FFC107",
          d: "M43.611,20.083H42V20H24v8h11.303c-1.649,4.657-6.08,8-11.303,8c-6.627,0-12-5.373-12-12c0-6.627,5.373-12,12-12c3.059,0,5.842,1.154,7.961,3.039l5.657-5.657C34.046,6.053,29.268,4,24,4C12.955,4,4,12.955,4,24c0,11.045,8.955,20,20,20c11.045,0,20-8.955,20-20C44,22.659,43.862,21.35,43.611,20.083z"
        }
      ),
      /* @__PURE__ */ y.jsx(
        "path",
        {
          fill: "#FF3D00",
          d: "M6.306,14.691l6.571,4.819C14.655,15.108,18.961,12,24,12c3.059,0,5.842,1.154,7.961,3.039l5.657-5.657C34.046,6.053,29.268,4,24,4C16.318,4,9.656,8.337,6.306,14.691z"
        }
      ),
      /* @__PURE__ */ y.jsx(
        "path",
        {
          fill: "#4CAF50",
          d: "M24,44c5.166,0,9.86-1.977,13.409-5.192l-6.19-5.238C29.211,35.091,26.715,36,24,36c-5.202,0-9.619-3.317-11.283-7.946l-6.522,5.025C9.505,39.556,16.227,44,24,44z"
        }
      ),
      /* @__PURE__ */ y.jsx(
        "path",
        {
          fill: "#1976D2",
          d: "M43.611,20.083H42V20H24v8h11.303c-0.792,2.237-2.231,4.166-4.087,5.571c0.001-0.001,0.002-0.001,0.003-0.002l6.19,5.238C36.971,39.205,44,34,44,24C44,22.659,43.862,21.35,43.611,20.083z"
        }
      )
    ]
  }
), wt = ({ children: l, showXButton: n = !0, className: u, isOpen: t, onClose: r, backdropClassName: o }) => /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsx(Je, { appear: !0, show: t, as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment, children: /* @__PURE__ */ y.jsx(Nd, { as: "div", className: "fixed inset-0 z-10 overflow-auto", onClose: r, children: /* @__PURE__ */ y.jsxs("div", { className: "min-h-screen p-4 text-center flex justify-center", children: [
  /* @__PURE__ */ y.jsx(
    Je.Child,
    {
      as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
      enter: "ease-out duration-300",
      enterFrom: "opacity-0",
      enterTo: "opacity-100",
      leave: "ease-in duration-200",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      children: /* @__PURE__ */ y.jsx(
        Jx,
        {
          onClick: r,
          className: wl(
            "fixed inset-0 bg-black bg-opacity-75 transition-opacity backdrop-blur-sm",
            o
          )
        }
      )
    }
  ),
  /* @__PURE__ */ y.jsx(
    Je.Child,
    {
      as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
      enter: "ease-out duration-300",
      enterFrom: "opacity-0 scale-95",
      enterTo: "opacity-100 scale-100",
      leave: "ease-in duration-200",
      leaveFrom: "opacity-100 scale-100",
      leaveTo: "opacity-0 scale-95",
      children: /* @__PURE__ */ y.jsxs(
        "div",
        {
          className: wl(
            "relative inline-block text-left w-full rounded transition-all transform bg-white shadow-xl self-center",
            u
          ),
          children: [
            l,
            n && /* @__PURE__ */ y.jsx(
              "button",
              {
                type: "button",
                onClick: r,
                className: "absolute right-2 top-2 rounded-primary p-1.5 transition-colors duration-150 text-sm text-gray-500 hover:text-gray-700 outline-none focus:outline-none",
                children: "✕"
              }
            )
          ]
        }
      )
    }
  )
] }) }) }) }), IC = ({ children: l, className: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("p-4 font-semibold", n), ...u, children: l }), EC = ({ children: l, className: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("p-4", n), ...u, children: l }), AC = ({ children: l, className: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("p-4", n), ...u, children: l });
wt.Title = IC;
wt.Content = EC;
wt.Footer = AC;
const SC = (l) => /* @__PURE__ */ y.jsxs(
  "svg",
  {
    width: l.width || "15",
    height: l.height || "15",
    viewBox: "0 0 15 15",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: [
      /* @__PURE__ */ y.jsx(
        "path",
        {
          d: "M6.40024 2.40909L1.13653 11.1964C1.02801 11.3844 0.970583 11.5975 0.969976 11.8145C0.969368 12.0315 1.0256 12.2449 1.13307 12.4334C1.24054 12.622 1.39551 12.7791 1.58255 12.8892C1.7696 12.9992 1.9822 13.0584 2.19922 13.0608H12.7266C12.9436 13.0584 13.1562 12.9992 13.3433 12.8892C13.5303 12.7791 13.6853 12.622 13.7928 12.4334C13.9002 12.2449 13.9565 12.0315 13.9559 11.8145C13.9553 11.5975 13.8978 11.3844 13.7893 11.1964L8.52561 2.40909C8.41482 2.22645 8.25883 2.07544 8.07269 1.97065C7.88655 1.86585 7.67654 1.81079 7.46292 1.81079C7.24931 1.81079 7.0393 1.86585 6.85315 1.97065C6.66701 2.07544 6.51102 2.22645 6.40024 2.40909V2.40909Z",
          stroke: "#E64B5F",
          strokeWidth: "1.7",
          strokeLinecap: "round",
          strokeLinejoin: "round"
        }
      ),
      /* @__PURE__ */ y.jsx("path", { d: "M7.5 5.625V8.125", stroke: "#E64B5F", strokeWidth: "1.7", strokeLinecap: "round", strokeLinejoin: "round" }),
      /* @__PURE__ */ y.jsx("path", { d: "M7.5 10.625H7.50625", stroke: "#E64B5F", strokeWidth: "1.7", strokeLinecap: "round", strokeLinejoin: "round" })
    ]
  }
);
var PC = Object.prototype;
function NC(l) {
  var n = l && l.constructor, u = typeof n == "function" && n.prototype || PC;
  return l === u;
}
var H4 = NC;
function TC(l, n) {
  return function(u) {
    return l(n(u));
  };
}
var RC = TC, OC = RC, FC = OC(Object.keys, Object), _C = FC, DC = H4, MC = _C, BC = Object.prototype, LC = BC.hasOwnProperty;
function GC(l) {
  if (!DC(l))
    return MC(l);
  var n = [];
  for (var u in Object(l))
    LC.call(l, u) && u != "constructor" && n.push(u);
  return n;
}
var jC = GC, WC = typeof Jn == "object" && Jn && Jn.Object === Object && Jn, Z4 = WC, VC = Z4, kC = typeof self == "object" && self && self.Object === Object && self, HC = VC || kC || Function("return this")(), ut = HC, ZC = ut, XC = ZC.Symbol, X4 = XC, Cf = X4, z4 = Object.prototype, zC = z4.hasOwnProperty, YC = z4.toString, jr = Cf ? Cf.toStringTag : void 0;
function UC(l) {
  var n = zC.call(l, jr), u = l[jr];
  try {
    l[jr] = void 0;
    var t = !0;
  } catch {
  }
  var r = YC.call(l);
  return t && (n ? l[jr] = u : delete l[jr]), r;
}
var JC = UC, KC = Object.prototype, QC = KC.toString;
function qC(l) {
  return QC.call(l);
}
var lw = qC, wf = X4, nw = JC, uw = lw, ew = "[object Null]", tw = "[object Undefined]", If = wf ? wf.toStringTag : void 0;
function rw(l) {
  return l == null ? l === void 0 ? tw : ew : If && If in Object(l) ? nw(l) : uw(l);
}
var ya = rw;
function iw(l) {
  var n = typeof l;
  return l != null && (n == "object" || n == "function");
}
var Y4 = iw, ow = ya, aw = Y4, sw = "[object AsyncFunction]", dw = "[object Function]", cw = "[object GeneratorFunction]", fw = "[object Proxy]";
function pw(l) {
  if (!aw(l))
    return !1;
  var n = ow(l);
  return n == dw || n == cw || n == sw || n == fw;
}
var U4 = pw, gw = ut, hw = gw["__core-js_shared__"], mw = hw, ud = mw, Ef = function() {
  var l = /[^.]+$/.exec(ud && ud.keys && ud.keys.IE_PROTO || "");
  return l ? "Symbol(src)_1." + l : "";
}();
function vw(l) {
  return !!Ef && Ef in l;
}
var bw = vw, yw = Function.prototype, $w = yw.toString;
function xw(l) {
  if (l != null) {
    try {
      return $w.call(l);
    } catch {
    }
    try {
      return l + "";
    } catch {
    }
  }
  return "";
}
var J4 = xw, Cw = U4, ww = bw, Iw = Y4, Ew = J4, Aw = /[\\^$.*+?()[\]{}|]/g, Sw = /^\[object .+?Constructor\]$/, Pw = Function.prototype, Nw = Object.prototype, Tw = Pw.toString, Rw = Nw.hasOwnProperty, Ow = RegExp(
  "^" + Tw.call(Rw).replace(Aw, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
);
function Fw(l) {
  if (!Iw(l) || ww(l))
    return !1;
  var n = Cw(l) ? Ow : Sw;
  return n.test(Ew(l));
}
var _w = Fw;
function Dw(l, n) {
  return l == null ? void 0 : l[n];
}
var Mw = Dw, Bw = _w, Lw = Mw;
function Gw(l, n) {
  var u = Lw(l, n);
  return Bw(u) ? u : void 0;
}
var ri = Gw, jw = ri, Ww = ut, Vw = jw(Ww, "DataView"), kw = Vw, Hw = ri, Zw = ut, Xw = Hw(Zw, "Map"), zw = Xw, Yw = ri, Uw = ut, Jw = Yw(Uw, "Promise"), Kw = Jw, Qw = ri, qw = ut, lI = Qw(qw, "Set"), nI = lI, uI = ri, eI = ut, tI = uI(eI, "WeakMap"), rI = tI, _d = kw, Dd = zw, Md = Kw, Bd = nI, Ld = rI, K4 = ya, pr = J4, Af = "[object Map]", iI = "[object Object]", Sf = "[object Promise]", Pf = "[object Set]", Nf = "[object WeakMap]", Tf = "[object DataView]", oI = pr(_d), aI = pr(Dd), sI = pr(Md), dI = pr(Bd), cI = pr(Ld), yt = K4;
(_d && yt(new _d(new ArrayBuffer(1))) != Tf || Dd && yt(new Dd()) != Af || Md && yt(Md.resolve()) != Sf || Bd && yt(new Bd()) != Pf || Ld && yt(new Ld()) != Nf) && (yt = function(l) {
  var n = K4(l), u = n == iI ? l.constructor : void 0, t = u ? pr(u) : "";
  if (t)
    switch (t) {
      case oI:
        return Tf;
      case aI:
        return Af;
      case sI:
        return Sf;
      case dI:
        return Pf;
      case cI:
        return Nf;
    }
  return n;
});
var fI = yt;
function pI(l) {
  return l != null && typeof l == "object";
}
var Rc = pI, gI = ya, hI = Rc, mI = "[object Arguments]";
function vI(l) {
  return hI(l) && gI(l) == mI;
}
var bI = vI, Rf = bI, yI = Rc, Q4 = Object.prototype, $I = Q4.hasOwnProperty, xI = Q4.propertyIsEnumerable, CI = Rf(/* @__PURE__ */ function() {
  return arguments;
}()) ? Rf : function(l) {
  return yI(l) && $I.call(l, "callee") && !xI.call(l, "callee");
}, wI = CI, II = Array.isArray, EI = II, AI = 9007199254740991;
function SI(l) {
  return typeof l == "number" && l > -1 && l % 1 == 0 && l <= AI;
}
var q4 = SI, PI = U4, NI = q4;
function TI(l) {
  return l != null && NI(l.length) && !PI(l);
}
var RI = TI, Xo = { exports: {} };
function OI() {
  return !1;
}
var FI = OI;
Xo.exports;
(function(l, n) {
  var u = ut, t = FI, r = n && !n.nodeType && n, o = r && !0 && l && !l.nodeType && l, s = o && o.exports === r, d = s ? u.Buffer : void 0, a = d ? d.isBuffer : void 0, f = a || t;
  l.exports = f;
})(Xo, Xo.exports);
var _I = Xo.exports, DI = ya, MI = q4, BI = Rc, LI = "[object Arguments]", GI = "[object Array]", jI = "[object Boolean]", WI = "[object Date]", VI = "[object Error]", kI = "[object Function]", HI = "[object Map]", ZI = "[object Number]", XI = "[object Object]", zI = "[object RegExp]", YI = "[object Set]", UI = "[object String]", JI = "[object WeakMap]", KI = "[object ArrayBuffer]", QI = "[object DataView]", qI = "[object Float32Array]", lE = "[object Float64Array]", nE = "[object Int8Array]", uE = "[object Int16Array]", eE = "[object Int32Array]", tE = "[object Uint8Array]", rE = "[object Uint8ClampedArray]", iE = "[object Uint16Array]", oE = "[object Uint32Array]", bn = {};
bn[qI] = bn[lE] = bn[nE] = bn[uE] = bn[eE] = bn[tE] = bn[rE] = bn[iE] = bn[oE] = !0;
bn[LI] = bn[GI] = bn[KI] = bn[jI] = bn[QI] = bn[WI] = bn[VI] = bn[kI] = bn[HI] = bn[ZI] = bn[XI] = bn[zI] = bn[YI] = bn[UI] = bn[JI] = !1;
function aE(l) {
  return BI(l) && MI(l.length) && !!bn[DI(l)];
}
var sE = aE;
function dE(l) {
  return function(n) {
    return l(n);
  };
}
var cE = dE, zo = { exports: {} };
zo.exports;
(function(l, n) {
  var u = Z4, t = n && !n.nodeType && n, r = t && !0 && l && !l.nodeType && l, o = r && r.exports === t, s = o && u.process, d = function() {
    try {
      var a = r && r.require && r.require("util").types;
      return a || s && s.binding && s.binding("util");
    } catch {
    }
  }();
  l.exports = d;
})(zo, zo.exports);
var fE = zo.exports, pE = sE, gE = cE, Of = fE, Ff = Of && Of.isTypedArray, hE = Ff ? gE(Ff) : pE, mE = hE, vE = jC, bE = fI, yE = wI, $E = EI, xE = RI, CE = _I, wE = H4, IE = mE, EE = "[object Map]", AE = "[object Set]", SE = Object.prototype, PE = SE.hasOwnProperty;
function NE(l) {
  if (l == null)
    return !0;
  if (xE(l) && ($E(l) || typeof l == "string" || typeof l.splice == "function" || CE(l) || IE(l) || yE(l)))
    return !l.length;
  var n = bE(l);
  if (n == EE || n == AE)
    return !l.size;
  if (wE(l))
    return !vE(l).length;
  for (var u in l)
    if (PE.call(l, u))
      return !1;
  return !0;
}
var TE = NE;
const RE = /* @__PURE__ */ ia(TE), Pu = ({ value: l, className: n, ...u }) => RE(l) ? null : /* @__PURE__ */ y.jsxs("p", { className: wl("mt-1.5 flex items-center space-x-1.5", n), ...u, children: [
  /* @__PURE__ */ y.jsx(SC, {}),
  " ",
  /* @__PURE__ */ y.jsx("span", { className: "text-xs text-danger-500", children: Array.isArray(l) ? l.join(", ") : l })
] }), y_ = ({
  id: l,
  className: n,
  label: u,
  errors: t,
  placeholder: r,
  value: o,
  setValue: s,
  helpText: d
}) => {
  const [a, f] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(""), p = (A) => {
    const x = [...o, A].filter(function(I, P, O) {
      return P === O.indexOf(I);
    });
    s(x);
  }, g = (A) => {
    f(A.target.value);
  }, m = (A) => {
    if (A.key == "Backspace" && a == "") {
      const x = [...o];
      s(
        x.filter((I, P) => {
        })
      ), A.preventDefault();
      return;
    }
    if (a && (A.key == "Enter" || A.key == "Tab")) {
      p(a), f(""), A.preventDefault();
      return;
    }
  }, v = (A) => {
    const I = [...o].filter((P, O) => O !== A);
    s(I);
  }, $ = !!(t && t.length > 0), b = l || Math.random().toString();
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    u && /* @__PURE__ */ y.jsx("label", { htmlFor: b, className: "block text-sm font-medium text-gray-700", children: u }),
    /* @__PURE__ */ y.jsxs(
      "div",
      {
        className: wl(
          "flex items-center flex-wrap gap-1 w-full px-3 py-2 rounded shadow-sm relative",
          $ ? "border border-red-300 text-red-900 placeholder-red-300 focus-within:ring-1 focus-within:ring-danger-500 focus-within:border-danger-500 hasErrors" : "border border-gray-300 placeholder-gray-400 focus-within:ring-1 focus-within:ring-primary-500 focus-within:border-primary-500",
          n
        ),
        children: [
          o.map((A, x) => /* @__PURE__ */ y.jsxs(
            "div",
            {
              className: "flex items-center bg-primary-50 text-xs rounded overflow-hidden text-primary-500",
              children: [
                /* @__PURE__ */ y.jsx("span", { className: "inline-block px-1.5", children: A }),
                /* @__PURE__ */ y.jsx(
                  "button",
                  {
                    type: "button",
                    className: "hover:bg-primary-100 font-semibold inline-block h-full p-1 transition-colors duration-200 focus:outline-none",
                    onClick: () => v(x),
                    children: "✕"
                  }
                )
              ]
            },
            x
          )),
          /* @__PURE__ */ y.jsx(
            "input",
            {
              id: b,
              value: a,
              onKeyDown: m,
              onChange: g,
              className: "flex-grow outline-none border-none text-sm shadow-none ring-0",
              placeholder: r
            }
          ),
          $ && /* @__PURE__ */ y.jsx("div", { className: "absolute right-0 pe-3 flex items-center pointer-events-none", children: /* @__PURE__ */ y.jsx(Sc, { className: "h-5 w-5 sm:h-4 sm:w-4 text-danger-400", "aria-hidden": "true" }) })
        ]
      }
    ),
    /* @__PURE__ */ y.jsx(Pu, { value: t ?? [] }),
    d && /* @__PURE__ */ y.jsx("span", { className: "text-xs text-gray-600", children: d })
  ] });
};
function At(l) {
  "@babel/helpers - typeof";
  return At = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(n) {
    return typeof n;
  } : function(n) {
    return n && typeof Symbol == "function" && n.constructor === Symbol && n !== Symbol.prototype ? "symbol" : typeof n;
  }, At(l);
}
function OE(l, n) {
  if (At(l) != "object" || !l) return l;
  var u = l[Symbol.toPrimitive];
  if (u !== void 0) {
    var t = u.call(l, n || "default");
    if (At(t) != "object") return t;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (n === "string" ? String : Number)(l);
}
function lp(l) {
  var n = OE(l, "string");
  return At(n) == "symbol" ? n : n + "";
}
function Kt(l, n, u) {
  return n = lp(n), n in l ? Object.defineProperty(l, n, {
    value: u,
    enumerable: !0,
    configurable: !0,
    writable: !0
  }) : l[n] = u, l;
}
function _f(l, n) {
  var u = Object.keys(l);
  if (Object.getOwnPropertySymbols) {
    var t = Object.getOwnPropertySymbols(l);
    n && (t = t.filter(function(r) {
      return Object.getOwnPropertyDescriptor(l, r).enumerable;
    })), u.push.apply(u, t);
  }
  return u;
}
function yl(l) {
  for (var n = 1; n < arguments.length; n++) {
    var u = arguments[n] != null ? arguments[n] : {};
    n % 2 ? _f(Object(u), !0).forEach(function(t) {
      Kt(l, t, u[t]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(l, Object.getOwnPropertyDescriptors(u)) : _f(Object(u)).forEach(function(t) {
      Object.defineProperty(l, t, Object.getOwnPropertyDescriptor(u, t));
    });
  }
  return l;
}
function FE(l) {
  if (Array.isArray(l)) return l;
}
function _E(l, n) {
  var u = l == null ? null : typeof Symbol < "u" && l[Symbol.iterator] || l["@@iterator"];
  if (u != null) {
    var t, r, o, s, d = [], a = !0, f = !1;
    try {
      if (o = (u = u.call(l)).next, n === 0) {
        if (Object(u) !== u) return;
        a = !1;
      } else for (; !(a = (t = o.call(u)).done) && (d.push(t.value), d.length !== n); a = !0) ;
    } catch (p) {
      f = !0, r = p;
    } finally {
      try {
        if (!a && u.return != null && (s = u.return(), Object(s) !== s)) return;
      } finally {
        if (f) throw r;
      }
    }
    return d;
  }
}
function Gd(l, n) {
  (n == null || n > l.length) && (n = l.length);
  for (var u = 0, t = new Array(n); u < n; u++) t[u] = l[u];
  return t;
}
function np(l, n) {
  if (l) {
    if (typeof l == "string") return Gd(l, n);
    var u = Object.prototype.toString.call(l).slice(8, -1);
    if (u === "Object" && l.constructor && (u = l.constructor.name), u === "Map" || u === "Set") return Array.from(l);
    if (u === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(u)) return Gd(l, n);
  }
}
function DE() {
  throw new TypeError(`Invalid attempt to destructure non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function Hn(l, n) {
  return FE(l) || _E(l, n) || np(l, n) || DE();
}
function ME(l, n) {
  if (l == null) return {};
  var u = {}, t = Object.keys(l), r, o;
  for (o = 0; o < t.length; o++)
    r = t[o], !(n.indexOf(r) >= 0) && (u[r] = l[r]);
  return u;
}
function le(l, n) {
  if (l == null) return {};
  var u = ME(l, n), t, r;
  if (Object.getOwnPropertySymbols) {
    var o = Object.getOwnPropertySymbols(l);
    for (r = 0; r < o.length; r++)
      t = o[r], !(n.indexOf(t) >= 0) && Object.prototype.propertyIsEnumerable.call(l, t) && (u[t] = l[t]);
  }
  return u;
}
var BE = ["defaultInputValue", "defaultMenuIsOpen", "defaultValue", "inputValue", "menuIsOpen", "onChange", "onInputChange", "onMenuClose", "onMenuOpen", "value"];
function Oc(l) {
  var n = l.defaultInputValue, u = n === void 0 ? "" : n, t = l.defaultMenuIsOpen, r = t === void 0 ? !1 : t, o = l.defaultValue, s = o === void 0 ? null : o, d = l.inputValue, a = l.menuIsOpen, f = l.onChange, p = l.onInputChange, g = l.onMenuClose, m = l.onMenuOpen, v = l.value, $ = le(l, BE), b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(d !== void 0 ? d : u), E = Hn(b, 2), S = E[0], A = E[1], x = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(a !== void 0 ? a : r), I = Hn(x, 2), P = I[0], O = I[1], _ = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(v !== void 0 ? v : s), j = Hn(_, 2), z = j[0], Y = j[1], el = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(ll, H) {
    typeof f == "function" && f(ll, H), Y(ll);
  }, [f]), U = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(ll, H) {
    var V;
    typeof p == "function" && (V = p(ll, H)), A(V !== void 0 ? V : ll);
  }, [p]), ul = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function() {
    typeof m == "function" && m(), O(!0);
  }, [m]), il = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function() {
    typeof g == "function" && g(), O(!1);
  }, [g]), rl = d !== void 0 ? d : S, tl = a !== void 0 ? a : P, sl = v !== void 0 ? v : z;
  return yl(yl({}, $), {}, {
    inputValue: rl,
    menuIsOpen: tl,
    onChange: el,
    onInputChange: U,
    onMenuClose: il,
    onMenuOpen: ul,
    value: sl
  });
}
function El() {
  return El = Object.assign ? Object.assign.bind() : function(l) {
    for (var n = 1; n < arguments.length; n++) {
      var u = arguments[n];
      for (var t in u)
        Object.prototype.hasOwnProperty.call(u, t) && (l[t] = u[t]);
    }
    return l;
  }, El.apply(this, arguments);
}
function LE(l, n) {
  if (!(l instanceof n))
    throw new TypeError("Cannot call a class as a function");
}
function Df(l, n) {
  for (var u = 0; u < n.length; u++) {
    var t = n[u];
    t.enumerable = t.enumerable || !1, t.configurable = !0, "value" in t && (t.writable = !0), Object.defineProperty(l, lp(t.key), t);
  }
}
function GE(l, n, u) {
  return n && Df(l.prototype, n), u && Df(l, u), Object.defineProperty(l, "prototype", {
    writable: !1
  }), l;
}
function jd(l, n) {
  return jd = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(t, r) {
    return t.__proto__ = r, t;
  }, jd(l, n);
}
function jE(l, n) {
  if (typeof n != "function" && n !== null)
    throw new TypeError("Super expression must either be null or a function");
  l.prototype = Object.create(n && n.prototype, {
    constructor: {
      value: l,
      writable: !0,
      configurable: !0
    }
  }), Object.defineProperty(l, "prototype", {
    writable: !1
  }), n && jd(l, n);
}
function Yo(l) {
  return Yo = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function(u) {
    return u.__proto__ || Object.getPrototypeOf(u);
  }, Yo(l);
}
function up() {
  try {
    var l = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
  } catch {
  }
  return (up = function() {
    return !!l;
  })();
}
function WE(l) {
  if (l === void 0)
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  return l;
}
function VE(l, n) {
  if (n && (At(n) === "object" || typeof n == "function"))
    return n;
  if (n !== void 0)
    throw new TypeError("Derived constructors may only return object or undefined");
  return WE(l);
}
function kE(l) {
  var n = up();
  return function() {
    var t = Yo(l), r;
    if (n) {
      var o = Yo(this).constructor;
      r = Reflect.construct(t, arguments, o);
    } else
      r = t.apply(this, arguments);
    return VE(this, r);
  };
}
function HE(l) {
  if (Array.isArray(l)) return Gd(l);
}
function ZE(l) {
  if (typeof Symbol < "u" && l[Symbol.iterator] != null || l["@@iterator"] != null) return Array.from(l);
}
function XE() {
  throw new TypeError(`Invalid attempt to spread non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function qt(l) {
  return HE(l) || ZE(l) || np(l) || XE();
}
function zE(l) {
  if (l.sheet)
    return l.sheet;
  for (var n = 0; n < document.styleSheets.length; n++)
    if (document.styleSheets[n].ownerNode === l)
      return document.styleSheets[n];
}
function YE(l) {
  var n = document.createElement("style");
  return n.setAttribute("data-emotion", l.key), l.nonce !== void 0 && n.setAttribute("nonce", l.nonce), n.appendChild(document.createTextNode("")), n.setAttribute("data-s", ""), n;
}
var UE = /* @__PURE__ */ function() {
  function l(u) {
    var t = this;
    this._insertTag = function(r) {
      var o;
      t.tags.length === 0 ? t.insertionPoint ? o = t.insertionPoint.nextSibling : t.prepend ? o = t.container.firstChild : o = t.before : o = t.tags[t.tags.length - 1].nextSibling, t.container.insertBefore(r, o), t.tags.push(r);
    }, this.isSpeedy = u.speedy === void 0 ? "development" === "production" : u.speedy, this.tags = [], this.ctr = 0, this.nonce = u.nonce, this.key = u.key, this.container = u.container, this.prepend = u.prepend, this.insertionPoint = u.insertionPoint, this.before = null;
  }
  var n = l.prototype;
  return n.hydrate = function(t) {
    t.forEach(this._insertTag);
  }, n.insert = function(t) {
    this.ctr % (this.isSpeedy ? 65e3 : 1) === 0 && this._insertTag(YE(this));
    var r = this.tags[this.tags.length - 1];
    if (true) {
      var o = t.charCodeAt(0) === 64 && t.charCodeAt(1) === 105;
      o && this._alreadyInsertedOrderInsensitiveRule && console.error(`You're attempting to insert the following rule:
` + t + "\n\n`@import` rules must be before all other types of rules in a stylesheet but other rules have already been inserted. Please ensure that `@import` rules are before all other rules."), this._alreadyInsertedOrderInsensitiveRule = this._alreadyInsertedOrderInsensitiveRule || !o;
    }
    if (this.isSpeedy) {
      var s = zE(r);
      try {
        s.insertRule(t, s.cssRules.length);
      } catch (d) {
         true && !/:(-moz-placeholder|-moz-focus-inner|-moz-focusring|-ms-input-placeholder|-moz-read-write|-moz-read-only|-ms-clear|-ms-expand|-ms-reveal){/.test(t) && console.error('There was a problem inserting the following rule: "' + t + '"', d);
      }
    } else
      r.appendChild(document.createTextNode(t));
    this.ctr++;
  }, n.flush = function() {
    this.tags.forEach(function(t) {
      return t.parentNode && t.parentNode.removeChild(t);
    }), this.tags = [], this.ctr = 0,  true && (this._alreadyInsertedOrderInsensitiveRule = !1);
  }, l;
}(), lu = "-ms-", Uo = "-moz-", ln = "-webkit-", Fc = "comm", _c = "rule", Dc = "decl", JE = "@import", ep = "@keyframes", KE = "@layer", QE = Math.abs, $a = String.fromCharCode, qE = Object.assign;
function lA(l, n) {
  return Un(l, 0) ^ 45 ? (((n << 2 ^ Un(l, 0)) << 2 ^ Un(l, 1)) << 2 ^ Un(l, 2)) << 2 ^ Un(l, 3) : 0;
}
function tp(l) {
  return l.trim();
}
function nA(l, n) {
  return (l = n.exec(l)) ? l[0] : l;
}
function nn(l, n, u) {
  return l.replace(n, u);
}
function Wd(l, n) {
  return l.indexOf(n);
}
function Un(l, n) {
  return l.charCodeAt(n) | 0;
}
function Kr(l, n, u) {
  return l.slice(n, u);
}
function oe(l) {
  return l.length;
}
function Mc(l) {
  return l.length;
}
function go(l, n) {
  return n.push(l), l;
}
function uA(l, n) {
  return l.map(n).join("");
}
var xa = 1, tr = 1, rp = 0, pu = 0, Bn = 0, gr = "";
function Ca(l, n, u, t, r, o, s) {
  return { value: l, root: n, parent: u, type: t, props: r, children: o, line: xa, column: tr, length: s, return: "" };
}
function Wr(l, n) {
  return qE(Ca("", null, null, "", null, null, 0), l, { length: -l.length }, n);
}
function eA() {
  return Bn;
}
function tA() {
  return Bn = pu > 0 ? Un(gr, --pu) : 0, tr--, Bn === 10 && (tr = 1, xa--), Bn;
}
function Su() {
  return Bn = pu < rp ? Un(gr, pu++) : 0, tr++, Bn === 10 && (tr = 1, xa++), Bn;
}
function se() {
  return Un(gr, pu);
}
function So() {
  return pu;
}
function ii(l, n) {
  return Kr(gr, l, n);
}
function Qr(l) {
  switch (l) {
    case 0:
    case 9:
    case 10:
    case 13:
    case 32:
      return 5;
    case 33:
    case 43:
    case 44:
    case 47:
    case 62:
    case 64:
    case 126:
    case 59:
    case 123:
    case 125:
      return 4;
    case 58:
      return 3;
    case 34:
    case 39:
    case 40:
    case 91:
      return 2;
    case 41:
    case 93:
      return 1;
  }
  return 0;
}
function ip(l) {
  return xa = tr = 1, rp = oe(gr = l), pu = 0, [];
}
function op(l) {
  return gr = "", l;
}
function Po(l) {
  return tp(ii(pu - 1, Vd(l === 91 ? l + 2 : l === 40 ? l + 1 : l)));
}
function rA(l) {
  for (; (Bn = se()) && Bn < 33; )
    Su();
  return Qr(l) > 2 || Qr(Bn) > 3 ? "" : " ";
}
function iA(l, n) {
  for (; --n && Su() && !(Bn < 48 || Bn > 102 || Bn > 57 && Bn < 65 || Bn > 70 && Bn < 97); )
    ;
  return ii(l, So() + (n < 6 && se() == 32 && Su() == 32));
}
function Vd(l) {
  for (; Su(); )
    switch (Bn) {
      case l:
        return pu;
      case 34:
      case 39:
        l !== 34 && l !== 39 && Vd(Bn);
        break;
      case 40:
        l === 41 && Vd(l);
        break;
      case 92:
        Su();
        break;
    }
  return pu;
}
function oA(l, n) {
  for (; Su() && l + Bn !== 57; )
    if (l + Bn === 84 && se() === 47)
      break;
  return "/*" + ii(n, pu - 1) + "*" + $a(l === 47 ? l : Su());
}
function aA(l) {
  for (; !Qr(se()); )
    Su();
  return ii(l, pu);
}
function sA(l) {
  return op(No("", null, null, null, [""], l = ip(l), 0, [0], l));
}
function No(l, n, u, t, r, o, s, d, a) {
  for (var f = 0, p = 0, g = s, m = 0, v = 0, $ = 0, b = 1, E = 1, S = 1, A = 0, x = "", I = r, P = o, O = t, _ = x; E; )
    switch ($ = A, A = Su()) {
      case 40:
        if ($ != 108 && Un(_, g - 1) == 58) {
          Wd(_ += nn(Po(A), "&", "&\f"), "&\f") != -1 && (S = -1);
          break;
        }
      case 34:
      case 39:
      case 91:
        _ += Po(A);
        break;
      case 9:
      case 10:
      case 13:
      case 32:
        _ += rA($);
        break;
      case 92:
        _ += iA(So() - 1, 7);
        continue;
      case 47:
        switch (se()) {
          case 42:
          case 47:
            go(dA(oA(Su(), So()), n, u), a);
            break;
          default:
            _ += "/";
        }
        break;
      case 123 * b:
        d[f++] = oe(_) * S;
      case 125 * b:
      case 59:
      case 0:
        switch (A) {
          case 0:
          case 125:
            E = 0;
          case 59 + p:
            S == -1 && (_ = nn(_, /\f/g, "")), v > 0 && oe(_) - g && go(v > 32 ? Bf(_ + ";", t, u, g - 1) : Bf(nn(_, " ", "") + ";", t, u, g - 2), a);
            break;
          case 59:
            _ += ";";
          default:
            if (go(O = Mf(_, n, u, f, p, r, d, x, I = [], P = [], g), o), A === 123)
              if (p === 0)
                No(_, n, O, O, I, o, g, d, P);
              else
                switch (m === 99 && Un(_, 3) === 110 ? 100 : m) {
                  case 100:
                  case 108:
                  case 109:
                  case 115:
                    No(l, O, O, t && go(Mf(l, O, O, 0, 0, r, d, x, r, I = [], g), P), r, P, g, d, t ? I : P);
                    break;
                  default:
                    No(_, O, O, O, [""], P, 0, d, P);
                }
        }
        f = p = v = 0, b = S = 1, x = _ = "", g = s;
        break;
      case 58:
        g = 1 + oe(_), v = $;
      default:
        if (b < 1) {
          if (A == 123)
            --b;
          else if (A == 125 && b++ == 0 && tA() == 125)
            continue;
        }
        switch (_ += $a(A), A * b) {
          case 38:
            S = p > 0 ? 1 : (_ += "\f", -1);
            break;
          case 44:
            d[f++] = (oe(_) - 1) * S, S = 1;
            break;
          case 64:
            se() === 45 && (_ += Po(Su())), m = se(), p = g = oe(x = _ += aA(So())), A++;
            break;
          case 45:
            $ === 45 && oe(_) == 2 && (b = 0);
        }
    }
  return o;
}
function Mf(l, n, u, t, r, o, s, d, a, f, p) {
  for (var g = r - 1, m = r === 0 ? o : [""], v = Mc(m), $ = 0, b = 0, E = 0; $ < t; ++$)
    for (var S = 0, A = Kr(l, g + 1, g = QE(b = s[$])), x = l; S < v; ++S)
      (x = tp(b > 0 ? m[S] + " " + A : nn(A, /&\f/g, m[S]))) && (a[E++] = x);
  return Ca(l, n, u, r === 0 ? _c : d, a, f, p);
}
function dA(l, n, u) {
  return Ca(l, n, u, Fc, $a(eA()), Kr(l, 2, -2), 0);
}
function Bf(l, n, u, t) {
  return Ca(l, n, u, Dc, Kr(l, 0, t), Kr(l, t + 1, -1), t);
}
function lr(l, n) {
  for (var u = "", t = Mc(l), r = 0; r < t; r++)
    u += n(l[r], r, l, n) || "";
  return u;
}
function cA(l, n, u, t) {
  switch (l.type) {
    case KE:
      if (l.children.length) break;
    case JE:
    case Dc:
      return l.return = l.return || l.value;
    case Fc:
      return "";
    case ep:
      return l.return = l.value + "{" + lr(l.children, t) + "}";
    case _c:
      l.value = l.props.join(",");
  }
  return oe(u = lr(l.children, t)) ? l.return = l.value + "{" + u + "}" : "";
}
function fA(l) {
  var n = Mc(l);
  return function(u, t, r, o) {
    for (var s = "", d = 0; d < n; d++)
      s += l[d](u, t, r, o) || "";
    return s;
  };
}
function pA(l) {
  return function(n) {
    n.root || (n = n.return) && l(n);
  };
}
function gA(l) {
  var n = /* @__PURE__ */ Object.create(null);
  return function(u) {
    return n[u] === void 0 && (n[u] = l(u)), n[u];
  };
}
var hA = function(n, u, t) {
  for (var r = 0, o = 0; r = o, o = se(), r === 38 && o === 12 && (u[t] = 1), !Qr(o); )
    Su();
  return ii(n, pu);
}, mA = function(n, u) {
  var t = -1, r = 44;
  do
    switch (Qr(r)) {
      case 0:
        r === 38 && se() === 12 && (u[t] = 1), n[t] += hA(pu - 1, u, t);
        break;
      case 2:
        n[t] += Po(r);
        break;
      case 4:
        if (r === 44) {
          n[++t] = se() === 58 ? "&\f" : "", u[t] = n[t].length;
          break;
        }
      default:
        n[t] += $a(r);
    }
  while (r = Su());
  return n;
}, vA = function(n, u) {
  return op(mA(ip(n), u));
}, Lf = /* @__PURE__ */ new WeakMap(), bA = function(n) {
  if (!(n.type !== "rule" || !n.parent || // positive .length indicates that this rule contains pseudo
  // negative .length indicates that this rule has been already prefixed
  n.length < 1)) {
    for (var u = n.value, t = n.parent, r = n.column === t.column && n.line === t.line; t.type !== "rule"; )
      if (t = t.parent, !t) return;
    if (!(n.props.length === 1 && u.charCodeAt(0) !== 58 && !Lf.get(t)) && !r) {
      Lf.set(n, !0);
      for (var o = [], s = vA(u, o), d = t.props, a = 0, f = 0; a < s.length; a++)
        for (var p = 0; p < d.length; p++, f++)
          n.props[f] = o[a] ? s[a].replace(/&\f/g, d[p]) : d[p] + " " + s[a];
    }
  }
}, yA = function(n) {
  if (n.type === "decl") {
    var u = n.value;
    // charcode for l
    u.charCodeAt(0) === 108 && // charcode for b
    u.charCodeAt(2) === 98 && (n.return = "", n.value = "");
  }
}, $A = "emotion-disable-server-rendering-unsafe-selector-warning-please-do-not-use-this-the-warning-exists-for-a-reason", xA = function(n) {
  return n.type === "comm" && n.children.indexOf($A) > -1;
}, CA = function(n) {
  return function(u, t, r) {
    if (!(u.type !== "rule" || n.compat)) {
      var o = u.value.match(/(:first|:nth|:nth-last)-child/g);
      if (o) {
        for (var s = !!u.parent, d = s ? u.parent.children : (
          // global rule at the root level
          r
        ), a = d.length - 1; a >= 0; a--) {
          var f = d[a];
          if (f.line < u.line)
            break;
          if (f.column < u.column) {
            if (xA(f))
              return;
            break;
          }
        }
        o.forEach(function(p) {
          console.error('The pseudo class "' + p + '" is potentially unsafe when doing server-side rendering. Try changing it to "' + p.split("-child")[0] + '-of-type".');
        });
      }
    }
  };
}, ap = function(n) {
  return n.type.charCodeAt(1) === 105 && n.type.charCodeAt(0) === 64;
}, wA = function(n, u) {
  for (var t = n - 1; t >= 0; t--)
    if (!ap(u[t]))
      return !0;
  return !1;
}, Gf = function(n) {
  n.type = "", n.value = "", n.return = "", n.children = "", n.props = "";
}, IA = function(n, u, t) {
  ap(n) && (n.parent ? (console.error("`@import` rules can't be nested inside other rules. Please move it to the top level and put it before regular rules. Keep in mind that they can only be used within global styles."), Gf(n)) : wA(u, t) && (console.error("`@import` rules can't be after other rules. Please put your `@import` rules before your other rules."), Gf(n)));
};
function sp(l, n) {
  switch (lA(l, n)) {
    case 5103:
      return ln + "print-" + l + l;
    case 5737:
    case 4201:
    case 3177:
    case 3433:
    case 1641:
    case 4457:
    case 2921:
    case 5572:
    case 6356:
    case 5844:
    case 3191:
    case 6645:
    case 3005:
    case 6391:
    case 5879:
    case 5623:
    case 6135:
    case 4599:
    case 4855:
    case 4215:
    case 6389:
    case 5109:
    case 5365:
    case 5621:
    case 3829:
      return ln + l + l;
    case 5349:
    case 4246:
    case 4810:
    case 6968:
    case 2756:
      return ln + l + Uo + l + lu + l + l;
    case 6828:
    case 4268:
      return ln + l + lu + l + l;
    case 6165:
      return ln + l + lu + "flex-" + l + l;
    case 5187:
      return ln + l + nn(l, /(\w+).+(:[^]+)/, ln + "box-$1$2" + lu + "flex-$1$2") + l;
    case 5443:
      return ln + l + lu + "flex-item-" + nn(l, /flex-|-self/, "") + l;
    case 4675:
      return ln + l + lu + "flex-line-pack" + nn(l, /align-content|flex-|-self/, "") + l;
    case 5548:
      return ln + l + lu + nn(l, "shrink", "negative") + l;
    case 5292:
      return ln + l + lu + nn(l, "basis", "preferred-size") + l;
    case 6060:
      return ln + "box-" + nn(l, "-grow", "") + ln + l + lu + nn(l, "grow", "positive") + l;
    case 4554:
      return ln + nn(l, /([^-])(transform)/g, "$1" + ln + "$2") + l;
    case 6187:
      return nn(nn(nn(l, /(zoom-|grab)/, ln + "$1"), /(image-set)/, ln + "$1"), l, "") + l;
    case 5495:
    case 3959:
      return nn(l, /(image-set\([^]*)/, ln + "$1$`$1");
    case 4968:
      return nn(nn(l, /(.+:)(flex-)?(.*)/, ln + "box-pack:$3" + lu + "flex-pack:$3"), /s.+-b[^;]+/, "justify") + ln + l + l;
    case 4095:
    case 3583:
    case 4068:
    case 2532:
      return nn(l, /(.+)-inline(.+)/, ln + "$1$2") + l;
    case 8116:
    case 7059:
    case 5753:
    case 5535:
    case 5445:
    case 5701:
    case 4933:
    case 4677:
    case 5533:
    case 5789:
    case 5021:
    case 4765:
      if (oe(l) - 1 - n > 6) switch (Un(l, n + 1)) {
        case 109:
          if (Un(l, n + 4) !== 45) break;
        case 102:
          return nn(l, /(.+:)(.+)-([^]+)/, "$1" + ln + "$2-$3$1" + Uo + (Un(l, n + 3) == 108 ? "$3" : "$2-$3")) + l;
        case 115:
          return ~Wd(l, "stretch") ? sp(nn(l, "stretch", "fill-available"), n) + l : l;
      }
      break;
    case 4949:
      if (Un(l, n + 1) !== 115) break;
    case 6444:
      switch (Un(l, oe(l) - 3 - (~Wd(l, "!important") && 10))) {
        case 107:
          return nn(l, ":", ":" + ln) + l;
        case 101:
          return nn(l, /(.+:)([^;!]+)(;|!.+)?/, "$1" + ln + (Un(l, 14) === 45 ? "inline-" : "") + "box$3$1" + ln + "$2$3$1" + lu + "$2box$3") + l;
      }
      break;
    case 5936:
      switch (Un(l, n + 11)) {
        case 114:
          return ln + l + lu + nn(l, /[svh]\w+-[tblr]{2}/, "tb") + l;
        case 108:
          return ln + l + lu + nn(l, /[svh]\w+-[tblr]{2}/, "tb-rl") + l;
        case 45:
          return ln + l + lu + nn(l, /[svh]\w+-[tblr]{2}/, "lr") + l;
      }
      return ln + l + lu + l + l;
  }
  return l;
}
var EA = function(n, u, t, r) {
  if (n.length > -1 && !n.return) switch (n.type) {
    case Dc:
      n.return = sp(n.value, n.length);
      break;
    case ep:
      return lr([Wr(n, {
        value: nn(n.value, "@", "@" + ln)
      })], r);
    case _c:
      if (n.length) return uA(n.props, function(o) {
        switch (nA(o, /(::plac\w+|:read-\w+)/)) {
          case ":read-only":
          case ":read-write":
            return lr([Wr(n, {
              props: [nn(o, /:(read-\w+)/, ":" + Uo + "$1")]
            })], r);
          case "::placeholder":
            return lr([Wr(n, {
              props: [nn(o, /:(plac\w+)/, ":" + ln + "input-$1")]
            }), Wr(n, {
              props: [nn(o, /:(plac\w+)/, ":" + Uo + "$1")]
            }), Wr(n, {
              props: [nn(o, /:(plac\w+)/, lu + "input-$1")]
            })], r);
        }
        return "";
      });
  }
}, AA = [EA], SA = function(n) {
  var u = n.key;
  if ( true && !u)
    throw new Error(`You have to configure \`key\` for your cache. Please make sure it's unique (and not equal to 'css') as it's used for linking styles to your cache.
If multiple caches share the same key they might "fight" for each other's style elements.`);
  if (u === "css") {
    var t = document.querySelectorAll("style[data-emotion]:not([data-s])");
    Array.prototype.forEach.call(t, function(b) {
      var E = b.getAttribute("data-emotion");
      E.indexOf(" ") !== -1 && (document.head.appendChild(b), b.setAttribute("data-s", ""));
    });
  }
  var r = n.stylisPlugins || AA;
  if ( true && /[^a-z-]/.test(u))
    throw new Error('Emotion key must only contain lower case alphabetical characters and - but "' + u + '" was passed');
  var o = {}, s, d = [];
  s = n.container || document.head, Array.prototype.forEach.call(
    // this means we will ignore elements which don't have a space in them which
    // means that the style elements we're looking at are only Emotion 11 server-rendered style elements
    document.querySelectorAll('style[data-emotion^="' + u + ' "]'),
    function(b) {
      for (var E = b.getAttribute("data-emotion").split(" "), S = 1; S < E.length; S++)
        o[E[S]] = !0;
      d.push(b);
    }
  );
  var a, f = [bA, yA];
   true && f.push(CA({
    get compat() {
      return $.compat;
    }
  }), IA);
  {
    var p, g = [cA,  true ? function(b) {
      b.root || (b.return ? p.insert(b.return) : b.value && b.type !== Fc && p.insert(b.value + "{}"));
    } : 0], m = fA(f.concat(r, g)), v = function(E) {
      return lr(sA(E), m);
    };
    a = function(E, S, A, x) {
      p = A,  true && S.map !== void 0 && (p = {
        insert: function(P) {
          A.insert(P + S.map);
        }
      }), v(E ? E + "{" + S.styles + "}" : S.styles), x && ($.inserted[S.name] = !0);
    };
  }
  var $ = {
    key: u,
    sheet: new UE({
      key: u,
      container: s,
      nonce: n.nonce,
      speedy: n.speedy,
      prepend: n.prepend,
      insertionPoint: n.insertionPoint
    }),
    nonce: n.nonce,
    inserted: o,
    registered: {},
    insert: a
  };
  return $.sheet.hydrate(d), $;
}, kd = { exports: {} }, tn = {};
/** @license React v16.13.1
 * react-is.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var jf;
function PA() {
  if (jf) return tn;
  jf = 1;
  var l = typeof Symbol == "function" && Symbol.for, n = l ? Symbol.for("react.element") : 60103, u = l ? Symbol.for("react.portal") : 60106, t = l ? Symbol.for("react.fragment") : 60107, r = l ? Symbol.for("react.strict_mode") : 60108, o = l ? Symbol.for("react.profiler") : 60114, s = l ? Symbol.for("react.provider") : 60109, d = l ? Symbol.for("react.context") : 60110, a = l ? Symbol.for("react.async_mode") : 60111, f = l ? Symbol.for("react.concurrent_mode") : 60111, p = l ? Symbol.for("react.forward_ref") : 60112, g = l ? Symbol.for("react.suspense") : 60113, m = l ? Symbol.for("react.suspense_list") : 60120, v = l ? Symbol.for("react.memo") : 60115, $ = l ? Symbol.for("react.lazy") : 60116, b = l ? Symbol.for("react.block") : 60121, E = l ? Symbol.for("react.fundamental") : 60117, S = l ? Symbol.for("react.responder") : 60118, A = l ? Symbol.for("react.scope") : 60119;
  function x(P) {
    if (typeof P == "object" && P !== null) {
      var O = P.$$typeof;
      switch (O) {
        case n:
          switch (P = P.type, P) {
            case a:
            case f:
            case t:
            case o:
            case r:
            case g:
              return P;
            default:
              switch (P = P && P.$$typeof, P) {
                case d:
                case p:
                case $:
                case v:
                case s:
                  return P;
                default:
                  return O;
              }
          }
        case u:
          return O;
      }
    }
  }
  function I(P) {
    return x(P) === f;
  }
  return tn.AsyncMode = a, tn.ConcurrentMode = f, tn.ContextConsumer = d, tn.ContextProvider = s, tn.Element = n, tn.ForwardRef = p, tn.Fragment = t, tn.Lazy = $, tn.Memo = v, tn.Portal = u, tn.Profiler = o, tn.StrictMode = r, tn.Suspense = g, tn.isAsyncMode = function(P) {
    return I(P) || x(P) === a;
  }, tn.isConcurrentMode = I, tn.isContextConsumer = function(P) {
    return x(P) === d;
  }, tn.isContextProvider = function(P) {
    return x(P) === s;
  }, tn.isElement = function(P) {
    return typeof P == "object" && P !== null && P.$$typeof === n;
  }, tn.isForwardRef = function(P) {
    return x(P) === p;
  }, tn.isFragment = function(P) {
    return x(P) === t;
  }, tn.isLazy = function(P) {
    return x(P) === $;
  }, tn.isMemo = function(P) {
    return x(P) === v;
  }, tn.isPortal = function(P) {
    return x(P) === u;
  }, tn.isProfiler = function(P) {
    return x(P) === o;
  }, tn.isStrictMode = function(P) {
    return x(P) === r;
  }, tn.isSuspense = function(P) {
    return x(P) === g;
  }, tn.isValidElementType = function(P) {
    return typeof P == "string" || typeof P == "function" || P === t || P === f || P === o || P === r || P === g || P === m || typeof P == "object" && P !== null && (P.$$typeof === $ || P.$$typeof === v || P.$$typeof === s || P.$$typeof === d || P.$$typeof === p || P.$$typeof === E || P.$$typeof === S || P.$$typeof === A || P.$$typeof === b);
  }, tn.typeOf = x, tn;
}
var rn = {};
/** @license React v16.13.1
 * react-is.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var Wf;
function NA() {
  return Wf || (Wf = 1,  true && function() {
    var l = typeof Symbol == "function" && Symbol.for, n = l ? Symbol.for("react.element") : 60103, u = l ? Symbol.for("react.portal") : 60106, t = l ? Symbol.for("react.fragment") : 60107, r = l ? Symbol.for("react.strict_mode") : 60108, o = l ? Symbol.for("react.profiler") : 60114, s = l ? Symbol.for("react.provider") : 60109, d = l ? Symbol.for("react.context") : 60110, a = l ? Symbol.for("react.async_mode") : 60111, f = l ? Symbol.for("react.concurrent_mode") : 60111, p = l ? Symbol.for("react.forward_ref") : 60112, g = l ? Symbol.for("react.suspense") : 60113, m = l ? Symbol.for("react.suspense_list") : 60120, v = l ? Symbol.for("react.memo") : 60115, $ = l ? Symbol.for("react.lazy") : 60116, b = l ? Symbol.for("react.block") : 60121, E = l ? Symbol.for("react.fundamental") : 60117, S = l ? Symbol.for("react.responder") : 60118, A = l ? Symbol.for("react.scope") : 60119;
    function x(Q) {
      return typeof Q == "string" || typeof Q == "function" || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
      Q === t || Q === f || Q === o || Q === r || Q === g || Q === m || typeof Q == "object" && Q !== null && (Q.$$typeof === $ || Q.$$typeof === v || Q.$$typeof === s || Q.$$typeof === d || Q.$$typeof === p || Q.$$typeof === E || Q.$$typeof === S || Q.$$typeof === A || Q.$$typeof === b);
    }
    function I(Q) {
      if (typeof Q == "object" && Q !== null) {
        var Xl = Q.$$typeof;
        switch (Xl) {
          case n:
            var Bl = Q.type;
            switch (Bl) {
              case a:
              case f:
              case t:
              case o:
              case r:
              case g:
                return Bl;
              default:
                var Kl = Bl && Bl.$$typeof;
                switch (Kl) {
                  case d:
                  case p:
                  case $:
                  case v:
                  case s:
                    return Kl;
                  default:
                    return Xl;
                }
            }
          case u:
            return Xl;
        }
      }
    }
    var P = a, O = f, _ = d, j = s, z = n, Y = p, el = t, U = $, ul = v, il = u, rl = o, tl = r, sl = g, ll = !1;
    function H(Q) {
      return ll || (ll = !0, console.warn("The ReactIs.isAsyncMode() alias has been deprecated, and will be removed in React 17+. Update your code to use ReactIs.isConcurrentMode() instead. It has the exact same API.")), V(Q) || I(Q) === a;
    }
    function V(Q) {
      return I(Q) === f;
    }
    function X(Q) {
      return I(Q) === d;
    }
    function dl(Q) {
      return I(Q) === s;
    }
    function fl(Q) {
      return typeof Q == "object" && Q !== null && Q.$$typeof === n;
    }
    function $l(Q) {
      return I(Q) === p;
    }
    function cl(Q) {
      return I(Q) === t;
    }
    function xl(Q) {
      return I(Q) === $;
    }
    function ol(Q) {
      return I(Q) === v;
    }
    function ml(Q) {
      return I(Q) === u;
    }
    function Sl(Q) {
      return I(Q) === o;
    }
    function Ol(Q) {
      return I(Q) === r;
    }
    function Cl(Q) {
      return I(Q) === g;
    }
    rn.AsyncMode = P, rn.ConcurrentMode = O, rn.ContextConsumer = _, rn.ContextProvider = j, rn.Element = z, rn.ForwardRef = Y, rn.Fragment = el, rn.Lazy = U, rn.Memo = ul, rn.Portal = il, rn.Profiler = rl, rn.StrictMode = tl, rn.Suspense = sl, rn.isAsyncMode = H, rn.isConcurrentMode = V, rn.isContextConsumer = X, rn.isContextProvider = dl, rn.isElement = fl, rn.isForwardRef = $l, rn.isFragment = cl, rn.isLazy = xl, rn.isMemo = ol, rn.isPortal = ml, rn.isProfiler = Sl, rn.isStrictMode = Ol, rn.isSuspense = Cl, rn.isValidElementType = x, rn.typeOf = I;
  }()), rn;
}
 false ? 0 : kd.exports = NA();
var TA = kd.exports, dp = TA, RA = {
  $$typeof: !0,
  render: !0,
  defaultProps: !0,
  displayName: !0,
  propTypes: !0
}, OA = {
  $$typeof: !0,
  compare: !0,
  defaultProps: !0,
  displayName: !0,
  propTypes: !0,
  type: !0
}, cp = {};
cp[dp.ForwardRef] = RA;
cp[dp.Memo] = OA;
var FA = !0;
function fp(l, n, u) {
  var t = "";
  return u.split(" ").forEach(function(r) {
    l[r] !== void 0 ? n.push(l[r] + ";") : t += r + " ";
  }), t;
}
var Bc = function(n, u, t) {
  var r = n.key + "-" + u.name;
  // we only need to add the styles to the registered cache if the
  // class name could be used further down
  // the tree but if it's a string tag, we know it won't
  // so we don't have to add it to registered cache.
  // this improves memory usage since we can avoid storing the whole style string
  (t === !1 || // we need to always store it if we're in compat mode and
  // in node since emotion-server relies on whether a style is in
  // the registered cache to know whether a style is global or not
  // also, note that this check will be dead code eliminated in the browser
  FA === !1) && n.registered[r] === void 0 && (n.registered[r] = u.styles);
}, Lc = function(n, u, t) {
  Bc(n, u, t);
  var r = n.key + "-" + u.name;
  if (n.inserted[u.name] === void 0) {
    var o = u;
    do
      n.insert(u === o ? "." + r : "", o, n.sheet, !0), o = o.next;
    while (o !== void 0);
  }
};
function _A(l) {
  for (var n = 0, u, t = 0, r = l.length; r >= 4; ++t, r -= 4)
    u = l.charCodeAt(t) & 255 | (l.charCodeAt(++t) & 255) << 8 | (l.charCodeAt(++t) & 255) << 16 | (l.charCodeAt(++t) & 255) << 24, u = /* Math.imul(k, m): */
    (u & 65535) * 1540483477 + ((u >>> 16) * 59797 << 16), u ^= /* k >>> r: */
    u >>> 24, n = /* Math.imul(k, m): */
    (u & 65535) * 1540483477 + ((u >>> 16) * 59797 << 16) ^ /* Math.imul(h, m): */
    (n & 65535) * 1540483477 + ((n >>> 16) * 59797 << 16);
  switch (r) {
    case 3:
      n ^= (l.charCodeAt(t + 2) & 255) << 16;
    case 2:
      n ^= (l.charCodeAt(t + 1) & 255) << 8;
    case 1:
      n ^= l.charCodeAt(t) & 255, n = /* Math.imul(h, m): */
      (n & 65535) * 1540483477 + ((n >>> 16) * 59797 << 16);
  }
  return n ^= n >>> 13, n = /* Math.imul(h, m): */
  (n & 65535) * 1540483477 + ((n >>> 16) * 59797 << 16), ((n ^ n >>> 15) >>> 0).toString(36);
}
var DA = {
  animationIterationCount: 1,
  aspectRatio: 1,
  borderImageOutset: 1,
  borderImageSlice: 1,
  borderImageWidth: 1,
  boxFlex: 1,
  boxFlexGroup: 1,
  boxOrdinalGroup: 1,
  columnCount: 1,
  columns: 1,
  flex: 1,
  flexGrow: 1,
  flexPositive: 1,
  flexShrink: 1,
  flexNegative: 1,
  flexOrder: 1,
  gridRow: 1,
  gridRowEnd: 1,
  gridRowSpan: 1,
  gridRowStart: 1,
  gridColumn: 1,
  gridColumnEnd: 1,
  gridColumnSpan: 1,
  gridColumnStart: 1,
  msGridRow: 1,
  msGridRowSpan: 1,
  msGridColumn: 1,
  msGridColumnSpan: 1,
  fontWeight: 1,
  lineHeight: 1,
  opacity: 1,
  order: 1,
  orphans: 1,
  tabSize: 1,
  widows: 1,
  zIndex: 1,
  zoom: 1,
  WebkitLineClamp: 1,
  // SVG-related properties
  fillOpacity: 1,
  floodOpacity: 1,
  stopOpacity: 1,
  strokeDasharray: 1,
  strokeDashoffset: 1,
  strokeMiterlimit: 1,
  strokeOpacity: 1,
  strokeWidth: 1
}, Vf = `You have illegal escape sequence in your template literal, most likely inside content's property value.
Because you write your CSS inside a JavaScript string you actually have to do double escaping, so for example "content: '\\00d7';" should become "content: '\\\\00d7';".
You can read more about this here:
https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences`, MA = "You have passed in falsy value as style object's key (can happen when in example you pass unexported component as computed key).", BA = /[A-Z]|^ms/g, pp = /_EMO_([^_]+?)_([^]*?)_EMO_/g, Gc = function(n) {
  return n.charCodeAt(1) === 45;
}, kf = function(n) {
  return n != null && typeof n != "boolean";
}, ed = /* @__PURE__ */ gA(function(l) {
  return Gc(l) ? l : l.replace(BA, "-$&").toLowerCase();
}), Jo = function(n, u) {
  switch (n) {
    case "animation":
    case "animationName":
      if (typeof u == "string")
        return u.replace(pp, function(t, r, o) {
          return Qu = {
            name: r,
            styles: o,
            next: Qu
          }, r;
        });
  }
  return DA[n] !== 1 && !Gc(n) && typeof u == "number" && u !== 0 ? u + "px" : u;
};
if (true) {
  var LA = /(var|attr|counters?|url|element|(((repeating-)?(linear|radial))|conic)-gradient)\(|(no-)?(open|close)-quote/, GA = ["normal", "none", "initial", "inherit", "unset"], jA = Jo, WA = /^-ms-/, VA = /-(.)/g, Hf = {};
  Jo = function(n, u) {
    if (n === "content" && (typeof u != "string" || GA.indexOf(u) === -1 && !LA.test(u) && (u.charAt(0) !== u.charAt(u.length - 1) || u.charAt(0) !== '"' && u.charAt(0) !== "'")))
      throw new Error("You seem to be using a value for 'content' without quotes, try replacing it with `content: '\"" + u + "\"'`");
    var t = jA(n, u);
    return t !== "" && !Gc(n) && n.indexOf("-") !== -1 && Hf[n] === void 0 && (Hf[n] = !0, console.error("Using kebab-case for css properties in objects is not supported. Did you mean " + n.replace(WA, "ms-").replace(VA, function(r, o) {
      return o.toUpperCase();
    }) + "?")), t;
  };
}
var gp = "Component selectors can only be used in conjunction with @emotion/babel-plugin, the swc Emotion plugin, or another Emotion-aware compiler transform.";
function qr(l, n, u) {
  if (u == null)
    return "";
  if (u.__emotion_styles !== void 0) {
    if ( true && u.toString() === "NO_COMPONENT_SELECTOR")
      throw new Error(gp);
    return u;
  }
  switch (typeof u) {
    case "boolean":
      return "";
    case "object": {
      if (u.anim === 1)
        return Qu = {
          name: u.name,
          styles: u.styles,
          next: Qu
        }, u.name;
      if (u.styles !== void 0) {
        var t = u.next;
        if (t !== void 0)
          for (; t !== void 0; )
            Qu = {
              name: t.name,
              styles: t.styles,
              next: Qu
            }, t = t.next;
        var r = u.styles + ";";
        return  true && u.map !== void 0 && (r += u.map), r;
      }
      return kA(l, n, u);
    }
    case "function": {
      if (l !== void 0) {
        var o = Qu, s = u(l);
        return Qu = o, qr(l, n, s);
      } else  true && console.error("Functions that are interpolated in css calls will be stringified.\nIf you want to have a css call based on props, create a function that returns a css call like this\nlet dynamicStyle = (props) => css`color: ${props.color}`\nIt can be called directly with props or interpolated in a styled call like this\nlet SomeComponent = styled('div')`${dynamicStyle}`");
      break;
    }
    case "string":
      if (true) {
        var d = [], a = u.replace(pp, function(p, g, m) {
          var v = "animation" + d.length;
          return d.push("const " + v + " = keyframes`" + m.replace(/^@keyframes animation-\w+/, "") + "`"), "${" + v + "}";
        });
        d.length && console.error("`keyframes` output got interpolated into plain string, please wrap it with `css`.\n\nInstead of doing this:\n\n" + [].concat(d, ["`" + a + "`"]).join(`
`) + `

You should wrap it with \`css\` like this:

` + ("css`" + a + "`"));
      }
      break;
  }
  if (n == null)
    return u;
  var f = n[u];
  return f !== void 0 ? f : u;
}
function kA(l, n, u) {
  var t = "";
  if (Array.isArray(u))
    for (var r = 0; r < u.length; r++)
      t += qr(l, n, u[r]) + ";";
  else
    for (var o in u) {
      var s = u[o];
      if (typeof s != "object")
        n != null && n[s] !== void 0 ? t += o + "{" + n[s] + "}" : kf(s) && (t += ed(o) + ":" + Jo(o, s) + ";");
      else {
        if (o === "NO_COMPONENT_SELECTOR" && "development" !== "production")
          throw new Error(gp);
        if (Array.isArray(s) && typeof s[0] == "string" && (n == null || n[s[0]] === void 0))
          for (var d = 0; d < s.length; d++)
            kf(s[d]) && (t += ed(o) + ":" + Jo(o, s[d]) + ";");
        else {
          var a = qr(l, n, s);
          switch (o) {
            case "animation":
            case "animationName": {
              t += ed(o) + ":" + a + ";";
              break;
            }
            default:
               true && o === "undefined" && console.error(MA), t += o + "{" + a + "}";
          }
        }
      }
    }
  return t;
}
var Zf = /label:\s*([^\s;\n{]+)\s*(;|$)/g, hp;
 true && (hp = /\/\*#\ssourceMappingURL=data:application\/json;\S+\s+\*\//g);
var Qu, li = function(n, u, t) {
  if (n.length === 1 && typeof n[0] == "object" && n[0] !== null && n[0].styles !== void 0)
    return n[0];
  var r = !0, o = "";
  Qu = void 0;
  var s = n[0];
  s == null || s.raw === void 0 ? (r = !1, o += qr(t, u, s)) : ( true && s[0] === void 0 && console.error(Vf), o += s[0]);
  for (var d = 1; d < n.length; d++)
    o += qr(t, u, n[d]), r && ( true && s[d] === void 0 && console.error(Vf), o += s[d]);
  var a;
   true && (o = o.replace(hp, function(m) {
    return a = m, "";
  })), Zf.lastIndex = 0;
  for (var f = "", p; (p = Zf.exec(o)) !== null; )
    f += "-" + // $FlowFixMe we know it's not null
    p[1];
  var g = _A(o) + f;
  return  true ? {
    name: g,
    styles: o,
    map: a,
    next: Qu,
    toString: function() {
      return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
    }
  } : 0;
}, HA = function(n) {
  return n();
}, mp = react__WEBPACK_IMPORTED_MODULE_0__.useInsertionEffect ? react__WEBPACK_IMPORTED_MODULE_0__.useInsertionEffect : !1, vp = mp || HA, Xf = mp || react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect, jc = {}.hasOwnProperty, Wc = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createContext(
  // we're doing this to avoid preconstruct's dead code elimination in this one case
  // because this module is primarily intended for the browser and node
  // but it's also required in react native and similar environments sometimes
  // and we could have a special build just for that
  // but this is much easier and the native packages
  // might use a different theme context in the future anyway
  typeof HTMLElement < "u" ? /* @__PURE__ */ SA({
    key: "css"
  }) : null
);
 true && (Wc.displayName = "EmotionCacheContext");
Wc.Provider;
var Vc = function(n) {
  return /* @__PURE__ */ (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function(u, t) {
    var r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(Wc);
    return n(u, r, t);
  });
}, wa = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createContext({});
 true && (wa.displayName = "EmotionThemeContext");
var zf = function(n) {
  var u = n.split(".");
  return u[u.length - 1];
}, ZA = function(n) {
  var u = /^\s+at\s+([A-Za-z0-9$.]+)\s/.exec(n);
  if (u || (u = /^([A-Za-z0-9$.]+)@/.exec(n), u)) return zf(u[1]);
}, XA = /* @__PURE__ */ new Set(["renderWithHooks", "processChild", "finishClassComponent", "renderToString"]), zA = function(n) {
  return n.replace(/\$/g, "-");
}, YA = function(n) {
  if (n)
    for (var u = n.split(`
`), t = 0; t < u.length; t++) {
      var r = ZA(u[t]);
      if (r) {
        if (XA.has(r)) break;
        if (/^[A-Z]/.test(r)) return zA(r);
      }
    }
}, Hd = "__EMOTION_TYPE_PLEASE_DO_NOT_USE__", Zd = "__EMOTION_LABEL_PLEASE_DO_NOT_USE__", UA = function(n, u) {
  if ( true && typeof u.css == "string" && // check if there is a css declaration
  u.css.indexOf(":") !== -1)
    throw new Error("Strings are not allowed as css prop values, please wrap it in a css template literal from '@emotion/react' like this: css`" + u.css + "`");
  var t = {};
  for (var r in u)
    jc.call(u, r) && (t[r] = u[r]);
  if (t[Hd] = n,  true && u.css && (typeof u.css != "object" || typeof u.css.name != "string" || u.css.name.indexOf("-") === -1)) {
    var o = YA(new Error().stack);
    o && (t[Zd] = o);
  }
  return t;
}, JA = function(n) {
  var u = n.cache, t = n.serialized, r = n.isStringTag;
  return Bc(u, t, r), vp(function() {
    return Lc(u, t, r);
  }), null;
}, bp = /* @__PURE__ */ Vc(function(l, n, u) {
  var t = l.css;
  typeof t == "string" && n.registered[t] !== void 0 && (t = n.registered[t]);
  var r = l[Hd], o = [t], s = "";
  typeof l.className == "string" ? s = fp(n.registered, o, l.className) : l.className != null && (s = l.className + " ");
  var d = li(o, void 0, react__WEBPACK_IMPORTED_MODULE_0__.useContext(wa));
  if ( true && d.name.indexOf("-") === -1) {
    var a = l[Zd];
    a && (d = li([d, "label:" + a + ";"]));
  }
  s += n.key + "-" + d.name;
  var f = {};
  for (var p in l)
    jc.call(l, p) && p !== "css" && p !== Hd && ( false || p !== Zd) && (f[p] = l[p]);
  return f.ref = u, f.className = s, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(JA, {
    cache: n,
    serialized: d,
    isStringTag: typeof r == "string"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(r, f));
});
 true && (bp.displayName = "EmotionCssPropInternal");
var KA = bp, QA = {
  name: "@emotion/react",
  version: "11.11.4",
  main: "dist/emotion-react.cjs.js",
  module: "dist/emotion-react.esm.js",
  browser: {
    "./dist/emotion-react.esm.js": "./dist/emotion-react.browser.esm.js"
  },
  exports: {
    ".": {
      module: {
        worker: "./dist/emotion-react.worker.esm.js",
        browser: "./dist/emotion-react.browser.esm.js",
        default: "./dist/emotion-react.esm.js"
      },
      import: "./dist/emotion-react.cjs.mjs",
      default: "./dist/emotion-react.cjs.js"
    },
    "./jsx-runtime": {
      module: {
        worker: "./jsx-runtime/dist/emotion-react-jsx-runtime.worker.esm.js",
        browser: "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.esm.js",
        default: "./jsx-runtime/dist/emotion-react-jsx-runtime.esm.js"
      },
      import: "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.mjs",
      default: "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.js"
    },
    "./_isolated-hnrs": {
      module: {
        worker: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.worker.esm.js",
        browser: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.esm.js",
        default: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.esm.js"
      },
      import: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.mjs",
      default: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.js"
    },
    "./jsx-dev-runtime": {
      module: {
        worker: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.worker.esm.js",
        browser: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.esm.js",
        default: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.esm.js"
      },
      import: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.mjs",
      default: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.js"
    },
    "./package.json": "./package.json",
    "./types/css-prop": "./types/css-prop.d.ts",
    "./macro": {
      types: {
        import: "./macro.d.mts",
        default: "./macro.d.ts"
      },
      default: "./macro.js"
    }
  },
  types: "types/index.d.ts",
  files: [
    "src",
    "dist",
    "jsx-runtime",
    "jsx-dev-runtime",
    "_isolated-hnrs",
    "types/*.d.ts",
    "macro.*"
  ],
  sideEffects: !1,
  author: "Emotion Contributors",
  license: "MIT",
  scripts: {
    "test:typescript": "dtslint types"
  },
  dependencies: {
    "@babel/runtime": "^7.18.3",
    "@emotion/babel-plugin": "^11.11.0",
    "@emotion/cache": "^11.11.0",
    "@emotion/serialize": "^1.1.3",
    "@emotion/use-insertion-effect-with-fallbacks": "^1.0.1",
    "@emotion/utils": "^1.2.1",
    "@emotion/weak-memoize": "^0.3.1",
    "hoist-non-react-statics": "^3.3.1"
  },
  peerDependencies: {
    react: ">=16.8.0"
  },
  peerDependenciesMeta: {
    "@types/react": {
      optional: !0
    }
  },
  devDependencies: {
    "@definitelytyped/dtslint": "0.0.112",
    "@emotion/css": "11.11.2",
    "@emotion/css-prettifier": "1.1.3",
    "@emotion/server": "11.11.0",
    "@emotion/styled": "11.11.0",
    "html-tag-names": "^1.1.2",
    react: "16.14.0",
    "svg-tag-names": "^1.1.1",
    typescript: "^4.5.5"
  },
  repository: "https://github.com/emotion-js/emotion/tree/main/packages/react",
  publishConfig: {
    access: "public"
  },
  "umd:main": "dist/emotion-react.umd.min.js",
  preconstruct: {
    entrypoints: [
      "./index.js",
      "./jsx-runtime.js",
      "./jsx-dev-runtime.js",
      "./_isolated-hnrs.js"
    ],
    umdName: "emotionReact",
    exports: {
      envConditions: [
        "browser",
        "worker"
      ],
      extra: {
        "./types/css-prop": "./types/css-prop.d.ts",
        "./macro": {
          types: {
            import: "./macro.d.mts",
            default: "./macro.d.ts"
          },
          default: "./macro.js"
        }
      }
    }
  }
}, Il = function(n, u) {
  var t = arguments;
  if (u == null || !jc.call(u, "css"))
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement.apply(void 0, t);
  var r = t.length, o = new Array(r);
  o[0] = KA, o[1] = UA(n, u);
  for (var s = 2; s < r; s++)
    o[s] = t[s];
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement.apply(null, o);
}, Yf = !1, qA = /* @__PURE__ */ Vc(function(l, n) {
   true && !Yf && // check for className as well since the user is
  // probably using the custom createElement which
  // means it will be turned into a className prop
  // $FlowFixMe I don't really want to add it to the type since it shouldn't be used
  (l.className || l.css) && (console.error("It looks like you're using the css prop on Global, did you mean to use the styles prop instead?"), Yf = !0);
  var u = l.styles, t = li([u], void 0, react__WEBPACK_IMPORTED_MODULE_0__.useContext(wa)), r = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  return Xf(function() {
    var o = n.key + "-global", s = new n.sheet.constructor({
      key: o,
      nonce: n.sheet.nonce,
      container: n.sheet.container,
      speedy: n.sheet.isSpeedy
    }), d = !1, a = document.querySelector('style[data-emotion="' + o + " " + t.name + '"]');
    return n.sheet.tags.length && (s.before = n.sheet.tags[0]), a !== null && (d = !0, a.setAttribute("data-emotion", o), s.hydrate([a])), r.current = [s, d], function() {
      s.flush();
    };
  }, [n]), Xf(function() {
    var o = r.current, s = o[0], d = o[1];
    if (d) {
      o[1] = !1;
      return;
    }
    if (t.next !== void 0 && Lc(n, t.next, !0), s.tags.length) {
      var a = s.tags[s.tags.length - 1].nextElementSibling;
      s.before = a, s.flush();
    }
    n.insert("", t, s, !1);
  }, [n, t.name]), null;
});
 true && (qA.displayName = "EmotionGlobal");
function kc() {
  for (var l = arguments.length, n = new Array(l), u = 0; u < l; u++)
    n[u] = arguments[u];
  return li(n);
}
var lS = function() {
  var n = kc.apply(void 0, arguments), u = "animation-" + n.name;
  return {
    name: u,
    styles: "@keyframes " + u + "{" + n.styles + "}",
    anim: 1,
    toString: function() {
      return "_EMO_" + this.name + "_" + this.styles + "_EMO_";
    }
  };
}, nS = function l(n) {
  for (var u = n.length, t = 0, r = ""; t < u; t++) {
    var o = n[t];
    if (o != null) {
      var s = void 0;
      switch (typeof o) {
        case "boolean":
          break;
        case "object": {
          if (Array.isArray(o))
            s = l(o);
          else {
             true && o.styles !== void 0 && o.name !== void 0 && console.error("You have passed styles created with `css` from `@emotion/react` package to the `cx`.\n`cx` is meant to compose class names (strings) so you should convert those styles to a class name by passing them to the `css` received from <ClassNames/> component."), s = "";
            for (var d in o)
              o[d] && d && (s && (s += " "), s += d);
          }
          break;
        }
        default:
          s = o;
      }
      s && (r && (r += " "), r += s);
    }
  }
  return r;
};
function uS(l, n, u) {
  var t = [], r = fp(l, t, u);
  return t.length < 2 ? u : r + n(t);
}
var eS = function(n) {
  var u = n.cache, t = n.serializedArr;
  return vp(function() {
    for (var r = 0; r < t.length; r++)
      Lc(u, t[r], !1);
  }), null;
}, tS = /* @__PURE__ */ Vc(function(l, n) {
  var u = !1, t = [], r = function() {
    if (u && "development" !== "production")
      throw new Error("css can only be used during render");
    for (var f = arguments.length, p = new Array(f), g = 0; g < f; g++)
      p[g] = arguments[g];
    var m = li(p, n.registered);
    return t.push(m), Bc(n, m, !1), n.key + "-" + m.name;
  }, o = function() {
    if (u && "development" !== "production")
      throw new Error("cx can only be used during render");
    for (var f = arguments.length, p = new Array(f), g = 0; g < f; g++)
      p[g] = arguments[g];
    return uS(n.registered, r, nS(p));
  }, s = {
    css: r,
    cx: o,
    theme: react__WEBPACK_IMPORTED_MODULE_0__.useContext(wa)
  }, d = l.children(s);
  return u = !0, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(eS, {
    cache: n,
    serializedArr: t
  }), d);
});
 true && (tS.displayName = "EmotionClassNames");
if (true) {
  var Uf = !0, rS = typeof jest < "u" || typeof vi < "u";
  if (Uf && !rS) {
    var Jf = (
      // $FlowIgnore
      typeof globalThis < "u" ? globalThis : Uf ? window : global
    ), Kf = "__EMOTION_REACT_" + QA.version.split(".")[0] + "__";
    Jf[Kf] && console.warn("You are loading @emotion/react when it is already loaded. Running multiple instances may cause problems. This can happen if multiple versions are used, or if multiple builds of the same version are used."), Jf[Kf] = !0;
  }
}
function iS(l, n) {
  return n || (n = l.slice(0)), Object.freeze(Object.defineProperties(l, {
    raw: {
      value: Object.freeze(n)
    }
  }));
}
var Xd = react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect, oS = ["className", "clearValue", "cx", "getStyles", "getClassNames", "getValue", "hasValue", "isMulti", "isRtl", "options", "selectOption", "selectProps", "setValue", "theme"], Ko = function() {
};
function aS(l, n) {
  return n ? n[0] === "-" ? l + n : l + "__" + n : l;
}
function sS(l, n) {
  for (var u = arguments.length, t = new Array(u > 2 ? u - 2 : 0), r = 2; r < u; r++)
    t[r - 2] = arguments[r];
  var o = [].concat(t);
  if (n && l)
    for (var s in n)
      n.hasOwnProperty(s) && n[s] && o.push("".concat(aS(l, s)));
  return o.filter(function(d) {
    return d;
  }).map(function(d) {
    return String(d).trim();
  }).join(" ");
}
var Qo = function(n) {
  return yS(n) ? n.filter(Boolean) : At(n) === "object" && n !== null ? [n] : [];
}, yp = function(n) {
  n.className, n.clearValue, n.cx, n.getStyles, n.getClassNames, n.getValue, n.hasValue, n.isMulti, n.isRtl, n.options, n.selectOption, n.selectProps, n.setValue, n.theme;
  var u = le(n, oS);
  return yl({}, u);
}, Nn = function(n, u, t) {
  var r = n.cx, o = n.getStyles, s = n.getClassNames, d = n.className;
  return {
    css: o(u, n),
    className: r(t ?? {}, s(u, n), d)
  };
};
function dS(l, n, u) {
  if (u) {
    var t = u(l, n);
    if (typeof t == "string") return t;
  }
  return l;
}
function Ia(l) {
  return [document.documentElement, document.body, window].indexOf(l) > -1;
}
function cS(l) {
  return Ia(l) ? window.innerHeight : l.clientHeight;
}
function $p(l) {
  return Ia(l) ? window.pageYOffset : l.scrollTop;
}
function qo(l, n) {
  if (Ia(l)) {
    window.scrollTo(0, n);
    return;
  }
  l.scrollTop = n;
}
function fS(l) {
  var n = getComputedStyle(l), u = n.position === "absolute", t = /(auto|scroll)/;
  if (n.position === "fixed") return document.documentElement;
  for (var r = l; r = r.parentElement; )
    if (n = getComputedStyle(r), !(u && n.position === "static") && t.test(n.overflow + n.overflowY + n.overflowX))
      return r;
  return document.documentElement;
}
function pS(l, n, u, t) {
  return u * ((l = l / t - 1) * l * l + 1) + n;
}
function ho(l, n) {
  var u = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : 200, t = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : Ko, r = $p(l), o = n - r, s = 10, d = 0;
  function a() {
    d += s;
    var f = pS(d, r, o, u);
    qo(l, f), d < u ? window.requestAnimationFrame(a) : t(l);
  }
  a();
}
function Qf(l, n) {
  var u = l.getBoundingClientRect(), t = n.getBoundingClientRect(), r = n.offsetHeight / 3;
  t.bottom + r > u.bottom ? qo(l, Math.min(n.offsetTop + n.clientHeight - l.offsetHeight + r, l.scrollHeight)) : t.top - r < u.top && qo(l, Math.max(n.offsetTop - r, 0));
}
function gS(l) {
  var n = l.getBoundingClientRect();
  return {
    bottom: n.bottom,
    height: n.height,
    left: n.left,
    right: n.right,
    top: n.top,
    width: n.width
  };
}
function qf() {
  try {
    return document.createEvent("TouchEvent"), !0;
  } catch {
    return !1;
  }
}
function hS() {
  try {
    return /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
  } catch {
    return !1;
  }
}
var xp = !1, mS = {
  get passive() {
    return xp = !0;
  }
}, mo = typeof window < "u" ? window : {};
mo.addEventListener && mo.removeEventListener && (mo.addEventListener("p", Ko, mS), mo.removeEventListener("p", Ko, !1));
var vS = xp;
function bS(l) {
  return l != null;
}
function yS(l) {
  return Array.isArray(l);
}
function Hr(l, n, u) {
  return l ? n : u;
}
var $S = function(n) {
  for (var u = arguments.length, t = new Array(u > 1 ? u - 1 : 0), r = 1; r < u; r++)
    t[r - 1] = arguments[r];
  var o = Object.entries(n).filter(function(s) {
    var d = Hn(s, 1), a = d[0];
    return !t.includes(a);
  });
  return o.reduce(function(s, d) {
    var a = Hn(d, 2), f = a[0], p = a[1];
    return s[f] = p, s;
  }, {});
}, xS = ["children", "innerProps"], CS = ["children", "innerProps"];
function wS(l) {
  var n = l.maxHeight, u = l.menuEl, t = l.minHeight, r = l.placement, o = l.shouldScroll, s = l.isFixedPosition, d = l.controlHeight, a = fS(u), f = {
    placement: "bottom",
    maxHeight: n
  };
  if (!u || !u.offsetParent) return f;
  var p = a.getBoundingClientRect(), g = p.height, m = u.getBoundingClientRect(), v = m.bottom, $ = m.height, b = m.top, E = u.offsetParent.getBoundingClientRect(), S = E.top, A = s ? window.innerHeight : cS(a), x = $p(a), I = parseInt(getComputedStyle(u).marginBottom, 10), P = parseInt(getComputedStyle(u).marginTop, 10), O = S - P, _ = A - b, j = O + x, z = g - x - b, Y = v - A + x + I, el = x + b - P, U = 160;
  switch (r) {
    case "auto":
    case "bottom":
      if (_ >= $)
        return {
          placement: "bottom",
          maxHeight: n
        };
      if (z >= $ && !s)
        return o && ho(a, Y, U), {
          placement: "bottom",
          maxHeight: n
        };
      if (!s && z >= t || s && _ >= t) {
        o && ho(a, Y, U);
        var ul = s ? _ - I : z - I;
        return {
          placement: "bottom",
          maxHeight: ul
        };
      }
      if (r === "auto" || s) {
        var il = n, rl = s ? O : j;
        return rl >= t && (il = Math.min(rl - I - d, n)), {
          placement: "top",
          maxHeight: il
        };
      }
      if (r === "bottom")
        return o && qo(a, Y), {
          placement: "bottom",
          maxHeight: n
        };
      break;
    case "top":
      if (O >= $)
        return {
          placement: "top",
          maxHeight: n
        };
      if (j >= $ && !s)
        return o && ho(a, el, U), {
          placement: "top",
          maxHeight: n
        };
      if (!s && j >= t || s && O >= t) {
        var tl = n;
        return (!s && j >= t || s && O >= t) && (tl = s ? O - P : j - P), o && ho(a, el, U), {
          placement: "top",
          maxHeight: tl
        };
      }
      return {
        placement: "bottom",
        maxHeight: n
      };
    default:
      throw new Error('Invalid placement provided "'.concat(r, '".'));
  }
  return f;
}
function IS(l) {
  var n = {
    bottom: "top",
    top: "bottom"
  };
  return l ? n[l] : "bottom";
}
var Cp = function(n) {
  return n === "auto" ? "bottom" : n;
}, ES = function(n, u) {
  var t, r = n.placement, o = n.theme, s = o.borderRadius, d = o.spacing, a = o.colors;
  return yl((t = {
    label: "menu"
  }, Kt(t, IS(r), "100%"), Kt(t, "position", "absolute"), Kt(t, "width", "100%"), Kt(t, "zIndex", 1), t), u ? {} : {
    backgroundColor: a.neutral0,
    borderRadius: s,
    boxShadow: "0 0 0 1px hsla(0, 0%, 0%, 0.1), 0 4px 11px hsla(0, 0%, 0%, 0.1)",
    marginBottom: d.menuGutter,
    marginTop: d.menuGutter
  });
}, wp = /* @__PURE__ */ (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null), AS = function(n) {
  var u = n.children, t = n.minMenuHeight, r = n.maxMenuHeight, o = n.menuPlacement, s = n.menuPosition, d = n.menuShouldScrollIntoView, a = n.theme, f = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(wp) || {}, p = f.setPortalPlacement, g = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), m = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(r), v = Hn(m, 2), $ = v[0], b = v[1], E = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null), S = Hn(E, 2), A = S[0], x = S[1], I = a.spacing.controlHeight;
  return Xd(function() {
    var P = g.current;
    if (P) {
      var O = s === "fixed", _ = d && !O, j = wS({
        maxHeight: r,
        menuEl: P,
        minHeight: t,
        placement: o,
        shouldScroll: _,
        isFixedPosition: O,
        controlHeight: I
      });
      b(j.maxHeight), x(j.placement), p == null || p(j.placement);
    }
  }, [r, o, s, d, t, p, I]), u({
    ref: g,
    placerProps: yl(yl({}, n), {}, {
      placement: A || Cp(o),
      maxHeight: $
    })
  });
}, SS = function(n) {
  var u = n.children, t = n.innerRef, r = n.innerProps;
  return Il("div", El({}, Nn(n, "menu", {
    menu: !0
  }), {
    ref: t
  }, r), u);
}, PS = SS, NS = function(n, u) {
  var t = n.maxHeight, r = n.theme.spacing.baseUnit;
  return yl({
    maxHeight: t,
    overflowY: "auto",
    position: "relative",
    // required for offset[Height, Top] > keyboard scroll
    WebkitOverflowScrolling: "touch"
  }, u ? {} : {
    paddingBottom: r,
    paddingTop: r
  });
}, TS = function(n) {
  var u = n.children, t = n.innerProps, r = n.innerRef, o = n.isMulti;
  return Il("div", El({}, Nn(n, "menuList", {
    "menu-list": !0,
    "menu-list--is-multi": o
  }), {
    ref: r
  }, t), u);
}, Ip = function(n, u) {
  var t = n.theme, r = t.spacing.baseUnit, o = t.colors;
  return yl({
    textAlign: "center"
  }, u ? {} : {
    color: o.neutral40,
    padding: "".concat(r * 2, "px ").concat(r * 3, "px")
  });
}, RS = Ip, OS = Ip, FS = function(n) {
  var u = n.children, t = u === void 0 ? "No options" : u, r = n.innerProps, o = le(n, xS);
  return Il("div", El({}, Nn(yl(yl({}, o), {}, {
    children: t,
    innerProps: r
  }), "noOptionsMessage", {
    "menu-notice": !0,
    "menu-notice--no-options": !0
  }), r), t);
}, _S = function(n) {
  var u = n.children, t = u === void 0 ? "Loading..." : u, r = n.innerProps, o = le(n, CS);
  return Il("div", El({}, Nn(yl(yl({}, o), {}, {
    children: t,
    innerProps: r
  }), "loadingMessage", {
    "menu-notice": !0,
    "menu-notice--loading": !0
  }), r), t);
}, DS = function(n) {
  var u = n.rect, t = n.offset, r = n.position;
  return {
    left: u.left,
    position: r,
    top: t,
    width: u.width,
    zIndex: 1
  };
}, MS = function(n) {
  var u = n.appendTo, t = n.children, r = n.controlElement, o = n.innerProps, s = n.menuPlacement, d = n.menuPosition, a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), f = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(Cp(s)), g = Hn(p, 2), m = g[0], v = g[1], $ = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    return {
      setPortalPlacement: v
    };
  }, []), b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null), E = Hn(b, 2), S = E[0], A = E[1], x = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function() {
    if (r) {
      var _ = gS(r), j = d === "fixed" ? 0 : window.pageYOffset, z = _[m] + j;
      (z !== (S == null ? void 0 : S.offset) || _.left !== (S == null ? void 0 : S.rect.left) || _.width !== (S == null ? void 0 : S.rect.width)) && A({
        offset: z,
        rect: _
      });
    }
  }, [r, d, m, S == null ? void 0 : S.offset, S == null ? void 0 : S.rect.left, S == null ? void 0 : S.rect.width]);
  Xd(function() {
    x();
  }, [x]);
  var I = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function() {
    typeof f.current == "function" && (f.current(), f.current = null), r && a.current && (f.current = Cc(r, a.current, x, {
      elementResize: "ResizeObserver" in window
    }));
  }, [r, x]);
  Xd(function() {
    I();
  }, [I]);
  var P = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(_) {
    a.current = _, I();
  }, [I]);
  if (!u && d !== "fixed" || !S) return null;
  var O = Il("div", El({
    ref: P
  }, Nn(yl(yl({}, n), {}, {
    offset: S.offset,
    position: d,
    rect: S.rect
  }), "menuPortal", {
    "menu-portal": !0
  }), o), t);
  return Il(wp.Provider, {
    value: $
  }, u ? /* @__PURE__ */ (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal)(O, u) : O);
}, BS = function(n) {
  var u = n.isDisabled, t = n.isRtl;
  return {
    label: "container",
    direction: t ? "rtl" : void 0,
    pointerEvents: u ? "none" : void 0,
    // cancel mouse events when disabled
    position: "relative"
  };
}, LS = function(n) {
  var u = n.children, t = n.innerProps, r = n.isDisabled, o = n.isRtl;
  return Il("div", El({}, Nn(n, "container", {
    "--is-disabled": r,
    "--is-rtl": o
  }), t), u);
}, GS = function(n, u) {
  var t = n.theme.spacing, r = n.isMulti, o = n.hasValue, s = n.selectProps.controlShouldRenderValue;
  return yl({
    alignItems: "center",
    display: r && o && s ? "flex" : "grid",
    flex: 1,
    flexWrap: "wrap",
    WebkitOverflowScrolling: "touch",
    position: "relative",
    overflow: "hidden"
  }, u ? {} : {
    padding: "".concat(t.baseUnit / 2, "px ").concat(t.baseUnit * 2, "px")
  });
}, jS = function(n) {
  var u = n.children, t = n.innerProps, r = n.isMulti, o = n.hasValue;
  return Il("div", El({}, Nn(n, "valueContainer", {
    "value-container": !0,
    "value-container--is-multi": r,
    "value-container--has-value": o
  }), t), u);
}, WS = function() {
  return {
    alignItems: "center",
    alignSelf: "stretch",
    display: "flex",
    flexShrink: 0
  };
}, VS = function(n) {
  var u = n.children, t = n.innerProps;
  return Il("div", El({}, Nn(n, "indicatorsContainer", {
    indicators: !0
  }), t), u);
}, l3, kS = ["size"], HS = ["innerProps", "isRtl", "size"];
function ZS() {
  return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
}
var XS =  false ? 0 : {
  name: "tj5bde-Svg",
  styles: "display:inline-block;fill:currentColor;line-height:1;stroke:currentColor;stroke-width:0;label:Svg;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: ZS
}, Ep = function(n) {
  var u = n.size, t = le(n, kS);
  return Il("svg", El({
    height: u,
    width: u,
    viewBox: "0 0 20 20",
    "aria-hidden": "true",
    focusable: "false",
    css: XS
  }, t));
}, Hc = function(n) {
  return Il(Ep, El({
    size: 20
  }, n), Il("path", {
    d: "M14.348 14.849c-0.469 0.469-1.229 0.469-1.697 0l-2.651-3.030-2.651 3.029c-0.469 0.469-1.229 0.469-1.697 0-0.469-0.469-0.469-1.229 0-1.697l2.758-3.15-2.759-3.152c-0.469-0.469-0.469-1.228 0-1.697s1.228-0.469 1.697 0l2.652 3.031 2.651-3.031c0.469-0.469 1.228-0.469 1.697 0s0.469 1.229 0 1.697l-2.758 3.152 2.758 3.15c0.469 0.469 0.469 1.229 0 1.698z"
  }));
}, Ap = function(n) {
  return Il(Ep, El({
    size: 20
  }, n), Il("path", {
    d: "M4.516 7.548c0.436-0.446 1.043-0.481 1.576 0l3.908 3.747 3.908-3.747c0.533-0.481 1.141-0.446 1.574 0 0.436 0.445 0.408 1.197 0 1.615-0.406 0.418-4.695 4.502-4.695 4.502-0.217 0.223-0.502 0.335-0.787 0.335s-0.57-0.112-0.789-0.335c0 0-4.287-4.084-4.695-4.502s-0.436-1.17 0-1.615z"
  }));
}, Sp = function(n, u) {
  var t = n.isFocused, r = n.theme, o = r.spacing.baseUnit, s = r.colors;
  return yl({
    label: "indicatorContainer",
    display: "flex",
    transition: "color 150ms"
  }, u ? {} : {
    color: t ? s.neutral60 : s.neutral20,
    padding: o * 2,
    ":hover": {
      color: t ? s.neutral80 : s.neutral40
    }
  });
}, zS = Sp, YS = function(n) {
  var u = n.children, t = n.innerProps;
  return Il("div", El({}, Nn(n, "dropdownIndicator", {
    indicator: !0,
    "dropdown-indicator": !0
  }), t), u || Il(Ap, null));
}, US = Sp, JS = function(n) {
  var u = n.children, t = n.innerProps;
  return Il("div", El({}, Nn(n, "clearIndicator", {
    indicator: !0,
    "clear-indicator": !0
  }), t), u || Il(Hc, null));
}, KS = function(n, u) {
  var t = n.isDisabled, r = n.theme, o = r.spacing.baseUnit, s = r.colors;
  return yl({
    label: "indicatorSeparator",
    alignSelf: "stretch",
    width: 1
  }, u ? {} : {
    backgroundColor: t ? s.neutral10 : s.neutral20,
    marginBottom: o * 2,
    marginTop: o * 2
  });
}, QS = function(n) {
  var u = n.innerProps;
  return Il("span", El({}, u, Nn(n, "indicatorSeparator", {
    "indicator-separator": !0
  })));
}, qS = lS(l3 || (l3 = iS([`
  0%, 80%, 100% { opacity: 0; }
  40% { opacity: 1; }
`]))), lP = function(n, u) {
  var t = n.isFocused, r = n.size, o = n.theme, s = o.colors, d = o.spacing.baseUnit;
  return yl({
    label: "loadingIndicator",
    display: "flex",
    transition: "color 150ms",
    alignSelf: "center",
    fontSize: r,
    lineHeight: 1,
    marginRight: r,
    textAlign: "center",
    verticalAlign: "middle"
  }, u ? {} : {
    color: t ? s.neutral60 : s.neutral20,
    padding: d * 2
  });
}, td = function(n) {
  var u = n.delay, t = n.offset;
  return Il("span", {
    css: /* @__PURE__ */ kc({
      animation: "".concat(qS, " 1s ease-in-out ").concat(u, "ms infinite;"),
      backgroundColor: "currentColor",
      borderRadius: "1em",
      display: "inline-block",
      marginLeft: t ? "1em" : void 0,
      height: "1em",
      verticalAlign: "top",
      width: "1em"
    },  false ? 0 : ";label:LoadingDot;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */")
  });
}, nP = function(n) {
  var u = n.innerProps, t = n.isRtl, r = n.size, o = r === void 0 ? 4 : r, s = le(n, HS);
  return Il("div", El({}, Nn(yl(yl({}, s), {}, {
    innerProps: u,
    isRtl: t,
    size: o
  }), "loadingIndicator", {
    indicator: !0,
    "loading-indicator": !0
  }), u), Il(td, {
    delay: 0,
    offset: t
  }), Il(td, {
    delay: 160,
    offset: !0
  }), Il(td, {
    delay: 320,
    offset: !t
  }));
}, uP = function(n, u) {
  var t = n.isDisabled, r = n.isFocused, o = n.theme, s = o.colors, d = o.borderRadius, a = o.spacing;
  return yl({
    label: "control",
    alignItems: "center",
    cursor: "default",
    display: "flex",
    flexWrap: "wrap",
    justifyContent: "space-between",
    minHeight: a.controlHeight,
    outline: "0 !important",
    position: "relative",
    transition: "all 100ms"
  }, u ? {} : {
    backgroundColor: t ? s.neutral5 : s.neutral0,
    borderColor: t ? s.neutral10 : r ? s.primary : s.neutral20,
    borderRadius: d,
    borderStyle: "solid",
    borderWidth: 1,
    boxShadow: r ? "0 0 0 1px ".concat(s.primary) : void 0,
    "&:hover": {
      borderColor: r ? s.primary : s.neutral30
    }
  });
}, eP = function(n) {
  var u = n.children, t = n.isDisabled, r = n.isFocused, o = n.innerRef, s = n.innerProps, d = n.menuIsOpen;
  return Il("div", El({
    ref: o
  }, Nn(n, "control", {
    control: !0,
    "control--is-disabled": t,
    "control--is-focused": r,
    "control--menu-is-open": d
  }), s, {
    "aria-disabled": t || void 0
  }), u);
}, tP = eP, rP = ["data"], iP = function(n, u) {
  var t = n.theme.spacing;
  return u ? {} : {
    paddingBottom: t.baseUnit * 2,
    paddingTop: t.baseUnit * 2
  };
}, oP = function(n) {
  var u = n.children, t = n.cx, r = n.getStyles, o = n.getClassNames, s = n.Heading, d = n.headingProps, a = n.innerProps, f = n.label, p = n.theme, g = n.selectProps;
  return Il("div", El({}, Nn(n, "group", {
    group: !0
  }), a), Il(s, El({}, d, {
    selectProps: g,
    theme: p,
    getStyles: r,
    getClassNames: o,
    cx: t
  }), f), Il("div", null, u));
}, aP = function(n, u) {
  var t = n.theme, r = t.colors, o = t.spacing;
  return yl({
    label: "group",
    cursor: "default",
    display: "block"
  }, u ? {} : {
    color: r.neutral40,
    fontSize: "75%",
    fontWeight: 500,
    marginBottom: "0.25em",
    paddingLeft: o.baseUnit * 3,
    paddingRight: o.baseUnit * 3,
    textTransform: "uppercase"
  });
}, sP = function(n) {
  var u = yp(n);
  u.data;
  var t = le(u, rP);
  return Il("div", El({}, Nn(n, "groupHeading", {
    "group-heading": !0
  }), t));
}, dP = oP, cP = ["innerRef", "isDisabled", "isHidden", "inputClassName"], fP = function(n, u) {
  var t = n.isDisabled, r = n.value, o = n.theme, s = o.spacing, d = o.colors;
  return yl(yl({
    visibility: t ? "hidden" : "visible",
    // force css to recompute when value change due to @emotion bug.
    // We can remove it whenever the bug is fixed.
    transform: r ? "translateZ(0)" : ""
  }, pP), u ? {} : {
    margin: s.baseUnit / 2,
    paddingBottom: s.baseUnit / 2,
    paddingTop: s.baseUnit / 2,
    color: d.neutral80
  });
}, Pp = {
  gridArea: "1 / 2",
  font: "inherit",
  minWidth: "2px",
  border: 0,
  margin: 0,
  outline: 0,
  padding: 0
}, pP = {
  flex: "1 1 auto",
  display: "inline-grid",
  gridArea: "1 / 1 / 2 / 3",
  gridTemplateColumns: "0 min-content",
  "&:after": yl({
    content: 'attr(data-value) " "',
    visibility: "hidden",
    whiteSpace: "pre"
  }, Pp)
}, gP = function(n) {
  return yl({
    label: "input",
    color: "inherit",
    background: 0,
    opacity: n ? 0 : 1,
    width: "100%"
  }, Pp);
}, hP = function(n) {
  var u = n.cx, t = n.value, r = yp(n), o = r.innerRef, s = r.isDisabled, d = r.isHidden, a = r.inputClassName, f = le(r, cP);
  return Il("div", El({}, Nn(n, "input", {
    "input-container": !0
  }), {
    "data-value": t || ""
  }), Il("input", El({
    className: u({
      input: !0
    }, a),
    ref: o,
    style: gP(d),
    disabled: s
  }, f)));
}, mP = hP, vP = function(n, u) {
  var t = n.theme, r = t.spacing, o = t.borderRadius, s = t.colors;
  return yl({
    label: "multiValue",
    display: "flex",
    minWidth: 0
  }, u ? {} : {
    backgroundColor: s.neutral10,
    borderRadius: o / 2,
    margin: r.baseUnit / 2
  });
}, bP = function(n, u) {
  var t = n.theme, r = t.borderRadius, o = t.colors, s = n.cropWithEllipsis;
  return yl({
    overflow: "hidden",
    textOverflow: s || s === void 0 ? "ellipsis" : void 0,
    whiteSpace: "nowrap"
  }, u ? {} : {
    borderRadius: r / 2,
    color: o.neutral80,
    fontSize: "85%",
    padding: 3,
    paddingLeft: 6
  });
}, yP = function(n, u) {
  var t = n.theme, r = t.spacing, o = t.borderRadius, s = t.colors, d = n.isFocused;
  return yl({
    alignItems: "center",
    display: "flex"
  }, u ? {} : {
    borderRadius: o / 2,
    backgroundColor: d ? s.dangerLight : void 0,
    paddingLeft: r.baseUnit,
    paddingRight: r.baseUnit,
    ":hover": {
      backgroundColor: s.dangerLight,
      color: s.danger
    }
  });
}, Np = function(n) {
  var u = n.children, t = n.innerProps;
  return Il("div", t, u);
}, $P = Np, xP = Np;
function CP(l) {
  var n = l.children, u = l.innerProps;
  return Il("div", El({
    role: "button"
  }, u), n || Il(Hc, {
    size: 14
  }));
}
var wP = function(n) {
  var u = n.children, t = n.components, r = n.data, o = n.innerProps, s = n.isDisabled, d = n.removeProps, a = n.selectProps, f = t.Container, p = t.Label, g = t.Remove;
  return Il(f, {
    data: r,
    innerProps: yl(yl({}, Nn(n, "multiValue", {
      "multi-value": !0,
      "multi-value--is-disabled": s
    })), o),
    selectProps: a
  }, Il(p, {
    data: r,
    innerProps: yl({}, Nn(n, "multiValueLabel", {
      "multi-value__label": !0
    })),
    selectProps: a
  }, u), Il(g, {
    data: r,
    innerProps: yl(yl({}, Nn(n, "multiValueRemove", {
      "multi-value__remove": !0
    })), {}, {
      "aria-label": "Remove ".concat(u || "option")
    }, d),
    selectProps: a
  }));
}, IP = wP, EP = function(n, u) {
  var t = n.isDisabled, r = n.isFocused, o = n.isSelected, s = n.theme, d = s.spacing, a = s.colors;
  return yl({
    label: "option",
    cursor: "default",
    display: "block",
    fontSize: "inherit",
    width: "100%",
    userSelect: "none",
    WebkitTapHighlightColor: "rgba(0, 0, 0, 0)"
  }, u ? {} : {
    backgroundColor: o ? a.primary : r ? a.primary25 : "transparent",
    color: t ? a.neutral20 : o ? a.neutral0 : "inherit",
    padding: "".concat(d.baseUnit * 2, "px ").concat(d.baseUnit * 3, "px"),
    // provide some affordance on touch devices
    ":active": {
      backgroundColor: t ? void 0 : o ? a.primary : a.primary50
    }
  });
}, AP = function(n) {
  var u = n.children, t = n.isDisabled, r = n.isFocused, o = n.isSelected, s = n.innerRef, d = n.innerProps;
  return Il("div", El({}, Nn(n, "option", {
    option: !0,
    "option--is-disabled": t,
    "option--is-focused": r,
    "option--is-selected": o
  }), {
    ref: s,
    "aria-disabled": t
  }, d), u);
}, SP = AP, PP = function(n, u) {
  var t = n.theme, r = t.spacing, o = t.colors;
  return yl({
    label: "placeholder",
    gridArea: "1 / 1 / 2 / 3"
  }, u ? {} : {
    color: o.neutral50,
    marginLeft: r.baseUnit / 2,
    marginRight: r.baseUnit / 2
  });
}, NP = function(n) {
  var u = n.children, t = n.innerProps;
  return Il("div", El({}, Nn(n, "placeholder", {
    placeholder: !0
  }), t), u);
}, TP = NP, RP = function(n, u) {
  var t = n.isDisabled, r = n.theme, o = r.spacing, s = r.colors;
  return yl({
    label: "singleValue",
    gridArea: "1 / 1 / 2 / 3",
    maxWidth: "100%",
    overflow: "hidden",
    textOverflow: "ellipsis",
    whiteSpace: "nowrap"
  }, u ? {} : {
    color: t ? s.neutral40 : s.neutral80,
    marginLeft: o.baseUnit / 2,
    marginRight: o.baseUnit / 2
  });
}, OP = function(n) {
  var u = n.children, t = n.isDisabled, r = n.innerProps;
  return Il("div", El({}, Nn(n, "singleValue", {
    "single-value": !0,
    "single-value--is-disabled": t
  }), r), u);
}, FP = OP, Tp = {
  ClearIndicator: JS,
  Control: tP,
  DropdownIndicator: YS,
  DownChevron: Ap,
  CrossIcon: Hc,
  Group: dP,
  GroupHeading: sP,
  IndicatorsContainer: VS,
  IndicatorSeparator: QS,
  Input: mP,
  LoadingIndicator: nP,
  Menu: PS,
  MenuList: TS,
  MenuPortal: MS,
  LoadingMessage: _S,
  NoOptionsMessage: FS,
  MultiValue: IP,
  MultiValueContainer: $P,
  MultiValueLabel: xP,
  MultiValueRemove: CP,
  Option: SP,
  Placeholder: TP,
  SelectContainer: LS,
  SingleValue: FP,
  ValueContainer: jS
}, _P = function(n) {
  return yl(yl({}, Tp), n.components);
}, n3 = Number.isNaN || function(n) {
  return typeof n == "number" && n !== n;
};
function DP(l, n) {
  return !!(l === n || n3(l) && n3(n));
}
function MP(l, n) {
  if (l.length !== n.length)
    return !1;
  for (var u = 0; u < l.length; u++)
    if (!DP(l[u], n[u]))
      return !1;
  return !0;
}
function BP(l, n) {
  n === void 0 && (n = MP);
  var u = null;
  function t() {
    for (var r = [], o = 0; o < arguments.length; o++)
      r[o] = arguments[o];
    if (u && u.lastThis === this && n(r, u.lastArgs))
      return u.lastResult;
    var s = l.apply(this, r);
    return u = {
      lastResult: s,
      lastArgs: r,
      lastThis: this
    }, s;
  }
  return t.clear = function() {
    u = null;
  }, t;
}
function LP() {
  return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
}
var GP =  false ? 0 : {
  name: "1f43avz-a11yText-A11yText",
  styles: "label:a11yText;z-index:9999;border:0;clip:rect(1px, 1px, 1px, 1px);height:1px;width:1px;position:absolute;overflow:hidden;padding:0;white-space:nowrap;label:A11yText;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkExMXlUZXh0LnRzeCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFNSSIsImZpbGUiOiJBMTF5VGV4dC50c3giLCJzb3VyY2VzQ29udGVudCI6WyIvKiogQGpzeCBqc3ggKi9cbmltcG9ydCB7IGpzeCB9IGZyb20gJ0BlbW90aW9uL3JlYWN0JztcblxuLy8gQXNzaXN0aXZlIHRleHQgdG8gZGVzY3JpYmUgdmlzdWFsIGVsZW1lbnRzLiBIaWRkZW4gZm9yIHNpZ2h0ZWQgdXNlcnMuXG5jb25zdCBBMTF5VGV4dCA9IChwcm9wczogSlNYLkludHJpbnNpY0VsZW1lbnRzWydzcGFuJ10pID0+IChcbiAgPHNwYW5cbiAgICBjc3M9e3tcbiAgICAgIGxhYmVsOiAnYTExeVRleHQnLFxuICAgICAgekluZGV4OiA5OTk5LFxuICAgICAgYm9yZGVyOiAwLFxuICAgICAgY2xpcDogJ3JlY3QoMXB4LCAxcHgsIDFweCwgMXB4KScsXG4gICAgICBoZWlnaHQ6IDEsXG4gICAgICB3aWR0aDogMSxcbiAgICAgIHBvc2l0aW9uOiAnYWJzb2x1dGUnLFxuICAgICAgb3ZlcmZsb3c6ICdoaWRkZW4nLFxuICAgICAgcGFkZGluZzogMCxcbiAgICAgIHdoaXRlU3BhY2U6ICdub3dyYXAnLFxuICAgIH19XG4gICAgey4uLnByb3BzfVxuICAvPlxuKTtcblxuZXhwb3J0IGRlZmF1bHQgQTExeVRleHQ7XG4iXX0= */",
  toString: LP
}, jP = function(n) {
  return Il("span", El({
    css: GP
  }, n));
}, u3 = jP, WP = {
  guidance: function(n) {
    var u = n.isSearchable, t = n.isMulti, r = n.tabSelectsValue, o = n.context, s = n.isInitialFocus;
    switch (o) {
      case "menu":
        return "Use Up and Down to choose options, press Enter to select the currently focused option, press Escape to exit the menu".concat(r ? ", press Tab to select the option and exit the menu" : "", ".");
      case "input":
        return s ? "".concat(n["aria-label"] || "Select", " is focused ").concat(u ? ",type to refine list" : "", ", press Down to open the menu, ").concat(t ? " press left to focus selected values" : "") : "";
      case "value":
        return "Use left and right to toggle between focused values, press Backspace to remove the currently focused value";
      default:
        return "";
    }
  },
  onChange: function(n) {
    var u = n.action, t = n.label, r = t === void 0 ? "" : t, o = n.labels, s = n.isDisabled;
    switch (u) {
      case "deselect-option":
      case "pop-value":
      case "remove-value":
        return "option ".concat(r, ", deselected.");
      case "clear":
        return "All selected options have been cleared.";
      case "initial-input-focus":
        return "option".concat(o.length > 1 ? "s" : "", " ").concat(o.join(","), ", selected.");
      case "select-option":
        return s ? "option ".concat(r, " is disabled. Select another option.") : "option ".concat(r, ", selected.");
      default:
        return "";
    }
  },
  onFocus: function(n) {
    var u = n.context, t = n.focused, r = n.options, o = n.label, s = o === void 0 ? "" : o, d = n.selectValue, a = n.isDisabled, f = n.isSelected, p = n.isAppleDevice, g = function(b, E) {
      return b && b.length ? "".concat(b.indexOf(E) + 1, " of ").concat(b.length) : "";
    };
    if (u === "value" && d)
      return "value ".concat(s, " focused, ").concat(g(d, t), ".");
    if (u === "menu" && p) {
      var m = a ? " disabled" : "", v = "".concat(f ? " selected" : "").concat(m);
      return "".concat(s).concat(v, ", ").concat(g(r, t), ".");
    }
    return "";
  },
  onFilter: function(n) {
    var u = n.inputValue, t = n.resultsMessage;
    return "".concat(t).concat(u ? " for search term " + u : "", ".");
  }
}, VP = function(n) {
  var u = n.ariaSelection, t = n.focusedOption, r = n.focusedValue, o = n.focusableOptions, s = n.isFocused, d = n.selectValue, a = n.selectProps, f = n.id, p = n.isAppleDevice, g = a.ariaLiveMessages, m = a.getOptionLabel, v = a.inputValue, $ = a.isMulti, b = a.isOptionDisabled, E = a.isSearchable, S = a.menuIsOpen, A = a.options, x = a.screenReaderStatus, I = a.tabSelectsValue, P = a.isLoading, O = a["aria-label"], _ = a["aria-live"], j = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    return yl(yl({}, WP), g || {});
  }, [g]), z = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    var rl = "";
    if (u && j.onChange) {
      var tl = u.option, sl = u.options, ll = u.removedValue, H = u.removedValues, V = u.value, X = function(ml) {
        return Array.isArray(ml) ? null : ml;
      }, dl = ll || tl || X(V), fl = dl ? m(dl) : "", $l = sl || H || void 0, cl = $l ? $l.map(m) : [], xl = yl({
        // multiSelected items are usually items that have already been selected
        // or set by the user as a default value so we assume they are not disabled
        isDisabled: dl && b(dl, d),
        label: fl,
        labels: cl
      }, u);
      rl = j.onChange(xl);
    }
    return rl;
  }, [u, j, b, d, m]), Y = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    var rl = "", tl = t || r, sl = !!(t && d && d.includes(t));
    if (tl && j.onFocus) {
      var ll = {
        focused: tl,
        label: m(tl),
        isDisabled: b(tl, d),
        isSelected: sl,
        options: o,
        context: tl === t ? "menu" : "value",
        selectValue: d,
        isAppleDevice: p
      };
      rl = j.onFocus(ll);
    }
    return rl;
  }, [t, r, m, b, j, o, d, p]), el = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    var rl = "";
    if (S && A.length && !P && j.onFilter) {
      var tl = x({
        count: o.length
      });
      rl = j.onFilter({
        inputValue: v,
        resultsMessage: tl
      });
    }
    return rl;
  }, [o, v, S, j, A, x, P]), U = (u == null ? void 0 : u.action) === "initial-input-focus", ul = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    var rl = "";
    if (j.guidance) {
      var tl = r ? "value" : S ? "menu" : "input";
      rl = j.guidance({
        "aria-label": O,
        context: tl,
        isDisabled: t && b(t, d),
        isMulti: $,
        isSearchable: E,
        tabSelectsValue: I,
        isInitialFocus: U
      });
    }
    return rl;
  }, [O, t, r, $, b, E, S, j, d, I, U]), il = Il(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, Il("span", {
    id: "aria-selection"
  }, z), Il("span", {
    id: "aria-focused"
  }, Y), Il("span", {
    id: "aria-results"
  }, el), Il("span", {
    id: "aria-guidance"
  }, ul));
  return Il(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, Il(u3, {
    id: f
  }, U && il), Il(u3, {
    "aria-live": _,
    "aria-atomic": "false",
    "aria-relevant": "additions text",
    role: "log"
  }, s && !U && il));
}, kP = VP, zd = [{
  base: "A",
  letters: "AⒶＡÀÁÂẦẤẪẨÃĀĂẰẮẴẲȦǠÄǞẢÅǺǍȀȂẠẬẶḀĄȺⱯ"
}, {
  base: "AA",
  letters: "Ꜳ"
}, {
  base: "AE",
  letters: "ÆǼǢ"
}, {
  base: "AO",
  letters: "Ꜵ"
}, {
  base: "AU",
  letters: "Ꜷ"
}, {
  base: "AV",
  letters: "ꜸꜺ"
}, {
  base: "AY",
  letters: "Ꜽ"
}, {
  base: "B",
  letters: "BⒷＢḂḄḆɃƂƁ"
}, {
  base: "C",
  letters: "CⒸＣĆĈĊČÇḈƇȻꜾ"
}, {
  base: "D",
  letters: "DⒹＤḊĎḌḐḒḎĐƋƊƉꝹ"
}, {
  base: "DZ",
  letters: "ǱǄ"
}, {
  base: "Dz",
  letters: "ǲǅ"
}, {
  base: "E",
  letters: "EⒺＥÈÉÊỀẾỄỂẼĒḔḖĔĖËẺĚȄȆẸỆȨḜĘḘḚƐƎ"
}, {
  base: "F",
  letters: "FⒻＦḞƑꝻ"
}, {
  base: "G",
  letters: "GⒼＧǴĜḠĞĠǦĢǤƓꞠꝽꝾ"
}, {
  base: "H",
  letters: "HⒽＨĤḢḦȞḤḨḪĦⱧⱵꞍ"
}, {
  base: "I",
  letters: "IⒾＩÌÍÎĨĪĬİÏḮỈǏȈȊỊĮḬƗ"
}, {
  base: "J",
  letters: "JⒿＪĴɈ"
}, {
  base: "K",
  letters: "KⓀＫḰǨḲĶḴƘⱩꝀꝂꝄꞢ"
}, {
  base: "L",
  letters: "LⓁＬĿĹĽḶḸĻḼḺŁȽⱢⱠꝈꝆꞀ"
}, {
  base: "LJ",
  letters: "Ǉ"
}, {
  base: "Lj",
  letters: "ǈ"
}, {
  base: "M",
  letters: "MⓂＭḾṀṂⱮƜ"
}, {
  base: "N",
  letters: "NⓃＮǸŃÑṄŇṆŅṊṈȠƝꞐꞤ"
}, {
  base: "NJ",
  letters: "Ǌ"
}, {
  base: "Nj",
  letters: "ǋ"
}, {
  base: "O",
  letters: "OⓄＯÒÓÔỒỐỖỔÕṌȬṎŌṐṒŎȮȰÖȪỎŐǑȌȎƠỜỚỠỞỢỌỘǪǬØǾƆƟꝊꝌ"
}, {
  base: "OI",
  letters: "Ƣ"
}, {
  base: "OO",
  letters: "Ꝏ"
}, {
  base: "OU",
  letters: "Ȣ"
}, {
  base: "P",
  letters: "PⓅＰṔṖƤⱣꝐꝒꝔ"
}, {
  base: "Q",
  letters: "QⓆＱꝖꝘɊ"
}, {
  base: "R",
  letters: "RⓇＲŔṘŘȐȒṚṜŖṞɌⱤꝚꞦꞂ"
}, {
  base: "S",
  letters: "SⓈＳẞŚṤŜṠŠṦṢṨȘŞⱾꞨꞄ"
}, {
  base: "T",
  letters: "TⓉＴṪŤṬȚŢṰṮŦƬƮȾꞆ"
}, {
  base: "TZ",
  letters: "Ꜩ"
}, {
  base: "U",
  letters: "UⓊＵÙÚÛŨṸŪṺŬÜǛǗǕǙỦŮŰǓȔȖƯỪỨỮỬỰỤṲŲṶṴɄ"
}, {
  base: "V",
  letters: "VⓋＶṼṾƲꝞɅ"
}, {
  base: "VY",
  letters: "Ꝡ"
}, {
  base: "W",
  letters: "WⓌＷẀẂŴẆẄẈⱲ"
}, {
  base: "X",
  letters: "XⓍＸẊẌ"
}, {
  base: "Y",
  letters: "YⓎＹỲÝŶỸȲẎŸỶỴƳɎỾ"
}, {
  base: "Z",
  letters: "ZⓏＺŹẐŻŽẒẔƵȤⱿⱫꝢ"
}, {
  base: "a",
  letters: "aⓐａẚàáâầấẫẩãāăằắẵẳȧǡäǟảåǻǎȁȃạậặḁąⱥɐ"
}, {
  base: "aa",
  letters: "ꜳ"
}, {
  base: "ae",
  letters: "æǽǣ"
}, {
  base: "ao",
  letters: "ꜵ"
}, {
  base: "au",
  letters: "ꜷ"
}, {
  base: "av",
  letters: "ꜹꜻ"
}, {
  base: "ay",
  letters: "ꜽ"
}, {
  base: "b",
  letters: "bⓑｂḃḅḇƀƃɓ"
}, {
  base: "c",
  letters: "cⓒｃćĉċčçḉƈȼꜿↄ"
}, {
  base: "d",
  letters: "dⓓｄḋďḍḑḓḏđƌɖɗꝺ"
}, {
  base: "dz",
  letters: "ǳǆ"
}, {
  base: "e",
  letters: "eⓔｅèéêềếễểẽēḕḗĕėëẻěȅȇẹệȩḝęḙḛɇɛǝ"
}, {
  base: "f",
  letters: "fⓕｆḟƒꝼ"
}, {
  base: "g",
  letters: "gⓖｇǵĝḡğġǧģǥɠꞡᵹꝿ"
}, {
  base: "h",
  letters: "hⓗｈĥḣḧȟḥḩḫẖħⱨⱶɥ"
}, {
  base: "hv",
  letters: "ƕ"
}, {
  base: "i",
  letters: "iⓘｉìíîĩīĭïḯỉǐȉȋịįḭɨı"
}, {
  base: "j",
  letters: "jⓙｊĵǰɉ"
}, {
  base: "k",
  letters: "kⓚｋḱǩḳķḵƙⱪꝁꝃꝅꞣ"
}, {
  base: "l",
  letters: "lⓛｌŀĺľḷḹļḽḻſłƚɫⱡꝉꞁꝇ"
}, {
  base: "lj",
  letters: "ǉ"
}, {
  base: "m",
  letters: "mⓜｍḿṁṃɱɯ"
}, {
  base: "n",
  letters: "nⓝｎǹńñṅňṇņṋṉƞɲŉꞑꞥ"
}, {
  base: "nj",
  letters: "ǌ"
}, {
  base: "o",
  letters: "oⓞｏòóôồốỗổõṍȭṏōṑṓŏȯȱöȫỏőǒȍȏơờớỡởợọộǫǭøǿɔꝋꝍɵ"
}, {
  base: "oi",
  letters: "ƣ"
}, {
  base: "ou",
  letters: "ȣ"
}, {
  base: "oo",
  letters: "ꝏ"
}, {
  base: "p",
  letters: "pⓟｐṕṗƥᵽꝑꝓꝕ"
}, {
  base: "q",
  letters: "qⓠｑɋꝗꝙ"
}, {
  base: "r",
  letters: "rⓡｒŕṙřȑȓṛṝŗṟɍɽꝛꞧꞃ"
}, {
  base: "s",
  letters: "sⓢｓßśṥŝṡšṧṣṩșşȿꞩꞅẛ"
}, {
  base: "t",
  letters: "tⓣｔṫẗťṭțţṱṯŧƭʈⱦꞇ"
}, {
  base: "tz",
  letters: "ꜩ"
}, {
  base: "u",
  letters: "uⓤｕùúûũṹūṻŭüǜǘǖǚủůűǔȕȗưừứữửựụṳųṷṵʉ"
}, {
  base: "v",
  letters: "vⓥｖṽṿʋꝟʌ"
}, {
  base: "vy",
  letters: "ꝡ"
}, {
  base: "w",
  letters: "wⓦｗẁẃŵẇẅẘẉⱳ"
}, {
  base: "x",
  letters: "xⓧｘẋẍ"
}, {
  base: "y",
  letters: "yⓨｙỳýŷỹȳẏÿỷẙỵƴɏỿ"
}, {
  base: "z",
  letters: "zⓩｚźẑżžẓẕƶȥɀⱬꝣ"
}], HP = new RegExp("[" + zd.map(function(l) {
  return l.letters;
}).join("") + "]", "g"), Rp = {};
for (var rd = 0; rd < zd.length; rd++)
  for (var id = zd[rd], od = 0; od < id.letters.length; od++)
    Rp[id.letters[od]] = id.base;
var Op = function(n) {
  return n.replace(HP, function(u) {
    return Rp[u];
  });
}, ZP = BP(Op), e3 = function(n) {
  return n.replace(/^\s+|\s+$/g, "");
}, XP = function(n) {
  return "".concat(n.label, " ").concat(n.value);
}, zP = function(n) {
  return function(u, t) {
    if (u.data.__isNew__) return !0;
    var r = yl({
      ignoreCase: !0,
      ignoreAccents: !0,
      stringify: XP,
      trim: !0,
      matchFrom: "any"
    }, n), o = r.ignoreCase, s = r.ignoreAccents, d = r.stringify, a = r.trim, f = r.matchFrom, p = a ? e3(t) : t, g = a ? e3(d(u)) : d(u);
    return o && (p = p.toLowerCase(), g = g.toLowerCase()), s && (p = ZP(p), g = Op(g)), f === "start" ? g.substr(0, p.length) === p : g.indexOf(p) > -1;
  };
}, YP = ["innerRef"];
function UP(l) {
  var n = l.innerRef, u = le(l, YP), t = $S(u, "onExited", "in", "enter", "exit", "appear");
  return Il("input", El({
    ref: n
  }, t, {
    css: /* @__PURE__ */ kc({
      label: "dummyInput",
      // get rid of any default styles
      background: 0,
      border: 0,
      // important! this hides the flashing cursor
      caretColor: "transparent",
      fontSize: "inherit",
      gridArea: "1 / 1 / 2 / 3",
      outline: 0,
      padding: 0,
      // important! without `width` browsers won't allow focus
      width: 1,
      // remove cursor on desktop
      color: "transparent",
      // remove cursor on mobile whilst maintaining "scroll into view" behaviour
      left: -100,
      opacity: 0,
      position: "relative",
      transform: "scale(.01)"
    },  false ? 0 : ";label:DummyInput;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkR1bW15SW5wdXQudHN4Il0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQXlCTSIsImZpbGUiOiJEdW1teUlucHV0LnRzeCIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAanN4IGpzeCAqL1xuaW1wb3J0IHsgUmVmIH0gZnJvbSAncmVhY3QnO1xuaW1wb3J0IHsganN4IH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuaW1wb3J0IHsgcmVtb3ZlUHJvcHMgfSBmcm9tICcuLi91dGlscyc7XG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIER1bW15SW5wdXQoe1xuICBpbm5lclJlZixcbiAgLi4ucHJvcHNcbn06IEpTWC5JbnRyaW5zaWNFbGVtZW50c1snaW5wdXQnXSAmIHtcbiAgcmVhZG9ubHkgaW5uZXJSZWY6IFJlZjxIVE1MSW5wdXRFbGVtZW50Pjtcbn0pIHtcbiAgLy8gUmVtb3ZlIGFuaW1hdGlvbiBwcm9wcyBub3QgbWVhbnQgZm9yIEhUTUwgZWxlbWVudHNcbiAgY29uc3QgZmlsdGVyZWRQcm9wcyA9IHJlbW92ZVByb3BzKFxuICAgIHByb3BzLFxuICAgICdvbkV4aXRlZCcsXG4gICAgJ2luJyxcbiAgICAnZW50ZXInLFxuICAgICdleGl0JyxcbiAgICAnYXBwZWFyJ1xuICApO1xuXG4gIHJldHVybiAoXG4gICAgPGlucHV0XG4gICAgICByZWY9e2lubmVyUmVmfVxuICAgICAgey4uLmZpbHRlcmVkUHJvcHN9XG4gICAgICBjc3M9e3tcbiAgICAgICAgbGFiZWw6ICdkdW1teUlucHV0JyxcbiAgICAgICAgLy8gZ2V0IHJpZCBvZiBhbnkgZGVmYXVsdCBzdHlsZXNcbiAgICAgICAgYmFja2dyb3VuZDogMCxcbiAgICAgICAgYm9yZGVyOiAwLFxuICAgICAgICAvLyBpbXBvcnRhbnQhIHRoaXMgaGlkZXMgdGhlIGZsYXNoaW5nIGN1cnNvclxuICAgICAgICBjYXJldENvbG9yOiAndHJhbnNwYXJlbnQnLFxuICAgICAgICBmb250U2l6ZTogJ2luaGVyaXQnLFxuICAgICAgICBncmlkQXJlYTogJzEgLyAxIC8gMiAvIDMnLFxuICAgICAgICBvdXRsaW5lOiAwLFxuICAgICAgICBwYWRkaW5nOiAwLFxuICAgICAgICAvLyBpbXBvcnRhbnQhIHdpdGhvdXQgYHdpZHRoYCBicm93c2VycyB3b24ndCBhbGxvdyBmb2N1c1xuICAgICAgICB3aWR0aDogMSxcblxuICAgICAgICAvLyByZW1vdmUgY3Vyc29yIG9uIGRlc2t0b3BcbiAgICAgICAgY29sb3I6ICd0cmFuc3BhcmVudCcsXG5cbiAgICAgICAgLy8gcmVtb3ZlIGN1cnNvciBvbiBtb2JpbGUgd2hpbHN0IG1haW50YWluaW5nIFwic2Nyb2xsIGludG8gdmlld1wiIGJlaGF2aW91clxuICAgICAgICBsZWZ0OiAtMTAwLFxuICAgICAgICBvcGFjaXR5OiAwLFxuICAgICAgICBwb3NpdGlvbjogJ3JlbGF0aXZlJyxcbiAgICAgICAgdHJhbnNmb3JtOiAnc2NhbGUoLjAxKScsXG4gICAgICB9fVxuICAgIC8+XG4gICk7XG59XG4iXX0= */")
  }));
}
var JP = function(n) {
  n.cancelable && n.preventDefault(), n.stopPropagation();
};
function KP(l) {
  var n = l.isEnabled, u = l.onBottomArrive, t = l.onBottomLeave, r = l.onTopArrive, o = l.onTopLeave, s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1), d = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1), a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(0), f = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(E, S) {
    if (f.current !== null) {
      var A = f.current, x = A.scrollTop, I = A.scrollHeight, P = A.clientHeight, O = f.current, _ = S > 0, j = I - P - x, z = !1;
      j > S && s.current && (t && t(E), s.current = !1), _ && d.current && (o && o(E), d.current = !1), _ && S > j ? (u && !s.current && u(E), O.scrollTop = I, z = !0, s.current = !0) : !_ && -S > x && (r && !d.current && r(E), O.scrollTop = 0, z = !0, d.current = !0), z && JP(E);
    }
  }, [u, t, r, o]), g = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(E) {
    p(E, E.deltaY);
  }, [p]), m = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(E) {
    a.current = E.changedTouches[0].clientY;
  }, []), v = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(E) {
    var S = a.current - E.changedTouches[0].clientY;
    p(E, S);
  }, [p]), $ = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(E) {
    if (E) {
      var S = vS ? {
        passive: !1
      } : !1;
      E.addEventListener("wheel", g, S), E.addEventListener("touchstart", m, S), E.addEventListener("touchmove", v, S);
    }
  }, [v, m, g]), b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(E) {
    E && (E.removeEventListener("wheel", g, !1), E.removeEventListener("touchstart", m, !1), E.removeEventListener("touchmove", v, !1));
  }, [v, m, g]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
    if (n) {
      var E = f.current;
      return $(E), function() {
        b(E);
      };
    }
  }, [n, $, b]), function(E) {
    f.current = E;
  };
}
var t3 = ["boxSizing", "height", "overflow", "paddingRight", "position"], r3 = {
  boxSizing: "border-box",
  // account for possible declaration `width: 100%;` on body
  overflow: "hidden",
  position: "relative",
  height: "100%"
};
function i3(l) {
  l.preventDefault();
}
function o3(l) {
  l.stopPropagation();
}
function a3() {
  var l = this.scrollTop, n = this.scrollHeight, u = l + this.offsetHeight;
  l === 0 ? this.scrollTop = 1 : u === n && (this.scrollTop = l - 1);
}
function s3() {
  return "ontouchstart" in window || navigator.maxTouchPoints;
}
var d3 = !!(typeof window < "u" && window.document && window.document.createElement), Vr = 0, Xt = {
  capture: !1,
  passive: !1
};
function QP(l) {
  var n = l.isEnabled, u = l.accountForScrollbars, t = u === void 0 ? !0 : u, r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)({}), o = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(a) {
    if (d3) {
      var f = document.body, p = f && f.style;
      if (t && t3.forEach(function($) {
        var b = p && p[$];
        r.current[$] = b;
      }), t && Vr < 1) {
        var g = parseInt(r.current.paddingRight, 10) || 0, m = document.body ? document.body.clientWidth : 0, v = window.innerWidth - m + g || 0;
        Object.keys(r3).forEach(function($) {
          var b = r3[$];
          p && (p[$] = b);
        }), p && (p.paddingRight = "".concat(v, "px"));
      }
      f && s3() && (f.addEventListener("touchmove", i3, Xt), a && (a.addEventListener("touchstart", a3, Xt), a.addEventListener("touchmove", o3, Xt))), Vr += 1;
    }
  }, [t]), d = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(a) {
    if (d3) {
      var f = document.body, p = f && f.style;
      Vr = Math.max(Vr - 1, 0), t && Vr < 1 && t3.forEach(function(g) {
        var m = r.current[g];
        p && (p[g] = m);
      }), f && s3() && (f.removeEventListener("touchmove", i3, Xt), a && (a.removeEventListener("touchstart", a3, Xt), a.removeEventListener("touchmove", o3, Xt)));
    }
  }, [t]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
    if (n) {
      var a = o.current;
      return s(a), function() {
        d(a);
      };
    }
  }, [n, s, d]), function(a) {
    o.current = a;
  };
}
function qP() {
  return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
}
var lN = function(n) {
  var u = n.target;
  return u.ownerDocument.activeElement && u.ownerDocument.activeElement.blur();
}, nN =  false ? 0 : {
  name: "bp8cua-ScrollManager",
  styles: "position:fixed;left:0;bottom:0;right:0;top:0;label:ScrollManager;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: qP
};
function uN(l) {
  var n = l.children, u = l.lockEnabled, t = l.captureEnabled, r = t === void 0 ? !0 : t, o = l.onBottomArrive, s = l.onBottomLeave, d = l.onTopArrive, a = l.onTopLeave, f = KP({
    isEnabled: r,
    onBottomArrive: o,
    onBottomLeave: s,
    onTopArrive: d,
    onTopLeave: a
  }), p = QP({
    isEnabled: u
  }), g = function(v) {
    f(v), p(v);
  };
  return Il(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, u && Il("div", {
    onClick: lN,
    css: nN
  }), n(g));
}
function eN() {
  return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
}
var tN =  false ? 0 : {
  name: "5kkxb2-requiredInput-RequiredInput",
  styles: "label:requiredInput;opacity:0;pointer-events:none;position:absolute;bottom:0;left:0;right:0;width:100%;label:RequiredInput;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIlJlcXVpcmVkSW5wdXQudHN4Il0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQWNJIiwiZmlsZSI6IlJlcXVpcmVkSW5wdXQudHN4Iiwic291cmNlc0NvbnRlbnQiOlsiLyoqIEBqc3gganN4ICovXG5pbXBvcnQgeyBGb2N1c0V2ZW50SGFuZGxlciwgRnVuY3Rpb25Db21wb25lbnQgfSBmcm9tICdyZWFjdCc7XG5pbXBvcnQgeyBqc3ggfSBmcm9tICdAZW1vdGlvbi9yZWFjdCc7XG5cbmNvbnN0IFJlcXVpcmVkSW5wdXQ6IEZ1bmN0aW9uQ29tcG9uZW50PHtcbiAgcmVhZG9ubHkgbmFtZT86IHN0cmluZztcbiAgcmVhZG9ubHkgb25Gb2N1czogRm9jdXNFdmVudEhhbmRsZXI8SFRNTElucHV0RWxlbWVudD47XG59PiA9ICh7IG5hbWUsIG9uRm9jdXMgfSkgPT4gKFxuICA8aW5wdXRcbiAgICByZXF1aXJlZFxuICAgIG5hbWU9e25hbWV9XG4gICAgdGFiSW5kZXg9ey0xfVxuICAgIGFyaWEtaGlkZGVuPVwidHJ1ZVwiXG4gICAgb25Gb2N1cz17b25Gb2N1c31cbiAgICBjc3M9e3tcbiAgICAgIGxhYmVsOiAncmVxdWlyZWRJbnB1dCcsXG4gICAgICBvcGFjaXR5OiAwLFxuICAgICAgcG9pbnRlckV2ZW50czogJ25vbmUnLFxuICAgICAgcG9zaXRpb246ICdhYnNvbHV0ZScsXG4gICAgICBib3R0b206IDAsXG4gICAgICBsZWZ0OiAwLFxuICAgICAgcmlnaHQ6IDAsXG4gICAgICB3aWR0aDogJzEwMCUnLFxuICAgIH19XG4gICAgLy8gUHJldmVudCBgU3dpdGNoaW5nIGZyb20gdW5jb250cm9sbGVkIHRvIGNvbnRyb2xsZWRgIGVycm9yXG4gICAgdmFsdWU9XCJcIlxuICAgIG9uQ2hhbmdlPXsoKSA9PiB7fX1cbiAgLz5cbik7XG5cbmV4cG9ydCBkZWZhdWx0IFJlcXVpcmVkSW5wdXQ7XG4iXX0= */",
  toString: eN
}, rN = function(n) {
  var u = n.name, t = n.onFocus;
  return Il("input", {
    required: !0,
    name: u,
    tabIndex: -1,
    "aria-hidden": "true",
    onFocus: t,
    css: tN,
    value: "",
    onChange: function() {
    }
  });
}, iN = rN;
function Zc(l) {
  var n;
  return typeof window < "u" && window.navigator != null ? l.test(((n = window.navigator.userAgentData) === null || n === void 0 ? void 0 : n.platform) || window.navigator.platform) : !1;
}
function oN() {
  return Zc(/^iPhone/i);
}
function Fp() {
  return Zc(/^Mac/i);
}
function aN() {
  return Zc(/^iPad/i) || // iPadOS 13 lies and says it's a Mac, but we can distinguish by detecting touch support.
  Fp() && navigator.maxTouchPoints > 1;
}
function sN() {
  return oN() || aN();
}
function dN() {
  return Fp() || sN();
}
var cN = function(n) {
  return n.label;
}, _p = function(n) {
  return n.label;
}, Dp = function(n) {
  return n.value;
}, fN = function(n) {
  return !!n.isDisabled;
}, pN = {
  clearIndicator: US,
  container: BS,
  control: uP,
  dropdownIndicator: zS,
  group: iP,
  groupHeading: aP,
  indicatorsContainer: WS,
  indicatorSeparator: KS,
  input: fP,
  loadingIndicator: lP,
  loadingMessage: OS,
  menu: ES,
  menuList: NS,
  menuPortal: DS,
  multiValue: vP,
  multiValueLabel: bP,
  multiValueRemove: yP,
  noOptionsMessage: RS,
  option: EP,
  placeholder: PP,
  singleValue: RP,
  valueContainer: GS
}, gN = {
  primary: "#2684FF",
  primary75: "#4C9AFF",
  primary50: "#B2D4FF",
  primary25: "#DEEBFF",
  danger: "#DE350B",
  dangerLight: "#FFBDAD",
  neutral0: "hsl(0, 0%, 100%)",
  neutral5: "hsl(0, 0%, 95%)",
  neutral10: "hsl(0, 0%, 90%)",
  neutral20: "hsl(0, 0%, 80%)",
  neutral30: "hsl(0, 0%, 70%)",
  neutral40: "hsl(0, 0%, 60%)",
  neutral50: "hsl(0, 0%, 50%)",
  neutral60: "hsl(0, 0%, 40%)",
  neutral70: "hsl(0, 0%, 30%)",
  neutral80: "hsl(0, 0%, 20%)",
  neutral90: "hsl(0, 0%, 10%)"
}, hN = 4, Mp = 4, mN = 38, vN = Mp * 2, bN = {
  baseUnit: Mp,
  controlHeight: mN,
  menuGutter: vN
}, ad = {
  borderRadius: hN,
  colors: gN,
  spacing: bN
}, yN = {
  "aria-live": "polite",
  backspaceRemovesValue: !0,
  blurInputOnSelect: qf(),
  captureMenuScroll: !qf(),
  classNames: {},
  closeMenuOnSelect: !0,
  closeMenuOnScroll: !1,
  components: {},
  controlShouldRenderValue: !0,
  escapeClearsValue: !1,
  filterOption: zP(),
  formatGroupLabel: cN,
  getOptionLabel: _p,
  getOptionValue: Dp,
  isDisabled: !1,
  isLoading: !1,
  isMulti: !1,
  isRtl: !1,
  isSearchable: !0,
  isOptionDisabled: fN,
  loadingMessage: function() {
    return "Loading...";
  },
  maxMenuHeight: 300,
  minMenuHeight: 140,
  menuIsOpen: !1,
  menuPlacement: "bottom",
  menuPosition: "absolute",
  menuShouldBlockScroll: !1,
  menuShouldScrollIntoView: !hS(),
  noOptionsMessage: function() {
    return "No options";
  },
  openMenuOnFocus: !1,
  openMenuOnClick: !0,
  options: [],
  pageSize: 5,
  placeholder: "Select...",
  screenReaderStatus: function(n) {
    var u = n.count;
    return "".concat(u, " result").concat(u !== 1 ? "s" : "", " available");
  },
  styles: {},
  tabIndex: 0,
  tabSelectsValue: !0,
  unstyled: !1
};
function c3(l, n, u, t) {
  var r = Gp(l, n, u), o = jp(l, n, u), s = Lp(l, n), d = la(l, n);
  return {
    type: "option",
    data: n,
    isDisabled: r,
    isSelected: o,
    label: s,
    value: d,
    index: t
  };
}
function To(l, n) {
  return l.options.map(function(u, t) {
    if ("options" in u) {
      var r = u.options.map(function(s, d) {
        return c3(l, s, n, d);
      }).filter(function(s) {
        return p3(l, s);
      });
      return r.length > 0 ? {
        type: "group",
        data: u,
        options: r,
        index: t
      } : void 0;
    }
    var o = c3(l, u, n, t);
    return p3(l, o) ? o : void 0;
  }).filter(bS);
}
function Bp(l) {
  return l.reduce(function(n, u) {
    return u.type === "group" ? n.push.apply(n, qt(u.options.map(function(t) {
      return t.data;
    }))) : n.push(u.data), n;
  }, []);
}
function f3(l, n) {
  return l.reduce(function(u, t) {
    return t.type === "group" ? u.push.apply(u, qt(t.options.map(function(r) {
      return {
        data: r.data,
        id: "".concat(n, "-").concat(t.index, "-").concat(r.index)
      };
    }))) : u.push({
      data: t.data,
      id: "".concat(n, "-").concat(t.index)
    }), u;
  }, []);
}
function $N(l, n) {
  return Bp(To(l, n));
}
function p3(l, n) {
  var u = l.inputValue, t = u === void 0 ? "" : u, r = n.data, o = n.isSelected, s = n.label, d = n.value;
  return (!Vp(l) || !o) && Wp(l, {
    label: s,
    value: d,
    data: r
  }, t);
}
function xN(l, n) {
  var u = l.focusedValue, t = l.selectValue, r = t.indexOf(u);
  if (r > -1) {
    var o = n.indexOf(u);
    if (o > -1)
      return u;
    if (r < n.length)
      return n[r];
  }
  return null;
}
function CN(l, n) {
  var u = l.focusedOption;
  return u && n.indexOf(u) > -1 ? u : n[0];
}
var sd = function(n, u) {
  var t, r = (t = n.find(function(o) {
    return o.data === u;
  })) === null || t === void 0 ? void 0 : t.id;
  return r || null;
}, Lp = function(n, u) {
  return n.getOptionLabel(u);
}, la = function(n, u) {
  return n.getOptionValue(u);
};
function Gp(l, n, u) {
  return typeof l.isOptionDisabled == "function" ? l.isOptionDisabled(n, u) : !1;
}
function jp(l, n, u) {
  if (u.indexOf(n) > -1) return !0;
  if (typeof l.isOptionSelected == "function")
    return l.isOptionSelected(n, u);
  var t = la(l, n);
  return u.some(function(r) {
    return la(l, r) === t;
  });
}
function Wp(l, n, u) {
  return l.filterOption ? l.filterOption(n, u) : !0;
}
var Vp = function(n) {
  var u = n.hideSelectedOptions, t = n.isMulti;
  return u === void 0 ? t : u;
}, wN = 1, Ea = /* @__PURE__ */ function(l) {
  jE(u, l);
  var n = kE(u);
  function u(t) {
    var r;
    if (LE(this, u), r = n.call(this, t), r.state = {
      ariaSelection: null,
      focusedOption: null,
      focusedOptionId: null,
      focusableOptionsWithIds: [],
      focusedValue: null,
      inputIsHidden: !1,
      isFocused: !1,
      selectValue: [],
      clearFocusValueOnUpdate: !1,
      prevWasFocused: !1,
      inputIsHiddenAfterUpdate: void 0,
      prevProps: void 0,
      instancePrefix: ""
    }, r.blockOptionHover = !1, r.isComposing = !1, r.commonProps = void 0, r.initialTouchX = 0, r.initialTouchY = 0, r.openAfterFocus = !1, r.scrollToFocusedOptionOnUpdate = !1, r.userIsDragging = void 0, r.isAppleDevice = dN(), r.controlRef = null, r.getControlRef = function(a) {
      r.controlRef = a;
    }, r.focusedOptionRef = null, r.getFocusedOptionRef = function(a) {
      r.focusedOptionRef = a;
    }, r.menuListRef = null, r.getMenuListRef = function(a) {
      r.menuListRef = a;
    }, r.inputRef = null, r.getInputRef = function(a) {
      r.inputRef = a;
    }, r.focus = r.focusInput, r.blur = r.blurInput, r.onChange = function(a, f) {
      var p = r.props, g = p.onChange, m = p.name;
      f.name = m, r.ariaOnChange(a, f), g(a, f);
    }, r.setValue = function(a, f, p) {
      var g = r.props, m = g.closeMenuOnSelect, v = g.isMulti, $ = g.inputValue;
      r.onInputChange("", {
        action: "set-value",
        prevInputValue: $
      }), m && (r.setState({
        inputIsHiddenAfterUpdate: !v
      }), r.onMenuClose()), r.setState({
        clearFocusValueOnUpdate: !0
      }), r.onChange(a, {
        action: f,
        option: p
      });
    }, r.selectOption = function(a) {
      var f = r.props, p = f.blurInputOnSelect, g = f.isMulti, m = f.name, v = r.state.selectValue, $ = g && r.isOptionSelected(a, v), b = r.isOptionDisabled(a, v);
      if ($) {
        var E = r.getOptionValue(a);
        r.setValue(v.filter(function(S) {
          return r.getOptionValue(S) !== E;
        }), "deselect-option", a);
      } else if (!b)
        g ? r.setValue([].concat(qt(v), [a]), "select-option", a) : r.setValue(a, "select-option");
      else {
        r.ariaOnChange(a, {
          action: "select-option",
          option: a,
          name: m
        });
        return;
      }
      p && r.blurInput();
    }, r.removeValue = function(a) {
      var f = r.props.isMulti, p = r.state.selectValue, g = r.getOptionValue(a), m = p.filter(function($) {
        return r.getOptionValue($) !== g;
      }), v = Hr(f, m, m[0] || null);
      r.onChange(v, {
        action: "remove-value",
        removedValue: a
      }), r.focusInput();
    }, r.clearValue = function() {
      var a = r.state.selectValue;
      r.onChange(Hr(r.props.isMulti, [], null), {
        action: "clear",
        removedValues: a
      });
    }, r.popValue = function() {
      var a = r.props.isMulti, f = r.state.selectValue, p = f[f.length - 1], g = f.slice(0, f.length - 1), m = Hr(a, g, g[0] || null);
      r.onChange(m, {
        action: "pop-value",
        removedValue: p
      });
    }, r.getFocusedOptionId = function(a) {
      return sd(r.state.focusableOptionsWithIds, a);
    }, r.getFocusableOptionsWithIds = function() {
      return f3(To(r.props, r.state.selectValue), r.getElementId("option"));
    }, r.getValue = function() {
      return r.state.selectValue;
    }, r.cx = function() {
      for (var a = arguments.length, f = new Array(a), p = 0; p < a; p++)
        f[p] = arguments[p];
      return sS.apply(void 0, [r.props.classNamePrefix].concat(f));
    }, r.getOptionLabel = function(a) {
      return Lp(r.props, a);
    }, r.getOptionValue = function(a) {
      return la(r.props, a);
    }, r.getStyles = function(a, f) {
      var p = r.props.unstyled, g = pN[a](f, p);
      g.boxSizing = "border-box";
      var m = r.props.styles[a];
      return m ? m(g, f) : g;
    }, r.getClassNames = function(a, f) {
      var p, g;
      return (p = (g = r.props.classNames)[a]) === null || p === void 0 ? void 0 : p.call(g, f);
    }, r.getElementId = function(a) {
      return "".concat(r.state.instancePrefix, "-").concat(a);
    }, r.getComponents = function() {
      return _P(r.props);
    }, r.buildCategorizedOptions = function() {
      return To(r.props, r.state.selectValue);
    }, r.getCategorizedOptions = function() {
      return r.props.menuIsOpen ? r.buildCategorizedOptions() : [];
    }, r.buildFocusableOptions = function() {
      return Bp(r.buildCategorizedOptions());
    }, r.getFocusableOptions = function() {
      return r.props.menuIsOpen ? r.buildFocusableOptions() : [];
    }, r.ariaOnChange = function(a, f) {
      r.setState({
        ariaSelection: yl({
          value: a
        }, f)
      });
    }, r.onMenuMouseDown = function(a) {
      a.button === 0 && (a.stopPropagation(), a.preventDefault(), r.focusInput());
    }, r.onMenuMouseMove = function(a) {
      r.blockOptionHover = !1;
    }, r.onControlMouseDown = function(a) {
      if (!a.defaultPrevented) {
        var f = r.props.openMenuOnClick;
        r.state.isFocused ? r.props.menuIsOpen ? a.target.tagName !== "INPUT" && a.target.tagName !== "TEXTAREA" && r.onMenuClose() : f && r.openMenu("first") : (f && (r.openAfterFocus = !0), r.focusInput()), a.target.tagName !== "INPUT" && a.target.tagName !== "TEXTAREA" && a.preventDefault();
      }
    }, r.onDropdownIndicatorMouseDown = function(a) {
      if (!(a && a.type === "mousedown" && a.button !== 0) && !r.props.isDisabled) {
        var f = r.props, p = f.isMulti, g = f.menuIsOpen;
        r.focusInput(), g ? (r.setState({
          inputIsHiddenAfterUpdate: !p
        }), r.onMenuClose()) : r.openMenu("first"), a.preventDefault();
      }
    }, r.onClearIndicatorMouseDown = function(a) {
      a && a.type === "mousedown" && a.button !== 0 || (r.clearValue(), a.preventDefault(), r.openAfterFocus = !1, a.type === "touchend" ? r.focusInput() : setTimeout(function() {
        return r.focusInput();
      }));
    }, r.onScroll = function(a) {
      typeof r.props.closeMenuOnScroll == "boolean" ? a.target instanceof HTMLElement && Ia(a.target) && r.props.onMenuClose() : typeof r.props.closeMenuOnScroll == "function" && r.props.closeMenuOnScroll(a) && r.props.onMenuClose();
    }, r.onCompositionStart = function() {
      r.isComposing = !0;
    }, r.onCompositionEnd = function() {
      r.isComposing = !1;
    }, r.onTouchStart = function(a) {
      var f = a.touches, p = f && f.item(0);
      p && (r.initialTouchX = p.clientX, r.initialTouchY = p.clientY, r.userIsDragging = !1);
    }, r.onTouchMove = function(a) {
      var f = a.touches, p = f && f.item(0);
      if (p) {
        var g = Math.abs(p.clientX - r.initialTouchX), m = Math.abs(p.clientY - r.initialTouchY), v = 5;
        r.userIsDragging = g > v || m > v;
      }
    }, r.onTouchEnd = function(a) {
      r.userIsDragging || (r.controlRef && !r.controlRef.contains(a.target) && r.menuListRef && !r.menuListRef.contains(a.target) && r.blurInput(), r.initialTouchX = 0, r.initialTouchY = 0);
    }, r.onControlTouchEnd = function(a) {
      r.userIsDragging || r.onControlMouseDown(a);
    }, r.onClearIndicatorTouchEnd = function(a) {
      r.userIsDragging || r.onClearIndicatorMouseDown(a);
    }, r.onDropdownIndicatorTouchEnd = function(a) {
      r.userIsDragging || r.onDropdownIndicatorMouseDown(a);
    }, r.handleInputChange = function(a) {
      var f = r.props.inputValue, p = a.currentTarget.value;
      r.setState({
        inputIsHiddenAfterUpdate: !1
      }), r.onInputChange(p, {
        action: "input-change",
        prevInputValue: f
      }), r.props.menuIsOpen || r.onMenuOpen();
    }, r.onInputFocus = function(a) {
      r.props.onFocus && r.props.onFocus(a), r.setState({
        inputIsHiddenAfterUpdate: !1,
        isFocused: !0
      }), (r.openAfterFocus || r.props.openMenuOnFocus) && r.openMenu("first"), r.openAfterFocus = !1;
    }, r.onInputBlur = function(a) {
      var f = r.props.inputValue;
      if (r.menuListRef && r.menuListRef.contains(document.activeElement)) {
        r.inputRef.focus();
        return;
      }
      r.props.onBlur && r.props.onBlur(a), r.onInputChange("", {
        action: "input-blur",
        prevInputValue: f
      }), r.onMenuClose(), r.setState({
        focusedValue: null,
        isFocused: !1
      });
    }, r.onOptionHover = function(a) {
      if (!(r.blockOptionHover || r.state.focusedOption === a)) {
        var f = r.getFocusableOptions(), p = f.indexOf(a);
        r.setState({
          focusedOption: a,
          focusedOptionId: p > -1 ? r.getFocusedOptionId(a) : null
        });
      }
    }, r.shouldHideSelectedOptions = function() {
      return Vp(r.props);
    }, r.onValueInputFocus = function(a) {
      a.preventDefault(), a.stopPropagation(), r.focus();
    }, r.onKeyDown = function(a) {
      var f = r.props, p = f.isMulti, g = f.backspaceRemovesValue, m = f.escapeClearsValue, v = f.inputValue, $ = f.isClearable, b = f.isDisabled, E = f.menuIsOpen, S = f.onKeyDown, A = f.tabSelectsValue, x = f.openMenuOnFocus, I = r.state, P = I.focusedOption, O = I.focusedValue, _ = I.selectValue;
      if (!b && !(typeof S == "function" && (S(a), a.defaultPrevented))) {
        switch (r.blockOptionHover = !0, a.key) {
          case "ArrowLeft":
            if (!p || v) return;
            r.focusValue("previous");
            break;
          case "ArrowRight":
            if (!p || v) return;
            r.focusValue("next");
            break;
          case "Delete":
          case "Backspace":
            if (v) return;
            if (O)
              r.removeValue(O);
            else {
              if (!g) return;
              p ? r.popValue() : $ && r.clearValue();
            }
            break;
          case "Tab":
            if (r.isComposing || a.shiftKey || !E || !A || !P || // don't capture the event if the menu opens on focus and the focused
            // option is already selected; it breaks the flow of navigation
            x && r.isOptionSelected(P, _))
              return;
            r.selectOption(P);
            break;
          case "Enter":
            if (a.keyCode === 229)
              break;
            if (E) {
              if (!P || r.isComposing) return;
              r.selectOption(P);
              break;
            }
            return;
          case "Escape":
            E ? (r.setState({
              inputIsHiddenAfterUpdate: !1
            }), r.onInputChange("", {
              action: "menu-close",
              prevInputValue: v
            }), r.onMenuClose()) : $ && m && r.clearValue();
            break;
          case " ":
            if (v)
              return;
            if (!E) {
              r.openMenu("first");
              break;
            }
            if (!P) return;
            r.selectOption(P);
            break;
          case "ArrowUp":
            E ? r.focusOption("up") : r.openMenu("last");
            break;
          case "ArrowDown":
            E ? r.focusOption("down") : r.openMenu("first");
            break;
          case "PageUp":
            if (!E) return;
            r.focusOption("pageup");
            break;
          case "PageDown":
            if (!E) return;
            r.focusOption("pagedown");
            break;
          case "Home":
            if (!E) return;
            r.focusOption("first");
            break;
          case "End":
            if (!E) return;
            r.focusOption("last");
            break;
          default:
            return;
        }
        a.preventDefault();
      }
    }, r.state.instancePrefix = "react-select-" + (r.props.instanceId || ++wN), r.state.selectValue = Qo(t.value), t.menuIsOpen && r.state.selectValue.length) {
      var o = r.getFocusableOptionsWithIds(), s = r.buildFocusableOptions(), d = s.indexOf(r.state.selectValue[0]);
      r.state.focusableOptionsWithIds = o, r.state.focusedOption = s[d], r.state.focusedOptionId = sd(o, s[d]);
    }
    return r;
  }
  return GE(u, [{
    key: "componentDidMount",
    value: function() {
      this.startListeningComposition(), this.startListeningToTouch(), this.props.closeMenuOnScroll && document && document.addEventListener && document.addEventListener("scroll", this.onScroll, !0), this.props.autoFocus && this.focusInput(), this.props.menuIsOpen && this.state.focusedOption && this.menuListRef && this.focusedOptionRef && Qf(this.menuListRef, this.focusedOptionRef);
    }
  }, {
    key: "componentDidUpdate",
    value: function(r) {
      var o = this.props, s = o.isDisabled, d = o.menuIsOpen, a = this.state.isFocused;
      // ensure focus is restored correctly when the control becomes enabled
      (a && !s && r.isDisabled || // ensure focus is on the Input when the menu opens
      a && d && !r.menuIsOpen) && this.focusInput(), a && s && !r.isDisabled ? this.setState({
        isFocused: !1
      }, this.onMenuClose) : !a && !s && r.isDisabled && this.inputRef === document.activeElement && this.setState({
        isFocused: !0
      }), this.menuListRef && this.focusedOptionRef && this.scrollToFocusedOptionOnUpdate && (Qf(this.menuListRef, this.focusedOptionRef), this.scrollToFocusedOptionOnUpdate = !1);
    }
  }, {
    key: "componentWillUnmount",
    value: function() {
      this.stopListeningComposition(), this.stopListeningToTouch(), document.removeEventListener("scroll", this.onScroll, !0);
    }
    // ==============================
    // Consumer Handlers
    // ==============================
  }, {
    key: "onMenuOpen",
    value: function() {
      this.props.onMenuOpen();
    }
  }, {
    key: "onMenuClose",
    value: function() {
      this.onInputChange("", {
        action: "menu-close",
        prevInputValue: this.props.inputValue
      }), this.props.onMenuClose();
    }
  }, {
    key: "onInputChange",
    value: function(r, o) {
      this.props.onInputChange(r, o);
    }
    // ==============================
    // Methods
    // ==============================
  }, {
    key: "focusInput",
    value: function() {
      this.inputRef && this.inputRef.focus();
    }
  }, {
    key: "blurInput",
    value: function() {
      this.inputRef && this.inputRef.blur();
    }
    // aliased for consumers
  }, {
    key: "openMenu",
    value: function(r) {
      var o = this, s = this.state, d = s.selectValue, a = s.isFocused, f = this.buildFocusableOptions(), p = r === "first" ? 0 : f.length - 1;
      if (!this.props.isMulti) {
        var g = f.indexOf(d[0]);
        g > -1 && (p = g);
      }
      this.scrollToFocusedOptionOnUpdate = !(a && this.menuListRef), this.setState({
        inputIsHiddenAfterUpdate: !1,
        focusedValue: null,
        focusedOption: f[p],
        focusedOptionId: this.getFocusedOptionId(f[p])
      }, function() {
        return o.onMenuOpen();
      });
    }
  }, {
    key: "focusValue",
    value: function(r) {
      var o = this.state, s = o.selectValue, d = o.focusedValue;
      if (this.props.isMulti) {
        this.setState({
          focusedOption: null
        });
        var a = s.indexOf(d);
        d || (a = -1);
        var f = s.length - 1, p = -1;
        if (s.length) {
          switch (r) {
            case "previous":
              a === 0 ? p = 0 : a === -1 ? p = f : p = a - 1;
              break;
            case "next":
              a > -1 && a < f && (p = a + 1);
              break;
          }
          this.setState({
            inputIsHidden: p !== -1,
            focusedValue: s[p]
          });
        }
      }
    }
  }, {
    key: "focusOption",
    value: function() {
      var r = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "first", o = this.props.pageSize, s = this.state.focusedOption, d = this.getFocusableOptions();
      if (d.length) {
        var a = 0, f = d.indexOf(s);
        s || (f = -1), r === "up" ? a = f > 0 ? f - 1 : d.length - 1 : r === "down" ? a = (f + 1) % d.length : r === "pageup" ? (a = f - o, a < 0 && (a = 0)) : r === "pagedown" ? (a = f + o, a > d.length - 1 && (a = d.length - 1)) : r === "last" && (a = d.length - 1), this.scrollToFocusedOptionOnUpdate = !0, this.setState({
          focusedOption: d[a],
          focusedValue: null,
          focusedOptionId: this.getFocusedOptionId(d[a])
        });
      }
    }
  }, {
    key: "getTheme",
    value: (
      // ==============================
      // Getters
      // ==============================
      function() {
        return this.props.theme ? typeof this.props.theme == "function" ? this.props.theme(ad) : yl(yl({}, ad), this.props.theme) : ad;
      }
    )
  }, {
    key: "getCommonProps",
    value: function() {
      var r = this.clearValue, o = this.cx, s = this.getStyles, d = this.getClassNames, a = this.getValue, f = this.selectOption, p = this.setValue, g = this.props, m = g.isMulti, v = g.isRtl, $ = g.options, b = this.hasValue();
      return {
        clearValue: r,
        cx: o,
        getStyles: s,
        getClassNames: d,
        getValue: a,
        hasValue: b,
        isMulti: m,
        isRtl: v,
        options: $,
        selectOption: f,
        selectProps: g,
        setValue: p,
        theme: this.getTheme()
      };
    }
  }, {
    key: "hasValue",
    value: function() {
      var r = this.state.selectValue;
      return r.length > 0;
    }
  }, {
    key: "hasOptions",
    value: function() {
      return !!this.getFocusableOptions().length;
    }
  }, {
    key: "isClearable",
    value: function() {
      var r = this.props, o = r.isClearable, s = r.isMulti;
      return o === void 0 ? s : o;
    }
  }, {
    key: "isOptionDisabled",
    value: function(r, o) {
      return Gp(this.props, r, o);
    }
  }, {
    key: "isOptionSelected",
    value: function(r, o) {
      return jp(this.props, r, o);
    }
  }, {
    key: "filterOption",
    value: function(r, o) {
      return Wp(this.props, r, o);
    }
  }, {
    key: "formatOptionLabel",
    value: function(r, o) {
      if (typeof this.props.formatOptionLabel == "function") {
        var s = this.props.inputValue, d = this.state.selectValue;
        return this.props.formatOptionLabel(r, {
          context: o,
          inputValue: s,
          selectValue: d
        });
      } else
        return this.getOptionLabel(r);
    }
  }, {
    key: "formatGroupLabel",
    value: function(r) {
      return this.props.formatGroupLabel(r);
    }
    // ==============================
    // Mouse Handlers
    // ==============================
  }, {
    key: "startListeningComposition",
    value: (
      // ==============================
      // Composition Handlers
      // ==============================
      function() {
        document && document.addEventListener && (document.addEventListener("compositionstart", this.onCompositionStart, !1), document.addEventListener("compositionend", this.onCompositionEnd, !1));
      }
    )
  }, {
    key: "stopListeningComposition",
    value: function() {
      document && document.removeEventListener && (document.removeEventListener("compositionstart", this.onCompositionStart), document.removeEventListener("compositionend", this.onCompositionEnd));
    }
  }, {
    key: "startListeningToTouch",
    value: (
      // ==============================
      // Touch Handlers
      // ==============================
      function() {
        document && document.addEventListener && (document.addEventListener("touchstart", this.onTouchStart, !1), document.addEventListener("touchmove", this.onTouchMove, !1), document.addEventListener("touchend", this.onTouchEnd, !1));
      }
    )
  }, {
    key: "stopListeningToTouch",
    value: function() {
      document && document.removeEventListener && (document.removeEventListener("touchstart", this.onTouchStart), document.removeEventListener("touchmove", this.onTouchMove), document.removeEventListener("touchend", this.onTouchEnd));
    }
  }, {
    key: "renderInput",
    value: (
      // ==============================
      // Renderers
      // ==============================
      function() {
        var r = this.props, o = r.isDisabled, s = r.isSearchable, d = r.inputId, a = r.inputValue, f = r.tabIndex, p = r.form, g = r.menuIsOpen, m = r.required, v = this.getComponents(), $ = v.Input, b = this.state, E = b.inputIsHidden, S = b.ariaSelection, A = this.commonProps, x = d || this.getElementId("input"), I = yl(yl(yl({
          "aria-autocomplete": "list",
          "aria-expanded": g,
          "aria-haspopup": !0,
          "aria-errormessage": this.props["aria-errormessage"],
          "aria-invalid": this.props["aria-invalid"],
          "aria-label": this.props["aria-label"],
          "aria-labelledby": this.props["aria-labelledby"],
          "aria-required": m,
          role: "combobox",
          "aria-activedescendant": this.isAppleDevice ? void 0 : this.state.focusedOptionId || ""
        }, g && {
          "aria-controls": this.getElementId("listbox")
        }), !s && {
          "aria-readonly": !0
        }), this.hasValue() ? (S == null ? void 0 : S.action) === "initial-input-focus" && {
          "aria-describedby": this.getElementId("live-region")
        } : {
          "aria-describedby": this.getElementId("placeholder")
        });
        return s ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement($, El({}, A, {
          autoCapitalize: "none",
          autoComplete: "off",
          autoCorrect: "off",
          id: x,
          innerRef: this.getInputRef,
          isDisabled: o,
          isHidden: E,
          onBlur: this.onInputBlur,
          onChange: this.handleInputChange,
          onFocus: this.onInputFocus,
          spellCheck: "false",
          tabIndex: f,
          form: p,
          type: "text",
          value: a
        }, I)) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(UP, El({
          id: x,
          innerRef: this.getInputRef,
          onBlur: this.onInputBlur,
          onChange: Ko,
          onFocus: this.onInputFocus,
          disabled: o,
          tabIndex: f,
          inputMode: "none",
          form: p,
          value: ""
        }, I));
      }
    )
  }, {
    key: "renderPlaceholderOrValue",
    value: function() {
      var r = this, o = this.getComponents(), s = o.MultiValue, d = o.MultiValueContainer, a = o.MultiValueLabel, f = o.MultiValueRemove, p = o.SingleValue, g = o.Placeholder, m = this.commonProps, v = this.props, $ = v.controlShouldRenderValue, b = v.isDisabled, E = v.isMulti, S = v.inputValue, A = v.placeholder, x = this.state, I = x.selectValue, P = x.focusedValue, O = x.isFocused;
      if (!this.hasValue() || !$)
        return S ? null : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(g, El({}, m, {
          key: "placeholder",
          isDisabled: b,
          isFocused: O,
          innerProps: {
            id: this.getElementId("placeholder")
          }
        }), A);
      if (E)
        return I.map(function(j, z) {
          var Y = j === P, el = "".concat(r.getOptionLabel(j), "-").concat(r.getOptionValue(j));
          return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(s, El({}, m, {
            components: {
              Container: d,
              Label: a,
              Remove: f
            },
            isFocused: Y,
            isDisabled: b,
            key: el,
            index: z,
            removeProps: {
              onClick: function() {
                return r.removeValue(j);
              },
              onTouchEnd: function() {
                return r.removeValue(j);
              },
              onMouseDown: function(ul) {
                ul.preventDefault();
              }
            },
            data: j
          }), r.formatOptionLabel(j, "value"));
        });
      if (S)
        return null;
      var _ = I[0];
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(p, El({}, m, {
        data: _,
        isDisabled: b
      }), this.formatOptionLabel(_, "value"));
    }
  }, {
    key: "renderClearIndicator",
    value: function() {
      var r = this.getComponents(), o = r.ClearIndicator, s = this.commonProps, d = this.props, a = d.isDisabled, f = d.isLoading, p = this.state.isFocused;
      if (!this.isClearable() || !o || a || !this.hasValue() || f)
        return null;
      var g = {
        onMouseDown: this.onClearIndicatorMouseDown,
        onTouchEnd: this.onClearIndicatorTouchEnd,
        "aria-hidden": "true"
      };
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(o, El({}, s, {
        innerProps: g,
        isFocused: p
      }));
    }
  }, {
    key: "renderLoadingIndicator",
    value: function() {
      var r = this.getComponents(), o = r.LoadingIndicator, s = this.commonProps, d = this.props, a = d.isDisabled, f = d.isLoading, p = this.state.isFocused;
      if (!o || !f) return null;
      var g = {
        "aria-hidden": "true"
      };
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(o, El({}, s, {
        innerProps: g,
        isDisabled: a,
        isFocused: p
      }));
    }
  }, {
    key: "renderIndicatorSeparator",
    value: function() {
      var r = this.getComponents(), o = r.DropdownIndicator, s = r.IndicatorSeparator;
      if (!o || !s) return null;
      var d = this.commonProps, a = this.props.isDisabled, f = this.state.isFocused;
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(s, El({}, d, {
        isDisabled: a,
        isFocused: f
      }));
    }
  }, {
    key: "renderDropdownIndicator",
    value: function() {
      var r = this.getComponents(), o = r.DropdownIndicator;
      if (!o) return null;
      var s = this.commonProps, d = this.props.isDisabled, a = this.state.isFocused, f = {
        onMouseDown: this.onDropdownIndicatorMouseDown,
        onTouchEnd: this.onDropdownIndicatorTouchEnd,
        "aria-hidden": "true"
      };
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(o, El({}, s, {
        innerProps: f,
        isDisabled: d,
        isFocused: a
      }));
    }
  }, {
    key: "renderMenu",
    value: function() {
      var r = this, o = this.getComponents(), s = o.Group, d = o.GroupHeading, a = o.Menu, f = o.MenuList, p = o.MenuPortal, g = o.LoadingMessage, m = o.NoOptionsMessage, v = o.Option, $ = this.commonProps, b = this.state.focusedOption, E = this.props, S = E.captureMenuScroll, A = E.inputValue, x = E.isLoading, I = E.loadingMessage, P = E.minMenuHeight, O = E.maxMenuHeight, _ = E.menuIsOpen, j = E.menuPlacement, z = E.menuPosition, Y = E.menuPortalTarget, el = E.menuShouldBlockScroll, U = E.menuShouldScrollIntoView, ul = E.noOptionsMessage, il = E.onMenuScrollToTop, rl = E.onMenuScrollToBottom;
      if (!_) return null;
      var tl = function(fl, $l) {
        var cl = fl.type, xl = fl.data, ol = fl.isDisabled, ml = fl.isSelected, Sl = fl.label, Ol = fl.value, Cl = b === xl, Q = ol ? void 0 : function() {
          return r.onOptionHover(xl);
        }, Xl = ol ? void 0 : function() {
          return r.selectOption(xl);
        }, Bl = "".concat(r.getElementId("option"), "-").concat($l), Kl = {
          id: Bl,
          onClick: Xl,
          onMouseMove: Q,
          onMouseOver: Q,
          tabIndex: -1,
          role: "option",
          "aria-selected": r.isAppleDevice ? void 0 : ml
          // is not supported on Apple devices
        };
        return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(v, El({}, $, {
          innerProps: Kl,
          data: xl,
          isDisabled: ol,
          isSelected: ml,
          key: Bl,
          label: Sl,
          type: cl,
          value: Ol,
          isFocused: Cl,
          innerRef: Cl ? r.getFocusedOptionRef : void 0
        }), r.formatOptionLabel(fl.data, "menu"));
      }, sl;
      if (this.hasOptions())
        sl = this.getCategorizedOptions().map(function(dl) {
          if (dl.type === "group") {
            var fl = dl.data, $l = dl.options, cl = dl.index, xl = "".concat(r.getElementId("group"), "-").concat(cl), ol = "".concat(xl, "-heading");
            return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(s, El({}, $, {
              key: xl,
              data: fl,
              options: $l,
              Heading: d,
              headingProps: {
                id: ol,
                data: dl.data
              },
              label: r.formatGroupLabel(dl.data)
            }), dl.options.map(function(ml) {
              return tl(ml, "".concat(cl, "-").concat(ml.index));
            }));
          } else if (dl.type === "option")
            return tl(dl, "".concat(dl.index));
        });
      else if (x) {
        var ll = I({
          inputValue: A
        });
        if (ll === null) return null;
        sl = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(g, $, ll);
      } else {
        var H = ul({
          inputValue: A
        });
        if (H === null) return null;
        sl = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(m, $, H);
      }
      var V = {
        minMenuHeight: P,
        maxMenuHeight: O,
        menuPlacement: j,
        menuPosition: z,
        menuShouldScrollIntoView: U
      }, X = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(AS, El({}, $, V), function(dl) {
        var fl = dl.ref, $l = dl.placerProps, cl = $l.placement, xl = $l.maxHeight;
        return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(a, El({}, $, V, {
          innerRef: fl,
          innerProps: {
            onMouseDown: r.onMenuMouseDown,
            onMouseMove: r.onMenuMouseMove
          },
          isLoading: x,
          placement: cl
        }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(uN, {
          captureEnabled: S,
          onTopArrive: il,
          onBottomArrive: rl,
          lockEnabled: el
        }, function(ol) {
          return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(f, El({}, $, {
            innerRef: function(Sl) {
              r.getMenuListRef(Sl), ol(Sl);
            },
            innerProps: {
              role: "listbox",
              "aria-multiselectable": $.isMulti,
              id: r.getElementId("listbox")
            },
            isLoading: x,
            maxHeight: xl,
            focusedOption: b
          }), sl);
        }));
      });
      return Y || z === "fixed" ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(p, El({}, $, {
        appendTo: Y,
        controlElement: this.controlRef,
        menuPlacement: j,
        menuPosition: z
      }), X) : X;
    }
  }, {
    key: "renderFormField",
    value: function() {
      var r = this, o = this.props, s = o.delimiter, d = o.isDisabled, a = o.isMulti, f = o.name, p = o.required, g = this.state.selectValue;
      if (p && !this.hasValue() && !d)
        return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(iN, {
          name: f,
          onFocus: this.onValueInputFocus
        });
      if (!(!f || d))
        if (a)
          if (s) {
            var m = g.map(function(b) {
              return r.getOptionValue(b);
            }).join(s);
            return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
              name: f,
              type: "hidden",
              value: m
            });
          } else {
            var v = g.length > 0 ? g.map(function(b, E) {
              return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
                key: "i-".concat(E),
                name: f,
                type: "hidden",
                value: r.getOptionValue(b)
              });
            }) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
              name: f,
              type: "hidden",
              value: ""
            });
            return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, v);
          }
        else {
          var $ = g[0] ? this.getOptionValue(g[0]) : "";
          return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
            name: f,
            type: "hidden",
            value: $
          });
        }
    }
  }, {
    key: "renderLiveRegion",
    value: function() {
      var r = this.commonProps, o = this.state, s = o.ariaSelection, d = o.focusedOption, a = o.focusedValue, f = o.isFocused, p = o.selectValue, g = this.getFocusableOptions();
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(kP, El({}, r, {
        id: this.getElementId("live-region"),
        ariaSelection: s,
        focusedOption: d,
        focusedValue: a,
        isFocused: f,
        selectValue: p,
        focusableOptions: g,
        isAppleDevice: this.isAppleDevice
      }));
    }
  }, {
    key: "render",
    value: function() {
      var r = this.getComponents(), o = r.Control, s = r.IndicatorsContainer, d = r.SelectContainer, a = r.ValueContainer, f = this.props, p = f.className, g = f.id, m = f.isDisabled, v = f.menuIsOpen, $ = this.state.isFocused, b = this.commonProps = this.getCommonProps();
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(d, El({}, b, {
        className: p,
        innerProps: {
          id: g,
          onKeyDown: this.onKeyDown
        },
        isDisabled: m,
        isFocused: $
      }), this.renderLiveRegion(), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(o, El({}, b, {
        innerRef: this.getControlRef,
        innerProps: {
          onMouseDown: this.onControlMouseDown,
          onTouchEnd: this.onControlTouchEnd
        },
        isDisabled: m,
        isFocused: $,
        menuIsOpen: v
      }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(a, El({}, b, {
        isDisabled: m
      }), this.renderPlaceholderOrValue(), this.renderInput()), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(s, El({}, b, {
        isDisabled: m
      }), this.renderClearIndicator(), this.renderLoadingIndicator(), this.renderIndicatorSeparator(), this.renderDropdownIndicator())), this.renderMenu(), this.renderFormField());
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function(r, o) {
      var s = o.prevProps, d = o.clearFocusValueOnUpdate, a = o.inputIsHiddenAfterUpdate, f = o.ariaSelection, p = o.isFocused, g = o.prevWasFocused, m = o.instancePrefix, v = r.options, $ = r.value, b = r.menuIsOpen, E = r.inputValue, S = r.isMulti, A = Qo($), x = {};
      if (s && ($ !== s.value || v !== s.options || b !== s.menuIsOpen || E !== s.inputValue)) {
        var I = b ? $N(r, A) : [], P = b ? f3(To(r, A), "".concat(m, "-option")) : [], O = d ? xN(o, A) : null, _ = CN(o, I), j = sd(P, _);
        x = {
          selectValue: A,
          focusedOption: _,
          focusedOptionId: j,
          focusableOptionsWithIds: P,
          focusedValue: O,
          clearFocusValueOnUpdate: !1
        };
      }
      var z = a != null && r !== s ? {
        inputIsHidden: a,
        inputIsHiddenAfterUpdate: void 0
      } : {}, Y = f, el = p && g;
      return p && !el && (Y = {
        value: Hr(S, A, A[0] || null),
        options: A,
        action: "initial-input-focus"
      }, el = !g), (f == null ? void 0 : f.action) === "initial-input-focus" && (Y = null), yl(yl(yl({}, x), z), {}, {
        prevProps: r,
        ariaSelection: Y,
        prevWasFocused: el
      });
    }
  }]), u;
}(react__WEBPACK_IMPORTED_MODULE_0__.Component);
Ea.defaultProps = yN;
var IN = /* @__PURE__ */ (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function(l, n) {
  var u = Oc(l);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Ea, El({
    ref: n
  }, u));
}), EN = IN;
function na(l) {
  return Wu({ tag: "svg", attr: { viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", strokeLinecap: "round", strokeLinejoin: "round" }, child: [{ tag: "polyline", attr: { points: "6 9 12 15 18 9" }, child: [] }] })(l);
}
function AN(l) {
  return Wu({ tag: "svg", attr: { viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", strokeLinecap: "round", strokeLinejoin: "round" }, child: [{ tag: "polyline", attr: { points: "18 15 12 9 6 15" }, child: [] }] })(l);
}
function SN(l) {
  return Wu({ tag: "svg", attr: { viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", strokeLinecap: "round", strokeLinejoin: "round" }, child: [{ tag: "circle", attr: { cx: "12", cy: "12", r: "10" }, child: [] }] })(l);
}
const $_ = (l) => {
  const n = l.id || Math.random().toString(), u = l.errors && l.errors.length > 0, t = () => null, r = () => /* @__PURE__ */ y.jsx("div", { className: "px-2", children: /* @__PURE__ */ y.jsx(na, { className: "h-5 text-gray-400" }) }), o = !!(l.errors && l.errors.length > 0);
  return /* @__PURE__ */ y.jsxs("div", { className: "react-select", children: [
    typeof l.label == "string" ? /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: n,
        className: wl(
          "mb-2 inline-block cursor-pointer text-sm font-medium leading-[21px] text-gray-900",
          l.disabled && "cursor-not-allowed opacity-50"
        ),
        children: [
          l.label,
          l.required && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
        ]
      }
    ) : l.label,
    /* @__PURE__ */ y.jsx(
      EN,
      {
        ...l,
        id: void 0,
        inputId: n,
        menuPortalTarget: l.menuPortalTarget,
        menuPosition: l.menuPosition,
        isDisabled: l.disabled,
        className: wl(
          {
            hasErrors: o,
            "rounded border": l.disabled
          },
          l.className
        ),
        placeholder: /* @__PURE__ */ y.jsx("div", { className: "text-sm text-gray-400", children: l.placeholder || "Search" }),
        theme: (s) => ({
          ...s,
          colors: {
            ...s.colors,
            primary: "var(--colors-primary-500)",
            primary75: "var(--colors-primary-200)",
            primary50: "var(--colors-primary-100)",
            primary25: "var(--colors-primary-50)",
            neutral5: "var(--colors-gray-100)",
            neutral10: "var(--colors-gray-100)",
            neutral20: "var(--colors-gray-200)",
            neutral30: "var(--colors-gray-200)",
            neutral40: "var(--colors-gray-400)",
            neutral50: "var(--colors-gray-500)",
            neutral60: "var(--colors-gray-600)",
            neutral70: "var(--colors-gray-700)",
            neutral80: "var(--colors-gray-800)",
            neutral90: "var(--colors-gray-900)"
          }
        }),
        components: {
          IndicatorSeparator: t,
          DropdownIndicator: r
        },
        classNames: {
          control: ({ isFocused: s }) => u && s ? "!border-2 !border-danger-500" : s ? "!border-2 !border-primary-500" : u ? "!border !border-danger-500" : "!border-gray-200"
        },
        styles: {
          control: (s) => ({
            ...s,
            minHeight: "40px",
            boxShadow: "none",
            borderRadius: "5px",
            fontSize: "14px"
          }),
          option: (s) => ({
            ...s,
            fontSize: "0.875rem"
          }),
          multiValue: (s) => ({
            ...s,
            background: "var(--colors-primary-50)",
            borderRadius: "0.25rem"
          }),
          multiValueLabel: (s) => ({
            ...s,
            color: "var(--colors-primary-600)"
          }),
          multiValueRemove: (s) => ({
            ...s,
            color: "var(--colors-primary-600)",
            ":hover": {
              background: "var(--colors-primary-100)"
            }
          }),
          menuPortal: (s) => ({
            ...s,
            zIndex: 9999
          })
        }
      }
    ),
    /* @__PURE__ */ y.jsx(Pu, { value: l.errors ?? [] }),
    l.helpText && /* @__PURE__ */ y.jsx("p", { className: "mt-1.5 text-xs text-gray-500", children: l.helpText })
  ] });
}, vo = {
  primary: "text-primary-400",
  amber: "text-amber-400",
  blue: "text-blue-400",
  cyan: "text-cyan-400",
  emerald: "text-emerald-400",
  fuchsia: "text-fuchsia-400",
  green: "text-green-400",
  gray: "text-gray-400",
  indigo: "text-indigo-400",
  lime: "text-lime-400",
  orange: "text-orange-400",
  pink: "text-pink-400",
  purple: "text-purple-400",
  red: "text-red-400",
  rose: "text-rose-400",
  sky: "text-sky-400",
  teal: "text-teal-400",
  violet: "text-violet-400",
  yellow: "text-yellow-400"
}, PN = {
  primary: "text-primary-800",
  amber: "text-amber-800",
  blue: "text-blue-800",
  cyan: "text-cyan-800",
  emerald: "text-emerald-800",
  fuchsia: "text-fuchsia-800",
  green: "text-green-800",
  gray: "text-gray-800",
  indigo: "text-indigo-800",
  lime: "text-lime-800",
  orange: "text-orange-800",
  pink: "text-pink-800",
  purple: "text-purple-800",
  red: "text-red-800",
  rose: "text-rose-800",
  sky: "text-sky-800",
  teal: "text-teal-800",
  violet: "text-violet-800",
  yellow: "text-yellow-800"
}, NN = {
  primary: "bg-primary-50",
  amber: "bg-amber-50",
  blue: "bg-blue-50",
  cyan: "bg-cyan-50",
  emerald: "bg-emerald-50",
  fuchsia: "bg-fuchsia-50",
  green: "bg-green-50",
  gray: "bg-gray-50",
  indigo: "bg-indigo-50",
  lime: "bg-lime-50",
  orange: "bg-orange-50",
  pink: "bg-pink-50",
  purple: "bg-purple-50",
  red: "bg-red-50",
  rose: "bg-rose-50",
  sky: "bg-sky-50",
  teal: "bg-teal-50",
  violet: "bg-violet-50",
  yellow: "bg-yellow-50"
}, TN = {
  primary: "bg-primary-50 text-primary-500 hover:bg-primary-100 focus:ring-offset-primary-50 focus-ring-primary-600",
  amber: "bg-amber-50 text-amber-500 hover:bg-amber-100 focus:ring-offset-amber-50 focus-ring-amber-600",
  blue: "bg-blue-50 text-blue-500 hover:bg-blue-100 focus:ring-offset-blue-50 focus-ring-blue-600",
  cyan: "bg-cyan-50 text-cyan-500 hover:bg-cyan-100 focus:ring-offset-cyan-50 focus-ring-cyan-600",
  emerald: "bg-emerald-50 text-emerald-500 hover:bg-emerald-100 focus:ring-offset-emerald-50 focus-ring-emerald-600",
  fuchsia: "bg-fuchsia-50 text-fuchsia-500 hover:bg-fuchsia-100 focus:ring-offset-fuchsia-50 focus-ring-fuchsia-600",
  green: "bg-green-50 text-green-500 hover:bg-green-100 focus:ring-offset-green-50 focus-ring-green-600",
  gray: "bg-gray-50 text-gray-500 hover:bg-gray-100 focus:ring-offset-gray-50 focus-ring-gray-600",
  indigo: "bg-indigo-50 text-indigo-500 hover:bg-indigo-100 focus:ring-offset-indigo-50 focus-ring-indigo-600",
  lime: "bg-lime-50 text-lime-500 hover:bg-lime-100 focus:ring-offset-lime-50 focus-ring-lime-600",
  orange: "bg-orange-50 text-orange-500 hover:bg-orange-100 focus:ring-offset-orange-50 focus-ring-orange-600",
  pink: "bg-pink-50 text-pink-500 hover:bg-pink-100 focus:ring-offset-pink-50 focus-ring-pink-600",
  purple: "bg-purple-50 text-purple-500 hover:bg-purple-100 focus:ring-offset-purple-50 focus-ring-purple-600",
  red: "bg-red-50 text-red-500 hover:bg-red-100 focus:ring-offset-red-50 focus-ring-red-600",
  rose: "bg-rose-50 text-rose-500 hover:bg-rose-100 focus:ring-offset-rose-50 focus-ring-rose-600",
  sky: "bg-sky-50 text-sky-500 hover:bg-sky-100 focus:ring-offset-sky-50 focus-ring-sky-600",
  teal: "bg-teal-50 text-teal-500 hover:bg-teal-100 focus:ring-offset-teal-50 focus-ring-teal-600",
  violet: "bg-violet-50 text-violet-500 hover:bg-violet-100 focus:ring-offset-violet-50 focus-ring-violet-600",
  yellow: "bg-yellow-50 text-yellow-500 hover:bg-yellow-100 focus:ring-offset-yellow-50 focus-ring-yellow-600"
}, x_ = (l) => /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsx("div", { className: wl(`rounded-md ${NN[l.color]} p-4`, l.className), children: /* @__PURE__ */ y.jsxs("div", { className: `flex ${l.centered ? "justify-center" : ""}`, children: [
  /* @__PURE__ */ y.jsxs("div", { className: "flex-shrink-0", children: [
    l.type == "success" && /* @__PURE__ */ y.jsx(Ac, { className: `h-5 w-5 ${vo[l.color]}`, "aria-hidden": "true" }),
    l.type == "warning" && /* @__PURE__ */ y.jsx(Qx, { className: `h-5 w-5 ${vo[l.color]}`, "aria-hidden": "true" }),
    l.type == "danger" && /* @__PURE__ */ y.jsx(L4, { className: `h-5 w-5 ${vo[l.color]}`, "aria-hidden": "true" }),
    l.type == "info" && /* @__PURE__ */ y.jsx(B4, { className: `h-5 w-5 ${vo[l.color]}`, "aria-hidden": "true" })
  ] }),
  /* @__PURE__ */ y.jsxs("div", { className: "ml-3", children: [
    /* @__PURE__ */ y.jsx("p", { className: `text-sm font-medium ${PN[l.color]}`, children: l.label }),
    l.children
  ] }),
  l.dismissable && /* @__PURE__ */ y.jsx("div", { className: "ml-auto pl-3", children: /* @__PURE__ */ y.jsx("div", { className: "-mx-1.5 -my-1.5", children: /* @__PURE__ */ y.jsxs(
    "button",
    {
      onClick: l.onDismiss,
      type: "button",
      className: `
                                inline-flex
                                rounded-md p-1.5
                                focus:outline-none focus:ring-2 focus:ring-offset-2
                                ${TN[l.color]}
                            `,
      children: [
        /* @__PURE__ */ y.jsx("span", { className: "sr-only", children: "Dismiss" }),
        /* @__PURE__ */ y.jsx(G4, { className: "h-5 w-5", "aria-hidden": "true" })
      ]
    }
  ) }) })
] }) }) }), RN = (l) => {
  const n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    l.indeterminate ? n.current && (n.current.indeterminate = !0) : n.current && (n.current.indeterminate = !1);
  }, [l.indeterminate]), /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsxs("div", { className: "flex items-center", children: [
    /* @__PURE__ */ y.jsx(
      "input",
      {
        ref: n,
        type: "checkbox",
        checked: l.checked,
        ...l.input,
        id: l.input.id,
        className: wl(
          "h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 rounded",
          l.className && l.className,
          l.disabled ? "opacity-50 cursor-not-allowed" : "cursor-pointer"
        ),
        onChange: l.onChange,
        disabled: l.disabled
      }
    ),
    /* @__PURE__ */ y.jsx(
      "label",
      {
        htmlFor: l.input.id,
        className: wl(
          "ml-2 block text-sm font-medium text-gray-700",
          l.disabled ? "opacity-50 cursor-not-allowed" : "cursor-pointer"
        ),
        children: l.label
      }
    )
  ] }) });
}, C_ = (l) => {
  const [n, u] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(l.defaultValue ?? []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => l.onChange && l.onChange(n), [n]);
  const t = !!(l.errors && l.errors.length > 0);
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    l.label && /* @__PURE__ */ y.jsx("label", { className: `block w-full text-sm font-medium text-gray-700 ${l.helpText ? "" : "mb-2"}`, children: l.label }),
    l.helpText && /* @__PURE__ */ y.jsx("p", { className: "text-xs mb-2 leading-5 text-gray-600", children: l.helpText }),
    /* @__PURE__ */ y.jsx("div", { className: "space-y-0", children: l.options.map((r, o) => /* @__PURE__ */ y.jsx("div", { className: `py-1 ${l.className}`, children: /* @__PURE__ */ y.jsx(
      RN,
      {
        label: r.label,
        input: {
          id: `simple-checkbox-group-${r.value}`,
          type: "checkbox",
          name: l.name,
          value: r.value
        },
        checked: !!n.find((s) => s === r.value),
        indeterminate: r.indeterminate,
        onChange: (s) => {
          s.target.checked ? u((d) => [...d, r.value]) : u((d) => d.filter((a) => a !== r.value));
        }
      }
    ) }, o)) }),
    /* @__PURE__ */ y.jsx(
      Pu,
      {
        value: l.errors ?? [],
        className: wl({
          hasErrors: t
        })
      }
    )
  ] });
}, ON = (l) => /* @__PURE__ */ y.jsxs(
  "svg",
  {
    width: l.width || "35",
    height: l.height || "45",
    viewBox: "0 0 22 27",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: [
      /* @__PURE__ */ y.jsx(
        "path",
        {
          d: "M15.29 13.2969C15.2719 17.7984 13.3516 22.4457 9.38415 24.5598C6.59427 26.0542 0 27.2024 0 22.3364C0 22.3364 0 4.23917 0 4.22094C0 1.52368 2.26452 0.630662 4.52903 0.758235C7.89863 0.940483 11.1233 2.52604 13.0799 5.442C14.3299 7.30093 15.0183 9.54257 15.2357 11.8024C15.2538 12.3127 15.29 12.8048 15.29 13.2969Z",
          fill: "#7047EB"
        }
      ),
      /* @__PURE__ */ y.jsx(
        "path",
        {
          d: "M21.5402 11.7116C21.1598 7.99377 18.8952 4.87733 15.7612 3.00018C13.6778 1.74267 11.0691 1.43285 9.71037 3.94787C9.71037 3.9661 0.561722 20.8787 0.561722 20.8787C-0.235387 22.3549 -0.0542249 23.5759 0.67042 24.5783C1.75739 26.0727 3.9132 26.7471 5.67047 26.9293C7.30092 27.1115 8.94949 26.9293 10.5256 26.5648C15.2901 25.4713 19.5112 22.2091 20.9424 17.4706C21.504 15.6117 21.7395 13.6617 21.5402 11.7116Z",
          fill: "#FF7D92"
        }
      ),
      /* @__PURE__ */ y.jsx(
        "path",
        {
          d: "M9.38396 24.5781C13.3514 22.4458 15.2717 17.7985 15.2898 13.3152C15.2898 12.8232 15.2717 12.3311 15.2174 11.839C15.0181 9.57915 14.3116 7.3375 13.0615 5.47858C12.3731 4.43976 11.5217 3.5832 10.5615 2.87244C10.2535 3.14581 9.96368 3.5103 9.72817 3.96592C9.72817 3.98415 0.579526 20.8967 0.579526 20.8967C-0.0183065 21.9902 -0.0545421 22.9561 0.253432 23.7945C0.253432 23.8127 0.271549 23.8309 0.271549 23.8491C0.289665 23.8856 0.307779 23.9403 0.325896 23.9767C0.344012 24.0132 0.344014 24.0314 0.36213 24.0678C0.36213 24.0861 0.380247 24.1043 0.380247 24.1043C1.81142 26.8744 6.99263 25.8539 9.38396 24.5781Z",
          fill: "#E23B7B"
        }
      )
    ]
  }
), w_ = (l) => /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsxs("section", { className: "flex flex-col items-center mt-6", children: [
  /* @__PURE__ */ y.jsx(ON, {}),
  /* @__PURE__ */ y.jsx("p", { className: "text-xl mt-4", children: l.title }),
  l.subtitle && /* @__PURE__ */ y.jsx("p", { className: "text-sm text-gray-500 mt-4", children: l.subtitle })
] }) }), I_ = (l) => {
  var s, d, a, f;
  const [n, u] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0), t = l.icon, r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)();
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    var p;
    l.counter && u(((p = l.value ?? l.defaultValue) == null ? void 0 : p.toString().length) ?? 0);
  }, [l.defaultValue, l.value]);
  const o = !!(l.errors && l.errors.length > 0);
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    typeof l.label == "string" ? /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: ((s = l.input) == null ? void 0 : s.id) ?? r,
        className: wl(
          "cursor-pointer text-sm font-medium leading-[21px] text-gray-900  mb-2 inline-block",
          l.disabled && "cursor-not-allowed opacity-50"
        ),
        children: [
          l.label,
          l.required && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
        ]
      }
    ) : l.label,
    /* @__PURE__ */ y.jsxs(
      "div",
      {
        className: wl(
          "flex h-10 items-center rounded ring-1 ring-[#E9E9E9] focus-within:ring-2 focus-within:ring-primary-500",
          o && "hasErrors ring-2 ring-red-500 focus:ring-red-500"
        ),
        children: [
          l.addOnLeft && /* @__PURE__ */ y.jsx("span", { className: "inline-flex h-full items-center rounded-bl rounded-tl bg-[#EAEAEA] px-3 text-sm text-[#4F4F4F]", children: l.addOnLeft }),
          l.icon && /* @__PURE__ */ y.jsx("div", { className: "inline-flex h-full items-center rounded-bl rounded-tl px-3 text-sm", children: /* @__PURE__ */ y.jsx(t, { className: wl("h-5 w-5 text-gray-400", o && "text-red-400"), "aria-hidden": "true" }) }),
          /* @__PURE__ */ y.jsx(
            "input",
            {
              type: "text",
              required: l.required,
              disabled: l.disabled,
              value: l.value,
              id: ((d = l.input) == null ? void 0 : d.id) ?? r,
              defaultValue: l.defaultValue,
              className: wl(
                "h-full w-full rounded border-transparent p-2 text-sm text-[#575757] placeholder:text-[#828282] focus:border-transparent focus:outline-none focus:ring-0 disabled:cursor-not-allowed disabled:opacity-50",
                l.disabled && "disabled",
                l.icon && "pl-0",
                l.className
              ),
              onChange: (p) => {
                l.counter && u(p.target.value.length), l.onChange && l.onChange(p);
              },
              onKeyDown: l.onKeyDown,
              onKeyPress: l.onKeyPress,
              onKeyUp: l.onKeyUp,
              onBlur: l.onBlur,
              onFocus: l.onFocus,
              "aria-invalid": o ? "true" : "false",
              "aria-describedby": `${((a = l.input) == null ? void 0 : a.id) ?? r}-error`,
              ...l.input
            }
          ),
          l.counter && /* @__PURE__ */ y.jsx("div", { className: "inline-flex h-full items-center rounded-br rounded-tr text-sm text-[#4F4F4F]", children: /* @__PURE__ */ y.jsxs("span", { className: "border-l-2 px-3", children: [
            n,
            "/",
            ((f = l.input) == null ? void 0 : f.maxLength) ?? "∞"
          ] }) }),
          l.addOnRight && /* @__PURE__ */ y.jsx("span", { className: "inline-flex h-full items-center rounded-br rounded-tr bg-[#EAEAEA] px-3 text-sm text-[#4F4F4F]", children: l.addOnRight }),
          l.children
        ]
      }
    ),
    /* @__PURE__ */ y.jsx(Pu, { value: l.errors ?? [] }),
    l.helpText && /* @__PURE__ */ y.jsx("p", { className: "mt-1.5 text-xs text-gray-500", children: l.helpText })
  ] });
}, E_ = (l) => {
  const [n, u] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(void 0), t = !!(l.errors && l.errors.length > 0);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    u(l.value ?? l.defaultValue);
  }, [l.value, l.defaultValue]), /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    l.label && /* @__PURE__ */ y.jsx(
      "label",
      {
        htmlFor: l.name,
        className: `block w-full text-sm font-medium text-gray-700 ${l.helpText ? "" : "mb-2"}`,
        children: l.label
      }
    ),
    l.helpText && /* @__PURE__ */ y.jsx("p", { className: "text-xs mb-2 leading-5 text-gray-600", children: l.helpText }),
    /* @__PURE__ */ y.jsx("div", { className: "space-y-0", children: l.options.map((r, o) => /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: `${l.name}-${r.value}-${o}`,
        className: Oe(
          "flex items-center py-2 px-4 rounded-md w-full text-sm font-medium text-gray-700",
          l.optionClass,
          r.value === n && l.selectedOptionClass
        ),
        children: [
          /* @__PURE__ */ y.jsx(
            "input",
            {
              id: `${l.name}-${r.value}-${o}`,
              type: "radio",
              name: l.name,
              value: r.value,
              checked: r.value === n,
              className: wl(
                "h-4 w-4 border-gray-300 text-primary-600 focus:ring-primary-500",
                t && "hasErrors"
              ),
              onChange: (s) => {
                u(s.target.value), l.onChange && l.onChange(s);
              }
            }
          ),
          r.label && /* @__PURE__ */ y.jsx("span", { className: "ml-3", children: r.label })
        ]
      },
      o
    )) }),
    /* @__PURE__ */ y.jsx(Pu, { value: l.errors ?? [] })
  ] });
}, A_ = (l) => {
  function n(t) {
    t = t.replace(/^\s+|\s+$/g, ""), t = t.toLowerCase();
    const r = "àáäâèéëêìíïîòóöôùúüûñç·/_,:;", o = "aaaaeeeeiiiioooouuuunc------";
    for (let s = 0, d = r.length; s < d; s++)
      t = t.replace(new RegExp(r.charAt(s), "g"), o.charAt(s));
    return t = t.replace(/[^a-z0-9 -]/g, "").replace(/\s+/g, "-").replace(/-+/g, "-"), t;
  }
  const u = !!(l.errors && l.errors.length > 0);
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: `${n(l.label)}-simple-select`,
        className: wl(
          "cursor-pointer text-sm font-medium leading-[21px] text-gray-900  mb-2 inline-block",
          l.disabled && "cursor-not-allowed opacity-50"
        ),
        children: [
          l.label,
          l.required && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
        ]
      }
    ),
    /* @__PURE__ */ y.jsxs(
      "select",
      {
        value: l.value || "",
        required: l.required,
        onChange: l.onChange,
        id: `${n(l.label)}-simple-select`,
        name: `${n(l.label)}-simple-select`,
        className: wl(
          "h-10 w-full rounded border-0 text-sm ring-1 focus:ring-2 ring-gray-200 ps-3 focus:outline-none focus:ring-primary-500",
          u && "ring-red-500 focus:ring-red-500 hasErrors"
        ),
        style: { fontSize: "14px" },
        disabled: l.disabled,
        children: [
          l.placeholder && /* @__PURE__ */ y.jsx("option", { disabled: !0, value: "", children: l.placeholder }),
          l.options.map((t, r) => Array.isArray(t.value) ? /* @__PURE__ */ y.jsx("optgroup", { label: t.label, children: t.value.map((o, s) => {
            var d;
            return /* @__PURE__ */ y.jsx(
              "option",
              {
                value: typeof l.value == "object" ? (d = l == null ? void 0 : l.value) == null ? void 0 : d.toString() : o.value,
                children: o.label
              },
              s
            );
          }) }, r) : typeof t.value == "string" ? /* @__PURE__ */ y.jsx("option", { value: t.value, children: t.label }, r) : typeof t.value == "number" ? /* @__PURE__ */ y.jsx("option", { value: t.value, children: t.label }, r) : null)
        ]
      }
    ),
    /* @__PURE__ */ y.jsx(Pu, { value: l.errors ?? [] }),
    l.helpText && /* @__PURE__ */ y.jsx("p", { className: "mt-1.5 text-xs text-gray-500", children: l.helpText })
  ] });
};
var FN = ["allowCreateWhileLoading", "createOptionPosition", "formatCreateLabel", "isValidNewOption", "getNewOptionData", "onCreateOption", "options", "onChange"], g3 = function() {
  var n = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "", u = arguments.length > 1 ? arguments[1] : void 0, t = arguments.length > 2 ? arguments[2] : void 0, r = String(n).toLowerCase(), o = String(t.getOptionValue(u)).toLowerCase(), s = String(t.getOptionLabel(u)).toLowerCase();
  return o === r || s === r;
}, dd = {
  formatCreateLabel: function(n) {
    return 'Create "'.concat(n, '"');
  },
  isValidNewOption: function(n, u, t, r) {
    return !(!n || u.some(function(o) {
      return g3(n, o, r);
    }) || t.some(function(o) {
      return g3(n, o, r);
    }));
  },
  getNewOptionData: function(n, u) {
    return {
      label: u,
      value: n,
      __isNew__: !0
    };
  }
};
function _N(l) {
  var n = l.allowCreateWhileLoading, u = n === void 0 ? !1 : n, t = l.createOptionPosition, r = t === void 0 ? "last" : t, o = l.formatCreateLabel, s = o === void 0 ? dd.formatCreateLabel : o, d = l.isValidNewOption, a = d === void 0 ? dd.isValidNewOption : d, f = l.getNewOptionData, p = f === void 0 ? dd.getNewOptionData : f, g = l.onCreateOption, m = l.options, v = m === void 0 ? [] : m, $ = l.onChange, b = le(l, FN), E = b.getOptionValue, S = E === void 0 ? Dp : E, A = b.getOptionLabel, x = A === void 0 ? _p : A, I = b.inputValue, P = b.isLoading, O = b.isMulti, _ = b.value, j = b.name, z = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    return a(I, Qo(_), v, {
      getOptionValue: S,
      getOptionLabel: x
    }) ? p(I, s(I)) : void 0;
  }, [s, p, x, S, I, a, v, _]), Y = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    return (u || !P) && z ? r === "first" ? [z].concat(qt(v)) : [].concat(qt(v), [z]) : v;
  }, [u, r, P, z, v]), el = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(U, ul) {
    if (ul.action !== "select-option")
      return $(U, ul);
    var il = Array.isArray(U) ? U : [U];
    if (il[il.length - 1] === z) {
      if (g) g(I);
      else {
        var rl = p(I, I), tl = {
          action: "create-option",
          name: j,
          option: rl
        };
        $(Hr(O, [].concat(qt(Qo(_)), [rl]), rl), tl);
      }
      return;
    }
    $(U, ul);
  }, [p, I, O, j, z, g, $, _]);
  return yl(yl({}, b), {}, {
    options: Y,
    onChange: el
  });
}
var DN = /* @__PURE__ */ (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function(l, n) {
  var u = Oc(l), t = _N(u);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Ea, El({
    ref: n
  }, t));
}), MN = DN;
const S_ = (l) => {
  const n = l.id || Math.random().toString(), u = (s) => /* @__PURE__ */ y.jsx(Tp.MultiValueRemove, { ...s, children: /* @__PURE__ */ y.jsx("span", { className: "text-primary-600", children: "×" }) }), t = () => /* @__PURE__ */ y.jsx("div", { className: "px-2", children: /* @__PURE__ */ y.jsx(M4, { className: "h-5 text-gray-400" }) }), r = () => null, o = !!(l.errors && l.errors.length > 0);
  return /* @__PURE__ */ y.jsxs("div", { className: "react-select", children: [
    l.label && /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: n,
        className: Oe(
          "inline-block cursor-pointer text-sm font-medium leading-[21px] text-gray-900",
          l.disabled && "cursor-not-allowed opacity-70"
        ),
        children: [
          l.label,
          l.required && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
        ]
      }
    ),
    /* @__PURE__ */ y.jsx(
      MN,
      {
        ...l,
        inputId: n,
        menuPortalTarget: document.body,
        menuPosition: "absolute",
        isDisabled: l.disabled,
        className: wl(
          {
            hasErrors: o,
            "border rounded": l.disabled
          },
          l.className
        ),
        placeholder: /* @__PURE__ */ y.jsx("div", { className: "text-sm text-gray-400", children: l.placeholder || "Search" }),
        components: {
          MultiValueRemove: u,
          DropdownIndicator: t,
          IndicatorSeparator: r
        },
        classNames: {
          control: ({ isFocused: s }) => o && s ? "!border-2 !border-danger-500" : s ? "!border-2 !border-primary-500" : o ? "!border !border-danger-500" : "!border-gray-200"
        },
        styles: {
          control: (s) => ({
            ...s,
            minHeight: "40px",
            boxShadow: "none",
            borderRadius: "5px",
            fontSize: "14px"
          }),
          option: (s) => ({
            ...s,
            fontSize: "0.875rem"
          }),
          multiValue: (s) => ({
            ...s,
            background: "var(--colors-primary-50)",
            borderRadius: "0.25rem"
          }),
          multiValueLabel: (s) => ({
            ...s,
            color: "var(--colors-primary-600)"
          }),
          multiValueRemove: (s) => ({
            ...s,
            color: "var(--colors-primary-600)",
            ":hover": {
              background: "var(--colors-primary-100)"
            }
          }),
          menuPortal: (s) => ({
            ...s,
            zIndex: 9999
          }),
          noOptionsMessage: (s) => ({
            ...s,
            fontSize: "0.875rem",
            color: "var(--colors-gray-800)"
          })
        },
        theme: (s) => ({
          ...s,
          colors: {
            ...s.colors,
            primary: "var(--colors-primary-500)",
            primary75: "var(--colors-primary-200)",
            primary50: "var(--colors-primary-100)",
            primary25: "var(--colors-primary-50)",
            neutral5: "var(--colors-gray-100)",
            neutral10: "var(--colors-gray-100)",
            neutral20: "var(--colors-gray-200)",
            neutral30: "var(--colors-gray-200)",
            neutral40: "var(--colors-gray-400)",
            neutral50: "var(--colors-gray-500)",
            neutral60: "var(--colors-gray-600)",
            neutral70: "var(--colors-gray-700)",
            neutral80: "var(--colors-gray-800)",
            neutral90: "var(--colors-gray-900)"
          }
        })
      }
    ),
    /* @__PURE__ */ y.jsx(Pu, { value: l.errors ?? [] }),
    l.helpText && /* @__PURE__ */ y.jsx("span", { className: "text-xs text-gray-600", children: l.helpText })
  ] });
}, P_ = ({
  input: l,
  label: n,
  className: u,
  errors: t,
  defaultValue: r,
  value: o,
  onChange: s,
  helpText: d,
  disabled: a,
  required: f
}) => {
  const p = !!(t && t.length > 0);
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    typeof n == "string" ? /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: l.id,
        className: wl(
          "cursor-pointer text-sm font-medium leading-[21px] text-gray-900  mb-2 inline-block",
          a && "cursor-not-allowed opacity-50"
        ),
        children: [
          n,
          f && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
        ]
      }
    ) : n,
    /* @__PURE__ */ y.jsx(
      "textarea",
      {
        required: f,
        className: wl(
          "w-full rounded border-0 px-4 py-2.5 text-sm leading-5 text-gray-800 ring-1 ring-gray-200 placeholder:text-gray-400 focus:ring-2 focus:ring-primary-600 disabled:cursor-not-allowed disabled:opacity-50",
          p && "ring-red-500 focus:ring-red-500 hasErrors",
          u,
          a && "disabled"
        ),
        onChange: s,
        "aria-invalid": t ? "true" : "false",
        "aria-describedby": `${l.id}-error`,
        value: o,
        defaultValue: r,
        disabled: a,
        ...l
      }
    ),
    /* @__PURE__ */ y.jsx(Pu, { value: t ?? [] }),
    d && /* @__PURE__ */ y.jsx("p", { className: "mt-1.5 text-xs text-gray-500", children: d })
  ] });
};
function BN(l, n, { checkForDefaultPrevented: u = !0 } = {}) {
  return function(r) {
    if (l == null || l(r), u === !1 || !r.defaultPrevented)
      return n == null ? void 0 : n(r);
  };
}
function h3(l, n) {
  if (typeof l == "function")
    return l(n);
  l != null && (l.current = n);
}
function kp(...l) {
  return (n) => {
    let u = !1;
    const t = l.map((r) => {
      const o = h3(r, n);
      return !u && typeof o == "function" && (u = !0), o;
    });
    if (u)
      return () => {
        for (let r = 0; r < t.length; r++) {
          const o = t[r];
          typeof o == "function" ? o() : h3(l[r], null);
        }
      };
  };
}
function Hp(...l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(kp(...l), l);
}
function LN(l, n = []) {
  let u = [];
  function t(o, s) {
    const d = react__WEBPACK_IMPORTED_MODULE_0__.createContext(s), a = u.length;
    u = [...u, s];
    const f = (g) => {
      var S;
      const { scope: m, children: v, ...$ } = g, b = ((S = m == null ? void 0 : m[l]) == null ? void 0 : S[a]) || d, E = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => $, Object.values($));
      return /* @__PURE__ */ y.jsx(b.Provider, { value: E, children: v });
    };
    f.displayName = o + "Provider";
    function p(g, m) {
      var b;
      const v = ((b = m == null ? void 0 : m[l]) == null ? void 0 : b[a]) || d, $ = react__WEBPACK_IMPORTED_MODULE_0__.useContext(v);
      if ($) return $;
      if (s !== void 0) return s;
      throw new Error(`\`${g}\` must be used within \`${o}\``);
    }
    return [f, p];
  }
  const r = () => {
    const o = u.map((s) => react__WEBPACK_IMPORTED_MODULE_0__.createContext(s));
    return function(d) {
      const a = (d == null ? void 0 : d[l]) || o;
      return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(
        () => ({ [`__scope${l}`]: { ...d, [l]: a } }),
        [d, a]
      );
    };
  };
  return r.scopeName = l, [t, GN(r, ...n)];
}
function GN(...l) {
  const n = l[0];
  if (l.length === 1) return n;
  const u = () => {
    const t = l.map((r) => ({
      useScope: r(),
      scopeName: r.scopeName
    }));
    return function(o) {
      const s = t.reduce((d, { useScope: a, scopeName: f }) => {
        const g = a(o)[`__scope${f}`];
        return { ...d, ...g };
      }, {});
      return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({ [`__scope${n.scopeName}`]: s }), [s]);
    };
  };
  return u.scopeName = n.scopeName, u;
}
var Zp = globalThis != null && globalThis.document ? react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect : () => {
}, jN = /*#__PURE__*/ (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache || (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache = __webpack_require__.t(react__WEBPACK_IMPORTED_MODULE_0__, 2)))[" useInsertionEffect ".trim().toString()] || Zp;
function WN({
  prop: l,
  defaultProp: n,
  onChange: u = () => {
  },
  caller: t
}) {
  const [r, o, s] = VN({
    defaultProp: n,
    onChange: u
  }), d = l !== void 0, a = d ? l : r;
  {
    const p = react__WEBPACK_IMPORTED_MODULE_0__.useRef(l !== void 0);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
      const g = p.current;
      g !== d && console.warn(
        `${t} is changing from ${g ? "controlled" : "uncontrolled"} to ${d ? "controlled" : "uncontrolled"}. Components should not switch from controlled to uncontrolled (or vice versa). Decide between using a controlled or uncontrolled value for the lifetime of the component.`
      ), p.current = d;
    }, [d, t]);
  }
  const f = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(
    (p) => {
      var g;
      if (d) {
        const m = kN(p) ? p(l) : p;
        m !== l && ((g = s.current) == null || g.call(s, m));
      } else
        o(p);
    },
    [d, l, o, s]
  );
  return [a, f];
}
function VN({
  defaultProp: l,
  onChange: n
}) {
  const [u, t] = react__WEBPACK_IMPORTED_MODULE_0__.useState(l), r = react__WEBPACK_IMPORTED_MODULE_0__.useRef(u), o = react__WEBPACK_IMPORTED_MODULE_0__.useRef(n);
  return jN(() => {
    o.current = n;
  }, [n]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    var s;
    r.current !== u && ((s = o.current) == null || s.call(o, u), r.current = u);
  }, [u, r]), [u, t, o];
}
function kN(l) {
  return typeof l == "function";
}
function HN(l) {
  const n = react__WEBPACK_IMPORTED_MODULE_0__.useRef({ value: l, previous: l });
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (n.current.value !== l && (n.current.previous = n.current.value, n.current.value = l), n.current.previous), [l]);
}
function ZN(l) {
  const [n, u] = react__WEBPACK_IMPORTED_MODULE_0__.useState(void 0);
  return Zp(() => {
    if (l) {
      u({ width: l.offsetWidth, height: l.offsetHeight });
      const t = new ResizeObserver((r) => {
        if (!Array.isArray(r) || !r.length)
          return;
        const o = r[0];
        let s, d;
        if ("borderBoxSize" in o) {
          const a = o.borderBoxSize, f = Array.isArray(a) ? a[0] : a;
          s = f.inlineSize, d = f.blockSize;
        } else
          s = l.offsetWidth, d = l.offsetHeight;
        u({ width: s, height: d });
      });
      return t.observe(l, { box: "border-box" }), () => t.unobserve(l);
    } else
      u(void 0);
  }, [l]), n;
}
// @__NO_SIDE_EFFECTS__
function XN(l) {
  const n = /* @__PURE__ */ zN(l), u = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((t, r) => {
    const { children: o, ...s } = t, d = react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(o), a = d.find(UN);
    if (a) {
      const f = a.props.children, p = d.map((g) => g === a ? react__WEBPACK_IMPORTED_MODULE_0__.Children.count(f) > 1 ? react__WEBPACK_IMPORTED_MODULE_0__.Children.only(null) : react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(f) ? f.props.children : null : g);
      return /* @__PURE__ */ y.jsx(n, { ...s, ref: r, children: react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(f) ? react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(f, void 0, p) : null });
    }
    return /* @__PURE__ */ y.jsx(n, { ...s, ref: r, children: o });
  });
  return u.displayName = `${l}.Slot`, u;
}
// @__NO_SIDE_EFFECTS__
function zN(l) {
  const n = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((u, t) => {
    const { children: r, ...o } = u;
    if (react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(r)) {
      const s = KN(r), d = JN(o, r.props);
      return r.type !== react__WEBPACK_IMPORTED_MODULE_0__.Fragment && (d.ref = t ? kp(t, s) : s), react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(r, d);
    }
    return react__WEBPACK_IMPORTED_MODULE_0__.Children.count(r) > 1 ? react__WEBPACK_IMPORTED_MODULE_0__.Children.only(null) : null;
  });
  return n.displayName = `${l}.SlotClone`, n;
}
var YN = Symbol("radix.slottable");
function UN(l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(l) && typeof l.type == "function" && "__radixId" in l.type && l.type.__radixId === YN;
}
function JN(l, n) {
  const u = { ...n };
  for (const t in n) {
    const r = l[t], o = n[t];
    /^on[A-Z]/.test(t) ? r && o ? u[t] = (...d) => {
      o(...d), r(...d);
    } : r && (u[t] = r) : t === "style" ? u[t] = { ...r, ...o } : t === "className" && (u[t] = [r, o].filter(Boolean).join(" "));
  }
  return { ...l, ...u };
}
function KN(l) {
  var t, r;
  let n = (t = Object.getOwnPropertyDescriptor(l.props, "ref")) == null ? void 0 : t.get, u = n && "isReactWarning" in n && n.isReactWarning;
  return u ? l.ref : (n = (r = Object.getOwnPropertyDescriptor(l, "ref")) == null ? void 0 : r.get, u = n && "isReactWarning" in n && n.isReactWarning, u ? l.props.ref : l.props.ref || l.ref);
}
var QN = [
  "a",
  "button",
  "div",
  "form",
  "h2",
  "h3",
  "img",
  "input",
  "label",
  "li",
  "nav",
  "ol",
  "p",
  "select",
  "span",
  "svg",
  "ul"
], Xp = QN.reduce((l, n) => {
  const u = /* @__PURE__ */ XN(`Primitive.${n}`), t = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((r, o) => {
    const { asChild: s, ...d } = r, a = s ? u : n;
    return typeof window < "u" && (window[Symbol.for("radix-ui")] = !0), /* @__PURE__ */ y.jsx(a, { ...d, ref: o });
  });
  return t.displayName = `Primitive.${n}`, { ...l, [n]: t };
}, {}), Aa = "Switch", [qN, N_] = LN(Aa), [lT, nT] = qN(Aa), zp = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const {
      __scopeSwitch: u,
      name: t,
      checked: r,
      defaultChecked: o,
      required: s,
      disabled: d,
      value: a = "on",
      onCheckedChange: f,
      form: p,
      ...g
    } = l, [m, v] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), $ = Hp(n, (x) => v(x)), b = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1), E = m ? p || !!m.closest("form") : !0, [S, A] = WN({
      prop: r,
      defaultProp: o ?? !1,
      onChange: f,
      caller: Aa
    });
    return /* @__PURE__ */ y.jsxs(lT, { scope: u, checked: S, disabled: d, children: [
      /* @__PURE__ */ y.jsx(
        Xp.button,
        {
          type: "button",
          role: "switch",
          "aria-checked": S,
          "aria-required": s,
          "data-state": Kp(S),
          "data-disabled": d ? "" : void 0,
          disabled: d,
          value: a,
          ...g,
          ref: $,
          onClick: BN(l.onClick, (x) => {
            A((I) => !I), E && (b.current = x.isPropagationStopped(), b.current || x.stopPropagation());
          })
        }
      ),
      E && /* @__PURE__ */ y.jsx(
        Jp,
        {
          control: m,
          bubbles: !b.current,
          name: t,
          value: a,
          checked: S,
          required: s,
          disabled: d,
          form: p,
          style: { transform: "translateX(-100%)" }
        }
      )
    ] });
  }
);
zp.displayName = Aa;
var Yp = "SwitchThumb", Up = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const { __scopeSwitch: u, ...t } = l, r = nT(Yp, u);
    return /* @__PURE__ */ y.jsx(
      Xp.span,
      {
        "data-state": Kp(r.checked),
        "data-disabled": r.disabled ? "" : void 0,
        ...t,
        ref: n
      }
    );
  }
);
Up.displayName = Yp;
var uT = "SwitchBubbleInput", Jp = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  ({
    __scopeSwitch: l,
    control: n,
    checked: u,
    bubbles: t = !0,
    ...r
  }, o) => {
    const s = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), d = Hp(s, o), a = HN(u), f = ZN(n);
    return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
      const p = s.current;
      if (!p) return;
      const g = window.HTMLInputElement.prototype, v = Object.getOwnPropertyDescriptor(
        g,
        "checked"
      ).set;
      if (a !== u && v) {
        const $ = new Event("click", { bubbles: t });
        v.call(p, u), p.dispatchEvent($);
      }
    }, [a, u, t]), /* @__PURE__ */ y.jsx(
      "input",
      {
        type: "checkbox",
        "aria-hidden": !0,
        defaultChecked: u,
        ...r,
        tabIndex: -1,
        ref: d,
        style: {
          ...r.style,
          ...f,
          position: "absolute",
          pointerEvents: "none",
          opacity: 0,
          margin: 0
        }
      }
    );
  }
);
Jp.displayName = uT;
function Kp(l) {
  return l ? "checked" : "unchecked";
}
var eT = zp, tT = Up;
const rT = {
  amber: "bg-amber-500",
  blue: "bg-blue-500",
  cyan: "bg-cyan-500",
  emerald: "bg-emerald-500",
  fuchsia: "bg-fuchsia-500",
  green: "bg-green-500",
  gray: "bg-gray-500",
  indigo: "bg-indigo-500",
  lime: "bg-lime-500",
  orange: "bg-orange-500",
  pink: "bg-pink-500",
  purple: "bg-purple-500",
  red: "bg-red-500",
  rose: "bg-rose-500",
  sky: "bg-sky-500",
  teal: "bg-teal-500",
  violet: "bg-violet-500",
  yellow: "bg-yellow-500",
  primary: "bg-primary-500",
  secondary: "bg-secondary-500",
  danger: "bg-danger-500",
  white: "bg-white"
}, T_ = ({
  checked: l,
  onChange: n,
  color: u = "primary",
  children: t,
  label: r,
  name: o,
  value: s,
  defaultChecked: d,
  helpText: a,
  disabled: f = !1,
  id: p,
  required: g
}) => {
  const m = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), v = p || `toggle-${m}`;
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    /* @__PURE__ */ y.jsxs("div", { className: "flex items-center relative", children: [
      /* @__PURE__ */ y.jsx(
        eT,
        {
          id: v,
          defaultChecked: d,
          name: o,
          value: s,
          checked: l,
          onCheckedChange: n,
          disabled: f,
          className: `${l ? rT[u] : "bg-gray-200"} ${f ? "opacity-50 cursor-not-allowed" : ""} relative inline-flex items-center h-5 w-10 rounded-full outline-none`,
          required: g,
          children: /* @__PURE__ */ y.jsx(
            tT,
            {
              className: `${l ? "translate-x-6" : "translate-x-1"} block h-3.5 w-3.5 rounded-full bg-white transition-transform duration-200 ease-in-out`
            }
          )
        }
      ),
      t || r && /* @__PURE__ */ y.jsxs(
        "label",
        {
          htmlFor: v,
          className: `ms-2.5 text-sm font-medium text-gray-900 ${f ? "opacity-50 cursor-not-allowed" : "cursor-pointer"}`,
          children: [
            r,
            g && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
          ]
        }
      )
    ] }),
    a && /* @__PURE__ */ y.jsx("p", { className: `mt-2.5 text-xs text-gray-400 ${f ? "opacity-50" : ""}`, children: a })
  ] });
}, R_ = (l) => {
  var o, s, d;
  const n = l.icon, u = l.btnIcon, t = !!(l.errors && l.errors.length > 0), r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)();
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    typeof l.label == "string" ? /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: ((o = l.input) == null ? void 0 : o.id) ?? r,
        className: wl(
          "cursor-pointer text-sm font-medium leading-[21px] text-gray-900  mb-2 inline-block",
          l.disabled && "cursor-not-allowed opacity-50"
        ),
        children: [
          l.label,
          l.required && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
        ]
      }
    ) : l.label,
    /* @__PURE__ */ y.jsxs("div", { className: "relative flex items-stretch flex-grow focus-within:z-10", children: [
      l.icon && /* @__PURE__ */ y.jsx("div", { className: "absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none", children: /* @__PURE__ */ y.jsx(n, { className: "h-5 w-5 text-gray-400", "aria-hidden": "true" }) }),
      /* @__PURE__ */ y.jsx(
        "input",
        {
          required: l.required,
          disabled: l.disabled,
          id: ((s = l.input) == null ? void 0 : s.id) ?? r,
          className: wl(
            "w-full h-10 rounded border-0 px-4 py-2.5 text-sm leading-5 text-gray-800 ring-1 focus:ring-2 ring-gray-200 placeholder:text-gray-400 focus:ring-primary-600 disabled:cursor-not-allowed disabled:opacity-50",
            t && "ring-red-500 focus:ring-red-500 hasErrors",
            l.icon && "pl-10",
            l.className
          ),
          value: l.value,
          defaultValue: l.defaultValue,
          onChange: l.onChange,
          onKeyDown: l.onKeyDown,
          onKeyPress: l.onKeyPress,
          onKeyUp: l.onKeyUp,
          onBlur: l.onBlur,
          onFocus: l.onFocus,
          "aria-invalid": t ? "true" : "false",
          "aria-describedby": `${((d = l.input) == null ? void 0 : d.id) ?? r}-error`,
          ...l.input
        }
      ),
      /* @__PURE__ */ y.jsxs(
        "button",
        {
          onClick: l.onBtnClick && l.onBtnClick,
          type: "button",
          className: "absolute right-2.5 top-1/2 -translate-y-1/2 inline-flex items-center gap-1",
          children: [
            /* @__PURE__ */ y.jsx(u, { className: "h-5 w-5 text-gray-400", "aria-hidden": "true" }),
            l.btnLabel && /* @__PURE__ */ y.jsx("span", { children: l.btnLabel })
          ]
        }
      )
    ] }),
    /* @__PURE__ */ y.jsx(Pu, { value: l.errors ?? [] }),
    l.helpText && /* @__PURE__ */ y.jsx("p", { className: "mt-1.5 text-xs text-gray-500", children: l.helpText })
  ] });
}, O_ = (l) => {
  const [n, u] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(l.value), t = (r) => r === n;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    u(l.value);
  }, [l.value]), (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    l.onChange && l.onChange(n ?? "");
  }, [n]), /* @__PURE__ */ y.jsxs("div", { className: "flex flex-col", children: [
    /* @__PURE__ */ y.jsx("section", { className: "flex", children: l.options.map((r, o) => /* @__PURE__ */ y.jsxs(
      "section",
      {
        role: "radio",
        "aria-checked": t(r.value),
        "aria-labelledby": r.label,
        className: `${t(r.value) ? "border border-primary-400" : "border"} mr-1 inline-flex cursor-pointer space-y-1 rounded-md px-3 py-2 ${l.className}`,
        onClick: () => {
          t(r.value) ? l.allowDeselect && u(void 0) : u(r.value);
        },
        children: [
          /* @__PURE__ */ y.jsxs("div", { className: "flex w-full", children: [
            /* @__PURE__ */ y.jsx("section", { className: `pr-2 ${t(r.value) ? "text-primary-500" : "text-gray-500"}`, children: r.icon && /* @__PURE__ */ y.jsx("div", { className: `p-2 ${t(r.value) ? "bg-primary-100" : "bg-gray-100"} rounded-md`, children: r.icon }) }),
            /* @__PURE__ */ y.jsxs("section", { className: "flex flex-col justify-center", children: [
              /* @__PURE__ */ y.jsx("div", { className: "flex", children: /* @__PURE__ */ y.jsx("section", { className: "flex-1", children: /* @__PURE__ */ y.jsx("label", { className: "text-md my-2 cursor-pointer", children: r.label }) }) }),
              r.description && /* @__PURE__ */ y.jsx("div", { className: "mt-1 mb-1", children: /* @__PURE__ */ y.jsx("p", { className: "text-xs leading-4 text-gray-500", children: r.description }) })
            ] })
          ] }),
          /* @__PURE__ */ y.jsxs("section", { className: "flex-none", children: [
            !t(r.value) && /* @__PURE__ */ y.jsx(SN, { className: "h-5 w-5 text-gray-400" }),
            t(r.value) && /* @__PURE__ */ y.jsx(Ac, { className: "h-5 w-5 text-primary-500" })
          ] })
        ]
      },
      o
    )) }),
    /* @__PURE__ */ y.jsx(Pu, { value: l.errors ?? [] })
  ] });
};
function Ee(l, n, { checkForDefaultPrevented: u = !0 } = {}) {
  return function(r) {
    if (l == null || l(r), u === !1 || !r.defaultPrevented)
      return n == null ? void 0 : n(r);
  };
}
function iT(l, n) {
  typeof l == "function" ? l(n) : l != null && (l.current = n);
}
function Qp(...l) {
  return (n) => l.forEach((u) => iT(u, n));
}
function Nt(...l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(Qp(...l), l);
}
function oi(l, n = []) {
  let u = [];
  function t(o, s) {
    const d = react__WEBPACK_IMPORTED_MODULE_0__.createContext(s), a = u.length;
    u = [...u, s];
    const f = (g) => {
      var S;
      const { scope: m, children: v, ...$ } = g, b = ((S = m == null ? void 0 : m[l]) == null ? void 0 : S[a]) || d, E = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => $, Object.values($));
      return /* @__PURE__ */ y.jsx(b.Provider, { value: E, children: v });
    };
    f.displayName = o + "Provider";
    function p(g, m) {
      var b;
      const v = ((b = m == null ? void 0 : m[l]) == null ? void 0 : b[a]) || d, $ = react__WEBPACK_IMPORTED_MODULE_0__.useContext(v);
      if ($) return $;
      if (s !== void 0) return s;
      throw new Error(`\`${g}\` must be used within \`${o}\``);
    }
    return [f, p];
  }
  const r = () => {
    const o = u.map((s) => react__WEBPACK_IMPORTED_MODULE_0__.createContext(s));
    return function(d) {
      const a = (d == null ? void 0 : d[l]) || o;
      return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(
        () => ({ [`__scope${l}`]: { ...d, [l]: a } }),
        [d, a]
      );
    };
  };
  return r.scopeName = l, [t, oT(r, ...n)];
}
function oT(...l) {
  const n = l[0];
  if (l.length === 1) return n;
  const u = () => {
    const t = l.map((r) => ({
      useScope: r(),
      scopeName: r.scopeName
    }));
    return function(o) {
      const s = t.reduce((d, { useScope: a, scopeName: f }) => {
        const g = a(o)[`__scope${f}`];
        return { ...d, ...g };
      }, {});
      return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({ [`__scope${n.scopeName}`]: s }), [s]);
    };
  };
  return u.scopeName = n.scopeName, u;
}
var qp = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const { children: u, ...t } = l, r = react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(u), o = r.find(aT);
  if (o) {
    const s = o.props.children, d = r.map((a) => a === o ? react__WEBPACK_IMPORTED_MODULE_0__.Children.count(s) > 1 ? react__WEBPACK_IMPORTED_MODULE_0__.Children.only(null) : react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(s) ? s.props.children : null : a);
    return /* @__PURE__ */ y.jsx(Yd, { ...t, ref: n, children: react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(s) ? react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(s, void 0, d) : null });
  }
  return /* @__PURE__ */ y.jsx(Yd, { ...t, ref: n, children: u });
});
qp.displayName = "Slot";
var Yd = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const { children: u, ...t } = l;
  if (react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(u)) {
    const r = dT(u);
    return react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(u, {
      ...sT(t, u.props),
      // @ts-ignore
      ref: n ? Qp(n, r) : r
    });
  }
  return react__WEBPACK_IMPORTED_MODULE_0__.Children.count(u) > 1 ? react__WEBPACK_IMPORTED_MODULE_0__.Children.only(null) : null;
});
Yd.displayName = "SlotClone";
var l5 = ({ children: l }) => /* @__PURE__ */ y.jsx(y.Fragment, { children: l });
function aT(l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(l) && l.type === l5;
}
function sT(l, n) {
  const u = { ...n };
  for (const t in n) {
    const r = l[t], o = n[t];
    /^on[A-Z]/.test(t) ? r && o ? u[t] = (...d) => {
      o(...d), r(...d);
    } : r && (u[t] = r) : t === "style" ? u[t] = { ...r, ...o } : t === "className" && (u[t] = [r, o].filter(Boolean).join(" "));
  }
  return { ...l, ...u };
}
function dT(l) {
  var t, r;
  let n = (t = Object.getOwnPropertyDescriptor(l.props, "ref")) == null ? void 0 : t.get, u = n && "isReactWarning" in n && n.isReactWarning;
  return u ? l.ref : (n = (r = Object.getOwnPropertyDescriptor(l, "ref")) == null ? void 0 : r.get, u = n && "isReactWarning" in n && n.isReactWarning, u ? l.props.ref : l.props.ref || l.ref);
}
var cT = [
  "a",
  "button",
  "div",
  "form",
  "h2",
  "h3",
  "img",
  "input",
  "label",
  "li",
  "nav",
  "ol",
  "p",
  "span",
  "svg",
  "ul"
], et = cT.reduce((l, n) => {
  const u = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((t, r) => {
    const { asChild: o, ...s } = t, d = o ? qp : n;
    return typeof window < "u" && (window[Symbol.for("radix-ui")] = !0), /* @__PURE__ */ y.jsx(d, { ...s, ref: r });
  });
  return u.displayName = `Primitive.${n}`, { ...l, [n]: u };
}, {});
function fT(l, n) {
  l && react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync(() => l.dispatchEvent(n));
}
function ju(l) {
  const n = react__WEBPACK_IMPORTED_MODULE_0__.useRef(l);
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    n.current = l;
  }), react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (...u) => {
    var t;
    return (t = n.current) == null ? void 0 : t.call(n, ...u);
  }, []);
}
function n5(l, n = globalThis == null ? void 0 : globalThis.document) {
  const u = ju(l);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    const t = (r) => {
      r.key === "Escape" && u(r);
    };
    return n.addEventListener("keydown", t, { capture: !0 }), () => n.removeEventListener("keydown", t, { capture: !0 });
  }, [u, n]);
}
var pT = "DismissableLayer", Ud = "dismissableLayer.update", gT = "dismissableLayer.pointerDownOutside", hT = "dismissableLayer.focusOutside", m3, u5 = react__WEBPACK_IMPORTED_MODULE_0__.createContext({
  layers: /* @__PURE__ */ new Set(),
  layersWithOutsidePointerEventsDisabled: /* @__PURE__ */ new Set(),
  branches: /* @__PURE__ */ new Set()
}), e5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const {
      disableOutsidePointerEvents: u = !1,
      onEscapeKeyDown: t,
      onPointerDownOutside: r,
      onFocusOutside: o,
      onInteractOutside: s,
      onDismiss: d,
      ...a
    } = l, f = react__WEBPACK_IMPORTED_MODULE_0__.useContext(u5), [p, g] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), m = (p == null ? void 0 : p.ownerDocument) ?? (globalThis == null ? void 0 : globalThis.document), [, v] = react__WEBPACK_IMPORTED_MODULE_0__.useState({}), $ = Nt(n, (_) => g(_)), b = Array.from(f.layers), [E] = [...f.layersWithOutsidePointerEventsDisabled].slice(-1), S = b.indexOf(E), A = p ? b.indexOf(p) : -1, x = f.layersWithOutsidePointerEventsDisabled.size > 0, I = A >= S, P = bT((_) => {
      const j = _.target, z = [...f.branches].some((Y) => Y.contains(j));
      !I || z || (r == null || r(_), s == null || s(_), _.defaultPrevented || d == null || d());
    }, m), O = yT((_) => {
      const j = _.target;
      [...f.branches].some((Y) => Y.contains(j)) || (o == null || o(_), s == null || s(_), _.defaultPrevented || d == null || d());
    }, m);
    return n5((_) => {
      A === f.layers.size - 1 && (t == null || t(_), !_.defaultPrevented && d && (_.preventDefault(), d()));
    }, m), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
      if (p)
        return u && (f.layersWithOutsidePointerEventsDisabled.size === 0 && (m3 = m.body.style.pointerEvents, m.body.style.pointerEvents = "none"), f.layersWithOutsidePointerEventsDisabled.add(p)), f.layers.add(p), v3(), () => {
          u && f.layersWithOutsidePointerEventsDisabled.size === 1 && (m.body.style.pointerEvents = m3);
        };
    }, [p, m, u, f]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => () => {
      p && (f.layers.delete(p), f.layersWithOutsidePointerEventsDisabled.delete(p), v3());
    }, [p, f]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
      const _ = () => v({});
      return document.addEventListener(Ud, _), () => document.removeEventListener(Ud, _);
    }, []), /* @__PURE__ */ y.jsx(
      et.div,
      {
        ...a,
        ref: $,
        style: {
          pointerEvents: x ? I ? "auto" : "none" : void 0,
          ...l.style
        },
        onFocusCapture: Ee(l.onFocusCapture, O.onFocusCapture),
        onBlurCapture: Ee(l.onBlurCapture, O.onBlurCapture),
        onPointerDownCapture: Ee(
          l.onPointerDownCapture,
          P.onPointerDownCapture
        )
      }
    );
  }
);
e5.displayName = pT;
var mT = "DismissableLayerBranch", vT = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const u = react__WEBPACK_IMPORTED_MODULE_0__.useContext(u5), t = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), r = Nt(n, t);
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    const o = t.current;
    if (o)
      return u.branches.add(o), () => {
        u.branches.delete(o);
      };
  }, [u.branches]), /* @__PURE__ */ y.jsx(et.div, { ...l, ref: r });
});
vT.displayName = mT;
function bT(l, n = globalThis == null ? void 0 : globalThis.document) {
  const u = ju(l), t = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1), r = react__WEBPACK_IMPORTED_MODULE_0__.useRef(() => {
  });
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    const o = (d) => {
      if (d.target && !t.current) {
        let a = function() {
          t5(
            gT,
            u,
            f,
            { discrete: !0 }
          );
        };
        const f = { originalEvent: d };
        d.pointerType === "touch" ? (n.removeEventListener("click", r.current), r.current = a, n.addEventListener("click", r.current, { once: !0 })) : a();
      } else
        n.removeEventListener("click", r.current);
      t.current = !1;
    }, s = window.setTimeout(() => {
      n.addEventListener("pointerdown", o);
    }, 0);
    return () => {
      window.clearTimeout(s), n.removeEventListener("pointerdown", o), n.removeEventListener("click", r.current);
    };
  }, [n, u]), {
    // ensures we check React component tree (not just DOM tree)
    onPointerDownCapture: () => t.current = !0
  };
}
function yT(l, n = globalThis == null ? void 0 : globalThis.document) {
  const u = ju(l), t = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1);
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    const r = (o) => {
      o.target && !t.current && t5(hT, u, { originalEvent: o }, {
        discrete: !1
      });
    };
    return n.addEventListener("focusin", r), () => n.removeEventListener("focusin", r);
  }, [n, u]), {
    onFocusCapture: () => t.current = !0,
    onBlurCapture: () => t.current = !1
  };
}
function v3() {
  const l = new CustomEvent(Ud);
  document.dispatchEvent(l);
}
function t5(l, n, u, { discrete: t }) {
  const r = u.originalEvent.target, o = new CustomEvent(l, { bubbles: !1, cancelable: !0, detail: u });
  n && r.addEventListener(l, n, { once: !0 }), t ? fT(r, o) : r.dispatchEvent(o);
}
var Ln = globalThis != null && globalThis.document ? react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect : () => {
}, $T = react__WEBPACK_IMPORTED_MODULE_0__.useId || (() => {
}), xT = 0;
function ai(l) {
  const [n, u] = react__WEBPACK_IMPORTED_MODULE_0__.useState($T());
  return Ln(() => {
    u((t) => t ?? String(xT++));
  }, [l]), n ? `radix-${n}` : "";
}
var CT = "Arrow", r5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const { children: u, width: t = 10, height: r = 5, ...o } = l;
  return /* @__PURE__ */ y.jsx(
    et.svg,
    {
      ...o,
      ref: n,
      width: t,
      height: r,
      viewBox: "0 0 30 10",
      preserveAspectRatio: "none",
      children: l.asChild ? u : /* @__PURE__ */ y.jsx("polygon", { points: "0,0 30,0 15,10" })
    }
  );
});
r5.displayName = CT;
var wT = r5;
function IT(l, n = []) {
  let u = [];
  function t(o, s) {
    const d = react__WEBPACK_IMPORTED_MODULE_0__.createContext(s), a = u.length;
    u = [...u, s];
    function f(g) {
      const { scope: m, children: v, ...$ } = g, b = (m == null ? void 0 : m[l][a]) || d, E = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => $, Object.values($));
      return /* @__PURE__ */ y.jsx(b.Provider, { value: E, children: v });
    }
    function p(g, m) {
      const v = (m == null ? void 0 : m[l][a]) || d, $ = react__WEBPACK_IMPORTED_MODULE_0__.useContext(v);
      if ($) return $;
      if (s !== void 0) return s;
      throw new Error(`\`${g}\` must be used within \`${o}\``);
    }
    return f.displayName = o + "Provider", [f, p];
  }
  const r = () => {
    const o = u.map((s) => react__WEBPACK_IMPORTED_MODULE_0__.createContext(s));
    return function(d) {
      const a = (d == null ? void 0 : d[l]) || o;
      return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(
        () => ({ [`__scope${l}`]: { ...d, [l]: a } }),
        [d, a]
      );
    };
  };
  return r.scopeName = l, [t, ET(r, ...n)];
}
function ET(...l) {
  const n = l[0];
  if (l.length === 1) return n;
  const u = () => {
    const t = l.map((r) => ({
      useScope: r(),
      scopeName: r.scopeName
    }));
    return function(o) {
      const s = t.reduce((d, { useScope: a, scopeName: f }) => {
        const g = a(o)[`__scope${f}`];
        return { ...d, ...g };
      }, {});
      return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({ [`__scope${n.scopeName}`]: s }), [s]);
    };
  };
  return u.scopeName = n.scopeName, u;
}
function i5(l) {
  const [n, u] = react__WEBPACK_IMPORTED_MODULE_0__.useState(void 0);
  return Ln(() => {
    if (l) {
      u({ width: l.offsetWidth, height: l.offsetHeight });
      const t = new ResizeObserver((r) => {
        if (!Array.isArray(r) || !r.length)
          return;
        const o = r[0];
        let s, d;
        if ("borderBoxSize" in o) {
          const a = o.borderBoxSize, f = Array.isArray(a) ? a[0] : a;
          s = f.inlineSize, d = f.blockSize;
        } else
          s = l.offsetWidth, d = l.offsetHeight;
        u({ width: s, height: d });
      });
      return t.observe(l, { box: "border-box" }), () => t.unobserve(l);
    } else
      u(void 0);
  }, [l]), n;
}
var Xc = "Popper", [o5, a5] = IT(Xc), [AT, s5] = o5(Xc), d5 = (l) => {
  const { __scopePopper: n, children: u } = l, [t, r] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
  return /* @__PURE__ */ y.jsx(AT, { scope: n, anchor: t, onAnchorChange: r, children: u });
};
d5.displayName = Xc;
var c5 = "PopperAnchor", f5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const { __scopePopper: u, virtualRef: t, ...r } = l, o = s5(c5, u), s = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), d = Nt(n, s);
    return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
      o.onAnchorChange((t == null ? void 0 : t.current) || s.current);
    }), t ? null : /* @__PURE__ */ y.jsx(et.div, { ...r, ref: d });
  }
);
f5.displayName = c5;
var zc = "PopperContent", [ST, PT] = o5(zc), p5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    var ol, ml, Sl, Ol, Cl, Q;
    const {
      __scopePopper: u,
      side: t = "bottom",
      sideOffset: r = 0,
      align: o = "center",
      alignOffset: s = 0,
      arrowPadding: d = 0,
      avoidCollisions: a = !0,
      collisionBoundary: f = [],
      collisionPadding: p = 0,
      sticky: g = "partial",
      hideWhenDetached: m = !1,
      updatePositionStrategy: v = "optimized",
      onPlaced: $,
      ...b
    } = l, E = s5(zc, u), [S, A] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), x = Nt(n, (Xl) => A(Xl)), [I, P] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), O = i5(I), _ = (O == null ? void 0 : O.width) ?? 0, j = (O == null ? void 0 : O.height) ?? 0, z = t + (o !== "center" ? "-" + o : ""), Y = typeof p == "number" ? p : { top: 0, right: 0, bottom: 0, left: 0, ...p }, el = Array.isArray(f) ? f : [f], U = el.length > 0, ul = {
      padding: Y,
      boundary: el.filter(TT),
      // with `strategy: 'fixed'`, this is the only way to get it to respect boundaries
      altBoundary: U
    }, { refs: il, floatingStyles: rl, placement: tl, isPositioned: sl, middlewareData: ll } = g4({
      // default to `fixed` strategy so users don't have to pick and we also avoid focus scroll issues
      strategy: "fixed",
      placement: z,
      whileElementsMounted: (...Xl) => Cc(...Xl, {
        animationFrame: v === "always"
      }),
      elements: {
        reference: E.anchor
      },
      middleware: [
        h4({ mainAxis: r + j, alignmentAxis: s }),
        a && m4({
          mainAxis: !0,
          crossAxis: !1,
          limiter: g === "partial" ? v4() : void 0,
          ...ul
        }),
        a && b4({ ...ul }),
        y4({
          ...ul,
          apply: ({ elements: Xl, rects: Bl, availableWidth: Kl, availableHeight: fn }) => {
            const { width: dn, height: Fn } = Bl.reference, sn = Xl.floating.style;
            sn.setProperty("--radix-popper-available-width", `${Kl}px`), sn.setProperty("--radix-popper-available-height", `${fn}px`), sn.setProperty("--radix-popper-anchor-width", `${dn}px`), sn.setProperty("--radix-popper-anchor-height", `${Fn}px`);
          }
        }),
        I && x4({ element: I, padding: d }),
        RT({ arrowWidth: _, arrowHeight: j }),
        m && $4({ strategy: "referenceHidden", ...ul })
      ]
    }), [H, V] = m5(tl), X = ju($);
    Ln(() => {
      sl && (X == null || X());
    }, [sl, X]);
    const dl = (ol = ll.arrow) == null ? void 0 : ol.x, fl = (ml = ll.arrow) == null ? void 0 : ml.y, $l = ((Sl = ll.arrow) == null ? void 0 : Sl.centerOffset) !== 0, [cl, xl] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
    return Ln(() => {
      S && xl(window.getComputedStyle(S).zIndex);
    }, [S]), /* @__PURE__ */ y.jsx(
      "div",
      {
        ref: il.setFloating,
        "data-radix-popper-content-wrapper": "",
        style: {
          ...rl,
          transform: sl ? rl.transform : "translate(0, -200%)",
          // keep off the page when measuring
          minWidth: "max-content",
          zIndex: cl,
          "--radix-popper-transform-origin": [
            (Ol = ll.transformOrigin) == null ? void 0 : Ol.x,
            (Cl = ll.transformOrigin) == null ? void 0 : Cl.y
          ].join(" "),
          // hide the content if using the hide middleware and should be hidden
          // set visibility to hidden and disable pointer events so the UI behaves
          // as if the PopperContent isn't there at all
          ...((Q = ll.hide) == null ? void 0 : Q.referenceHidden) && {
            visibility: "hidden",
            pointerEvents: "none"
          }
        },
        dir: l.dir,
        children: /* @__PURE__ */ y.jsx(
          ST,
          {
            scope: u,
            placedSide: H,
            onArrowChange: P,
            arrowX: dl,
            arrowY: fl,
            shouldHideArrow: $l,
            children: /* @__PURE__ */ y.jsx(
              et.div,
              {
                "data-side": H,
                "data-align": V,
                ...b,
                ref: x,
                style: {
                  ...b.style,
                  // if the PopperContent hasn't been placed yet (not all measurements done)
                  // we prevent animations so that users's animation don't kick in too early referring wrong sides
                  animation: sl ? void 0 : "none"
                }
              }
            )
          }
        )
      }
    );
  }
);
p5.displayName = zc;
var g5 = "PopperArrow", NT = {
  top: "bottom",
  right: "left",
  bottom: "top",
  left: "right"
}, h5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function(n, u) {
  const { __scopePopper: t, ...r } = n, o = PT(g5, t), s = NT[o.placedSide];
  return (
    // we have to use an extra wrapper because `ResizeObserver` (used by `useSize`)
    // doesn't report size as we'd expect on SVG elements.
    // it reports their bounding box which is effectively the largest path inside the SVG.
    /* @__PURE__ */ y.jsx(
      "span",
      {
        ref: o.onArrowChange,
        style: {
          position: "absolute",
          left: o.arrowX,
          top: o.arrowY,
          [s]: 0,
          transformOrigin: {
            top: "",
            right: "0 0",
            bottom: "center 0",
            left: "100% 0"
          }[o.placedSide],
          transform: {
            top: "translateY(100%)",
            right: "translateY(50%) rotate(90deg) translateX(-50%)",
            bottom: "rotate(180deg)",
            left: "translateY(50%) rotate(-90deg) translateX(50%)"
          }[o.placedSide],
          visibility: o.shouldHideArrow ? "hidden" : void 0
        },
        children: /* @__PURE__ */ y.jsx(
          wT,
          {
            ...r,
            ref: u,
            style: {
              ...r.style,
              // ensures the element can be measured correctly (mostly for if SVG)
              display: "block"
            }
          }
        )
      }
    )
  );
});
h5.displayName = g5;
function TT(l) {
  return l !== null;
}
var RT = (l) => ({
  name: "transformOrigin",
  options: l,
  fn(n) {
    var E, S, A;
    const { placement: u, rects: t, middlewareData: r } = n, s = ((E = r.arrow) == null ? void 0 : E.centerOffset) !== 0, d = s ? 0 : l.arrowWidth, a = s ? 0 : l.arrowHeight, [f, p] = m5(u), g = { start: "0%", center: "50%", end: "100%" }[p], m = (((S = r.arrow) == null ? void 0 : S.x) ?? 0) + d / 2, v = (((A = r.arrow) == null ? void 0 : A.y) ?? 0) + a / 2;
    let $ = "", b = "";
    return f === "bottom" ? ($ = s ? g : `${m}px`, b = `${-a}px`) : f === "top" ? ($ = s ? g : `${m}px`, b = `${t.floating.height + a}px`) : f === "right" ? ($ = `${-a}px`, b = s ? g : `${v}px`) : f === "left" && ($ = `${t.floating.width + a}px`, b = s ? g : `${v}px`), { data: { x: $, y: b } };
  }
});
function m5(l) {
  const [n, u = "center"] = l.split("-");
  return [n, u];
}
var OT = d5, FT = f5, _T = p5, DT = h5, MT = "Portal", v5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  var d;
  const { container: u, ...t } = l, [r, o] = react__WEBPACK_IMPORTED_MODULE_0__.useState(!1);
  Ln(() => o(!0), []);
  const s = u || r && ((d = globalThis == null ? void 0 : globalThis.document) == null ? void 0 : d.body);
  return s ? react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal(/* @__PURE__ */ y.jsx(et.div, { ...t, ref: n }), s) : null;
});
v5.displayName = MT;
function BT(l, n) {
  return react__WEBPACK_IMPORTED_MODULE_0__.useReducer((u, t) => n[u][t] ?? u, l);
}
var Yc = (l) => {
  const { present: n, children: u } = l, t = LT(n), r = typeof u == "function" ? u({ present: t.isPresent }) : react__WEBPACK_IMPORTED_MODULE_0__.Children.only(u), o = Nt(t.ref, GT(r));
  return typeof u == "function" || t.isPresent ? react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(r, { ref: o }) : null;
};
Yc.displayName = "Presence";
function LT(l) {
  const [n, u] = react__WEBPACK_IMPORTED_MODULE_0__.useState(), t = react__WEBPACK_IMPORTED_MODULE_0__.useRef({}), r = react__WEBPACK_IMPORTED_MODULE_0__.useRef(l), o = react__WEBPACK_IMPORTED_MODULE_0__.useRef("none"), s = l ? "mounted" : "unmounted", [d, a] = BT(s, {
    mounted: {
      UNMOUNT: "unmounted",
      ANIMATION_OUT: "unmountSuspended"
    },
    unmountSuspended: {
      MOUNT: "mounted",
      ANIMATION_END: "unmounted"
    },
    unmounted: {
      MOUNT: "mounted"
    }
  });
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    const f = bo(t.current);
    o.current = d === "mounted" ? f : "none";
  }, [d]), Ln(() => {
    const f = t.current, p = r.current;
    if (p !== l) {
      const m = o.current, v = bo(f);
      l ? a("MOUNT") : v === "none" || (f == null ? void 0 : f.display) === "none" ? a("UNMOUNT") : a(p && m !== v ? "ANIMATION_OUT" : "UNMOUNT"), r.current = l;
    }
  }, [l, a]), Ln(() => {
    if (n) {
      let f;
      const p = n.ownerDocument.defaultView ?? window, g = (v) => {
        const b = bo(t.current).includes(v.animationName);
        if (v.target === n && b && (a("ANIMATION_END"), !r.current)) {
          const E = n.style.animationFillMode;
          n.style.animationFillMode = "forwards", f = p.setTimeout(() => {
            n.style.animationFillMode === "forwards" && (n.style.animationFillMode = E);
          });
        }
      }, m = (v) => {
        v.target === n && (o.current = bo(t.current));
      };
      return n.addEventListener("animationstart", m), n.addEventListener("animationcancel", g), n.addEventListener("animationend", g), () => {
        p.clearTimeout(f), n.removeEventListener("animationstart", m), n.removeEventListener("animationcancel", g), n.removeEventListener("animationend", g);
      };
    } else
      a("ANIMATION_END");
  }, [n, a]), {
    isPresent: ["mounted", "unmountSuspended"].includes(d),
    ref: react__WEBPACK_IMPORTED_MODULE_0__.useCallback((f) => {
      f && (t.current = getComputedStyle(f)), u(f);
    }, [])
  };
}
function bo(l) {
  return (l == null ? void 0 : l.animationName) || "none";
}
function GT(l) {
  var t, r;
  let n = (t = Object.getOwnPropertyDescriptor(l.props, "ref")) == null ? void 0 : t.get, u = n && "isReactWarning" in n && n.isReactWarning;
  return u ? l.ref : (n = (r = Object.getOwnPropertyDescriptor(l, "ref")) == null ? void 0 : r.get, u = n && "isReactWarning" in n && n.isReactWarning, u ? l.props.ref : l.props.ref || l.ref);
}
function ua({
  prop: l,
  defaultProp: n,
  onChange: u = () => {
  }
}) {
  const [t, r] = jT({ defaultProp: n, onChange: u }), o = l !== void 0, s = o ? l : t, d = ju(u), a = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(
    (f) => {
      if (o) {
        const g = typeof f == "function" ? f(l) : f;
        g !== l && d(g);
      } else
        r(f);
    },
    [o, l, r, d]
  );
  return [s, a];
}
function jT({
  defaultProp: l,
  onChange: n
}) {
  const u = react__WEBPACK_IMPORTED_MODULE_0__.useState(l), [t] = u, r = react__WEBPACK_IMPORTED_MODULE_0__.useRef(t), o = ju(n);
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    r.current !== t && (o(t), r.current = t);
  }, [t, r, o]), u;
}
var WT = "VisuallyHidden", b5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => /* @__PURE__ */ y.jsx(
    et.span,
    {
      ...l,
      ref: n,
      style: {
        // See: https://github.com/twbs/bootstrap/blob/master/scss/mixins/_screen-reader.scss
        position: "absolute",
        border: 0,
        width: 1,
        height: 1,
        padding: 0,
        margin: -1,
        overflow: "hidden",
        clip: "rect(0, 0, 0, 0)",
        whiteSpace: "nowrap",
        wordWrap: "normal",
        ...l.style
      }
    }
  )
);
b5.displayName = WT;
var VT = b5, [Sa, F_] = oi("Tooltip", [
  a5
]), Pa = a5(), y5 = "TooltipProvider", kT = 700, Jd = "tooltip.open", [HT, Uc] = Sa(y5), $5 = (l) => {
  const {
    __scopeTooltip: n,
    delayDuration: u = kT,
    skipDelayDuration: t = 300,
    disableHoverableContent: r = !1,
    children: o
  } = l, [s, d] = react__WEBPACK_IMPORTED_MODULE_0__.useState(!0), a = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1), f = react__WEBPACK_IMPORTED_MODULE_0__.useRef(0);
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    const p = f.current;
    return () => window.clearTimeout(p);
  }, []), /* @__PURE__ */ y.jsx(
    HT,
    {
      scope: n,
      isOpenDelayed: s,
      delayDuration: u,
      onOpen: react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
        window.clearTimeout(f.current), d(!1);
      }, []),
      onClose: react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
        window.clearTimeout(f.current), f.current = window.setTimeout(
          () => d(!0),
          t
        );
      }, [t]),
      isPointerInTransitRef: a,
      onPointerInTransitChange: react__WEBPACK_IMPORTED_MODULE_0__.useCallback((p) => {
        a.current = p;
      }, []),
      disableHoverableContent: r,
      children: o
    }
  );
};
$5.displayName = y5;
var Na = "Tooltip", [ZT, si] = Sa(Na), x5 = (l) => {
  const {
    __scopeTooltip: n,
    children: u,
    open: t,
    defaultOpen: r = !1,
    onOpenChange: o,
    disableHoverableContent: s,
    delayDuration: d
  } = l, a = Uc(Na, l.__scopeTooltip), f = Pa(n), [p, g] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), m = ai(), v = react__WEBPACK_IMPORTED_MODULE_0__.useRef(0), $ = s ?? a.disableHoverableContent, b = d ?? a.delayDuration, E = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1), [S = !1, A] = ua({
    prop: t,
    defaultProp: r,
    onChange: (_) => {
      _ ? (a.onOpen(), document.dispatchEvent(new CustomEvent(Jd))) : a.onClose(), o == null || o(_);
    }
  }), x = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => S ? E.current ? "delayed-open" : "instant-open" : "closed", [S]), I = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    window.clearTimeout(v.current), v.current = 0, E.current = !1, A(!0);
  }, [A]), P = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    window.clearTimeout(v.current), v.current = 0, A(!1);
  }, [A]), O = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    window.clearTimeout(v.current), v.current = window.setTimeout(() => {
      E.current = !0, A(!0), v.current = 0;
    }, b);
  }, [b, A]);
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => () => {
    v.current && (window.clearTimeout(v.current), v.current = 0);
  }, []), /* @__PURE__ */ y.jsx(OT, { ...f, children: /* @__PURE__ */ y.jsx(
    ZT,
    {
      scope: n,
      contentId: m,
      open: S,
      stateAttribute: x,
      trigger: p,
      onTriggerChange: g,
      onTriggerEnter: react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
        a.isOpenDelayed ? O() : I();
      }, [a.isOpenDelayed, O, I]),
      onTriggerLeave: react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
        $ ? P() : (window.clearTimeout(v.current), v.current = 0);
      }, [P, $]),
      onOpen: I,
      onClose: P,
      disableHoverableContent: $,
      children: u
    }
  ) });
};
x5.displayName = Na;
var Kd = "TooltipTrigger", C5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const { __scopeTooltip: u, ...t } = l, r = si(Kd, u), o = Uc(Kd, u), s = Pa(u), d = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), a = Nt(n, d, r.onTriggerChange), f = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1), p = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1), g = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => f.current = !1, []);
    return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => () => document.removeEventListener("pointerup", g), [g]), /* @__PURE__ */ y.jsx(FT, { asChild: !0, ...s, children: /* @__PURE__ */ y.jsx(
      et.button,
      {
        "aria-describedby": r.open ? r.contentId : void 0,
        "data-state": r.stateAttribute,
        ...t,
        ref: a,
        onPointerMove: Ee(l.onPointerMove, (m) => {
          m.pointerType !== "touch" && !p.current && !o.isPointerInTransitRef.current && (r.onTriggerEnter(), p.current = !0);
        }),
        onPointerLeave: Ee(l.onPointerLeave, () => {
          r.onTriggerLeave(), p.current = !1;
        }),
        onPointerDown: Ee(l.onPointerDown, () => {
          f.current = !0, document.addEventListener("pointerup", g, { once: !0 });
        }),
        onFocus: Ee(l.onFocus, () => {
          f.current || r.onOpen();
        }),
        onBlur: Ee(l.onBlur, r.onClose),
        onClick: Ee(l.onClick, r.onClose)
      }
    ) });
  }
);
C5.displayName = Kd;
var Jc = "TooltipPortal", [XT, zT] = Sa(Jc, {
  forceMount: void 0
}), w5 = (l) => {
  const { __scopeTooltip: n, forceMount: u, children: t, container: r } = l, o = si(Jc, n);
  return /* @__PURE__ */ y.jsx(XT, { scope: n, forceMount: u, children: /* @__PURE__ */ y.jsx(Yc, { present: u || o.open, children: /* @__PURE__ */ y.jsx(v5, { asChild: !0, container: r, children: t }) }) });
};
w5.displayName = Jc;
var rr = "TooltipContent", I5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const u = zT(rr, l.__scopeTooltip), { forceMount: t = u.forceMount, side: r = "top", ...o } = l, s = si(rr, l.__scopeTooltip);
    return /* @__PURE__ */ y.jsx(Yc, { present: t || s.open, children: s.disableHoverableContent ? /* @__PURE__ */ y.jsx(E5, { side: r, ...o, ref: n }) : /* @__PURE__ */ y.jsx(YT, { side: r, ...o, ref: n }) });
  }
), YT = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const u = si(rr, l.__scopeTooltip), t = Uc(rr, l.__scopeTooltip), r = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), o = Nt(n, r), [s, d] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), { trigger: a, onClose: f } = u, p = r.current, { onPointerInTransitChange: g } = t, m = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    d(null), g(!1);
  }, [g]), v = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(
    ($, b) => {
      const E = $.currentTarget, S = { x: $.clientX, y: $.clientY }, A = KT(S, E.getBoundingClientRect()), x = QT(S, A), I = qT(b.getBoundingClientRect()), P = nR([...x, ...I]);
      d(P), g(!0);
    },
    [g]
  );
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => () => m(), [m]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (a && p) {
      const $ = (E) => v(E, p), b = (E) => v(E, a);
      return a.addEventListener("pointerleave", $), p.addEventListener("pointerleave", b), () => {
        a.removeEventListener("pointerleave", $), p.removeEventListener("pointerleave", b);
      };
    }
  }, [a, p, v, m]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (s) {
      const $ = (b) => {
        const E = b.target, S = { x: b.clientX, y: b.clientY }, A = (a == null ? void 0 : a.contains(E)) || (p == null ? void 0 : p.contains(E)), x = !lR(S, s);
        A ? m() : x && (m(), f());
      };
      return document.addEventListener("pointermove", $), () => document.removeEventListener("pointermove", $);
    }
  }, [a, p, s, f, m]), /* @__PURE__ */ y.jsx(E5, { ...l, ref: o });
}), [UT, JT] = Sa(Na, { isInside: !1 }), E5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const {
      __scopeTooltip: u,
      children: t,
      "aria-label": r,
      onEscapeKeyDown: o,
      onPointerDownOutside: s,
      ...d
    } = l, a = si(rr, u), f = Pa(u), { onClose: p } = a;
    return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => (document.addEventListener(Jd, p), () => document.removeEventListener(Jd, p)), [p]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
      if (a.trigger) {
        const g = (m) => {
          const v = m.target;
          v != null && v.contains(a.trigger) && p();
        };
        return window.addEventListener("scroll", g, { capture: !0 }), () => window.removeEventListener("scroll", g, { capture: !0 });
      }
    }, [a.trigger, p]), /* @__PURE__ */ y.jsx(
      e5,
      {
        asChild: !0,
        disableOutsidePointerEvents: !1,
        onEscapeKeyDown: o,
        onPointerDownOutside: s,
        onFocusOutside: (g) => g.preventDefault(),
        onDismiss: p,
        children: /* @__PURE__ */ y.jsxs(
          _T,
          {
            "data-state": a.stateAttribute,
            ...f,
            ...d,
            ref: n,
            style: {
              ...d.style,
              "--radix-tooltip-content-transform-origin": "var(--radix-popper-transform-origin)",
              "--radix-tooltip-content-available-width": "var(--radix-popper-available-width)",
              "--radix-tooltip-content-available-height": "var(--radix-popper-available-height)",
              "--radix-tooltip-trigger-width": "var(--radix-popper-anchor-width)",
              "--radix-tooltip-trigger-height": "var(--radix-popper-anchor-height)"
            },
            children: [
              /* @__PURE__ */ y.jsx(l5, { children: t }),
              /* @__PURE__ */ y.jsx(UT, { scope: u, isInside: !0, children: /* @__PURE__ */ y.jsx(VT, { id: a.contentId, role: "tooltip", children: r || t }) })
            ]
          }
        )
      }
    );
  }
);
I5.displayName = rr;
var A5 = "TooltipArrow", S5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const { __scopeTooltip: u, ...t } = l, r = Pa(u);
    return JT(
      A5,
      u
    ).isInside ? null : /* @__PURE__ */ y.jsx(DT, { ...r, ...t, ref: n });
  }
);
S5.displayName = A5;
function KT(l, n) {
  const u = Math.abs(n.top - l.y), t = Math.abs(n.bottom - l.y), r = Math.abs(n.right - l.x), o = Math.abs(n.left - l.x);
  switch (Math.min(u, t, r, o)) {
    case o:
      return "left";
    case r:
      return "right";
    case u:
      return "top";
    case t:
      return "bottom";
    default:
      throw new Error("unreachable");
  }
}
function QT(l, n, u = 5) {
  const t = [];
  switch (n) {
    case "top":
      t.push(
        { x: l.x - u, y: l.y + u },
        { x: l.x + u, y: l.y + u }
      );
      break;
    case "bottom":
      t.push(
        { x: l.x - u, y: l.y - u },
        { x: l.x + u, y: l.y - u }
      );
      break;
    case "left":
      t.push(
        { x: l.x + u, y: l.y - u },
        { x: l.x + u, y: l.y + u }
      );
      break;
    case "right":
      t.push(
        { x: l.x - u, y: l.y - u },
        { x: l.x - u, y: l.y + u }
      );
      break;
  }
  return t;
}
function qT(l) {
  const { top: n, right: u, bottom: t, left: r } = l;
  return [
    { x: r, y: n },
    { x: u, y: n },
    { x: u, y: t },
    { x: r, y: t }
  ];
}
function lR(l, n) {
  const { x: u, y: t } = l;
  let r = !1;
  for (let o = 0, s = n.length - 1; o < n.length; s = o++) {
    const d = n[o].x, a = n[o].y, f = n[s].x, p = n[s].y;
    a > t != p > t && u < (f - d) * (t - a) / (p - a) + d && (r = !r);
  }
  return r;
}
function nR(l) {
  const n = l.slice();
  return n.sort((u, t) => u.x < t.x ? -1 : u.x > t.x ? 1 : u.y < t.y ? -1 : u.y > t.y ? 1 : 0), uR(n);
}
function uR(l) {
  if (l.length <= 1) return l.slice();
  const n = [];
  for (let t = 0; t < l.length; t++) {
    const r = l[t];
    for (; n.length >= 2; ) {
      const o = n[n.length - 1], s = n[n.length - 2];
      if ((o.x - s.x) * (r.y - s.y) >= (o.y - s.y) * (r.x - s.x)) n.pop();
      else break;
    }
    n.push(r);
  }
  n.pop();
  const u = [];
  for (let t = l.length - 1; t >= 0; t--) {
    const r = l[t];
    for (; u.length >= 2; ) {
      const o = u[u.length - 1], s = u[u.length - 2];
      if ((o.x - s.x) * (r.y - s.y) >= (o.y - s.y) * (r.x - s.x)) u.pop();
      else break;
    }
    u.push(r);
  }
  return u.pop(), n.length === 1 && u.length === 1 && n[0].x === u[0].x && n[0].y === u[0].y ? n : n.concat(u);
}
var eR = $5, tR = x5, rR = C5, iR = w5, oR = I5, aR = S5;
function __({ direction: l = "top", children: n, content: u, contentClass: t }) {
  return /* @__PURE__ */ y.jsx(eR, { delayDuration: 0, children: /* @__PURE__ */ y.jsxs(tR, { children: [
    /* @__PURE__ */ y.jsx(rR, { asChild: !0, children: n }),
    /* @__PURE__ */ y.jsx(iR, { children: /* @__PURE__ */ y.jsxs(
      oR,
      {
        sideOffset: 5,
        className: Oe(
          "text-gray-50 z-50 select-none rounded-[4px] bg-black px-2 py-1.5 text-xs leading-none text-white will-change-[transform,opacity] data-[state=delayed-open]:data-[side=bottom]:animate-slide-up-fade data-[state=delayed-open]:data-[side=left]:animate-slide-right-fade data-[state=delayed-open]:data-[side=right]:animate-slide-left-fade data-[state=delayed-open]:data-[side=top]:animate-slide-down-fade",
          t
        ),
        side: l,
        align: "center",
        children: [
          u,
          /* @__PURE__ */ y.jsx(aR, { className: "fill-black" })
        ]
      }
    ) })
  ] }) });
}
function b3(l, n) {
  if (typeof l == "function")
    return l(n);
  l != null && (l.current = n);
}
function P5(...l) {
  return (n) => {
    let u = !1;
    const t = l.map((r) => {
      const o = b3(r, n);
      return !u && typeof o == "function" && (u = !0), o;
    });
    if (u)
      return () => {
        for (let r = 0; r < t.length; r++) {
          const o = t[r];
          typeof o == "function" ? o() : b3(l[r], null);
        }
      };
  };
}
function Gn(...l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(P5(...l), l);
}
var ir = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const { children: u, ...t } = l, r = react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(u), o = r.find(dR);
  if (o) {
    const s = o.props.children, d = r.map((a) => a === o ? react__WEBPACK_IMPORTED_MODULE_0__.Children.count(s) > 1 ? react__WEBPACK_IMPORTED_MODULE_0__.Children.only(null) : react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(s) ? s.props.children : null : a);
    return /* @__PURE__ */ y.jsx(Qd, { ...t, ref: n, children: react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(s) ? react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(s, void 0, d) : null });
  }
  return /* @__PURE__ */ y.jsx(Qd, { ...t, ref: n, children: u });
});
ir.displayName = "Slot";
var Qd = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const { children: u, ...t } = l;
  if (react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(u)) {
    const r = fR(u), o = cR(t, u.props);
    return u.type !== react__WEBPACK_IMPORTED_MODULE_0__.Fragment && (o.ref = n ? P5(n, r) : r), react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(u, o);
  }
  return react__WEBPACK_IMPORTED_MODULE_0__.Children.count(u) > 1 ? react__WEBPACK_IMPORTED_MODULE_0__.Children.only(null) : null;
});
Qd.displayName = "SlotClone";
var sR = ({ children: l }) => /* @__PURE__ */ y.jsx(y.Fragment, { children: l });
function dR(l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(l) && l.type === sR;
}
function cR(l, n) {
  const u = { ...n };
  for (const t in n) {
    const r = l[t], o = n[t];
    /^on[A-Z]/.test(t) ? r && o ? u[t] = (...d) => {
      o(...d), r(...d);
    } : r && (u[t] = r) : t === "style" ? u[t] = { ...r, ...o } : t === "className" && (u[t] = [r, o].filter(Boolean).join(" "));
  }
  return { ...l, ...u };
}
function fR(l) {
  var t, r;
  let n = (t = Object.getOwnPropertyDescriptor(l.props, "ref")) == null ? void 0 : t.get, u = n && "isReactWarning" in n && n.isReactWarning;
  return u ? l.ref : (n = (r = Object.getOwnPropertyDescriptor(l, "ref")) == null ? void 0 : r.get, u = n && "isReactWarning" in n && n.isReactWarning, u ? l.props.ref : l.props.ref || l.ref);
}
var pR = [
  "a",
  "button",
  "div",
  "form",
  "h2",
  "h3",
  "img",
  "input",
  "label",
  "li",
  "nav",
  "ol",
  "p",
  "span",
  "svg",
  "ul"
], An = pR.reduce((l, n) => {
  const u = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((t, r) => {
    const { asChild: o, ...s } = t, d = o ? ir : n;
    return typeof window < "u" && (window[Symbol.for("radix-ui")] = !0), /* @__PURE__ */ y.jsx(d, { ...s, ref: r });
  });
  return u.displayName = `Primitive.${n}`, { ...l, [n]: u };
}, {});
function gR(l, n) {
  l && react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync(() => l.dispatchEvent(n));
}
var hR = "Label", N5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => /* @__PURE__ */ y.jsx(
  An.label,
  {
    ...l,
    ref: n,
    onMouseDown: (u) => {
      var r;
      u.target.closest("button, input, select, textarea") || ((r = l.onMouseDown) == null || r.call(l, u), !u.defaultPrevented && u.detail > 1 && u.preventDefault());
    }
  }
));
N5.displayName = hR;
var mR = N5;
const T5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  ({ className: l, ...n }, u) => /* @__PURE__ */ y.jsx(
    mR,
    {
      ref: u,
      className: wl(
        "cursor-pointer text-sm font-medium leading-[21px] text-gray-900 peer-disabled:cursor-not-allowed peer-disabled:opacity-50",
        l
      ),
      ...n
    }
  )
);
T5.displayName = "FormLabel";
let yo;
const vR = (l, n) => {
  var r, o;
  if ((o = (r = window.google) == null ? void 0 : r.maps) != null && o.places) {
    n();
    return;
  }
  const u = document.createElement("script"), t = document.createElement("script");
  t.type = "text/javascript", t.textContent = "function initMapPlaceholderFunc() {}", u.type = "text/javascript", u.src = l, document.body.appendChild(t), document.body.appendChild(u), u.onload = () => n();
}, D_ = ({
  label: l,
  apiKey: n,
  input: u,
  className: t,
  errors: r,
  onPlaceSelected: o,
  countryRestriction: s,
  value: d,
  onClear: a,
  onFocus: f,
  onBlur: p,
  showClear: g = !0,
  disabled: m
}) => {
  const v = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), $ = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), b = () => {
    var z;
    const A = yo.getPlace(), x = $.current.value;
    A && A.name ? $.current.value = A.name : $.current.value = x;
    const I = ie.get(A, "address_components");
    let P = "", O = "", _ = "", j = { long_name: "", short_name: "" };
    ie.forEach(I, function(Y) {
      const el = ie.get(Y, "types");
      ie.includes(el, "country") && (j = Y), ie.includes(el, "locality") && (P = ie.get(Y, "long_name")), ie.includes(el, "administrative_area_level_1") && (O = ie.get(Y, "long_name")), ie.includes(el, "postal_code") && (_ = ie.get(Y, "long_name"));
    }), o({
      city: P ?? "",
      state: O ?? "",
      zip: _ ?? "",
      country: j ?? { long_name: "", short_name: "" },
      address: ((z = $.current) == null ? void 0 : z.value) ?? "",
      place: A,
      inputValue: x
    });
  }, E = (A, x) => {
    const { maps: I } = window.google;
    yo = new I.places.Autocomplete(A.current), x && yo.setComponentRestrictions({
      country: x
    }), yo.addListener("place_changed", () => b());
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    $.current && d && ($.current.value = d);
  }, [d]), (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const A = `https://maps.googleapis.com/maps/api/js?key=${n}&libraries=places&language=en&callback=initMapPlaceholderFunc`;
    vR(A, () => E($, s));
  }, [s]);
  const S = !!(r && r.length > 0);
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    typeof l == "string" ? /* @__PURE__ */ y.jsx(
      T5,
      {
        htmlFor: (u == null ? void 0 : u.id) ?? v,
        className: wl("mb-2 inline-block", m && "cursor-not-allowed opacity-50"),
        children: l
      }
    ) : l,
    /* @__PURE__ */ y.jsxs("div", { className: "relative flex", children: [
      /* @__PURE__ */ y.jsx(
        "input",
        {
          id: (u == null ? void 0 : u.id) ?? v,
          className: wl(
            "w-full h-10 rounded border-0 px-4 py-2.5 text-sm leading-5 text-gray-800 ring-1 focus:ring-2 ring-gray-200 placeholder:text-gray-400 focus:ring-primary-600 disabled:cursor-not-allowed disabled:opacity-50",
            S && "ring-red-500 focus:ring-red-500 hasErrors",
            t
          ),
          ...u,
          disabled: m,
          ref: $,
          onFocus: f,
          onBlur: p
        }
      ),
      d && d.toString().length && g && /* @__PURE__ */ y.jsx("div", { className: "absolute right-2 top-1/2 -translate-y-1/2", children: /* @__PURE__ */ y.jsx(
        "button",
        {
          type: "button",
          onClick: () => {
            $.current.value = "", a && a();
          },
          className: "inset-y-0 right-0 text-sm flex items-center me-3 text-gray-400",
          children: "Clear"
        }
      ) })
    ] }),
    /* @__PURE__ */ y.jsx(Pu, { value: r ?? [] })
  ] });
}, M_ = ({ loading: l = !0, children: n, height: u }) => /* @__PURE__ */ y.jsx(y.Fragment, { children: l ? /* @__PURE__ */ y.jsx("div", { className: "loader flex items-center justify-center", style: { height: u || "100px" }, children: /* @__PURE__ */ y.jsxs("div", { className: "lds-ellipsis", children: [
  /* @__PURE__ */ y.jsx("div", {}),
  /* @__PURE__ */ y.jsx("div", {}),
  /* @__PURE__ */ y.jsx("div", {}),
  /* @__PURE__ */ y.jsx("div", {})
] }) }) : n });
(function() {
  function l(R, G) {
    var W = R.split("."), al = xl;
    W[0] in al || !al.execScript || al.execScript("var " + W[0]);
    for (var Pl; W.length && (Pl = W.shift()); ) W.length || G === void 0 ? al = al[Pl] ? al[Pl] : al[Pl] = {} : al[Pl] = G;
  }
  function n(R, G) {
    function W() {
    }
    W.prototype = G.prototype, R.M = G.prototype, R.prototype = new W(), R.prototype.constructor = R, R.N = function(al, Pl, Fl) {
      for (var on = Array(arguments.length - 2), xn = 2; xn < arguments.length; xn++) on[xn - 2] = arguments[xn];
      return G.prototype[Pl].apply(al, on);
    };
  }
  function u(R, G) {
    R != null && this.a.apply(this, arguments);
  }
  function t(R) {
    R.b = "";
  }
  function r(R, G) {
    R.sort(G || o);
  }
  function o(R, G) {
    return R > G ? 1 : R < G ? -1 : 0;
  }
  function s(R) {
    var G, W = [], al = 0;
    for (G in R) W[al++] = R[G];
    return W;
  }
  function d(R, G) {
    this.b = R, this.a = {};
    for (var W = 0; W < G.length; W++) {
      var al = G[W];
      this.a[al.b] = al;
    }
  }
  function a(R) {
    return R = s(R.a), r(R, function(G, W) {
      return G.b - W.b;
    }), R;
  }
  function f(R, G) {
    switch (this.b = R, this.g = !!G.v, this.a = G.c, this.i = G.type, this.h = !1, this.a) {
      case Sl:
      case Ol:
      case Cl:
      case Q:
      case Xl:
      case ml:
      case ol:
        this.h = !0;
    }
    this.f = G.defaultValue;
  }
  function p() {
    this.a = {}, this.f = this.j().a, this.b = this.g = null;
  }
  function g(R, G) {
    for (var W = a(R.j()), al = 0; al < W.length; al++) {
      var Pl = W[al], Fl = Pl.b;
      if (G.a[Fl] != null) {
        R.b && delete R.b[Pl.b];
        var on = Pl.a == 11 || Pl.a == 10;
        if (Pl.g) for (var Pl = m(G, Fl) || [], xn = 0; xn < Pl.length; xn++) {
          var Dn = R, ku = Fl, at = on ? Pl[xn].clone() : Pl[xn];
          Dn.a[ku] || (Dn.a[ku] = []), Dn.a[ku].push(at), Dn.b && delete Dn.b[ku];
        }
        else Pl = m(G, Fl), on ? (on = m(R, Fl)) ? g(on, Pl) : E(R, Fl, Pl.clone()) : E(R, Fl, Pl);
      }
    }
  }
  function m(R, G) {
    var W = R.a[G];
    if (W == null) return null;
    if (R.g) {
      if (!(G in R.b)) {
        var al = R.g, Pl = R.f[G];
        if (W != null) if (Pl.g) {
          for (var Fl = [], on = 0; on < W.length; on++) Fl[on] = al.b(Pl, W[on]);
          W = Fl;
        } else W = al.b(Pl, W);
        return R.b[G] = W;
      }
      return R.b[G];
    }
    return W;
  }
  function v(R, G, W) {
    var al = m(R, G);
    return R.f[G].g ? al[W || 0] : al;
  }
  function $(R, G) {
    var W;
    if (R.a[G] != null) W = v(R, G, void 0);
    else l: {
      if (W = R.f[G], W.f === void 0) {
        var al = W.i;
        if (al === Boolean) W.f = !1;
        else if (al === Number) W.f = 0;
        else {
          if (al !== String) {
            W = new al();
            break l;
          }
          W.f = W.h ? "0" : "";
        }
      }
      W = W.f;
    }
    return W;
  }
  function b(R, G) {
    return R.f[G].g ? R.a[G] != null ? R.a[G].length : 0 : R.a[G] != null ? 1 : 0;
  }
  function E(R, G, W) {
    R.a[G] = W, R.b && (R.b[G] = W);
  }
  function S(R, G) {
    var W, al = [];
    for (W in G) W != 0 && al.push(new f(W, G[W]));
    return new d(R, al);
  }
  function A() {
    p.call(this);
  }
  function x() {
    p.call(this);
  }
  function I() {
    p.call(this);
  }
  function P() {
  }
  function O() {
  }
  function _() {
  }
  function j() {
    this.a = {};
  }
  function z(R) {
    return R.length == 0 || ne.test(R);
  }
  function Y(R, G) {
    if (G == null) return null;
    G = G.toUpperCase();
    var W = R.a[G];
    if (W == null) {
      if (W = sn[G], W == null) return null;
      W = new _().a(I.j(), W), R.a[G] = W;
    }
    return W;
  }
  function el(R) {
    return R = Fn[R], R == null ? "ZZ" : R[0];
  }
  function U(R) {
    this.H = RegExp(" "), this.C = "", this.m = new u(), this.w = "", this.i = new u(), this.u = new u(), this.l = !0, this.A = this.o = this.F = !1, this.G = j.b(), this.s = 0, this.b = new u(), this.B = !1, this.h = "", this.a = new u(), this.f = [], this.D = R, this.J = this.g = ul(this, this.D);
  }
  function ul(R, G) {
    var W;
    if (G != null && isNaN(G) && G.toUpperCase() in sn) {
      if (W = Y(R.G, G), W == null) throw Error("Invalid region code: " + G);
      W = $(W, 10);
    } else W = 0;
    return W = Y(R.G, el(W)), W ?? _e;
  }
  function il(R) {
    for (var G = R.f.length, W = 0; W < G; ++W) {
      var al = R.f[W], Pl = $(al, 1);
      if (R.w == Pl) return !1;
      var Fl;
      Fl = R;
      var on = al, xn = $(on, 1);
      if (xn.indexOf("|") != -1) Fl = !1;
      else {
        xn = xn.replace(Nu, "\\d"), xn = xn.replace(ue, "\\d"), t(Fl.m);
        var Dn;
        Dn = Fl;
        var on = $(on, 2), ku = "999999999999999".match(xn)[0];
        ku.length < Dn.a.b.length ? Dn = "" : (Dn = ku.replace(new RegExp(xn, "g"), on), Dn = Dn.replace(RegExp("9", "g"), " ")), 0 < Dn.length ? (Fl.m.a(Dn), Fl = !0) : Fl = !1;
      }
      if (Fl) return R.w = Pl, R.B = mu.test(v(al, 4)), R.s = 0, !0;
    }
    return R.l = !1;
  }
  function rl(R, G) {
    for (var W = [], al = G.length - 3, Pl = R.f.length, Fl = 0; Fl < Pl; ++Fl) {
      var on = R.f[Fl];
      b(on, 3) == 0 ? W.push(R.f[Fl]) : (on = v(on, 3, Math.min(al, b(on, 3) - 1)), G.search(on) == 0 && W.push(R.f[Fl]));
    }
    R.f = W;
  }
  function tl(R, G) {
    R.i.a(G);
    var W = G;
    if (Zn.test(W) || R.i.b.length == 1 && _n.test(W)) {
      var al, W = G;
      W == "+" ? (al = W, R.u.a(W)) : (al = gn[W], R.u.a(al), R.a.a(al)), G = al;
    } else R.l = !1, R.F = !0;
    if (!R.l) {
      if (!R.F) {
        if (fl(R)) {
          if ($l(R)) return sl(R);
        } else if (0 < R.h.length && (W = R.a.toString(), t(R.a), R.a.a(R.h), R.a.a(W), W = R.b.toString(), al = W.lastIndexOf(R.h), t(R.b), R.b.a(W.substring(0, al))), R.h != dl(R)) return R.b.a(" "), sl(R);
      }
      return R.i.toString();
    }
    switch (R.u.b.length) {
      case 0:
      case 1:
      case 2:
        return R.i.toString();
      case 3:
        if (!fl(R)) return R.h = dl(R), V(R);
        R.A = !0;
      default:
        return R.A ? ($l(R) && (R.A = !1), R.b.toString() + R.a.toString()) : 0 < R.f.length ? (W = cl(R, G), al = ll(R), 0 < al.length ? al : (rl(R, R.a.toString()), il(R) ? X(R) : R.l ? H(R, W) : R.i.toString())) : V(R);
    }
  }
  function sl(R) {
    return R.l = !0, R.A = !1, R.f = [], R.s = 0, t(R.m), R.w = "", V(R);
  }
  function ll(R) {
    for (var G = R.a.toString(), W = R.f.length, al = 0; al < W; ++al) {
      var Pl = R.f[al], Fl = $(Pl, 1);
      if (new RegExp("^(?:" + Fl + ")$").test(G)) return R.B = mu.test(v(Pl, 4)), G = G.replace(new RegExp(Fl, "g"), v(Pl, 2)), H(R, G);
    }
    return "";
  }
  function H(R, G) {
    var W = R.b.b.length;
    return R.B && 0 < W && R.b.toString().charAt(W - 1) != " " ? R.b + " " + G : R.b + G;
  }
  function V(R) {
    var G = R.a.toString();
    if (3 <= G.length) {
      for (var W = R.o && R.h.length == 0 && 0 < b(R.g, 20) ? m(R.g, 20) || [] : m(R.g, 19) || [], al = W.length, Pl = 0; Pl < al; ++Pl) {
        var Fl = W[Pl];
        0 < R.h.length && z($(Fl, 4)) && !v(Fl, 6) && Fl.a[5] == null || (R.h.length != 0 || R.o || z($(Fl, 4)) || v(Fl, 6)) && Kn.test($(Fl, 2)) && R.f.push(Fl);
      }
      return rl(R, G), G = ll(R), 0 < G.length ? G : il(R) ? X(R) : R.i.toString();
    }
    return H(R, G);
  }
  function X(R) {
    var G = R.a.toString(), W = G.length;
    if (0 < W) {
      for (var al = "", Pl = 0; Pl < W; Pl++) al = cl(R, G.charAt(Pl));
      return R.l ? H(R, al) : R.i.toString();
    }
    return R.b.toString();
  }
  function dl(R) {
    var G, W = R.a.toString(), al = 0;
    return v(R.g, 10) != 1 ? G = !1 : (G = R.a.toString(), G = G.charAt(0) == "1" && G.charAt(1) != "0" && G.charAt(1) != "1"), G ? (al = 1, R.b.a("1").a(" "), R.o = !0) : R.g.a[15] != null && (G = new RegExp("^(?:" + v(R.g, 15) + ")"), G = W.match(G), G != null && G[0] != null && 0 < G[0].length && (R.o = !0, al = G[0].length, R.b.a(W.substring(0, al)))), t(R.a), R.a.a(W.substring(al)), W.substring(0, al);
  }
  function fl(R) {
    var G = R.u.toString(), W = new RegExp("^(?:\\+|" + v(R.g, 11) + ")"), W = G.match(W);
    return W != null && W[0] != null && 0 < W[0].length && (R.o = !0, W = W[0].length, t(R.a), R.a.a(G.substring(W)), t(R.b), R.b.a(G.substring(0, W)), G.charAt(0) != "+" && R.b.a(" "), !0);
  }
  function $l(R) {
    if (R.a.b.length == 0) return !1;
    var G, W = new u();
    l: {
      if (G = R.a.toString(), G.length != 0 && G.charAt(0) != "0") {
        for (var al, Pl = G.length, Fl = 1; 3 >= Fl && Fl <= Pl; ++Fl) if (al = parseInt(G.substring(0, Fl), 10), al in Fn) {
          W.a(G.substring(Fl)), G = al;
          break l;
        }
      }
      G = 0;
    }
    return G != 0 && (t(R.a), R.a.a(W.toString()), W = el(G), W == "001" ? R.g = Y(R.G, "" + G) : W != R.D && (R.g = ul(R, W)), R.b.a("" + G).a(" "), R.h = "", !0);
  }
  function cl(R, G) {
    var W = R.m.toString();
    if (0 <= W.substring(R.s).search(R.H)) {
      var al = W.search(R.H), W = W.replace(R.H, G);
      return t(R.m), R.m.a(W), R.s = al, W.substring(0, R.s + 1);
    }
    return R.f.length == 1 && (R.l = !1), R.w = "", R.i.toString();
  }
  var xl = this;
  u.prototype.b = "", u.prototype.set = function(R) {
    this.b = "" + R;
  }, u.prototype.a = function(R, G, W) {
    if (this.b += String(R), G != null) for (var al = 1; al < arguments.length; al++) this.b += arguments[al];
    return this;
  }, u.prototype.toString = function() {
    return this.b;
  };
  var ol = 1, ml = 2, Sl = 3, Ol = 4, Cl = 6, Q = 16, Xl = 18;
  p.prototype.set = function(R, G) {
    E(this, R.b, G);
  }, p.prototype.clone = function() {
    var R = new this.constructor();
    return R != this && (R.a = {}, R.b && (R.b = {}), g(R, this)), R;
  }, n(A, p);
  var Bl = null;
  n(x, p);
  var Kl = null;
  n(I, p);
  var fn = null;
  A.prototype.j = function() {
    var R = Bl;
    return R || (Bl = R = S(A, { 0: { name: "NumberFormat", I: "i18n.phonenumbers.NumberFormat" }, 1: { name: "pattern", required: !0, c: 9, type: String }, 2: { name: "format", required: !0, c: 9, type: String }, 3: { name: "leading_digits_pattern", v: !0, c: 9, type: String }, 4: { name: "national_prefix_formatting_rule", c: 9, type: String }, 6: { name: "national_prefix_optional_when_formatting", c: 8, defaultValue: !1, type: Boolean }, 5: { name: "domestic_carrier_code_formatting_rule", c: 9, type: String } })), R;
  }, A.j = A.prototype.j, x.prototype.j = function() {
    var R = Kl;
    return R || (Kl = R = S(x, { 0: { name: "PhoneNumberDesc", I: "i18n.phonenumbers.PhoneNumberDesc" }, 2: { name: "national_number_pattern", c: 9, type: String }, 9: { name: "possible_length", v: !0, c: 5, type: Number }, 10: { name: "possible_length_local_only", v: !0, c: 5, type: Number }, 6: { name: "example_number", c: 9, type: String } })), R;
  }, x.j = x.prototype.j, I.prototype.j = function() {
    var R = fn;
    return R || (fn = R = S(I, { 0: { name: "PhoneMetadata", I: "i18n.phonenumbers.PhoneMetadata" }, 1: { name: "general_desc", c: 11, type: x }, 2: { name: "fixed_line", c: 11, type: x }, 3: { name: "mobile", c: 11, type: x }, 4: { name: "toll_free", c: 11, type: x }, 5: { name: "premium_rate", c: 11, type: x }, 6: { name: "shared_cost", c: 11, type: x }, 7: { name: "personal_number", c: 11, type: x }, 8: { name: "voip", c: 11, type: x }, 21: { name: "pager", c: 11, type: x }, 25: { name: "uan", c: 11, type: x }, 27: { name: "emergency", c: 11, type: x }, 28: { name: "voicemail", c: 11, type: x }, 29: { name: "short_code", c: 11, type: x }, 30: { name: "standard_rate", c: 11, type: x }, 31: { name: "carrier_specific", c: 11, type: x }, 33: { name: "sms_services", c: 11, type: x }, 24: { name: "no_international_dialling", c: 11, type: x }, 9: { name: "id", required: !0, c: 9, type: String }, 10: { name: "country_code", c: 5, type: Number }, 11: { name: "international_prefix", c: 9, type: String }, 17: { name: "preferred_international_prefix", c: 9, type: String }, 12: { name: "national_prefix", c: 9, type: String }, 13: { name: "preferred_extn_prefix", c: 9, type: String }, 15: { name: "national_prefix_for_parsing", c: 9, type: String }, 16: { name: "national_prefix_transform_rule", c: 9, type: String }, 18: { name: "same_mobile_and_fixed_line_pattern", c: 8, defaultValue: !1, type: Boolean }, 19: { name: "number_format", v: !0, c: 11, type: A }, 20: { name: "intl_number_format", v: !0, c: 11, type: A }, 22: { name: "main_country_for_code", c: 8, defaultValue: !1, type: Boolean }, 23: { name: "leading_digits", c: 9, type: String }, 26: { name: "leading_zero_possible", c: 8, defaultValue: !1, type: Boolean } })), R;
  }, I.j = I.prototype.j, P.prototype.a = function(R) {
    throw new R.b(), Error("Unimplemented");
  }, P.prototype.b = function(R, G) {
    if (R.a == 11 || R.a == 10) return G instanceof p ? G : this.a(R.i.prototype.j(), G);
    if (R.a == 14) {
      if (typeof G == "string" && dn.test(G)) {
        var W = Number(G);
        if (0 < W) return W;
      }
      return G;
    }
    if (!R.h) return G;
    if (W = R.i, W === String) {
      if (typeof G == "number") return String(G);
    } else if (W === Number && typeof G == "string" && (G === "Infinity" || G === "-Infinity" || G === "NaN" || dn.test(G))) return Number(G);
    return G;
  };
  var dn = /^-?[0-9]+$/;
  n(O, P), O.prototype.a = function(R, G) {
    var W = new R.b();
    return W.g = this, W.a = G, W.b = {}, W;
  }, n(_, O), _.prototype.b = function(R, G) {
    return R.a == 8 ? !!G : P.prototype.b.apply(this, arguments);
  }, _.prototype.a = function(R, G) {
    return _.M.a.call(this, R, G);
  };
  var Fn = { 1: "US AG AI AS BB BM BS CA DM DO GD GU JM KN KY LC MP MS PR SX TC TT VC VG VI".split(" "), 7: ["RU", "KZ"], 20: ["EG"], 27: ["ZA"], 30: ["GR"], 31: ["NL"], 32: ["BE"], 33: ["FR"], 34: ["ES"], 36: ["HU"], 39: ["IT", "VA"], 40: ["RO"], 41: ["CH"], 43: ["AT"], 44: ["GB", "GG", "IM", "JE"], 45: ["DK"], 46: ["SE"], 47: ["NO", "SJ"], 48: ["PL"], 49: ["DE"], 51: ["PE"], 52: ["MX"], 53: ["CU"], 54: ["AR"], 55: ["BR"], 56: ["CL"], 57: ["CO"], 58: ["VE"], 60: ["MY"], 61: ["AU", "CC", "CX"], 62: ["ID"], 63: ["PH"], 64: ["NZ"], 65: ["SG"], 66: ["TH"], 81: ["JP"], 82: ["KR"], 84: ["VN"], 86: ["CN"], 90: ["TR"], 91: ["IN"], 92: ["PK"], 93: ["AF"], 94: ["LK"], 95: ["MM"], 98: ["IR"], 211: ["SS"], 212: ["MA", "EH"], 213: ["DZ"], 216: ["TN"], 218: ["LY"], 220: ["GM"], 221: ["SN"], 222: ["MR"], 223: ["ML"], 224: ["GN"], 225: ["CI"], 226: ["BF"], 227: ["NE"], 228: ["TG"], 229: ["BJ"], 230: ["MU"], 231: ["LR"], 232: ["SL"], 233: ["GH"], 234: ["NG"], 235: ["TD"], 236: ["CF"], 237: ["CM"], 238: ["CV"], 239: ["ST"], 240: ["GQ"], 241: ["GA"], 242: ["CG"], 243: ["CD"], 244: ["AO"], 245: ["GW"], 246: ["IO"], 247: ["AC"], 248: ["SC"], 249: ["SD"], 250: ["RW"], 251: ["ET"], 252: ["SO"], 253: ["DJ"], 254: ["KE"], 255: ["TZ"], 256: ["UG"], 257: ["BI"], 258: ["MZ"], 260: ["ZM"], 261: ["MG"], 262: ["RE", "YT"], 263: ["ZW"], 264: ["NA"], 265: ["MW"], 266: ["LS"], 267: ["BW"], 268: ["SZ"], 269: ["KM"], 290: ["SH", "TA"], 291: ["ER"], 297: ["AW"], 298: ["FO"], 299: ["GL"], 350: ["GI"], 351: ["PT"], 352: ["LU"], 353: ["IE"], 354: ["IS"], 355: ["AL"], 356: ["MT"], 357: ["CY"], 358: ["FI", "AX"], 359: ["BG"], 370: ["LT"], 371: ["LV"], 372: ["EE"], 373: ["MD"], 374: ["AM"], 375: ["BY"], 376: ["AD"], 377: ["MC"], 378: ["SM"], 380: ["UA"], 381: ["RS"], 382: ["ME"], 383: ["XK"], 385: ["HR"], 386: ["SI"], 387: ["BA"], 389: ["MK"], 420: ["CZ"], 421: ["SK"], 423: ["LI"], 500: ["FK"], 501: ["BZ"], 502: ["GT"], 503: ["SV"], 504: ["HN"], 505: ["NI"], 506: ["CR"], 507: ["PA"], 508: ["PM"], 509: ["HT"], 590: ["GP", "BL", "MF"], 591: ["BO"], 592: ["GY"], 593: ["EC"], 594: ["GF"], 595: ["PY"], 596: ["MQ"], 597: ["SR"], 598: ["UY"], 599: ["CW", "BQ"], 670: ["TL"], 672: ["NF"], 673: ["BN"], 674: ["NR"], 675: ["PG"], 676: ["TO"], 677: ["SB"], 678: ["VU"], 679: ["FJ"], 680: ["PW"], 681: ["WF"], 682: ["CK"], 683: ["NU"], 685: ["WS"], 686: ["KI"], 687: ["NC"], 688: ["TV"], 689: ["PF"], 690: ["TK"], 691: ["FM"], 692: ["MH"], 800: ["001"], 808: ["001"], 850: ["KP"], 852: ["HK"], 853: ["MO"], 855: ["KH"], 856: ["LA"], 870: ["001"], 878: ["001"], 880: ["BD"], 881: ["001"], 882: ["001"], 883: ["001"], 886: ["TW"], 888: ["001"], 960: ["MV"], 961: ["LB"], 962: ["JO"], 963: ["SY"], 964: ["IQ"], 965: ["KW"], 966: ["SA"], 967: ["YE"], 968: ["OM"], 970: ["PS"], 971: ["AE"], 972: ["IL"], 973: ["BH"], 974: ["QA"], 975: ["BT"], 976: ["MN"], 977: ["NP"], 979: ["001"], 992: ["TJ"], 993: ["TM"], 994: ["AZ"], 995: ["GE"], 996: ["KG"], 998: ["UZ"] }, sn = {
    800: [null, [null, null, "\\d{8}", null, null, null, null, null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "\\d{8}", null, null, null, "12345678"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "001", 800, null, null, null, null, null, null, null, 1, [[null, "(\\d{4})(\\d{4})", "$1 $2"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    808: [null, [null, null, "\\d{8}", null, null, null, null, null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "\\d{8}", null, null, null, "12345678"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "001", 808, null, null, null, null, null, null, null, 1, [[null, "(\\d{4})(\\d{4})", "$1 $2"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    870: [null, [null, null, "[35-7]\\d{8}", null, null, null, null, null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:[356]\\d|7[6-8])\\d{7}", null, null, null, "301234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "001", 870, null, null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[35-7]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    878: [null, [null, null, "10\\d{10}", null, null, null, null, null, null, [12]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "10\\d{10}", null, null, null, "101234567890"], "001", 878, null, null, null, null, null, null, null, 1, [[null, "(\\d{2})(\\d{5})(\\d{5})", "$1 $2 $3", ["1"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    881: [null, [null, null, "[67]\\d{8}", null, null, null, null, null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "[67]\\d{8}", null, null, null, "612345678"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "001", 881, null, null, null, null, null, null, null, null, [[null, "(\\d)(\\d{3})(\\d{5})", "$1 $2 $3", ["[67]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    882: [null, [null, null, "[13]\\d{6}(?:\\d{2,5})?|1\\d{7}", null, null, null, null, null, null, [7, 8, 9, 10, 11, 12]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "3(?:(?:(?:2|7\\d{3})\\d|37)\\d\\d|4(?:2|7\\d{3}))\\d{4}", null, null, null, "3421234", null, null, [7, 9, 10, 12]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:1(?:3(?:0[0347]|[13][0139]|2[035]|4[013568]|6[0459]|7[06]|8[15-8]|9[0689])|6\\d{1,6})|3(?:45|9\\d{3})\\d{3})\\d{4}", null, null, null, "390123456789"], "001", 882, null, null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{5})", "$1 $2", ["16|342"]], [null, "(\\d{2})(\\d{2})(\\d{4})", "$1 $2 $3", ["1"]], [null, "(\\d{2})(\\d{4})(\\d{3})", "$1 $2 $3", ["3[23]"]], [null, "(\\d{2})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["1"]], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["34[57]"]], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["34"]], [null, "(\\d{2})(\\d{4,5})(\\d{5})", "$1 $2 $3", ["[13]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "348[57]\\d{7}", null, null, null, "34851234567", null, null, [11]]],
    883: [null, [null, null, "51\\d{7}(?:\\d{3})?", null, null, null, null, null, null, [9, 12]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "51[013]0\\d{8}|5100\\d{5}", null, null, null, "510012345"], "001", 883, null, null, null, null, null, null, null, 1, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["510"]], [null, "(\\d{3})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["510"]], [null, "(\\d{4})(\\d{4})(\\d{4})", "$1 $2 $3", ["5"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    888: [null, [null, null, "\\d{11}", null, null, null, null, null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "001", 888, null, null, null, null, null, null, null, 1, [[null, "(\\d{3})(\\d{3})(\\d{5})", "$1 $2 $3"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "\\d{11}", null, null, null, "12345678901"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    979: [null, [null, null, "\\d{9}", null, null, null, null, null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "\\d{9}", null, null, null, "123456789"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "001", 979, null, null, null, null, null, null, null, 1, [[null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AC: [null, [null, null, "(?:[01589]\\d|[46])\\d{4}", null, null, null, null, null, null, [5, 6]], [null, null, "6[2-467]\\d{3}", null, null, null, "62889", null, null, [5]], [null, null, "4\\d{4}", null, null, null, "40123", null, null, [5]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AC", 247, "00", null, null, null, null, null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "[01589]\\d{5}", null, null, null, "542011", null, null, [6]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AD: [null, [null, null, "(?:1|6\\d)\\d{7}|[136-9]\\d{5}", null, null, null, null, null, null, [6, 8, 9]], [null, null, "[78]\\d{5}", null, null, null, "712345", null, null, [6]], [null, null, "690\\d{6}|[36]\\d{5}", null, null, null, "312345", null, null, [6, 9]], [null, null, "180[02]\\d{4}", null, null, null, "18001234", null, null, [8]], [null, null, "[19]\\d{5}", null, null, null, "912345", null, null, [6]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AD", 376, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{3})", "$1 $2", ["[136-9]"]], [null, "(\\d{4})(\\d{4})", "$1 $2", ["1"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["6"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "1800\\d{4}", null, null, null, null, null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AE: [null, [null, null, "(?:[4-7]\\d|9[0-689])\\d{7}|800\\d{2,9}|[2-4679]\\d{7}", null, null, null, null, null, null, [5, 6, 7, 8, 9, 10, 11, 12]], [null, null, "[2-4679][2-8]\\d{6}", null, null, null, "22345678", null, null, [8], [7]], [null, null, "5[024-68]\\d{7}", null, null, null, "501234567", null, null, [9]], [null, null, "400\\d{6}|800\\d{2,9}", null, null, null, "800123456"], [null, null, "900[02]\\d{5}", null, null, null, "900234567", null, null, [9]], [null, null, "700[05]\\d{5}", null, null, null, "700012345", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AE", 971, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{2,9})", "$1 $2", ["60|8"]], [null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["[236]|[479][2-8]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["5"], "0$1"], [null, "(\\d{3})(\\d)(\\d{5})", "$1 $2 $3", ["[479]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "600[25]\\d{5}", null, null, null, "600212345", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AF: [null, [null, null, "[2-7]\\d{8}", null, null, null, null, null, null, [9], [7]], [null, null, "(?:[25][0-8]|[34][0-4]|6[0-5])[2-9]\\d{6}", null, null, null, "234567890", null, null, null, [7]], [null, null, "7(?:[014-9]\\d|2[89]|3[01])\\d{6}", null, null, null, "701234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AF", 93, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[2-9]"]], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[2-7]"], "0$1"]], [[null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[2-7]"], "0$1"]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AG: [null, [null, null, "(?:268|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "268(?:4(?:6[0-38]|84)|56[0-2])\\d{4}", null, null, null, "2684601234", null, null, null, [7]], [null, null, "268(?:464|7(?:1[3-9]|2\\d|3[246]|64|[78][0-689]))\\d{4}", null, null, null, "2684641234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, "26848[01]\\d{4}", null, null, null, "2684801234", null, null, null, [7]], "AG", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, "26840[69]\\d{4}", null, null, null, "2684061234", null, null, null, [7]], null, "268", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AI: [null, [null, null, "(?:264|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "2644(?:6[12]|9[78])\\d{4}", null, null, null, "2644612345", null, null, null, [7]], [null, null, "264(?:235|476|5(?:3[6-9]|8[1-4])|7(?:29|72))\\d{4}", null, null, null, "2642351234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "AI", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "264", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AL: [null, [null, null, "(?:(?:[2-58]|6\\d)\\d\\d|700)\\d{5}|(?:8\\d{2,3}|900)\\d{3}", null, null, null, null, null, null, [6, 7, 8, 9], [5]], [null, null, "(?:[2358](?:[16-9]\\d[2-9]|[2-5][2-9]\\d)|4(?:[2-57-9][2-9]|6\\d)\\d)\\d{4}", null, null, null, "22345678", null, null, [8], [5, 6, 7]], [null, null, "6(?:[689][2-9]|7[2-6])\\d{6}", null, null, null, "662123456", null, null, [9]], [null, null, "800\\d{4}", null, null, null, "8001234", null, null, [7]], [null, null, "900[1-9]\\d\\d", null, null, null, "900123", null, null, [6]], [null, null, "808[1-9]\\d\\d", null, null, null, "808123", null, null, [6]], [null, null, "700[2-9]\\d{4}", null, null, null, "70021234", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], "AL", 355, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{3,4})", "$1 $2", ["80|9"], "0$1"], [null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["4[2-6]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[2358][2-5]|4"], "0$1"], [null, "(\\d{3})(\\d{5})", "$1 $2", ["[23578]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["6"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AM: [null, [null, null, "(?:[1-489]\\d|55|60|77)\\d{6}", null, null, null, null, null, null, [8], [5, 6]], [null, null, "(?:(?:1[0-2]|47)\\d|2(?:2[2-46]|3[1-8]|4[2-69]|5[2-7]|6[1-9]|8[1-7])|3[12]2)\\d{5}", null, null, null, "10123456", null, null, null, [5, 6]], [null, null, "(?:4[1349]|55|77|88|9[13-9])\\d{6}", null, null, null, "77123456"], [null, null, "800\\d{5}", null, null, null, "80012345"], [null, null, "90[016]\\d{5}", null, null, null, "90012345"], [null, null, "80[1-4]\\d{5}", null, null, null, "80112345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "60(?:2[78]|3[5-9]|4[02-9]|5[0-46-9]|[6-8]\\d|90)\\d{4}", null, null, null, "60271234"], "AM", 374, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{6})", "$1 $2", ["1|47"], "(0$1)"], [null, "(\\d{3})(\\d{5})", "$1 $2", ["[23]"], "(0$1)"], [null, "(\\d{2})(\\d{6})", "$1 $2", ["[4-7]|88|9[13-9]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["[89]"], "0 $1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AO: [null, [null, null, "[29]\\d{8}", null, null, null, null, null, null, [9]], [null, null, "2\\d(?:[0134][25-9]|[25-9]\\d)\\d{5}", null, null, null, "222123456"], [null, null, "9[1-49]\\d{7}", null, null, null, "923123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AO", 244, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[29]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AR: [null, [null, null, "(?:11|(?:[2368]|9\\d)\\d)\\d{8}", null, null, null, null, null, null, [10, 11], [6, 7, 8]], [null, null, "11\\d{8}|(?:2(?:2(?:[013]\\d|2[13-79]|4[1-6]|5[2457]|6[124-8]|7[1-4]|8[13-6]|9[1267])|3(?:[07]\\d|1[467]|2[03-6]|3[13-8]|[49][2-6]|5[2-8]|6[013-9])|4(?:7[3-8]|9\\d)|6(?:[01346]\\d|2[24-6]|5[15-8])|80\\d|9(?:[012789]\\d|3[1-6]|4[02-9]|5[234]|6[2-46]))|3(?:3(?:2[79]|6\\d|8[2578])|4(?:0[0124-9]|[1-357]\\d|4[24-7]|6[02-9]|8[0-79]|9[1236-8])|5(?:[138]\\d|2[1245]|4[1-9]|6[2-4]|7[1-6])|6[24]\\d|7(?:[069]\\d|1[1568]|2[013-9]|3[145]|4[0-35-9]|5[14-8]|7[2-57]|8[0-24-9])|8(?:[01578]\\d|2[15-7]|3[0-24-9]|4[13-6]|6[1-357-9]|9[124]))|670\\d)\\d{6}", null, null, null, "1123456789", null, null, [10], [6, 7, 8]], [null, null, "675\\d{7}|9(?:11[2-9]\\d{7}|(?:2(?:2[013]|3[067]|49|6[01346]|80|9[147-9])|3(?:36|4[1-358]|5[138]|6[24]|7[069]|8[013578]))[2-9]\\d{6}|(?:2(?:2(?:02|2[13-79]|4[1-6]|5[2457]|6[124-8]|7[1-4]|8[13-6]|9[1267])|3(?:02|1[467]|2[03-6]|3[13-8]|[49][2-6]|5[2-8])|47[3-578]|6(?:2[24-6]|4[6-8]|5[15-8])|9(?:0[1-3]|2\\d|3[1-6]|4[02568]|5[2-4]|6[2-46]|72|8[23]))|3(?:3(?:2[79]|8[2578])|4(?:0[0-24-9]|4[24-7]|6[02-9]|7[126]|9[1-36-8])|5(?:2[1245]|3[237]|4[1-46-9]|6[2-4]|7[1-6]|8[2-5])|7(?:1[1568]|2[15]|3[145]|4[13]|5[14-8]|7[2-57]|8[126])|8(?:2[15-7]|3[2578]|4[13-6]|5[4-8]|6[1-357-9]|9[124])))[2-9]\\d{5})", null, null, null, "91123456789", null, null, null, [6, 7, 8]], [null, null, "800\\d{7}", null, null, null, "8001234567", null, null, [10]], [null, null, "60[04579]\\d{7}", null, null, null, "6001234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AR", 54, "00", "0", null, null, "0?(?:(11|2(?:2(?:02?|[13]|2[13-79]|4[1-6]|5[2457]|6[124-8]|7[1-4]|8[13-6]|9[1267])|3(?:02?|1[467]|2[03-6]|3[13-8]|[49][2-6]|5[2-8]|[67])|4(?:7[3-578]|9)|6(?:[0136]|2[24-6]|4[6-8]?|5[15-8])|80|9(?:0[1-3]|[19]|2\\d|3[1-6]|4[02568]?|5[2-4]|6[2-46]|72?|8[23]?))|3(?:3(?:2[79]|6|8[2578])|4(?:0[0-24-9]|[12]|3[5-8]?|4[24-7]|5[4-68]?|6[02-9]|7[126]|8[2379]?|9[1-36-8])|5(?:1|2[1245]|3[237]?|4[1-46-9]|6[2-4]|7[1-6]|8[2-5]?)|6[24]|7(?:[069]|1[1568]|2[15]|3[145]|4[13]|5[14-8]|7[2-57]|8[126])|8(?:[01]|2[15-7]|3[2578]?|4[13-6]|5[4-8]?|6[1-357-9]|7[36-8]?|8[5-8]?|9[124])))?15)?", "9$1", null, null, [[null, "(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3", ["[68]"], "0$1"], [null, "(\\d{2})(\\d{4})", "$1-$2", ["[2-9]"], "$1"], [null, "(\\d{3})(\\d{4})", "$1-$2", ["[2-9]"], "$1"], [null, "(\\d{4})(\\d{4})", "$1-$2", ["[2-9]"], "$1"], [null, "(\\d)(\\d{2})(\\d{4})(\\d{4})", "$2 15-$3-$4", ["911"], "0$1"], [null, "(\\d)(\\d{3})(\\d{3})(\\d{4})", "$2 15-$3-$4", ["9(?:2[2-4689]|3[3-8])", "9(?:2(?:2[013]|3[067]|49|6[01346]|8|9[147-9])|3(?:36|4[1-358]|5[138]|6|7[069]|8[013578]))", "9(?:2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3[4-6]|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45])))", "9(?:2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3(?:4|5[014]|6[1-39])|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45])))"], "0$1"], [null, "(\\d)(\\d{4})(\\d{2})(\\d{4})", "$2 15-$3-$4", ["9[23]"], "0$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2-$3", ["11"], "0$1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2-$3", ["2(?:2[013]|3[067]|49|6[01346]|8|9[147-9])|3(?:36|4[1-358]|5[138]|6|7[069]|8[013578])", "2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3[4-6]|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45]))", "2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3(?:4|5[014]|6[1-39])|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45]))"], "0$1", null, 1], [null, "(\\d{4})(\\d{2})(\\d{4})", "$1 $2-$3", ["[23]"], "0$1", null, 1], [null, "(\\d{3})", "$1", ["1[0-2]|911"], "$1"]], [[null, "(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3", ["[68]"], "0$1"], [null, "(\\d)(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3-$4", ["911"]], [null, "(\\d)(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3-$4", ["9(?:2[2-4689]|3[3-8])", "9(?:2(?:2[013]|3[067]|49|6[01346]|8|9[147-9])|3(?:36|4[1-358]|5[138]|6|7[069]|8[013578]))", "9(?:2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3[4-6]|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45])))", "9(?:2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3(?:4|5[014]|6[1-39])|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45])))"]], [null, "(\\d)(\\d{4})(\\d{2})(\\d{4})", "$1 $2 $3-$4", ["9[23]"]], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2-$3", ["11"], "0$1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2-$3", ["2(?:2[013]|3[067]|49|6[01346]|8|9[147-9])|3(?:36|4[1-358]|5[138]|6|7[069]|8[013578])", "2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3[4-6]|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45]))", "2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3(?:4|5[014]|6[1-39])|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45]))"], "0$1", null, 1], [null, "(\\d{4})(\\d{2})(\\d{4})", "$1 $2-$3", ["[23]"], "0$1", null, 1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "810\\d{7}", null, null, null, null, null, null, [10]], [null, null, "810\\d{7}", null, null, null, "8101234567", null, null, [10]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AS: [null, [null, null, "(?:[58]\\d\\d|684|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "6846(?:22|33|44|55|77|88|9[19])\\d{4}", null, null, null, "6846221234", null, null, null, [7]], [null, null, "684(?:2(?:5[2468]|72)|7(?:3[13]|70))\\d{4}", null, null, null, "6847331234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "AS", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "684", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AT: [null, [null, null, "[1-35-9]\\d{8,12}|4(?:[0-24-9]\\d{4,11}|3(?:(?:0\\d|5[02-9])\\d{3,9}|2\\d{4,5}|[3467]\\d{4}|8\\d{4,6}|9\\d{4,7}))|[1-35-8]\\d{7}|[1-35-7]\\d{6}|[135-7]\\d{5}|[15]\\d{4}|1\\d{3}", null, null, null, null, null, null, [4, 5, 6, 7, 8, 9, 10, 11, 12, 13], [3]], [null, null, "(?:1(?:11|[2-9]\\d{2,10})|(?:2(?:1[467]|2[13-8]|5[2357]|6[1-46-8]|7[1-8]|8[124-7]|9[1458])|3(?:1[1-8]|3[23568]|4[5-7]|5[1378]|6[1-38]|8[3-68])|7(?:2[1-8]|3[25]|4[13478]|5[68]|6[16-8]|7[1-6]|9[45]))\\d{3,9}|4(?:(?:2[1-8]|35|7[1368]|8[2457])\\d{3,9}|63\\d{2,9})|5(?:12\\d{2,9}|(?:2[1-8]|3[357]|4[147]|5[12578]|6[37])\\d{3,9})|6(?:(?:13|2[1-47]|4[135-8]|5[468])\\d{3,9}|62\\d{2,9}))\\d|(?:316|732)\\d{3}", null, null, null, "1234567890", null, null, null, [3]], [null, null, "6(?:5[0-3579]|6[013-9]|[7-9]\\d)\\d{4,10}", null, null, null, "664123456", null, null, [7, 8, 9, 10, 11, 12, 13]], [null, null, "800\\d{6,10}", null, null, null, "800123456", null, null, [9, 10, 11, 12, 13]], [null, null, "9(?:0[01]|3[019])\\d{6,10}", null, null, null, "900123456", null, null, [9, 10, 11, 12, 13]], [null, null, "8(?:10|2[018])\\d{6,10}|828\\d{5}", null, null, null, "810123456", null, null, [8, 9, 10, 11, 12, 13]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:0[1-9]|17|[79]\\d)\\d{2,10}|7[28]0\\d{6,10}", null, null, null, "780123456", null, null, [5, 6, 7, 8, 9, 10, 11, 12, 13]], "AT", 43, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3,12})", "$1 $2", ["1(?:11|[2-9])"], "0$1"], [null, "(\\d{3})(\\d{2})", "$1 $2", ["517"], "0$1"], [null, "(\\d{2})(\\d{3,5})", "$1 $2", ["5[079]"], "0$1"], [null, "(\\d{3})(\\d{3,10})", "$1 $2", ["(?:31|4)6|51|6(?:5[0-3579]|[6-9])|7(?:20|32|8)|[89]"], "0$1"], [null, "(\\d{4})(\\d{3,9})", "$1 $2", ["[2-467]|5[2-6]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["5"], "0$1"], [null, "(\\d{2})(\\d{4})(\\d{4,7})", "$1 $2 $3", ["5"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AU: [null, [null, null, "1\\d{4,9}|(?:[2-478]\\d\\d|550)\\d{6}", null, null, null, null, null, null, [5, 6, 7, 8, 9, 10]], [null, null, "(?:[237]\\d{5}|8(?:51(?:0(?:0[03-9]|[1247]\\d|3[2-9]|5[0-8]|6[1-9]|8[0-6])|1(?:1[69]|[23]\\d|4[0-4]))|(?:[6-8]\\d{3}|9(?:[02-9]\\d\\d|1(?:[0-57-9]\\d|6[0135-9])))\\d))\\d{3}", null, null, null, "212345678", null, null, [9], [8]], [null, null, "4(?:[0-3]\\d|4[047-9]|5[0-25-9]|6[6-9]|7[02-9]|8[0-2457-9]|9[017-9])\\d{6}", null, null, null, "412345678", null, null, [9]], [null, null, "180(?:0\\d{3}|2)\\d{3}", null, null, null, "1800123456", null, null, [7, 10]], [null, null, "190[0-26]\\d{6}", null, null, null, "1900123456", null, null, [10]], [null, null, "13(?:00\\d{3}|45[0-4])\\d{3}|13\\d{4}", null, null, null, "1300123456", null, null, [6, 8, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:14(?:5\\d|71)|550\\d)\\d{5}", null, null, null, "550123456", null, null, [9]], "AU", 61, "001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011", "0", null, null, "0", null, "0011", null, [[null, "(\\d{3})(\\d{3})", "$1 $2", ["19"]], [null, "(\\d{4})(\\d{3,4})", "$1 $2", ["19"]], [null, "(\\d{2})(\\d{3,4})", "$1 $2", ["16"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3", ["13"]], [null, "(\\d{3})(\\d{4})", "$1 $2", ["180", "1802"]], [null, "(\\d{2})(\\d{3})(\\d{2,4})", "$1 $2 $3", ["16"], "0$1"], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["[2378]"], "(0$1)"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["14|[45]"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1(?:30|[89])"]]], [[null, "(\\d{2})(\\d{3,4})", "$1 $2", ["16"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2,4})", "$1 $2 $3", ["16"], "0$1"], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["[2378]"], "(0$1)"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["14|[45]"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1(?:30|[89])"]]], [null, null, "16\\d{3,7}", null, null, null, "1612345", null, null, [5, 6, 7, 8, 9]], 1, null, [null, null, "1[38]00\\d{6}|1(?:345[0-4]|802)\\d{3}|13\\d{4}", null, null, null, null, null, null, [6, 7, 8, 10]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AW: [null, [null, null, "(?:[25-79]\\d\\d|800)\\d{4}", null, null, null, null, null, null, [7]], [null, null, "5(?:2\\d|8[1-9])\\d{4}", null, null, null, "5212345"], [null, null, "(?:290|5[69]\\d|6(?:[03]0|22|4[0-2]|[69]\\d)|7(?:[34]\\d|7[07])|9(?:6[45]|9[4-8]))\\d{4}", null, null, null, "5601234"], [null, null, "800\\d{4}", null, null, null, "8001234"], [null, null, "900\\d{4}", null, null, null, "9001234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:28\\d|501)\\d{4}", null, null, null, "5011234"], "AW", 297, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[25-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AX: [null, [null, null, "(?:(?:[1247]\\d|3[0-46-9]|[56]0)\\d\\d|800)\\d{4,6}|(?:[1-47]\\d|50)\\d{4,5}|2\\d{4}", null, null, null, null, null, null, [5, 6, 7, 8, 9, 10]], [null, null, "18[1-8]\\d{3,6}", null, null, null, "181234567", null, null, [6, 7, 8, 9]], [null, null, "(?:4[0-8]|50)\\d{4,8}", null, null, null, "412345678", null, null, [6, 7, 8, 9, 10]], [null, null, "800\\d{4,6}", null, null, null, "800123456", null, null, [7, 8, 9]], [null, null, "[67]00\\d{5,6}", null, null, null, "600123456", null, null, [8, 9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AX", 358, "00|99(?:[01469]|5(?:[14]1|3[23]|5[59]|77|88|9[09]))", "0", null, null, "0", null, "00", null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "18", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:10|[23][09])\\d{4,8}|60(?:[12]\\d{5,6}|6\\d{7})|7(?:(?:1|3\\d)\\d{7}|5[03-9]\\d{3,7})|20[2-59]\\d\\d", null, null, null, "10112345"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AZ: [null, [null, null, "(?:(?:(?:[12457]\\d|60|88)\\d|365)\\d{3}|900200)\\d{3}", null, null, null, null, null, null, [9], [7]], [null, null, "(?:(?:1[28]\\d|2(?:[045]2|1[24]|2[2-4]|33|6[23]))\\d\\d|365(?:[0-46-9]\\d|5[0-35-9]))\\d{4}", null, null, null, "123123456", null, null, null, [7]], [null, null, "(?:36554|(?:4[04]|5[015]|60|7[07])\\d{3})\\d{4}", null, null, null, "401234567"], [null, null, "88\\d{7}", null, null, null, "881234567"], [null, null, "900200\\d{3}", null, null, null, "900200123"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AZ", 994, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3"], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[12]|365", "[12]|365", "[12]|365(?:[0-46-9]|5[0-35-9])"], "(0$1)"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["9"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[3-8]"], "0$1"]], [[null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[12]|365", "[12]|365", "[12]|365(?:[0-46-9]|5[0-35-9])"], "(0$1)"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["9"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[3-8]"], "0$1"]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BA: [null, [null, null, "(?:[3589]\\d|49|6\\d\\d?|70)\\d{6}", null, null, null, null, null, null, [8, 9], [6]], [null, null, "(?:3(?:[05-79][2-9]|1[4579]|[23][24-9]|4[2-4689]|8[2457-9])|49[2-579]|5(?:0[2-49]|[13][2-9]|[268][2-4679]|4[4689]|5[2-79]|7[2-69]|9[2-4689]))\\d{5}", null, null, null, "30212345", null, null, [8], [6]], [null, null, "6(?:0(?:3\\d|40)|[1-356]\\d|44[0-6]|71[137])\\d{5}", null, null, null, "61123456"], [null, null, "8[08]\\d{6}", null, null, null, "80123456", null, null, [8]], [null, null, "9[0246]\\d{6}", null, null, null, "90123456", null, null, [8]], [null, null, "8[12]\\d{6}", null, null, null, "82123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BA", 387, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{3})", "$1-$2", ["[2-9]"]], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2-$3", ["[3-5]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["6[1-356]|[7-9]"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["6"], "0$1"]], [[null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2-$3", ["[3-5]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["6[1-356]|[7-9]"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["6"], "0$1"]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "70(?:3[0146]|[56]0)\\d{4}", null, null, null, "70341234", null, null, [8]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BB: [null, [null, null, "(?:246|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "246(?:2(?:2[78]|7[0-4])|4(?:1[024-6]|2\\d|3[2-9])|5(?:20|[34]\\d|54|7[1-3])|6(?:2\\d|38)|7[35]7|9(?:1[89]|63))\\d{4}", null, null, null, "2464123456", null, null, null, [7]], [null, null, "246(?:2(?:[356]\\d|4[0-57-9]|8[0-79])|45\\d|69[5-7]|8(?:[2-5]\\d|83))\\d{4}", null, null, null, "2462501234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "(?:246976|900[2-9]\\d\\d)\\d{4}", null, null, null, "9002123456", null, null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, "24631\\d{5}", null, null, null, "2463101234", null, null, null, [7]], "BB", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "246", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "246(?:292|367|4(?:1[7-9]|3[01]|44|67)|7(?:36|53))\\d{4}", null, null, null, "2464301234", null, null, null, [7]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BD: [null, [null, null, "[13469]\\d{9}|8[0-79]\\d{7,8}|[2-7]\\d{8}|[2-9]\\d{7}|[3-689]\\d{6}|[57-9]\\d{5}", null, null, null, null, null, null, [6, 7, 8, 9, 10]], [null, null, "(?:(?:2(?:[45]\\d{3}|7(?:1[0-267]|2[0-289]|3[0-29]|4[01]|5[1-3]|6[013]|7[0178]|91)|8(?:0[125]|[13][1-6]|2[0157-9]|41|6[1-35]|7[1-5]|8[1-8]|9[0-6])|9(?:0[0-2]|1[0-4]|2[568]|3[3-6]|5[5-7]|6[01367]|7[15]|8[0146-9]))|7(?:02|21\\d|[3-589]1|6[12]|72[24])\\d|8(?:(?:[01]|217|3[12])\\d|4[12]|[5-7](?:1\\d|2)))\\d|3(?:(?:0(?:2[348]\\d|3[2-6])|(?:1(?:2[5-7]|[5-7])|3(?:1|24)|[5-7]1)\\d)\\d|2(?:1\\d\\d|2(?:[35]\\d\\d|4))|4(?:1\\d\\d|2(?:[25]\\d\\d|[47]))|8(?:1\\d\\d|2(?:(?:2\\d|4)\\d|3)))|4(?:0(?:2(?:[09]\\d|7)|33\\d\\d)|(?:1\\d|4(?:2[2-46]|5[25])|8(?:23|54))\\d\\d|2(?:1\\d\\d|2(?:[25]|[67]\\d\\d))|3(?:1\\d\\d(?:\\d{2})?|(?:2[236-9]|32)\\d\\d)|525|6(?:(?:[18]|2[3-6]|62)\\d\\d|5(?:[38]|[5-7]\\d\\d))|9(?:(?:[18]|2[2-5])\\d\\d|53\\d\\d?))|5(?:(?:02[03489]|1|22[2457]|32[35-79]|42[46]|[58]26|724)\\d\\d|6(?:(?:[18]|53)\\d\\d|2))|6(?:(?:(?:[04]2[34]|32[3478]|52[47]|[78]2[2-5]|92[2-6])\\d|6(?:[18]\\d|6(?:2(?:2|[34]\\d)|5[245]\\d)))\\d|2(?:(?:2[2-5]|8)\\d\\d|5(?:[3-5]\\d\\d|7)))|9(?:[24]1\\d\\d|[35]1))\\d{3}|(?:3(?:0(?:2[02-9]\\d|3[56])|(?:22[1-5]|32[2-6]|422)\\d|529)|(?:4(?:22[2-8]|32[02-9]|(?:[48][18]|71)\\d|5(?:1\\d|23)|6(?:2[467]|5[3-57]))|5(?:[2-47-9]1\\d|5(?:1\\d|26))|6(?:0(?:1\\d|24)|[3-589]1\\d|665[35])|81|9(?:[024]2|1\\d|81))\\d|732)\\d{3}|(?:4[46]23|5(?:222|32[37]))\\d{3}", null, null, null, "27111234"], [null, null, "(?:1[13-9]\\d|(?:3[78]|44)[02-9]|6(?:44|6[02-9]))\\d{7}", null, null, null, "1812345678", null, null, [10]], [null, null, "80[03]\\d{7}", null, null, null, "8001234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "96(?:0[469]|1[0-47]|3[389]|6[69]|7[78])\\d{6}", null, null, null, "9604123456", null, null, [10]], "BD", 880, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{4,6})", "$1-$2", ["31[5-7]|[459]1"], "0$1"], [null, "(\\d{3})(\\d{3,7})", "$1-$2", ["3(?:[2-5]1|[67]|8[013-9])|4(?:[235]1|4[01346-9]|6[168]|7|[89][18])|5(?:[2-578]1|6[128]|9)|6(?:[0389]1|28|4[14]|5|6[01346-9])|7(?:[2-589]|61)|8(?:0[014-9]|[12]|[3-7]1)|9(?:[24]1|[358])"], "0$1"], [null, "(\\d{4})(\\d{3,6})", "$1-$2", ["[13-9]"], "0$1"], [null, "(\\d)(\\d{7,8})", "$1-$2", ["2"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BE: [null, [null, null, "4\\d{8}|[1-9]\\d{7}", null, null, null, null, null, null, [8, 9]], [null, null, "(?:(?:1[0-69]|[23][2-8]|4[23]|5\\d|6[013-57-9]|71|9[2-4])\\d|8(?:0[2-8]|[1-79]\\d))\\d{5}", null, null, null, "12345678", null, null, [8]], [null, null, "4(?:5[56]|6[0135-8]|[79]\\d|8[3-9])\\d{6}", null, null, null, "470123456", null, null, [9]], [null, null, "800[1-9]\\d{4}", null, null, null, "80012345", null, null, [8]], [null, null, "(?:70(?:2[0-57]|3[0457]|44|69|7[0579])|90(?:0[0-35-8]|1[36]|2[0-3568]|3[0135689]|4[2-68]|5[1-68]|6[0-378]|7[23568]|9[34679]))\\d{4}", null, null, null, "90012345", null, null, [8]], [null, null, "7879\\d{4}", null, null, null, "78791234", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BE", 32, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[23]|4[23]|9[2-4]"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[15-7]|8(?:0[2-8]|[1-79])"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["[89]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["4"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "78(?:0[57]|1[0458]|2[25]|3[5-8]|48|[56]0|7[078])\\d{4}", null, null, null, "78102345", null, null, [8]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BF: [null, [null, null, "[25-7]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "2(?:0(?:49|5[23]|6[56]|9[016-9])|4(?:4[569]|5[4-6]|6[56]|7[0179])|5(?:[34]\\d|50|6[5-7]))\\d{4}", null, null, null, "20491234"], [null, null, "(?:5[124-8]|[67]\\d)\\d{6}", null, null, null, "70123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BF", 226, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[25-7]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BG: [null, [null, null, "[2-7]\\d{6,7}|[89]\\d{6,8}|2\\d{5}", null, null, null, null, null, null, [6, 7, 8, 9], [4, 5]], [null, null, "(?:(?:[236]\\d|5[1-9]|8[1-6]|9[1-7])\\d|4(?:[124-7]\\d|3[1-6])|7(?:0[1-9]|[1-9]\\d))\\d{4,5}|2\\d{5}", null, null, null, "2123456", null, null, [6, 7, 8], [4, 5]], [null, null, "(?:4(?:3[07-9]|8\\d)|(?:8[7-9]\\d|9(?:8\\d|9[69]))\\d)\\d{5}", null, null, null, "48123456", null, null, [8, 9]], [null, null, "800\\d{5}", null, null, null, "80012345", null, null, [8]], [null, null, "90\\d{6}", null, null, null, "90123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "700\\d{5}", null, null, null, "70012345", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], "BG", 359, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d)(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["2"], "0$1"], [null, "(\\d{3})(\\d{4})", "$1 $2", ["43[1-6]|70[1-9]"], "0$1"], [null, "(\\d)(\\d{3})(\\d{3,4})", "$1 $2 $3", ["2"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2,3})", "$1 $2 $3", ["[356]|4[124-7]|7[1-9]|8[1-6]|9[1-7]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{2})", "$1 $2 $3", ["43[1-7]|70[1-9]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["7|80"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[48]|9[08]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["9"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BH: [null, [null, null, "[136-9]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "(?:1(?:3[1356]|6[0156]|7\\d)\\d|6(?:1[16]\\d|500|6(?:0\\d|3[12]|44|7[7-9])|9[69][69])|7(?:1(?:11|78)|7\\d\\d))\\d{4}", null, null, null, "17001234"], [null, null, "(?:3(?:[1-4679]\\d|5[013-69]|8[0-47-9])\\d|6(?:3(?:00|33|6[16])|6(?:3[03-9]|[69]\\d|7[0-6])))\\d{4}", null, null, null, "36001234"], [null, null, "80\\d{6}", null, null, null, "80123456"], [null, null, "(?:87|9[014578])\\d{6}", null, null, null, "90123456"], [null, null, "84\\d{6}", null, null, null, "84123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BH", 973, "00", null, null, null, null, null, null, null, [[null, "(\\d{4})(\\d{4})", "$1 $2", ["[1367]|8[047]|9[014578]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BI: [null, [null, null, "(?:[267]\\d|31)\\d{6}", null, null, null, null, null, null, [8]], [null, null, "22\\d{6}", null, null, null, "22201234"], [null, null, "(?:29|31|6[189]|7[125-9])\\d{6}", null, null, null, "79561234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BI", 257, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[23]|6[189]|7[125-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BJ: [null, [null, null, "[2689]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "2(?:02|1[037]|2[45]|3[68])\\d{5}", null, null, null, "20211234"], [null, null, "(?:6\\d|9[03-9])\\d{6}", null, null, null, "90011234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "857[58]\\d{4}", null, null, null, "85751234"], "BJ", 229, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2689]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "81\\d{6}", null, null, null, "81123456"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BL: [null, [null, null, "(?:590|69\\d)\\d{6}", null, null, null, null, null, null, [9]], [null, null, "590(?:2[7-9]|5[12]|87)\\d{4}", null, null, null, "590271234"], [null, null, "69(?:0\\d\\d|1(?:2[29]|3[0-5]))\\d{4}", null, null, null, "690001234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BL", 590, "00", "0", null, null, "0", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BM: [null, [null, null, "(?:441|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "441(?:2(?:02|23|[3479]\\d|61)|[46]\\d\\d|5(?:4\\d|60|89)|824)\\d{4}", null, null, null, "4412345678", null, null, null, [7]], [null, null, "441(?:[37]\\d|5[0-39])\\d{5}", null, null, null, "4413701234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "BM", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "441", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BN: [null, [null, null, "[2-578]\\d{6}", null, null, null, null, null, null, [7]], [null, null, "(?:2(?:[013-9]\\d|2[0-7])|[3-5]\\d\\d)\\d{4}", null, null, null, "2345678"], [null, null, "(?:22[89]|[78]\\d\\d)\\d{4}", null, null, null, "7123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BN", 673, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[2-578]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BO: [null, [null, null, "(?:[2-467]\\d{3}|80017)\\d{4}", null, null, null, null, null, null, [8, 9], [7]], [null, null, "(?:2(?:2\\d\\d|5(?:11|[258]\\d|9[67])|6(?:12|2\\d|9[34])|8(?:2[34]|39|62))|3(?:3\\d\\d|4(?:6\\d|8[24])|8(?:25|42|5[257]|86|9[25])|9(?:[27]\\d|3[2-4]|4[248]|5[24]|6[2-6]))|4(?:4\\d\\d|6(?:11|[24689]\\d|72)))\\d{4}", null, null, null, "22123456", null, null, [8], [7]], [null, null, "[67]\\d{7}", null, null, null, "71234567", null, null, [8]], [null, null, "80017\\d{4}", null, null, null, "800171234", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BO", 591, "00(?:1\\d)?", "0", null, null, "0(1\\d)?", null, null, null, [[null, "(\\d)(\\d{7})", "$1 $2", ["[2-4]"], null, "0$CC $1"], [null, "(\\d{8})", "$1", ["[67]"], null, "0$CC $1"], [null, "(\\d{3})(\\d{2})(\\d{4})", "$1 $2 $3", ["8"], null, "0$CC $1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BQ: [null, [null, null, "(?:[34]1|7\\d)\\d{5}", null, null, null, null, null, null, [7]], [null, null, "(?:318[023]|41(?:6[023]|70)|7(?:1[578]|50)\\d)\\d{3}", null, null, null, "7151234"], [null, null, "(?:31(?:8[14-8]|9[14578])|416[14-9]|7(?:0[01]|7[07]|8\\d|9[056])\\d)\\d{3}", null, null, null, "3181234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BQ", 599, "00", null, null, null, null, null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "[347]", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BR: [null, [null, null, "(?:[1-46-9]\\d\\d|5(?:[0-46-9]\\d|5[0-24679]))\\d{8}|[1-9]\\d{9}|[3589]\\d{8}|[34]\\d{7}", null, null, null, null, null, null, [8, 9, 10, 11]], [null, null, "(?:[14689][1-9]|2[12478]|3[1-578]|5[13-5]|7[13-579])[2-5]\\d{7}", null, null, null, "1123456789", null, null, [10], [8]], [null, null, "(?:[189][1-9]|2[12478])(?:7|9\\d)\\d{7}|(?:3[1-578]|[46][1-9]|5[13-5]|7[13-579])(?:[6-9]|9\\d)\\d{7}", null, null, null, "11961234567", null, null, [10, 11], [8]], [null, null, "800\\d{6,7}", null, null, null, "800123456", null, null, [9, 10]], [null, null, "(?:300|[59]00\\d?)\\d{6}", null, null, null, "300123456", null, null, [9, 10]], [null, null, "(?:300\\d(?:\\d{2})?|4(?:0(?:0\\d|20)|370))\\d{4}", null, null, null, "40041234", null, null, [8, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BR", 55, "00(?:1[245]|2[1-35]|31|4[13]|[56]5|99)", "0", null, null, "0(?:(1[245]|2[1-35]|31|4[13]|[56]5|99)(\\d{10,11}))?", "$2", null, null, [[null, "(\\d{4})(\\d{4})", "$1-$2", ["300|4(?:0[02]|37)", "300|4(?:0(?:0|20)|370)"]], [null, "(\\d{3})(\\d{2,3})(\\d{4})", "$1 $2 $3", ["[3589]00"], "0$1"], [null, "(\\d{3,5})", "$1", ["1[125689]"]], [null, "(\\d{4})(\\d{4})", "$1-$2", ["[2-9](?:0[1-9]|[1-9])"]], [null, "(\\d{5})(\\d{4})", "$1-$2", ["9(?:0[1-9]|[1-9])"]], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2-$3", ["[1-9][1-9]"], "($1)", "0 $CC ($1)"], [null, "(\\d{2})(\\d{5})(\\d{4})", "$1 $2-$3", ["[1-9][1-9]9"], "($1)", "0 $CC ($1)"]], [[null, "(\\d{4})(\\d{4})", "$1-$2", ["300|4(?:0[02]|37)", "300|4(?:0(?:0|20)|370)"]], [null, "(\\d{3})(\\d{2,3})(\\d{4})", "$1 $2 $3", ["[3589]00"], "0$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2-$3", ["[1-9][1-9]"], "($1)", "0 $CC ($1)"], [null, "(\\d{2})(\\d{5})(\\d{4})", "$1 $2-$3", ["[1-9][1-9]9"], "($1)", "0 $CC ($1)"]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "(?:300\\d|40(?:0\\d|20))\\d{4}", null, null, null, null, null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BS: [null, [null, null, "(?:242|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "242(?:3(?:02|[236][1-9]|4[0-24-9]|5[0-68]|7[347]|8[0-4]|9[2-467])|461|502|6(?:0[1-4]|12|2[013]|[45]0|7[67]|8[78]|9[89])|7(?:02|88))\\d{4}", null, null, null, "2423456789", null, null, null, [7]], [null, null, "242(?:3(?:5[79]|7[56]|95)|4(?:[23][1-9]|4[1-35-9]|5[1-8]|6[2-8]|7\\d|81)|5(?:2[45]|3[35]|44|5[1-46-9]|65|77)|6[34]6|7(?:27|38)|8(?:0[1-9]|1[02-9]|2\\d|[89]9))\\d{4}", null, null, null, "2423591234", null, null, null, [7]], [null, null, "(?:242300|8(?:00|33|44|55|66|77|88)[2-9]\\d\\d)\\d{4}", null, null, null, "8002123456", null, null, null, [7]], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "BS", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "242", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "242225[0-46-9]\\d{3}", null, null, null, "2422250123"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BT: [null, [null, null, "[17]\\d{7}|[2-8]\\d{6}", null, null, null, null, null, null, [7, 8], [6]], [null, null, "(?:2[3-6]|[34][5-7]|5[236]|6[2-46]|7[246]|8[2-4])\\d{5}", null, null, null, "2345678", null, null, [7], [6]], [null, null, "(?:1[67]|77)\\d{6}", null, null, null, "17123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BT", 975, "00", null, null, null, null, null, null, null, [[null, "(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["[23568]|4[5-7]|7[246]"]], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["1[67]|7"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BW: [null, [null, null, "(?:(?:[2-6]|7\\d)\\d|90)\\d{5}", null, null, null, null, null, null, [7, 8]], [null, null, "(?:2(?:4[0-48]|6[0-24]|9[0578])|3(?:1[0-35-9]|55|[69]\\d|7[01])|4(?:6[03]|7[1267]|9[0-5])|5(?:3[0389]|4[0489]|7[1-47]|88|9[0-49])|6(?:2[1-35]|5[149]|8[067]))\\d{4}", null, null, null, "2401234", null, null, [7]], [null, null, "7(?:[1-6]\\d{3}|7(?:[014-8]\\d\\d|200))\\d{3}", null, null, null, "71123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "90\\d{5}", null, null, null, "9012345", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "79(?:1(?:[01]\\d|20)|2[0-2]\\d)\\d{3}", null, null, null, "79101234", null, null, [8]], "BW", 267, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[2-6]"]], [null, "(\\d{2})(\\d{5})", "$1 $2", ["90"]], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["7"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BY: [null, [null, null, "(?:(?:[12]|8[0-7]\\d)\\d|33|44|902)\\d{7}|8(?:[05-79]\\d|1[0-489])\\d{7}|8[0-79]\\d{5,7}|8\\d{5}", null, null, null, null, null, null, [6, 7, 8, 9, 10, 11], [5]], [null, null, "(?:1(?:5(?:1[1-5]|[24]\\d|6[2-4]|9[1-7])|6(?:[235]\\d|4[1-7])|7\\d\\d)|2(?:1(?:[246]\\d|3[0-35-9]|5[1-9])|2(?:[235]\\d|4[0-8])|3(?:[26]\\d|3[02-79]|4[024-7]|5[03-7])))\\d{5}", null, null, null, "152450911", null, null, [9], [5, 6, 7]], [null, null, "(?:2(?:5[5-79]|9[1-9])|(?:33|44)\\d)\\d{6}", null, null, null, "294911911", null, null, [9]], [null, null, "8(?:0[013]|20\\d)\\d{7}|800\\d{3,6}", null, null, null, "8011234567"], [null, null, "(?:810|902)\\d{7}", null, null, null, "9021234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "249\\d{6}", null, null, null, "249123456", null, null, [9]], "BY", 375, "810", "8", null, null, "0|80?", null, "8~10", null, [[null, "(\\d{3})(\\d{3})", "$1 $2", ["800"], "8 $1"], [null, "(\\d{3})(\\d{2})(\\d{2,4})", "$1 $2 $3", ["800"], "8 $1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2-$3-$4", ["1(?:5[24]|6[235]|7[467])|2(?:1[246]|2[25]|3[26])", "1(?:5[24]|6(?:2|3[04-9]|5[0346-9])|7(?:[46]|7[37-9]))|2(?:1[246]|2[25]|3[26])"], "8 0$1"], [null, "(\\d{4})(\\d{2})(\\d{3})", "$1 $2-$3", ["1(?:[56]|7[179])|2[1-3]", "1(?:[56]|7(?:1[3-9]|7|9[2-7]))|2[1-3]"], "8 0$1"], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2-$3-$4", ["[1-4]"], "8 0$1"], [null, "(\\d{3})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["[89]"], "8 $1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "(?:8(?:0[013]|10|20\\d)|902)\\d{7}|800\\d{3,6}"], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BZ: [null, [null, null, "(?:0800\\d|[2-8])\\d{6}", null, null, null, null, null, null, [7, 11]], [null, null, "(?:2(?:[02]\\d|36)|[3-58][02]\\d|7(?:[02]\\d|32))\\d{4}", null, null, null, "2221234", null, null, [7]], [null, null, "6[0-35-7]\\d{5}", null, null, null, "6221234", null, null, [7]], [null, null, "0800\\d{7}", null, null, null, "08001234123", null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BZ", 501, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1-$2", ["[2-8]"]], [null, "(\\d)(\\d{3})(\\d{4})(\\d{3})", "$1-$2-$3-$4", ["0"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CA: [null, [null, null, "(?:[2-8]\\d|90)\\d{8}", null, null, null, null, null, null, [10], [7]], [null, null, "(?:2(?:04|[23]6|[48]9|50)|3(?:06|43|65)|4(?:03|1[68]|3[178]|50)|5(?:06|1[49]|48|79|8[17])|6(?:04|13|39|47)|7(?:0[59]|78|8[02])|8(?:[06]7|19|25|73)|90[25])[2-9]\\d{6}", null, null, null, "5062345678", null, null, null, [7]], [null, null, "(?:2(?:04|[23]6|[48]9|50)|3(?:06|43|65)|4(?:03|1[68]|3[178]|50)|5(?:06|1[49]|48|79|8[17])|6(?:04|13|39|47)|7(?:0[59]|78|8[02])|8(?:[06]7|19|25|73)|90[25])[2-9]\\d{6}", null, null, null, "5062345678", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:5(?:00|2[12]|33|44|66|77|88)|622)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, "600[2-9]\\d{6}", null, null, null, "6002012345"], "CA", 1, "011", "1", null, null, "1", null, null, 1, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CC: [null, [null, null, "1\\d{5,9}|(?:[48]\\d\\d|550)\\d{6}", null, null, null, null, null, null, [6, 7, 8, 9, 10]], [null, null, "8(?:51(?:0(?:02|31|60)|118)|91(?:0(?:1[0-2]|29)|1(?:[28]2|50|79)|2(?:10|64)|3(?:[06]8|22)|4[29]8|62\\d|70[23]|959))\\d{3}", null, null, null, "891621234", null, null, [9], [8]], [null, null, "4(?:[0-3]\\d|4[047-9]|5[0-25-9]|6[6-9]|7[02-9]|8[0-2457-9]|9[017-9])\\d{6}", null, null, null, "412345678", null, null, [9]], [null, null, "180(?:0\\d{3}|2)\\d{3}", null, null, null, "1800123456", null, null, [7, 10]], [null, null, "190[0-26]\\d{6}", null, null, null, "1900123456", null, null, [10]], [null, null, "13(?:00\\d{3}|45[0-4])\\d{3}|13\\d{4}", null, null, null, "1300123456", null, null, [6, 8, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:14(?:5\\d|71)|550\\d)\\d{5}", null, null, null, "550123456", null, null, [9]], "CC", 61, "001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011", "0", null, null, "0|([59]\\d{7})$", "8$1", "0011", null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CD: [null, [null, null, "[189]\\d{8}|[1-68]\\d{6}", null, null, null, null, null, null, [7, 9]], [null, null, "12\\d{7}|[1-6]\\d{6}", null, null, null, "1234567"], [null, null, "(?:8(?:[0-2459]\\d\\d|8)|9[017-9]\\d\\d)\\d{5}", null, null, null, "991234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CD", 243, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3", ["88"], "0$1"], [null, "(\\d{2})(\\d{5})", "$1 $2", ["[1-6]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[89]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CF: [null, [null, null, "(?:[27]\\d{3}|8776)\\d{4}", null, null, null, null, null, null, [8]], [null, null, "2[12]\\d{6}", null, null, null, "21612345"], [null, null, "7[0257]\\d{6}", null, null, null, "70012345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "8776\\d{4}", null, null, null, "87761234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CF", 236, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[278]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CG: [null, [null, null, "(?:(?:0\\d|80)\\d|222)\\d{6}", null, null, null, null, null, null, [9]], [null, null, "222[1-589]\\d{5}", null, null, null, "222123456"], [null, null, "0[14-6]\\d{7}", null, null, null, "061234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "80(?:0\\d\\d|11[0-4])\\d{4}", null, null, null, "800123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CG", 242, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["801"]], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[02]"]], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["8"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CH: [null, [null, null, "8\\d{11}|[2-9]\\d{8}", null, null, null, null, null, null, [9, 12]], [null, null, "(?:2[12467]|3[1-4]|4[134]|5[256]|6[12]|[7-9]1)\\d{7}", null, null, null, "212345678", null, null, [9]], [null, null, "7[35-9]\\d{7}", null, null, null, "781234567", null, null, [9]], [null, null, "800\\d{6}", null, null, null, "800123456", null, null, [9]], [null, null, "90[016]\\d{6}", null, null, null, "900123456", null, null, [9]], [null, null, "84[0248]\\d{6}", null, null, null, "840123456", null, null, [9]], [null, null, "878\\d{6}", null, null, null, "878123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], "CH", 41, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2-7]|[89]1"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["8[047]|9"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["8"], "0$1"]], null, [null, null, "74[0248]\\d{6}", null, null, null, "740123456", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5[18]\\d{7}", null, null, null, "581234567", null, null, [9]], null, null, [null, null, "860\\d{9}", null, null, null, "860123456789", null, null, [12]]],
    CI: [null, [null, null, "[02-8]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "(?:2(?:0[023]|1[02357]|[23][045]|4[03-5])|3(?:0[06]|1[069]|[2-4][07]|5[09]|6[08]))\\d{5}", null, null, null, "21234567"], [null, null, "(?:[07][1-9]|[45]\\d|6[014-9]|8[4-9])\\d{6}", null, null, null, "01234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CI", 225, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[02-8]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CK: [null, [null, null, "[2-8]\\d{4}", null, null, null, null, null, null, [5]], [null, null, "(?:2\\d|3[13-7]|4[1-5])\\d{3}", null, null, null, "21234"], [null, null, "[5-8]\\d{4}", null, null, null, "71234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CK", 682, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{3})", "$1 $2", ["[2-8]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CL: [null, [null, null, "(?:1230|[2-57-9]\\d|6\\d{1,3})\\d{7}", null, null, null, null, null, null, [9, 10, 11]], [null, null, "(?:2(?:1962|(?:2\\d\\d|32[0-46-8])\\d)|(?:(?:3[2-5]|[47][1-35]|5[1-3578]|6[13-57]|9[2-9])\\d|8(?:0[1-9]|[1-9]\\d))\\d\\d)\\d{4}", null, null, null, "221234567", null, null, [9]], [null, null, "(?:2(?:1962|(?:2\\d\\d|32[0-46-8])\\d)|(?:(?:3[2-5]|[47][1-35]|5[1-3578]|6[13-57]|9[2-9])\\d|8(?:0[1-9]|[1-9]\\d))\\d\\d)\\d{4}", null, null, null, "221234567", null, null, [9]], [null, null, "(?:1230\\d|800)\\d{6}", null, null, null, "800123456", null, null, [9, 11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "600\\d{7,8}", null, null, null, "6001234567", null, null, [10, 11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "44\\d{7}", null, null, null, "441234567", null, null, [9]], "CL", 56, "(?:0|1(?:1[0-69]|2[0-57]|5[13-58]|69|7[0167]|8[018]))0", null, null, null, null, null, null, 1, [[null, "(\\d{4})", "$1", ["1(?:[03-58]|[29]1)"]], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["2(?:2|32)", "2(?:2|32[0-46-8])"], "($1)"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["3[2-5]|[47][1-35]|5[1-3578]|6[13-57]|8(?:0[1-9]|[1-9])"], "($1)"], [null, "(\\d{5})(\\d{4})", "$1 $2", ["2"], "($1)"], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["9[2-9]"]], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["44"]], [null, "(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[68]00"]], [null, "(\\d{3})(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["600"]], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"]]], [[null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["2(?:2|32)", "2(?:2|32[0-46-8])"], "($1)"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["3[2-5]|[47][1-35]|5[1-3578]|6[13-57]|8(?:0[1-9]|[1-9])"], "($1)"], [null, "(\\d{5})(\\d{4})", "$1 $2", ["2"], "($1)"], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["9[2-9]"]], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["44"]], [null, "(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[68]00"]], [null, "(\\d{3})(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["600"]], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"]]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "600\\d{7,8}", null, null, null, null, null, null, [10, 11]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CM: [null, [null, null, "(?:[26]\\d\\d|88)\\d{6}", null, null, null, null, null, null, [8, 9]], [null, null, "2(?:22|33|4[23])\\d{6}", null, null, null, "222123456", null, null, [9]], [null, null, "6[5-9]\\d{7}", null, null, null, "671234567", null, null, [9]], [null, null, "88\\d{6}", null, null, null, "88012345", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CM", 237, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["88"]], [null, "(\\d)(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["[26]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CN: [null, [null, null, "(?:(?:(?:1[03-68]|2\\d)\\d\\d|[3-79])\\d|8[0-57-9])\\d{7}|[1-579]\\d{10}|8[0-57-9]\\d{8,9}|[1-79]\\d{9}|[1-9]\\d{7}|[12]\\d{6}", null, null, null, null, null, null, [7, 8, 9, 10, 11, 12], [5, 6]], [null, null, "21(?:100\\d{2}|95\\d{3,4}|\\d{8,10})|(?:10|2[02-57-9]|3(?:11|7[179])|4(?:[15]1|3[1-35])|5(?:1\\d|2[37]|3[12]|51|7[13-79]|9[15])|7(?:31|5[457]|6[09]|91)|8(?:[57]1|98))(?:100\\d{2}|95\\d{3,4}|\\d{8})|(?:3(?:1[02-9]|35|49|5\\d|7[02-68]|9[1-68])|4(?:1[02-9]|2[179]|3[3-9]|5[2-9]|6[4789]|7\\d|8[23])|5(?:3[03-9]|4[36]|5[02-9]|6[1-46]|7[028]|80|9[2-46-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[17]\\d|2[248]|3[04-9]|4[3-6]|5[0-4689]|6[2368]|9[02-9])|8(?:078|1[236-8]|2[5-7]|3\\d|5[1-9]|7[02-9]|8[3678]|9[1-7])|9(?:0[1-3689]|1[1-79]|[379]\\d|4[13]|5[1-5]))(?:100\\d{2}|95\\d{3,4}|\\d{7})", null, null, null, "1012345678", null, null, null, [5, 6]], [null, null, "1(?:[38]\\d{3}|4[57]\\d{2}|5[0-35-9]\\d{2}|6[267]\\d{2}|7(?:[0-35-8]\\d{2}|40[0-5])|9[189]\\d{2})\\d{6}", null, null, null, "13123456789", null, null, [11]], [null, null, "(?:10)?800\\d{7}", null, null, null, "8001234567", null, null, [10, 12]], [null, null, "16[08]\\d{5}", null, null, null, "16812345", null, null, [8]], [null, null, "400\\d{7}|950\\d{7,8}|(?:10|2[0-57-9]|3(?:[157]\\d|35|49|9[1-68])|4(?:[17]\\d|2[179]|[35][1-9]|6[4789]|8[23])|5(?:[1357]\\d|2[37]|4[36]|6[1-46]|80|9[1-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]\\d|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]\\d|5[14-9]|8[3678]|9[1-8])|9(?:0[1-3689]|1[1-79]|[379]\\d|4[13]|5[1-5]))96\\d{3,4}", null, null, null, "4001234567", null, null, [7, 8, 9, 10, 11], [5, 6]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CN", 86, "(?:1(?:[12]\\d{3}|79\\d{2}|9[0-7]\\d{2}))?00", "0", null, null, "0|(1(?:[12]\\d{3}|79\\d{2}|9[0-7]\\d{2}))", null, "00", null, [[null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[48]00"]], [null, "(\\d{5,6})", "$1", ["100|95"]], [null, "(\\d{2})(\\d{5,6})", "$1 $2", ["(?:10|2\\d)[19]", "(?:10|2\\d)(?:10|9[56])", "(?:10|2\\d)(?:100|9[56])"], "0$1", "$CC $1"], [null, "(\\d{3})(\\d{5,6})", "$1 $2", ["[3-9]", "[3-9]\\d\\d[19]", "[3-9]\\d\\d(?:10|9[56])"], "0$1", "$CC $1"], [null, "(\\d{3,4})(\\d{4})", "$1 $2", ["[2-9]"]], [null, "(\\d{2})(\\d{4})(\\d{4,6})", "$1 $2 $3", ["21"], "0$1", "$CC $1", 1], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["10[1-9]|2[02-9]", "10[1-9]|2[02-9]", "10(?:[1-79]|8(?:0[1-9]|[1-9]))|2[02-9]"], "0$1", "$CC $1", 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["3(?:1[02-9]|35|49|5|7[02-68]|9[1-68])|4(?:1[02-9]|2[179]|[35][2-9]|6[47-9]|7|8[23])|5(?:3[03-9]|4[36]|5[02-9]|6[1-46]|7[028]|80|9[2-46-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]|2[248]|3[04-9]|4[3-6]|6[2368])|8(?:1[236-8]|2[5-7]|3|5[1-9]|7[02-9]|8[36-8]|9[1-7])|9(?:0[1-3689]|1[1-79]|[379]|4[13]|5[1-5])"], "0$1", "$CC $1", 1], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["3(?:11|7[179])|4(?:[15]1|3[1-35])|5(?:1|2[37]|3[12]|51|7[13-79]|9[15])|7(?:[39]1|5[457]|6[09])|8(?:[57]1|98)"], "0$1", "$CC $1", 1], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["807", "8078"], "0$1", "$CC $1", 1], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["1(?:[3-57-9]|6[267])"], null, "$CC $1"], [null, "(\\d{5})(\\d{3})(\\d{4})", "$1 $2 $3", ["108", "1080", "10800"]], [null, "(\\d{3})(\\d{7,8})", "$1 $2", ["950"]]], [[null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[48]00"]], [null, "(\\d{2})(\\d{5,6})", "$1 $2", ["(?:10|2\\d)[19]", "(?:10|2\\d)(?:10|9[56])", "(?:10|2\\d)(?:100|9[56])"], "0$1", "$CC $1"], [null, "(\\d{3})(\\d{5,6})", "$1 $2", ["[3-9]", "[3-9]\\d\\d[19]", "[3-9]\\d\\d(?:10|9[56])"], "0$1", "$CC $1"], [null, "(\\d{2})(\\d{4})(\\d{4,6})", "$1 $2 $3", ["21"], "0$1", "$CC $1", 1], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["10[1-9]|2[02-9]", "10[1-9]|2[02-9]", "10(?:[1-79]|8(?:0[1-9]|[1-9]))|2[02-9]"], "0$1", "$CC $1", 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["3(?:1[02-9]|35|49|5|7[02-68]|9[1-68])|4(?:1[02-9]|2[179]|[35][2-9]|6[47-9]|7|8[23])|5(?:3[03-9]|4[36]|5[02-9]|6[1-46]|7[028]|80|9[2-46-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]|2[248]|3[04-9]|4[3-6]|6[2368])|8(?:1[236-8]|2[5-7]|3|5[1-9]|7[02-9]|8[36-8]|9[1-7])|9(?:0[1-3689]|1[1-79]|[379]|4[13]|5[1-5])"], "0$1", "$CC $1", 1], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["3(?:11|7[179])|4(?:[15]1|3[1-35])|5(?:1|2[37]|3[12]|51|7[13-79]|9[15])|7(?:[39]1|5[457]|6[09])|8(?:[57]1|98)"], "0$1", "$CC $1", 1], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["807", "8078"], "0$1", "$CC $1", 1], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["1(?:[3-57-9]|6[267])"], null, "$CC $1"], [null, "(\\d{5})(\\d{3})(\\d{4})", "$1 $2 $3", ["108", "1080", "10800"]], [null, "(\\d{3})(\\d{7,8})", "$1 $2", ["950"]]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "(?:4|(?:10)?8)00\\d{7}|950\\d{7,8}", null, null, null, null, null, null, [10, 11, 12]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CO: [null, [null, null, "(?:1\\d|3)\\d{9}|[124-8]\\d{7}", null, null, null, null, null, null, [8, 10, 11], [7]], [null, null, "[124-8][2-9]\\d{6}", null, null, null, "12345678", null, null, [8], [7]], [null, null, "3(?:0[0-5]|1\\d|2[0-3]|5[01])\\d{7}", null, null, null, "3211234567", null, null, [10]], [null, null, "1800\\d{7}", null, null, null, "18001234567", null, null, [11]], [null, null, "19(?:0[01]|4[78])\\d{7}", null, null, null, "19001234567", null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CO", 57, "00(?:4(?:[14]4|56)|[579])", "0", null, null, "0([3579]|4(?:[14]4|56))?", null, null, null, [[null, "(\\d)(\\d{7})", "$1 $2", ["1(?:[2-79]|8[2-9])|[24-8]"], "($1)", "0$CC $1"], [null, "(\\d{3})(\\d{7})", "$1 $2", ["3"], null, "0$CC $1"], [null, "(\\d)(\\d{3})(\\d{7})", "$1-$2-$3", ["1(?:80|9)", "1(?:800|9)"], "0$1"]], [[null, "(\\d)(\\d{7})", "$1 $2", ["1(?:[2-79]|8[2-9])|[24-8]"], "($1)", "0$CC $1"], [null, "(\\d{3})(\\d{7})", "$1 $2", ["3"], null, "0$CC $1"], [null, "(\\d)(\\d{3})(\\d{7})", "$1 $2 $3", ["1(?:80|9)", "1(?:800|9)"]]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CR: [null, [null, null, "(?:8\\d|90)\\d{8}|[24-8]\\d{7}", null, null, null, null, null, null, [8, 10]], [null, null, "2(?:[024-7]\\d\\d|1(?:0[7-9]|[1-9]\\d))\\d{4}", null, null, null, "22123456", null, null, [8]], [null, null, "(?:(?:5(?:0[01]|7[0-3])|(?:7[0-3]|8[3-9])\\d)\\d\\d|6(?:[0-4]\\d{3}|500[01]))\\d{3}", null, null, null, "83123456", null, null, [8]], [null, null, "800\\d{7}", null, null, null, "8001234567", null, null, [10]], [null, null, "90[059]\\d{7}", null, null, null, "9001234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:210[0-6]|4\\d{3}|5100)\\d{4}", null, null, null, "40001234", null, null, [8]], "CR", 506, "00", null, null, null, "(19(?:0[0-2468]|1[09]|20|66|77|99))", null, null, null, [[null, "(\\d{4})(\\d{4})", "$1 $2", ["[24-7]|8[3-9]"], null, "$CC $1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3", ["[89]"], null, "$CC $1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CU: [null, [null, null, "[2-57]\\d{7}|[2-47]\\d{6}|[34]\\d{5}", null, null, null, null, null, null, [6, 7, 8], [4, 5]], [null, null, "(?:2[1-4]|7\\d)\\d{5,6}|(?:3[1-3]|4[1-35-8])\\d{6}|3[23]\\d{4,5}|4[12578]\\d{5}|4[78]\\d{4}", null, null, null, "71234567", null, null, null, [4, 5]], [null, null, "5\\d{7}", null, null, null, "51234567", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CU", 53, "119", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{4,6})", "$1 $2", ["[2-4]"], "(0$1)"], [null, "(\\d)(\\d{6,7})", "$1 $2", ["7"], "(0$1)"], [null, "(\\d)(\\d{7})", "$1 $2", ["5"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CV: [null, [null, null, "[2-59]\\d{6}", null, null, null, null, null, null, [7]], [null, null, "2(?:2[1-7]|3[0-8]|4[12]|5[1256]|6\\d|7[1-3]|8[1-5])\\d{4}", null, null, null, "2211234"], [null, null, "(?:[34][36]|5[1-389]|9\\d)\\d{5}", null, null, null, "9911234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CV", 238, "0", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3", ["[2-59]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CW: [null, [null, null, "(?:[34]1|60|(?:7|9\\d)\\d)\\d{5}", null, null, null, null, null, null, [7, 8]], [null, null, "9(?:(?:[48]\\d|50)\\d|7(?:2[0-24]|[34]\\d|6[35-7]|77|8[7-9]))\\d{4}", null, null, null, "94151234"], [null, null, "9(?:5(?:[12467]\\d|3[01])|6(?:[15-9]\\d|3[01]))\\d{4}", null, null, null, "95181234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "60[0-2]\\d{4}", null, null, null, "6001234", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CW", 599, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[3467]"]], [null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["9[4-8]"]]], null, [null, null, "955\\d{5}", null, null, null, "95581234", null, null, [8]], 1, "[69]", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CX: [null, [null, null, "1\\d{5,9}|(?:[48]\\d\\d|550)\\d{6}", null, null, null, null, null, null, [6, 7, 8, 9, 10]], [null, null, "8(?:51(?:0(?:01|30|59)|117)|91(?:00[6-9]|1(?:[28]1|49|78)|2(?:09|63)|3(?:12|26|75)|4(?:56|97)|64\\d|7(?:0[01]|1[0-2])|958))\\d{3}", null, null, null, "891641234", null, null, [9], [8]], [null, null, "4(?:[0-3]\\d|4[047-9]|5[0-25-9]|6[6-9]|7[02-9]|8[0-2457-9]|9[017-9])\\d{6}", null, null, null, "412345678", null, null, [9]], [null, null, "180(?:0\\d{3}|2)\\d{3}", null, null, null, "1800123456", null, null, [7, 10]], [null, null, "190[0-26]\\d{6}", null, null, null, "1900123456", null, null, [10]], [null, null, "13(?:00\\d{3}|45[0-4])\\d{3}|13\\d{4}", null, null, null, "1300123456", null, null, [6, 8, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:14(?:5\\d|71)|550\\d)\\d{5}", null, null, null, "550123456", null, null, [9]], "CX", 61, "001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011", "0", null, null, "0|([59]\\d{7})$", "8$1", "0011", null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CY: [null, [null, null, "(?:[279]\\d|[58]0)\\d{6}", null, null, null, null, null, null, [8]], [null, null, "2[2-6]\\d{6}", null, null, null, "22345678"], [null, null, "9[4-79]\\d{6}", null, null, null, "96123456"], [null, null, "800\\d{5}", null, null, null, "80001234"], [null, null, "90[09]\\d{5}", null, null, null, "90012345"], [null, null, "80[1-9]\\d{5}", null, null, null, "80112345"], [null, null, "700\\d{5}", null, null, null, "70012345"], [null, null, null, null, null, null, null, null, null, [-1]], "CY", 357, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{6})", "$1 $2", ["[257-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:50|77)\\d{6}", null, null, null, "77123456"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CZ: [null, [null, null, "(?:[2-578]\\d|60|9\\d{1,4})\\d{7}", null, null, null, null, null, null, [9, 10, 11, 12]], [null, null, "(?:2\\d|3[1257-9]|4[16-9]|5[13-9])\\d{7}", null, null, null, "212345678", null, null, [9]], [null, null, "(?:60[1-8]|7(?:0[2-5]|[2379]\\d))\\d{6}", null, null, null, "601123456", null, null, [9]], [null, null, "800\\d{6}", null, null, null, "800123456", null, null, [9]], [null, null, "9(?:0[05689]|76)\\d{6}", null, null, null, "900123456", null, null, [9]], [null, null, "8[134]\\d{7}", null, null, null, "811234567", null, null, [9]], [null, null, "70[01]\\d{6}", null, null, null, "700123456", null, null, [9]], [null, null, "9[17]0\\d{6}", null, null, null, "910123456", null, null, [9]], "CZ", 420, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[2-8]|9[015-7]"]], [null, "(\\d{2})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["9[36]"]], [null, "(\\d{3})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["96"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "9(?:5\\d|7[2-4])\\d{6}", null, null, null, "972123456", null, null, [9]], null, null, [null, null, "9(?:3\\d{9}|6\\d{7,10})", null, null, null, "93123456789"]],
    DE: [null, [null, null, "(?:1|[235-9]\\d{11}|4(?:[0-8]\\d{2,10}|9(?:[05]\\d{7}|[46][1-8]\\d{2,6})))\\d{3}|[1-35-9]\\d{6,13}|49(?:(?:[0-25]\\d|3[1-689])\\d{4,8}|4[1-8]\\d{4}|6[0-8]\\d{3,4}|7[1-7]\\d{5,8})|497[0-7]\\d{4}|49(?:[0-2579]\\d|[34][1-9])\\d{3}|[1-9]\\d{5}|[13468]\\d{4}", null, null, null, null, null, null, [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15], [3]], [null, null, "(?:2(?:0[1-689]|[1-3569]\\d|4[0-8]|7[1-7]|8[0-7])|5(?:0[2-8]|[124-6]\\d|[38][0-8]|[79][0-7])|6(?:0[02-9]|[1-3589]\\d|[47][0-8]|6[1-9])|7(?:0[2-8]|1[1-9]|[27][0-7]|3\\d|[4-6][0-8]|8[0-5]|9[013-7])|8(?:0[2-9]|1[0-79]|[29]\\d|3[0-46-9]|4[0-6]|5[013-9]|6[1-8]|7[0-8]|8[0-24-6])|9(?:0[6-9]|[1-4]\\d|[589][0-7]|6[0-8]|7[0-467]))\\d{4,12}|3(?:(?:[03569]\\d|4[0-79]|7[1-7]|8[1-8])\\d{4,12}|2\\d{9})|4(?:(?:[02-48]\\d|1[02-9]|5[0-6]|6[0-8]|7[0-79])\\d{4,12}|9(?:[0-37]\\d{4,9}|[4-6]\\d{4,10}))|(?:2(?:0[1-389]|1[124]|2[18]|3[14]|[4-9]1)|3(?:0\\d?|[35-9][15]|4[015])|4(?:0\\d?|[2-9]1)|[57][1-9]1|[68](?:[1-8]1|9\\d?)|9(?:06|[1-9]1))\\d{3}", null, null, null, "30123456", null, null, [5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15], [3, 4]], [null, null, "1(?:5[0-25-9]\\d{8}|(?:6[023]|7\\d)\\d{7,8})", null, null, null, "15123456789", null, null, [10, 11]], [null, null, "800\\d{7,12}", null, null, null, "8001234567890", null, null, [10, 11, 12, 13, 14, 15]], [null, null, "(?:137[7-9]|900(?:[135]|9\\d))\\d{6}", null, null, null, "9001234567", null, null, [10, 11]], [null, null, "1(?:3(?:7[1-6]\\d\\d|8)|80\\d{1,7})\\d{4}", null, null, null, "18012345", null, null, [7, 8, 9, 10, 11, 12, 13, 14]], [null, null, "700\\d{8}", null, null, null, "70012345678", null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], "DE", 49, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3,13})", "$1 $2", ["3[02]|40|[68]9"], "0$1"], [null, "(\\d{3})(\\d{3,12})", "$1 $2", ["2(?:0[1-389]|1[124]|2[18]|3[14]|[4-9]1)|3(?:[35-9][15]|4[015])|(?:4[2-9]|[57][1-9]|[68][1-8])1|9(?:06|[1-9]1)", "2(?:0[1-389]|1(?:[14]|2[0-8])|2[18]|3[14]|[4-9]1)|3(?:[35-9][15]|4[015])|(?:4[2-9]|[57][1-9]|[68][1-8])1|9(?:06|[1-9]1)"], "0$1"], [null, "(\\d{3})(\\d{4})", "$1 $2", ["138"], "0$1"], [null, "(\\d{4})(\\d{3,11})", "$1 $2", ["[24-6]|3(?:[3569][02-46-9]|4[2-4679]|7[2-467]|8[2-46-8])|7(?:0[2-8]|[1-9])|8(?:0[2-9]|[1-8])|9(?:0[7-9]|[1-9])", "[24-6]|3(?:3(?:0[1-467]|2[127-9]|3[124578]|[46][1246]|7[1257-9]|8[1256]|9[145])|4(?:2[135]|3[1357]|4[13578]|6[1246]|7[1356]|9[1346])|5(?:0[14]|2[1-3589]|3[1357]|[49][1246]|6[1-4]|7[13468]|8[13568])|6(?:0[1356]|2[1-489]|3[124-6]|4[1347]|6[13]|7[12579]|8[1-356]|9[135])|7(?:2[1-7]|3[1357]|4[145]|6[1-5]|7[1-4])|8(?:21|3[1468]|4[1347]|6|7[1467]|8[136])|9(?:0[12479]|2[1358]|3[1357]|4[134679]|6[1-9]|7[136]|8[147]|9[1468]))|7(?:0[2-8]|[1-9])|8(?:0[2-9]|[1-8])|9(?:0[7-9]|[1-9])"], "0$1"], [null, "(\\d{3})(\\d{5,11})", "$1 $2", ["181"], "0$1"], [null, "(\\d{3})(\\d)(\\d{4,10})", "$1 $2 $3", ["1(?:3|80)|9"], "0$1"], [null, "(\\d{5})(\\d{3,10})", "$1 $2", ["3"], "0$1"], [null, "(\\d{3})(\\d{7,8})", "$1 $2", ["1(?:6[02-489]|7)"], "0$1"], [null, "(\\d{3})(\\d{7,12})", "$1 $2", ["8"], "0$1"], [null, "(\\d{4})(\\d{7})", "$1 $2", ["15[1279]"], "0$1"], [null, "(\\d{5})(\\d{6})", "$1 $2", ["15[0568]"], "0$1"], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["7"], "0$1"], [null, "(\\d{3})(\\d{8})", "$1 $2", ["18[2-579]", "18[2-579]", "18(?:[2-479]|5(?:0[1-9]|[1-9]))"], "0$1"], [null, "(\\d{4})(\\d{7})", "$1 $2", ["18[68]"], "0$1"], [null, "(\\d{5})(\\d{6})", "$1 $2", ["18"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{7,8})", "$1 $2 $3", ["1(?:6[023]|7)"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{8})", "$1 $2 $3", ["15[013-68]"], "0$1"], [null, "(\\d{4})(\\d{2})(\\d{7})", "$1 $2 $3", ["15"], "0$1"]], null, [null, null, "16(?:4\\d{1,10}|[89]\\d{1,11})", null, null, null, "16412345", null, null, [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "18(?:1\\d{5,11}|[2-9]\\d{8})", null, null, null, "18500123456", null, null, [8, 9, 10, 11, 12, 13, 14]], null, null, [null, null, "1(?:5(?:(?:[03-68]00|113)\\d|2\\d55|7\\d99|9\\d33)|(?:6(?:013|255|399)|7(?:(?:[015]1|[69]3)3|[2-4]55|[78]99))\\d?)\\d{7}", null, null, null, "177991234567", null, null, [12, 13]]],
    DJ: [null, [null, null, "(?:2\\d|77)\\d{6}", null, null, null, null, null, null, [8]], [null, null, "2(?:1[2-5]|7[45])\\d{5}", null, null, null, "21360003"], [null, null, "77\\d{6}", null, null, null, "77831001"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "DJ", 253, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[27]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    DK: [null, [null, null, "[2-9]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "(?:[2-7]\\d|8[126-9]|9[1-36-9])\\d{6}", null, null, null, "32123456"], [null, null, "(?:[2-7]\\d|8[126-9]|9[1-36-9])\\d{6}", null, null, null, "32123456"], [null, null, "80\\d{6}", null, null, null, "80123456"], [null, null, "90\\d{6}", null, null, null, "90123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "DK", 45, "00", null, null, null, null, null, null, 1, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    DM: [null, [null, null, "(?:[58]\\d\\d|767|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "767(?:2(?:55|66)|4(?:2[01]|4[0-25-9])|50[0-4]|70[1-3])\\d{4}", null, null, null, "7674201234", null, null, null, [7]], [null, null, "767(?:2(?:[2-4689]5|7[5-7])|31[5-7]|61[1-7])\\d{4}", null, null, null, "7672251234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "DM", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "767", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    DO: [null, [null, null, "(?:[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "8(?:[04]9[2-9]\\d\\d|29(?:2(?:[0-59]\\d|6[04-9]|7[0-27]|8[0237-9])|3(?:[0-35-9]\\d|4[7-9])|[45]\\d\\d|6(?:[0-27-9]\\d|[3-5][1-9]|6[0135-8])|7(?:0[013-9]|[1-37]\\d|4[1-35689]|5[1-4689]|6[1-57-9]|8[1-79]|9[1-8])|8(?:0[146-9]|1[0-48]|[248]\\d|3[1-79]|5[01589]|6[013-68]|7[124-8]|9[0-8])|9(?:[0-24]\\d|3[02-46-9]|5[0-79]|60|7[0169]|8[57-9]|9[02-9])))\\d{4}", null, null, null, "8092345678", null, null, null, [7]], [null, null, "8[024]9[2-9]\\d{6}", null, null, null, "8092345678", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "DO", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "8[024]9", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    DZ: [null, [null, null, "(?:[1-4]|[5-79]\\d|80)\\d{7}", null, null, null, null, null, null, [8, 9]], [null, null, "(?:(?:1\\d|2[013-79]|3[0-8]|4[0135689])\\d|9619)\\d{5}", null, null, null, "12345678"], [null, null, "(?:(?:5[4-6]|7[7-9])\\d|6(?:[569]\\d|7[0-6]))\\d{6}", null, null, null, "551234567", null, null, [9]], [null, null, "800\\d{6}", null, null, null, "800123456", null, null, [9]], [null, null, "80[3-689]1\\d{5}", null, null, null, "808123456", null, null, [9]], [null, null, "80[12]1\\d{5}", null, null, null, "801123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "98[23]\\d{6}", null, null, null, "983123456", null, null, [9]], "DZ", 213, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[1-4]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[5-8]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["9"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    EC: [null, [null, null, "1800\\d{6,7}|(?:[2-7]|9\\d)\\d{7}", null, null, null, null, null, null, [8, 9, 10, 11], [7]], [null, null, "[2-7][2-7]\\d{6}", null, null, null, "22123456", null, null, [8], [7]], [null, null, "9(?:(?:39|[57][89]|[89]\\d)\\d|6(?:[0-27-9]\\d|30))\\d{5}", null, null, null, "991234567", null, null, [9]], [null, null, "1800\\d{6,7}", null, null, null, "18001234567", null, null, [10, 11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "[2-7]890\\d{4}", null, null, null, "28901234", null, null, [8]], "EC", 593, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{4})", "$1-$2", ["[2-7]"]], [null, "(\\d)(\\d{3})(\\d{4})", "$1 $2-$3", ["[2-7]"], "(0$1)"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["9"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["1"]]], [[null, "(\\d)(\\d{3})(\\d{4})", "$1-$2-$3", ["[2-7]"]], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["9"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["1"]]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    EE: [null, [null, null, "8\\d{9}|[4578]\\d{7}|(?:[3-8]\\d\\d|900)\\d{4}", null, null, null, null, null, null, [7, 8, 10]], [null, null, "(?:3[23589]|4[3-8]|6\\d|7[1-9]|88)\\d{5}", null, null, null, "3212345", null, null, [7]], [null, null, "(?:5\\d|8[1-4])\\d{6}|5(?:(?:[02]\\d|5[0-478])\\d|1(?:[0-8]\\d|95)|6(?:4[0-4]|5[1-589]))\\d{3}", null, null, null, "51234567", null, null, [7, 8]], [null, null, "800(?:(?:0\\d\\d|1)\\d|[2-9])\\d{3}", null, null, null, "80012345"], [null, null, "(?:40\\d\\d|900)\\d{4}", null, null, null, "9001234", null, null, [7, 8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "70[0-2]\\d{5}", null, null, null, "70012345", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], "EE", 372, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[369]|4[3-8]|5(?:[0-2]|5[0-478]|6[45])|7[1-9]", "[369]|4[3-8]|5(?:[02]|1(?:[0-8]|95)|5[0-478]|6(?:4[0-4]|5[1-589]))|7[1-9]"]], [null, "(\\d{4})(\\d{3,4})", "$1 $2", ["[45]|8(?:00|[1-4])", "[45]|8(?:00[1-9]|[1-4])"]], [null, "(\\d{2})(\\d{2})(\\d{4})", "$1 $2 $3", ["7"]], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["80"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "800[2-9]\\d{3}", null, null, null, null, null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    EG: [null, [null, null, "(?:[189]\\d?|[24-6])\\d{8}|[13]\\d{7}", null, null, null, null, null, null, [8, 9, 10], [6, 7]], [null, null, "(?:1(?:3[23]|5\\d?)|(?:2[2-4]|3)\\d|4(?:0[2-5]|[578][23]|64)|5(?:0[2-7]|5\\d|7[23])|6[24-689]3|8(?:2[2-57]|4[26]|6[237]|8[2-4])|9(?:2[27]|3[24]|52|6[2356]|7[2-4]))\\d{6}", null, null, null, "234567890", null, null, [8, 9], [6, 7]], [null, null, "1[0-25]\\d{8}", null, null, null, "1001234567", null, null, [10]], [null, null, "800\\d{7}", null, null, null, "8001234567", null, null, [10]], [null, null, "900\\d{7}", null, null, null, "9001234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "EG", 20, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{7,8})", "$1 $2", ["[23]"], "0$1"], [null, "(\\d{2})(\\d{6,7})", "$1 $2", ["1[35]|[4-6]|8[2468]|9[235-7]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[189]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    EH: [null, [null, null, "[5-8]\\d{8}", null, null, null, null, null, null, [9]], [null, null, "528[89]\\d{5}", null, null, null, "528812345"], [null, null, "(?:6(?:[0-79]\\d|8[0-247-9])|7(?:0[067]|6[1267]|7[017]))\\d{6}", null, null, null, "650123456"], [null, null, "80\\d{7}", null, null, null, "801234567"], [null, null, "89\\d{7}", null, null, null, "891234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5924[01]\\d{4}", null, null, null, "592401234"], "EH", 212, "00", "0", null, null, "0", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "528[89]", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    ER: [null, [null, null, "[178]\\d{6}", null, null, null, null, null, null, [7], [6]], [null, null, "(?:1(?:1[12568]|[24]0|55|6[146])|8\\d\\d)\\d{4}", null, null, null, "8370362", null, null, null, [6]], [null, null, "(?:17[1-3]|7\\d\\d)\\d{4}", null, null, null, "7123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "ER", 291, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["[178]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    ES: [null, [null, null, "(?:51|[6-9]\\d)\\d{7}", null, null, null, null, null, null, [9]], [null, null, "(?:8(?:[1356]\\d|[28][0-8]|[47][1-9])\\d{4}|9(?:(?:(?:[135]\\d|[28][0-8]|4[1-9])\\d\\d|7(?:[124-9]\\d\\d|3(?:[0-8]\\d|9[1-9])))\\d\\d|6(?:[0-8]\\d{4}|9(?:0(?:[0-57-9]\\d\\d|6(?:0[0-8]|1[1-9]|[2-9]\\d))|[1-9]\\d{3}))))\\d\\d", null, null, null, "810123456"], [null, null, "(?:(?:6\\d|7[1-48])\\d{5}|9(?:6906(?:09|10)|7390\\d\\d))\\d\\d", null, null, null, "612345678"], [null, null, "[89]00\\d{6}", null, null, null, "800123456"], [null, null, "80[367]\\d{6}", null, null, null, "803123456"], [null, null, "90[12]\\d{6}", null, null, null, "901123456"], [null, null, "70\\d{7}", null, null, null, "701234567"], [null, null, null, null, null, null, null, null, null, [-1]], "ES", 34, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[89]00"]], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[568]|7[0-48]|9(?:0[12]|[1-8])"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "51\\d{7}", null, null, null, "511234567"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    ET: [null, [null, null, "(?:11|[2-59]\\d)\\d{7}", null, null, null, null, null, null, [9], [7]], [null, null, "(?:11(?:1(?:1[124]|2[2-57]|3[1-5]|5[5-8]|8[6-8])|2(?:13|3[6-8]|5[89]|7[05-9]|8[2-6])|3(?:2[01]|3[0-289]|4[1289]|7[1-4]|87)|4(?:1[69]|3[2-49]|4[0-3]|6[5-8])|5(?:1[578]|44|5[0-4])|6(?:18|2[69]|39|4[5-7]|5[1-5]|6[0-59]|8[015-8]))|2(?:2(?:11[1-9]|22[0-7]|33\\d|44[1467]|66[1-68])|5(?:11[124-6]|33[2-8]|44[1467]|55[14]|66[1-3679]|77[124-79]|880))|3(?:3(?:11[0-46-8]|(?:22|55)[0-6]|33[0134689]|44[04]|66[01467])|4(?:44[0-8]|55[0-69]|66[0-3]|77[1-5]))|4(?:6(?:22[0-24-7]|33[1-5]|44[13-69]|55[14-689]|660|88[1-4])|7(?:(?:11|22)[1-9]|33[13-7]|44[13-6]|55[1-689]))|5(?:7(?:227|55[05]|(?:66|77)[14-8])|8(?:11[149]|22[013-79]|33[0-68]|44[013-8]|550|66[1-5]|77\\d)))\\d{4}", null, null, null, "111112345", null, null, null, [7]], [null, null, "9\\d{8}", null, null, null, "911234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "ET", 251, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[1-59]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    FI: [null, [null, null, "(?:[124-7]\\d|3[0-46-9])\\d{8}|[1-9]\\d{5,8}|[1-35689]\\d{4}", null, null, null, null, null, null, [5, 6, 7, 8, 9, 10]], [null, null, "(?:1[3-79][1-8]|[235689][1-8]\\d)\\d{2,6}", null, null, null, "131234567", null, null, [5, 6, 7, 8, 9]], [null, null, "(?:4[0-8]|50)\\d{4,8}", null, null, null, "412345678", null, null, [6, 7, 8, 9, 10]], [null, null, "800\\d{4,6}", null, null, null, "800123456", null, null, [7, 8, 9]], [null, null, "[67]00\\d{5,6}", null, null, null, "600123456", null, null, [8, 9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "FI", 358, "00|99(?:[01469]|5(?:[14]1|3[23]|5[59]|77|88|9[09]))", "0", null, null, "0", null, "00", null, [[null, "(\\d{5})", "$1", ["7"], "0$1"], [null, "(\\d)(\\d{4,9})", "$1 $2", ["[2568][1-8]|3(?:0[1-9]|[1-9])|9"], "0$1"], [null, "(\\d{2})(\\d{4,8})", "$1 $2", ["1(?:0[1-9]|[3-79][1-8]|8)|2(?:0[1-9]|9)|[45]|7[135]"], "0$1"], [null, "(\\d{3})(\\d{3,7})", "$1 $2", ["(?:1|20)0|[36-8]"], "0$1"]], [[null, "(\\d)(\\d{4,9})", "$1 $2", ["[2568][1-8]|3(?:0[1-9]|[1-9])|9"], "0$1"], [null, "(\\d{2})(\\d{4,8})", "$1 $2", ["1(?:0[1-9]|[3-79][1-8]|8)|2(?:0[1-9]|9)|[45]|7[135]"], "0$1"], [null, "(\\d{3})(\\d{3,7})", "$1 $2", ["(?:1|20)0|[36-8]"], "0$1"]], [null, null, null, null, null, null, null, null, null, [-1]], 1, "1[03-79]|[2-9]", [null, null, "[13]00\\d{3,7}|20(?:0\\d{3,7}|(?:2[023]|9[89])\\d{1,6})|60(?:[12]\\d{5,6}|6\\d{7})|7(?:(?:1|3\\d)\\d{7}|5[03-9]\\d{3,7})"], [null, null, "(?:10|[23][09])\\d{4,8}|60(?:[12]\\d{5,6}|6\\d{7})|7(?:(?:1|3\\d)\\d{7}|5[03-9]\\d{3,7})|20[2-59]\\d\\d", null, null, null, "10112345"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    FJ: [null, [null, null, "(?:(?:0800\\d|[235-9])\\d|45)\\d{5}", null, null, null, null, null, null, [7, 11]], [null, null, "(?:(?:3[0-5]|8[58])\\d|6(?:03|[25-7]\\d))\\d{4}", null, null, null, "3212345", null, null, [7]], [null, null, "(?:[279]\\d|45|5[01568]|8[034679])\\d{5}", null, null, null, "7012345", null, null, [7]], [null, null, "0800\\d{7}", null, null, null, "08001234567", null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "FJ", 679, "0(?:0|52)", null, null, null, null, null, "00", null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[235-9]|45"]], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["0"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    FK: [null, [null, null, "[2-7]\\d{4}", null, null, null, null, null, null, [5]], [null, null, "[2-47]\\d{4}", null, null, null, "31234"], [null, null, "[56]\\d{4}", null, null, null, "51234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "FK", 500, "00", null, null, null, null, null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    FM: [null, [null, null, "[39]\\d{6}", null, null, null, null, null, null, [7]], [null, null, "(?:3[2357]0[1-9]|9[2-6]\\d\\d)\\d{3}", null, null, null, "3201234"], [null, null, "(?:3[2357]0[1-9]|9[2-7]\\d\\d)\\d{3}", null, null, null, "3501234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "FM", 691, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["3(?:20|[357])|9", "3(?:20[1-9]|[357])|9"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    FO: [null, [null, null, "(?:[2-8]\\d|90)\\d{4}", null, null, null, null, null, null, [6]], [null, null, "(?:20|[34]\\d|8[19])\\d{4}", null, null, null, "201234"], [null, null, "(?:[27][1-9]|5\\d)\\d{4}", null, null, null, "211234"], [null, null, "80[257-9]\\d{3}", null, null, null, "802123"], [null, null, "90(?:[13-5][15-7]|2[125-7]|99)\\d\\d", null, null, null, "901123"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:6[0-36]|88)\\d{4}", null, null, null, "601234"], "FO", 298, "00", null, null, null, "(10(?:01|[12]0|88))", null, null, null, [[null, "(\\d{6})", "$1", ["[2-9]"], null, "$CC $1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    FR: [null, [null, null, "[1-9]\\d{8}", null, null, null, null, null, null, [9]], [null, null, "[1-5]\\d{8}", null, null, null, "123456789"], [null, null, "(?:6\\d\\d|7(?:00|[3-9]\\d))\\d{6}", null, null, null, "612345678"], [null, null, "80[0-5]\\d{6}", null, null, null, "801234567"], [null, null, "8[129]\\d{7}", null, null, null, "891123456"], [null, null, "884\\d{6}", null, null, null, "884012345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "9\\d{8}", null, null, null, "912345678"], "FR", 33, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{3})", "$1 $2", ["11"]], [null, "(\\d)(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["[1-79]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["8"], "0 $1"]], [[null, "(\\d)(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["[1-79]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["8"], "0 $1"]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "80[6-9]\\d{6}", null, null, null, "806123456"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GA: [null, [null, null, "(?:0\\d|[2-7])\\d{6}", null, null, null, null, null, null, [7, 8]], [null, null, "01\\d{6}", null, null, null, "01441234", null, null, [8]], [null, null, "(?:0[2-7]|[2-7])\\d{6}", null, null, null, "06031234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GA", 241, "00", null, null, null, null, null, null, null, [[null, "(\\d)(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2-7]"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["0"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GB: [null, [null, null, "[1-357-9]\\d{9}|[18]\\d{8}|8\\d{6}", null, null, null, null, null, null, [7, 9, 10], [4, 5, 6, 8]], [null, null, "(?:1(?:1(?:3[0-58]|4[0-5]|5[0-26-9]|6[0-4]|[78][0-49])|2(?:0[024-9]|1[0-7]|2[3-9]|3[3-79]|4[1-689]|[58][02-9]|6[0-47-9]|7[013-9]|9\\d)|3(?:0\\d|1[0-8]|[25][02-9]|3[02-579]|[468][0-46-9]|7[1-35-79]|9[2-578])|4(?:0[03-9]|[137]\\d|[28][02-57-9]|4[02-69]|5[0-8]|[69][0-79])|5(?:0[1-35-9]|[16]\\d|2[024-9]|3[015689]|4[02-9]|5[03-9]|7[0-35-9]|8[0-468]|9[0-57-9])|6(?:0[034689]|1\\d|2[0-35689]|[38][013-9]|4[1-467]|5[0-69]|6[13-9]|7[0-8]|9[0-24578])|7(?:0[0246-9]|2\\d|3[0236-8]|4[03-9]|5[0-46-9]|6[013-9]|7[0-35-9]|8[024-9]|9[02-9])|8(?:0[35-9]|2[1-57-9]|3[02-578]|4[0-578]|5[124-9]|6[2-69]|7\\d|8[02-9]|9[02569])|9(?:0[02-589]|[18]\\d|2[02-689]|3[1-57-9]|4[2-9]|5[0-579]|6[2-47-9]|7[0-24578]|9[2-57]))|2(?:0[01378]|3[0189]|4[017]|8[0-46-9]|9[0-2])\\d)\\d{6}|1(?:(?:2(?:0(?:46[1-4]|87[2-9])|545[1-79]|76(?:2\\d|3[1-8]|6[1-6])|9(?:7(?:2[0-4]|3[2-5])|8(?:2[2-8]|7[0-47-9]|8[3-5])))|3(?:6(?:38[2-5]|47[23])|8(?:47[04-9]|64[0157-9]))|4(?:044[1-7]|20(?:2[23]|8\\d)|6(?:0(?:30|5[2-57]|6[1-8]|7[2-8])|140)|8(?:052|87[1-3]))|5(?:2(?:4(?:3[2-79]|6\\d)|76\\d)|6(?:26[06-9]|686))|6(?:06(?:4\\d|7[4-79])|295[5-7]|35[34]\\d|47(?:24|61)|59(?:5[08]|6[67]|74)|9(?:55[0-4]|77[23]))|8(?:27[56]\\d|37(?:5[2-5]|8[239])|843[2-58])|9(?:0(?:0(?:6[1-8]|85)|52\\d)|3583|4(?:66[1-8]|9(?:2[01]|81))|63(?:23|3[1-4])|9561))\\d|7(?:(?:26(?:6[13-9]|7[0-7])|442\\d|50(?:2[0-3]|[3-68]2|76))\\d|6888[2-46-8]))\\d\\d", null, null, null, "1212345678", null, null, [9, 10], [4, 5, 6, 7, 8]], [null, null, "7(?:(?:[1-3]\\d\\d|5(?:0[0-8]|[13-9]\\d|2[0-35-9])|8(?:[014-9]\\d|[23][0-8]))\\d|4(?:[0-46-9]\\d\\d|5(?:[0-689]\\d|7[0-57-9]))|7(?:0(?:0[01]|[1-9]\\d)|(?:[1-7]\\d|8[02-9]|9[0-689])\\d)|9(?:(?:[024-9]\\d|3[0-689])\\d|1(?:[02-9]\\d|1[028])))\\d{5}", null, null, null, "7400123456", null, null, [10]], [null, null, "80[08]\\d{7}|800\\d{6}|8001111", null, null, null, "8001234567"], [null, null, "(?:8(?:4[2-5]|7[0-3])|9(?:[01]\\d|8[2-49]))\\d{7}|845464\\d", null, null, null, "9012345678", null, null, [7, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "70\\d{8}", null, null, null, "7012345678", null, null, [10]], [null, null, "56\\d{8}", null, null, null, "5612345678", null, null, [10]], "GB", 44, "00", "0", " x", null, "0", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3", ["845", "8454", "84546", "845464"], "0$1"], [null, "(\\d{3})(\\d{4})", "$1 $2", ["800", "8001", "80011", "800111", "8001111"], "0$1"], [null, "(\\d{3})(\\d{6})", "$1 $2", ["800"], "0$1"], [null, "(\\d{4})(\\d{5,6})", "$1 $2", ["1(?:[2-79][02-9]|8)", "1(?:[24][02-9]|3(?:[02-79]|8[0-46-9])|5(?:[04-9]|2[024-9]|3[014-689])|6(?:[02-8]|9[0-24578])|7(?:[02-57-9]|6[013-9])|8|9(?:[0235-9]|4[2-9]))", "1(?:[24][02-9]|3(?:[02-79]|8(?:[0-4689]|7[0-24-9]))|5(?:[04-9]|2(?:[025-9]|4[013-9])|3(?:[014-68]|9[0-37-9]))|6(?:[02-8]|9(?:[0-2458]|7[0-25689]))|7(?:[02-57-9]|6(?:[013-79]|8[0-25689]))|8|9(?:[0235-9]|4(?:[2-57-9]|6[0-689])))"], "0$1"], [null, "(\\d{5})(\\d{4,5})", "$1 $2", ["1(?:38|5[23]|69|7|94)"], "0$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["[25]|7(?:0|6[024-9])", "[25]|7(?:0|6(?:[04-9]|2[356]))"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[1389]"], "0$1"], [null, "(\\d{4})(\\d{6})", "$1 $2", ["7"], "0$1"]], null, [null, null, "76(?:0[0-2]|2[356]|4[0134]|5[49]|6[0-369]|77|81|9[39])\\d{6}", null, null, null, "7640123456", null, null, [10]], 1, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:3[0347]|55)\\d{8}", null, null, null, "5512345678", null, null, [10]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GD: [null, [null, null, "(?:473|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "473(?:2(?:3[0-2]|69)|3(?:2[89]|86)|4(?:[06]8|3[5-9]|4[0-49]|5[5-79]|73|90)|63[68]|7(?:58|84)|800|938)\\d{4}", null, null, null, "4732691234", null, null, null, [7]], [null, null, "473(?:4(?:0[2-79]|1[04-9]|2[0-5]|58)|5(?:2[01]|3[3-8])|901)\\d{4}", null, null, null, "4734031234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "GD", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "473", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GE: [null, [null, null, "(?:[3-57]\\d\\d|800)\\d{6}", null, null, null, null, null, null, [9], [6]], [null, null, "(?:3(?:[256]\\d|4[124-9]|7[0-4])|4(?:1\\d|2[2-7]|3[1-79]|4[2-8]|7[239]|9[1-7]))\\d{6}", null, null, null, "322123456", null, null, null, [6]], [null, null, "(?:5(?:[14]4|5[0157-9]|68|7[0147-9]|9[1-35-9])|790)\\d{6}", null, null, null, "555123456"], [null, null, "800\\d{6}", null, null, null, "800123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "706\\d{6}", null, null, null, "706123456"], "GE", 995, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[348]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["5|79"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["7"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "706\\d{6}"], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GF: [null, [null, null, "[56]94\\d{6}", null, null, null, null, null, null, [9]], [null, null, "594(?:[023]\\d|1[01]|4[03-9]|5[6-9]|6[0-3]|80|9[014])\\d{4}", null, null, null, "594101234"], [null, null, "694(?:[0-249]\\d|3[0-48])\\d{4}", null, null, null, "694201234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GF", 594, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[56]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GG: [null, [null, null, "(?:1481|[357-9]\\d{3})\\d{6}|8\\d{6}(?:\\d{2})?", null, null, null, null, null, null, [7, 9, 10], [6]], [null, null, "1481[25-9]\\d{5}", null, null, null, "1481256789", null, null, [10], [6]], [null, null, "7(?:(?:781|839)\\d|911[17])\\d{5}", null, null, null, "7781123456", null, null, [10]], [null, null, "80[08]\\d{7}|800\\d{6}|8001111", null, null, null, "8001234567"], [null, null, "(?:8(?:4[2-5]|7[0-3])|9(?:[01]\\d|8[0-3]))\\d{7}|845464\\d", null, null, null, "9012345678", null, null, [7, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "70\\d{8}", null, null, null, "7012345678", null, null, [10]], [null, null, "56\\d{8}", null, null, null, "5612345678", null, null, [10]], "GG", 44, "00", "0", null, null, "0|([25-9]\\d{5})$", "1481$1", null, null, null, null, [null, null, "76(?:0[0-2]|2[356]|4[0134]|5[49]|6[0-369]|77|81|9[39])\\d{6}", null, null, null, "7640123456", null, null, [10]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:3[0347]|55)\\d{8}", null, null, null, "5512345678", null, null, [10]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GH: [null, [null, null, "(?:[235]\\d{3}|800)\\d{5}", null, null, null, null, null, null, [8, 9], [7]], [null, null, "3(?:0(?:[237]\\d|80)|[167](?:2[0-6]|7\\d|80)|2(?:2[0-5]|7\\d|80)|3(?:2[0-3]|7\\d|80)|4(?:2[013-9]|3[01]|7\\d|80)|5(?:2[0-7]|7\\d|80)|8(?:2[0-2]|7\\d|80)|9(?:[28]0|7\\d))\\d{5}", null, null, null, "302345678", null, null, [9], [7]], [null, null, "(?:2[0346-8]\\d|5(?:[0457]\\d|6[01]))\\d{6}", null, null, null, "231234567", null, null, [9]], [null, null, "800\\d{5}", null, null, null, "80012345", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GH", 233, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[237]|80"]], [null, "(\\d{3})(\\d{5})", "$1 $2", ["8"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[235]"], "0$1"]], [[null, "(\\d{3})(\\d{5})", "$1 $2", ["8"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[235]"], "0$1"]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "800\\d{5}", null, null, null, null, null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GI: [null, [null, null, "(?:[25]\\d\\d|629)\\d{5}", null, null, null, null, null, null, [8]], [null, null, "2(?:(?:00\\d|2(?:2[2457]|50))\\d|1(?:6[24-7]\\d|90[0-2]))\\d{3}", null, null, null, "20012345"], [null, null, "(?:5[46-8]\\d|629)\\d{5}", null, null, null, "57123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GI", 350, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{5})", "$1 $2", ["2"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GL: [null, [null, null, "(?:19|[2-689]\\d)\\d{4}", null, null, null, null, null, null, [6]], [null, null, "(?:19|3[1-7]|6[14689]|8[14-79]|9\\d)\\d{4}", null, null, null, "321000"], [null, null, "(?:[25][1-9]|4[2-9])\\d{4}", null, null, null, "221234"], [null, null, "80\\d{4}", null, null, null, "801234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "3[89]\\d{4}", null, null, null, "381234"], "GL", 299, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3", ["19|[2-689]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GM: [null, [null, null, "[2-9]\\d{6}", null, null, null, null, null, null, [7]], [null, null, "(?:4(?:[23]\\d\\d|4(?:1[024679]|[6-9]\\d))|5(?:54[0-7]|6[67]\\d|7(?:1[04]|2[035]|3[58]|48))|8\\d{3})\\d{3}", null, null, null, "5661234"], [null, null, "[23679]\\d{6}", null, null, null, "3012345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GM", 220, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[2-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GN: [null, [null, null, "(?:30|6\\d\\d|722)\\d{6}", null, null, null, null, null, null, [8, 9]], [null, null, "30(?:24|3[12]|4[1-35-7]|5[13]|6[189]|[78]1|9[1478])\\d{4}", null, null, null, "30241234", null, null, [8]], [null, null, "6[02356]\\d{7}", null, null, null, "601123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "722\\d{6}", null, null, null, "722123456", null, null, [9]], "GN", 224, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["3"]], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[67]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GP: [null, [null, null, "(?:590|69\\d)\\d{6}", null, null, null, null, null, null, [9]], [null, null, "590(?:0[1-68]|1[0-2]|2[0-68]|3[1289]|4[0-24-9]|5[3-579]|6[0189]|7[08]|8[0-689]|9\\d)\\d{4}", null, null, null, "590201234"], [null, null, "69(?:0\\d\\d|1(?:2[29]|3[0-5]))\\d{4}", null, null, null, "690001234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GP", 590, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[56]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], 1, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GQ: [null, [null, null, "(?:222|(?:3\\d|55|[89]0)\\d)\\d{6}", null, null, null, null, null, null, [9]], [null, null, "3(?:3(?:[0-24-9]\\d[46]|3\\d[7-9])|5\\d\\d[7-9])\\d{4}", null, null, null, "333091234"], [null, null, "(?:222|55[015])\\d{6}", null, null, null, "222123456"], [null, null, "80\\d[1-9]\\d{5}", null, null, null, "800123456"], [null, null, "90\\d[1-9]\\d{5}", null, null, null, "900123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GQ", 240, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[235]"]], [null, "(\\d{3})(\\d{6})", "$1 $2", ["[89]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GR: [null, [null, null, "(?:[268]\\d|[79]0)\\d{8}", null, null, null, null, null, null, [10]], [null, null, "2(?:1\\d\\d|2(?:2[1-46-9]|[36][1-8]|4[1-7]|5[1-4]|7[1-5]|[89][1-9])|3(?:1\\d|2[1-57]|[35][1-3]|4[13]|7[1-7]|8[124-6]|9[1-79])|4(?:1\\d|2[1-8]|3[1-4]|4[13-5]|6[1-578]|9[1-5])|5(?:1\\d|[29][1-4]|3[1-5]|4[124]|5[1-6])|6(?:1\\d|[269][1-6]|3[1245]|4[1-7]|5[13-9]|7[14]|8[1-5])|7(?:1\\d|2[1-5]|3[1-6]|4[1-7]|5[1-57]|6[135]|9[125-7])|8(?:1\\d|2[1-5]|[34][1-4]|9[1-57]))\\d{6}", null, null, null, "2123456789"], [null, null, "6(?:8[57-9]|9\\d)\\d{7}", null, null, null, "6912345678"], [null, null, "800\\d{7}", null, null, null, "8001234567"], [null, null, "90[19]\\d{7}", null, null, null, "9091234567"], [null, null, "8(?:0[16]|12|25)\\d{7}", null, null, null, "8011234567"], [null, null, "70\\d{8}", null, null, null, "7012345678"], [null, null, null, null, null, null, null, null, null, [-1]], "GR", 30, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["21|7"]], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["2[3-8]1|[689]"]], [null, "(\\d{4})(\\d{6})", "$1 $2", ["2"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GT: [null, [null, null, "(?:1\\d{3}|[2-7])\\d{7}", null, null, null, null, null, null, [8, 11]], [null, null, "[267][2-9]\\d{6}", null, null, null, "22456789", null, null, [8]], [null, null, "[3-5]\\d{7}", null, null, null, "51234567", null, null, [8]], [null, null, "18[01]\\d{8}", null, null, null, "18001112222", null, null, [11]], [null, null, "19\\d{9}", null, null, null, "19001112222", null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GT", 502, "00", null, null, null, null, null, null, null, [[null, "(\\d{4})(\\d{4})", "$1 $2", ["[2-7]"]], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GU: [null, [null, null, "(?:[58]\\d\\d|671|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "671(?:3(?:00|3[39]|4[349]|55|6[26])|4(?:00|56|7[1-9]|8[0236-9])|5(?:55|6[2-5]|88)|6(?:3[2-578]|4[24-9]|5[34]|78|8[235-9])|7(?:[0479]7|2[0167]|3[45]|8[7-9])|8(?:[2-57-9]8|6[48])|9(?:2[29]|6[79]|7[1279]|8[7-9]|9[78]))\\d{4}", null, null, null, "6713001234", null, null, null, [7]], [null, null, "671(?:3(?:00|3[39]|4[349]|55|6[26])|4(?:00|56|7[1-9]|8[0236-9])|5(?:55|6[2-5]|88)|6(?:3[2-578]|4[24-9]|5[34]|78|8[235-9])|7(?:[0479]7|2[0167]|3[45]|8[7-9])|8(?:[2-57-9]8|6[48])|9(?:2[29]|6[79]|7[1279]|8[7-9]|9[78]))\\d{4}", null, null, null, "6713001234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "GU", 1, "011", "1", null, null, "1", null, null, 1, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "671", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GW: [null, [null, null, "[49]\\d{8}|4\\d{6}", null, null, null, null, null, null, [7, 9]], [null, null, "443\\d{6}", null, null, null, "443201234", null, null, [9]], [null, null, "9(?:5\\d|6[569]|77)\\d{6}", null, null, null, "955012345", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "40\\d{5}", null, null, null, "4012345", null, null, [7]], "GW", 245, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["40"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[49]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GY: [null, [null, null, "(?:(?:(?:[2-46]\\d|77)\\d|862)\\d|9008)\\d{3}", null, null, null, null, null, null, [7]], [null, null, "(?:2(?:1[6-9]|2[0-35-9]|3[1-4]|5[3-9]|6\\d|7[0-24-79])|3(?:2[25-9]|3\\d)|4(?:4[0-24]|5[56])|77[1-57])\\d{4}", null, null, null, "2201234"], [null, null, "6\\d{6}", null, null, null, "6091234"], [null, null, "(?:289|862)\\d{4}", null, null, null, "2891234"], [null, null, "9008\\d{3}", null, null, null, "9008123"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GY", 592, "001", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[2-46-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    HK: [null, [null, null, "8[0-46-9]\\d{6,7}|9\\d{4}(?:\\d(?:\\d(?:\\d{4})?)?)?|(?:[235-79]\\d|46)\\d{6}", null, null, null, null, null, null, [5, 6, 7, 8, 9, 11]], [null, null, "(?:2(?:[13-8]\\d|2[013-9]|9[0-24-9])\\d|3(?:(?:[1569][0-24-9]|4[0-246-9]|7[0-24-69])\\d|8(?:4[04]|9\\d))|58(?:0[1-8]|1[2-9]))\\d{4}", null, null, null, "21234567", null, null, [8]], [null, null, "(?:46(?:0[0-6]|10|4[0-57-9])|5(?:(?:[1-59][0-46-9]|6[0-4689])\\d|7(?:[0-2469]\\d|30))|6(?:(?:0[1-9]|[13-59]\\d|[68][0-57-9]|7[0-79])\\d|2(?:[0-57-9]\\d|6[01]))|707[1-5]|8480|9(?:(?:0[1-9]|1[02-9]|[358][0-8]|[467]\\d)\\d|2(?:[0-8]\\d|9[03-9])))\\d{4}", null, null, null, "51234567", null, null, [8]], [null, null, "800\\d{6}", null, null, null, "800123456", null, null, [9]], [null, null, "900(?:[0-24-9]\\d{7}|3\\d{1,4})", null, null, null, "90012345678", null, null, [5, 6, 7, 8, 11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "8(?:1[0-4679]\\d|2(?:[0-36]\\d|7[0-4])|3(?:[034]\\d|2[09]|70))\\d{4}", null, null, null, "81123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], "HK", 852, "00(?:30|5[09]|[126-9]?)", null, null, null, null, null, "00", null, [[null, "(\\d{3})(\\d{2,5})", "$1 $2", ["900", "9003"]], [null, "(\\d{4})(\\d{4})", "$1 $2", ["[2-7]|8[1-4]|9(?:0[1-9]|[1-8])"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"]], [null, "(\\d{3})(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["9"]]], null, [null, null, "7(?:1(?:0[0-38]|1[0-3679]|3[013]|69|9[136])|2(?:[02389]\\d|1[18]|7[27-9])|3(?:[0-38]\\d|7[0-369]|9[2357-9])|47\\d|5(?:[178]\\d|5[0-5])|6(?:0[0-7]|2[236-9]|[35]\\d)|7(?:[27]\\d|8[7-9])|8(?:[23689]\\d|7[1-9])|9(?:[025]\\d|6[0-246-8]|7[0-36-9]|8[238]))\\d{4}", null, null, null, "71123456", null, null, [8]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "30(?:0[1-9]|[15-7]\\d|2[047]|89)\\d{4}", null, null, null, "30161234", null, null, [8]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    HN: [null, [null, null, "[237-9]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "2(?:2(?:0[019]|1[1-36]|[23]\\d|4[04-6]|5[57]|64|7[0135689]|8[01346-9]|9[0-2])|4(?:07|2[3-59]|3[13-689]|4[0-68]|5[1-35])|5(?:08|16|4[03-5]|5\\d|6[4-6]|74|80)|6(?:[056]\\d|17|3[04]|4[0-378]|[78][0-8]|9[01])|7(?:6[46-9]|7[02-9]|8[034])|8(?:79|8[0-357-9]|9[1-57-9]))\\d{4}", null, null, null, "22123456"], [null, null, "[37-9]\\d{7}", null, null, null, "91234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "HN", 504, "00", null, null, null, null, null, null, null, [[null, "(\\d{4})(\\d{4})", "$1-$2", ["[237-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    HR: [null, [null, null, "(?:[24-69]\\d|3[0-79])\\d{7}|80\\d{5,7}|[1-79]\\d{7}|6\\d{5,6}", null, null, null, null, null, null, [6, 7, 8, 9]], [null, null, "1\\d{7}|(?:2[0-3]|3[1-5]|4[02-47-9]|5[1-3])\\d{6,7}", null, null, null, "12345678", null, null, [8, 9], [6, 7]], [null, null, "9(?:(?:01|[12589]\\d)\\d|7(?:[0679]\\d|51))\\d{5}|98\\d{6}", null, null, null, "921234567", null, null, [8, 9]], [null, null, "80[01]\\d{4,6}", null, null, null, "800123456", null, null, [7, 8, 9]], [null, null, "6[01459]\\d{6}|6[01]\\d{4,5}", null, null, null, "611234", null, null, [6, 7, 8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "7[45]\\d{6}", null, null, null, "74123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], "HR", 385, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2,3})", "$1 $2 $3", ["6[01]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2,3})", "$1 $2 $3", ["8"], "0$1"], [null, "(\\d)(\\d{4})(\\d{3})", "$1 $2 $3", ["1"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2-5]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[67]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["9"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:62\\d?|72)\\d{6}", null, null, null, "62123456", null, null, [8, 9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    HT: [null, [null, null, "[2-489]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "2(?:2\\d|5[1-5]|81|9[149])\\d{5}", null, null, null, "22453300"], [null, null, "[34]\\d{7}", null, null, null, "34101234"], [null, null, "8\\d{7}", null, null, null, "80012345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "9(?:[67][0-4]|8[0-3589]|9\\d)\\d{5}", null, null, null, "98901234"], "HT", 509, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{4})", "$1 $2 $3", ["[2-489]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    HU: [null, [null, null, "[2357]\\d{8}|[1-9]\\d{7}", null, null, null, null, null, null, [8, 9], [6, 7]], [null, null, "(?:1\\d|[27][2-9]|3[2-7]|4[24-9]|5[2-79]|6[23689]|8[2-57-9]|9[2-69])\\d{6}", null, null, null, "12345678", null, null, [8], [6, 7]], [null, null, "(?:[257]0|3[01])\\d{7}", null, null, null, "201234567", null, null, [9]], [null, null, "[48]0\\d{6}", null, null, null, "80123456", null, null, [8]], [null, null, "9[01]\\d{6}", null, null, null, "90123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "21\\d{7}", null, null, null, "211234567", null, null, [9]], "HU", 36, "00", "06", null, null, "06", null, null, null, [[null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "($1)"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2-9]"], "($1)"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "[48]0\\d{6}", null, null, null, null, null, null, [8]], [null, null, "38\\d{7}", null, null, null, "381234567", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    ID: [null, [null, null, "(?:[1-36]|8\\d{5})\\d{6}|[1-9]\\d{8,10}|[2-9]\\d{7}", null, null, null, null, null, null, [7, 8, 9, 10, 11, 12], [5, 6]], [null, null, "2(?:[124]\\d{7,8}|(?:[35][1-4]|6[0-8]|7[1-6]|8\\d|9[1-8])\\d{5,8})|(?:3(?:1|[25][1-8]|3[1-68]|4[1-3]|6[1-3568]|7[0-469]|8\\d)|4(?:0[1-589]|1[01347-9]|2[0-36-8]|3[0-24-68]|43|5[1-378]|6[1-5]|7[134]|8[1245])|5(?:1[1-35-9]|2[25-8]|3[124-9]|4[1-3589]|5[1-46]|6[1-8])|7(?:02|[125][1-9]|[36]\\d|4[1-8]|7[0-36-9])|9(?:0[12]|1[013-8]|2[0-479]|5[125-8]|6[23679]|7[159]|8[01346]))\\d{5,8}|6(?:1(?:[0-8]\\d{4,7}|9\\d{4,8})|(?:[25]\\d|3[1-69]|4[1-6])\\d{5,8})|2(?:1(?:14|500)|2\\d{3})\\d{3}", null, null, null, "218350123", null, null, [7, 8, 9, 10, 11], [5, 6]], [null, null, "8[1-35-9]\\d{7,10}", null, null, null, "812345678", null, null, [9, 10, 11, 12]], [null, null, "(?:177\\d|800)\\d{5,7}", null, null, null, "8001234567", null, null, [8, 9, 10, 11]], [null, null, "809\\d{7}", null, null, null, "8091234567", null, null, [10]], [null, null, "804\\d{7}", null, null, null, "8041234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "ID", 62, "0(?:0[17-9]|10(?:00|1[67]))", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["15"]], [null, "(\\d{2})(\\d{5,9})", "$1 $2", ["2[124]|[36]1"], "(0$1)"], [null, "(\\d{3})(\\d{5,7})", "$1 $2", ["800"], "0$1"], [null, "(\\d{3})(\\d{5,8})", "$1 $2", ["[2-79]"], "(0$1)"], [null, "(\\d{3})(\\d{3,4})(\\d{3})", "$1-$2-$3", ["8[1-35-9]"], "0$1"], [null, "(\\d{3})(\\d{6,8})", "$1 $2", ["1"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["804"], "0$1"], [null, "(\\d{3})(\\d)(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["80"], "0$1"], [null, "(\\d{3})(\\d{4})(\\d{4,5})", "$1-$2-$3", ["8"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "8071\\d{6}", null, null, null, null, null, null, [10]], [null, null, "(?:1500|8071\\d{3})\\d{3}", null, null, null, "8071123456", null, null, [7, 10]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    IE: [null, [null, null, "[148]\\d{9}|[124-9]\\d{8}|[124-69]\\d{7}|[24-69]\\d{6}", null, null, null, null, null, null, [7, 8, 9, 10], [5, 6]], [null, null, "(?:1\\d{2,3}|2(?:[13]\\d\\d|[24-9])|4(?:0[24]|(?:(?:[1-469]|8[0-46-9])\\d|5)\\d|7)|5(?:0[45]|(?:1|[23679]\\d)\\d|8)|6(?:[237-9]|[4-6]\\d\\d)|7[14]\\d\\d|9(?:[04]\\d\\d|[35-9]))\\d{5}|[269]1\\d{6}", null, null, null, "2212345", null, null, null, [5, 6]], [null, null, "8(?:22|[35-9]\\d)\\d{6}", null, null, null, "850123456", null, null, [9]], [null, null, "1800\\d{6}", null, null, null, "1800123456", null, null, [10]], [null, null, "15(?:1[2-8]|[2-8]0|9[089])\\d{6}", null, null, null, "1520123456", null, null, [10]], [null, null, "18[59]0\\d{6}", null, null, null, "1850123456", null, null, [10]], [null, null, "700\\d{6}", null, null, null, "700123456", null, null, [9]], [null, null, "76\\d{7}", null, null, null, "761234567", null, null, [9]], "IE", 353, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{5})", "$1 $2", ["2[24-9]|47|58|6[237-9]|9[35-9]"], "(0$1)"], [null, "(\\d{3})(\\d{5})", "$1 $2", ["[45]0"], "(0$1)"], [null, "(\\d)(\\d{3,4})(\\d{4})", "$1 $2 $3", ["1"], "(0$1)"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2569]|4[1-69]|7[14]"], "(0$1)"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["76|8[235-9]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["7"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["81"], "(0$1)"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["4"], "(0$1)"], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1"]], [null, "(\\d{2})(\\d)(\\d{3})(\\d{4})", "$1 $2 $3 $4", ["8"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "18[59]0\\d{6}", null, null, null, null, null, null, [10]], [null, null, "818\\d{6}", null, null, null, "818123456", null, null, [9]], null, null, [null, null, "8[35-9]5\\d{7}", null, null, null, "8551234567", null, null, [10]]],
    IL: [null, [null, null, "1\\d{6}(?:\\d{3,5})?|[57]\\d{8}|[1-489]\\d{7}", null, null, null, null, null, null, [7, 8, 9, 10, 11, 12]], [null, null, "(?:153\\d\\d?|[2-489])\\d{7}", null, null, null, "21234567", null, null, [8, 11, 12], [7]], [null, null, "5(?:(?:[0-489][2-9]|6\\d)\\d|5(?:01|2[2-5]|3[23]|4[45]|5[05689]|6[6-8]|7[0-267]|8[7-9]|9[1-9]))\\d{5}", null, null, null, "502345678", null, null, [9]], [null, null, "1(?:255|80[019]\\d{3})\\d{3}", null, null, null, "1800123456", null, null, [7, 10]], [null, null, "1(?:2(?:00\\d\\d|12)|9(?:0[01]|19)\\d\\d)\\d{4}", null, null, null, "1919123456", null, null, [8, 10]], [null, null, "1700\\d{6}", null, null, null, "1700123456", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "7(?:(?:18|2[23]|3[237]|47|6[58]|7\\d|9[2357-9])\\d|8(?:2\\d|33|55|77|81))\\d{5}", null, null, null, "771234567", null, null, [9]], "IL", 972, "0(?:0|1[2-9])", "0", null, null, "0", null, null, null, [[null, "(\\d{4})(\\d{3})", "$1-$2", ["125"]], [null, "(\\d)(\\d{3})(\\d{4})", "$1-$2-$3", ["[2-489]"], "0$1"], [null, "(\\d{4})(\\d{2})(\\d{2})", "$1-$2-$3", ["121"]], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["[57]"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1-$2-$3", ["12"]], [null, "(\\d{4})(\\d{6})", "$1-$2", ["159"]], [null, "(\\d)(\\d{3})(\\d{3})(\\d{3})", "$1-$2-$3-$4", ["1[7-9]"]], [null, "(\\d{3})(\\d{1,2})(\\d{3})(\\d{4})", "$1-$2 $3-$4", ["1"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "1700\\d{6}", null, null, null, null, null, null, [10]], [null, null, "1599\\d{6}", null, null, null, "1599123456", null, null, [10]], null, null, [null, null, "151\\d{8,9}", null, null, null, "15112340000", null, null, [11, 12]]],
    IM: [null, [null, null, "(?:1624|(?:[3578]\\d|90)\\d\\d)\\d{6}", null, null, null, null, null, null, [10], [6]], [null, null, "1624[5-8]\\d{5}", null, null, null, "1624756789", null, null, null, [6]], [null, null, "7(?:4576|[59]24\\d|624[0-4689])\\d{5}", null, null, null, "7924123456"], [null, null, "808162\\d{4}", null, null, null, "8081624567"], [null, null, "(?:8(?:4(?:40[49]06|5624\\d)|7(?:0624|2299)\\d)|90[0167]624\\d)\\d{3}", null, null, null, "9016247890"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "70\\d{8}", null, null, null, "7012345678"], [null, null, "56\\d{8}", null, null, null, "5612345678"], "IM", 44, "00", "0", null, null, "0|([5-8]\\d{5})$", "1624$1", null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:3(?:(?:08162|3\\d{4}|7(?:0624|2299))\\d|4(?:40[49]06|5624\\d))|55\\d{5})\\d{3}", null, null, null, "5512345678"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    IN: [null, [null, null, "(?:00800|1\\d{0,5}|[2-9]\\d\\d)\\d{7}", null, null, null, null, null, null, [8, 9, 10, 11, 12, 13], [6, 7]], [null, null, "(?:1(?:1[2-7]\\d\\d|2(?:[0-249][2-7]\\d|[35-8]\\d[2-7])|3(?:[0-25][2-7]\\d|[346-9]\\d[2-7])|4(?:[145][2-7]\\d|[236-9]\\d[2-7])|[59](?:[0235-9]\\d[2-7]|[14][2-7]\\d)|6(?:[014][2-7]\\d|[235-9]\\d[2-7])|7(?:(?:0[24]|[1257][2-7])\\d|[34689]\\d[2-7])|8(?:[01346][2-7]\\d|[257-9]\\d[2-7]))|2(?:[02][2-7]\\d\\d|1(?:[134689]\\d[2-7]|[257][2-7]\\d)|3(?:[013][2-7]\\d|[24-8]\\d[2-7])|4(?:[01][2-7]\\d|[2-8]\\d[2-7])|5(?:[0137][2-7]\\d|[25689]\\d[2-7])|6(?:[0158][2-7]\\d|[2-4679]\\d[2-7])|7(?:[13-79]\\d[2-7]|8[2-7]\\d)|8(?:(?:0[13468]|[1568][2-7])\\d|[2-479]\\d[2-7])|9(?:(?:0\\d|[14][2-7])\\d|[235-9]\\d[2-7]))|3(?:(?:01|1[79])\\d[2-7]|2(?:[1-5]\\d[2-7]|6[2-7]\\d)|3[2-7]\\d\\d|4(?:[13][2-7]\\d|2(?:[0189][2-7]|[2-7]\\d)|[5-8]\\d[2-7])|5(?:[125689]\\d[2-7]|[34][2-7]\\d)|6(?:[01489][2-7]\\d|[235-7]\\d[2-7])|7(?:[02-46][2-7]\\d|[157-9]\\d[2-7])|8(?:(?:0\\d|[159][2-7])\\d|[2-46-8]\\d[2-7]))|4(?:[04][2-7]\\d\\d|1(?:[14578]\\d[2-7]|[36][2-7]\\d)|2(?:(?:0[24]|[1-47][2-7])\\d|[5689]\\d[2-7])|3(?:[15][2-7]\\d|[2-467]\\d[2-7])|5(?:[12][2-7]\\d|[4-7]\\d[2-7])|6(?:[0-26-9][2-7]\\d|[35]\\d[2-7])|7(?:(?:[014-9][2-7]|2[2-8])\\d|3\\d[2-7])|8(?:[013-57][2-7]\\d|[2689]\\d[2-7])|9(?:[014-7][2-7]\\d|[2389]\\d[2-7]))|5(?:1(?:[025][2-7]\\d|[146-9]\\d[2-7])|2(?:[14-8]\\d[2-7]|2[2-7]\\d)|3(?:[1346]\\d[2-7]|[25][2-7]\\d)|4(?:[14-69]\\d[2-7]|[28][2-7]\\d)|5(?:(?:1[2-7]|2[1-7])\\d|[46]\\d[2-7])|6(?:[146-9]\\d[2-7]|[25][2-7]\\d)|7(?:1[2-7]\\d|[2-4]\\d[2-7])|8(?:1[2-7]\\d|[2-8]\\d[2-7])|9(?:[15][2-7]\\d|[246]\\d[2-7]))|6(?:1(?:[1358]\\d[2-7]|2[2-7]\\d)|2(?:1[2-7]\\d|[2457]\\d[2-7])|3(?:1[2-7]\\d|[2-4]\\d[2-7])|4(?:1[2-7]\\d|[235-7]\\d[2-7])|5(?:[17][2-7]\\d|[2-689]\\d[2-7])|6(?:[13][2-7]\\d|[24578]\\d[2-7])|7(?:1[2-7]\\d|[235689]\\d[2-7]|4(?:[0189][2-7]|[2-7]\\d))|8(?:0[2-7]\\d|[1-6]\\d[2-7]))|7(?:1(?:[013-9]\\d[2-7]|2[2-7]\\d)|2(?:[0235-9]\\d[2-7]|[14][2-7]\\d)|3(?:[134][2-7]\\d|[2679]\\d[2-7])|4(?:[1-35689]\\d[2-7]|[47][2-7]\\d)|5(?:[15][2-7]\\d|[2-46-9]\\d[2-7])|[67](?:[02-9]\\d[2-7]|1[2-7]\\d)|8(?:(?:[013-7]\\d|2[0-6])[2-7]|8(?:[0189][2-7]|[2-7]\\d))|9(?:[0189]\\d[2-7]|[2-7]\\d\\d))|8(?:0[2-7]\\d\\d|1(?:[1357-9]\\d[2-7]|6[2-7]\\d)|2(?:[014][2-7]\\d|[235-8]\\d[2-7])|3(?:[03-57-9]\\d[2-7]|[126][2-7]\\d)|(?:4[0-24-9]|5\\d)\\d[2-7]|6(?:[136][2-7]\\d|[2457-9]\\d[2-7])|7(?:[078][2-7]\\d|[1-6]\\d[2-7])|8(?:[1256]\\d[2-7]|[34][2-7]\\d)|9(?:1[2-7]\\d|[2-4]\\d[2-7])))\\d{5}", null, null, null, "7410410123", null, null, [10], [6, 7, 8]], [null, null, "(?:6(?:(?:0(?:0[0-3569]|26|33)|2(?:[06]\\d|3[02589]|8[0-479]|9[0-79])|9(?:0[019]|13))\\d|1279|3(?:(?:0[0-79]|6[0-4679]|7[0-24-9]|[89]\\d)\\d|5(?:0[0-6]|[1-9]\\d)))|7(?:(?:0\\d\\d|19[0-5])\\d|2(?:(?:[0235-79]\\d|[14][017-9])\\d|8(?:[0-59]\\d|[6-8][089]))|3(?:(?:[05-8]\\d|3[017-9])\\d|1(?:[089]\\d|11|7[02-8])|2(?:[0-49][089]|[5-8]\\d)|4(?:[07-9]\\d|11)|9(?:[016-9]\\d|[2-5][089]))|4(?:0\\d\\d|1(?:[015-9]\\d|[2-4][089])|[29](?:[0-7][089]|[89]\\d)|3(?:[0-8][089]|9\\d)|[47](?:[089]\\d|11|7[02-8])|[56]\\d[089]|8(?:[0-24-7][089]|[389]\\d))|5(?:(?:[0346-8]\\d|5[017-9])\\d|1(?:[07-9]\\d|11)|2(?:[04-9]\\d|[1-3][089])|9(?:[0-6][089]|[7-9]\\d))|6(?:0(?:[0-47]\\d|[5689][089])|(?:1[0-257-9]|[6-9]\\d)\\d|2(?:[0-4]\\d|[5-9][089])|3(?:[02-8][089]|[19]\\d)|4\\d[089]|5(?:[0-367][089]|[4589]\\d))|7(?:0(?:0[02-9]|[13-7][089]|[289]\\d)|[1-9]\\d\\d)|8(?:[0-79]\\d\\d|8(?:[089]\\d|11|7[02-9]))|9(?:[089]\\d\\d|313|7(?:[02-8]\\d|9[07-9])))|8(?:0(?:(?:[01589]\\d|6[67])\\d|7(?:[02-8]\\d|9[04-9]))|1(?:[0-57-9]\\d\\d|6(?:[089]\\d|7[02-8]))|2(?:[014](?:[089]\\d|7[02-8])|[235-9]\\d\\d)|3(?:[03-57-9]\\d\\d|[126](?:[089]\\d|7[02-8]))|[45]\\d{3}|6(?:[02457-9]\\d\\d|[136](?:[089]\\d|7[02-8]))|7(?:(?:0[07-9]|[1-69]\\d)\\d|[78](?:[089]\\d|7[02-8]))|8(?:[0-25-9]\\d\\d|3(?:[089]\\d|7[02-8])|4(?:[0489]\\d|7[02-8]))|9(?:[02-9]\\d\\d|1(?:[0289]\\d|7[02-8])))|9\\d{4})\\d{5}", null, null, null, "8123456789", null, null, [10]], [null, null, "(?:00800\\d|1(?:600|80[03]\\d{3}))\\d{6}|1800\\d{4,8}", null, null, null, "1800123456"], [null, null, "186[12]\\d{9}", null, null, null, "1861123456789", null, null, [13]], [null, null, "1860\\d{7}", null, null, null, "18603451234", null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "IN", 91, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{8})", "$1", ["5[0236-8]"], null, null, 1], [null, "(\\d{4})(\\d{4,5})", "$1 $2", ["180", "1800"], null, null, 1], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["11|2[02]|33|4[04]|79[1-7]|80[2-46]", "11|2[02]|33|4[04]|79(?:[1-6]|7[19])|80(?:[2-4]|6[0-589])", "11|2[02]|33|4[04]|79(?:[124-6]|3(?:[02-9]|1[0-24-9])|7(?:1|9[1-6]))|80(?:[2-4]|6[0-589])"], "0$1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["1(?:2[0-249]|3[0-25]|4[145]|[59][14]|[68]|7[1257])|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5[12]|[78]1|9[15])|6(?:12|[2-4]1|5[17]|6[13]|7[14]|80)|7(?:12|2[14]|3[134]|4[47]|5[15]|61|88)|8(?:16|2[014]|3[126]|6[136]|7[078]|8[34]|91)", "1(?:2[0-249]|3[0-25]|4[145]|[59][14]|6(?:0[2-7]|[1-9])|7[1257]|8(?:[06][2-7]|[1-57-9]))|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5(?:1|2[2-7])|[78]1|9[15])|6(?:12[2-7]|[2-4]1|5[17]|6[13]|7[14]|80)|7(?:12|(?:2[14]|5[15])[2-6]|3(?:1[2-7]|[34][2-6])|4[47][2-7]|61[346]|88[0-8])|8(?:(?:16|2[014]|3[126]|6[136])[2-7]|7(?:0[2-6]|[78][2-7])|8(?:3[2-7]|4[235-7])|91[3-7])", "1(?:2[0-249]|3[0-25]|4[145]|[59][14]|6(?:0[2-7]|[1-9])|7[1257]|8(?:[06][2-7]|[1-57-9]))|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5(?:1|2[2-7])|[78]1|9[15])|6(?:12(?:[2-6]|7[0-8])|[2-4]1|5[17]|6[13]|7[14]|80)|7(?:12|(?:2[14]|5[15])[2-6]|3(?:1(?:[2-6]|71)|[34][2-6])|4[47](?:[2-6]|7[19])|61[346]|88(?:[01][2-7]|[2-7]|82))|8(?:(?:16|2[014]|3[126]|6[136])(?:[2-6]|7[19])|7(?:0[2-6]|[78](?:[2-6]|7[19]))|8(?:3(?:[2-6]|7[19])|4(?:[2356]|7[19]))|91(?:[3-6]|7[19]))"], "0$1", null, 1], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1(?:[23579]|4[236-9])|[2-5]|6(?:1[1358]|2[2457-9]|3[2-5]|[4-8])|7(?:1[013-9]|28|3[129]|4[1-35689]|5[29]|6[02-5]|70)|807", "1(?:[23579]|4[236-9])|[2-5]|6(?:1[1358]|2(?:[2457]|84|95)|3(?:[2-4]|55)|[4-8])|7(?:1(?:[013-8]|9[6-9])|28[6-8]|3(?:17|2[0-49]|9[2-57])|4(?:1[2-4]|[29][0-7]|3[0-8]|[56]|8[0-24-7])|5(?:2[1-3]|9[0-6])|6(?:0[5689]|2[5-9]|3[02-8]|4|5[0-367])|70[13-7])|807[19]", "1(?:[23579]|4[236-9])|[2-5]|6(?:1[1358]|2(?:[2457]|84|95)|3(?:[2-4]|55)|[4-8])|7(?:1(?:[013-8]|9[6-9])|(?:28[6-8]|4(?:1[2-4]|[29][0-7]|3[0-8]|[56]\\d|8[0-24-7])|5(?:2[1-3]|9[0-6])|6(?:0[5689]|2[5-9]|3[02-8]|4\\d|5[0-367])|70[13-7])[2-7]|3(?:179|(?:2[0-49]|9[2-57])[2-7]))|807(?:1|9[1-3])"], "0$1", null, 1], [null, "(\\d{5})(\\d{5})", "$1 $2", ["[6-9]"], "0$1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["14"], null, null, 1], [null, "(\\d{4})(\\d{2,4})(\\d{4})", "$1 $2 $3", ["1(?:6|8[06])", "1(?:6|8[06]0)"], null, null, 1], [null, "(\\d{2})(\\d{3})(\\d{4})(\\d{3})", "$1 $2 $3 $4", ["0"], "0$1", null, 1], [null, "(\\d{4})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["1"], null, null, 1]], [[null, "(\\d{8})", "$1", ["5[0236-8]"], null, null, 1], [null, "(\\d{4})(\\d{4,5})", "$1 $2", ["180", "1800"], null, null, 1], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["11|2[02]|33|4[04]|79[1-7]|80[2-46]", "11|2[02]|33|4[04]|79(?:[1-6]|7[19])|80(?:[2-4]|6[0-589])", "11|2[02]|33|4[04]|79(?:[124-6]|3(?:[02-9]|1[0-24-9])|7(?:1|9[1-6]))|80(?:[2-4]|6[0-589])"], "0$1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["1(?:2[0-249]|3[0-25]|4[145]|[59][14]|[68]|7[1257])|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5[12]|[78]1|9[15])|6(?:12|[2-4]1|5[17]|6[13]|7[14]|80)|7(?:12|2[14]|3[134]|4[47]|5[15]|61|88)|8(?:16|2[014]|3[126]|6[136]|7[078]|8[34]|91)", "1(?:2[0-249]|3[0-25]|4[145]|[59][14]|6(?:0[2-7]|[1-9])|7[1257]|8(?:[06][2-7]|[1-57-9]))|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5(?:1|2[2-7])|[78]1|9[15])|6(?:12[2-7]|[2-4]1|5[17]|6[13]|7[14]|80)|7(?:12|(?:2[14]|5[15])[2-6]|3(?:1[2-7]|[34][2-6])|4[47][2-7]|61[346]|88[0-8])|8(?:(?:16|2[014]|3[126]|6[136])[2-7]|7(?:0[2-6]|[78][2-7])|8(?:3[2-7]|4[235-7])|91[3-7])", "1(?:2[0-249]|3[0-25]|4[145]|[59][14]|6(?:0[2-7]|[1-9])|7[1257]|8(?:[06][2-7]|[1-57-9]))|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5(?:1|2[2-7])|[78]1|9[15])|6(?:12(?:[2-6]|7[0-8])|[2-4]1|5[17]|6[13]|7[14]|80)|7(?:12|(?:2[14]|5[15])[2-6]|3(?:1(?:[2-6]|71)|[34][2-6])|4[47](?:[2-6]|7[19])|61[346]|88(?:[01][2-7]|[2-7]|82))|8(?:(?:16|2[014]|3[126]|6[136])(?:[2-6]|7[19])|7(?:0[2-6]|[78](?:[2-6]|7[19]))|8(?:3(?:[2-6]|7[19])|4(?:[2356]|7[19]))|91(?:[3-6]|7[19]))"], "0$1", null, 1], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1(?:[23579]|4[236-9])|[2-5]|6(?:1[1358]|2[2457-9]|3[2-5]|[4-8])|7(?:1[013-9]|28|3[129]|4[1-35689]|5[29]|6[02-5]|70)|807", "1(?:[23579]|4[236-9])|[2-5]|6(?:1[1358]|2(?:[2457]|84|95)|3(?:[2-4]|55)|[4-8])|7(?:1(?:[013-8]|9[6-9])|28[6-8]|3(?:17|2[0-49]|9[2-57])|4(?:1[2-4]|[29][0-7]|3[0-8]|[56]|8[0-24-7])|5(?:2[1-3]|9[0-6])|6(?:0[5689]|2[5-9]|3[02-8]|4|5[0-367])|70[13-7])|807[19]", "1(?:[23579]|4[236-9])|[2-5]|6(?:1[1358]|2(?:[2457]|84|95)|3(?:[2-4]|55)|[4-8])|7(?:1(?:[013-8]|9[6-9])|(?:28[6-8]|4(?:1[2-4]|[29][0-7]|3[0-8]|[56]\\d|8[0-24-7])|5(?:2[1-3]|9[0-6])|6(?:0[5689]|2[5-9]|3[02-8]|4\\d|5[0-367])|70[13-7])[2-7]|3(?:179|(?:2[0-49]|9[2-57])[2-7]))|807(?:1|9[1-3])"], "0$1", null, 1], [null, "(\\d{5})(\\d{5})", "$1 $2", ["[6-9]"], "0$1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["14"], null, null, 1], [null, "(\\d{4})(\\d{2,4})(\\d{4})", "$1 $2 $3", ["1(?:6|8[06])", "1(?:6|8[06]0)"], null, null, 1], [null, "(\\d{4})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["1"], null, null, 1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "(?:00800\\d|1(?:600|8(?:0[03]\\d\\d|6(?:0|[12]\\d\\d))\\d))\\d{6}|1800\\d{4,8}"], [null, null, "140\\d{7}", null, null, null, "1409305260", null, null, [10]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    IO: [null, [null, null, "3\\d{6}", null, null, null, null, null, null, [7]], [null, null, "37\\d{5}", null, null, null, "3709100"], [null, null, "38\\d{5}", null, null, null, "3801234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "IO", 246, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["3"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    IQ: [null, [null, null, "(?:1|[2-6]\\d?|7\\d\\d)\\d{7}", null, null, null, null, null, null, [8, 9, 10], [6, 7]], [null, null, "1\\d{7}|(?:2[13-5]|3[02367]|4[023]|5[03]|6[026])\\d{6,7}", null, null, null, "12345678", null, null, [8, 9], [6, 7]], [null, null, "7[3-9]\\d{8}", null, null, null, "7912345678", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "IQ", 964, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2-6]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["7"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    IR: [null, [null, null, "[1-9]\\d{9}|(?:[1-8]\\d\\d|9)\\d{3,4}", null, null, null, null, null, null, [4, 5, 6, 7, 10], [8]], [null, null, "(?:(?:1[137]|2[13-68]|3[1458]|4[145]|5[1468]|6[16]|7[1467]|8[13467])\\d{4}|94(?:(?:000|(?:11|2\\d)\\d|30[01])\\d|4(?:111|40\\d)))\\d{4}|(?:1[137]|2[13-68]|3[1458]|4[145]|5[1468]|6[16]|7[1467]|8[13467])(?:[16]|[289]\\d?)\\d{3}", null, null, null, "2123456789", null, null, [6, 7, 10], [4, 5, 8]], [null, null, "9(?:(?:0(?:[1-35]\\d|44)|(?:[13]\\d|2[0-2])\\d)\\d|9(?:(?:[01]\\d|44)\\d|510|8(?:1[01]|88)|9(?:0[013]|1[0134]|21|77|9[6-9])))\\d{5}", null, null, null, "9123456789", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "993\\d{7}", null, null, null, "9932123456", null, null, [10]], "IR", 98, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{4,5})", "$1", ["96"], "0$1"], [null, "(\\d{2})(\\d{4,5})", "$1 $2", ["(?:1[137]|2[13-68]|3[1458]|4[145]|5[1468]|6[16]|7[1467]|8[13467])[12689]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["9"], "0$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["[1-8]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "9(?:4(?:11[1-7]|440)\\d{5}|6(?:0[12]|2[16-8]|3(?:08|[14]5|[23]|66)|4(?:0|80)|5[01]|6[89]|86|9[19]))", null, null, null, null, null, null, [4, 5, 10]], [null, null, "96(?:0[12]|2[16-8]|3(?:08|[14]5|[23]|66)|4(?:0|80)|5[01]|6[89]|86|9[19])", null, null, null, "9601", null, null, [4, 5]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    IS: [null, [null, null, "(?:38\\d|[4-9])\\d{6}", null, null, null, null, null, null, [7, 9]], [null, null, "(?:4(?:1[0-24-69]|2[0-7]|[37][0-8]|4[0-245]|5[0-68]|6\\d|8[0-36-8])|5(?:05|[156]\\d|2[02578]|3[0-579]|4[03-7]|7[0-2578]|8[0-35-9]|9[013-689])|87[23])\\d{4}", null, null, null, "4101234", null, null, [7]], [null, null, "(?:38[589]\\d\\d|6(?:1[1-8]|2[0-6]|3[027-9]|4[014679]|5[0159]|6[0-69]|70|8[06-8]|9\\d)|7(?:5[057]|[6-8]\\d|9[0-3])|8(?:2[0-59]|[3469]\\d|5[1-9]|8[28]))\\d{4}", null, null, null, "6111234"], [null, null, "800\\d{4}", null, null, null, "8001234", null, null, [7]], [null, null, "90\\d{5}", null, null, null, "9011234", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "49\\d{5}", null, null, null, "4921234", null, null, [7]], "IS", 354, "00|1(?:0(?:01|[12]0)|100)", null, null, null, null, null, "00", null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[4-9]"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["3"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "809\\d{4}", null, null, null, "8091234", null, null, [7]], null, null, [null, null, "(?:689|8(?:7[0189]|80)|95[48])\\d{4}", null, null, null, "6891234", null, null, [7]]],
    IT: [null, [null, null, "0\\d{6}(?:\\d{4})?|3[0-8]\\d{9}|(?:[0138]\\d?|55)\\d{8}|[08]\\d{5}(?:\\d{2})?", null, null, null, null, null, null, [6, 7, 8, 9, 10, 11]], [null, null, "0(?:(?:1(?:[0159]\\d|[27][1-5]|31|4[1-4]|6[1356]|8[2-57])|2\\d\\d|3(?:[0159]\\d|2[1-4]|3[12]|[48][1-6]|6[2-59]|7[1-7])|4(?:[0159]\\d|[23][1-9]|4[245]|6[1-5]|7[1-4]|81)|5(?:[0159]\\d|2[1-5]|3[2-6]|4[1-79]|6[4-6]|7[1-578]|8[3-8])|7(?:[0159]\\d|2[12]|3[1-7]|4[2-46]|6[13569]|7[13-6]|8[1-59])|8(?:[0159]\\d|2[3-578]|3[1-356]|[6-8][1-5])|9(?:[0159]\\d|[238][1-5]|4[12]|6[1-8]|7[1-6]))\\d|6(?:[0-57-9]\\d\\d|6(?:[0-8]\\d|9[0-79])))\\d{1,6}", null, null, null, "0212345678"], [null, null, "33\\d{9}|3[1-9]\\d{8}|3[2-9]\\d{7}", null, null, null, "3123456789", null, null, [9, 10, 11]], [null, null, "80(?:0\\d{3}|3)\\d{3}", null, null, null, "800123456", null, null, [6, 9]], [null, null, "(?:(?:0878|1(?:44|6[346])\\d)\\d\\d|89(?:2|(?:4[5-9]|(?:5[5-9]|9)\\d\\d)\\d))\\d{3}|89[45][0-4]\\d\\d", null, null, null, "899123456", null, null, [6, 8, 9, 10]], [null, null, "84(?:[08]\\d{3}|[17])\\d{3}", null, null, null, "848123456", null, null, [6, 9]], [null, null, "1(?:78\\d|99)\\d{6}", null, null, null, "1781234567", null, null, [9, 10]], [null, null, "55\\d{8}", null, null, null, "5512345678", null, null, [10]], "IT", 39, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{4,6})", "$1 $2", ["0[26]"]], [null, "(\\d{3})(\\d{3,6})", "$1 $2", ["0[13-57-9][0159]|8(?:03|4[17]|9[245])", "0[13-57-9][0159]|8(?:03|4[17]|9(?:2|[45][0-4]))"]], [null, "(\\d{4})(\\d{2,6})", "$1 $2", ["0(?:[13-579][2-46-8]|8[236-8])"]], [null, "(\\d{4})(\\d{4})", "$1 $2", ["894"]], [null, "(\\d{2})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["0[26]|5"]], [null, "(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["1(?:44|[67]|99)|[38]"]], [null, "(\\d{3})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["0[13-57-9][0159]"]], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["3"]], [null, "(\\d{2})(\\d{4})(\\d{5})", "$1 $2 $3", ["0[26]"]], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["0"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], 1, null, [null, null, "848\\d{6}", null, null, null, null, null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    JE: [null, [null, null, "(?:1534|(?:[3578]\\d|90)\\d\\d)\\d{6}", null, null, null, null, null, null, [10], [6]], [null, null, "1534[0-24-8]\\d{5}", null, null, null, "1534456789", null, null, null, [6]], [null, null, "7(?:(?:(?:50|82)9|937)\\d|7(?:00[378]|97[7-9]))\\d{5}", null, null, null, "7797712345"], [null, null, "80(?:07(?:35|81)|8901)\\d{4}", null, null, null, "8007354567"], [null, null, "(?:8(?:4(?:4(?:4(?:05|42|69)|703)|5(?:041|800))|7(?:0002|1206))|90(?:066[59]|1810|71(?:07|55)))\\d{4}", null, null, null, "9018105678"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "701511\\d{4}", null, null, null, "7015115678"], [null, null, "56\\d{8}", null, null, null, "5612345678"], "JE", 44, "00", "0", null, null, "0|([0-24-8]\\d{5})$", "1534$1", null, null, null, null, [null, null, "76(?:0[0-2]|2[356]|4[0134]|5[49]|6[0-369]|77|81|9[39])\\d{6}", null, null, null, "7640123456"], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:3(?:0(?:07(?:35|81)|8901)|3\\d{4}|4(?:4(?:4(?:05|42|69)|703)|5(?:041|800))|7(?:0002|1206))|55\\d{4})\\d{4}", null, null, null, "5512345678"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    JM: [null, [null, null, "(?:[58]\\d\\d|658|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "(?:658[2-9]\\d\\d|876(?:5(?:0[12]|1[0-468]|2[35]|63)|6(?:0[1-3579]|1[0237-9]|[23]\\d|40|5[06]|6[2-589]|7[05]|8[04]|9[4-9])|7(?:0[2-689]|[1-6]\\d|8[056]|9[45])|9(?:0[1-8]|1[02378]|[2-8]\\d|9[2-468])))\\d{4}", null, null, null, "8765230123", null, null, null, [7]], [null, null, "876(?:(?:2[14-9]|[348]\\d)\\d|5(?:0[3-9]|[2-57-9]\\d|6[0-24-9])|7(?:0[07]|7\\d|8[1-47-9]|9[0-36-9])|9(?:[01]9|9[0579]))\\d{4}", null, null, null, "8762101234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "JM", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "658|876", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    JO: [null, [null, null, "(?:(?:(?:[268]|7\\d)\\d|32|53)\\d|900)\\d{5}", null, null, null, null, null, null, [8, 9]], [null, null, "(?:2(?:6(?:2[0-35-9]|3[0-578]|4[24-7]|5[0-24-8]|[6-8][023]|9[0-3])|7(?:0[1-79]|10|2[014-7]|3[0-689]|4[019]|5[0-3578]))|32(?:0[1-69]|1[1-35-7]|2[024-7]|3\\d|4[0-3]|[57][023]|6[03])|53(?:0[0-3]|[13][023]|2[0-59]|49|5[0-35-9]|6[15]|7[45]|8[1-6]|9[0-36-9])|6(?:2[05]0|3(?:00|33)|4(?:0[0-25]|1[2-7]|2[0569]|[38][07-9]|4[025689]|6[0-589]|7\\d|9[0-2])|5(?:[01][056]|2[034]|3[0-57-9]|4[178]|5[0-69]|6[0-35-9]|7[1-379]|8[0-68]|9[0239]))|87(?:[029]0|7[08]))\\d{4}", null, null, null, "62001234", null, null, [8]], [null, null, "7(?:55[0-49]|(?:7[025-9]|[89][0-25-9])\\d)\\d{5}", null, null, null, "790123456", null, null, [9]], [null, null, "80\\d{6}", null, null, null, "80012345", null, null, [8]], [null, null, "900\\d{5}", null, null, null, "90012345", null, null, [8]], [null, null, "85\\d{6}", null, null, null, "85012345", null, null, [8]], [null, null, "70\\d{7}", null, null, null, "700123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], "JO", 962, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["[2356]|87"], "(0$1)"], [null, "(\\d{3})(\\d{5,6})", "$1 $2", ["[89]"], "0$1"], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["7[457-9]"], "0$1"], [null, "(\\d{2})(\\d{7})", "$1 $2", ["7"], "0$1"]], null, [null, null, "74(?:66|77)\\d{5}", null, null, null, "746612345", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "8(?:10|8\\d)\\d{5}", null, null, null, "88101234", null, null, [8]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    JP: [null, [null, null, "00[1-9]\\d{6,14}|[257-9]\\d{9}|(?:00|[1-9]\\d\\d)\\d{6}", null, null, null, null, null, null, [8, 9, 10, 11, 12, 13, 14, 15, 16, 17]], [null, null, "(?:1(?:1[235-8]|2[3-6]|3[3-9]|4[2-6]|[58][2-8]|6[2-7]|7[2-9]|9[1-9])|(?:2[2-9]|[36][1-9])\\d|4(?:[2-578]\\d|6[02-8]|9[2-59])|5(?:[2-589]\\d|6[1-9]|7[2-8])|7(?:[25-9]\\d|3[4-9]|4[02-9])|8(?:[2679]\\d|3[2-9]|4[5-9]|5[1-9]|8[03-9])|9(?:[2-58]\\d|[679][1-9]))\\d{6}", null, null, null, "312345678", null, null, [9]], [null, null, "[7-9]0[1-9]\\d{7}", null, null, null, "9012345678", null, null, [10]], [null, null, "(?:00(?:(?:37|66)\\d{4,11}|777(?:[01]|(?:5|8\\d)\\d)|882[1245]\\d\\d)|(?:120|800\\d)\\d{4})\\d\\d", null, null, null, "120123456"], [null, null, "990\\d{6}", null, null, null, "990123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "60\\d{7}", null, null, null, "601234567", null, null, [9]], [null, null, "50[1-9]\\d{7}", null, null, null, "5012345678", null, null, [10]], "JP", 81, "010", "0", null, null, "0", null, null, null, [[null, "(\\d{4})(\\d{4})", "$1-$2", ["007", "0077", "00777", "00777[01]"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1-$2-$3", ["(?:12|57|99)0"], "0$1"], [null, "(\\d{4})(\\d)(\\d{4})", "$1-$2-$3", ["1(?:26|3[79]|4[56]|5[4-68]|6[3-5])|499|5(?:76|97)|746|8(?:3[89]|47|51|63)|9(?:49|80|9[16])", "1(?:267|3(?:7[247]|9[278])|4(?:5[67]|66)|5(?:47|58|64|8[67])|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:76|97)9|7468|8(?:3(?:8[78]|96)|477|51[24]|636)|9(?:496|802|9(?:1[23]|69))", "1(?:267|3(?:7[247]|9[278])|4(?:5[67]|66)|5(?:47|58|64|8[67])|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:769|979[2-69])|7468|8(?:3(?:8[78]|96[2457-9])|477|51[24]|636[2-57-9])|9(?:496|802|9(?:1[23]|69))"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{4})", "$1-$2-$3", ["1(?:[2-46]|5[2-8]|7[2-689]|8[2-7]|9[1-578])|2(?:2[03-689]|3[3-58]|4[0-468]|5[04-8]|6[013-8]|7[06-9]|8[02-57-9]|9[13])|4(?:2[28]|3[689]|6[035-7]|7[05689]|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9[4-9])|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9[014-9])|8(?:2[49]|3[3-8]|4[5-8]|5[2-9]|6[35-9]|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9[3-7])", "1(?:[2-46]|5(?:[236-8]|[45][2-69])|7[2-689]|8[2-7]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9[2-8])|3(?:[3-6][2-9]|7[2-6]|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5[4-7]|6[2-9]|8[2-8]|9[236-9])|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3[34]|4[2-69]|[5-7]))", "1(?:[2-46]|5(?:[236-8]|[45][2-69])|7[2-689]|8[2-7]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9(?:20|[3578]|4[04-9]|6[56]))|3(?:[3-6][2-9]|7(?:[2-5]|6[0-59])|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5(?:[467]|5[014-9])|6(?:[2-8]|9[02-69])|8[2-8]|9(?:[236-8]|9[23]))|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3(?:3[02-9]|4[0-24689])|4[2-69]|[5-7]))", "1(?:[2-46]|5(?:[236-8]|[45][2-69])|7[2-689]|8[2-7]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9(?:20|[3578]|4[04-9]|6(?:5[25]|60)))|3(?:[3-6][2-9]|7(?:[2-5]|6[0-59])|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5(?:[467]|5[014-9])|6(?:[2-8]|9[02-69])|8[2-8]|9(?:[236-8]|9[23]))|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3(?:3[02-9]|4[0-24689])|4[2-69]|[5-7]))"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["1|2(?:2[37]|5[5-9]|64|78|8[39]|91)|4(?:2[2689]|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93)", "1|2(?:2[37]|5(?:[57]|[68]0|9[19])|64|78|8[39]|917)|4(?:2(?:20|[68]|9[178])|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93[34])", "1|2(?:2[37]|5(?:[57]|[68]0|9(?:17|99))|64|78|8[39]|917)|4(?:2(?:20|[68]|9[178])|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93[34])"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{4})", "$1-$2-$3", ["2(?:[34]7|[56]9|74|9[14-79])|82|993"], "0$1"], [null, "(\\d)(\\d{4})(\\d{4})", "$1-$2-$3", ["[36]|4(?:2[09]|7[01])"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["2[2-9]|4|7[235-9]|9[49]"], "0$1"], [null, "(\\d{4})(\\d{2})(\\d{3,4})", "$1-$2-$3", ["007"]], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3", ["800"], "0$1"], [null, "(\\d{4})(\\d{2})(\\d{4})", "$1-$2-$3", ["008"]], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1-$2-$3", ["[2579]|80"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3,4})", "$1-$2-$3", ["0"]], [null, "(\\d{4})(\\d{4})(\\d{4,5})", "$1-$2-$3", ["0"]], [null, "(\\d{4})(\\d{5})(\\d{5,6})", "$1-$2-$3", ["0"]], [null, "(\\d{4})(\\d{6})(\\d{6,7})", "$1-$2-$3", ["0"]]], [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1-$2-$3", ["(?:12|57|99)0"], "0$1"], [null, "(\\d{4})(\\d)(\\d{4})", "$1-$2-$3", ["1(?:26|3[79]|4[56]|5[4-68]|6[3-5])|499|5(?:76|97)|746|8(?:3[89]|47|51|63)|9(?:49|80|9[16])", "1(?:267|3(?:7[247]|9[278])|4(?:5[67]|66)|5(?:47|58|64|8[67])|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:76|97)9|7468|8(?:3(?:8[78]|96)|477|51[24]|636)|9(?:496|802|9(?:1[23]|69))", "1(?:267|3(?:7[247]|9[278])|4(?:5[67]|66)|5(?:47|58|64|8[67])|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:769|979[2-69])|7468|8(?:3(?:8[78]|96[2457-9])|477|51[24]|636[2-57-9])|9(?:496|802|9(?:1[23]|69))"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{4})", "$1-$2-$3", ["1(?:[2-46]|5[2-8]|7[2-689]|8[2-7]|9[1-578])|2(?:2[03-689]|3[3-58]|4[0-468]|5[04-8]|6[013-8]|7[06-9]|8[02-57-9]|9[13])|4(?:2[28]|3[689]|6[035-7]|7[05689]|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9[4-9])|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9[014-9])|8(?:2[49]|3[3-8]|4[5-8]|5[2-9]|6[35-9]|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9[3-7])", "1(?:[2-46]|5(?:[236-8]|[45][2-69])|7[2-689]|8[2-7]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9[2-8])|3(?:[3-6][2-9]|7[2-6]|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5[4-7]|6[2-9]|8[2-8]|9[236-9])|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3[34]|4[2-69]|[5-7]))", "1(?:[2-46]|5(?:[236-8]|[45][2-69])|7[2-689]|8[2-7]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9(?:20|[3578]|4[04-9]|6[56]))|3(?:[3-6][2-9]|7(?:[2-5]|6[0-59])|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5(?:[467]|5[014-9])|6(?:[2-8]|9[02-69])|8[2-8]|9(?:[236-8]|9[23]))|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3(?:3[02-9]|4[0-24689])|4[2-69]|[5-7]))", "1(?:[2-46]|5(?:[236-8]|[45][2-69])|7[2-689]|8[2-7]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9(?:20|[3578]|4[04-9]|6(?:5[25]|60)))|3(?:[3-6][2-9]|7(?:[2-5]|6[0-59])|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5(?:[467]|5[014-9])|6(?:[2-8]|9[02-69])|8[2-8]|9(?:[236-8]|9[23]))|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3(?:3[02-9]|4[0-24689])|4[2-69]|[5-7]))"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["1|2(?:2[37]|5[5-9]|64|78|8[39]|91)|4(?:2[2689]|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93)", "1|2(?:2[37]|5(?:[57]|[68]0|9[19])|64|78|8[39]|917)|4(?:2(?:20|[68]|9[178])|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93[34])", "1|2(?:2[37]|5(?:[57]|[68]0|9(?:17|99))|64|78|8[39]|917)|4(?:2(?:20|[68]|9[178])|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93[34])"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{4})", "$1-$2-$3", ["2(?:[34]7|[56]9|74|9[14-79])|82|993"], "0$1"], [null, "(\\d)(\\d{4})(\\d{4})", "$1-$2-$3", ["[36]|4(?:2[09]|7[01])"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["2[2-9]|4|7[235-9]|9[49]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3", ["800"], "0$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1-$2-$3", ["[2579]|80"], "0$1"]], [null, null, "20\\d{8}", null, null, null, "2012345678", null, null, [10]], null, null, [null, null, "00(?:(?:37|66)\\d{4,11}|777(?:[01]|(?:5|8\\d)\\d)|882[1245]\\d\\d)\\d\\d"], [null, null, "570\\d{6}", null, null, null, "570123456", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KE: [null, [null, null, "(?:(?:2|80)0\\d?|[4-7]\\d\\d|900)\\d{6}|[4-6]\\d{6,7}", null, null, null, null, null, null, [7, 8, 9, 10]], [null, null, "20\\d{6,7}|(?:4[0-6]|5\\d|6[0-24-9])\\d{7}|(?:4[0245]|6[014-9])\\d{6}|5[1-79]\\d{5,6}|(?:4[245]|6[01457-9])\\d{5}", null, null, null, "202012345", null, null, [7, 8, 9]], [null, null, "7\\d{8}", null, null, null, "712123456", null, null, [9]], [null, null, "800[24-8]\\d{5,6}", null, null, null, "800223456", null, null, [9, 10]], [null, null, "900[02-9]\\d{5}", null, null, null, "900223456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "KE", 254, "000", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{5,7})", "$1 $2", ["[24-6]"], "0$1"], [null, "(\\d{3})(\\d{6})", "$1 $2", ["7"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[89]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KG: [null, [null, null, "(?:[235-7]\\d|99)\\d{7}|800\\d{6,7}", null, null, null, null, null, null, [9, 10], [5, 6]], [null, null, "(?:3(?:1(?:[256]\\d|3[1-9]|47)|2(?:22|3[0-479]|6[0-7])|4(?:22|5[6-9]|6\\d)|5(?:22|3[4-7]|59|6\\d)|6(?:22|5[35-7]|6\\d)|7(?:22|3[468]|4[1-9]|59|[67]\\d)|9(?:22|4[1-8]|6\\d))|6(?:09|12|2[2-4])\\d)\\d{5}", null, null, null, "312123456", null, null, [9], [5, 6]], [null, null, "(?:2(?:0[0-35]|2\\d)|5[0-24-7]\\d|7(?:[07]\\d|55)|99[69])\\d{6}", null, null, null, "700123456", null, null, [9]], [null, null, "800\\d{6,7}", null, null, null, "800123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "KG", 996, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[25-79]|31[25]"], "0$1"], [null, "(\\d{4})(\\d{5})", "$1 $2", ["3"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d)(\\d{2,3})", "$1 $2 $3 $4", ["8"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KH: [null, [null, null, "1\\d{9}|[1-9]\\d{7,8}", null, null, null, null, null, null, [8, 9, 10], [6, 7]], [null, null, "(?:2(?:3(?:4(?:[2-4]|[56]\\d)|[568]\\d\\d)|[4-6](?:4[56]|[56]\\d)\\d)|(?:3[2-6]|4[2-4]|[5-7][2-5])(?:4[56]|[56]\\d)\\d)\\d{4}|(?:2[3-6]|3[2-6]|4[2-4]|[5-7][2-5])[236-9]\\d{5}", null, null, null, "23756789", null, null, [8, 9], [6, 7]], [null, null, "(?:(?:(?:1[28]|9[67])\\d|8(?:[013-79]|8\\d))\\d|(?:2[3-6]|4[2-4]|[56][2-5])48|3(?:[18]\\d\\d|[2-6]48)|7(?:(?:[07-9]|[16]\\d)\\d|[2-5]48))\\d{5}|(?:1\\d|6[016-9]|9[0-57-9])\\d{6}", null, null, null, "91234567", null, null, [8, 9]], [null, null, "1800(?:1\\d|2[019])\\d{4}", null, null, null, "1800123456", null, null, [10]], [null, null, "1900(?:1\\d|2[09])\\d{4}", null, null, null, "1900123456", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "KH", 855, "00[14-9]", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[1-9]"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KI: [null, [null, null, "(?:[37]\\d|6[0-79])\\d{6}|(?:[2-48]\\d|50)\\d{3}", null, null, null, null, null, null, [5, 8]], [null, null, "(?:[24]\\d|3[1-9]|50|65(?:02[12]|12[56]|22[89]|[3-5]00)|7(?:27\\d\\d|3100|5(?:02[12]|12[56]|22[89]|[34](?:00|81)|500))|8[0-5])\\d{3}", null, null, null, "31234"], [null, null, "(?:6(?:200[01]|30[01]\\d)|7(?:200[01]|3(?:0[0-5]\\d|140)))\\d{3}", null, null, null, "72001234", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "30(?:0[01]\\d\\d|12(?:11|20))\\d\\d", null, null, null, "30010000", null, null, [8]], "KI", 686, "00", "0", null, null, "0", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KM: [null, [null, null, "[3478]\\d{6}", null, null, null, null, null, null, [7]], [null, null, "7[4-7]\\d{5}", null, null, null, "7712345"], [null, null, "[34]\\d{6}", null, null, null, "3212345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "8\\d{6}", null, null, null, "8001234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "KM", 269, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3", ["[3478]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KN: [null, [null, null, "(?:[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "869(?:2(?:29|36)|302|4(?:6[015-9]|70))\\d{4}", null, null, null, "8692361234", null, null, null, [7]], [null, null, "869(?:5(?:5[6-8]|6[5-7])|66\\d|76[02-7])\\d{4}", null, null, null, "8697652917", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "KN", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "869", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KP: [null, [null, null, "(?:(?:19\\d|2)\\d|85)\\d{6}", null, null, null, null, null, null, [8, 10], [6, 7]], [null, null, "(?:2\\d|85)\\d{6}", null, null, null, "21234567", null, null, [8], [6, 7]], [null, null, "19[1-3]\\d{7}", null, null, null, "1921234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "KP", 850, "00|99", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["2"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "2(?:[0-24-9]\\d\\d|3(?:[0-79]\\d|8[02-9]))\\d{4}", null, null, null, null, null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KR: [null, [null, null, "(?:00[1-9]\\d{2,4}|[12]|5\\d{3})\\d{7}|(?:(?:00|[13-6])\\d|70)\\d{8}|(?:[1-6]\\d|80)\\d{7}|[3-6]\\d{4,5}", null, null, null, null, null, null, [5, 6, 8, 9, 10, 11, 12, 13, 14], [3, 7]], [null, null, "2[1-9]\\d{6,7}|(?:3[1-3]|[46][1-4]|5[1-5])(?:1\\d{2,3}|[1-9]\\d{6,7})", null, null, null, "22123456", null, null, [5, 6, 8, 9, 10], [3, 7]], [null, null, "1[0-26-9]\\d{7,8}", null, null, null, "1000000000", null, null, [9, 10]], [null, null, "(?:00(?:3(?:08|68\\d)|798\\d{1,3})|80\\d)\\d{6}", null, null, null, "801234567", null, null, [9, 11, 12, 13, 14]], [null, null, "60[2-9]\\d{6}", null, null, null, "602345678", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "50\\d{8,9}", null, null, null, "5012345678", null, null, [10, 11]], [null, null, "70\\d{8}", null, null, null, "7012345678", null, null, [10]], "KR", 82, "00(?:[125689]|3(?:[46]5|91)|7(?:00|27|3|55|6[126]))", "0", null, null, "0(8[1-46-8]|85\\d{2})?", null, null, null, [[null, "(\\d{2})(\\d{3,4})", "$1-$2", ["(?:3[1-3]|[46][1-4]|5[1-5])1"], "0$1", "0$CC-$1"], [null, "(\\d{4})(\\d{4})", "$1-$2", ["1(?:5[246-9]|6[046-8]|8[03579])", "1(?:5(?:22|44|66|77|88|99)|6(?:[07]0|44|6[16]|88)|8(?:00|33|55|77|99))"], "$1", "0$CC-$1"], [null, "(\\d{5})", "$1", ["1[016-9]1", "1[016-9]11", "1[016-9]114"], "0$1", "0$CC-$1"], [null, "(\\d)(\\d{3,4})(\\d{4})", "$1-$2-$3", ["2[1-9]"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["60[2-9]|80"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{3,4})(\\d{4})", "$1-$2-$3", ["1[0-25-9]|(?:3[1-3]|[46][1-4]|5[1-5])[1-9]"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1-$2-$3", ["[57]0"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{5})(\\d{4})", "$1-$2-$3", ["50"], "0$1", "0$CC-$1"], [null, "(\\d{5})(\\d{3})(\\d{3})", "$1 $2 $3", ["003", "0030", "00308"], "$1", "0$CC-$1"], [null, "(\\d{5})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["00[37]", "00(?:36|79)", "00(?:36|79)8"], "$1", "0$CC-$1"], [null, "(\\d{5})(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3 $4", ["007", "0079", "00798"], "$1", "0$CC-$1"]], [[null, "(\\d{2})(\\d{3,4})", "$1-$2", ["(?:3[1-3]|[46][1-4]|5[1-5])1"], "0$1", "0$CC-$1"], [null, "(\\d{4})(\\d{4})", "$1-$2", ["1(?:5[246-9]|6[046-8]|8[03579])", "1(?:5(?:22|44|66|77|88|99)|6(?:[07]0|44|6[16]|88)|8(?:00|33|55|77|99))"], "$1", "0$CC-$1"], [null, "(\\d{5})", "$1", ["1[016-9]1", "1[016-9]11", "1[016-9]114"], "0$1", "0$CC-$1"], [null, "(\\d)(\\d{3,4})(\\d{4})", "$1-$2-$3", ["2[1-9]"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["60[2-9]|80"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{3,4})(\\d{4})", "$1-$2-$3", ["1[0-25-9]|(?:3[1-3]|[46][1-4]|5[1-5])[1-9]"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1-$2-$3", ["[57]0"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{5})(\\d{4})", "$1-$2-$3", ["50"], "0$1", "0$CC-$1"]], [null, null, "15\\d{7,8}", null, null, null, "1523456789", null, null, [9, 10]], null, null, [null, null, "00(?:3(?:08|68\\d)|798\\d{1,3})\\d{6}", null, null, null, null, null, null, [11, 12, 13, 14]], [null, null, "1(?:5(?:22|44|66|77|88|99)|6(?:00|44|6[16]|70|88)|8(?:00|33|55|77|99))\\d{4}", null, null, null, "15441234", null, null, [8]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KW: [null, [null, null, "(?:18|[2569]\\d\\d)\\d{5}", null, null, null, null, null, null, [7, 8]], [null, null, "2(?:[23]\\d\\d|4(?:[1-35-9]\\d|44)|5(?:0[034]|[2-46]\\d|5[1-3]|7[1-7]))\\d{4}", null, null, null, "22345678", null, null, [8]], [null, null, "(?:5(?:(?:[05]\\d|1[0-7]|6[56])\\d|2(?:22|5[25]))|6(?:(?:0[034679]|5[015-9]|6\\d)\\d|222|7(?:0[013-9]|[67]\\d)|9(?:[069]\\d|3[039]))|9(?:(?:0[09]|22|4[01479]|55|6[0679]|8[057-9]|9\\d)\\d|11[01]|7(?:02|[1-9]\\d)))\\d{4}", null, null, null, "50012345", null, null, [8]], [null, null, "18\\d{5}", null, null, null, "1801234", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "KW", 965, "00", null, null, null, null, null, null, null, [[null, "(\\d{4})(\\d{3,4})", "$1 $2", ["[169]|2(?:[235]|4[1-35-9])|52"]], [null, "(\\d{3})(\\d{5})", "$1 $2", ["[25]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KY: [null, [null, null, "(?:345|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "345(?:2(?:22|44)|444|6(?:23|38|40)|7(?:4[35-79]|6[6-9]|77)|8(?:00|1[45]|25|[48]8)|9(?:14|4[035-9]))\\d{4}", null, null, null, "3452221234", null, null, null, [7]], [null, null, "345(?:32[1-9]|5(?:1[67]|2[5-79]|4[6-9]|50|76)|649|9(?:1[67]|2[2-9]|3[689]))\\d{4}", null, null, null, "3453231234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002345678"], [null, null, "(?:345976|900[2-9]\\d\\d)\\d{4}", null, null, null, "9002345678"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "KY", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, "345849\\d{4}", null, null, null, "3458491234"], null, "345", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KZ: [null, [null, null, "(?:33622|(?:7\\d|80)\\d{3})\\d{5}", null, null, null, null, null, null, [10]], [null, null, "(?:33622|7(?:1(?:0(?:[23]\\d|4[0-3]|59|63)|1(?:[23]\\d|4[0-79]|59)|2(?:[23]\\d|59)|3(?:2\\d|3[0-79]|4[0-35-9]|59)|4(?:[24]\\d|3[013-9]|5[1-9])|5(?:2\\d|3[1-9]|4[0-7]|59)|6(?:[2-4]\\d|5[19]|61)|72\\d|8(?:[27]\\d|3[1-46-9]|4[0-5]))|2(?:1(?:[23]\\d|4[46-9]|5[3469])|2(?:2\\d|3[0679]|46|5[12679])|3(?:[2-4]\\d|5[139])|4(?:2\\d|3[1-35-9]|59)|5(?:[23]\\d|4[0-246-8]|59|61)|6(?:2\\d|3[1-9]|4[0-4]|59)|7(?:[2379]\\d|40|5[279])|8(?:[23]\\d|4[0-3]|59)|9(?:2\\d|3[124578]|59))))\\d{5}", null, null, null, "7123456789"], [null, null, "7(?:0[0-2578]|47|6[02-4]|7[15-8]|85)\\d{7}", null, null, null, "7710009998"], [null, null, "800\\d{7}", null, null, null, "8001234567"], [null, null, "809\\d{7}", null, null, null, "8091234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "808\\d{7}", null, null, null, "8081234567"], [null, null, "751\\d{7}", null, null, null, "7511234567"], "KZ", 7, "810", "8", null, null, "8", null, "8~10", null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "33|7", [null, null, "751\\d{7}"], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LA: [null, [null, null, "(?:2\\d|3)\\d{8}|(?:[235-8]\\d|41)\\d{6}", null, null, null, null, null, null, [8, 9, 10], [6]], [null, null, "(?:2[13]|[35-7][14]|41|8[1468])\\d{6}", null, null, null, "21212862", null, null, [8], [6]], [null, null, "20(?:2[2389]|5[24-689]|7[6-8]|9[1-35-9])\\d{6}", null, null, null, "2023123456", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "LA", 856, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["2[13]|3[14]|[4-8]"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["3"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["2"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "30\\d{7}", null, null, null, "301234567", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LB: [null, [null, null, "[7-9]\\d{7}|[13-9]\\d{6}", null, null, null, null, null, null, [7, 8]], [null, null, "(?:(?:[14-69]\\d|8[02-9])\\d|7(?:[2-57]\\d|62|8[0-7]|9[04-9]))\\d{4}", null, null, null, "1123456", null, null, [7]], [null, null, "(?:(?:3|81)\\d|7(?:[01]\\d|6[013-9]|8[89]|9[1-3]))\\d{5}", null, null, null, "71123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "9[01]\\d{6}", null, null, null, "90123456", null, null, [8]], [null, null, "80\\d{6}", null, null, null, "80123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "LB", 961, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["[13-69]|7(?:[2-57]|62|8[0-7]|9[04-9])|8[02-9]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[7-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LC: [null, [null, null, "(?:[58]\\d\\d|758|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "758(?:4(?:30|5\\d|6[2-9]|8[0-2])|57[0-2]|638)\\d{4}", null, null, null, "7584305678", null, null, null, [7]], [null, null, "758(?:28[4-7]|384|4(?:6[01]|8[4-9])|5(?:1[89]|20|84)|7(?:1[2-9]|2\\d|3[01]))\\d{4}", null, null, null, "7582845678", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "LC", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "758", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LI: [null, [null, null, "(?:(?:[2378]|6\\d\\d)\\d|90)\\d{5}", null, null, null, null, null, null, [7, 9]], [null, null, "(?:2(?:01|1[27]|3\\d|6[02-578]|96)|3(?:7[0135-7]|8[048]|9[0269]))\\d{4}", null, null, null, "2345678", null, null, [7]], [null, null, "(?:6(?:5(?:09|1\\d|20)|6(?:0[0-6]|10|2[06-9]|39))\\d|7(?:[37-9]\\d|42|56))\\d{4}", null, null, null, "660234567"], [null, null, "80(?:02[28]|9\\d\\d)\\d\\d", null, null, null, "8002222", null, null, [7]], [null, null, "90(?:02[258]|1(?:23|3[14])|66[136])\\d\\d", null, null, null, "9002222", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "LI", 423, "00", "0", null, null, "0|(10(?:01|20|66))", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3", ["[237-9]"], null, "$CC $1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["6[56]"], null, "$CC $1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["6"], null, "$CC $1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "870(?:28|87)\\d\\d", null, null, null, "8702812", null, null, [7]], null, null, [null, null, "697(?:42|56|[78]\\d)\\d{4}", null, null, null, "697861234", null, null, [9]]],
    LK: [null, [null, null, "(?:[1-7]\\d|[89]1)\\d{7}", null, null, null, null, null, null, [9], [7]], [null, null, "(?:[189]1|2[13-7]|3[1-8]|4[157]|5[12457]|6[35-7])[2-57]\\d{6}", null, null, null, "112345678", null, null, null, [7]], [null, null, "7[0-25-8]\\d{7}", null, null, null, "712345678"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "LK", 94, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[1-689]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["7"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "1973\\d{5}", null, null, null, "197312345"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LR: [null, [null, null, "(?:[25]\\d|33|77|88)\\d{7}|(?:2\\d|[45])\\d{6}", null, null, null, null, null, null, [7, 8, 9]], [null, null, "(?:2\\d{3}|33333)\\d{4}", null, null, null, "21234567", null, null, [8, 9]], [null, null, "(?:(?:(?:20|77|88)\\d|330|555)\\d|4[67])\\d{5}|5\\d{6}", null, null, null, "770123456", null, null, [7, 9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "332(?:02|[34]\\d)\\d{4}", null, null, null, "332021234", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "LR", 231, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["[45]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["2"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[23578]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LS: [null, [null, null, "(?:[256]\\d\\d|800)\\d{5}", null, null, null, null, null, null, [8]], [null, null, "2\\d{7}", null, null, null, "22123456"], [null, null, "[56]\\d{7}", null, null, null, "50123456"], [null, null, "800[256]\\d{4}", null, null, null, "80021234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "LS", 266, "00", null, null, null, null, null, null, null, [[null, "(\\d{4})(\\d{4})", "$1 $2", ["[2568]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LT: [null, [null, null, "(?:[3469]\\d|52|[78]0)\\d{6}", null, null, null, null, null, null, [8]], [null, null, "(?:3[1478]|4[124-6]|52)\\d{6}", null, null, null, "31234567"], [null, null, "6\\d{7}", null, null, null, "61234567"], [null, null, "800\\d{5}", null, null, null, "80012345"], [null, null, "9(?:0[0239]|10)\\d{5}", null, null, null, "90012345"], [null, null, "808\\d{5}", null, null, null, "80812345"], [null, null, "700\\d{5}", null, null, null, "70012345"], [null, null, null, null, null, null, null, null, null, [-1]], "LT", 370, "00", "8", null, null, "[08]", null, null, null, [[null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["52[0-79]"], "(8-$1)", null, 1], [null, "(\\d{2})(\\d{6})", "$1 $2", ["37|4(?:[15]|6[1-8])"], "(8-$1)", null, 1], [null, "(\\d{3})(\\d{5})", "$1 $2", ["[3-6]"], "(8-$1)", null, 1], [null, "(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["[7-9]"], "8 $1", null, 1]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "70[67]\\d{5}", null, null, null, "70712345"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LU: [null, [null, null, "[2457-9]\\d{3,10}|3(?:[0-46-9]\\d{2,9}|5(?:[013-9]\\d{1,8}|2\\d{1,3}))|6\\d{8}", null, null, null, null, null, null, [4, 5, 6, 7, 8, 9, 10, 11]], [null, null, "(?:(?:2[2-9]|[457]\\d)\\d|3(?:[0-46-9]\\d|5[013-9])|8(?:0[2-9]|[13-9]\\d)|9(?:0[89]|[2-579]\\d))\\d{1,8}", null, null, null, "27123456"], [null, null, "6(?:[269][18]|5[158]|7[189]|81)\\d{6}", null, null, null, "628123456", null, null, [9]], [null, null, "800\\d{5}", null, null, null, "80012345", null, null, [8]], [null, null, "90[015]\\d{5}", null, null, null, "90012345", null, null, [8]], [null, null, "801\\d{5}", null, null, null, "80112345", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "20(?:1\\d{5}|[2-689]\\d{1,7})", null, null, null, "20201234", null, null, [4, 5, 6, 7, 8, 9, 10]], "LU", 352, "00", null, null, null, "(15(?:0[06]|1[12]|[35]5|4[04]|6[26]|77|88|99)\\d)", null, null, null, [[null, "(\\d{2})(\\d{3})", "$1 $2", ["2(?:0[2-689]|[2-9])|3(?:[0-46-9]|5[013-9])|[457]|8(?:0[2-9]|[13-9])|9(?:0[89]|[2-579])"], null, "$CC $1"], [null, "(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3", ["2(?:0[2-689]|[2-9])|3(?:[0-46-9]|5[013-9])|[457]|8(?:0[2-9]|[13-9])|9(?:0[89]|[2-579])"], null, "$CC $1"], [null, "(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3", ["20[2-689]"], null, "$CC $1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{1,2})", "$1 $2 $3 $4", ["2(?:0[1-689]|[367]|4[3-8])"], null, "$CC $1"], [null, "(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["80[01]|90[015]"], null, "$CC $1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["20[2-689]"], null, "$CC $1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["6"], null, "$CC $1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\d{1,2})", "$1 $2 $3 $4 $5", ["2(?:0[2-689]|[367]|4[3-8])"], null, "$CC $1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{1,5})", "$1 $2 $3 $4", ["2[2-9]|3(?:[0-46-9]|5[013-9])|[457]|8(?:0[2-9]|[13-9])|9(?:0[89]|[2-579])"], null, "$CC $1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LV: [null, [null, null, "(?:[268]\\d|90)\\d{6}", null, null, null, null, null, null, [8]], [null, null, "6\\d{7}", null, null, null, "63123456"], [null, null, "2\\d{7}", null, null, null, "21234567"], [null, null, "80\\d{6}", null, null, null, "80123456"], [null, null, "90\\d{6}", null, null, null, "90123456"], [null, null, "81\\d{6}", null, null, null, "81123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "LV", 371, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[269]|8[01]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LY: [null, [null, null, "(?:[2569]\\d|71)\\d{7}", null, null, null, null, null, null, [9], [7]], [null, null, "(?:2[13-5]|5[1347]|6[1-479]|71)\\d{7}", null, null, null, "212345678", null, null, null, [7]], [null, null, "9[1-6]\\d{7}", null, null, null, "912345678"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "LY", 218, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{7})", "$1-$2", ["[25-79]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MA: [null, [null, null, "[5-8]\\d{8}", null, null, null, null, null, null, [9]], [null, null, "5(?:2(?:[015-79]\\d|2[02-9]|3[2-57]|4[2-8]|8[235-7])|3(?:[0-48]\\d|[57][2-9]|6[2-8]|9[3-9])|(?:4[067]|5[03])\\d)\\d{5}", null, null, null, "520123456"], [null, null, "(?:6(?:[0-79]\\d|8[0-247-9])|7(?:0[067]|6[1267]|7[017]))\\d{6}", null, null, null, "650123456"], [null, null, "80\\d{7}", null, null, null, "801234567"], [null, null, "89\\d{7}", null, null, null, "891234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5924[01]\\d{4}", null, null, null, "592401234"], "MA", 212, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{6})", "$1-$2", ["5(?:2[015-7]|3[0-4])|[67]"], "0$1"], [null, "(\\d{4})(\\d{5})", "$1-$2", ["5(?:2[2-489]|3[5-9]|9)|892", "5(?:2(?:[2-48]|9[0-7])|3(?:[5-79]|8[0-7])|9)|892"], "0$1"], [null, "(\\d{5})(\\d{4})", "$1-$2", ["5[23]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["5"], "0$1"], [null, "(\\d{2})(\\d{7})", "$1-$2", ["8"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], 1, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MC: [null, [null, null, "(?:(?:[349]|6\\d)\\d\\d|870)\\d{5}", null, null, null, null, null, null, [8, 9]], [null, null, "(?:870|9[2-47-9]\\d)\\d{5}", null, null, null, "99123456", null, null, [8]], [null, null, "(?:(?:3|6\\d)\\d\\d|4(?:4\\d|5[1-9]))\\d{5}", null, null, null, "612345678"], [null, null, "90\\d{6}", null, null, null, "90123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "MC", 377, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{2})", "$1 $2 $3", ["8"]], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[39]"]], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["4"], "0$1"], [null, "(\\d)(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["6"], "0$1"]], [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[39]"]], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["4"], "0$1"], [null, "(\\d)(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["6"], "0$1"]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "870\\d{5}", null, null, null, null, null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MD: [null, [null, null, "(?:[235-7]\\d|[89]0)\\d{6}", null, null, null, null, null, null, [8]], [null, null, "(?:(?:2[1-9]|3[1-79])\\d|5(?:33|5[257]))\\d{5}", null, null, null, "22212345"], [null, null, "(?:562|6\\d\\d|7(?:[189]\\d|6[07]|7[457-9]))\\d{5}", null, null, null, "62112345"], [null, null, "800\\d{5}", null, null, null, "80012345"], [null, null, "90[056]\\d{5}", null, null, null, "90012345"], [null, null, "808\\d{5}", null, null, null, "80812345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "3[08]\\d{6}", null, null, null, "30123456"], "MD", 373, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["22|3"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["[25-7]"], "0$1"], [null, "(\\d{3})(\\d{5})", "$1 $2", ["[89]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "803\\d{5}", null, null, null, "80312345"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    ME: [null, [null, null, "(?:20|[3-79]\\d|80\\d?)\\d{6}", null, null, null, null, null, null, [8, 9], [6]], [null, null, "(?:20[2-8]|3(?:[0-2][2-7]|3[24-7])|4(?:0[2-467]|1[2467])|5(?:[01][2467]|2[2-467]))\\d{5}", null, null, null, "30234567", null, null, [8], [6]], [null, null, "6(?:00|3[024]|6[0-25]|[7-9]\\d)\\d{5}", null, null, null, "67622901", null, null, [8]], [null, null, "80(?:[0-2578]|9\\d)\\d{5}", null, null, null, "80080002"], [null, null, "9(?:4[1568]|5[178])\\d{5}", null, null, null, "94515151", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "78[1-49]\\d{5}", null, null, null, "78108780", null, null, [8]], "ME", 382, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2-9]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "77[1-9]\\d{5}", null, null, null, "77273012", null, null, [8]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MF: [null, [null, null, "(?:590|69\\d)\\d{6}", null, null, null, null, null, null, [9]], [null, null, "590(?:0[079]|[14]3|[27][79]|30|5[0-268]|87)\\d{4}", null, null, null, "590271234"], [null, null, "69(?:0\\d\\d|1(?:2[29]|3[0-5]))\\d{4}", null, null, null, "690001234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "MF", 590, "00", "0", null, null, "0", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MG: [null, [null, null, "[23]\\d{8}", null, null, null, null, null, null, [9], [7]], [null, null, "20(?:(?:2\\d|4[47]|5[3467]|6[279]|8[268]|9[245])\\d|7(?:2[29]|[35]\\d))\\d{4}", null, null, null, "202123456", null, null, null, [7]], [null, null, "3[2-49]\\d{7}", null, null, null, "321234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "22\\d{7}", null, null, null, "221234567"], "MG", 261, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{3})(\\d{2})", "$1 $2 $3 $4", ["[23]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MH: [null, [null, null, "(?:(?:[256]\\d|45)\\d|329)\\d{4}", null, null, null, null, null, null, [7]], [null, null, "(?:247|528|625)\\d{4}", null, null, null, "2471234"], [null, null, "(?:(?:23|54)5|329|45[56])\\d{4}", null, null, null, "2351234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "635\\d{4}", null, null, null, "6351234"], "MH", 692, "011", "1", null, null, "1", null, null, null, [[null, "(\\d{3})(\\d{4})", "$1-$2", ["[2-6]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MK: [null, [null, null, "[2-578]\\d{7}", null, null, null, null, null, null, [8], [6, 7]], [null, null, "(?:2(?:[23]\\d|5[0-24578]|6[01]|82)|3(?:1[3-68]|[23][2-68]|4[23568])|4(?:[23][2-68]|4[3-68]|5[2568]|6[25-8]|7[24-68]|8[4-68]))\\d{5}", null, null, null, "22012345", null, null, null, [6, 7]], [null, null, "7(?:(?:[0-25-8]\\d|3[2-4]|9[23])\\d|421)\\d{4}", null, null, null, "72345678"], [null, null, "800\\d{5}", null, null, null, "80012345"], [null, null, "5[02-9]\\d{6}", null, null, null, "50012345"], [null, null, "8(?:0[1-9]|[1-9]\\d)\\d{5}", null, null, null, "80123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "MK", 389, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["2"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[347]"], "0$1"], [null, "(\\d{3})(\\d)(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[58]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    ML: [null, [null, null, "(?:[246-9]\\d|50)\\d{6}", null, null, null, null, null, null, [8]], [null, null, "(?:2(?:0(?:2\\d|7[0-8])|1(?:2[67]|[4-689]\\d))|4(?:0[0-4]|4[1-39])\\d)\\d{4}", null, null, null, "20212345"], [null, null, "(?:2(?:079|17\\d)|(?:50|[679]\\d|8[239])\\d\\d)\\d{4}", null, null, null, "65012345"], [null, null, "80\\d{6}", null, null, null, "80012345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "ML", 223, "00", null, null, null, null, null, null, null, [[null, "(\\d{4})", "$1", ["67[057-9]|74[045]", "67(?:0[09]|[59]9|77|8[89])|74(?:0[02]|44|55)"]], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[24-79]|8[0239]"]]], [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[24-79]|8[0239]"]]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "80\\d{6}"], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MM: [null, [null, null, "(?:1|[24-7]\\d)\\d{5,7}|8\\d{6,9}|9(?:[0-46-9]\\d{6,8}|5\\d{6})|2\\d{5}", null, null, null, null, null, null, [6, 7, 8, 9, 10], [5]], [null, null, "(?:1(?:(?:2\\d|3[56]|[89][0-6])\\d|4(?:2[2-469]|39|6[25]|7[01])|6)|2(?:2(?:00|8[34])|4(?:0\\d|2[246]|39|62|7[01])|51\\d\\d)|4(?:2(?:2\\d\\d|480)|3(?:20\\d|470|56)|420\\d|5470)|5(?:2(?:2\\d\\d?|470)|4(?:2(?:1|86)|470)|522\\d|7(?:20\\d|480)|[89](?:20\\d|470))|6(?:0(?:[23]|88\\d)|(?:124|42[04]|[56]2\\d)\\d|3(?:20\\d|470)|7(?:(?:3\\d|8[01459])\\d|4(?:39|[67]0)))|7(?:0470|1(?:20\\d?|470)|4(?:25\\d|470)|5(?:202|470|96\\d))|8(?:[13](?:2\\d\\d|470)|[25]2\\d\\d))\\d{4}|(?:(?:1[2-6]\\d|4(?:2[24-8]|3[2-7]|[46][2-6]|5[3-5])|5(?:[27][2-8]|3[2-68]|4[24-8]|5[23]|6[2-4]|8[24-7]|9[2-7])|6(?:[19]20|42[03-6]|(?:52|7[45])\\d)|7(?:[04][24-8]|[15][2-7]|22|3[2-4]))\\d|25\\d{2,3}|8(?:[135]2\\d\\d|2(?:2\\d\\d|320)))\\d{3}|(?:2[2-9]|6(?:1[2356]|[24][2-6]|3[24-6]|5[2-4]|6[2-8]|7[235-7]|8[245]|9[24])|8(?:1[2-689]|2[2-8]|3[24]|4[24-7]|5[245]|6[23]))\\d{4}", null, null, null, "1234567", null, null, [6, 7, 8, 9], [5]], [null, null, "(?:17[01]|9(?:2(?:[0-4]|(?:5\\d|6[0-5])\\d)|(?:3(?:[0-36]|4[069])|[68]9\\d|7(?:3|5[0-2]|[6-9]\\d))\\d|4(?:(?:0[0-4]|[1379]|[25]\\d|4[0-589])\\d|88)|5[0-6]|9(?:[089]|[5-7]\\d\\d))\\d)\\d{4}|9[69]1\\d{6}|9[68]\\d{6}", null, null, null, "92123456", null, null, [7, 8, 9, 10]], [null, null, "80080(?:[01][1-9]|2\\d)\\d{3}", null, null, null, "8008001234", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:1(?:333|468)|2468)\\d{4}", null, null, null, "13331234", null, null, [8]], "MM", 95, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{2})(\\d{3})", "$1 $2 $3", ["16|2"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3", ["[45]|6(?:0[23]|[1-689]|7[235-7])|7(?:[0-4]|5[2-7])|8[1-6]"], "0$1"], [null, "(\\d)(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[12]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[4-7]|8[1-35]"], "0$1"], [null, "(\\d)(\\d{3})(\\d{4,6})", "$1 $2 $3", ["9(?:2[0-4]|[35-9]|4[137-9])"], "0$1"], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["2"], "0$1"], [null, "(\\d)(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["92"], "0$1"], [null, "(\\d)(\\d{5})(\\d{4})", "$1 $2 $3", ["9"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["8"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MN: [null, [null, null, "[12]\\d{8,9}|[1257-9]\\d{7}", null, null, null, null, null, null, [8, 9, 10], [4, 5, 6]], [null, null, "(?:[12](?:1|2[1-37]|(?:3[2-8]|4[2-68]|5[1-4689])\\d?)|5[0568])\\d{6}|[12]2[1-3]\\d{5}", null, null, null, "50123456", null, null, null, [4, 5, 6]], [null, null, "(?:8(?:[05689]\\d|3[01])|9[013-9]\\d)\\d{5}", null, null, null, "88123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "7[05-8]\\d{6}", null, null, null, "75123456", null, null, [8]], "MN", 976, "001", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{4})", "$1 $2 $3", ["[12]1"], "0$1"], [null, "(\\d{4})(\\d{4})", "$1 $2", ["[57-9]"]], [null, "(\\d{3})(\\d{5,6})", "$1 $2", ["[12]2[1-3]"], "0$1"], [null, "(\\d{4})(\\d{5,6})", "$1 $2", ["[12](?:27|3[2-8]|4[2-68]|5[1-4689])", "[12](?:27|3[2-8]|4[2-68]|5[1-4689])[0-3]"], "0$1"], [null, "(\\d{5})(\\d{4,5})", "$1 $2", ["[12]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MO: [null, [null, null, "(?:28|[68]\\d)\\d{6}", null, null, null, null, null, null, [8]], [null, null, "(?:28[2-57-9]|8(?:11|[2-57-9]\\d))\\d{5}", null, null, null, "28212345"], [null, null, "6(?:[2356]\\d\\d|8(?:[02][5-9]|[1478]\\d|[356][0-4]))\\d{4}", null, null, null, "66123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "MO", 853, "00", null, null, null, null, null, null, null, [[null, "(\\d{4})(\\d{4})", "$1 $2", ["[268]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MP: [null, [null, null, "(?:[58]\\d\\d|(?:67|90)0)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "670(?:2(?:3[3-7]|56|8[5-8])|32[1-38]|4(?:33|8[348])|5(?:32|55|88)|6(?:64|70|82)|78[3589]|8[3-9]8|989)\\d{4}", null, null, null, "6702345678", null, null, null, [7]], [null, null, "670(?:2(?:3[3-7]|56|8[5-8])|32[1-38]|4(?:33|8[348])|5(?:32|55|88)|6(?:64|70|82)|78[3589]|8[3-9]8|989)\\d{4}", null, null, null, "6702345678", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "MP", 1, "011", "1", null, null, "1", null, null, 1, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "670", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MQ: [null, [null, null, "(?:596|69\\d)\\d{6}", null, null, null, null, null, null, [9]], [null, null, "596(?:0[0-7]|10|2[7-9]|3[05-9]|4[0-46-8]|[5-7]\\d|8[09]|9[4-8])\\d{4}", null, null, null, "596301234"], [null, null, "69(?:6(?:[0-47-9]\\d|5[0-6]|6[0-4])|727)\\d{4}", null, null, null, "696201234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "MQ", 596, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[56]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MR: [null, [null, null, "(?:[2-4]\\d\\d|800)\\d{5}", null, null, null, null, null, null, [8]], [null, null, "(?:25[08]|35\\d|45[1-7])\\d{5}", null, null, null, "35123456"], [null, null, "[2-4][0-46-9]\\d{6}", null, null, null, "22123456"], [null, null, "800\\d{5}", null, null, null, "80012345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "MR", 222, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2-48]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MS: [null, [null, null, "(?:(?:[58]\\d\\d|900)\\d\\d|66449)\\d{5}", null, null, null, null, null, null, [10], [7]], [null, null, "664491\\d{4}", null, null, null, "6644912345", null, null, null, [7]], [null, null, "66449[2-6]\\d{4}", null, null, null, "6644923456", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "MS", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "664", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MT: [null, [null, null, "(?:(?:[2579]\\d\\d|800)\\d|3550)\\d{4}", null, null, null, null, null, null, [8]], [null, null, "2(?:0(?:[169]\\d|3[1-4])|[1-357]\\d\\d)\\d{4}", null, null, null, "21001234"], [null, null, "(?:7(?:210|[79]\\d\\d)|9(?:2(?:1[01]|31)|69[67]|8(?:1[1-3]|89|97)|9\\d\\d))\\d{4}", null, null, null, "96961234"], [null, null, "800[3467]\\d{4}", null, null, null, "80071234"], [null, null, "5(?:0(?:0(?:37|43)|(?:6\\d|70|9[0168])\\d)|[12]\\d0[1-5])\\d{3}", null, null, null, "50037123"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "3550\\d{4}", null, null, null, "35501234"], "MT", 356, "00", null, null, null, null, null, null, null, [[null, "(\\d{4})(\\d{4})", "$1 $2", ["[2357-9]"]]], null, [null, null, "7117\\d{4}", null, null, null, "71171234"], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "501\\d{5}", null, null, null, "50112345"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MU: [null, [null, null, "(?:[2-468]|5\\d)\\d{6}", null, null, null, null, null, null, [7, 8]], [null, null, "(?:2(?:[03478]\\d|1[0-7]|6[0-79])|4(?:[013568]\\d|2[4-7])|54(?:4\\d|71)|6\\d\\d|8(?:14|3[129]))\\d{4}", null, null, null, "54480123"], [null, null, "5(?:(?:2[589]|7\\d|9[0-8])\\d|4(?:2[1-389]|[489]\\d|7[1-9])|8(?:[0-689]\\d|7[15-8]))\\d{4}", null, null, null, "52512345", null, null, [8]], [null, null, "80[0-2]\\d{4}", null, null, null, "8001234", null, null, [7]], [null, null, "30\\d{5}", null, null, null, "3012345", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "3(?:20|9\\d)\\d{4}", null, null, null, "3201234", null, null, [7]], "MU", 230, "0(?:0|[24-7]0|3[03])", null, null, null, null, null, "020", null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[2-46]|8(?:0[0-2]|14|3[129])"]], [null, "(\\d{4})(\\d{4})", "$1 $2", ["5"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MV: [null, [null, null, "(?:800|9[0-57-9]\\d)\\d{7}|[34679]\\d{6}", null, null, null, null, null, null, [7, 10]], [null, null, "(?:3(?:0[0-3]|3[0-59])|6(?:[57][02468]|6[024-68]|8[024689]))\\d{4}", null, null, null, "6701234", null, null, [7]], [null, null, "(?:46[46]|(?:7[2-9]|9[14-9])\\d)\\d{4}", null, null, null, "7712345", null, null, [7]], [null, null, "800\\d{7}", null, null, null, "8001234567", null, null, [10]], [null, null, "900\\d{7}", null, null, null, "9001234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "MV", 960, "0(?:0|19)", null, null, null, null, null, "00", null, [[null, "(\\d{3})(\\d{4})", "$1-$2", ["[367]|4(?:00|[56])|9[14-9]"]], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[89]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "4[05]0\\d{4}", null, null, null, "4001234", null, null, [7]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MW: [null, [null, null, "1\\d{6}(?:\\d{2})?|(?:[23]1|77|88|99)\\d{7}", null, null, null, null, null, null, [7, 9]], [null, null, "(?:1[2-9]|21\\d\\d)\\d{5}", null, null, null, "1234567"], [null, null, "(?:111|(?:77|88|99)\\d)\\d{6}", null, null, null, "991234567", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "31\\d{7}", null, null, null, "310123456", null, null, [9]], "MW", 265, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["1[2-9]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["2"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[17-9]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["3"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MX: [null, [null, null, "(?:1\\d|[2-9])\\d{9}", null, null, null, null, null, null, [10, 11], [7, 8]], [null, null, "(?:2(?:0[01]|2[1-9]|3[1-35-8]|4[13-9]|7[1-689]|8[1-578]|9[467])|3(?:1[1-79]|[2458][1-9]|3\\d|7[1-8]|9[1-5])|4(?:1[1-57-9]|[24-7][1-9]|3[1-8]|8[1-35-9]|9[2-689])|5(?:[56]\\d|88|9[1-79])|6(?:1[2-68]|[2-4][1-9]|5[1-3689]|6[1-57-9]|7[1-7]|8[67]|9[4-8])|7(?:[1-467][1-9]|5[13-9]|8[1-69]|9[17])|8(?:1\\d|2[13-689]|3[1-6]|4[124-6]|6[1246-9]|7[1-378]|9[12479])|9(?:1[346-9]|2[1-4]|3[2-46-8]|5[1348]|[69][1-9]|7[12]|8[1-8]))\\d{7}", null, null, null, "2221234567", null, null, [10], [7, 8]], [null, null, "1(?:2(?:2[1-9]|3[1-35-8]|4[13-9]|7[1-689]|8[1-578]|9[467])|3(?:1[1-79]|[2458][1-9]|3\\d|7[1-8]|9[1-5])|4(?:1[1-57-9]|[24-7][1-9]|3[1-8]|8[1-35-9]|9[2-689])|5(?:[56]\\d|88|9[1-79])|6(?:1[2-68]|[2-4][1-9]|5[1-3689]|6[1-57-9]|7[1-7]|8[67]|9[4-8])|7(?:[1-467][1-9]|5[13-9]|8[1-69]|9[17])|8(?:1\\d|2[13-689]|3[1-6]|4[124-6]|6[1246-9]|7[1-378]|9[12479])|9(?:1[346-9]|2[1-4]|3[2-46-8]|5[1348]|[69][1-9]|7[12]|8[1-8]))\\d{7}", null, null, null, "12221234567", null, null, [11]], [null, null, "8(?:00|88)\\d{7}", null, null, null, "8001234567", null, null, [10]], [null, null, "900\\d{7}", null, null, null, "9001234567", null, null, [10]], [null, null, "300\\d{7}", null, null, null, "3001234567", null, null, [10]], [null, null, "500\\d{7}", null, null, null, "5001234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], "MX", 52, "0[09]", "01", null, null, "0[12]|04[45]([2-9]\\d{9})$", "1$1", "00", null, [[null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["33|5[56]|81"], "01 $1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[2-9]"], "01 $1", null, 1], [null, "(\\d)(\\d{2})(\\d{4})(\\d{4})", "$2 $3 $4", ["1(?:33|5[56]|81)"], "044 $1"], [null, "(\\d)(\\d{3})(\\d{3})(\\d{4})", "$2 $3 $4", ["1"], "044 $1"]], [[null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["33|5[56]|81"], "01 $1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[2-9]"], "01 $1", null, 1], [null, "(\\d)(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3 $4", ["1(?:33|5[56]|81)"]], [null, "(\\d)(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3 $4", ["1"]]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MY: [null, [null, null, "(?:1\\d\\d?|3\\d|[4-9])\\d{7}", null, null, null, null, null, null, [8, 9, 10], [6, 7]], [null, null, "(?:3(?:2[0-36-9]|3[0-368]|4[0-278]|5[0-24-8]|6[0-467]|7[1246-9]|8\\d|9[0-57])\\d|4(?:2[0-689]|[3-79]\\d|8[1-35689])|5(?:2[0-589]|[3468]\\d|5[0-489]|7[1-9]|9[23])|6(?:2[2-9]|3[1357-9]|[46]\\d|5[0-6]|7[0-35-9]|85|9[015-8])|7(?:[2579]\\d|3[03-68]|4[0-8]|6[5-9]|8[0-35-9])|8(?:[24][2-8]|3[2-5]|5[2-7]|6[2-589]|7[2-578]|[89][2-9])|9(?:0[57]|13|[25-7]\\d|[3489][0-8]))\\d{5}", null, null, null, "323856789", null, null, [8, 9], [6, 7]], [null, null, "1(?:(?:0(?:[23568]\\d|4[0-6]|7[016-9]|9[0-8])|1(?:[1-5]\\d\\d|6(?:0[5-9]|[1-9]\\d))|(?:[23679][2-9]|59\\d)\\d)\\d|4(?:[235-9]\\d\\d|400)|8(?:(?:1[23]|[236]\\d|5[7-9]|7[016-9]|9[0-8])\\d|4(?:[06]\\d|7[0-4])|8(?:[01]\\d|[27][0-4])))\\d{4}", null, null, null, "123456789", null, null, [9, 10]], [null, null, "1[378]00\\d{6}", null, null, null, "1300123456", null, null, [10]], [null, null, "1600\\d{6}", null, null, null, "1600123456", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "154(?:6(?:0\\d|1[0-3])|8(?:[25]1|4[0189]|7[0-4679]))\\d{4}", null, null, null, "1546012345", null, null, [10]], "MY", 60, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{4})", "$1-$2 $3", ["[4-79]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1-$2 $3", ["1(?:[0249]|[367][2-9]|8[1-9])|8"], "0$1"], [null, "(\\d)(\\d{4})(\\d{4})", "$1-$2 $3", ["3"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1-$2 $3", ["15"], "0$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1-$2 $3", ["11"], "0$1"], [null, "(\\d)(\\d{3})(\\d{2})(\\d{4})", "$1-$2-$3-$4", ["1"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    MZ: [null, [null, null, "(?:2|8\\d)\\d{7}", null, null, null, null, null, null, [8, 9]], [null, null, "2(?:[1346]\\d|5[0-2]|[78][12]|93)\\d{5}", null, null, null, "21123456", null, null, [8]], [null, null, "8[2-7]\\d{7}", null, null, null, "821234567", null, null, [9]], [null, null, "800\\d{6}", null, null, null, "800123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "MZ", 258, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["2|8[2-7]"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    NA: [null, [null, null, "[68]\\d{7,8}", null, null, null, null, null, null, [8, 9]], [null, null, "6(?:1(?:[02-4]\\d\\d|17)|2(?:17|54\\d|69|70)|3(?:17|2[0237]\\d|34|6[289]|7[01]|81)|4(?:17|(?:27|41|5[25])\\d|69|7[01])|5(?:17|2[236-8]\\d|69|7[01])|6(?:17|26\\d|38|42|69|7[01])|7(?:17|(?:2[2-4]|30)\\d|6[89]|7[01]))\\d{4}|6(?:1(?:2[2-7]|3[01378]|4[0-4]|69|7[014])|25[0-46-8]|32\\d|4(?:2[0-27]|4[016]|5[0-357])|52[02-9]|62[56]|7(?:2[2-69]|3[013]))\\d{4}", null, null, null, "61221234"], [null, null, "(?:60|8[1245])\\d{7}", null, null, null, "811234567", null, null, [9]], [null, null, "80\\d{7}", null, null, null, "800123456", null, null, [9]], [null, null, "8701\\d{5}", null, null, null, "870123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "8(?:3\\d\\d|86)\\d{5}", null, null, null, "88612345"], "NA", 264, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["88"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["6"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["8[0-5]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    NC: [null, [null, null, "[2-57-9]\\d{5}", null, null, null, null, null, null, [6]], [null, null, "(?:2[03-9]|3[0-5]|4[1-7]|88)\\d{4}", null, null, null, "201234"], [null, null, "(?:5[0-4]|[79]\\d|8[0-79])\\d{4}", null, null, null, "751234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "36\\d{4}", null, null, null, "366711"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "NC", 687, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})", "$1.$2.$3", ["[247-9]|3[0-6]|5[0-4]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    NE: [null, [null, null, "[0289]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "2(?:0(?:20|3[1-7]|4[13-5]|5[14]|6[14578]|7[1-578])|1(?:4[145]|5[14]|6[14-68]|7[169]|88))\\d{4}", null, null, null, "20201234"], [null, null, "(?:8[04589]|9\\d)\\d{6}", null, null, null, "93123456"], [null, null, "08\\d{6}", null, null, null, "08123456"], [null, null, "09\\d{6}", null, null, null, "09123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "NE", 227, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["09|2[01]|8[04589]|9"]], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["0"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    NF: [null, [null, null, "[13]\\d{5}", null, null, null, null, null, null, [6], [5]], [null, null, "(?:1(?:06|17|28|39)|3[0-2]\\d)\\d{3}", null, null, null, "106609", null, null, null, [5]], [null, null, "3[58]\\d{4}", null, null, null, "381234", null, null, null, [5]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "NF", 672, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{4})", "$1 $2", ["1"]], [null, "(\\d)(\\d{5})", "$1 $2", ["3"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    NG: [null, [null, null, "[78]\\d{10,13}|[7-9]\\d{9}|[1-9]\\d{7}|[124-7]\\d{6}", null, null, null, null, null, null, [7, 8, 10, 11, 12, 13, 14], [5, 6]], [null, null, "(?:(?:[1-356]\\d|4[02-8]|7[0-79]|8[2-9])\\d|9(?:0[3-9]|[1-9]\\d))\\d{5}|(?:[12]\\d|4[147]|5[14579]|6[1578]|7[0-3578])\\d{5}", null, null, null, "18040123", null, null, [7, 8], [5, 6]], [null, null, "(?:1(?:(?:7[34]|95)\\d|8(?:04|[124579]\\d|8[0-3]))|287[0-7]|3(?:18[1-8]|88[0-7]|9(?:6[1-5]|8[5-9]))|4(?:[28]8[0-2]|6(?:7[1-9]|8[02-47]))|5(?:2(?:7[7-9]|8\\d)|38[1-79]|48[0-7]|68[4-7])|6(?:2(?:7[7-9]|8\\d)|4(?:3[7-9]|[68][129]|7[04-69]|9[1-8])|58[0-2]|98[7-9])|7(?:0(?:[1-689]\\d|7[0-3])\\d\\d|38[0-7]|69[1-8]|78[2-4])|8(?:(?:0(?:1[01]|[2-9]\\d)|1(?:[0-8]\\d|9[01]))\\d\\d|28[3-9]|38[0-2]|4(?:2[12]|3[147-9]|5[346]|7[4-9]|8[014-689]|90)|58[1-8]|78[2-9]|88[5-7])|9(?:0[235-9]\\d\\d|8[07])\\d)\\d{4}", null, null, null, "8021234567", null, null, [8, 10], [6, 7]], [null, null, "800\\d{7,11}", null, null, null, "80017591759", null, null, [10, 11, 12, 13, 14]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "NG", 234, "009", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3", ["78"], "0$1"], [null, "(\\d)(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[12]|9(?:0[3-9]|[1-9])"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2,3})", "$1 $2 $3", ["[3-7]|8[2-9]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[7-9]"], "0$1"], [null, "(\\d{3})(\\d{4})(\\d{4,5})", "$1 $2 $3", ["[78]"], "0$1"], [null, "(\\d{3})(\\d{5})(\\d{5,6})", "$1 $2 $3", ["[78]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "700\\d{7,11}", null, null, null, "7001234567", null, null, [10, 11, 12, 13, 14]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    NI: [null, [null, null, "(?:1800|[25-8]\\d{3})\\d{4}", null, null, null, null, null, null, [8]], [null, null, "2\\d{7}", null, null, null, "21234567"], [null, null, "(?:5(?:5[0-7]|[78]\\d)|6(?:20|3[035]|4[045]|5[05]|77|8[1-9]|9[059])|(?:7[5-8]|8\\d)\\d)\\d{5}", null, null, null, "81234567"], [null, null, "1800\\d{4}", null, null, null, "18001234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "NI", 505, "00", null, null, null, null, null, null, null, [[null, "(\\d{4})(\\d{4})", "$1 $2", ["[125-8]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    NL: [null, [null, null, "(?:[124-7]\\d\\d|3(?:[02-9]\\d|1[0-8])|[89]\\d{0,3})\\d{6}|1\\d{4,5}", null, null, null, null, null, null, [5, 6, 7, 8, 9, 10]], [null, null, "(?:1(?:[035]\\d|1[13-578]|6[124-8]|7[24]|8[0-467])|2(?:[0346]\\d|2[2-46-9]|5[125]|9[479])|3(?:[03568]\\d|1[3-8]|2[01]|4[1-8])|4(?:[0356]\\d|1[1-368]|7[58]|8[15-8]|9[23579])|5(?:[0358]\\d|[19][1-9]|2[1-57-9]|4[13-8]|6[126]|7[0-3578])|7\\d\\d)\\d{6}", null, null, null, "101234567", null, null, [9]], [null, null, "6[1-58]\\d{7}", null, null, null, "612345678", null, null, [9]], [null, null, "800\\d{4,7}", null, null, null, "8001234", null, null, [7, 8, 9, 10]], [null, null, "90[069]\\d{4,7}", null, null, null, "9061234", null, null, [7, 8, 9, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:85|91)\\d{7}", null, null, null, "851234567", null, null, [9]], "NL", 31, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3,4})", "$1 $2", ["14"]], [null, "(\\d{3})(\\d{4,7})", "$1 $2", ["[89]0"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["1[035]|2[0346]|3[03568]|4[0356]|5[0358]|[7-9]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[1-5]"], "0$1"], [null, "(\\d)(\\d{8})", "$1 $2", ["6[1-58]"], "0$1"], [null, "(\\d{2})(\\d{7})", "$1 $2", ["6"], "0$1"]], [[null, "(\\d{3})(\\d{4,7})", "$1 $2", ["[89]0"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["1[035]|2[0346]|3[03568]|4[0356]|5[0358]|[7-9]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[1-5]"], "0$1"], [null, "(\\d)(\\d{8})", "$1 $2", ["6[1-58]"], "0$1"], [null, "(\\d{2})(\\d{7})", "$1 $2", ["6"], "0$1"]], [null, null, "66\\d{7}", null, null, null, "662345678", null, null, [9]], null, null, [null, null, "140(?:1(?:[035]|[16-8]\\d)|2(?:[0346]|[259]\\d)|3(?:[03568]|[124]\\d)|4(?:[0356]|[17-9]\\d)|5(?:[0358]|[124679]\\d)|7\\d|8[458])", null, null, null, null, null, null, [5, 6]], [null, null, "140(?:1(?:[035]|[16-8]\\d)|2(?:[0346]|[259]\\d)|3(?:[03568]|[124]\\d)|4(?:[0356]|[17-9]\\d)|5(?:[0358]|[124679]\\d)|7\\d|8[458])|8[478]\\d{7}", null, null, null, "14020", null, null, [5, 6, 9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    NO: [null, [null, null, "(?:0|[2-9]\\d{3})\\d{4}", null, null, null, null, null, null, [5, 8]], [null, null, "(?:2[1-4]|3[1-3578]|5[1-35-7]|6[1-4679]|7[0-8])\\d{6}", null, null, null, "21234567", null, null, [8]], [null, null, "(?:4[015-8]|5[89]|9\\d)\\d{6}", null, null, null, "40612345", null, null, [8]], [null, null, "80[01]\\d{5}", null, null, null, "80012345", null, null, [8]], [null, null, "82[09]\\d{5}", null, null, null, "82012345", null, null, [8]], [null, null, "810(?:0[0-6]|[2-8]\\d)\\d{3}", null, null, null, "81021234", null, null, [8]], [null, null, "880\\d{5}", null, null, null, "88012345", null, null, [8]], [null, null, "85[0-5]\\d{5}", null, null, null, "85012345", null, null, [8]], "NO", 47, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[235-7]"]], [null, "(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["[489]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], 1, "[02-689]|7[0-8]", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:0\\d|81(?:0(?:0[7-9]|1\\d)|5\\d\\d))\\d{3}", null, null, null, "01234"], null, null, [null, null, "81[23]\\d{5}", null, null, null, "81212345", null, null, [8]]],
    NP: [null, [null, null, "9\\d{9}|[1-9]\\d{7}", null, null, null, null, null, null, [8, 10], [6, 7]], [null, null, "(?:1[0-6]\\d|(?:2[13-79]|3[135-8]|4[146-9]|5[135-7]|6[13-9]|7[15-9]|8[1-46-9]|9[1-79])[2-6])\\d{5}", null, null, null, "14567890", null, null, [8], [6, 7]], [null, null, "9(?:6[0-3]|7[245]|8[0-24-68])\\d{7}", null, null, null, "9841234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "NP", 977, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{7})", "$1-$2", ["1[2-6]"], "0$1"], [null, "(\\d{2})(\\d{6})", "$1-$2", ["[1-8]|9(?:[1-579]|6[2-6])"], "0$1"], [null, "(\\d{3})(\\d{7})", "$1-$2", ["9"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    NR: [null, [null, null, "(?:444|55\\d|888)\\d{4}", null, null, null, null, null, null, [7]], [null, null, "(?:444|888)\\d{4}", null, null, null, "4441234"], [null, null, "55[4-9]\\d{4}", null, null, null, "5551234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "NR", 674, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[458]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    NU: [null, [null, null, "(?:[47]|888\\d)\\d{3}", null, null, null, null, null, null, [4, 7]], [null, null, "[47]\\d{3}", null, null, null, "7012", null, null, [4]], [null, null, "888[4-9]\\d{3}", null, null, null, "8884012", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "NU", 683, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["8"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    NZ: [null, [null, null, "[28]\\d{7,9}|[346]\\d{7}|(?:508|[79]\\d)\\d{6,7}", null, null, null, null, null, null, [8, 9, 10], [7]], [null, null, "(?:24099|(?:3[2-79]|[49][2-9]|6[235-9]|7[2-57-9])\\d{3})\\d{3}", null, null, null, "32345678", null, null, [8], [7]], [null, null, "2(?:[0-28]\\d?|[79])\\d{7}|21\\d{6}", null, null, null, "211234567"], [null, null, "508\\d{6,7}|80\\d{6,8}", null, null, null, "800123456"], [null, null, "90\\d{6,7}", null, null, null, "900123456", null, null, [8, 9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "70\\d{7}", null, null, null, "701234567", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], "NZ", 64, "0(?:0|161)", "0", null, null, "0", null, "00", null, [[null, "(\\d)(\\d{3})(\\d{4})", "$1-$2 $3", ["24|[346]|7[2-57-9]|9[2-9]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["80|9"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["2(?:10|74)|[59]|80"], "0$1"], [null, "(\\d{2})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["2[028]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,5})", "$1 $2 $3", ["[278]"], "0$1"]], null, [null, null, "[28]6\\d{6,7}", null, null, null, "26123456", null, null, [8, 9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    OM: [null, [null, null, "(?:[279]\\d{3}|500|8007\\d?)\\d{4}", null, null, null, null, null, null, [7, 8, 9]], [null, null, "2[2-6]\\d{6}", null, null, null, "23123456", null, null, [8]], [null, null, "(?:7[129]\\d|9(?:0[1-9]|[1-9]\\d))\\d{5}", null, null, null, "92123456", null, null, [8]], [null, null, "(?:500|8007\\d?)\\d{4}", null, null, null, "80071234"], [null, null, "900\\d{5}", null, null, null, "90012345", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "OM", 968, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4,6})", "$1 $2", ["[58]"]], [null, "(\\d{2})(\\d{6})", "$1 $2", ["2"]], [null, "(\\d{4})(\\d{4})", "$1 $2", ["[79]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    PA: [null, [null, null, "(?:[1-57-9]|6\\d)\\d{6}", null, null, null, null, null, null, [7, 8]], [null, null, "(?:1(?:0\\d|1[479]|2[37]|3[0137]|4[17]|5[05]|[68][58]|7[0167]|9[39])|2(?:[0235-79]\\d|1[0-7]|4[013-9]|8[026-9])|3(?:[089]\\d|1[014-7]|2[0-35]|33|4[0-579]|55|6[068]|7[06-8])|4(?:00|3[0-579]|4\\d|7[0-57-9])|5(?:[01]\\d|2[0-7]|[56]0|79)|7(?:0[09]|2[0-26-8]|3[03]|4[04]|5[05-9]|6[05]|7[0-24-9]|8[7-9]|90)|8(?:09|2[89]|3\\d|4[0-24-689]|5[014]|8[02])|9(?:0[5-9]|1[0135-8]|2[036-9]|3[35-79]|40|5[0457-9]|6[05-9]|7[04-9]|8[35-8]|9\\d))\\d{4}", null, null, null, "2001234", null, null, [7]], [null, null, "(?:1[16]1|21[89]|6(?:[02-9]\\d|1[0-5])\\d|8(?:1[01]|7[23]))\\d{4}", null, null, null, "61234567"], [null, null, "800\\d{4}", null, null, null, "8001234", null, null, [7]], [null, null, "(?:8(?:22|55|60|7[78]|86)|9(?:00|81))\\d{4}", null, null, null, "8601234", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "PA", 507, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1-$2", ["[1-57-9]"]], [null, "(\\d{4})(\\d{4})", "$1-$2", ["6"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    PE: [null, [null, null, "(?:[14-8]|9\\d)\\d{7}", null, null, null, null, null, null, [8, 9], [6, 7]], [null, null, "(?:1\\d|4[1-4]|5[1-46]|6[1-7]|7[2-46]|8[2-4])\\d{6}", null, null, null, "11234567", null, null, [8], [6, 7]], [null, null, "9\\d{8}", null, null, null, "912345678", null, null, [9]], [null, null, "800\\d{5}", null, null, null, "80012345", null, null, [8]], [null, null, "805\\d{5}", null, null, null, "80512345", null, null, [8]], [null, null, "801\\d{5}", null, null, null, "80112345", null, null, [8]], [null, null, "80[24]\\d{5}", null, null, null, "80212345", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], "PE", 51, "19(?:1[124]|77|90)00", "0", " Anexo ", null, "0", null, null, null, [[null, "(\\d)(\\d{7})", "$1 $2", ["1"], "(0$1)"], [null, "(\\d{2})(\\d{6})", "$1 $2", ["[4-7]|8[2-4]"], "(0$1)"], [null, "(\\d{3})(\\d{5})", "$1 $2", ["8"], "(0$1)"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["9"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    PF: [null, [null, null, "[48]\\d{7}|4\\d{5}", null, null, null, null, null, null, [6, 8]], [null, null, "4(?:[09][4-689]\\d|4)\\d{4}", null, null, null, "40412345"], [null, null, "8[79]\\d{6}", null, null, null, "87123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "PF", 689, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3", ["44"]], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[48]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "44\\d{4}", null, null, null, null, null, null, [6]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    PG: [null, [null, null, "(?:180|[78]\\d{3})\\d{4}|(?:[2-589]\\d|64)\\d{5}", null, null, null, null, null, null, [7, 8]], [null, null, "(?:(?:3[0-2]|4[257]|5[34]|9[78])\\d|64[1-9]|77(?:[0-24]\\d|30)|85[02-46-9])\\d{4}", null, null, null, "3123456"], [null, null, "(?:7(?:[0-689]\\d|75)|81\\d)\\d{5}", null, null, null, "70123456", null, null, [8]], [null, null, "180\\d{4}", null, null, null, "1801234", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "2(?:0[0-47]|7[568])\\d{4}", null, null, null, "2751234", null, null, [7]], "PG", 675, "00|140[1-3]", null, null, null, null, null, "00", null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["18|[2-69]|85"]], [null, "(\\d{4})(\\d{4})", "$1 $2", ["[78]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    PH: [null, [null, null, "(?:1800\\d{2,4}|2|[89]\\d{4})\\d{5}|[3-8]\\d{8}|[28]\\d{7}", null, null, null, null, null, null, [6, 8, 9, 10, 11, 12, 13], [4, 5, 7]], [null, null, "(?:2\\d(?:\\d{2})?|(?:3[2-68]|4[2-9]|5[2-6]|6[2-58]|7[24578])\\d{3}|88(?:22\\d\\d|42))\\d{4}|8[2-8]\\d{7}", null, null, null, "21234567", null, null, [6, 8, 9, 10], [4, 5, 7]], [null, null, "(?:81[37]|9(?:0[5-9]|1[024-9]|2[0-35-9]|3[02-9]|4[235-9]|5[056]|6[5-7]|7[3-79]|89|9[4-9]))\\d{7}", null, null, null, "9051234567", null, null, [10]], [null, null, "1800\\d{7,9}", null, null, null, "180012345678", null, null, [11, 12, 13]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "PH", 63, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{5})", "$1 $2", ["2"], "(0$1)"], [null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["2"], "(0$1)"], [null, "(\\d{4})(\\d{4,6})", "$1 $2", ["3(?:23|39|46)|4(?:2[3-6]|[35]9|4[26]|76)|5(?:22|44)|642|8(?:62|8[245])", "3(?:230|397|461)|4(?:2(?:35|[46]4|51)|396|4(?:22|63)|59[347]|76[15])|5(?:221|446)|642[23]|8(?:622|8(?:[24]2|5[13]))"], "(0$1)"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["3[2-68]|4[2-9]|[5-7]|8[2-8]", "3(?:[23568]|4(?:[0-57-9]|6[02-8]))|4(?:2(?:[0-689]|7[0-8])|[3-8]|9(?:[0-246-9]|3[1-9]|5[0-57-9]))|[5-7]|8(?:[2-7]|8(?:[0-24-9]|3[0-35-9]))"], "(0$1)"], [null, "(\\d{5})(\\d{4})", "$1 $2", ["[34]|88"], "(0$1)"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[89]"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"]], [null, "(\\d{4})(\\d{1,2})(\\d{3})(\\d{4})", "$1 $2 $3 $4", ["1"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    PK: [null, [null, null, "(?:122|[24-8]\\d{4,5}|9(?:[013-9]\\d{2,4}|2(?:[01]\\d\\d|2(?:[025-8]\\d|1[01]))\\d))\\d{6}|(?:[2-8]\\d{3}|92(?:[0-7]\\d|8[1-9]))\\d{6}|[24-9]\\d{8}|[89]\\d{7}", null, null, null, null, null, null, [8, 9, 10, 11, 12], [5, 6, 7]], [null, null, "2(?:(?:1[2-9]\\d|[25][2-9])\\d{6}|(?:3[2358]|4[2-4]|9[2-8])[2-9]\\d{5,6})|4(?:(?:[0146-9][2-9]|2[2-9]\\d)\\d{6}|5[3479][2-9]\\d{5,6})|5(?:(?:[1-35-7][2-9]|8[126]\\d)\\d{6}|4[2-467][2-9]\\d{5,6})|6(?:0[468][2-9]\\d{5,6}|[1-8][2-9]\\d{6})|7(?:[14][2-9]\\d{6}|2[236][2-9]\\d{5,6})|8(?:[16][2-9]\\d{6}|(?:2[2-689]|3[23578]|4[3478]|5[2356])[2-9]\\d{5,6})|9(?:1[2-9]\\d{6}|(?:2[2-8]|3[27-9]|4[2-6]|6[3569]|9[25-8])[2-9]\\d{5,6})", null, null, null, "2123456789", null, null, [9, 10], [5, 6, 7, 8]], [null, null, "3(?:[014]\\d|2[0-5]|3[0-7]|55|64)\\d{7}", null, null, null, "3012345678", null, null, [10]], [null, null, "800\\d{5}", null, null, null, "80012345", null, null, [8]], [null, null, "900\\d{5}", null, null, null, "90012345", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "122\\d{6}", null, null, null, "122044444", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], "PK", 92, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{2})", "$1 $2 $3", ["[89]0"], "0$1"], [null, "(\\d{4})(\\d{5})", "$1 $2", ["1"]], [null, "(\\d{2})(\\d{7,8})", "$1 $2", ["(?:2[125]|4[0-246-9]|5[1-35-7]|6[1-8]|7[14]|8[16]|91)[2-9]"], "(0$1)"], [null, "(\\d{3})(\\d{6,7})", "$1 $2", ["2(?:3[2358]|4[2-4]|9[2-8])|45[3479]|54[2-467]|60[468]|72[236]|8(?:2[2-689]|3[23578]|4[3478]|5[2356])|9(?:2[2-8]|3[27-9]|4[2-6]|6[3569]|9[25-8])", "(?:2(?:3[2358]|4[2-4]|9[2-8])|45[3479]|54[2-467]|60[468]|72[236]|8(?:2[2-689]|3[23578]|4[3478]|5[2356]))[2-9]|9(?:2(?:2[2-9]|[3-8])|(?:3[27-9]|4[2-6]|6[3569])[2-9]|9(?:[25-7][2-9]|8))"], "(0$1)"], [null, "(\\d{5})(\\d{5})", "$1 $2", ["58"], "(0$1)"], [null, "(\\d{3})(\\d{7})", "$1 $2", ["3"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["2[125]|4[0-246-9]|5[1-35-7]|6[1-8]|7[14]|8[16]|91"], "(0$1)"], [null, "(\\d{3})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["[24-9]"], "(0$1)"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:2(?:[125]|3[2358]|4[2-4]|9[2-8])|4(?:[0-246-9]|5[3479])|5(?:[1-35-7]|4[2-467])|6(?:0[468]|[1-8])|7(?:[14]|2[236])|8(?:[16]|2[2-689]|3[23578]|4[3478]|5[2356])|9(?:1|22|3[27-9]|4[2-6]|6[3569]|9[2-7]))111\\d{6}", null, null, null, "21111825888", null, null, [11, 12]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    PL: [null, [null, null, "[1-9]\\d{6}(?:\\d{2})?|6\\d{5}(?:\\d{2})?", null, null, null, null, null, null, [6, 7, 8, 9]], [null, null, "(?:1[2-8]|2[2-69]|3[2-4]|4[1-468]|5[24-689]|6[1-3578]|7[14-7]|8[1-79]|9[145])\\d{7}|(?:1[2-8]|2[2-69]|3[2-4]|4[1-468]|5[24-689]|6[1-3578]|7[14-7]|8[1-79]|9[145])19\\d{3}", null, null, null, "123456789", null, null, [7, 9]], [null, null, "(?:45|5[0137]|6[069]|7[2389]|88)\\d{7}", null, null, null, "512345678", null, null, [9]], [null, null, "800\\d{6}", null, null, null, "800123456", null, null, [9]], [null, null, "70[01346-8]\\d{6}", null, null, null, "701234567", null, null, [9]], [null, null, "801\\d{6}", null, null, null, "801234567", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "39\\d{7}", null, null, null, "391234567", null, null, [9]], "PL", 48, "00", null, null, null, null, null, null, null, [[null, "(\\d{5})", "$1", ["19"]], [null, "(\\d{3})(\\d{3})", "$1 $2", ["11|64"]], [null, "(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3", ["(?:1[2-8]|2[2-69]|3[2-4]|4[1-468]|5[24-689]|6[1-3578]|7[14-7]|8[1-79]|9[145])1", "(?:1[2-8]|2[2-69]|3[2-4]|4[1-468]|5[24-689]|6[1-3578]|7[14-7]|8[1-79]|9[145])19"]], [null, "(\\d{3})(\\d{2})(\\d{2,3})", "$1 $2 $3", ["64"]], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["1[2-8]|2|3[2-4]|4[1-468]|5[24-689]|6[1-3578]|7[14-7]|8[1-79]|9[145]"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[3-8]"]]], null, [null, null, "64\\d{4,7}", null, null, null, "641234567"], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "804\\d{6}", null, null, null, "804123456", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    PM: [null, [null, null, "[45]\\d{5}", null, null, null, null, null, null, [6]], [null, null, "(?:4[1-3]|50)\\d{4}", null, null, null, "430123"], [null, null, "(?:4[02-4]|5[05])\\d{4}", null, null, null, "551234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "PM", 508, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3", ["[45]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    PR: [null, [null, null, "(?:[589]\\d\\d|787)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "(?:787|939)[2-9]\\d{6}", null, null, null, "7872345678", null, null, null, [7]], [null, null, "(?:787|939)[2-9]\\d{6}", null, null, null, "7872345678", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002345678"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002345678"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "PR", 1, "011", "1", null, null, "1", null, null, 1, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "787|939", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    PS: [null, [null, null, "(?:(?:1\\d|5)\\d\\d|[2489]2)\\d{6}", null, null, null, null, null, null, [8, 9, 10], [7]], [null, null, "(?:22[2-47-9]|42[45]|82[01458]|92[369])\\d{5}", null, null, null, "22234567", null, null, [8], [7]], [null, null, "5[69]\\d{7}", null, null, null, "599123456", null, null, [9]], [null, null, "1800\\d{6}", null, null, null, "1800123456", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "1700\\d{6}", null, null, null, "1700123456", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "PS", 970, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["[2489]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["5"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    PT: [null, [null, null, "(?:[26-9]\\d|30)\\d{7}", null, null, null, null, null, null, [9]], [null, null, "2(?:[12]\\d|[35][1-689]|4[1-59]|6[1-35689]|7[1-9]|8[1-69]|9[1256])\\d{6}", null, null, null, "212345678"], [null, null, "9(?:[1-36]\\d\\d|480)\\d{5}", null, null, null, "912345678"], [null, null, "80[02]\\d{6}", null, null, null, "800123456"], [null, null, "(?:6(?:0[178]|4[68])\\d|76(?:0[1-57]|1[2-47]|2[237]))\\d{5}", null, null, null, "760123456"], [null, null, "80(?:8\\d|9[1579])\\d{5}", null, null, null, "808123456"], [null, null, "884[0-4689]\\d{5}", null, null, null, "884123456"], [null, null, "30\\d{7}", null, null, null, "301234567"], "PT", 351, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["2[12]"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[236-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "70(?:7\\d|8[17])\\d{5}", null, null, null, "707123456"], null, null, [null, null, "600\\d{6}", null, null, null, "600110000"]],
    PW: [null, [null, null, "(?:[25-8]\\d\\d|345|488|900)\\d{4}", null, null, null, null, null, null, [7]], [null, null, "(?:2(?:55|77)|345|488|5(?:35|44|87)|6(?:22|54|79)|7(?:33|47)|8(?:24|55|76)|900)\\d{4}", null, null, null, "2771234"], [null, null, "(?:6[2-4689]0|77\\d|88[0-4])\\d{4}", null, null, null, "6201234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "PW", 680, "01[12]", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[2-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    PY: [null, [null, null, "(?:[2-46-9]\\d|5[0-8])\\d{7}|[2-9]\\d{5,7}", null, null, null, null, null, null, [6, 7, 8, 9], [5]], [null, null, "(?:2(?:1\\d|2[4-68]|7[15]|9[1-5])|5(?:[1-4]\\d|5[02-4])|6(?:1\\d|3[1-3]|44|7[1-46-8]))\\d{5,6}|3(?:(?:18|3[167]|4[2357]|51)\\d{5,6}|[289]\\d{5,7})|4(?:[1246-8]\\d{5,7}|(?:3[12]|5[13]|9[1-47])\\d{5,6})|7(?:[1-3]\\d{5,7}|(?:4[0-4]|6[1-578]|75|8[0-8])\\d{5,6})|8(?:[1-36]\\d{5,7}|58\\d{5,6})|[26]1\\d{5}", null, null, null, "212345678", null, null, [7, 8, 9], [5, 6]], [null, null, "9(?:51|6[129]|[78][1-6]|9[1-5])\\d{6}", null, null, null, "961456789", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "8700[0-4]\\d{4}", null, null, null, "870012345", null, null, [9]], "PY", 595, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{3,6})", "$1 $2", ["[2-9]0"], "0$1"], [null, "(\\d{2})(\\d{5})", "$1 $2", ["[26]1|3[289]|4[1246-8]|7[1-3]|8[1-36]"], "(0$1)"], [null, "(\\d{3})(\\d{4,5})", "$1 $2", ["2[279]|3[13-5]|4[359]|5|6[347]|7[46-8]|85"], "(0$1)"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[26]1|3[289]|4[1246-8]|7[1-3]|8[1-36]"], "(0$1)"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[2-7]|85"], "0$1"], [null, "(\\d{3})(\\d{6})", "$1 $2", ["9"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["8"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "[2-9]0\\d{4,7}", null, null, null, "201234567"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    QA: [null, [null, null, "(?:(?:2|[3-7]\\d)\\d\\d|800)\\d{4}", null, null, null, null, null, null, [7, 8]], [null, null, "4[04]\\d{6}", null, null, null, "44123456", null, null, [8]], [null, null, "[35-7]\\d{7}", null, null, null, "33123456", null, null, [8]], [null, null, "800\\d{4}", null, null, null, "8001234", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "QA", 974, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["2[126]|8"]], [null, "(\\d{4})(\\d{4})", "$1 $2", ["[3-7]"]]], null, [null, null, "2(?:[12]\\d|61)\\d{4}", null, null, null, "2123456", null, null, [7]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    RE: [null, [null, null, "(?:26|[68]\\d)\\d{7}", null, null, null, null, null, null, [9]], [null, null, "262\\d{6}", null, null, null, "262161234"], [null, null, "69(?:2\\d\\d|3(?:0[0-46]|1[013]|2[0-2]|3[0-39]|4\\d|5[05]|6[0-26]|7[0-27]|8[0-38]|9[0-479]))\\d{4}", null, null, null, "692123456"], [null, null, "80\\d{7}", null, null, null, "801234567"], [null, null, "89[1-37-9]\\d{6}", null, null, null, "891123456"], [null, null, "8(?:1[019]|2[0156]|84|90)\\d{6}", null, null, null, "810123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "RE", 262, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[268]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], 1, "262|69|8", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    RO: [null, [null, null, "(?:[237]\\d|[89]0)\\d{7}|[23]\\d{5}", null, null, null, null, null, null, [6, 9]], [null, null, "[23][13-6]\\d{7}|(?:2(?:19\\d|[3-6]\\d9)|31\\d\\d)\\d\\d", null, null, null, "211234567"], [null, null, "7(?:(?:[02-7]\\d|8[03-8]|99)\\d|1(?:[01]\\d|20))\\d{5}", null, null, null, "712034567", null, null, [9]], [null, null, "800\\d{6}", null, null, null, "800123456", null, null, [9]], [null, null, "90[036]\\d{6}", null, null, null, "900123456", null, null, [9]], [null, null, "801\\d{6}", null, null, null, "801123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "RO", 40, "00", "0", " int ", null, "0", null, null, null, [[null, "(\\d{2})(\\d{4})", "$1 $2", ["219|31"], "0$1"], [null, "(\\d{3})(\\d{3})", "$1 $2", ["2[3-6]", "2[3-6]\\d9"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[23]1"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[237-9]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "37\\d{7}", null, null, null, "372123456", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    RS: [null, [null, null, "[127]\\d{6,11}|3(?:[0-79]\\d{5,10}|8(?:[02-9]\\d{4,9}|1\\d{4,5}))|6\\d{7,9}|800\\d{3,9}|90\\d{4,8}|7\\d{5}", null, null, null, null, null, null, [6, 7, 8, 9, 10, 11, 12], [4, 5]], [null, null, "(?:1(?:[02-9][2-9]|1[1-9])\\d|2(?:[0-24-7][2-9]\\d|[389](?:0[2-9]|[2-9]\\d))|3(?:[0-8][2-9]\\d|9(?:0[2-9]|[2-9]\\d)))\\d{3,8}", null, null, null, "10234567", null, null, [7, 8, 9, 10, 11, 12], [4, 5, 6]], [null, null, "6(?:[0-689]|7\\d)\\d{6,7}", null, null, null, "601234567", null, null, [8, 9, 10]], [null, null, "800\\d{3,9}", null, null, null, "80012345"], [null, null, "(?:78\\d|90[0169])\\d{3,7}", null, null, null, "90012345", null, null, [6, 7, 8, 9, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "RS", 381, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{3,9})", "$1 $2", ["(?:2[389]|39)0|[7-9]"], "0$1"], [null, "(\\d{2})(\\d{5,10})", "$1 $2", ["[1-36]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "7[06]\\d{4,10}", null, null, null, "700123456"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    RU: [null, [null, null, "[347-9]\\d{9}", null, null, null, null, null, null, [10], [7]], [null, null, "(?:3(?:0[12]|4[1-35-79]|5[1-3]|65|8[1-58]|9[0145])|4(?:01|1[1356]|2[13467]|7[1-5]|8[1-7]|9[1-689])|8(?:1[1-8]|2[01]|3[13-6]|4[0-8]|5[15]|6[1-35-79]|7[1-37-9]))\\d{7}", null, null, null, "3011234567", null, null, null, [7]], [null, null, "9\\d{9}", null, null, null, "9123456789"], [null, null, "80[04]\\d{7}", null, null, null, "8001234567"], [null, null, "80[39]\\d{7}", null, null, null, "8091234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "808\\d{7}", null, null, null, "8081234567"], [null, null, null, null, null, null, null, null, null, [-1]], "RU", 7, "810", "8", null, null, "8", null, "8~10", null, [[null, "(\\d{3})(\\d{2})(\\d{2})", "$1-$2-$3"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["7"], "8 ($1)", null, 1], [null, "(\\d{3})(\\d{3})(\\d{2})(\\d{2})", "$1 $2-$3-$4", ["[3489]"], "8 ($1)", null, 1]], [[null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["7"], "8 ($1)", null, 1], [null, "(\\d{3})(\\d{3})(\\d{2})(\\d{2})", "$1 $2-$3-$4", ["[3489]"], "8 ($1)", null, 1]], [null, null, null, null, null, null, null, null, null, [-1]], 1, "3[04-689]|[489]", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    RW: [null, [null, null, "(?:06|[27]\\d\\d|[89]00)\\d{6}", null, null, null, null, null, null, [8, 9]], [null, null, "(?:06|2[258]\\d)\\d{6}", null, null, null, "250123456"], [null, null, "7[238]\\d{7}", null, null, null, "720123456", null, null, [9]], [null, null, "800\\d{6}", null, null, null, "800123456", null, null, [9]], [null, null, "900\\d{6}", null, null, null, "900123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "RW", 250, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["0"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["2"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[7-9]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    SA: [null, [null, null, "(?:(?:[15]|8\\d)\\d|92)\\d{7}", null, null, null, null, null, null, [9, 10], [7]], [null, null, "1(?:1\\d|2[24-8]|3[35-8]|4[3-68]|6[2-5]|7[235-7])\\d{6}", null, null, null, "112345678", null, null, [9], [7]], [null, null, "5(?:[013-689]\\d|7[0-36-8])\\d{6}", null, null, null, "512345678", null, null, [9]], [null, null, "800\\d{7}", null, null, null, "8001234567", null, null, [10]], [null, null, "925\\d{6}", null, null, null, "925012345", null, null, [9]], [null, null, "920\\d{6}", null, null, null, "920012345", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "SA", 966, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["5"], "0$1"], [null, "(\\d{4})(\\d{5})", "$1 $2", ["9"]], [null, "(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["81"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["8"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "811\\d{7}", null, null, null, "8110123456", null, null, [10]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    SB: [null, [null, null, "(?:[1-6]|[7-9]\\d\\d)\\d{4}", null, null, null, null, null, null, [5, 7]], [null, null, "(?:1[4-79]|[23]\\d|4[0-2]|5[03]|6[0-37])\\d{3}", null, null, null, "40123", null, null, [5]], [null, null, "(?:48|(?:(?:7[1-9]|8[4-9])\\d|9(?:1[2-9]|2[013-9]|3[0-2]|[46]\\d|5[0-46-9]|7[0-689]|8[0-79]|9[0-8]))\\d)\\d{3}", null, null, null, "7421234"], [null, null, "1[38]\\d{3}", null, null, null, "18123", null, null, [5]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5[12]\\d{3}", null, null, null, "51123", null, null, [5]], "SB", 677, "0[01]", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{5})", "$1 $2", ["7[1-9]|8[4-9]|9(?:1[2-9]|2[013-9]|3[0-2]|[46]|5[0-46-9]|7[0-689]|8[0-79]|9[0-8])"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    SC: [null, [null, null, "(?:(?:(?:[24]\\d|64)\\d|971)\\d|8000)\\d{3}", null, null, null, null, null, null, [7]], [null, null, "4[2-46]\\d{5}", null, null, null, "4217123"], [null, null, "2[5-8]\\d{5}", null, null, null, "2510123"], [null, null, "8000\\d{3}", null, null, null, "8000000"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:64\\d|971)\\d{4}", null, null, null, "6412345"], "SC", 248, "0(?:[02]|10?)", null, null, null, null, null, "00", null, [[null, "(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["[246]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    SD: [null, [null, null, "[19]\\d{8}", null, null, null, null, null, null, [9]], [null, null, "1(?:5\\d|8[35-7])\\d{6}", null, null, null, "151231234"], [null, null, "(?:1[0-2]|9[0-3569])\\d{7}", null, null, null, "911231234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "SD", 249, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[19]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    SE: [null, [null, null, "(?:[26]\\d\\d|9)\\d{9}|[1-9]\\d{8}|[1-689]\\d{7}|[1-4689]\\d{6}|2\\d{5}", null, null, null, null, null, null, [6, 7, 8, 9, 10, 12]], [null, null, "1(?:0[1-8]\\d{6}|(?:[13689]\\d|2[0-35]|4[0-4]|5[0-25-9]|7[13-6])\\d{5,6})|(?:2(?:[136]\\d|2[0-7]|4[0136-8]|5[0138]|7[018]|8[01]|9[0-57])|3(?:0[0-4]|[1356]\\d|2[0-25]|4[056]|7[0-2]|8[0-3]|9[023])|5(?:0[0-6]|[15][0-5]|2[0-68]|3[0-4]|4\\d|6[03-5]|7[013]|8[0-79]|9[01]))\\d{5,6}|4(?:[0246]\\d{5,7}|(?:1[013-8]|3[0135]|5[14-79]|7[0-246-9]|8[0156]|9[0-689])\\d{5,6})|6(?:[03]\\d{5,7}|(?:1[1-3]|2[0-4]|4[02-57]|5[0-37]|6[0-3]|7[0-2]|8[0247]|9[0-356])\\d{5,6})|8\\d{6,8}|9(?:0[1-9]\\d{4,6}|(?:1[0-68]|2\\d|3[02-5]|4[0-3]|5[0-4]|[68][01]|7[0135-8])\\d{5,6})|(?:[12][136]|3[356])\\d{5}", null, null, null, "8123456", null, null, [7, 8, 9]], [null, null, "7[02369]\\d{7}", null, null, null, "701234567", null, null, [9]], [null, null, "20\\d{4,7}", null, null, null, "20123456", null, null, [6, 7, 8, 9]], [null, null, "649\\d{6}|9(?:00|39|44)[1-8]\\d{3,6}", null, null, null, "9001234567", null, null, [7, 8, 9, 10]], [null, null, "77[0-7]\\d{6}", null, null, null, "771234567", null, null, [9]], [null, null, "75[1-8]\\d{6}", null, null, null, "751234567", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], "SE", 46, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{2,3})(\\d{2})", "$1-$2 $3", ["20"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2})", "$1-$2 $3", ["[12][136]|3[356]|4[0246]|6[03]|90[1-9]"], "0$1"], [null, "(\\d{3})(\\d{4})", "$1-$2", ["9(?:00|39|44)"], "0$1"], [null, "(\\d)(\\d{2,3})(\\d{2})(\\d{2})", "$1-$2 $3 $4", ["8"], "0$1"], [null, "(\\d{3})(\\d{2,3})(\\d{2})", "$1-$2 $3", ["1[2457]|2(?:[247-9]|5[0138])|3[0247-9]|4[1357-9]|5[0-35-9]|6(?:[125689]|4[02-57]|7[0-2])|9(?:[125-8]|3[02-5]|4[0-3])"], "0$1"], [null, "(\\d{2})(\\d{2,3})(\\d{2})(\\d{2})", "$1-$2 $3 $4", ["1[013689]|2[0136]|3[1356]|4[0246]|54|6[03]|90[1-9]"], "0$1"], [null, "(\\d{3})(\\d{2,3})(\\d{3})", "$1-$2 $3", ["9(?:0|39|44)"], "0$1"], [null, "(\\d)(\\d{3})(\\d{3})(\\d{2})", "$1-$2 $3 $4", ["8"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1-$2 $3 $4", ["[13-5]|2(?:[247-9]|5[0138])|6(?:[124-689]|7[0-2])|9(?:[125-8]|3[02-5]|4[0-3])"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1-$2 $3 $4", ["7"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{3})", "$1-$2 $3 $4", ["9"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1-$2 $3 $4 $5", ["[26]"], "0$1"]], [[null, "(\\d{2})(\\d{2,3})(\\d{2})", "$1 $2 $3", ["20"]], [null, "(\\d{2})(\\d{3})(\\d{2})", "$1 $2 $3", ["[12][136]|3[356]|4[0246]|6[03]|90[1-9]"]], [null, "(\\d{3})(\\d{4})", "$1 $2", ["9(?:00|39|44)"]], [null, "(\\d)(\\d{2,3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["8"]], [null, "(\\d{3})(\\d{2,3})(\\d{2})", "$1 $2 $3", ["1[2457]|2(?:[247-9]|5[0138])|3[0247-9]|4[1357-9]|5[0-35-9]|6(?:[125689]|4[02-57]|7[0-2])|9(?:[125-8]|3[02-5]|4[0-3])"]], [null, "(\\d{2})(\\d{2,3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["1[013689]|2[0136]|3[1356]|4[0246]|54|6[03]|90[1-9]"]], [null, "(\\d{3})(\\d{2,3})(\\d{3})", "$1 $2 $3", ["9(?:0|39|44)"]], [null, "(\\d)(\\d{3})(\\d{3})(\\d{2})", "$1 $2 $3 $4", ["8"]], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[13-5]|2(?:[247-9]|5[0138])|6(?:[124-689]|7[0-2])|9(?:[125-8]|3[02-5]|4[0-3])"]], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["7"]], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["9"]], [null, "(\\d{3})(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["[26]"]]], [null, null, "74[02-9]\\d{6}", null, null, null, "740123456", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "(?:25[245]|67[3-68])\\d{9}", null, null, null, "254123456789", null, null, [12]]],
    SG: [null, [null, null, "(?:1\\d{3}|[369]|7000|8(?:\\d{2})?)\\d{7}", null, null, null, null, null, null, [8, 10, 11]], [null, null, "6[1-9]\\d{6}", null, null, null, "61234567", null, null, [8]], [null, null, "(?:8[1-8]|9[0-8])\\d{6}", null, null, null, "81234567", null, null, [8]], [null, null, "(?:18|8)00\\d{7}", null, null, null, "18001234567", null, null, [10, 11]], [null, null, "1900\\d{7}", null, null, null, "19001234567", null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "3[12]\\d{6}", null, null, null, "31234567", null, null, [8]], "SG", 65, "0[0-3]\\d", null, null, null, null, null, null, null, [[null, "(\\d{4})(\\d{4})", "$1 $2", ["[369]|8[1-8]"]], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["8"]], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["1[89]"]], [null, "(\\d{4})(\\d{4})(\\d{3})", "$1 $2 $3", ["70"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "7000\\d{7}", null, null, null, "70001234567", null, null, [11]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    SH: [null, [null, null, "(?:[256]\\d|8)\\d{3}", null, null, null, null, null, null, [4, 5]], [null, null, "2(?:[0-57-9]\\d|6[4-9])\\d\\d", null, null, null, "22158"], [null, null, "[56]\\d{4}", null, null, null, "51234", null, null, [5]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "262\\d\\d", null, null, null, "26212", null, null, [5]], "SH", 290, "00", null, null, null, null, null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], 1, "[256]", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    SI: [null, [null, null, "[1-8]\\d{7}|90\\d{4,6}|8\\d{4,6}", null, null, null, null, null, null, [5, 6, 7, 8]], [null, null, "(?:[1-357][2-8]|4[24-8])\\d{6}", null, null, null, "12345678", null, null, [8], [7]], [null, null, "(?:(?:[37][01]|4[0139]|51)\\d\\d|6(?:[48]\\d\\d|5(?:1\\d|55|[67]0)|9(?:10|[69]\\d)))\\d{4}", null, null, null, "31234567", null, null, [8]], [null, null, "80\\d{4,6}", null, null, null, "80123456", null, null, [6, 7, 8]], [null, null, "89[1-3]\\d{2,5}|90\\d{4,6}", null, null, null, "90123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:59\\d\\d|8(?:1(?:[67]\\d|8[01389])|2(?:0\\d|2[0378]|8[0-2489])|3[389]\\d))\\d{4}", null, null, null, "59012345", null, null, [8]], "SI", 386, "00|10(?:22|66|88|99)", "0", null, null, "0", null, "00", null, [[null, "(\\d{2})(\\d{3,6})", "$1 $2", ["8[09]|9"], "0$1"], [null, "(\\d)(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[12]|[357][2-8]|4[24-8]"], "(0$1)"], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[3467]|51"], "0$1"], [null, "(\\d{3})(\\d{5})", "$1 $2", ["[58]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    SJ: [null, [null, null, "(?:0|(?:[4589]\\d|79)\\d\\d)\\d{4}", null, null, null, null, null, null, [5, 8]], [null, null, "79\\d{6}", null, null, null, "79123456", null, null, [8]], [null, null, "(?:4[015-8]|5[89]|9\\d)\\d{6}", null, null, null, "41234567", null, null, [8]], [null, null, "80[01]\\d{5}", null, null, null, "80012345", null, null, [8]], [null, null, "82[09]\\d{5}", null, null, null, "82012345", null, null, [8]], [null, null, "810(?:0[0-6]|[2-8]\\d)\\d{3}", null, null, null, "81021234", null, null, [8]], [null, null, "880\\d{5}", null, null, null, "88012345", null, null, [8]], [null, null, "85[0-5]\\d{5}", null, null, null, "85012345", null, null, [8]], "SJ", 47, "00", null, null, null, null, null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "79", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:0\\d|81(?:0(?:0[7-9]|1\\d)|5\\d\\d))\\d{3}", null, null, null, "01234"], null, null, [null, null, "81[23]\\d{5}", null, null, null, "81212345", null, null, [8]]],
    SK: [null, [null, null, "[2-689]\\d{8}|[2-59]\\d{6}|[2-5]\\d{5}", null, null, null, null, null, null, [6, 7, 9]], [null, null, "(?:2(?:16|[2-9]\\d{3})|[3-5][1-8]\\d{3})\\d{4}|(?:2|[3-5][1-8])1[67]\\d{3}|[3-5][1-8]16\\d\\d", null, null, null, "221234567"], [null, null, "9(?:0(?:[1-8]\\d|9[1-9])|(?:1[0-24-9]|[45]\\d)\\d)\\d{5}", null, null, null, "912123456", null, null, [9]], [null, null, "800\\d{6}", null, null, null, "800123456", null, null, [9]], [null, null, "9(?:00|[78]\\d)\\d{6}", null, null, null, "900123456", null, null, [9]], [null, null, "8[5-9]\\d{7}", null, null, null, "850123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "6(?:02|5[0-4]|9[0-6])\\d{6}", null, null, null, "690123456", null, null, [9]], "SK", 421, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{2})(\\d{3,4})", "$1 $2 $3", ["21"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{2,3})", "$1 $2 $3", ["[3-5][1-8]1", "[3-5][1-8]1[67]"], "0$1"], [null, "(\\d{4})(\\d{3})", "$1 $2", ["909", "9090"], "0$1"], [null, "(\\d)(\\d{3})(\\d{3})(\\d{2})", "$1/$2 $3 $4", ["2"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1/$2 $3 $4", 