'use strict';

/* jSticky Plugin
 * =============
 * Author: Andrew Henderson (@AndrewHenderson)
 * Date: 9/7/2012
 * Update: 02/14/2013
 * Website: http://github.com/andrewhenderson/jsticky/
 * Description: A jQuery plugin that keeps select DOM
 * element(s) in view while scrolling the page.
 */

;
(function($) {

  $.fn.stickyScroll = function(options) {

    var defaults = {
        topSpacing: 0, // No spacing by default
        zIndex: '', // No default z-index
        stopper: '.sticky-stopper', // Default stopper class, also accepts number value
        namespace: 'stickyScroll'
      },
      settings = $.extend({}, defaults, options),
      // Accepts custom stopper id or class
      eventName = 'scroll.' + settings.namespace + ' resize.' + settings.namespace;

    if (options === false) {
      $(window).off(eventName);
      return this;
    }

    // Checks if custom z-index was defined
    function checkIndex() {

      if (typeof settings.zIndex == 'number') {
        return true;
      } else {
        return false;
      }
    }
    var hasIndex = checkIndex(); // True or false

    // Checks if a stopper exists in the DOM or number defined
    function checkStopper() {

      if (0 < $(settings.stopper).length || typeof settings.stopper === 'number') {
        return true;
      } else {
        return false;
      }
    }
    var hasStopper = checkStopper(); // True or false

    return this.each(function() {

      var $this = $(this),
        thisHeight = $this.outerHeight(),
        thisWidth = $this.width('auto').outerWidth(),
        topSpacing = settings.topSpacing,
        zIndex = settings.zIndex,
        pushPoint = $this.offset().top - topSpacing,
        // Point at which the sticky element starts pushing
        placeholder = $('<div></div>').width(thisWidth).addClass('sticky-placeholder'),
        // Cache a clone sticky element
        stopper = settings.stopper,
        $window = $(window);

      function stickyScroll() {

        if (!$this.is(':visible')) return;

        var windowTop = $window.scrollTop(); // Check window's scroll position

        if (hasStopper && typeof stopper === 'string') {
          var $stopper = $(stopper),
            stopperTop = $stopper.offset().top,
            stopperMarginTop = parseInt($stopper.css('margin-top'), 10),
            stopPoint = stopperTop - thisHeight - topSpacing - stopperMarginTop;
        } else if (hasStopper && typeof stopper === 'number') {
          var stopPoint = stopper;
        }

        if (pushPoint < windowTop) {
          // Create a placeholder for sticky element to occupy vertical real estate
          $this.width(thisWidth).append(placeholder).css({
            position: 'fixed',
            top: topSpacing
          });

          if (hasIndex) {
            $this.css({
              zIndex: zIndex
            });
          }

          if (hasStopper) {
            if (stopPoint < windowTop) {
              var diff = stopPoint - windowTop + topSpacing;
              $this.css({
                top: diff
              });
            }
          }
        } else {
          $this.css({
            position: 'static',
            top: null,
            left: null
          });

          placeholder.remove();
        }
      };

      $window.off(eventName).on(eventName, stickyScroll);
    });
  };
})(jQuery);