<?php
/* This file has been auto-generated. Do not edit this file directly. */
namespace SabaiApps\Directories\Component\Payment\Model\Base;

use SabaiApps\Framework\Model\Model;

abstract class FeatureGateway extends \SabaiApps\Framework\Model\AbstractGateway
{
    public function getName()
    {
        return 'payment_feature';
    }

    public function getFields()
    {
        return ['feature_status' => Model::KEY_TYPE_INT, 'feature_feature_name' => Model::KEY_TYPE_VARCHAR, 'feature_metas' => Model::KEY_TYPE_TEXT, 'feature_logs' => Model::KEY_TYPE_TEXT, 'feature_id' => Model::KEY_TYPE_INT, 'feature_created' => Model::KEY_TYPE_INT, 'feature_updated' => Model::KEY_TYPE_INT, 'feature_featuregroup_id' => Model::KEY_TYPE_INT];
    }

    protected function _getIdFieldName()
    {
        return 'feature_id';
    }

    protected function _getSelectByIdQuery($id, $fields)
    {
        return sprintf(
            'SELECT %s FROM %spayment_feature WHERE feature_id = %d',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $id
        );
    }

    protected function _getSelectByIdsQuery($ids, $fields)
    {
        return sprintf(
            'SELECT %s FROM %spayment_feature WHERE feature_id IN (%s)',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            implode(', ', array_map('intval', $ids))
        );
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, $fields)
    {
        return sprintf(
            'SELECT %1$s FROM %2$spayment_feature payment_feature WHERE %3$s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $criteriaStr
        );
    }

    protected function _getInsertQuery(&$values)
    {
        $values['feature_created'] = time();
        $values['feature_updated'] = 0;
        return sprintf('INSERT INTO %spayment_feature(feature_status, feature_feature_name, feature_metas, feature_logs, feature_id, feature_created, feature_updated, feature_featuregroup_id) VALUES(%d, %s, %s, %s, %s, %d, %d, %d)', $this->_db->getResourcePrefix(), $values['feature_status'], $this->_db->escapeString($values['feature_feature_name']), $this->_db->escapeString(serialize($values['feature_metas'])), $this->_db->escapeString(serialize($values['feature_logs'])), empty($values['feature_id']) ? 'NULL' : intval($values['feature_id']), $values['feature_created'], $values['feature_updated'], $values['feature_featuregroup_id']);
    }

    protected function _getUpdateQuery($id, $values)
    {
        $last_update = $values['feature_updated'];
        $values['feature_updated'] = time();
        return sprintf('UPDATE %spayment_feature SET feature_status = %d, feature_feature_name = %s, feature_metas = %s, feature_logs = %s, feature_updated = %d, feature_featuregroup_id = %d WHERE feature_id = %d AND feature_updated = %d', $this->_db->getResourcePrefix(), $values['feature_status'], $this->_db->escapeString($values['feature_feature_name']), $this->_db->escapeString(serialize($values['feature_metas'])), $this->_db->escapeString(serialize($values['feature_logs'])), $values['feature_updated'], $values['feature_featuregroup_id'], $id, $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$spayment_feature WHERE feature_id = %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, $sets)
    {
        $sets['feature_updated'] = 'feature_updated=' . time();
        return sprintf('UPDATE %spayment_feature payment_feature SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(', ', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE payment_feature FROM %1$spayment_feature payment_feature WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$spayment_feature payment_feature WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _afterInsert1($id, array $new)
    {
    }

    protected function _afterDelete1($id, array $old)
    {
    }

    protected function _afterUpdate1($id, array $new, array $old)
    {
    }

    protected function _afterInsert($id, array $new)
    {
        $this->_afterInsert1($id, $new);
    }

    protected function _afterUpdate($id, array $new, array $old)
    {
        $this->_afterUpdate1($id, $new, $old);
    }

    protected function _afterDelete($id, array $old)
    {
        $this->_afterDelete1($id, $old);
    }
}