<?php
namespace SabaiApps\Directories\Component\Entity\Helper;

use SabaiApps\Directories\Application;

class FieldCacheHelper
{   
    public function help(Application $application, array $entities)
    {
        $platform = $application->getPlatform();
        $loaded = [];
        foreach (array_keys($entities) as $entity_id) {
            if ($cache = $platform->getOption('_entity_field_' . $entities[$entity_id]->getBundleName() . '__' . $entity_id)) {
                $entities[$entity_id]->initFields($cache[0], $cache[1]);
                $loaded[] = $entity_id;
            }
        }
        return $loaded;
    }
    
    public function save(Application $application, array $entities)
    {
        $platform = $application->getPlatform();
        foreach ($entities as $entity_id => $entity) {
            $platform->setOption(
                '_entity_field_' . $entity->getBundleName() . '__' . $entity_id,
                array($entity->getFieldValues(), $entity->getFieldTypes()),
                false // do not autoload
             );
        }
    }

    public function remove(Application $application, $bundleName, array $entityIds)
    {
        $platform = $application->getPlatform();
        foreach ($entityIds as $entity_id) {
            $platform->deleteOption('_entity_field_' . $bundleName . '__' . $entity_id);
        }
    }

    public function clean(Application $application, $bundleName = null)
    {
        $cache_id = '_entity_field_';
        if (isset($bundleName)) {
            $cache_id .= $bundleName . '__';
        }
        $application->getPlatform()->clearOptions($cache_id)
            ->clearOptions('_entity_field_post_')
            ->clearOptions('_entity_field_term_');
    }
}