<?php
namespace SabaiApps\Directories\Component\Location\FormField;

use SabaiApps\Directories\Component\Form;

class AddressFormField extends Form\Field\FieldsetField
{
    protected static $_count = 0;

    public function formFieldInit($name, array &$data, Form\Form $form)
    {
        $map = [];
        if (!empty($data['#default_value']['lat']) && !empty($data['#default_value']['lng'])) {
            $map['center-lat'] = $map['lat'] = str_replace(',', '.', floatval($data['#default_value']['lat']));
            $map['center-lng'] = $map['lng'] = str_replace(',', '.', floatval($data['#default_value']['lng']));
        } else {
            if (isset($data['#center_longitude'])) {
                $map['center-lng'] = str_replace(',', '.', floatval($data['#center_longitude']));
            }
            if (isset($data['#center_latitude'])) {
                $map['center-lat'] = str_replace(',', '.', floatval($data['#center_latitude']));
            }
            $map['lat'] = $map['lng'] = '';
        }
        if (!empty($data['#default_value']['zoom'])) {
            $map['zoom'] = $data['#default_value']['zoom'];
        } else {
            $map['zoom'] = isset($data['#zoom']) ? intval($data['#zoom']) : 10;
        }
        $map['map-type'] = isset($data['#map_type']) && in_array(strtolower($data['#map_type']), array('satellite', 'hybrid', 'osm'))
            ? $data['#map_type']
            : 'roadmap';
        $map['map-api-key'] = $this->_application->getComponent('Map')->getConfig('api', 'key');
        $data = array(
            '#tree' => true,
            '#group' => true,
            '#children' => array(
                0 => [],
                1 => [],
            ),
            '#data' => $map,
        ) + $data;
        $data['#children'][1] += array(
            'buttons' => array(
                '#type' => 'markup',
                '#markup' => '<div class="drts-location-address-field-buttons" style="margin:0 0 5px;">
    <button class="' . DRTS_BS_PREFIX . 'btn ' . DRTS_BS_PREFIX . 'btn-info ' . DRTS_BS_PREFIX . 'btn-sm drts-map-field-find-on-map"><i class="fas fa-search fa-fw"></i> ' . __('Find on map', 'directories-pro') . '</button>
    <button class="' . DRTS_BS_PREFIX . 'btn ' . DRTS_BS_PREFIX . 'btn-info ' . DRTS_BS_PREFIX . 'btn-sm drts-map-field-get-from-map"><i class="fas fa-arrow-up fa-fw"></i> ' . __('Get from map', 'directories-pro') . '</button>
</div>',
            ),
            'map' => array(
                '#type' => 'item',
                '#markup' => sprintf(
                    '<div style="height:%dpx;" class="drts-map-map" data-form-field-name="__FORM_FIELD_NAME__"></div>',
                    empty($data['#map_height']) ? 300 : $data['#map_height']
                ),
            ),
            'manual' => array(
                '#type' => 'checkbox',
                '#title' => __('Enter address details manually', 'directories-pro'),
                '#attributes' => array('class' => 'drts-map-field-manual'),
                '#default_value' => false,
                '#switch' => false,
            ),
            '_address' => array(
                '#type' => 'address',
                '#disable_street2' => true,
                '#class' => 'drts-map-location ' . DRTS_BS_PREFIX . 'mb-0',
                '#class_street' => 'drts-map-location-street',
                '#class_city' => 'drts-map-location-city',
                '#class_province' => 'drts-map-location-province',
                '#class_zip' => 'drts-map-location-zip',
                '#class_country' => 'drts-map-location-country',
                '#attr_street' => ['data-format' => $data['#street_format']],
                '#default_value' => is_array(@$data['#default_value']['_address']) ? $data['#default_value']['_address'] : @$data['#default_value'],
                '#states' => $hidden_if_not_manual = array(
                    'visible' => array('.drts-map-field-manual' => array('type' => 'checked', 'value' => true, 'container' => '.drts-form-type-location-address')),
                ),
                '#states_selector' => '.drts-map-location',
                '#country_type' => 'System_Countries',
            ),
            'timezone' => [
                '#type' => 'select',
                '#class' => 'drts-map-location-timezone',
                '#title' => __('Timezone', 'directories-pro'),
                '#default_value' => isset($data['#default_value']['timezone']) ? $data['#default_value']['timezone'] : null,
                '#options' => ['' => ''] + array_combine($identifiers = \DateTimeZone::listIdentifiers(), $identifiers),
                '#states' => $hidden_if_not_manual,
                '#states_selector' => '.drts-map-location-timezone',
            ],
            '_latlng' => array(
                '#type' => 'map_latlng',
                '#class' => 'drts-map-location-latlng',
                '#default_value' => is_array(@$data['#default_value']['_latlng']) ? $data['#default_value']['_latlng'] : @$data['#default_value'],
                '#states' => $hidden_if_not_manual,
                '#states_selector' => '.drts-map-location-latlng',
            ),
            'zoom' => array(
                '#type' => 'markup',
                '#value' => sprintf('<input type="hidden" name="%s[zoom]" value="%d" class="drts-map-field-zoom" />', $this->_application->H($name), isset($data['#default_value']['zoom']) ? $data['#default_value']['zoom'] : 10),
            ),
        );

        if (empty($data['#input_fields'])) {
            $data['#children'][0] += array(
                'address' => array(
                    '#type' => 'textfield',
                    '#attributes' => array('class' => 'drts-location-text-input drts-map-location-address drts-map-location-address-component', 'data-autocomplete-country' => (string)@$data['#autocomplete_country']),
                    '#default_value' => @$data['#default_value']['address'],
                    '#required' => !empty($data['#required']),
                    '#field_suffix' => '<span class="drts-map-location-geolocate"><i class="fas fa-crosshairs"></i></span>',
                    '#field_suffix_no_addon' => true,
                ) + (array)@$data['#address'],
            );
        } else {
            foreach ($data['#input_fields'] as $key => $label) {
                $data['#children'][0][$key] = array(
                    '#type' => 'textfield',
                    '#title' => $label,
                    '#default_value' => @$data['#default_value'][$key],
                    '#attributes' => array('class' => 'drts-map-location-address-component drts-map-location-' . $key),
                    '#horizontal' => true,
                    '#required' => !empty($data['#required']),
                );
                if ($key === 'street') {
                    $data['#children'][0][$key]['#attributes']['data-format'] = $data['#street_format'];
                }
            }
            $data['#children'][1] += array(
                'address' => array(
                    '#type' => 'hidden',
                    '#class' => 'drts-map-location-address',
                    '#render_hidden_inline' => true,
                ),
                'city' => array(
                    '#type' => 'hidden',
                    '#class' => 'drts-map-location-city',
                    '#render_hidden_inline' => true,
                ),
                'province' => array(
                    '#type' => 'hidden',
                    '#class' => 'drts-map-location-province',
                    '#render_hidden_inline' => true,
                ),
                'country' => array(
                    '#type' => 'hidden',
                    '#class' => 'drts-map-location-country',
                    '#render_hidden_inline' => true,
                ),
            );
            foreach (array('street', 'zip') as $key) {
                if (!isset($data['#input_fields'][$key])) {
                    $data['#children'][1][$key] = array(
                        '#type' => 'hidden',
                        '#class' => 'drts-map-location-' . $key,
                        '#render_hidden_inline' => true,
                    );
                    if ($key === 'street') {
                        $data['#children'][1][$key]['#attributes']['data-format'] = $data['#street_format'];
                    }
                }
            }
            // Add country name used by the find on map button
            if (!empty($data['#input_country'])) {
                $data['#children'][1]['_country'] = array(
                    '#type' => 'hidden',
                    '#value' => $data['#input_country'],
                    '#class' => 'drts-map-location-address-component',
                    '#render_hidden_inline' => true,
                );
            }
            $data['#children'][1]['buttons']['#markup'] = '<div class="drts-location-address-field-buttons" style="margin:0 0 5px;">
    <button class="' . DRTS_BS_PREFIX . 'btn ' . DRTS_BS_PREFIX . 'btn-info ' . DRTS_BS_PREFIX . 'btn-sm drts-map-field-find-on-map"><i class="fas fa-search fa-fw"></i> ' . __('Find on map', 'directories-pro') . '</button>
</div>';
            unset($data['#children'][1]['_address']);
            $data['#children'][1]['manual']['#title'] = __('Enter geolocation info manually', 'directories-pro');
        }
        $data['#latlng_required'] = $data['#required'];
        unset($data['#required']);

        $form->settings['#pre_render'][__CLASS__] = array($this, 'preRenderCallback');

        parent::formFieldInit($name, $data, $form);
    }

    public function formFieldSubmit(&$value, array &$data, Form\Form $form)
    {
        parent::formFieldSubmit($value, $data, $form);

        if (empty($value['_latlng']['lat']) || empty($value['_latlng']['lng'])) {
            if (!empty($data['#latlng_required'])
                || (!empty($data['#latlng_required_if_address']) && strlen(trim($value['address'])))
            ) {
                $form->setError(__('Please click on the map or fill out the following fields.', 'directories-pro'), $data['#name'] . '[_latlng]');
                $form->setError(__('Please select a valid location on map.', 'directories-pro'), $data['#name'] . '[map]');
            }
        }

        if ($form->hasError()) return;

        if (!empty($value['_latlng'])) {
            foreach ($value['_latlng'] as $key => $_value) {
                $value[$key] = $_value;
            }
        } else {
            unset($value['_latlng']); // prevent from saving array as string
        }

        if (!empty($value['_address'])) {
            foreach ($value['_address'] as $key => $_value) {
                $value[$key] = $_value;
            }
        } else {
            unset($value['_address']); // prevent from saving array as string
        }
    }

    public function preRenderCallback($form)
    {
        $this->_application->Location_Api_load(array('markermap' => true));

        $form->settings['#js_ready'][] = '(function() {
    var googlemaps = function (field, cloneable) {
        DRTS.Map.markerMap(field, cloneable);
        var address = field.find(".drts-location-text-input");
        DRTS.Map.autocomplete(address, {markerMap: field, country: address.data("autocomplete-country")});
    }
    $(".drts-form-type-location-address").each(function(index) {
        var field = $(this);
        if (field.is(":visible")) {
            googlemaps(field, index === 0);
        } else {
            var tab = field.closest(".' . DRTS_BS_PREFIX . 'tab-pane");
            if (tab.length) {
                $("#" + tab.attr("id") + "-trigger").on("shown.bs.tab", function(e, data){
                    googlemaps(field, index === 0);
                });
            }
        }
    });
})();';
    }
}
