<?php
namespace SabaiApps\Directories\Component\Map\Helper;

use SabaiApps\Directories\Application;
use SabaiApps\Directories\Component\Entity;
use SabaiApps\Directories\Exception;

class MarkerHelper
{
    public function help(Application $application, Entity\Type\IEntity $entity, $fieldName, $container, array $options = array())
    {
        $markers = [];
        if ($values = $entity->getFieldValue($fieldName)) {
            $image_field_name = isset($options['image_field_name']) ? $options['image_field_name'] : null;
            $image = $application->Entity_Image_url($entity, 'thumbnail', $image_field_name);
            if (!$image) $image = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAPAAAAC0CAQAAAAAlWljAAABIklEQVR42u3RAQ0AAAjDMK4c6aAD0klYM116XAADFmABFmABFmABBizAAizAAizAAgxYgAVYgAVYgAVYgAELsAALsAALsAADFmABFmABFmABBizAAizAAizAAizAgAVYgAVYgAVYgAELsAALsAALsAADBgxYgAVYgAVYgAUYsAALsAALsAALMGABFmABFmABFmABBizAAizAAizAAgxYgAVYgAVYgAUYsAALsAALsAALsAADFmABFmABFmABBizAAizAAizAAgzYBMACLMACLMACLMCABViABViABViAAQuwAAuwAAuwAAswYAEWYAEWYAEWYMACLMACLMACLMCABViABViABViABRiwAAuwAAuwAAswYAEWYAEWYAEWYMACrKst65UNXM2XNOgAAAAASUVORK5CYII=';
            $icon = $application->Entity_Image_url($entity, isset($options['size']) ? $this->_getSize($options['size']) : 'icon', $image_field_name);
            $title = !empty($options['link']) ? $application->Entity_Permalink($entity, ['atts' => ['class' => DRTS_BS_PREFIX . 'text-white']]) : $application->H($entity->getTitle());
            foreach ($values as $key => $value) {
                if (!$value['lat'] || !$value['lng']) continue;
            
                $markers[$key] = array(
                    'content' => $this->content($application, $title, $value['address'], $image),
                    'lat' => $value['lat'],
                    'lng' => $value['lng'],
                    'icon' => $icon ? ['url' => $icon] : null,
                    'trigger' => isset($options['trigger']) ? $options['trigger'] : $entity->getUniqueId($container),
                    'triggerEvent' => isset($options['trigger_event']) ? $options['trigger_event'] : null,
                );
            }
        }
        return $markers;
    }
    
    public function content(Application $application, $title, $address, $imgUrl = null)
    {
        $html = array('<div class="' . DRTS_BS_PREFIX . 'card ' . DRTS_BS_PREFIX . 'border-0 ' . DRTS_BS_PREFIX . 'bg-dark ' . DRTS_BS_PREFIX . 'text-white drts-location-card">');
        
        $html[] = '<img class="' . DRTS_BS_PREFIX . 'card-img" src="' . $imgUrl . '" alt="" />';
        $html[] = '<div class="' . DRTS_BS_PREFIX . 'card-img-overlay drts-location-card-body ' . DRTS_BS_PREFIX . 'p-2">';
        $html[] = '<div class="' . DRTS_BS_PREFIX . 'card-title">' . $title . '</div>';
        $html[] = '<address class="' . DRTS_BS_PREFIX . 'card-text">' . $application->H($address) . '</address>';
        $html[] = '</div></div>';
        
        return implode(PHP_EOL, $html);
    }
    
    public function all(Application $application, Entity\Model\Bundle $bundle, array $entities, $fieldName, $container, $link = false, $size = null)
    {
        $markers = [];
        $options = [
            'link' => $link,
            'image_field_name' => $application->Entity_BundleTypeInfo($bundle, 'entity_image'),
            'size' => isset($size) ? $this->_getSize($size) : 'icon',
        ];
        foreach ($entities as $entity) {
            $_markers = $this->help($application, $entity, $fieldName, $container, $options);
            foreach (array_keys($_markers) as $i) {
                $markers[] = ['index' => $i] + $_markers[$i];
            }
        }
        
        return $markers;
    }
    
    protected function _getSize($size)
    {   
        if (!is_numeric($size)) return $size;
        
        if ($size > 54) return 'icon_xl';
        
        return $size <= 38 ? 'icon' : 'icon_lg';
    }
}