<?php
namespace SabaiApps\Directories\Component\Map\FakerGenerator;

use SabaiApps\Directories\Component\Faker;
use SabaiApps\Directories\Component\Field;
use SabaiApps\Directories\Exception;

class MapFakerGenerator extends Faker\Generator\AbstractGenerator
{
    protected $_viewport;
    
    protected function _fakerGeneratorInfo()
    {
        switch ($this->_name) {
            case 'map_map':
                return array(
                    'field_types' => array($this->_name),
                    'default_settings' => array(
                        'probability' => 100,
                        'max' => 5,
                        'location' => null,
                    ),
                );
        }
    }
    
    public function fakerGeneratorSettingsForm(Field\IField $field, array $settings, array $parents = [])
    {
        switch ($this->_name) {
            case 'map_map':
                return array(
                    'probability' => $this->_getProbabilitySettingForm($settings['probability']),
                    'location' => array(
                        '#type' => 'textfield',
                        '#description' => __('Enter a location used to generate lat/lng coordinates, e.g. USA, California, Tokyo, etc.', 'directories'),
                        '#default_value' => $settings['location'],
                        '#required' => true,
                    ),
                    'max' => $this->_getMaxNumItemsSettingForm($field, $settings['max']),
               );
        }
    }
    
    public function fakerGeneratorGenerate(Field\IField $field, array $settings, array &$values)
    {
        switch ($this->_name) {
            case 'map_map':
                if (mt_rand(0, 100) > $settings['probability']) return;

                $location = $settings['location'];
                
                if (empty($location)) return false;
                
                if (!isset($this->_viewport[$location])) {
                    try {
                        $geocoded = $this->_application->Map_Api_geocode($location, false);
                        $this->_viewport[$location] = $geocoded['viewport'];
                    } catch (Exception\IException $e) {
                        $this->_application->logError($e);
                        $this->_viewport[$location] = false;
                    }
                }
                if (!$this->_viewport[$location]) return false;
                
                $ret = [];
                $count = $this->_getMaxNumItems($field, $settings['max']);
                $faker = $this->_getFaker();
                $viewport = $this->_viewport[$location];
                for ($i = 0; $i < $count; ++$i) {
                    $ret[$i] = array(
                        'lat' => $faker->randomFloat(6, $viewport[0], $viewport[2]),
                        'lng' => $faker->randomFloat(6, $viewport[1], $viewport[3]),
                    );
                }
                return $ret;
        }
    }
}