<?php
namespace SabaiApps\Directories\Component\Field\Renderer;

use SabaiApps\Directories\Component\Entity;
use SabaiApps\Directories\Component\Field\IField;

abstract class AbstractFileRenderer extends AbstractRenderer
{
    protected $_fieldTypes;
    
    protected function _fieldRendererInfo()
    {
         return array(
            'field_types' => $this->_fieldTypes,
            'default_settings' => array(
                '_separator' => ' ',
            ),
            'inlineable' => true,
        );
    }

    protected function _fieldRendererRenderField(IField $field, array &$settings, Entity\Type\IEntity $entity, array $values, $more = 0)
    {
        $ret = [];
        foreach ($values as $value) {
            $icon = $this->_application->FileIcon($this->_getFileExtension($field, $settings, $value, $entity));
            $ret[] = '<i class="' . $icon . '"></i> ' . $this->_getFileLink($field, $settings, $value, $entity);
        }
        return implode($settings['_separator'], $ret);
    }
    
    abstract protected function _getFileExtension(IField $field, array $settings, $value, Entity\Type\IEntity $entity);
    abstract protected function _getFileLink(IField $field, array $settings, $value, Entity\Type\IEntity $entity);
}