'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function(obj) {
  return typeof obj;
} : function(obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};

(function($) {
  DRTS.Map = DRTS.Map || {};
  DRTS.Map.markerMap = DRTS.Map.markerMap || function(field, cloneable) {
    if (typeof google === 'undefined' || !google.maps) return;

    var $field = $(field),
      map,
      overlay,
      geocoder,
      getCallbacks = function getCallbacks() {
        return DRTS.Map.markerMapAddress;
      },
      getGeocoder = function getGeocoder() {
        if (!geocoder) geocoder = new google.maps.Geocoder();
        return geocoder;
      },
      updateValues = function updateValues(latlng) {
        $field.find('.drts-map-field-zoom').val(map.getZoom());
        $field.find('.drts-map-field-lat').val(latlng.lat());
        $field.find('.drts-map-field-lng').val(latlng.lng());
        fetchAddress(latlng, false);
        fetchTimezone(latlng, false);
      },
      updateAll = function updateAll(latlng) {
        overlay.setPosition(latlng);
        overlay.setAnimation(google.maps.Animation.BOUNCE);
        window.setTimeout(function() {
          overlay.setAnimation(null);
          map.panTo(latlng);
          updateValues(latlng);
        }, 1000);
      },
      fetchTimezone = function fetchTimezone(latlng, overwrite) {
        if (!$field.data('map-api-key')) return; // API key required for timezone API request

        var field = $field.find('.drts-map-location-timezone select');
        if (!field.length || !overwrite && field.val()) return;

        $.get('https://maps.googleapis.com/maps/api/timezone/json', {
          timestamp: Math.round(new Date().getTime() / 1000).toString(),
          location: latlng.lat() + ',' + latlng.lng(),
          key: $field.data('map-api-key')
        }, function(data) {
          if (data.status === 'OK') {
            field.val(data.timeZoneId);
          } else {
            if (data.error_message) console.log(data.error_message);
          }
        });
      },
      fetchAddress = function fetchAddress(latlng, overwrite) {
        getGeocoder().geocode({
          'latLng': latlng
        }, function(results, status) {
          if (status == google.maps.GeocoderStatus.OK) {
            if (results[0]) {
              if (results[0].address_components) {
                var geocoded = {};
                for (var i in results[0].address_components) {
                  if (_typeof(results[0].address_components[i]) !== 'object' || !results[0].address_components[i].types[0] || !results[0].address_components[i].long_name) continue;

                  geocoded[results[0].address_components[i].types[0]] = {
                    value: results[0].address_components[i].long_name,
                    short_value: results[0].address_components[i].short_name
                  };
                }
              }
              var formatted_address = $field.find('.drts-map-location-address');
              if (formatted_address.length && (overwrite || !formatted_address.val() || formatted_address.attr('type') === 'hidden')) {
                formatted_address.val(results[0].formatted_address || '');
              }
              $field.find('[class^="drts-map-location-"]').filter(':input:visible:not(.drts-map-location-address)').val('');
              getCallbacks().setAddress($field, geocoded, overwrite);
            } else {
              alert('Geocoder returned no address components');
            }
          } else {
            alert('Geocoder failed due to: ' + status);
          }
        });
      },
      mapType,
      mapTypeIds = [],
      setUserMarker = function setUserMarker() {
        var lat = $field.find('.drts-map-field-lat').val(),
          lng = $field.find('.drts-map-field-lng').val();
        if (lat && lng) {
          google.maps.event.trigger(map, 'click', {
            latLng: new google.maps.LatLng(lat, lng)
          });
        }
      };
    // Init map type IDs
    for (mapType in google.maps.MapTypeId) {
      mapTypeIds.push(google.maps.MapTypeId[mapType]);
    }
    mapTypeIds.push('osm');
    // Init map
    map = new google.maps.Map($field.find('.drts-map-map').get(0), {
      mapTypeControl: true,
      mapTypeId: $.inArray($field.data('map-type'), mapTypeIds) !== -1 ? $field.data('map-type') : google.maps.MapTypeId.ROADMAP,
      mapTypeControlOptions: {
        style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,
        mapTypeIds: mapTypeIds
      },
      zoom: $field.data('zoom'),
      center: new google.maps.LatLng($field.data('center-lat'), $field.data('center-lng')),
      scrollwheel: false,
      styles: null
    });
    map.mapTypes.set('osm', new google.maps.ImageMapType({
      getTileUrl: function getTileUrl(coord, zoom) {
        return '//a.tile.openstreetmap.org/' + zoom + '/' + coord.x + '/' + coord.y + '.png';
      },
      tileSize: new google.maps.Size(256, 256),
      isPng: true,
      maxZoom: 19,
      minZoom: 0,
      name: 'OSM'
    }));
    // Init marker
    overlay = new google.maps.Marker({
      map: map,
      draggable: true,
      animation: google.maps.Animation.DROP
    });
    if ($field.data('lat') && $field.data('lng')) {
      overlay.setPosition(new google.maps.LatLng($field.data('lat'), $field.data('lng')));
    }
    // Init events
    google.maps.event.addListener(map, 'click', function(event) {
      updateAll(event.latLng);
    });
    google.maps.event.addListener(map, 'zoom_changed', function(event) {
      // update zoom
      $field.find('.drts-map-field-zoom').val(map.getZoom());
    });
    google.maps.event.addListener(overlay, 'dragend', function(event) {
      window.setTimeout(function() {
        map.panTo(event.latLng);
        updateValues(event.latLng);
      }, 1000);
    });
    $field.find('.drts-map-field-lat, .drts-map-field-lng').change(function() {
      setUserMarker();
    });
    $field.find('.drts-map-field-find-on-map').click(function() {
      var address = [],
        container = $field.closest('.drts-map-location-container') || $field;
      container.find('.drts-map-location-address-component').each(function() {
        var $this = $(this),
          text;
        if (this.tagName.toLowerCase() === 'select') {
          if (!$this.val()) return true;

          text = $.trim($this.find('option:selected').text());
        } else {
          text = $.trim($this.val());
        }
        if (text.length) {
          address.push(text);
        }
      });
      if (!address.length) return false;
      getGeocoder().geocode({
        'address': $.trim(address.join(' '))
      }, function(results, status) {
        if (status == google.maps.GeocoderStatus.OK) {
          updateAll(results[0].geometry.location);
        } else {
          alert('Geocoder failed due to: ' + status);
        }
      });
      return false;
    });
    $field.find('.drts-map-field-get-from-map').click(function() {
      var latlng = overlay.getPosition();
      if (!latlng) return;

      fetchAddress(latlng, true);
      fetchTimezone(latlng, true);
      return false;
    });
    // Init geolocation
    DRTS.Map.geolocate($field.find('.drts-map-location-address'), updateAll);

    // Init clone events
    if (cloneable) {
      $(DRTS).on('clonefield.sabai', function(e, data) {
        if (data.clone.hasClass('drts-map-location-container') || data.clone.hasClass('drts-form-type-location-map')) {
          var field = data.clone.find('.drts-form-type-location-address').length ? data.clone.find('.drts-form-type-location-address') : data.clone;
          field.data('lat', null).data('lng', null);
          DRTS.Map.markerMap(field, false);
        }
      });
    }
    // Set user marker if any and fit marker into map
    setUserMarker();
    $field.find('.drts-map-map').fitMaps();
  };
  DRTS.Map.markerMapAddress = {
    _loadVal: function _loadVal(field, val, selector, overwrite) {
      field.find(selector).each(function() {
        var $this = $(this);
        if (!overwrite && $this.val() && $this.attr('type') !== 'hidden') return;

        if ($this.get(0).tagName.toLowerCase() === 'select') {
          var found;
          $this.find('option').each(function() {
            found = this.value === val.short_value || this.value === val.value || this.innerHTML === val.value;
            if (found) {
              $this.val(this.value);
              return false;
            }
          });
        } else {
          $this.val(val.short_value || val.value);
        }
      });
    },
    setAddress: function setAddress(field, geocoded, overwrite) {
      console.log(geocoded);
      for (var key in geocoded) {
        switch (key) {
          case 'sublocality':
          case 'locality':
            DRTS.Map.markerMapAddress._loadVal(field, geocoded[key], '.drts-map-location-city', overwrite);
            break;
          case 'administrative_area_level_1':
            DRTS.Map.markerMapAddress._loadVal(field, geocoded[key], '.drts-map-location-province', overwrite);
            break;
          case 'postal_code':
            DRTS.Map.markerMapAddress._loadVal(field, geocoded[key], '.drts-map-location-zip', overwrite);
            break;
          case 'country':
            DRTS.Map.markerMapAddress._loadVal(field, geocoded[key], '.drts-map-location-country', overwrite);
            break;
        }
      }
      field.find('.drts-map-location-street').each(function() {
        var $this = $(this),
          street_address;
        if (!overwrite && $this.val() && $this.attr('type') !== 'hidden') return;

        if ($this.data('format')) {
          street_address = $this.data('format').replace(/\{(.*?)_short\}/g, function(all, key) {
            return Object.prototype.hasOwnProperty.call(geocoded, key) ? geocoded[key].short_value : '';
          });
          street_address = $this.data('format').replace(/\{(.*?)\}/g, function(all, key) {
            return Object.prototype.hasOwnProperty.call(geocoded, key) ? geocoded[key].value : '';
          });
          street_address = street_address.replace(/\s+/g, ' ').trim().replace(/(^,)|(,$)/g, '') // remove starting/trailing commas
            .trim();
        } else if (geocoded.street_address) {
          street_address = geocoded.street_address.value;
        } else if (geocoded.route) {
          if (geocoded.street_number) {
            street_address = geocoded.street_number.value + ' ' + geocoded.route.value;
          } else {
            street_address = geocoded.route.value;
          }
        }
        $this.val(street_address);
      });
    }
  };
})(jQuery);