<?php
namespace SabaiApps\Directories\Component\Payment\Feature;

use SabaiApps\Directories\Application;
use SabaiApps\Directories\Component\Entity;
use SabaiApps\Directories\Component\Payment\Model\Feature;
use SabaiApps\Directories\Component\Payment\IPlan;

abstract class AbstractFeature implements IFeature
{
    protected $_application, $_name;
    
    public function __construct(Application $application, $name)
    {
        $this->_application = $application;
        $this->_name = $name;
    }
    
    abstract protected function _paymentFeatureInfo();
    
    public function paymentFeatureInfo($key = null)
    {
        $info = $this->_paymentFeatureInfo();
        return isset($key) ? (isset($info[$key]) ? $info[$key] : null) : $info;
    }
    
    public function paymentFeatureSettings(Entity\Model\Bundle $bundle, $base = null)
    {
        return false; // use default_settings in info array
    }
    
    public function paymentFeatureSupports(Entity\Model\Bundle $bundle)
    {
        return true;
    }
    
    public function paymentFeatureSettingsForm(Entity\Model\Bundle $bundle, array $settings, array $parents = []){}
        
    public function paymentFeatureIsEnabled(Entity\Model\Bundle $bundle, array $settings)
    {
        return true;
    }
    
    public function paymentFeatureOnEntityForm(Entity\Model\Bundle $bundle, array $settings, array &$form, Entity\Type\IEntity $entity = null, $isAdmin = false, $isEdit = false){}
    
    public function paymentFeatureOnClaimEntityForm(Entity\Model\Bundle $bundle, array $settings, array &$form, Entity\Type\IEntity $entity){}
    
    public function paymentFeatureOnAdded(Entity\Type\IEntity $entity, Feature $feature, array $settings, IPlan $plan, array &$values)
    {
        $feature->addMetas($settings);
    }
        
    public function paymentFeatureApply(Entity\Type\IEntity $entity, Feature $feature, array &$values)
    {
        return true;
    }
    
    public function paymentFeatureUnapply(Entity\Type\IEntity $entity, Feature $feature, array &$values)
    {
        return true;
    }
    
    public function paymentFeatureRender(Entity\Model\Bundle $bundle, array $settings){}
        
    public function isFieldRequired($form, $parents, $dependee = 'enable')
    {
        $values = $form->getValue($parents);
        return !empty($values[$dependee]);
    }
    
    protected function _applyAddonFeature(Entity\Type\IEntity $entity, Feature $feature, array &$values, array $metas = null)
    {
        if (!$entity->getSingleFieldValue('payment_plan', 'plan_id') // needs a plan associated in order to apply add-ons
            || $feature->FeatureGroup->plan_name // not an add-on feature
        ) return;

        $values['payment_plan']['addon_features'][$this->_name] = isset($metas) ? $metas : $feature->getMetas();
        
        return true;
    }
    
    protected function _maxNumAllowedLabel($label)
    {
        return sprintf(__('Max number of %s allowed', 'directories-payments'), strtolower($label), $label);
    }
    
    protected function _additionalNumAllowedLabel($label)
    {
        return sprintf(__('Additional number of %s allowed', 'directories-payments'), strtolower($label), $label);
    }
}