'use strict';

(function($) {
  DRTS.Location = DRTS.Location || {};
  DRTS.Location.map = DRTS.Location.map || function(map, options) {
    if (map.getContainer().find('.drts-view-entities-container').length) {
      $(DRTS).on('loaded.sabai', function(e, data) {
        if (data.container === map.getContainerSelector() && data.target.hasClass('drts-view-entities-container')) {
          if (data.target.hasClass('drts-location-map-full')) {
            $('.drts-location-entities-container').animate({
              scrollTop: 0
            }, 500, 'swing');
          }
          map.clearMarkers();
          if (data.response.markers) {
            map.setMarkers(data.response.markers);
          }
          map.draw(data.response.draw_options);
        }
      });
    }
    $(DRTS).on('map_marker_clicked.sabai', function(e, data) {
      map.getContainer().find('.drts-highlighted').removeClass('drts-highlighted');

      if (!data.marker || !data.marker.get('trigger')) return;

      var $item = $(data.marker.get('trigger'));
      if (!$item.length || !$item.is(':visible')) return;

      DRTS.Location.scrollToItem($item, function() {
        $item.addClass('drts-highlighted');
      });
    });
    DRTS.Location.enableMapControls(map, options);
    if (options.sticky) DRTS.Location.stickyScroll(map);
  };
  DRTS.Location.stickyScroll = function(map, options) {
    if (!$.fn.stickyScroll) return;

    var mapContainer = map.getContainer().find('.drts-map-container');
    if (options === false) {
      mapContainer.stickyScroll(false).css({
        position: 'relative',
        top: '',
        width: ''
      });
    } else {
      if (typeof options === 'undefined') {
        options = {
          topSpacing: $('#wpadminbar').length ? $('#wpadminbar').outerHeight() : 0,
          stopper: map.getContainerSelector() + ' .drts-location-sticky-scroll-stopper',
          namespace: map.getContainer().attr('id') || 'stickyScroll'
        };
      }
      if (typeof imagesLoaded !== 'undefined') {
        $('body').imagesLoaded(function() {
          mapContainer.stickyScroll(options);
        });
      } else {
        mapContainer.stickyScroll(options);
      }
    }
  };
  DRTS.Location.enableMapControls = function(map, options) {
    var controls = map.getContainer().find('.drts-location-map-controls');
    if (!controls.length) return;

    var filter_form = $('.drts-view-filter-form[data-entities-container="' + map.getContainerSelector() + '"]');
    if (filter_form.length > 0) {
      var location_filter = filter_form.find('.drts-view-filter-form-field-type-location-address');
      if (location_filter.length > 0) {
        // Show custom control butotns
        if (location_filter.data('search-my-loc')) {
          if (navigator.geolocation && (document.location.protocol === 'https:' || document.location.hostname === 'localhost')) {
            controls.find('.drts-location-map-control[data-action="geolocate"]').show();
          }
        }
        if (location_filter.data('search-this-area')) {
          controls.find('.drts-location-map-control[data-action="update"]').show();
        }
      }
    }
    var height = map.getContainer().find('.drts-map-map').outerHeight();
    // Handle click on custom confrol buttons
    controls.on('click', '.drts-location-map-control', function(e) {
      e.preventDefault();
      var $this = $(this);

      var resize_fullscreen_map = function resize_fullscreen_map(e) {
        var height = $(window).outerHeight() - e.data.offset;
        e.data.container.find('.drts-location-entities-container').outerHeight(height).end().find('.drts-map-map').outerHeight(height);
      };

      switch ($this.data('action')) {
        case 'update':
        case 'geolocate':
          // Need to re-fetch filter form since it gets disconnected with the current page after first submit 
          var _filter_form = $('.drts-view-filter-form[data-entities-container="' + map.getContainerSelector() + '"]');
          if (!_filter_form.length) return this;

          _filter_form.find('.drts-view-filter-form-field-type-location-address').each(function() {
            DRTS.View.removeFilter(_filter_form, $(this).data('view-filter-name'));
          });

          switch ($this.data('action')) {
            case 'update':
              var bounds = map.getMap().getBounds();
              _filter_form.find('.drts-location-text-viewport').val([bounds.getSouthWest().lat(), bounds.getSouthWest().lng(), bounds.getNorthEast().lat(), bounds.getNorthEast().lng()].join(',')).end().find('.drts-location-text-center').val('').end().find('.drts-location-text-radius').val(0).end().find('.drts-location-text-zoom').val(map.getMap().getZoom()).end().find('.drts-location-text-input').val('Current Map View');
              _filter_form.find('input[name^="search_location_location"]').val('').end().submit();
              break;

            case 'geolocate':
              $this.find('> i').addClass('fa-spin');
              var geocoder = new google.maps.Geocoder();
              navigator.geolocation.getCurrentPosition(function(pos) {
                $this.find('> i').removeClass('fa-spin');
                var latlng = new google.maps.LatLng(pos.coords.latitude, pos.coords.longitude);
                geocoder.geocode({
                  latLng: latlng
                }, function(results, status) {
                  if (status === google.maps.GeocoderStatus.OK) {
                    var bounds = results[0].geometry.viewport;
                    _filter_form.find('.drts-location-text-viewport').val([bounds.getSouthWest().lat(), bounds.getSouthWest().lng(), bounds.getNorthEast().lat(), bounds.getNorthEast().lng()].join(',')).end().find('.drts-location-text-center').val('').end().find('.drts-location-text-radius').val(0).end().find('.drts-location-text-zoom').val('').end().find('.drts-location-text-input').val('Current Location');
                    _filter_form.find('input[name^="search_location_location"]').val('').end().submit();
                  } else {
                    DRTS.flash('Geocode was not successful for the following reason: ' + status, 'danger');
                  }
                });
              }, function(error) {
                $this.find('> i').removeClass('fa-spin');
                DRTS.flash(error.message + ' (' + error.code + ')', 'danger');
              }, {
                enableHighAccuracy: true,
                timeout: 10000
              });
              break;
          }
          break;
        case 'fullscreen':
        case 'exit_fullscreen':
          var _container = map.getContainer().find('.drts-view-entities-container'),
            is_map_view = _container.hasClass('drts-view-entities-container-map'),
            map_container = is_map_view ? null : _container.find('.drts-location-map-container-container');
          switch ($this.data('action')) {
            case 'fullscreen':
              var offset = $('#wpadminbar').length ? $('#wpadminbar').outerHeight() : 0;
              var _height = $(window).outerHeight() - offset;
              _container.addClass('drts-location-map-full').css('top', offset).toggleClass('drts-location-map-full-no-filter', $(map.getContainerSelector() + '-view-filter-form').length === 0);
              if (!is_map_view) {
                _container.find('.drts-location-entities-container').outerHeight(_height).find('.drts-location-entities').before(_container.find('.drts-view-entities-header')).before(_container.find('.drts-view-entities-filter-form')).after(_container.find('.drts-view-entities-footer')).end().end();
                if (map_container.length) {
                  _container.find('.drts-location-entities-with-map').removeClass('drts-location-entities-with-map-top').end().find('.drts-location-entities-container').removeClass(DRTS.bsPrefix + 'col-sm-' + (12 - map_container.data('span'))).addClass(DRTS.bsPrefix + 'col-sm-' + (12 - map_container.data('fullscreen-span')));
                  map_container.removeClass(DRTS.bsPrefix + 'col-sm-' + map_container.data('span')).addClass(DRTS.bsPrefix + 'col-sm-' + map_container.data('fullscreen-span'));
                  if (options.sticky) DRTS.Location.stickyScroll(map, false);
                }
              } else {
                _height -= _container.find('.drts-view-entities-header').outerHeight();
                _height -= _container.find('.drts-view-entities-footer').outerHeight();
              }
              _container.find('.drts-map-map').outerHeight(_height);
              $(window).on('resize.sabai', {
                container: _container,
                offset: offset
              }, resize_fullscreen_map);
              $('body').css('overflow', 'hidden');
              map.getOverlay(true); // re-create overlay
              $(DRTS).trigger("location_fullscreen.sabai", {
                container: map.getContainer()
              });
              break;
            case 'exit_fullscreen':
              _container.removeClass('drts-location-map-full drts-location-map-full-no-filter').find('.drts-map-map').outerHeight(height); // revert to original height 
              if (!is_map_view) {
                _container.find('> .drts-view-entities').before(_container.find('.drts-view-entities-header')).before(_container.find('.drts-view-entities-filter-form')).after(_container.find('.drts-view-entities-footer')).end().find('.drts-location-entities-container').css('height', '100%');
                if (map_container.length) {
                  _container.find('.drts-location-entities-with-map').toggleClass('drts-location-entities-with-map-top', map_container.data('position') === 'top').end().find('.drts-location-entities-container').removeClass(DRTS.bsPrefix + 'col-sm-' + (12 - map_container.data('fullscreen-span'))).addClass(DRTS.bsPrefix + 'col-sm-' + (12 - map_container.data('span')));
                  map_container.removeClass(DRTS.bsPrefix + 'col-sm-' + map_container.data('fullscreen-span')).addClass(DRTS.bsPrefix + 'col-sm-' + map_container.data('span'));
                  if (options.sticky) {
                    DRTS.scrollTo(_container, null, null, function() {
                      DRTS.Location.stickyScroll(map);
                    });
                  }
                }
              }
              $(window).off('resize.sabai');
              $('body').css('overflow', '');
              map.getOverlay(true); // re-create overlay
              $(DRTS).trigger("location_exit_fullscreen.sabai", {
                container: map.getContainer()
              });
              break;
          }
          google.maps.event.trigger(map.getMap(), 'resize');
          map.draw();
          // Re-evaluate container queries
          if (window.cqApi) {
            window.cqApi.reevaluate(false);
          }
          break;
      }
    });
    // Clear field values when filter removed
    $(window).on('entity_reset_form_field.sabai', function(e, filterName) {
      if (filterName !== 'filter_location_address') return;

      var _filter_form = $('.drts-view-filter-form[data-entities-container="' + map.getContainerSelector() + '"]');
      if (!_filter_form.length) return this;

      _filter_form.find('.drts-location-text-viewport').val('').end().find('.drts-location-text-center').val('').end().find('.drts-location-text-radius').val('').end().find('.drts-location-text-zoom').val('').end().find('.drts-location-text-input').val('');
    });
  };
  DRTS.Location.scrollToItem = function(item, callback) {
    var container = item.closest('.drts-view-entities-container');
    if (!container.length) return;

    var is_map_view = container.hasClass('drts-view-entities-container-map');
    if (is_map_view) return; // this should not happen, but just in case

    var is_full_map = container.hasClass('drts-location-map-full');
    if (is_full_map) {
      var _container = container.find('.drts-location-entities-container');
      if (_container.length) {
        _container.animate({
          scrollTop: _container.scrollTop() - _container.offset().top + item.offset().top
        }, 500, 'swing', callback);
      }
    } else {
      var map_container = container.find('.drts-location-map-container-container');
      var offset = 40;
      if (map_container.data('position') === 'top') {
        offset += map_container.find('.drts-map-map').outerHeight();
      }
      $('html,body').animate({
        scrollTop: item.offset().top - offset
      }, 500, 'swing', callback);
    }
  };
})(jQuery);