<?php
namespace SabaiApps\Directories\Component\Map\FieldRenderer;

use SabaiApps\Directories\Request;
use SabaiApps\Directories\Component\Field\IField;
use SabaiApps\Directories\Component\Entity\Type\IEntity;
use SabaiApps\Directories\Component\Field\Renderer\AbstractRenderer;

class MapFieldRenderer extends AbstractRenderer
{
    protected $_isStreetView = false;
    protected static $_count = 0;
    
    protected function _fieldRendererInfo()
    {
        return array(
            'label' => $this->_isStreetView
                ? __('Street view renderer', 'directories')
                : __('Map renderer', 'directories'),
            'field_types' => array('map_map',  'location_address'),
            'default_settings' => array(
                'height' => 300,
                'directions' => true,
                'map_type_control' => true,
                'zoom_control' => true,
                'fullscreen_control' => true,
            ),
            'separatable' => false,
            'accept_multiple' => true,
        );
    }
    
    protected function _fieldRendererSettingsForm(IField $field, array $settings, array $parents = [])
    {        
        $form = array(
            'height' => array(
                '#type' => 'number',
                '#size' => 4,
                '#integer' => true,
                '#field_suffix' => 'px',
                '#min_value' => 100,
                '#max_value' => 1000,
                '#default_value' => $settings['height'],
                '#title' => __('Map height', 'directories'),
                '#weight' => 1,
            ),
            'zoom_control' => array(
                '#type' => 'checkbox',
                '#default_value' => !empty($settings['zoom_control']),
                '#title' => __('Show zoom control buttons', 'directories'),
                '#weight' => 5,
            ),
            'map_type_control' => array(
                '#type' => 'checkbox',
                '#default_value' => !empty($settings['map_type_control']),
                '#title' => __('Show select map type dropdown menu', 'directories'),
                '#weight' => 7,
            ),
            'fullscreen_control' => array(
                '#type' => 'checkbox',
                '#default_value' => !empty($settings['fullscreen_control']),
                '#title' => __('Show toggle fullscreen button', 'directories'),
                '#weight' => 9,
            ),
        );
        
        if (!$this->_isStreetView) {
            $form += array(
                'directions' => array(
                    '#type' => 'checkbox',
                    '#default_value' => !empty($settings['directions']),
                    '#title' => __('Enable directions search', 'directories'),
                    '#weight' => 10,
                ),
            );
        } else {
            $form['map_type_control']['#description'] = __(
                'This option is used for the map that is displayed when a street map view is not available for the specified location.',
                'directories'
            );
        }
        
        return $form;
    }

    protected function _fieldRendererRenderField(IField $field, array &$settings, IEntity $entity, array $values, $more = 0)
    {   
        if ($this->_isStreetView) {
            $settings = array('street_view' => true, 'directions' => false, 'infobox' => false) + $settings;
        }
        return $this->_renderMap($entity, $field, $values, $settings);
    }
    
    protected function _renderMap(IEntity $entity, IField $field, array $values, array $options)
    {        
        $id = 'drts-map-map-' . self::$_count++;
        $config = $this->_application->getComponent('Map')->getConfig('map');
        $marker_options = [
            'trigger' => '#' . $id . ' .drts-map-directions-destination',
            'trigger_event' => 'change',
            'size' => $config['marker_size'],
        ];
        if (!$markers = $this->_application->Map_Marker($entity, $field->getFieldName(), $id, $marker_options)) return;
        
        unset($config['api']);
        $options += array(
            'height' => 300,
        );
        $options += $config;

        if (empty($options['directions'])) {
            $this->_application->Map_Api_load(array('map' => true, 'style' => $options['style']));
            return sprintf(
                '<div id="%s" style="position:relative;">
    <div class="drts-map-container">
        <div class="drts-map-map" style="height:%dpx;"></div>
    </div>
</div>
<script type="text/javascript">
%s
</script>',
                $id,
                $options['height'],
                $this->_getJs($id, $markers, $options)
            );
        }
        
        $this->_application->Map_Api_load(array('map' => true, 'style' => $options['style']));
        $this->_application->getPlatform()
            ->addCssFile('map-directions.min.css', 'drts-map-directions', array('drts'), 'directories');
        $multi_address = count($markers) > 1; 
        if ($multi_address) {
            $addr_options = [];
            foreach (array_keys($markers) as $key) {
                $option = isset($values[$key]['address']) ? $this->_application->H($values[$key]['address']) : $values[$key]['lat'] . ',' . $values[$key]['lat'];
                $addr_options[] = '<option value="' . $key . '">' . $option . '</option>';
            }
            $addr_select = sprintf(
                '<div class="%1$smt-0 %1$smb-2 %1$salign-middle">
    <select class="drts-map-directions-destination %1$sform-control">
    %2$s
    </select>
</div>',
                DRTS_BS_PREFIX,
                implode(PHP_EOL, $addr_options)
            );
        } else {
            $addr_select = '<input type="hidden" value="0" class="drts-map-directions-destination" />';
        }
        return sprintf(
            '<div id="%1$s" style="position:relative;">
    <div class="drts-map-container">
        <div class="drts-map-map" style="height:%2$dpx;"></div>
    </div>
    <div class="drts-map-directions-panel" style="display:none;"></div>
    <form class="drts-map-directions %3$spx-2 %3$spt-2">
        <div class="drts-row">
            <div class="%4$s %3$smt-0 %3$smb-2 %3$salign-middle">
                <input type="text" class="%3$sform-control drts-map-directions-input" value="" placeholder="%5$s" />
            </div>
            %6$s
            <div class="%7$s %3$smt-0 %3$smb-2">
                <div class="%3$sbtn-group %3$sbtn-block %3$salign-middle">
                    <button class="%3$sbtn %3$sbtn-block %3$sbtn-primary drts-directory-btn-directions drts-map-directions-trigger">%8$s</button>
                    <button class="%3$sbtn %3$sbtn-primary %3$sdropdown-toggle %3$sdropdown-toggle-split" data-toggle="dropdown" aria-expanded="false"></button>
                    <div class="%3$sdropdown-menu %3$sdropdown-menu-right">
                        <a class="%3$sdropdown-item drts-map-directions-trigger" data-travel-mode="DRIVING">%9$s</a>
                        <a class="%3$sdropdown-item drts-map-directions-trigger" data-travel-mode="TRANSIT">%10$s</a>
                        <a class="%3$sdropdown-item drts-map-directions-trigger" data-travel-mode="WALKING">%11$s</a>
                        <a class="%3$sdropdown-item drts-map-directions-trigger" data-travel-mode="BICYCLING">%12$s</a>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script type="text/javascript">
%13$s
</script>',
            $id,
            $options['height'],
            DRTS_BS_PREFIX,
            $multi_address ? '' : ' drts-col-md-8',
            $this->_application->H(__('Enter a location', 'directories')),
            $addr_select,
            $multi_address ? '' : ' drts-col-md-4',
            $this->_application->H(__('Get Directions', 'directories')),
            $this->_application->H(__('By car', 'directories')),
            $this->_application->H(__('By public transit', 'directories')),
            $this->_application->H(__('Walking', 'directories')),
            $this->_application->H(__('Bicycling', 'directories')),
            $this->_getJs($id, $markers, $options)
        );
    }
    
    protected function _getJs($id, $markers, $options)
    {
        return sprintf(
            '%1$s
    var googlemaps = function (container) {
        var map = new DRTS.Map.map(
            container,
            %3$s
        );
        map.setMarkers(%4$s);
        if (%5$s) map.enableDirections();
        map.draw(%6$s);
    }
    var $map = $("#%2$s");
    if ($map.is(":visible")) {
        googlemaps($map);
    } else {
        var pane = $map.closest(".%7$stab-pane");
        if (pane.length) {
            $("#" + pane.attr("id") + "-trigger").on("shown.bs.tab", function(e, data){
                googlemaps($map);
            });
        }
    }
    $(DRTS).on("loaded.sabai", function (e, data) {
        if (data.target.find("#%2$s").length) {
            googlemaps();
        }
    });
});',
            Request::isXhr() ? 'jQuery(function ($) {' : 'document.addEventListener("DOMContentLoaded", function() { var $ = jQuery;',
            $id,
            $this->_application->JsonEncode(array(
                'marker_clusters' => false,
                'infobox' => !isset($options['infobox']) || $options['infobox'],
                'map_type_control' => !empty($options['map_type_control']),
                'zoom_control' => !empty($options['zoom_control']),
                'fullscreen_control' => !empty($options['fullscreen_control']),
            ) + $options),
            $this->_application->JsonEncode($markers),
            empty($options['directions']) ? 'false' : 'true',
            $this->_application->JsonEncode(array('street_view' => !empty($options['street_view']))),
            DRTS_BS_PREFIX
        );
    }
}