<?php
namespace SabaiApps\Directories\Component\Entity\Helper;

use SabaiApps\Directories\Application;
use SabaiApps\Directories\Component\Entity;

class TokensHelper
{
    public function help(Application $application, Entity\Model\Bundle $bundle)
    {
        $tokens = [
            '%id%',
            '%author_id%',
            '%timestamp%',
        ];
        return $application->Filter('entity_tokens', $tokens, [$bundle]);
    }

    public function replace(Application $application, $text, Entity\Type\IEntity $entity)
    {
        $replacements = [
            '%id%' => $entity->getId(),
            '%author_id%' => $entity->getAuthorId(),
            '%timestamp%' => $entity->getTimestamp(),
        ];

        return strtr($text, $application->Filter('entity_tokens_replace', $replacements, [$entity]));
    }
}
