<?php
namespace SabaiApps\Directories\Component\Entity\Helper;

use SabaiApps\Directories\Application;
use SabaiApps\Directories\Component\Entity;

class PermalinkUrlHelper
{
    protected $_paths = [];
    
    public function help(Application $application, Entity\Type\IEntity $entity, $fragment = '', $lang = null)
    {
        return $application->Url(array(
            'route' => $this->path($application, $entity, $lang),
            'params' => [],
            'fragment' => $fragment,
            'script' => 'main',
        ));
    }
    
    public function path(Application $application, Entity\Type\IEntity $entity, $lang = null)
    {
        $bundle = $application->Entity_Bundle($entity);
        if (!empty($bundle->info['parent'])) { // child entity bundles do not have custom permalinks
            return ($parent = $application->Entity_ParentEntity($entity, false))
                ? str_replace(':slug', $parent->getSlug(), $application->Entity_BundlePath($bundle, true, $lang)) . '/' . $entity->getId()
                : '';
        }
        return $application->Entity_BundlePath($bundle, true, $lang) . '/' . $entity->getSlug();
    }
}