<?php
namespace SabaiApps\Directories\Component\Entity\Helper;

use SabaiApps\Directories\Application;
use SabaiApps\Directories\Component\Entity;

class PageTitleHelper
{
    public function help(Application $application, Entity\Type\IEntity $entity, $withIcon = true)
    {
        $title = $application->Entity_Title($entity);
        $bundle = $application->Entity_Bundle($entity, null, '', true);
        if ($entity->getParentId()) {
            $title = sprintf(
                $bundle->getLabel('page'),
                $title,
                ($parent_entity = $application->Entity_ParentEntity($entity, false)) ? $application->Entity_Title($parent_entity) : ''
            );
        } elseif (empty($bundle->info['is_primary'])) {
            $title = sprintf($bundle->getLabel('page'), $title);
        }
        $title = $application->H($title);

        // Add icon?
        if ($withIcon
            && !empty($bundle->info['entity_icon'])
            && ($class = $application->Entity_Image_icon($entity, $bundle->info['entity_icon'], false))
        ) {
            $class .= ' fa-border';
            $class .= $application->getPlatform()->isRtl() ? ' fa-pull-left' : ' fa-pull-right';
            if (!empty($bundle->info['entity_color'])
                && ($color = $application->Entity_Image_color($entity, $bundle->info['entity_color']))
            ) {
                $style = 'background-color:' . $color . ';color:#fff;';
            } else {
                $style = '';
            }
            $title = '<i class="' . $class . '" style="' . $style . '"></i>' . $title;
        }
        
        return $application->Filter('entity_page_title', $title, [$withIcon]);
    }
}