<?php
/* This file has been auto-generated. Do not edit this file directly. */
namespace SabaiApps\Directories\Component\Display\Model\Base;

use SabaiApps\Framework\Model\Model;

abstract class ElementGateway extends \SabaiApps\Framework\Model\AbstractGateway
{
    public function getName()
    {
        return 'display_element';
    }

    public function getFields()
    {
        return ['element_name' => Model::KEY_TYPE_VARCHAR, 'element_weight' => Model::KEY_TYPE_INT, 'element_data' => Model::KEY_TYPE_TEXT, 'element_parent_id' => Model::KEY_TYPE_INT, 'element_system' => Model::KEY_TYPE_BOOL, 'element_id' => Model::KEY_TYPE_INT, 'element_created' => Model::KEY_TYPE_INT, 'element_updated' => Model::KEY_TYPE_INT, 'element_display_id' => Model::KEY_TYPE_INT];
    }

    protected function _getIdFieldName()
    {
        return 'element_id';
    }

    protected function _getSelectByIdQuery($id, $fields)
    {
        return sprintf(
            'SELECT %s FROM %sdisplay_element WHERE element_id = %d',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $id
        );
    }

    protected function _getSelectByIdsQuery($ids, $fields)
    {
        return sprintf(
            'SELECT %s FROM %sdisplay_element WHERE element_id IN (%s)',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            implode(', ', array_map('intval', $ids))
        );
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, $fields)
    {
        return sprintf(
            'SELECT %1$s FROM %2$sdisplay_element display_element WHERE %3$s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $criteriaStr
        );
    }

    protected function _getInsertQuery(&$values)
    {
        $values['element_created'] = time();
        $values['element_updated'] = 0;
        return sprintf('INSERT INTO %sdisplay_element(element_name, element_weight, element_data, element_parent_id, element_system, element_id, element_created, element_updated, element_display_id) VALUES(%s, %d, %s, %d, %u, %s, %d, %d, %d)', $this->_db->getResourcePrefix(), $this->_db->escapeString($values['element_name']), $values['element_weight'], $this->_db->escapeString(serialize($values['element_data'])), $values['element_parent_id'], $this->_db->escapeBool($values['element_system']), empty($values['element_id']) ? 'NULL' : intval($values['element_id']), $values['element_created'], $values['element_updated'], $values['element_display_id']);
    }

    protected function _getUpdateQuery($id, $values)
    {
        $last_update = $values['element_updated'];
        $values['element_updated'] = time();
        return sprintf('UPDATE %sdisplay_element SET element_name = %s, element_weight = %d, element_data = %s, element_parent_id = %d, element_system = %u, element_updated = %d, element_display_id = %d WHERE element_id = %d AND element_updated = %d', $this->_db->getResourcePrefix(), $this->_db->escapeString($values['element_name']), $values['element_weight'], $this->_db->escapeString(serialize($values['element_data'])), $values['element_parent_id'], $this->_db->escapeBool($values['element_system']), $values['element_updated'], $values['element_display_id'], $id, $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$sdisplay_element WHERE element_id = %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, $sets)
    {
        $sets['element_updated'] = 'element_updated=' . time();
        return sprintf('UPDATE %sdisplay_element display_element SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(', ', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE display_element FROM %1$sdisplay_element display_element WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$sdisplay_element display_element WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _afterInsert1($id, array $new)
    {
    }

    protected function _afterDelete1($id, array $old)
    {
    }

    protected function _afterUpdate1($id, array $new, array $old)
    {
    }

    protected function _afterInsert($id, array $new)
    {
        $this->_afterInsert1($id, $new);
    }

    protected function _afterUpdate($id, array $new, array $old)
    {
        $this->_afterUpdate1($id, $new, $old);
    }

    protected function _afterDelete($id, array $old)
    {
        $this->_afterDelete1($id, $old);
    }
}