<?php
namespace SabaiApps\Directories\Component\Display\Helper;

use SabaiApps\Directories\Application;
use SabaiApps\Directories\Component\Entity;

class ElementTypesHelper
{
    protected $_types = [];
    
    public function help(Application $application, Entity\Model\Bundle $bundle)
    {
        if (!isset($this->_types[$bundle->name])) {
            $types = [
                'field' => _x('Field', 'display element type', 'directories'),
            ];
            if (!empty($bundle->info['parent'])
                && ($parent_bundle = $application->Entity_Bundle($bundle->info['parent']))
            ) {
                $types['parent'] = $parent_bundle->getLabel('singular'); // parent entity bundle label 
            }
            $types += [
                'content' => _x('Content', 'display element type', 'directories'),
                'utility' => _x('Utility', 'display element type', 'directories'),
            ];

            $this->_types[$bundle->name] = $application->Filter('display_element_types', array_filter($types));
        }
        
        return $this->_types[$bundle->name];
    }
}