<?php
namespace SabaiApps\Directories\Component\CSV\Importer;

use SabaiApps\Directories\Component\Entity;

class FieldImporter extends AbstractImporter
{
    protected function _csvImporterInfo()
    {
        return array(
            'field_types' => array(substr($this->_name, 6)), // remove field_ part
        );
    }
    
    public function csvImporterSettingsForm(Entity\Model\Field $field, array $settings, $column, $enclosure, array $parents = [])
    {
        if ($this->_name === 'field_boolean') return;
        
        $form = $reserved_separator = [];
        
        switch ($this->_name) {                
            case 'field_video':
                $form += array(
                    'separator' => array(
                        '#type' => 'textfield',
                        '#title' => __('Video provider/ID separator', 'directories'),
                        '#description' => __('Enter the character used to separate the video provider and ID.', 'directories'),
                        '#default_value' => '|',
                        '#horizontal' => true,
                        '#min_length' => 1,
                        '#required' => true,
                        '#weight' => 1,
                    ),
                );
                $reserved_separator['separator'] = $form['separator']['#title'];
                break;
            case 'field_range':
                $form += array(
                    'separator' => array(
                        '#type' => 'textfield',
                        '#title' => __('Field min/max separator', 'directories'),
                        '#description' => __('Enter the character used to separate the minimum and maximum values.', 'directories'),
                        '#default_value' => '|',
                        '#horizontal' => true,
                        '#min_length' => 1,
                        '#required' => true,
                        '#weight' => 1,
                    ),
                );
                $reserved_separator['separator'] = $form['separator']['#title'];
                break;
            case 'field_date':
                $form += $this->_getDateFormatSettingsForm();
                break;
            case 'field_time':
                $form += array(
                    'separator' => array(
                        '#type' => 'textfield',
                        '#title' => __('Start/End/Day separator', 'directories'),
                        '#description' => __('Enter the character used to separate the starting time, ending time, and day of week.', 'directories'),
                        '#default_value' => '|',
                        '#horizontal' => true,
                        '#min_length' => 1,
                        '#required' => true,
                    ),
                );
                $form += $this->_getDateFormatSettingsForm();
                $reserved_separator['separator'] = $form['separator']['#title'];
                break;
            default:
        }
        
        if ($field->isCustomField()) {
            $form += $this->_acceptMultipleValues($enclosure, $parents, $reserved_separator);
        }
        
        return $form;
    }
    
    public function csvImporterDoImport(Entity\Model\Field $field, array $settings, $column, $value)
    {
        if ($this->_name === 'field_boolean') return array(array('value' => $value));
        
        if (!empty($settings['_multiple'])) {
            if (!$values = explode($settings['_separator'], $value)) {
                return;
            }
        } else {
            $values = array($value);
        }

        $ret = [];
        
        switch ($this->_name) {
            case 'field_video':
                foreach ($values as $value) {
                    if ($value = explode($settings['separator'], $value)) {
                        $ret[] = array(
                            'id' => $value[1],
                            'provider' => $value[0],
                        );
                    }
                }
                break;
            case 'field_range':
                foreach ($values as $value) {
                    if ($value = explode($settings['separator'], $value)) {
                        $ret[] = array(
                            'min' => $value[0],
                            'max' => $value[1],
                        );
                    }
                }
                break;
            case 'field_date':
                if ($settings['date_format'] === 'string') {
                    foreach ($values as $value) {
                        if (false !== $value = strtotime($value)) {
                            $ret[] = $value;
                        }
                    }
                } else {
                    foreach ($values as $value) {
                        $ret[] = $value;
                    }
                }
                break;
            case 'field_time':
                if ($settings['date_format'] === 'string') {
                    foreach ($values as $value) {
                        $value = explode($settings['separator'], $value);
                        if (!$value[0]) continue;
                
                        $ret[] = array(
                            'start' => $value[0],
                            'end' => false !== ($value[1] = strtotime($value[1])) ? $value[1] : null,
                            'day' => (string)@$value[2],
                        );
                    }
                } else {
                    foreach ($values as $value) {
                        $value = explode($settings['separator'], $value);
                        if (!$value[0]) continue;
                
                        $ret[] = array(
                            'start' => $value[0],
                            'end' => strlen($value[1]) ? $value[1] : null,
                            'day' => (string)@$value[2],
                        );
                    }
                }
                break;
            default:
                foreach ($values as $value) {
                    $ret[] = array('value' => $value);
                }
        }
        
        return $ret;
    }
}