<?php
namespace SabaiApps\Directories\Component\WordPress\Helper;

use SabaiApps\Directories\Application;

class RolesHelper
{
    protected $_rolesEnabled;
    
    public function help(Application $application)
    { 
        $ret = [];
        if (!isset($this->_rolesEnabled)) {
            $this->_rolesEnabled = $application->Filter('wordpress_roles', array('administrator', 'editor', 'author', 'contributor', 'subscriber'));
            foreach ($application->getPlatform()->getAdministratorRoles() as $admin_role_name) {
                if (!in_array($admin_role_name, $this->_rolesEnabled)) {
                    $this->_rolesEnabled[] = $admin_role_name;
                }
            }
        }
        $roles = wp_roles()->roles;
        foreach (array_keys($roles) as $role_name) {
            if (in_array($role_name, $this->_rolesEnabled)) {
                $ret[$role_name] = $roles[$role_name];
            }
        }
        return $ret;
    }
}