<?php
namespace SabaiApps\Directories\Component\System\Helper;

use SabaiApps\Directories\Application;

class DateHelper
{
    public function help(Application $application, $timestamp, $html = false)
    {
        return $this->_render($application, $application->getPlatform()->getDateFormat(), $timestamp, $html);
    }

    public function time(Application $application, $timestamp, $html = false)
    {
        return $this->_render($application, $application->getPlatform()->getTimeFormat(), $timestamp, $html);
    }

    public function datetime(Application $application, $timestamp, $html = false)
    {
        return $this->_render(
            $application,
            $application->getPlatform()->getDateFormat() . ' ' . $application->getPlatform()->getTimeFormat(),
            $timestamp,
            $html
        );
    }

    protected function _render(Application $application, $format, $timestamp, $html = false)
    {
        $ret = $application->getPlatform()->getDate($format, $timestamp);
        if ($html) {
            $ret = '<time class="drts-datetime" datetime="' . date('c' , $timestamp) . '">' . $ret . '</time>';
        }
        return $ret;
    }
}
