'use strict';

(function($) {
  DRTS.Map = DRTS.Map || {};
  DRTS.Map.autocomplete = DRTS.Map.autocomplete || function(input, options) {
    if (typeof google === 'undefined' || !google.maps.places) return;

    var $input = $(input);
    if (!$input.length) return;
    options = options || {};
    options.types = ['geocode'];
    if (options.country) {
      options.componentRestrictions = options.componentRestrictions || {};
      options.componentRestrictions.country = options.country;
    }
    $input.each(function() {
      var ele = $(this).get(0);
      google.maps.event.addDomListener(ele, 'focus', function(e) {
        var autocomplete = new google.maps.places.Autocomplete(ele, options);
        if (options.markerMap) {
          autocomplete.addListener('place_changed', function() {
            $(options.markerMap).find('.drts-map-field-find-on-map').click();
          });
        }
      });
      google.maps.event.addDomListener(ele, 'keydown', function(e) {
        if (e.keyCode === 13) {
          e.preventDefault();
        }
      });
    });
  };
  DRTS.Map.geolocate = DRTS.Map.geolocate || function(input, options) {
    var $input = $(input);
    if (!$input.length) return;

    var container = $input.parent();
    if (navigator.geolocation && (document.location.protocol === 'https:' || document.location.hostname === 'localhost')) {
      if (!container.find('.drts-map-location-geolocate').length) {
        container.css('position', 'relative').append($('<span class="drts-map-location-geolocate"><i class="fas fa-crosshairs"></i></span>'));
      }
      container.find('.drts-map-location-geolocate').css('cursor', 'pointer').click(function(e) {
        var $this = $(this),
          geocoder;
        $this.find('> i').addClass('fa-spin');
        geocoder = new google.maps.Geocoder();
        navigator.geolocation.getCurrentPosition(function(pos) {
          $this.find('> i').removeClass('fa-spin');
          geocoder.geocode({
            latLng: new google.maps.LatLng(pos.coords.latitude, pos.coords.longitude)
          }, function(results, status) {
            if (status == google.maps.GeocoderStatus.OK) {
              $input.val(results[0].formatted_address);
              if (options.callback) {
                options.callback(new google.maps.LatLng(results[0].geometry.location.lat(), results[0].geometry.location.lng()));
              }
            }
          });
        }, function(error) {
          $this.find('> i').removeClass('fa-spin');
          DRTS.popover($this, {
            content: error.message + ' (' + error.code + ')'
          }, true);
        }, {
          enableHighAccuracy: true,
          timeout: 5000
        });
        return false;
      });
    } else {
      container.addClass('drts-location-no-geolocation');
    }
  };
})(jQuery);