<?php
namespace SabaiApps\Directories\Component\Location\CSVImporter;

use SabaiApps\Directories\Component\CSV\Importer\AbstractImporter;
use SabaiApps\Directories\Component\Entity\Model\Field;
use SabaiApps\Directories\Exception;

class LocationCSVImporter extends AbstractImporter
{
    protected static $_geocodeCount = 0;
    
    protected function _csvImporterInfo()
    {
        switch ($this->_name) {
            case 'location_address':
                return array(
                    'field_types' => array($this->_name),
                    'columns' => array(
                        'address' => __('Full Address', 'directories-pro'),
                        'street' => __('Address Line 1', 'directories-pro'),
                        'street2' => __('Address Line 2', 'directories-pro'),
                        'city' => __('City', 'directories-pro'),
                        'province' => __('State / Province / Region', 'directories-pro'),
                        'zip' => __('Postal / Zip Code', 'directories-pro'),
                        'country' => __('Country', 'directories-pro'),
                        'lat' => __('Latitude', 'directories-pro'),
                        'lng' => __('Longitude', 'directories-pro'),
                        'zoom' => __('Zooom Level', 'directories-pro'),
                        'term_id' => __('Location Taxonomy Term', 'directories-pro'),
                    ),
                );
        }
    }
    
    public function csvImporterSettingsForm(Field $field, array $settings, $column, $enclosure, array $parents = [])
    {
        switch ($this->_name) {
            case 'location_address':
                $form = [];
                if ($column === 'address') {
                    $form += array(
                        'geocode' => array(
                            '#type' => 'checkbox',
                            '#title' => __('Geocode address', 'directories-pro'),
                            '#description' => __('Use the Google geocoding service to resolve the latitude/longitude coordinate from the address. This will populate all other address components of the field.', 'directories-pro'),
                            '#default_value' => true,
                            '#horizontal' => true,
                        ),
                    );
                } elseif ($column === 'term_id') {
                    $form += array(
                        'type' => array(
                            '#type' => 'select',
                            '#title' => __('Taxonomy term data type', 'directories-pro'),
                            '#description' => __('Select the type of data used to specify terms.', 'directories-pro'),
                            '#options' => array(
                                'id' => __('ID', 'directories-pro'),
                                'slug' => __('Slug', 'directories-pro'),
                                'title' => __('Title', 'directories-pro'),
                            ),
                            '#default_value' => 'slug',
                            '#horizontal' => true,
                        ),
                    );
                }
        
                return $form + $this->_acceptMultipleValues($enclosure, $parents);
        }
    }
    
    public function csvImporterDoImport(Field $field, array $settings, $column, $value)
    {
        switch ($this->_name) {
            case 'location_address':
                if (!empty($settings['_multiple'])) {
                    if (!$values = explode($settings['_separator'], $value)) {
                        return;
                    }
                } else {
                    $values = array($value);
                }
                $ret = [];
        
                switch ($column) {
                    case 'address':
                        foreach ($values as $value) {
                            $value = trim($value);
                            if (!strlen($value)) continue;
                            
                            $value = array(
                                'address' => $value,
                            );
                            if ($settings['geocode']) {
                                try {
                                    $geocode_result = $this->_application->Map_Api_geocode($value['address'], false);
                                } catch (Exception\IException $e) {
                                    $this->_application->logError($e);
                                    continue;
                                }
                                $value += array(
                                    'city' => $geocode_result['city'],
                                    'province' => $geocode_result['province'],
                                    'zip' => $geocode_result['zip'],
                                    'country' => $geocode_result['country'],
                                    'lat' => $geocode_result['lat'],
                                    'lng' => $geocode_result['lng'],
                                );
                                ++self::$_geocodeCount;
                                if (self::$_geocodeCount % 10 === 0) {
                                    sleep(1); // this is to prevent rate limit of 10 requests per second
                                }
                            }
                            $ret[] = $value;
                        }
                        break;
                    case 'term_id':
                        switch ($settings['type']) {
                            case 'slug':
                            case 'title':
                                if ((!$location_bundle_name = $field->Bundle->info['taxonomies']['location_location'])
                                    || (!$location_bundle = $this->_application->Entity_Bundle($location_bundle_name))
                                ) return;

                                if ($settings['type'] === 'title') {
                                    $terms = $this->_application->Entity_Types_impl($location_bundle->entitytype_name)
                                        ->entityTypeEntitiesByTitles($location_bundle->name, $values);
                                } else {
                                    $terms = $this->_application->Entity_Types_impl($location_bundle->entitytype_name)
                                        ->entityTypeEntitiesBySlugs($location_bundle->name, $values);
                                }
                                foreach ($terms as $term) {
                                    $ret[] = array('term_id' => $term->getId());
                                }
                                break;
                            case 'id':
                                foreach ($values as $value) {
                                    $ret[] = array('term_id' => $value);
                                }
                                break;
                        }
                        break;
                    default:
                        foreach ($values as $value) {
                            $ret[] = array($column => $value);
                        }
                }
        
                return $ret;
        }
    }
}