<?php
namespace SabaiApps\Directories\Component\FrontendSubmit\Controller;

use SabaiApps\Directories\Context;
use SabaiApps\Directories\Component\Form;

class AddChildEntity extends AbstractAddEntity
{
    protected function _getSteps(Context $context, array &$formStorage)
    {
        if ($this->getUser()->isAnonymous()) {
            if (!$this->Entity_IsRoutable($context->child_bundle, 'add', $context->entity)
                || $this->_isGuestInfoRequired($context, $formStorage)
            ) {
                return $this->_redirectGuest($context, $formStorage, $context->child_bundle, $context->entity);
            }
        } else {
            if (!$this->Entity_IsRoutable($context->child_bundle, 'add', $context->entity)) {
                return;
            }
        }

        return parent::_getSteps($context, $formStorage);
    }

    public function _getFormForStepAdd(Context $context, array &$formStorage)
    {
        $parent_url = $this->Entity_Url($context->entity);
        $this->_cancelUrl = $parent_url;
        $form = parent::_getFormForStepAdd($context, $formStorage);
        $form['#action'] = $this->Entity_Url($context->entity, '/' . $context->child_bundle->info['slug'] . (empty($context->child_bundle->info['public']) ? '_add' : '/add'));
        // Remove parent field
        if (isset($form['#wrap'])) {
            $_form =& $form[$form['#wrap']];
        } else {
            $_form =& $form;
        }
        unset($_form[$context->entity->getType() . '_parent']);

        return $form;
    }

    protected function _getBundle(Context $context, array $formStorage)
    {
        return $context->child_bundle;
    }

    protected function _getEntityValues(Context $context, Form\Form $form)
    {
        $values = parent::_getEntityValues($context, $form);
        unset($values['slug']); // this comes from the URL path
        $values['parent'] = $context->entity->getId();

        return $values;
    }
}
