<?php
namespace SabaiApps\Directories\Component\WordPressContent\FieldRenderer;

use SabaiApps\Directories\Component\Field;
use SabaiApps\Directories\Component\Entity;

class PostContentFieldRenderer extends Field\Renderer\TextRenderer
{
    protected function _fieldRendererInfo()
    {
        $ret = parent::_fieldRendererInfo();
        $ret['field_types'] = array($this->_name);
        $ret['separatable'] = false;
        return $ret;
    }
    
    protected function _fieldRendererSettingsForm(Field\IField $field, array $settings, array $parents = [])
    {
        $ret = parent::_fieldRendererSettingsForm($field, $settings, $parents);
        unset($ret['trim_marker'], $ret['trim_link']);
        return $ret;
    }
    
    protected function _getContent($value, array $settings, Entity\Type\IEntity $entity)
    {
        setup_postdata($entity->getId());
        $value = str_replace(']]>', ']]&gt;', apply_filters('the_content', get_the_content()));
        wp_reset_postdata();

        return $value;
    }
    
    protected function _getTrimmedContent($value, $length, $marker, $link, array $settings, Entity\Type\IEntity $entity)
    {
        // Render excerpt without tirm marker
        setup_postdata($entity->getId());
        $callback = function () { return ''; };
        add_filter('excerpt_more', $callback);
        $value = apply_filters('the_excerpt', get_the_excerpt());
        remove_filter('excerpt_more', $callback);
        wp_reset_postdata();
        
        // Add WordPress trim marker
        $marker = apply_filters('excerpt_more', ' ' . '[&hellip;]');
        
        return parent::_getTrimmedContent($value, $length, $marker, $link, $settings, $entity);
    }
    
    protected function _fieldRendererReadableSettings(Field\IField $field, array $settings)
    {
        $ret = (array)parent::_fieldRendererReadableSettings($field, $settings);
        unset($ret['trim_marker'], $ret['trim_link']);
        return $ret;
    }
}