<?php
namespace SabaiApps\Directories\Component\Field\Renderer;

use SabaiApps\Directories\Component\Entity;
use SabaiApps\Directories\Component\Field\IField;

class IconRenderer extends AbstractRenderer
{
    protected function _fieldRendererInfo()
    {
        return array(
            'field_types' => array($this->_name),
            'default_settings' => array(
                'size' => '',
                'color' => null,
            ),
        );
    }

    protected function _fieldRendererSettingsForm(IField $field, array $settings, array $parents = [])
    {
        return [
            'size' => [
                '#type' => 'select',
                '#title' => __('Icon size', 'directories'),
                '#default_value' => $settings['size'],
                '#options' => $this->_application->System_Util_iconSizeOptions(),
            ],
            'color' => [
                '#type' => 'select',
                '#title' => __('Icon color', 'directories'),
                '#default_value' => $settings['color'],
                '#options' => $this->_application->System_Util_fieldOptions($field->Bundle, 'entity_color') + [
                    '_custom' => __('Choose a color', 'directories'),
                    '' => __('Default', 'directories')
                ],
            ],
            'custom_color' => [
                '#type' => 'colorpicker',
                '#default_value' => $settings['custom_color'],
                '#states' => [
                    'visible' => [
                        sprintf('select[name="%s"]', $this->_application->Form_FieldName(array_merge($parents, ['color']))) => [
                            'value' => '_custom',
                        ],
                    ],
                ],
            ],
        ];
    }

    protected function _fieldRendererRenderField(IField $field, array &$settings, Entity\Type\IEntity $entity, array $values, $more = 0)
    {
        if ($settings['color'] === '_custom') {
            $color = $settings['custom_color'];
        } else {
            if ($settings['color'] !== ''
                && ($_color = $entity->getSingleFieldValue($settings['color']))
            ) {
                $color = $_color;
            }
        }
        $class = $values[0] . ' drts-icon';
        if ($settings['size']) {
            $class .= ' drts-icon-' . $settings['size'];
        }
        $style = empty($color) ? '' : 'style="background-color:' . $color . ';color:#fff;"';
        return '<i ' . $style . ' class="' . $this->_application->H($class) . '"></i>';
    }
    
    protected function _fieldRendererReadableSettings(IField $field, array $settings)
    {
        return [
            'size' => [
                'label' => __('Icon size', 'directories'),
                'value' => $this->_application->System_Util_iconSizeOptions()[$settings['size']],
            ],
        ];
    }
}