<?php
namespace SabaiApps\Directories\Component\Entity\Helper;

use SabaiApps\Directories\Application;
use SabaiApps\Directories\Component\Entity;

class ImageHelper
{
    public function url(Application $application, Entity\Type\IEntity $entity, $size = 'medium', $fieldName = null)
    {
        
        if (!isset($fieldName)
            && (!$fieldName = $application->Entity_BundleTypeInfo($entity->getBundleType(), 'entity_image'))
        ) return;
        
        if ((!$value = $entity->getSingleFieldValue($fieldName))
             || (!$field_type = $application->Field_Type($entity->getFieldType($fieldName), true))
             || !$field_type instanceof \SabaiApps\Directories\Component\Field\Type\IImage
        ) return;
        
        switch ($size) {
            case 'icon':
                return $field_type->fieldImageGetIconUrl($value);
            case 'icon_lg':
                return $field_type->fieldImageGetIconUrl($value, 'lg');
            case 'icon_xl':
                return $field_type->fieldImageGetIconUrl($value, 'xl');
            case 'full':
                return $field_type->fieldImageGetFullUrl($value);
            default:
                return $field_type->fieldImageGetUrl($value, $size);
        }
    }
    
    public function icon(Application $application, Entity\Type\IEntity $entity, $fieldName = null, $fallbackBundleIcon = true)
    {
        if (isset($fieldName)
            || ($fieldName = $application->Entity_BundleTypeInfo($entity->getBundleType(), 'entity_icon'))
        ) {
            if ($icon = $entity->getSingleFieldValue($fieldName)) return $icon;
        }
        return $fallbackBundleIcon ? $application->Entity_BundleTypeInfo($entity->getBundleType(), 'icon') : null;
    }
    
    public function color(Application $application, Entity\Type\IEntity $entity, $fieldName = null)
    {
        if (isset($fieldName)
            || ($fieldName = $application->Entity_BundleTypeInfo($entity->getBundleType(), 'entity_color'))
        ) {
            return $entity->getSingleFieldValue($fieldName);
        }
    }
}