<?php
namespace SabaiApps\Directories\Component\Entity\DisplayElement;

use SabaiApps\Directories\Component\Entity;
use SabaiApps\Directories\Component\Display;

class FieldListDisplayElement extends Display\Element\AbstractElement
{
    protected function _displayElementInfo(Entity\Model\Bundle $bundle)
    {
        return array(
            'type' => 'utility',
            'label' => _x('Field List', 'display element name', 'directories'),
            'description' => __('Display fields as a list', 'directories'),
            'default_settings' => [
                'size' => '',
                'no_border' => false,
            ],
            'child_element_type' => 'field',
            'add_child_label' => __('Add Field', 'directories'),
            'containable' => true,
            'icon' => 'fas fa-list',
        );
    }
    
    protected function _displayElementSupports(Entity\Model\Bundle $bundle, Display\Model\Display $display)
    {
        return $display->type === 'entity';
    }
    
    protected function _getSizeOptions()
    {
        return [
            'sm' => __('Small', 'directories'),
            '' => __('Medium', 'directories'),
        ];
    }
    
    public function displayElementSettingsForm(Entity\Model\Bundle $bundle, array $settings, Display\Model\Display $display, array $parents = [], $tab = null, $isEdit = false, array $submitValues = [])
    {
        return [
            'size' => [
                '#type' => 'select',
                '#title' => __('Size', 'directories'),
                '#options' => $this->_getSizeOptions(),
                '#default_value' => $settings['size'],
                '#horizontal' => true,
            ],
            'no_border' => [
                '#type' => 'checkbox',
                '#title' => __('No border', 'directories'),
                '#default_value' => !empty($settings['no_border']),
                '#horizontal' => true,
                '#states' => [
                    'invisible' => [
                        sprintf('select[name="%s"]', $this->_application->Form_FieldName(array_merge($parents, ['size']))) => ['value' => 'sm'],
                    ],
                ],
            ],
        ];
    }

    public function displayElementRender(Entity\Model\Bundle $bundle, array $element, array $display, $var, array $displayOptions, array &$states, $parent = null)
    {   
        if (empty($element['children'])) return;

        $bundle = $this->_application->Entity_Bundle($var);        
        $html = [];
        $value_text_align_class = DRTS_BS_PREFIX . ($this->_application->getPlatform()->isRtl() ? 'text-left' : 'text-right'); 
        foreach ($element['children'] as $child) {
            $label_is_no_text = $child['settings']['label'] === 'icon' || $child['settings']['label'] === 'none';
            $child['settings']['label'] = 'none';
            if (!$field_value = $this->_application->callHelper('Display_Render_element', array($bundle, $child, $display, $var, $displayOptions, &$states, $this->_name))) continue;

            $html[] = '<div class="' . DRTS_BS_PREFIX . 'list-group-item ' . DRTS_BS_PREFIX . 'px-0">';
            if ($element['settings']['size'] !== 'sm'
                && !$label_is_no_text
            ) {
                $html[] = '<div class="drts-entity-field ' . DRTS_BS_PREFIX . 'justify-content-between">';
                $add_value_text_align_class = true;
            } else {
                $html[] = '<div class="drts-entity-field">';
                $add_value_text_align_class = false;
            }
            $html[] = '<div class="drts-entity-field-label">' . $child['title'] . '</div>';
            $html[] = $add_value_text_align_class
                ? '<div class="drts-entity-field-value ' . $value_text_align_class . '">' . $field_value . '</div>'
                : '<div class="drts-entity-field-value">' . $field_value . '</div>';
            $html[] = '</div></div>';
        }
        if (empty($html)) return '';
        
        $class = 'drts-entity-fieldlist';
        if ($element['settings']['size'] === 'sm') {
            $class .= ' drts-entity-fieldlist-sm';
        } elseif (!empty($element['settings'])) {
            $class .= ' drts-entity-fieldlist-no-border';
        }
        
        return '<div class="' . DRTS_BS_PREFIX . 'list-group ' . DRTS_BS_PREFIX . 'list-group-flush ' . $class . '">' . implode(PHP_EOL, $html) . '</div>';
    }
    
    public function displayElementReadableSettings(Entity\Model\Bundle $bundle, array $settings)
    {
        $ret = [
            'size' => [
                'label' => __('Size', 'directories'),
                'value' => $this->_getSizeOptions()[$settings['size']],
            ],
        ];
        if (!empty($settings['no_border'])) {
            $ret['no_border'] = [
                'label' => __('No border', 'directories'),
                'value' => true,
                'is_bool' => true,
            ];
        }
        
        return $ret;
    }
}