<?php
namespace SabaiApps\Directories\Component\CSV\Importer;

use SabaiApps\Directories\Component\Entity;

class WPImporter extends AbstractImporter
{    
    protected $_fileDir = [];
    protected static $_files = [];
    
    public function csvImporterSettingsForm(Entity\Model\Field $field, array $settings, $column, $enclosure, array $parents = [])
    {
        switch ($this->_name) {
            case 'wp_post_parent':
                return array(
                    'type' => array(
                        '#type' => 'select',
                        '#title' => __('Parent content ID type', 'directories'),
                        '#description' => __('Select the type of data used to specify parent content items.', 'directories'),
                        '#options' => array(
                            'id' => __('ID', 'directories'),
                            'slug' => __('Slug', 'directories'),
                        ),
                        '#default_value' => 'slug',
                        '#horizontal' => true,
                    ),
                );
            case 'wp_image':
            case 'wp_file':
                $form = array(
                    'location' => array(
                        '#type' => 'select',
                        '#title' => __('File location', 'directories'),
                        '#options' => array(
                            'upload' => __('Upload zip archive', 'directories'),
                            'local' => __('Local folder', 'directories'),
                        ),
                        '#options_description' => array(
                            'upload' => __('Upload a zip archive file containing all files.', 'directories'),
                            'local' => __('Specify the path to the directory where all files are located.', 'directories'),
                        ),
                        '#default_value' => 'upload',
                    ),
                    'file' => array(
                        '#type' => 'file',
                        '#title' => __('Upload zip archive', 'directories'),
                        '#upload_dir' => get_temp_dir(),
                        '#allowed_extensions' => array('zip'),
                        '#states' => array(
                            'visible' => array(
                                sprintf('[name="%s[location]"]', $this->_application->Form_FieldName($parents)) => array('value' => 'upload'),
                            ),
                        ),
                        '#required' => function($form) use ($parents) { return $form->getValue(array_merge($parents, array('location'))) === 'upload'; },
                    ),
                    'local' => array(
                        '#title' => __('Local folder', 'directories'),
                        '#type' => 'textfield',
                        '#states' => array(
                            'visible' => array(
                                sprintf('[name="%s[location]"]', $this->_application->Form_FieldName($parents)) => array('value' => 'local'),
                            ),
                        ),
                        '#placeholder' => '/path/to/local/folder',
                        '#required' => function($form) use ($parents) { return $form->getValue(array_merge($parents, array('location'))) === 'local'; },
                    ),
                );
                $form += $this->_acceptMultipleValues($enclosure, $parents);
                return $form;
        }
    }
    
    public function csvImporterDoImport(Entity\Model\Field $field, array $settings, $column, $value)
    {
        switch ($this->_name) {
            case 'wp_post_content':
            case 'wp_post_status':
            case 'wp_term_description':
                return $value;
            case 'wp_post_parent':
                if ($settings['type'] === 'slug') {
                    if (!isset($this->_parentBundle)
                        && (!$this->_parentBundle = $this->_application->Entity_Bundle($field->Bundle->info['parent']))
                    ) return false;
                    
                    if (!$entity = $this->_application->Entity_Types_impl($this->_parentBundle->entitytype_name)
                        ->entityTypeEntityBySlug($this->_parentBundle->name, $value)
                    ) return;
                    
                    return $entity->getId();
                } else {
                    return $value;
                }   
            case 'wp_image':
            case 'wp_file':
                if (!empty($settings['_multiple'])) {
                    if (!$values = explode($settings['_separator'], $value)) return;
                } else {
                    $values = array($value);
                }
        
                $field_name = $field->getFieldName();
                if (!isset($this->_fileDir[$field_name])) {
                    if (!$this->_fileDir[$field_name] = $this->_getUploadDir($settings)) {
                        $this->_fileDir[$field_name] = false;
                    }
                }
                if (!$this->_fileDir[$field_name]) return;
            
                return $this->_saveFiles($settings, $values, $this->_fileDir[$field_name]);
        }
    }
    
    protected function _getUploadDir(array $settings)
    {   
        if ($settings['location'] === 'local') {
            return @is_dir($settings['local']) ? rtrim($settings['local'], '/') : null;
        }
            
        if ($settings['location'] !== 'upload') return;        
        
        $ret = null;
        if ($archive = @$settings['file']['saved_file_path']) {
            $this->_application->getPlatform()->unzip($archive, dirname($archive));
            $possible_file_dir = array(
                dirname($archive) . '/' . substr($settings['file']['name'], 0, -1 * (strlen($settings['file']['file_ext']) + 1)), // check sub directory with folder name
                dirname($archive)
            );
            foreach ($possible_file_dir as $file_dir) {
                if (@is_dir($file_dir)) {
                    $ret = $file_dir;
                    break;
                }
            }
        }
        @unlink($settings['file']['saved_file_path']);
        
        return rtrim($ret, '/');
    }

    protected function _saveFiles(array $settings, array $values, $tmpDir)
    {
        $ret = [];
        foreach ($values as $value) {
            if (isset(self::$_files[$value])) {
                $ret[$value] = self::$_files[$value];
                continue;
            }

            $file_path = $tmpDir . '/' . $value;
            if (!file_exists($file_path)) continue;

            $file = array(
                'tmp_name' => $file_path,
                'name' => $value,
            );
            $id = media_handle_sideload($file, 0);
            if (is_wp_error($id)) {
                $this->_application->logError($id->get_error_message());
                continue;
            }

            self::$_files[$value] = $ret[$value] = $id;
        }

        return array_values($ret);
    }
}