<?php
namespace SabaiApps\Directories\Component\CSV\Importer;

use SabaiApps\Directories\Component\Entity;

class VotingImporter extends AbstractImporter
{
    public function csvImporterSupports(Entity\Model\Bundle $bundle, Entity\Model\Field $field)
    {
        return !empty($bundle->info[$this->_name])
            && (!isset($bundle->info[$this->_name]['csv']) || !empty($bundle->info[$this->_name]['csv']));
    }
    
    public function csvImporterDoImport(Entity\Model\Field $field, array $settings, $column, $value)
    {
        if (false === $value = unserialize($value)) return;
        
        switch ($this->_name) {
            case 'voting_default':
            case 'voting_rating':
                $ret = [];
                foreach ($value as $name => $_value) {
                    $ret[] = $_value + array('name' => $name);
                }
                return $ret;
            default:
                return array($value);
        }
    }
}