<?php
namespace SabaiApps\Directories\Component\CSV\Importer;

use SabaiApps\Directories\Component\Entity\Model\Field;

class MapImporter extends AbstractImporter
{    
    protected function _csvImporterInfo()
    {
        switch ($this->_name) {
            case 'map_map':
                return array(
                    'field_types' => array($this->_name),
                    'columns' => array(
                        'lat' => __('Latitude', 'directories'),
                        'lng' => __('Longitude', 'directories'),
                        'zoom' => __('Zooom Level', 'directories'),
                    ),
                );
        }
    }
    
    public function csvImporterSettingsForm(Field $field, array $settings, $column, $enclosure, array $parents = [])
    {
        switch ($this->_name) {
            case 'map_map':
                return $this->_acceptMultipleValues($enclosure, $parents);
        }
    }
    
    public function csvImporterDoImport(Field $field, array $settings, $column, $value)
    {
        switch ($this->_name) {
            case 'map_map':
                if (!empty($settings['_multiple'])) {
                    if (!$values = explode($settings['_separator'], $value)) {
                        return;
                    }
                } else {
                    $values = array($value);
                }
                $ret = [];
                foreach ($values as $value) {
                    $ret[] = array($column => $value);
                }
        
                return $ret;
        }
    }
}