<?php
namespace SabaiApps\Directories\Component\Dashboard\DisplayButton;

use SabaiApps\Directories\Component\Display;
use SabaiApps\Directories\Component\Entity;
use SabaiApps\Directories\Application;

abstract class AbstractPostDisplayButton extends Display\Button\AbstractButton
{    
    protected $_route, $_modalDanger, $_allowGuest;
    
    public function __construct(Application $application, $name, $route, $modalDanger = false, $allowGuest = false)
    {
        parent::__construct($application, $name);
        $this->_route = $route;
        $this->_modalDanger = (bool)$modalDanger;
        $this->_allowGuest = (bool)$allowGuest;
    }
    
    public function displayButtonLink(Entity\Model\Bundle $bundle, array $display, Entity\Type\IEntity $entity, array $settings)
    {
        if (!$this->_application->Entity_IsAuthor($entity) // dashboard should allow own content only
            || !$this->_application->Entity_IsRoutable($bundle, $this->_route, $entity)
        ) return;
        
        if ($this->_application->getUser()->isAnonymous()) {
            if (!$this->_allowGuest) return;
            
            return; // @todo create pages for guest users to edit/delete posts
        }

        $label = $this->_getLabel($bundle, $entity, $settings);
        $options = [
            'icon' => $settings['_icon'],
        ];
        $attr = [
            'class' => $settings['_class'],
            'style' => $settings['_style'],
            'data-modal-title' => $label . ' - ' . $entity->getTitle(),
            'data-modal-danger' => empty($this->_modalDanger) ? 0 : 1,
        ];
        if ($this->_route !== 'edit') {
            $this->_application->getPlatform()->addJsFile('form.min.js', 'drts-form', array('drts'), null, true); // for modal form
            $options['container'] = 'modal';
        } elseif ($display['name'] === 'dashboard_row') {
            //if ($this->_route === 'edit') {
            //    $options['container'] = 'drts-dashboard-main';
            //} else {
                $options['container'] = 'modal';
            //}
        }
        
        return $this->_application->LinkTo(
            $label,
            $this->_getUrl($bundle, $display, $entity, $settings),
            $options,
            $attr
        );
    }
    
    protected function _getUrl(Entity\Model\Bundle $bundle, array $display, Entity\Type\IEntity $entity, array $settings)
    {
        $params = [];
        if ($display['name'] !== 'dashboard_row') $params['redirect'] = 1;
        if ($this->_route === 'edit') {
            if ($display['name'] === 'dashboard_row') {
                return $this->_application->getComponent('Dashboard')->getPostsPanelUrl($bundle, '/posts/' . $entity->getId(), $params, true);
            }
            $params['post_id'] = $entity->getId(); // Go to dashboard and then open in modal
            return $this->_application->getComponent('Dashboard')->getPostsPanelUrl($bundle, '', $params);                
        }
        return $this->_application->getComponent('Dashboard')->getPostsPanelUrl($bundle, '/posts/' . $entity->getId() . '/' . $this->_route, $params, true);
    }
    
    protected function _getLabel(Entity\Model\Bundle $bundle, Entity\Type\IEntity $entity, array $settings)
    {
        return $settings['_label'];
    }
}