<?php
namespace SabaiApps\Directories\Component\Payment\Controller;

use SabaiApps\Directories\Component\FrontendSubmit;
use SabaiApps\Directories\Context;
use SabaiApps\Directories\Component\Form;
use SabaiApps\Directories\Component\Entity;

class AddEntity extends FrontendSubmit\Controller\AddEntity
{
    protected $_reloadStepsOnNextStep = true;

    protected function _hideSelectPlan(Context $context, array &$formStorage)
    {
        if (!isset($formStorage['hide_select_plan'])) {
            $formStorage['hide_select_plan'] = false;
            if (($plan_id = $context->getRequest()->asStr('plan'))
                && ($payment_component = $this->_getPaymentComponent(false))
                && ($plan = $payment_component->paymentGetPlan($plan_id))
                && $plan->paymentPlanType() === 'base'
                && ($bundle = $this->_getBundle($context, $formStorage))
                && $plan->paymentPlanBundleName() === $bundle->name
            ) {
                $formStorage['hide_select_plan']= $plan_id;
            }
        }
        return $formStorage['hide_select_plan'];
    }

    protected function _getPaymentComponent($throwError = true)
    {
        return $this->getComponent('Payment')->getPaymentComponent($throwError);
    }

    protected function _getSteps(Context $context, array &$formStorage)
    {
        if (false === $steps = parent::_getSteps($context, $formStorage)) return false;

        if (!$this->_isPaymentEnabled($context, $formStorage)) return $steps;

        if (!$this->getUser()->isAnonymous()
            || $this->_isGuestCheckoutEnabled()
        ) {
            if ($plan_id = $this->_hideSelectPlan($context, $formStorage)) {
                $formStorage['values']['select_plan']['plan'] = $plan_id;
            } else {
                $steps['select_plan'] = array('order' => 6);
            }
        }

        return $steps;
    }

    protected function _getPageTitle(Context $context, array $formStorage)
    {
        if (!$this->_isPaymentEnabled($context, $formStorage)
            || (!$plan = $this->_getSelectedPlan($context, $formStorage))
        ) return parent::_getPageTitle($context, $formStorage);

        if (!$bundle = $this->_getBundle($context, $formStorage)) return;

        return sprintf(__('%s: %s'), $bundle->getLabel('add'), $bundle->getGroupLabel() . ' - ' . $plan->paymentPlanTitle());
    }

    public function _getFormForStepSelectPlan(Context $context, array &$formStorage)
    {
        $form = $this->Payment_Plans_form($this->_getBundle($context, $formStorage)->name);
        $this->_submitable = !empty($form['plan']['#options']);
        return $form;
    }

    public function _submitFormForStepAdd(Context $context, Form\Form $form)
    {
        parent::_submitFormForStepAdd($context, $form);

        if (!$this->_isPaymentEnabled($context, $form->storage)) return;

        if ((!$plan = $this->_getSelectedPlan($context, $form->storage))
            || (!$entity = $this->_getEntity($context, $form->storage))
        ) return false; // this should not happen

        $this->_getPaymentComponent()->paymentOnSubmit($entity, $plan, 'add');
    }

    protected function _getSubmitButtonForStepAdd(Context $context, array &$formStorage)
    {
        if (!$this->_isPaymentEnabled($context, $formStorage)) {
            return parent::_getSubmitButtonForStepAdd($context, $formStorage);
        }

        return __('Add to cart', 'directories-payments');
    }

    protected function _getSelectedPlan(Context $context, array $formStorage)
    {
        if (!empty($formStorage['values']['select_plan']['plan'])) {
            return $this->_getPaymentComponent()->paymentGetPlan($formStorage['values']['select_plan']['plan']);
        }
    }

    protected function _getRedirectGuestUrlParams(Context $context, array $formStorage)
    {
        $ret = parent::_getRedirectGuestUrlParams($context, $formStorage);

        if ($this->_isPaymentEnabled($context, $formStorage)) {
            $ret[] = 'plan';
        }

        return $ret;
    }

    protected function _getEntityStatus(Context $context, Form\Form $form, Entity\Model\Bundle $bundle)
    {
        if (!$this->_isPaymentEnabled($context, $form->storage)) {
            return parent::_getEntityStatus($context, $form, $bundle);
        }
        return $this->Entity_Status($bundle->entitytype_name, 'draft');
    }

    protected function _isGuestCheckoutEnabled()
    {
        return ($payment_component = $this->_getPaymentComponent(false)) ? $payment_component ->paymentIsGuestCheckoutEnabled() : false;
    }

    protected function _isPaymentEnabled(Context $context, array $formStorage)
    {
        if ($this->getUser()->isAnonymous()
            && !$this->_isGuestCheckoutEnabled()
        ) return false;

        if ((!$bundle = $this->_getBundle($context, $formStorage))
            || empty($bundle->info['payment_enable'])
        ) return false;

        return $this->_getPaymentComponent(false) ? true : false;
    }

    protected function _getSubmitEntityFormOptions(Context $context, array &$formStorage, $isEdit = null, $wrap = null)
    {
        $ret = parent::_getSubmitEntityFormOptions($context, $formStorage, $isEdit, $wrap);
        if ($this->_isPaymentEnabled($context, $formStorage)
            && ($plan = $this->_getSelectedPlan($context, $formStorage))
        ) {
            $ret['payment_plan'] = $plan;
        }
        return $ret;
    }

    protected function _complete(Context $context, array $formStorage)
    {
        if (!$this->_isPaymentEnabled($context, $formStorage)) {
            parent::_complete($context, $formStorage);
            return;
        }

        $entity = $this->_getEntity($context, $formStorage);

        // Set cookie to track guest user
        if ($this->getUser()->isAnonymous()) {
            $this->FrontendSubmit_GuestAuthorCookie($entity);
        }

        $context->setSuccess($this->getComponent('Payment')->getPaymentComponent(true)->paymentSuccessUrl());
    }
}
