/* ========================================================================
 * Bootstrap: tooltip.js v3.2.0
 * http://getbootstrap.com/javascript/#tooltip
 * Inspired by the original jQuery.tipsy by Jason Frame
 * ========================================================================
 * Copyright 2011-2014 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */

+function(b){var c=function(f,e){this.type=this.options=this.enabled=this.timeout=this.hoverState=this.$element=null;this.init("tooltip",f,e)};c.VERSION="3.2.0";c.DEFAULTS={animation:true,placement:"top",selector:false,template:'<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',trigger:"hover focus",title:"",delay:0,html:false,container:false,viewport:{selector:"body",padding:0}};c.prototype.init=function(j,f,h){this.enabled=true;this.type=j;this.$element=b(f);this.options=this.getOptions(h);this.$viewport=this.options.viewport&&b(this.options.viewport.selector||this.options.viewport);var g=this.options.trigger.split(" ");for(var k=g.length;k--;){var l=g[k];if(l=="click"){this.$element.on("click."+this.type,this.options.selector,b.proxy(this.toggle,this))}else{if(l!="manual"){var m=l=="hover"?"mouseenter":"focusin";var e=l=="hover"?"mouseleave":"focusout";this.$element.on(m+"."+this.type,this.options.selector,b.proxy(this.enter,this));this.$element.on(e+"."+this.type,this.options.selector,b.proxy(this.leave,this))}}}this.options.selector?(this._options=b.extend({},this.options,{trigger:"manual",selector:""})):this.fixTitle()};c.prototype.getDefaults=function(){return c.DEFAULTS};c.prototype.getOptions=function(e){e=b.extend({},this.getDefaults(),this.$element.data(),e);if(e.delay&&typeof e.delay=="number"){e.delay={show:e.delay,hide:e.delay}}return e};c.prototype.getDelegateOptions=function(){var e={};var f=this.getDefaults();this._options&&b.each(this._options,function(h,g){if(f[h]!=g){e[h]=g}});return e};c.prototype.enter=function(f){var e=f instanceof this.constructor?f:b(f.currentTarget).data("bs."+this.type);if(!e){e=new this.constructor(f.currentTarget,this.getDelegateOptions());b(f.currentTarget).data("bs."+this.type,e)}clearTimeout(e.timeout);e.hoverState="in";if(!e.options.delay||!e.options.delay.show){return e.show()}e.timeout=setTimeout(function(){if(e.hoverState=="in"){e.show()}},e.options.delay.show)};c.prototype.leave=function(f){var e=f instanceof this.constructor?f:b(f.currentTarget).data("bs."+this.type);if(!e){e=new this.constructor(f.currentTarget,this.getDelegateOptions());b(f.currentTarget).data("bs."+this.type,e)}clearTimeout(e.timeout);e.hoverState="out";if(!e.options.delay||!e.options.delay.hide){return e.hide()}e.timeout=setTimeout(function(){if(e.hoverState=="out"){e.hide()}},e.options.delay.hide)};c.prototype.show=function(){var h=b.Event("show.bs."+this.type);if(this.hasContent()&&this.enabled){this.$element.trigger(h);var k=b.contains(document.documentElement,this.$element[0]);if(h.isDefaultPrevented()||!k){return}var u=this;var s=this.tip();var q=this.getUID(this.type);this.setContent();s.attr("id",q);this.$element.attr("aria-describedby",q);if(this.options.animation){s.addClass("fade")}var o=typeof this.options.placement=="function"?this.options.placement.call(this,s[0],this.$element[0]):this.options.placement;var r=/\s?auto?\s?/i;var p=r.test(o);if(p){o=o.replace(r,"")||"top"}s.detach().css({top:0,left:0,display:"block"}).addClass(o).data("bs."+this.type,this);this.options.container?s.appendTo(this.options.container):s.insertAfter(this.$element);var l=this.getPosition();var i=s[0].offsetWidth;var m=s[0].offsetHeight;if(p){var t=o;var f=this.$element.parent();var j=this.getPosition(f);o=o=="bottom"&&l.top+l.height+m-j.scroll>j.height?"top":o=="top"&&l.top-j.scroll-m<0?"bottom":o=="right"&&l.right+i>j.width?"left":o=="left"&&l.left-i<j.left?"right":o;s.removeClass(t).addClass(o)}var g=this.getCalculatedOffset(o,l,i,m);this.applyPlacement(g,o);var n=function(){u.$element.trigger("shown.bs."+u.type);u.hoverState=null};b.support.transition&&this.$tip.hasClass("fade")?s.one("bsTransitionEnd",n).emulateTransitionEnd(150):n()}};c.prototype.applyPlacement=function(k,p){var o=this.tip();var f=o[0].offsetWidth;var g=o[0].offsetHeight;var e=parseInt(o.css("margin-top"),10);var h=parseInt(o.css("margin-left"),10);if(isNaN(e)){e=0}if(isNaN(h)){h=0}k.top=k.top+e;k.left=k.left+h;b.offset.setOffset(o[0],b.extend({using:function(r){o.css({top:Math.round(r.top),left:Math.round(r.left)})}},k),0);o.addClass("in");var q=o[0].offsetWidth;var l=o[0].offsetHeight;if(p=="top"&&l!=g){k.top=k.top+g-l}var i=this.getViewportAdjustedDelta(p,k,q,l);if(i.left){k.left+=i.left}else{k.top+=i.top}var j=i.left?i.left*2-f+q:i.top*2-g+l;var n=i.left?"left":"top";var m=i.left?"offsetWidth":"offsetHeight";o.offset(k);this.replaceArrow(j,o[0][m],n)};c.prototype.replaceArrow=function(g,f,e){this.arrow().css(e,g?(50*(1-g/f)+"%"):"")};c.prototype.setContent=function(){var f=this.tip();var e=this.getTitle();f.find(".tooltip-inner")[this.options.html?"html":"text"](e);f.removeClass("fade in top bottom left right")};c.prototype.hide=function(){var h=this;var f=this.tip();var g=b.Event("hide.bs."+this.type);this.$element.removeAttr("aria-describedby");function i(){if(h.hoverState!="in"){f.detach()}h.$element.trigger("hidden.bs."+h.type)}this.$element.trigger(g);if(g.isDefaultPrevented()){return}f.removeClass("in");b.support.transition&&this.$tip.hasClass("fade")?f.one("bsTransitionEnd",i).emulateTransitionEnd(150):i();this.hoverState=null;return this};c.prototype.fixTitle=function(){var e=this.$element;if(e.attr("title")||typeof(e.attr("data-original-title"))!="string"){e.attr("data-original-title",e.attr("title")||"").attr("title","")}};c.prototype.hasContent=function(){return this.getTitle()};c.prototype.getPosition=function(f){f=f||this.$element;var h=f[0];var k=h.tagName=="BODY";var i=window.SVGElement&&h instanceof window.SVGElement;var j=h.getBoundingClientRect?h.getBoundingClientRect():null;var l=k?{top:0,left:0}:f.offset();var e={scroll:k?document.documentElement.scrollTop||document.body.scrollTop:f.scrollTop()};var g=i?{}:{width:k?b(window).width():f.outerWidth(),height:k?b(window).height():f.outerHeight()};return b.extend({},j,e,g,l)};c.prototype.getCalculatedOffset=function(e,h,f,g){return e=="bottom"?{top:h.top+h.height,left:h.left+h.width/2-f/2}:e=="top"?{top:h.top-g,left:h.left+h.width/2-f/2}:e=="left"?{top:h.top+h.height/2-g/2,left:h.left-f}:{top:h.top+h.height/2-g/2,left:h.left+h.width}};c.prototype.getViewportAdjustedDelta=function(h,n,g,l){var i={top:0,left:0};if(!this.$viewport){return i}var e=this.options.viewport&&this.options.viewport.padding||0;var m=this.getPosition(this.$viewport);if(/right|left/.test(h)){var f=n.top-e-m.scroll;var o=n.top+e-m.scroll+l;if(f<m.top){i.top=m.top-f}else{if(o>m.top+m.height){i.top=m.top+m.height-o}}}else{var k=n.left-e;var j=n.left+e+g;if(k<m.left){i.left=m.left-k}else{if(j>m.width){i.left=m.left+m.width-j}}}return i};c.prototype.getTitle=function(){var e;var f=this.$element;var g=this.options;e=f.attr("data-original-title")||(typeof g.title=="function"?g.title.call(f[0]):g.title);return e};c.prototype.getUID=function(e){do{e+=~~(Math.random()*1000000)}while(document.getElementById(e));return e};c.prototype.tip=function(){return(this.$tip=this.$tip||b(this.options.template))};c.prototype.arrow=function(){return(this.$arrow=this.$arrow||this.tip().find(".tooltip-arrow"))};c.prototype.validate=function(){if(!this.$element[0].parentNode){this.hide();this.$element=null;this.options=null}};c.prototype.enable=function(){this.enabled=true};c.prototype.disable=function(){this.enabled=false};c.prototype.toggleEnabled=function(){this.enabled=!this.enabled};c.prototype.toggle=function(f){var g=this;if(f){g=b(f.currentTarget).data("bs."+this.type);if(!g){g=new this.constructor(f.currentTarget,this.getDelegateOptions());b(f.currentTarget).data("bs."+this.type,g)}}g.tip().hasClass("in")?g.leave(g):g.enter(g)};c.prototype.destroy=function(){clearTimeout(this.timeout);this.hide().$element.off("."+this.type).removeData("bs."+this.type)};function d(e){return this.each(function(){var f=b(this);var h=f.data("bs.tooltip");var g=typeof e=="object"&&e;if(!h&&e=="destroy"){return}if(!h){f.data("bs.tooltip",(h=new c(this,g)))}if(typeof e=="string"){h[e]()}})}var a=b.fn.tooltip;b.fn.tooltip=d;b.fn.tooltip.Constructor=c;b.fn.tooltip.noConflict=function(){b.fn.tooltip=a;return this}}(jQuery);
