<?php

/*
 * this class should be used to work with the public side of wordpress
 */

class dale_Public
{

    protected static $instance = null;
    private $shared = null;

    //Store the number of events added to the post/page/cpt
    private static $event_counter = 0;

    private function __construct()
    {

        //assign an instance of the plugin info
        $this->shared = dale_Shared::get_instance();

        //dale shortcode
        add_shortcode('le', array($this, 'display_live_event'));

        //Load public css
        add_action('wp_enqueue_scripts', array($this, 'enqueue_styles'));

        //Load public js
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'));

        //Write in front-end head
        add_action('wp_head', array($this, 'wr_public_head'));

    }

    public function enqueue_styles()
    {

        if (intval(get_option($this->shared->get('slug') . '_advanced_assets_mode'), 10) === 0) {

            //Development
            wp_enqueue_style($this->shared->get('slug') . '-general',
                $this->shared->get('url') . 'public/assets/css/general.css', array(), $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-timeline',
                $this->shared->get('url') . 'public/assets/css/timeline.css', array(), $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-stat',
                $this->shared->get('url') . 'public/assets/css/stat.css', array(), $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-comment',
                $this->shared->get('url') . 'public/assets/css/comment.css', array(), $this->shared->get('ver'));

        } else {

            //Production
            wp_enqueue_style($this->shared->get('slug') . '-live-events',
                $this->shared->get('url') . 'public/assets/css/production/live-events.css', array(), $this->shared->get('ver'));

        }

        wp_enqueue_style($this->shared->get('slug') . '-custom',
            $this->shared->get('url') . 'public/assets/css/custom-' . get_current_blog_id() . '.css', array(),
            $this->shared->get('ver'));

        wp_enqueue_style($this->shared->get('slug') . '-fontello',
            $this->shared->get('url') . 'public/assets/font/fontello/css/dale-fontello.css', array(),
            $this->shared->get('ver'));

    }

    public function enqueue_scripts()
    {

        if (intval(get_option($this->shared->get('slug') . '_advanced_assets_mode'), 10) === 0) {

            //Development
            wp_enqueue_script($this->shared->get('slug') . '-twitter-loading',
                $this->shared->get('url') . 'public/assets/js/twitter-loading.js', array(),
                $this->shared->get('ver'), true);
            wp_enqueue_script($this->shared->get('slug') . '-utility',
                $this->shared->get('url') . 'public/assets/js/utility.js', array('jquery', 'jquery-effects-highlight'),
                $this->shared->get('ver'), true);
            wp_enqueue_script($this->shared->get('slug') . '-timeline',
                $this->shared->get('url') . 'public/assets/js/timeline.js',
                array('jquery', 'jquery-effects-highlight', $this->shared->get('slug') . '-utility'),
                $this->shared->get('ver'), true);
            wp_enqueue_script($this->shared->get('slug') . '-stat',
                $this->shared->get('url') . 'public/assets/js/stat.js',
                array('jquery', 'jquery-effects-highlight', $this->shared->get('slug') . '-timeline'),
                $this->shared->get('ver'), true);
            wp_enqueue_script($this->shared->get('slug') . '-comment',
                $this->shared->get('url') . 'public/assets/js/comment.js',
                array('jquery', 'jquery-effects-highlight', $this->shared->get('slug') . '-stat'),
                $this->shared->get('ver'), true);
            wp_enqueue_script($this->shared->get('slug') . '-general',
                $this->shared->get('url') . 'public/assets/js/general.js',
                array('jquery',
                    'jquery-effects-highlight',
                    $this->shared->get('slug') . '-twitter-loading',
                    $this->shared->get('slug') . '-utility',
                    $this->shared->get('slug') . '-timeline',
                    $this->shared->get('slug') . '-stat',
                    $this->shared->get('slug') . '-comment'),
                $this->shared->get('ver'), true);

            $partial_script_handle = 'utility';

        } else {

            //Production
            wp_enqueue_script($this->shared->get('slug') . '-live-events',
                $this->shared->get('url') . 'public/assets/js/production/live-events.js',
                array('jquery', 'jquery-effects-highlight'), $this->shared->get('ver'), true);

            $partial_script_handle = 'live-events';

        }

        //Generate the array that will be passed to wp_localize_script()
        $php_data = array(
            'nonce'                               => wp_create_nonce("dale"),
            'ajaxUrl'                             => admin_url('admin-ajax.php'),
            'commentEmptyCommentText'             => get_option($this->shared->get('slug') . '_comment_empty_comment_text'),
            'commentMessageUnderModerationText'   => get_option($this->shared->get('slug') . '_comment_message_under_moderation_text'),
            'commentCommentLimitText'             => get_option($this->shared->get('slug') . '_comment_comment_limit_text'),
            'commentNumberOfCommentsSingleText'   => get_option($this->shared->get('slug') . '_comment_number_of_comments_single_text'),
            'commentNumberOfCommentsMultipleText' => get_option($this->shared->get('slug') . '_comment_number_of_comments_multiple_text'),
            'commentSubmitCommentText'            => get_option($this->shared->get('slug') . '_comment_submit_comment_text'),
            'commentSignInText'                   => get_option($this->shared->get('slug') . '_comment_sign_in_text'),
            'advancedUpdateTime'                  => intval(get_option($this->shared->get('slug') . '_advanced_update_time'),
                10),
            'advancedInstagramProcessEmbed'                  => intval(get_option($this->shared->get('slug') . '_advanced_instagram_process_embed'),
                10)
        );

        //Add 'signInUrl' to the array that will be passed to wp_localize_script()
        if (intval(get_option($this->shared->get('slug') . '_advanced_sign_in_mode'), 10) === 0) {

            //Manual
            $php_data['advancedSignInUrl'] = get_option($this->shared->get('slug') . '_advanced_manual_sign_in_url');

        } else {

            //Automatic
            global $wp;
            $current_url                   = trailingslashit(home_url(add_query_arg(array(), $wp->request)));
            $php_data['advancedSignInUrl'] = wp_login_url($current_url);

        }

        //Make a series of useful PHP data available to the JavaScript part in the DALE_PHPDATA object
        wp_localize_script($this->shared->get('slug') . '-' . $partial_script_handle, 'DALE_PHPDATA', $php_data);

    }

    public function wr_public_head()
    {

        if (strlen(trim(get_option($this->shared->get('slug') . "_advanced_google_font_embed"))) > 0) {
            echo '<link href="' . esc_url(get_option($this->shared->get('slug') . '_advanced_google_font_embed')) . '" rel="stylesheet">';
        }

    }

    /*
     * create an instance of this class
     */
    public static function get_instance()
    {

        if (null == self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;

    }

    /*
     * [le] shortcode callback
     */
    public function display_live_event($atts)
    {

        /*
         * Parse the shortcode only inside the full content of posts. Do not parse the shortcode inside feeds.
         */
        if (is_feed() or ( ! is_single() and ! is_page())) {
            return;
        }

        //get the table id
        extract(shortcode_atts(array('id' => '0'), $atts));
        $event_id = abs(intval($id, 10));

        //get table object
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_event";
        $safe_sql   = $wpdb->prepare("SELECT * FROM $table_name WHERE event_id = %d", $event_id);
        $event_obj  = $wpdb->get_row($safe_sql);

        //terminate if there is no event with the specified id
        if ($event_obj === null) {
            return '<p>' . esc_attr__('There is no event associated with this shortcode.', 'dale') . '</p>';
        }

        //terminate if an event has been already added to the post/page/cpt
        if (self::$event_counter > 0) {
            return '<p>' . esc_attr__("You can't add multiple events in the same post, page or custom post type.",
                    'dale') . '</p>';
        }

        //increase the event counter
        self::$event_counter++;

        //Generate the layout
        $title     = get_the_title();
        $permalink = get_permalink();

        //turn on output buffering
        ob_start();

        ?>

        <!-- Event HTML -->

        <div id="dale-live-event" data-event-id="<?php echo intval($event_obj->event_id, 10); ?>">

            <div id="dale-tabs">
                <ul id="dale-tabs-ul"></ul>
            </div>

            <?php if ((intval(get_option($this->shared->get('slug') . '_social_facebook'), 10) === 1) or
                      (intval(get_option($this->shared->get('slug') . '_social_twitter'), 10) === 1) or
                      (intval(get_option($this->shared->get('slug') . '_social_google_plus'), 10) === 1) or
                      (intval(get_option($this->shared->get('slug') . '_social_pinterest'), 10) === 1) or
                      (intval(get_option($this->shared->get('slug') . '_social_linkeding'), 10) === 1) or
                      (intval(get_option($this->shared->get('slug') . '_social_tumblr'), 10) === 1) or
                      (intval(get_option($this->shared->get('slug') . '_social_email'), 10) === 1)) : ?>
                <div id="dale-social" class="daext-clearfix">
                    <div id="dale-social-label-left"><?php echo esc_attr(get_option($this->shared->get('slug') . '_social_share_text')); ?></div>
                    <div id="dale-social-label-right" class="daext-clearfix">
                        <?php if (intval(get_option($this->shared->get('slug') . '_social_facebook'), 10) === 1) : ?>
                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url($permalink); ?>"
                               id="dale-social-label-facebook" class="dale-social-label-button" target="_blank"><span
                                        class="icon-facebook"></span></a>
                        <?php endif; ?>
                        <?php if (intval(get_option($this->shared->get('slug') . '_social_twitter'), 10) === 1) : ?>
                            <a href="https://twitter.com/intent/tweet?url=<?php echo esc_url($permalink); ?>"
                               id="dale-social-label-twitter" class="dale-social-label-button" target="_blank"><span
                                        class="icon-twitter"></span></span></a>
                        <?php endif; ?>
                        <?php if (intval(get_option($this->shared->get('slug') . '_social_google_plus'), 10) === 1) : ?>
                            <a href="https://plus.google.com/share?url=<?php echo esc_url($permalink); ?>"
                               id="dale-social-label-gplus" class="dale-social-label-button" target="_blank"><span
                                        class="icon-gplus"></span></a>
                        <?php endif; ?>
                        <?php if (intval(get_option($this->shared->get('slug') . '_social_pinterest'), 10) === 1) : ?>
                            <a href="http://pinterest.com/pin/create/button/?url=<?php echo esc_url($permalink); ?>&description=<?php echo esc_attr($title); ?>"
                               id="dale-social-label-facebook" class="dale-social-label-button" target="_blank"><span
                                        class="icon-pinterest"></span></a>
                        <?php endif; ?>
                        <?php if (intval(get_option($this->shared->get('slug') . '_social_linkedin'), 10) === 1) : ?>
                            <a href="http://linkedin.com/shareArticle?mini=true&title=<?php echo esc_attr($title); ?>&url=<?php echo esc_url($permalink); ?>"
                               id="dale-social-label-twitter" class="dale-social-label-button" target="_blank"><span
                                        class="icon-linkedin"></span></span></a>
                        <?php endif; ?>
                        <?php if (intval(get_option($this->shared->get('slug') . '_social_tumblr'), 10) === 1) : ?>
                            <a href="http://www.tumblr.com/share/link?url=<?php echo esc_url($permalink); ?>&name=<?php echo esc_attr($title); ?>"
                               id="dale-social-label-gplus" class="dale-social-label-button" target="_blank"><span
                                        class="icon-tumblr"></span></a>
                        <?php endif; ?>
                        <?php if (intval(get_option($this->shared->get('slug') . '_social_email'), 10) === 1) : ?>
                            <a href="mailto:?subject=<?php echo esc_attr($title); ?>&body=<?php echo esc_url($permalink); ?>"
                               id="dale-social-label-gplus" class="dale-social-label-button" target="_blank"><span
                                        class="icon-mail"></span></a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

            <div id="dale-body"></div>

        </div>

        <?php

        //Generate the structured data in JSON-LD format if enabled
        echo $this->get_structured_data($event_obj);

        return ob_get_clean();

    }

    /**
     * Returns a script with the structured data in JSON-LD format.
     *
     * @param $event_id
     * @return void
     */
    private function get_structured_data($event_obj){

        /**
         * Get all the timelines associated with the events.
         *
         * Note that only one timeline per event can have the structured data enabled. As a consequence the first
         * timeline found with the structured data enabled is also the only timeline of the event with the structured
         * data enabled. This timeline should be used to generate the schema data.
         */
        $timeline = null;
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
        $timeline_a = $wpdb->get_results("SELECT * FROM $table_name WHERE event_id = " . $event_obj->event_id,
            ARRAY_A);
        foreach ($timeline_a as $single_timeline) {

            //if the timeline has the schema enabled save it and exit from the loop
            if (intval($single_timeline['structured_data'], 10) === 1) {
                $timeline = $single_timeline;
                break;
            }

        }

        //Do not generate the schema json-ld if a timeline with structured data enabled is not available for the event
        if ($timeline !== null) {

            //Get the data for the schema
            $id = get_the_permalink();
            $about_start_date = $event_obj->schema_start_date; //This value should be defined in the event database (new field)
            $timezone = $event_obj->schema_timezone;
            $about_location = stripslashes($event_obj->schema_location);
            $about_name = stripslashes($event_obj->name);
            $coverage_start_time = $timeline['schema_coverage_start_time']; //This value should be defined in the event database (new field)
            $coverage_end_time = $timeline['schema_coverage_end_time']; //This value should be defined in the event database (new field)
            $headline = stripslashes($timeline['name']);
            $description = stripslashes($timeline['description']);

            //Generate an array with the json-ld data
            $json_ld = [
                "@context" => "https://schema.org",
                "@type" => "LiveBlogPosting",
                "@id" => $id,
                "about" => [
                    "@type" => "Event",
                    "startDate" => $about_start_date . $timezone,
                    "location" => $about_location,
                    "name" => $about_name
                ],
                "coverageStartTime" => $coverage_start_time . $timezone,
                "coverageEndTime" => $coverage_end_time . $timezone,
                "headline" => $headline,
                "description" => $description,
            ];

            //Get the live blog updates from the timeline items
            $json_ld['liveBlogUpdate'] = [];
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline_item";
            $timeline_item_a = $wpdb->get_results("SELECT * FROM $table_name WHERE timeline_id = " . $timeline['timeline_id'],
                ARRAY_A);
            foreach ($timeline_item_a as $single_timeline_item) {

                $json_ld['liveBlogUpdate'][] = [
                    "@type" => "BlogPosting",
                    "headline" => stripslashes($single_timeline_item['title']),
                    "datePublished" => $single_timeline_item['date'],
                    "articleBody" => stripslashes($single_timeline_item['content'])
                ];

            }

            return '<script type="application/ld+json">' . wp_json_encode($json_ld) . '</script>';

        }

    }

}