(function($) {

  'use strict';

  //Global Object
  window.DALE = {};

  /**
   * Utility Methods
   */
  window.DALE.utility = {

    /**
     * Convert specific characters to the related HTML Entities
     *
     * From: https://github.com/janl/mustache.js/blob/master/mustache.js#L60
     *
     * @param string
     * @returns {string}
     */
    escapeHtml: function(string) {

      'use strict';

      var entityMap = {
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;',
        '"': '&quot;',
        '\'': '&#39;',
        '/': '&#x2F;',
        '`': '&#x60;',
        '=': '&#x3D;',
      };

      return String(string).replace(/[&<>"'`=\/]/g, function(s) {
        return entityMap[s];
      });

    },

    /**
     * Load a script and execute the callback function on success
     * @param url
     * @param callback
     */
    loadScript: function(url, callback) {
      $.ajax({
        url: url,
        dataType: 'script',
        success: callback,
        async: true,
      });
    },

  };

}(window.jQuery));