(function($) {

  'use strict';

  /**
   * Timeline Methods
   */
  window.DALE.timeline = {

    process: function(tabIndex, timelineData) {

      'use strict';

      var html = '',
          htmlTimelineItem,
          htmlTimelineItems = '',
          timelineItemIdA = [],
          el = null,
          timelineItemsBefore = null,
          collection = null;

      if (window.DALE.states.initialized === false) {

        //Add the HTML of the tabs and of the timeline to the DOM ----------------

        //add list item to the timeline tabs list
        $('#dale-tabs-ul').
            append('<li class="dale-tabs-li daext-clearfix-responsive" data-element-id="' + tabIndex +
                '"><div class="dale-tabs-li-inner"><span class="icon-clock"></span>' +
                window.DALE.utility.escapeHtml(timelineData.label) +
                '</div></li>');

        //Generate the HTML of the timeline items
        $.each(timelineData.timelineItem, function(index, value) {

          htmlTimelineItems += window.DALE.timeline.generateTimelineItemHtml(timelineData, value);

        });

        //add the timeline to the body
        html = '<div class="dale-body-timeline dale-body-element" data-element-id="' + tabIndex + '">' +
            htmlTimelineItems + '</div>';

        $('#dale-body').append(html);

        window.DALE.timeline.applyActiveElements(tabIndex);

      } else {

        //Update the timeline ------------------------------------------------------------------------------------------
        if ($('.dale-tabs-li[data-element-id="' + tabIndex + '"]').length === 1) {

          //Update the DOM elements ------------------------------------------------------------------------------------

          //iterate over the timeline items
          $.each(timelineData.timelineItem, function(index, value) {

            //check if the timeline item exists in the dom
            if ($('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId + '"]').length === 1) {

              //If the hash of the timelineItem has changed the timelineItem should be updated in the DOM
              if (value.hash !== $('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId + '"]').
                      attr('data-hash')) {

                //fadeout the timeline item
                $('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId + '"]').
                    fadeOut(400, function() {

                      //update the timeline item in the dom
                      if (parseInt(timelineData.showIcon, 10) === 1) {
                        $('.dale-body-timeline-item[data-timeline-item-id="' +
                            value.timelineItemId + '"] .dale-body-timeline-icon img').
                            attr('src', value.icon);
                      }
                      $('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId +
                          '"] .dale-body-timeline-date').html(window.DALE.utility.escapeHtml(value.date));

                      //title
                      el = $('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId +
                          '"] .dale-body-timeline-title');
                      el.html(window.DALE.utility.escapeHtml(value.title));
                      if (value.title.trim().length === 0) {
                        if (!el.hasClass('daext-display-none')) {
                          el.addClass('daext-display-none');
                        }
                      } else {
                        if (el.hasClass('daext-display-none')) {
                          el.removeClass('daext-display-none');
                        }
                      }

                      //content
                      el = $('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId +
                          '"] .dale-body-timeline-content');
                      el.html(value.content);
                      if (value.content.trim().length === 0) {
                        if (!el.hasClass('daext-display-none')) {
                          el.addClass('daext-display-none');
                        }
                      } else {
                        if (el.hasClass('daext-display-none')) {
                          el.removeClass('daext-display-none');
                        }
                      }

                      //delete extra -----------------------------------------------------------------------------------

                      //delete the image extra if exists
                      el = $('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId +
                          '"] .dale-body-timeline-image');
                      if (el.length > 0) {
                        el.remove();
                      }

                      //delete the tweet extra if exists
                      el = $('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId +
                          '"] .dale-body-timeline-tweet');
                      if (el.length > 0) {
                        el.remove();
                      }

                      //delete the html extra if exists
                      el = $('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId +
                          '"] .dale-body-timeline-html');
                      if (el.length > 0) {
                        el.remove();
                      }

                      //add extra --------------------------------------------------------------------------------------

                      switch (parseInt(value.extra, 10)) {

                        //Image
                        case 1:

                          //create the image if doesn't exist
                          $('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId +
                              '"] .dale-body-timeline-item-right').
                              append('<div class="dale-body-timeline-image"><img src="' + value.image + '"></div>');

                          break;

                        //Tweet
                        case 2:

                          //create the image if doesn't exist
                          $('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId +
                              '"] .dale-body-timeline-item-right').
                              append('<div class="dale-body-timeline-tweet" data-tweet-id="' + value.tweet_id + '" data-status="0"></div>');

                          break;

                        //HTML
                        case 3:

                            if(value.html.trim().length > 0){

                              //create the html extra if doesn't exist
                              $('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId +
                                  '"] .dale-body-timeline-item-right').
                                  append('<div class="dale-body-timeline-html">' + value.html + '</div>');

                            }

                          break;

                        default:

                          break;

                      }

                      //fadein the timeline item
                      $('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId + '"]').fadeIn(400);

                      window.DALE.timeline.applyActiveElements(tabIndex);

                    });

                //Update the hash
                $('.dale-body-timeline-item[data-timeline-item-id="' + value.timelineItemId + '"]').
                    attr('data-hash', value.hash);

              }

            } else {

              htmlTimelineItem = window.DALE.timeline.generateTimelineItemHtml(timelineData, value);
              htmlTimelineItem = $.parseHTML(htmlTimelineItem);
              $(htmlTimelineItem).css('display', 'none');

              if($('.dale-body-timeline[data-element-id="' + tabIndex + '"] .dale-body-timeline-item').length === 0){

                //If there are no timeline items add the new timeline item in .dale-body-timeline with prepend
                $('.dale-body-timeline[data-element-id="' + tabIndex + '"]').prepend(htmlTimelineItem);

              }else{

                //If there is at least one timeline item add the new timeline item in the right position.

                //Generate an array with all the timeline-item-id of all the timeline item in the DOM
                timelineItemIdA = [];
                collection = $('.dale-body-timeline[data-element-id="' + tabIndex + '"] .dale-body-timeline-item');
                $(collection).each(function() {
                  timelineItemIdA.push(parseInt($(this).attr('data-timeline-item-id'), 10));
                });

                //Find the number of timeline items that goes before the timeline item that is going to be added
                timelineItemsBefore = 0;
                $.each(timelineItemIdA, function( index1, value1 ) {
                  if(value.timelineItemId < value1){
                    timelineItemsBefore++;
                  }
                });

                //Add the timeline item in the correct position
                if(timelineItemsBefore === 0){
                  $('.dale-body-timeline[data-element-id="' + tabIndex + '"] .dale-body-timeline-item').eq(0).before(htmlTimelineItem);
                }else{
                  $('.dale-body-timeline[data-element-id="' + tabIndex + '"] .dale-body-timeline-item').eq(timelineItemsBefore - 1).after(htmlTimelineItem);
                }

              }

              $(htmlTimelineItem).fadeIn(400);

              window.DALE.timeline.applyActiveElements(tabIndex);

            }

          });

          //Delete from the DOM the timeline items that no longer exists -----------------------------------------------

          //Generate an array with all the timelineItemId of the timeline
          $.each(timelineData.timelineItem, function(index, value) {
            timelineItemIdA.push(parseInt(value.timelineItemId, 10));
          });

          //Iterate through the DOM elements of the timeline
          $('.dale-body-timeline[data-element-id="' + tabIndex + '"] .dale-body-timeline-item').each(function() {

            /**
             * If the data-element-id found in the DOM doesn't exists in the array with the list of timelineItemId
             * delete the timeline item from the DOM
             */
            if ($.inArray(parseInt($(this).attr('data-timeline-item-id'), 10), timelineItemIdA) === -1) {
              $(this).fadeOut(400, function() {
                $(this).remove();
              });

            }

          });

        }

      }

    },

    /**
     * Generate the HTML of a Timeline Item.
     *
     * @param timelineData
     * @param value
     * @returns {string|*}
     */
    generateTimelineItemHtml: function(timelineData, value) {

      'use strict';

      var htmlTimelineItem;

      //Init
      var iconHtml = '',
          layoutHtml = '',
          displayNoneClass = '';

      //Avatar HTML
      if (parseInt(timelineData.showIcon, 10) === 1) {
        iconHtml = '<div class="dale-body-timeline-item-left">' +
            '<div class="dale-body-timeline-icon"><img src="' + value.icon + '"></div>' +
            '</div>';
      } else {
        iconHtml = '';
      }

      //Title
      if (value.title.trim().length === 0) {
        displayNoneClass = ' daext-display-none';
      }else{
        displayNoneClass = '';
      }
      layoutHtml += '<div class="dale-body-timeline-title' + displayNoneClass + '">' +
          window.DALE.utility.escapeHtml(value.title) + '</div>';

      //Content
      if (value.content.trim().length === 0) {
        displayNoneClass = ' daext-display-none';
      }else{
        displayNoneClass = '';
      }
      layoutHtml += '<div class="dale-body-timeline-content' + displayNoneClass + '">' +
          value.content + '</div>';

      //Generate the final part of the layoutHtml based on the selected "Extra"
      switch (parseInt(value.extra, 10)) {

        //None
        case 0:

          break;

        //Image
        case 1:

          if (value.image.trim().length > 0) {
            layoutHtml += '<div class="dale-body-timeline-image"><img src="' + value.image + '"></div>';
          }

          break;

        //Tweet
        case 2:

          if (parseInt(value.tweet_id, 10) > 0) {
            layoutHtml += '<div class="dale-body-timeline-tweet" data-tweet-id="' + window.DALE.utility.escapeHtml(value.tweet_id) + '" data-status="0"></div>';
          }

          break;

        //HTML
        case 3:

          if (value.html.trim().length > 0) {
            layoutHtml += '<div class="dale-body-timeline-html">' + value.html + '</div>';
          }

          break;

      }

      //Generate the HTML of the timeline item
      htmlTimelineItem = '<div data-hash="' + value.hash +
          '" class="dale-body-timeline-item" data-timeline-item-id="' + value.timelineItemId + '">' +
          iconHtml +
          '<div class="dale-body-timeline-item-right">' +
          '<div class="dale-body-timeline-date">' + window.DALE.utility.escapeHtml(value.date) + '</div>' +
          layoutHtml +
          '</div>' +
          '</div>';

      //Return
      return htmlTimelineItem;

    },

    /**
     * Applies all the active elements. (Tweets, etc.)
     *
     * @param tabIndex
     */
    applyActiveElements: function(tabIndex){

      /**
       * If:
       *
       * - The "Instagram Process Embed" option is set to "Yes"
       * - The instgrm object is not undefined
       *
       * The process() method transforms the Instagram Embed Code added dynamically with JavaScript in a real Instagram
       * posts.
       *
       * Please note that the process() method is available when an Instagram Embed Code is added in the HTML field of
       * a timeline item, but if it's undefined the embed.js file is manually loaded to make the process() method
       * available.
        */
      if(parseInt(window.DALE_PHPDATA.advancedInstagramProcessEmbed, 10) === 1){
        if(typeof window.instgrm != 'undefined'){
          window.instgrm.Embeds.process();
        }else{
          window.DALE.utility.loadScript('//platform.instagram.com/en_US/embeds.js', function(){
            //Executed when the embeds.js has loaded
            window.instgrm.Embeds.process();
          });
        }
      }

      /**
       * Applies the tweets with the twitter 'createTweet' method and update the 'data-status' attribute of the container
       * to '1' (which means that the tweet ID available in the 'data-tweet-id' attribute has been applied with the
       * 'createTweet' method)
       */
      $('.dale-body-timeline[data-element-id="' + tabIndex + '"] .dale-body-timeline-tweet').each(function(){

        if(parseInt($(this).attr('data-status'), 10) === 0){

          window.twttr.widgets.createTweet(
              $(this).attr('data-tweet-id'),
              this
          );

          $(this).attr('data-status', '1');

        }

      });

    },

  };

})(window.jQuery);