(function($) {

  'use strict';

  /**
   * Stat Methods
   */
  window.DALE.stat = {

    process: function(tabIndex, statData) {

      'use strict';

      var html = '',
          htmlStatGroups = '';

      if (window.DALE.states.initialized === false) {

        //add list item to the timeline tabs list
        $('#dale-tabs-ul').
            append('<li class="dale-tabs-li daext-clearfix-responsive" data-element-id="' + tabIndex +
                '"><div class="dale-tabs-li-inner"><span class="icon-chart-bar"></span>' + window.DALE.utility.escapeHtml(statData.label) +
                '</div></li>');

        //create stat ------------------------------------------------------------------------------------------------

        //iterate over the stat groups
        $.each(statData.statGroup, function(index1, value1) {

          htmlStatGroups += '<div class="dale-body-stat-group" data-stat-group-id="' + value1.statGroupId + '">';

          htmlStatGroups += '<div class="dale-body-stat-group-label">' + window.DALE.utility.escapeHtml(value1.label) + '</div>';

          $.each(value1.statItem, function(index2, value2) {

            if (parseInt(value2.type, 10) === 0) {

              //add hash in all these type of stats

              //Single Data
              htmlStatGroups += '<div class="dale-body-stat-single-data dale-body-stat-item daext-clearfix" data-stat-item-id="' +
                  value2.statItemId + '"' +
                  ' data-hash="' + value2.hash + '">' +
                  '<div class="dale-subject">' + window.DALE.utility.escapeHtml(value2.subject) + '</div>' +
                  '<div class="dale-value-1">' + value2.value1 + (parseInt(value2.percentage, 10) === 1 ? '%' : '') + '</div>' +
                  '</div>';

            } else if (parseInt(value2.type, 10) === 1) {

              //Single Visual
              htmlStatGroups += '<div class="dale-body-stat-single-visual dale-body-stat-item" data-stat-item-id="' +
                  value2.statItemId + '"' +
                  ' data-hash="' + value2.hash + '">' +
                  '<div class="dale-bar"></div>' +
                  '<div class="dale-data daext-clearfix">' +
                  '<div class="dale-value-1">' + value2.value1 + (parseInt(value2.percentage, 10) === 1 ? '%' : '') +
                  '</div>' +
                  '<div class="dale-subject">' + window.DALE.utility.escapeHtml(value2.subject) + '</div>' +
                  '<div class="dale-reference">' + value2.reference +
                  (parseInt(value2.percentage, 10) === 1 ? '%' : '') + '</div>' +
                  '</div>' +
                  '</div>';

            } else if (parseInt(value2.type, 10) === 2) {

              //Comparison Data
              htmlStatGroups += '<div class="dale-body-stat-comparison-data dale-body-stat-item daext-clearfix" data-stat-item-id="' +
                  value2.statItemId + '"' +
                  ' data-hash="' + value2.hash + '">' +
                  '<div class="dale-value-1">' + value2.value1 + (parseInt(value2.percentage, 10) === 1 ? '%' : '') + '</div>' +
                  '<div class="dale-subject">' + window.DALE.utility.escapeHtml(value2.subject) + '</div>' +
                  '<div class="dale-value-2">' + value2.value2 + (parseInt(value2.percentage, 10) === 1 ? '%' : '') + '</div>' +
                  '</div>';

            } else if (parseInt(value2.type, 10) === 3) {

              //Comparison Visual
              htmlStatGroups += '<div class="dale-body-stat-comparison-visual dale-body-stat-item" data-stat-item-id="' +
                  value2.statItemId + '"' +
                  ' data-hash="' + value2.hash + '">' +
                  '<div class="dale-bar"></div>' +
                  '<div class="dale-data daext-clearfix">' +
                  '<div class="dale-value-1">' + value2.value1 + (parseInt(value2.percentage, 10) === 1 ? '%' : '') +
                  '</div>' +
                  '<div class="dale-subject">' + value2.subject + '</div>' +
                  '<div class="dale-value-2">' + value2.value2 + (parseInt(value2.percentage, 10) === 1 ? '%' : '') +
                  '</div>' +
                  '</div>' +
                  '</div>';

            }

          });

          htmlStatGroups += '</div>';

        });

        //add the stat to the body
        html = '<div class="dale-body-stat dale-body-element" data-element-id="' + tabIndex + '">' + htmlStatGroups +
            '</div>';

        $('#dale-body').append(html);

      } else {

        var sel = null;

        $.each(statData.statGroup, function(index1, value1) {

          $.each(value1.statItem, function(index2, value2) {

            if (parseInt(value2.type, 10) === 0) {

              //Single Data
              sel = $('.dale-body-stat[data-element-id="' + tabIndex + '"] ' +
                  '.dale-body-stat-group[data-stat-group-id="' + value1.statGroupId + '"] ' +
                  '.dale-body-stat-single-data[data-stat-item-id="' + value2.statItemId + '"]');

              //Update the stat item when the hash changes
              if (sel.attr('data-hash') !== value2.hash) {
                sel.fadeOut('400', function() {
                  $(this).find('.dale-subject').html(window.DALE.utility.escapeHtml(value2.subject));
                  $(this).find('.dale-value-1').html(value2.value1 + (parseInt(value2.percentage, 10) === 1 ? '%' : ''));
                  $(this).attr('data-hash', value2.hash);
                  $(this).fadeIn('400');
                });
              }

            } else if (parseInt(value2.type, 10) === 1) {

              //Single Visual
              sel = $('.dale-body-stat[data-element-id="' + tabIndex + '"] ' +
                  '.dale-body-stat-group[data-stat-group-id="' + value1.statGroupId + '"] ' +
                  '.dale-body-stat-single-visual[data-stat-item-id="' + value2.statItemId + '"]');

              //Update the stat item when the hash changes
              if (sel.attr('data-hash') !== value2.hash) {
                sel.fadeOut('400', function() {
                  $(this).
                      find('.dale-value-1').
                      text(value2.value1 + (parseInt(value2.percentage, 10) === 1 ? '%' : ''));
                  $(this).find('.dale-subject').html(window.DALE.utility.escapeHtml(value2.subject));
                  $(this).
                      find('.dale-reference').
                      text(value2.reference + (parseInt(value2.percentage, 10) === 1 ? '%' : ''));
                  $(this).attr('data-hash', value2.hash);
                  window.DALE.stat.updateVisualBars();
                  $(this).fadeIn('400');
                });
              }

            } else if (parseInt(value2.type, 10) === 2) {

              //Comparison Data
              sel = $('.dale-body-stat[data-element-id="' + tabIndex + '"] ' +
                  '.dale-body-stat-group[data-stat-group-id="' + value1.statGroupId + '"] ' +
                  '.dale-body-stat-comparison-data[data-stat-item-id="' + value2.statItemId + '"]');

              //Update the stat item when the hash changes
              if (sel.attr('data-hash') !== value2.hash) {
                sel.fadeOut('400', function() {
                  $(this).
                      find('.dale-value-1').
                      text(value2.value1 + (parseInt(value2.percentage, 10) === 1 ? '%' : ''));
                  $(this).find('.dale-subject').html(window.DALE.utility.escapeHtml(value2.subject));
                  $(this).
                      find('.dale-value-2').
                      text(value2.value2 + (parseInt(value2.percentage, 10) === 1 ? '%' : ''));
                  $(this).attr('data-hash', value2.hash);
                  $(this).fadeIn('400');
                });
              }

            } else if (parseInt(value2.type, 10) === 3) {

              //Comparison Visual
              sel = $('.dale-body-stat[data-element-id="' + tabIndex + '"] ' +
                  '.dale-body-stat-group[data-stat-group-id="' + value1.statGroupId + '"] ' +
                  '.dale-body-stat-comparison-visual[data-stat-item-id="' + value2.statItemId + '"]');

              //Update the stat item when the hash changes
              if (sel.attr('data-hash') !== value2.hash) {
                sel.fadeOut('400', function() {
                  $(this).
                      find('.dale-value-1').
                      text(value2.value1 + (parseInt(value2.percentage, 10) === 1 ? '%' : ''));
                  $(this).find('.dale-subject').html(window.DALE.utility.escapeHtml(value2.subject));
                  $(this).
                      find('.dale-value-2').
                      text(value2.value2 + (parseInt(value2.percentage, 10) === 1 ? '%' : ''));
                  $(this).attr('data-hash', value2.hash);
                  window.DALE.stat.updateVisualBars();
                  $(this).fadeIn('400');
                });
              }

            }

          });

        });

      }

      window.DALE.stat.updateVisualBars();

    },

    /**
     * Update the bar length of the "Single Visual" and "Comparison Visual" bars.
     */
    updateVisualBars: function() {

      'use strict';

      //Update the bar length by modifying the width value of .dale-bar
      $('.dale-body-stat-single-visual, .dale-body-stat-comparison-visual').each(function() {

        var percentageValue = 0;

        if ($(this).hasClass('dale-body-stat-single-visual')) {

          //Single Visual
          percentageValue = parseFloat(parseInt($(this).find('.dale-value-1').text()) /
              parseInt($(this).find('.dale-reference').text(), 10)) * 100;

        } else {

          //Comparison visual
          percentageValue = parseFloat(parseInt($(this).find('.dale-value-1').text(), 10) /
              (parseInt($(this).find('.dale-value-1').text(), 10) +
                  parseInt($(this).find('.dale-value-2').text(), 10))) * 100;

        }

        $(this).find('.dale-bar').css('width', percentageValue + '%');

      });

    },

  };

})(window.jQuery);