(function($) {

  'use strict';

  //This object is used to save all the variable states of the event ---------------------------------------------------
  window.DALE.states = {

    //Store the timeline content
    timeline: false,

    //Stores the numeric identifier of the timer created by setInterval() to receive updates
    intervalIdentifier: false,

    //True if initialized, False if not initialized
    initialized: false,

  };

  //This object is used to save fixed parameters of the event ----------------------------------------------------------
  window.DALE.params = {

    //True if the user is enabled to leave comments, False if he's not enabled to leave comments
    userComment: null,

  };

  //If the event exists in the DOM start receiving updates
  if($('#dale-live-event').length > 0){
    bindEventListeners();
  }

  function receiveUpdate() {

    'use strict';

    var eventId = $('#dale-live-event').attr('data-event-id');

    //perform ajax request -------------------------------------------------------------------------------------------
    var data = {
      'action': 'dale_get_event_data',
      'security': window.DALE_PHPDATA.nonce,
      'event_id': eventId,
    };

    //send ajax request
    $.post(window.DALE_PHPDATA.ajaxUrl, data, function(data_json) {

      //convert the json string to a javascript object
      var data_obj = JSON.parse(data_json);

      //Set the userComment flag
      window.DALE.params.userComment = data_obj.user_comment;

      /**
       * If the event is not live clear the window.DALE.states.timerIdentifier to prevent
       * additional updates of the event.
       */
      if (data_obj.live === false) {
        clearInterval(window.DALE.states.timerIdentifier);
      }

      //parse one by one the objects in the json
      $.each(data_obj, function(tabIndex, value) {

        //identify the object (timeline, stat, comment) by looking at the presence of a specific field (timeline_id, stat_id, comment_id)
        if (value.hasOwnProperty('timelineId')) {

          //use the data to generate/update a timeline
          window.DALE.timeline.process(tabIndex, value);

        } else if (value.hasOwnProperty('statId')) {

          //use the data to generate/update a stat
          window.DALE.stat.process(tabIndex, value);

        } else if (value.hasOwnProperty('commentId')) {

          //use the data to generate/update a comment
          window.DALE.comment.process(tabIndex, value);

        }

      });

      if (window.DALE.states.initialized === false) {

        //bind click on tabs
        bindClickOnTabs();

        //highlight the first tab
        $('li:first-child').addClass('dale-tabs-highlight');

        //display the first element
        $('.dale-body-element:first-child').show();

        //display the live event container
        $('#dale-live-event').css('visibility', 'visible');

        window.DALE.states.initialized = true;

      }

    });

  }

  function startReceivingUpdates() {

    'use strict';

    receiveUpdate();

    window.DALE.states.timerIdentifier = setInterval(function() {
      receiveUpdate();
    }, window.DALE_PHPDATA.advancedUpdateTime * 1000);

  }

  function bindClickOnTabs() {

    'use strict';

    if($('.dale-tabs-li > .dale-tabs-li-inner').length > 1){

      $('.dale-tabs-li > .dale-tabs-li-inner').addClass('dale-tabs-li-inner-cursor-pointer');

      //on click display the proper element
      $('.dale-tabs-li > .dale-tabs-li-inner').click(function() {

        //hide all the elements
        $('.dale-body-element').hide(0);

        //remove the highlight on all the tabs
        $('.dale-tabs-li').removeClass('dale-tabs-highlight');

        //highlight the active tab
        $(this).parent().addClass('dale-tabs-highlight');

        //display the proper element
        var elementId = $(this).parent().attr('data-element-id');
        $('.dale-body-element[data-element-id="' + elementId + '"]').show(0);

      });

    }


  }

  function bindEventListeners() {

    'use strict';

    $(document).ready(function() {

      window.twttr.ready(function(){

        startReceivingUpdates();

      });

    });

  }

}(window.jQuery));