<?php

/*
 * this class should be used to include ajax actions
 */

class dale_Ajax
{

    protected static $instance = null;
    private $shared = null;

    private function __construct()
    {

        //assign an instance of the plugin info
        $this->shared = dale_Shared::get_instance();

        //ajax requests for logged-in and not logged-in users
        add_action('wp_ajax_dale_get_event_data', array($this, 'dale_get_event_data'));
        add_action('wp_ajax_nopriv_dale_get_event_data', array($this, 'dale_get_event_data'));


        //ajax requests for logged-in users ----------------------------------------------------------------------------
        add_action('wp_ajax_dale_get_timeline_data', array($this, 'get_timeline_data'));
        add_action('wp_ajax_dale_comment_submit', array($this, 'dale_comment_submit'));
        add_action('wp_ajax_dale_get_modal_window_content', array($this, 'get_modal_window_content'));
	    add_action('wp_ajax_dale_get_event_list', array( $this, 'get_event_list' ));

    }

    /*
     * return an instance of this class
     */
    public static function get_instance()
    {

        if (null == self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;

    }

    /**
     * Generates the event data in json format
     */
    public function dale_get_event_data()
    {

        //check the referer
        if ( ! check_ajax_referer('dale', 'security', false)) {
            echo "Invalid AJAX Request";
            die();
        }

        $tabs     = array();
        $event_id = intval($_POST['event_id'], 10);

        //Get the transient with included the data of the event if available
        $tabs = get_transient('dale_' . $event_id);

        //Generate the data of the live event only if the transient with the data is not available
        if ($tabs === false) {

            //generate the json part for the timelines data ------------------------------------------------------------
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
            $safe_sql   = $wpdb->prepare("SELECT * FROM $table_name WHERE event_id = %d ORDER BY timeline_id ASC",
                $event_id);
            $timelines  = $wpdb->get_results($safe_sql, ARRAY_A);

            foreach ($timelines as $single_timeline) {

                //Set all the json fields
                $single_timeline_json['timelineId'] = intval($single_timeline['timeline_id'], 10);
                $single_timeline_json['eventId']    = intval($single_timeline['event_id'], 10);
                $single_timeline_json['timeMode']   = intval($single_timeline['time_mode'], 10);
                $single_timeline_json['showIcon']   = intval($single_timeline['show_icon'], 10);
                $single_timeline_json['label']      = stripslashes($single_timeline['label']);
                $single_timeline_json['index']      = intval($single_timeline['index'], 10);

                $table_name      = $wpdb->prefix . $this->shared->get('slug') . "_timeline_item";
                $safe_sql        = $wpdb->prepare("SELECT * FROM $table_name WHERE timeline_id = %d ORDER BY timeline_item_id DESC",
                    $single_timeline['timeline_id']);
                $timeline_item_a = $wpdb->get_results($safe_sql, ARRAY_A);

                if (count($timeline_item_a) > 0) {

                    foreach ($timeline_item_a as $key => $single_timeline_item) {

                        //Add the icon
                        if (intval($single_timeline_item['icon'], 10) === 0) {

                            //Empty Icon
                            $single_timeline_item_json['icon'] = $this->shared->get('url') . 'public/assets/img/empty-icon.svg';

                        } else {

                            //Add the icon from the timeline_icon db
                            $table_name                        = $wpdb->prefix . $this->shared->get('slug') . "_timeline_icon";
                            $safe_sql                          = $wpdb->prepare("SELECT url FROM $table_name WHERE timeline_icon_id = %d",
                                $single_timeline_item['icon']);
                            $timeline_icon_obj                 = $wpdb->get_row($safe_sql);
                            $single_timeline_item_json['icon'] = $timeline_icon_obj->url;

                        }

                        //Set all the json fields
                        $single_timeline_item_json['timelineItemId'] = intval($single_timeline_item['timeline_item_id'],
                            10);
                        $single_timeline_item_json['timelineId']     = intval($single_timeline_item['timeline_id'], 10);
                        $single_timeline_item_json['title']          = stripslashes($single_timeline_item['title']);
                        $single_timeline_item_json['extra']          = intval($single_timeline_item['extra'], 10);
                        $single_timeline_item_json['content']        = wp_kses(wpautop(stripslashes($single_timeline_item['content'])),
                            array(
                                'p' => array(),
                                'br' => array()
                            ));
                        $single_timeline_item_json['html']           = $this->shared->apply_custom_kses(stripslashes($single_timeline_item['html']));
                        $single_timeline_item_json['image']          = stripslashes($single_timeline_item['image']);
                        $single_timeline_item_json['tweet_id']       = stripslashes($single_timeline_item['tweet_id']);
                        if(intval($single_timeline_json['timeMode'], 10) === 0){
                            //Auto
                            $single_timeline_item_json['date']       = mysql2date(get_option('date_format') . ' ' . get_option('time_format'),
                                $single_timeline_item['date']);
                        }else{
                            //Manual
                            $single_timeline_item_json['date']     = stripslashes($single_timeline_item['manual_time']);
                        }

                        //Generate an hash with all the fields of timeline_item
                        $single_timeline_item_json['hash'] = hash('md5',
                            $single_timeline_item['timeline_item_id'] .
                            $single_timeline_item['timeline_id'] .
                            $single_timeline_item['title'] .
                            $single_timeline_item['extra'] .
                            $single_timeline_item['content'] .
                            $single_timeline_item['html'] .
                            $single_timeline_item['image'] .
                            $single_timeline_item['tweet_id'] .
                            $single_timeline_item['date'] .
                            $single_timeline_item['icon']
                        );

                        $single_timeline_json['timelineItem'][] = $single_timeline_item_json;

                    }

                } else {
                    $single_timeline_json['timelineItem'] = null;
                }

                $tabs[] = $single_timeline_json;
                $single_timeline_json = null;

            }

            //generate the json part for the stats data --------------------------------------------------------------------
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat";
            $safe_sql   = $wpdb->prepare("SELECT * FROM $table_name WHERE event_id = %d ORDER BY stat_id ASC",
                $event_id);
            $stats      = $wpdb->get_results($safe_sql, ARRAY_A);

            foreach ($stats as $single_stat) {

                //Set all the json fields
                $single_stat_json['statId']  = intval($single_stat['stat_id'], 10);
                $single_stat_json['eventId'] = intval($single_stat['event_id'], 10);
                $single_stat_json['label']   = stripslashes($single_stat['label']);
                $single_stat_json['index']   = intval($single_stat['index'], 10);

                //Apply stripslashes on varchar and text fields
                $single_stat['label'] = stripslashes($single_stat['label']);

                $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
                $safe_sql     = $wpdb->prepare("SELECT * FROM $table_name WHERE stat_id = %d ORDER BY `index` ASC ,stat_group_id ASC",
                    $single_stat['stat_id']);
                $stat_group_a = $wpdb->get_results($safe_sql, ARRAY_A);

                if (count($stat_group_a) > 0) {

                    //$single_stat['statGroup'] = $stat_group_a;

                    foreach ($stat_group_a as $key => $single_stat_group) {

                        //Set all the json fields
                        $single_stat_json['statGroup'][$key]['statGroupId'] = intval($single_stat_group['stat_group_id'],
                            10);
                        $single_stat_json['statGroup'][$key]['statId']      = stripslashes($single_stat_group['stat_id']);
                        $single_stat_json['statGroup'][$key]['label']       = stripslashes($single_stat_group['label']);
                        $single_stat_json['statGroup'][$key]['index']       = stripslashes($single_stat_group['index']);

                        $table_name  = $wpdb->prefix . $this->shared->get('slug') . "_stat_item";
                        $safe_sql    = $wpdb->prepare("SELECT * FROM $table_name WHERE stat_group_id = %d ORDER BY `index` ASC, stat_item_id ASC",
                            $single_stat_group['stat_group_id']);
                        $stat_item_a = $wpdb->get_results($safe_sql, ARRAY_A);

                        if (count($stat_item_a) > 0) {

                            //Apply stripslashes on varchar and text fields
                            foreach ($stat_item_a as $key2 => $single_stat_item) {

                                $single_stat_json['statGroup'][$key]['statItem'][$key2]['statItemId']  = intval($single_stat_item['stat_item_id'],
                                    10);
                                $single_stat_json['statGroup'][$key]['statItem'][$key2]['statGroupId'] = intval($single_stat_item['stat_group_id'],
                                    10);
                                $single_stat_json['statGroup'][$key]['statItem'][$key2]['type']        = intval($single_stat_item['type'],
                                    10);
                                $single_stat_json['statGroup'][$key]['statItem'][$key2]['subject']     = stripslashes($single_stat_item['subject']);
                                $single_stat_json['statGroup'][$key]['statItem'][$key2]['value1']      = intval($single_stat_item['value_1'], 10);
                                $single_stat_json['statGroup'][$key]['statItem'][$key2]['reference']   = intval($single_stat_item['reference'], 10);
                                $single_stat_json['statGroup'][$key]['statItem'][$key2]['value2']      = intval($single_stat_item['value_2'], 10);
                                $single_stat_json['statGroup'][$key]['statItem'][$key2]['percentage']  = intval($single_stat_item['percentage'],
                                    10);
                                $single_stat_json['statGroup'][$key]['statItem'][$key2]['index']       = intval($single_stat_item['index'],
                                    10);
                                $single_stat_json['statGroup'][$key]['statItem'][$key2]['hash']        = hash('md5',
                                    json_encode($single_stat_item));

                            }

                        } else {

                            $single_stat_json['statGroup'][$key]['statItem'] = null;

                        }

                    }

                } else {
                    $single_stat_json['stat_group'] = null;
                }

                $tabs[] = $single_stat_json;
                $single_stat_json = null;

            }

            //generate the json part for the comments data -----------------------------------------------------------------
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_comment";
            $safe_sql   = $wpdb->prepare("SELECT * FROM $table_name WHERE event_id = %d ORDER BY comment_id ASC",
                $event_id);
            $comments   = $wpdb->get_results($safe_sql, ARRAY_A);

            foreach ($comments as $single_comment) {

                //Set the json fields
                $single_comment_json['commentId']   = intval($single_comment['comment_id'], 10);
                $single_comment_json['eventId']     = intval($single_comment['event_id'], 10);
                $single_comment_json['name']        = stripslashes($single_comment['name']);
                $single_comment_json['description'] = stripslashes($single_comment['description']);
                $single_comment_json['closed']      = intval($single_comment['closed'], 10);

                if(intval(get_option('show_avatars'), 10) === 1 and intval($single_comment['avatar'], 10) === 1){
                    $single_comment_json['avatar'] = 1;
                }else{
                    $single_comment_json['avatar'] = 0;
                }

                $single_comment_json['label']       = stripslashes($single_comment['label']);
                $single_comment_json['index']       = intval($single_comment['index'], 10);

                //add data from 'comment_item'
                $table_name     = $wpdb->prefix . $this->shared->get('slug') . "_comment_item";
                $safe_sql       = $wpdb->prepare("SELECT * FROM $table_name WHERE comment_id = %d AND approved = 1",
                    $single_comment['comment_id']);
                $comment_item_a = $wpdb->get_results($safe_sql, ARRAY_A);

                if (count($comment_item_a) > 0) {

                    //Add additional fields in each single comment
                    foreach ($comment_item_a as $key => $single_comment_item) {

                        //Set the json fields
                        $single_comment_json['commentItem'][$key]['commentItemId'] = intval($single_comment_item['comment_item_id'],
                            10);
                        $single_comment_json['commentItem'][$key]['commentId']     = intval($single_comment_item['comment_id'],
                            10);
                        $single_comment_json['commentItem'][$key]['userId']        = intval($single_comment_item['user_id'],
                            10);
                        $single_comment_json['commentItem'][$key]['content']       = stripslashes($single_comment_item['content']);
                        $single_comment_json['commentItem'][$key]['approved']      = intval($single_comment_item['approved'],
                            10);

                        //Add the 'display_name' of the user
                        $user_info                                               = get_userdata($single_comment_item['user_id']);
                        $single_comment_json['commentItem'][$key]['displayName'] = $user_info->display_name;

                        //Add the 'avatar' of the user
                        $avatar_size = round(3.2307692307 * intval(get_option($this->shared->get('slug') . '_general_base_font_size'), 10), 0);
                        $user_avatar = get_avatar($single_comment_item['user_id'], $avatar_size);
                        if ($user_avatar !== false) {
                            $single_comment_json['commentItem'][$key]['avatar'] = $user_avatar;
                        } else {
                            $single_comment_json['commentItem'][$key]['avatar'] = '';
                        }

                        //Add the 'formattedDate' based on the 'date_format' and 'time_format' WordPress options
                        $single_comment_json['commentItem'][$key]['formattedDate'] = mysql2date(get_option('date_format') . ' ' . get_option('time_format'),
                            $single_comment_item['date']);

                        //Generate an hash with all the fields of comment_item
                        $single_comment_json['commentItem'][$key]['hash'] = hash('md5',
                            $single_comment_item['comment_item_id'] .
                            $single_comment_item['comment_id'] .
                            $single_comment_item['user_id'] .
                            $single_comment_item['content'] .
                            $single_comment_item['approved'] .
                            $single_comment_item['date'] .
                            $single_comment_item['date_gmt']
                        );

                    }

                } else {
                    $single_comment_json['commentItem'] = null;
                }

                $tabs[] = $single_comment_json;
                $single_comment_json = null;

            }

            /*
             * If $tabs is different from false (false is the initial value of $tabs, and it's assigned by the
             * get_transient() function when a transient is not available) sort the tabs based on the index field.
             */
            if($tabs !== false){

                usort($tabs, function ($a, $b) {

                    if ($a['index'] == $b['index']) {

                        /*
                         * If there is no difference in terms of index use this priority:
                         *
                         * 1 - Timeline
                         * 2 - Stat
                         * 3 - Comment
                         *
                         * When there is no index defined and the tabs are of the same type use the id (timelineId, statId,
                         * commentId) to determine the order.
                         */
                        if(isset($a['timelineId']) and isset($b['timelineId'])){
                            if($a['timelineId'] > $b['timelineId']){
                                return 1;
                            }else{
                                return -1;
                            }
                        }else if(isset($a['timelineId']) and isset($b['statId'])){
                            return -1;
                        }else if(isset($a['timelineId']) and isset($b['commentId'])){
                            return -1;
                        }else if(isset($a['statId']) and isset($b['timelineId'])){
                            return 1;
                        }else if(isset($a['statId']) and isset($b['statId'])){
                            if($a['statId'] > $b['statId']){
                                return 1;
                            }else{
                                return -1;
                            }
                        }else if(isset($a['statId']) and isset($b['commentId'])){
                            return -1;
                        }else if(isset($a['commentId']) and isset($b['timelineId'])){
                            return 1;
                        }else if(isset($a['commentId']) and isset($b['statId'])){
                            return 1;
                        }else if(isset($a['commentId']) and isset($b['commentId'])){
                            if($a['commentId'] > $b['commentId']){
                                return 1;
                            }else{
                                return -1;
                            }
                        }
                    }else{

                        /*
                         * If there is a difference in term of index use it to determine the order.
                         */
                        return ($a['index'] > $b['index']) ? 1 : -1;

                    }

                });

            }

            //Convert the array to an object
            $tabs = (object)$tabs;

            //Add the "live" flag
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_event";
            $safe_sql   = $wpdb->prepare("SELECT live FROM $table_name WHERE event_id = %d", $event_id);
            $event_obj  = $wpdb->get_row($safe_sql);

            if($event_obj === null){

                //If the event doesn't exist stop the live updates
                $tabs->live = false;

            }else{

                //Set the live update status
                if (intval($event_obj->live, 10) === 1) {
                    $tabs->live = true;
                } else {
                    $tabs->live = false;
                }

            }

            //Add the "user_comment" flag
            if (current_user_can(get_option($this->shared->get('slug') . '_advanced_write_comments_capability'))) {
                $tabs->user_comment = true;
            } else {
                $tabs->user_comment = false;
            }

            //Set the transient
            $transient_expiration = intval(get_option($this->shared->get('slug') . '_advanced_transient_expiration'),
                10);
            if ($transient_expiration > 0) {
                set_transient('dale_' . $event_id, $tabs, $transient_expiration);
            }

        }

        //generate the json output from the tab array
        echo json_encode($tabs);

        die();

    }

    /**
     * Given the timeline_id return the timeline data are returned
     */
    public function get_timeline_data()
    {

        //check the referer
        if ( ! check_ajax_referer('dale', 'security', false)) {
            echo "Invalid AJAX Request";
            die();
        }

        //check the capability
        if ( ! current_user_can(get_option($this->shared->get('slug') . '_advanced_timeline_items_menu_capability'))) {
            echo 'Invalid Capability';
            die();
        }

        $timeline_id = intval($_POST['timeline_id'], 10);

        global $wpdb;
        $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
        $safe_sql     = $wpdb->prepare("SELECT * FROM $table_name WHERE timeline_id = %d ", $timeline_id);
        $timeline_obj = $wpdb->get_row($safe_sql);

        //generate the json output
        echo json_encode($timeline_obj);

        die();

    }

    /**
     * Save the comment submitted in the front-end with the form available in the comment section
     */
    public function dale_comment_submit()
    {

        //check the referer
        if ( ! check_ajax_referer('dale', 'security', false)) {
            echo "Invalid AJAX Request";
            die();
        }

        //check the capability
        if (get_current_user_id() !== 0 and ! current_user_can(get_option($this->shared->get('slug') . '_advanced_write_comments_capability'))) {
            echo 'Invalid Capability';
            die();
        }

        $comment_id      = intval($_POST['comment_id'], 10);
        $comment_item_id = intval($_POST['comment_item_id'], 10);
        $content         = $_POST['content'];
        $user_id         = get_current_user_id();
        $date            = current_time('mysql', 0);
        $date_gmt        = current_time('mysql', 1);

        if (!$this->shared->comment_exists($comment_id)) {
            echo "The comment section doesn't exist";
            die();
        }

        if ($this->shared->comments_are_closed($comment_id)) {
            echo 'Comments are closed';
            die();
        }

        if ($this->shared->is_comment_spam($user_id)) {
            echo 'Too many comments';
            die();
        }

        //insert into the database
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_comment_item";
        $safe_sql   = $wpdb->prepare("INSERT INTO $table_name SET 
                    comment_id = %d,
                    user_id = %d,
                    content = %s,
                    approved = %d,
                    date = %s,
                    date_gmt = %s",
            $comment_id,
            $user_id,
            $content,
            0,
            $date,
            $date_gmt);

        $query_result     = $wpdb->query($safe_sql);
        $last_inserted_id = $wpdb->insert_id;

        if ($query_result !== false) {

            $result = 'Under Moderation';

        } else {
            $result = 'Unable to save the comment';
        }

        echo $result;
        die();

    }

    /**
     * This method is used to retrieve the content of the modal window generated when the TinyMCE "Live Events" button
     * is clicked.
     */
    function get_modal_window_content()
    {

        //check the referer
        if ( ! check_ajax_referer('dale', 'security', false)) {
            echo "Invalid AJAX Request";
            die();
        }

        //check the capability
        if ( ! current_user_can(get_option($this->shared->get('slug') . '_advanced_events_menu_capability'))) {
            echo 'Invalid Capability';
            die();
        }

        $output = '<div id="dale-liveevents-body-container">';
        $output .= '<h3>' . esc_attr__('Select the Event', 'dalE') . '</h3>';
        $output .= '<select id="event-id" data-placeholder="' . esc_attr__('Choose an Event', 'dale') . '">';

        global $wpdb;
        $table_name = $wpdb->prefix . "dale_event";
        $sql        = "SELECT event_id, name FROM $table_name ORDER BY event_id DESC";
        $event_a    = $wpdb->get_results($sql, ARRAY_A);
        foreach ($event_a as $key => $event) {
            $output .= '<option value="' . intval($event['event_id'],
                    10) . '">' . esc_attr(stripslashes($event['name'])) . '</option>';
        }

        $output .= '</select>';
        $output .= '</div>';

        echo $output;
        die();

    }

	/**
	 * A JSON string that includes ID and name of all the events is returned.
	 */
	function get_event_list() {

		//check the referer
		if ( ! check_ajax_referer( 'dale', 'security', false ) ) {
			echo "Invalid AJAX Request";
			die();
		}

		global $wpdb;
		$table_name = $wpdb->prefix . "dale_event";
		$sql = "SELECT event_id, name FROM $table_name ORDER BY event_id DESC";
		$table_a = $wpdb->get_results($sql, ARRAY_A);

		echo json_encode($table_a);
		die();

	}

}