<?php

//Prevent direct access to this file
if ( ! defined( 'WPINC' ) ) {
    die();
}

/**
 * Enqueue the Gutenberg block assets for the backend.
 *
 * This function should be used for:
 *
 * - Hooks into editor only
 * - For main block JS
 * - For editor only block CSS overrides
 */
function dale_editor_assets() {

    $shared = dale_Shared::get_instance();

    //Styles -----------------------------------------------------------------------------------------------------------
    wp_enqueue_style(
        'dale-editor-css',
	    $shared->get('url') . 'blocks/dist/editor.build.css',
        array( 'wp-edit-blocks' ),//Dependency to include the CSS after it.
	    filemtime( $shared->get('dir') . 'blocks/dist/editor.build.css')
    );

    //Scripts ----------------------------------------------------------------------------------------------------------
    wp_enqueue_script(
        'dale-editor-js', // Handle.
	    $shared->get('url') . 'blocks/dist/blocks.build.js', //We register the block here.
	    /*
	     * Dependencies:
	     *
		 * - 'wp-blocks': includes block type registration and related functions.
		 * - 'wp-element': includes the WordPress Element abstraction for describing the structure of the blocks.
		 */
        array( 'wp-blocks', 'wp-element' ),
	    filemtime( $shared->get('dir') . 'blocks/dist/blocks.build.js'),
        true //Enqueue the script in the footer.
    );

    /*
     * Add the translations associated with this script in the JED/json format.
     *
     * Reference: https://make.wordpress.org/core/2018/11/09/new-javascript-i18n-support-in-wordpress/
     *
     * Argument 1: Handler
     * Argument 2: Domain
     * Argument 3: Location where the JED/json file is located.
     *
     * Note that:
     *
     * - The JED/json file should be named [domain]-[locale]-[handle].json to be actually detected by WordPress.
     * - The JED/json file is generated with https://github.com/mikeedwards/po2json from the .po file
     */
	wp_set_script_translations( 'dale-editor-js', 'dale', $shared->get('dir') . 'blocks/lang' );

}
add_action( 'enqueue_block_editor_assets', 'dale_editor_assets' );

/**
 * Enqueue the Gutenberg block assets for both frontend and backend.
 *
 *  * This function should be used for:
 *
 * - Hooks into editor and frontend
 * - For main block CSS
 * - With !is_admin() loads frontend only
 */
function dale_style_assets() {

    //Not used with this block.
    return;

    //Styles -----------------------------------------------------------------------------------------------------------
    wp_enqueue_style(
        'dale-style-css',
        $shared->get('url') . 'blocks/dist/style.build.css',
        array( 'wp-blocks' ),//Dependency to include the CSS after it
	    filemtime( $shared->get('dir') . 'blocks/dist/style.build.css')
    );

	//Scripts ----------------------------------------------------------------------------------------------------------

	//Loaded only in the frontend
	if(!is_admin()){

		//Styles -----------------------------------------------------------------------------------------------------------

		//Scripts ----------------------------------------------------------------------------------------------------------

	}

}
add_action( 'enqueue_block_assets', 'dale_style_assets' );

/**
 * Dynamic Block Server Component
 *
 * For more info:
 *
 * https://wordpress.org/gutenberg/handbook/blocks/creating-dynamic-blocks/
 */
function dale_event_render($attributes) {

    if(isset($attributes['eventId'])){

        $public = dale_Public::get_instance();
        return $public->display_live_event(
        	array('id' => $attributes['eventId'])
        );
    }

}

register_block_type( 'dale/event', array(
    'render_callback' => 'dale_event_render',
) );