<?php

if ( ! current_user_can(get_option($this->shared->get('slug') . '_advanced_timeline_icons_menu_capability'))) {
    wp_die(esc_attr__('You do not have sufficient permissions to access this page.', 'dale'));
}

?>

<!-- process data -->

<?php

if (isset($_POST['update_id']) or isset($_POST['form_submitted'])) {

    extract($_POST);

    //prepare data -----------------------------------------------------------------------------------------------------
    if (isset($update_id)) {
        $update_id = intval($update_id, 10);
    }
    $name        = trim($name);
    $description = trim($description);
    $url         = trim($url);

    //validation -------------------------------------------------------------------------------------------------------

    $invalid_data_message = '';

    //validation on "timeline_icon_id"
    if (isset($update_id)) {
        if ( ! $this->shared->timeline_icon_exists($update_id)) {
            $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__("The timeline icon doesn't exist.",
                    'dale') . '</p></div>';
            $invalid_data         = true;
        }
    }

    //validation on "name"
    if (strlen(trim($name)) == 0 or strlen($name) > 255) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Name" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "description"
    if (strlen(trim($description)) === 0 or strlen(trim($description)) > 255) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Description" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "url"
    if (strlen(trim($url)) == 0 or strlen($url) > 2083) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Image" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

}

//update ---------------------------------------------------------------
if (isset($_POST['update_id']) and ! isset($invalid_data)) {

    //update the database
    global $wpdb;
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline_icon";
    $safe_sql   = $wpdb->prepare("UPDATE $table_name SET 
                name = %s,
                description = %s,
                url = %s
                WHERE timeline_icon_id = %d",
        $name,
        $description,
        $url,
        $update_id);

    $query_result = $wpdb->query($safe_sql);

    if ($query_result !== false) {
        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The timeline icon has been successfully updated.',
                'dale') . '</p></div>';
    }

} else {

    //add ------------------------------------------------------------------
    if (isset($_POST['form_submitted']) and ! isset($invalid_data)) {

        //insert into the database
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline_icon";
        $safe_sql   = $wpdb->prepare("INSERT INTO $table_name SET 
                name = %s,
                description = %s,
                url = %s",
            $name,
            $description,
            $url
        );

        $query_result = $wpdb->query($safe_sql);

        if ($query_result !== false) {
            $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The timeline icon has been successfully added.',
                    'dale') . '</p></div>';
        }

    }

}

//delete a timeline icon
if (isset($_POST['delete_id'])) {

    global $wpdb;
    $delete_id = intval($_POST['delete_id'], 10);

    //delete this timeline_icon
    if ( ! $this->shared->timeline_icon_is_used($delete_id)) {

        $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_timeline_icon";
        $safe_sql     = $wpdb->prepare("DELETE FROM $table_name WHERE timeline_icon_id = %d ", $delete_id);
        $query_result = $wpdb->query($safe_sql);

        if ($query_result !== false) {
            $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The timeline icon has been successfully deleted.',
                    'dale') . '</p></div>';
        }

    } else {

        $process_data_message = '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The timeline icon is used in a timeline item.',
                'dale') . '</p></div>';

    }

}

//get the timeline icon data
if (isset($_GET['edit_id'])) {
    $edit_id = intval($_GET['edit_id'], 10);
    global $wpdb;
    $table_name        = $wpdb->prefix . $this->shared->get('slug') . "_timeline_icon";
    $safe_sql          = $wpdb->prepare("SELECT * FROM $table_name WHERE timeline_icon_id = %d ", $edit_id);
    $timeline_icon_obj = $wpdb->get_row($safe_sql);
}

?>

<!-- output -->

<div class="wrap">

    <div id="daext-header-wrapper" class="daext-clearfix">

        <h2><?php esc_attr_e('Live Events - Timeline Icons', 'dale'); ?></h2>

        <form action="admin.php" method="get" id="daext-search-form">

            <input type="hidden" name="page" value="dale-timeline-icons">

            <p><?php esc_attr_e('Perform your Search', 'dale'); ?></p>

            <?php
            if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {
                $search_string = $_GET['s'];
            } else {
                $search_string = '';
            }
            ?>

            <input type="text" name="s"
                   value="<?php echo esc_attr(stripslashes($search_string)); ?>" autocomplete="off" maxlength="255">
            <input type="submit" value="">

        </form>

    </div>

    <div id="daext-menu-wrapper">

        <?php if (isset($invalid_data_message)) {
            echo $invalid_data_message;
        } ?>
        <?php if (isset($process_data_message)) {
            echo $process_data_message;
        } ?>

        <!-- table -->

        <?php

        $filter = '';

        //create the query part used to filter the results when a search is performed
        if (strlen(trim($filter)) === 0 and isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {
            $search_string = $_GET['s'];
            global $wpdb;
            $filter = $wpdb->prepare('WHERE (name LIKE %s OR description LIKE %s)', '%' . $search_string . '%',
                '%' . $search_string . '%');
        }

        //retrieve the total number of timelines icons
        global $wpdb;
        $table_name  = $wpdb->prefix . $this->shared->get('slug') . "_timeline_icon";
        $total_items = $wpdb->get_var("SELECT COUNT(*) FROM $table_name $filter");

        //Initialize the pagination class
        require_once($this->shared->get('dir') . '/admin/inc/class-dale-pagination.php');
        $pag = new dale_pagination();
        $pag->set_total_items($total_items);//Set the total number of items
        $pag->set_record_per_page(intval(get_option($this->shared->get('slug') . '_advanced_timeline_icons_menu_pagination'))); //Set records per page
        $pag->set_target_page("admin.php?page=" . $this->shared->get('slug') . "-timeline-icons");//Set target page
        $pag->set_current_page();//set the current page number from $_GET

        ?>

        <!-- Query the database -->
        <?php
        $query_limit = $pag->query_limit();
        $results     = $wpdb->get_results("SELECT * FROM $table_name $filter ORDER BY timeline_icon_id DESC $query_limit",
            ARRAY_A); ?>

        <?php if (count($results) > 0) : ?>

            <div class="daext-items-container">

                <!-- list of tables -->
                <table class="daext-items">
                    <thead>
                    <tr>
                        <th><?php esc_attr_e('Name', 'dale'); ?></th>
                        <th><?php esc_attr_e('Description', 'dale'); ?></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach ($results as $result) : ?>
                        <tr>
                            <td><?php echo esc_attr(stripslashes($result['name'])); ?></td>
                            <td><?php echo esc_attr(stripslashes($result['description'])); ?></td>
                            <td class="icons-container">
                                <a class="menu-icon edit"
                                   href="admin.php?page=<?php echo $this->shared->get('slug'); ?>-timeline-icons&edit_id=<?php echo $result['timeline_icon_id']; ?>"></a>
                                <form method="POST"
                                      action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-timeline-icons">
                                    <input type="hidden" value="<?php echo $result['timeline_icon_id']; ?>"
                                           name="delete_id">
                                    <input class="menu-icon delete" type="submit" value="">
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>

                    </tbody>

                </table>

            </div>

            <!-- Display the pagination -->
            <?php if ($pag->total_items > 0) : ?>
                <div class="daext-tablenav daext-clearfix">
                    <div class="daext-tablenav-pages">
                        <span class="daext-displaying-num"><?php echo $pag->total_items; ?>&nbsp<?php esc_attr_e('items',
                                'dale'); ?></span>
                        <?php $pag->show(); ?>
                    </div>
                </div>
            <?php endif; ?>

        <?php else : ?>

            <?php

            if (strlen(trim($filter)) > 0) {
                echo '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('There are no results that match your filter.',
                        'dale') . '</p></div>';
            }

            ?>

        <?php endif; ?>

        <div>

            <form method="POST" action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-timeline-icons"
                  autocomplete="off">

                <input type="hidden" value="1" name="form_submitted">

                <?php if (isset($_GET['edit_id'])) : ?>

                <!-- Edit an Events -->

                <div class="daext-form-container">

                    <h3 class="daext-form-title"><?php esc_attr_e('Edit Timeline Icon',
                            'dale'); ?>&nbsp<?php echo $timeline_icon_obj->timeline_icon_id; ?></h3>

                    <table class="daext-form">

                        <input type="hidden" name="update_id"
                               value="<?php echo $timeline_icon_obj->timeline_icon_id; ?>"/>

                        <!-- Name -->
                        <tr valign="top">
                            <th scope="row"><label for="name"><?php esc_attr_e('Name', 'dale'); ?></label></th>
                            <td>
                                <input value="<?php echo esc_attr(stripslashes($timeline_icon_obj->name)); ?>"
                                       type="text" id="name" maxlength="255" size="30" name="name"/>
                                <div class="help-icon"
                                     title="<?php esc_attr_e('The name of the icon.', 'dale'); ?>"></div>
                            </td>
                        </tr>

                        <!-- Description -->
                        <tr valign="top">
                            <th scope="row"><label for="description"><?php esc_attr_e('Description', 'dale'); ?></label>
                            </th>
                            <td>
                                <input value="<?php echo esc_attr(stripslashes($timeline_icon_obj->description)); ?>"
                                       type="text" id="description" maxlength="255" size="30" name="description"/>
                                <div class="help-icon"
                                     title="<?php esc_attr_e('The description of the icon.', 'dale'); ?>"></div>
                            </td>
                        </tr>

                        <!-- URL -->
                        <tr valign="top">
                            <th scope="row"><label for="url"><?php esc_attr_e('Image', 'dale'); ?></label></th>
                            <td>

                                <div class="image-uploader">
                                    <img class="selected-image"
                                         src="<?php echo esc_attr(stripslashes($timeline_icon_obj->url)); ?>" <?php echo strlen(trim($timeline_icon_obj->url)) == 0 ? 'style="display: none;"' : ''; ?>>
                                    <input value="<?php echo esc_attr(stripslashes($timeline_icon_obj->url)); ?>"
                                           type="hidden" id="url" name="url" maxlength="2083">
                                    <a class="button_add_media"
                                       data-set-remove="<?php echo strlen(trim($timeline_icon_obj->url)) == 0 ? 'set' : 'remove'; ?>"
                                       data-set="<?php esc_attr_e('Set image', 'dale'); ?>"
                                       data-remove="<?php esc_attr_e('Remove Image',
                                           'dale'); ?>"><?php echo strlen(trim($timeline_icon_obj->url)) == 0 ? esc_attr__('Set image',
                                            'dale') : esc_attr__('Remove image', 'dale'); ?></a>
                                    <p class="description"><?php esc_attr_e("Select an image that represents this timeline icon.",
                                            "dale"); ?></p>
                                </div>

                            </td>
                        </tr>

                    </table>

                    <!-- submit button -->
                    <div class="daext-form-action">
                        <input class="button" type="submit"
                               value="<?php esc_attr_e('Update Timeline Icon', 'dale'); ?>">
                        <input id="cancel" class="button" type="submit" value="<?php esc_attr_e( 'Cancel', 'dale'); ?>">
                    </div>

                    <?php else : ?>

                    <!-- Create New Timeline Icon -->

                    <div class="daext-form-container">

                        <div class="daext-form-title"><?php esc_attr_e('Create New Timeline Icon', 'dale'); ?></div>

                        <table class="daext-form">

                            <!-- Name -->
                            <tr valign="top">
                                <th scope="row"><label for="title"><?php esc_attr_e('Name', 'dale'); ?></label></th>
                                <td>
                                    <input type="text" id="name" maxlength="255" size="30" name="name"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('The name of the timeline icon.', 'dale'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Description -->
                            <tr valign="top">
                                <th scope="row"><label for="descripition"><?php esc_attr_e('Description',
                                            'dale'); ?></label></th>
                                <td>
                                    <input type="text" id="description" maxlength="255" size="30" name="description"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('The description of the timeline icon.',
                                             'dale'); ?>"></div>
                                </td>
                            </tr>

                            <!-- URL -->
                            <tr valign="top">
                                <th scope="row"><label for="url"><?php esc_attr_e('Image', 'dale'); ?></label></th>
                                <td>

                                    <div class="image-uploader">
                                        <img class="selected-image" src="" style="display: none">
                                        <input type="hidden" id="url" maxlength="2083" name="url">
                                        <a class="button_add_media" data-set-remove="set"
                                           data-set="<?php esc_attr_e('Set Image', 'dale'); ?>"
                                           data-remove="<?php esc_attr_e('Remove Image',
                                               'dale'); ?>"><?php esc_attr_e('Set image', 'dale'); ?></a>
                                        <p class="description"><?php esc_attr_e("Select an image that represents this timeline icon.",
                                                "dale"); ?></p>
                                    </div>

                                </td>
                            </tr>

                        </table>

                        <!-- submit button -->
                        <div class="daext-form-action">
                            <input class="button" type="submit"
                                   value="<?php esc_attr_e('Add Timeline Icon', 'dale'); ?>">
                        </div>

                        <?php endif; ?>

                    </div>

            </form>

        </div>

    </div>

</div>