<?php

if ( ! current_user_can('manage_options')) {
    wp_die(__('You do not have sufficient capabilities to access this page.'));
}

?>

<div class="wrap">

    <h2><?php esc_attr_e('Live Events - Options', 'dale'); ?></h2>

    <?php

    //settings errors
    if (isset($_GET['settings-updated']) and $_GET['settings-updated'] == 'true') {
        if ($this->write_custom_css() === false) {
            ?>
            <div id="setting-error-settings_updated" class="error settings-error notice is-dismissible below-h2">
                <p>
                    <strong>The <?php echo $this->shared->get('dir') . 'public/assets/css/custom-' . get_current_blog_id() . '.css'; ?>
                        file should be writable by the server. Please change its permissions and try again.</strong></p>
                <button type="button" class="notice-dismiss"><span
                            class="screen-reader-text">Dismiss this notice.</span></button>
            </div>
            <?php
        }
        settings_errors();
    }

    ?>

    <div id="daext-options-wrapper">

        <?php
        //get current tab value
        $active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'general_options';
        ?>

        <div class="nav-tab-wrapper">
            <a href="?page=dale-options&tab=general_options"
               class="nav-tab <?php echo $active_tab == 'general_options' ? 'nav-tab-active' : ''; ?>"><?php esc_attr_e('General',
                    'dale'); ?></a>
            <a href="?page=dale-options&tab=timeline_options"
               class="nav-tab <?php echo $active_tab == 'timeline_options' ? 'nav-tab-active' : ''; ?>"><?php esc_attr_e('Timeline',
                    'dale'); ?></a>
            <a href="?page=dale-options&tab=comment_options"
               class="nav-tab <?php echo $active_tab == 'comment_options' ? 'nav-tab-active' : ''; ?>"><?php esc_attr_e('Comment',
                    'dale'); ?></a>
            <a href="?page=dale-options&tab=stat_options"
               class="nav-tab <?php echo $active_tab == 'stat_options' ? 'nav-tab-active' : ''; ?>"><?php esc_attr_e('Stat',
                    'dale'); ?></a>
            <a href="?page=dale-options&tab=social_options"
               class="nav-tab <?php echo $active_tab == 'social_options' ? 'nav-tab-active' : ''; ?>"><?php esc_attr_e('Social',
                    'dale'); ?></a>
            <a href="?page=dale-options&tab=advanced_options"
               class="nav-tab <?php echo $active_tab == 'advanced_options' ? 'nav-tab-active' : ''; ?>"><?php esc_attr_e('Advanced',
                    'dale'); ?></a>
        </div>

        <form method='post' action='options.php'>

            <?php

            if ($active_tab == 'general_options') {

                settings_fields($this->shared->get('slug') . '_general_options');
                do_settings_sections($this->shared->get('slug') . '_general_options');

            }

            if ($active_tab == 'timeline_options') {

                settings_fields($this->shared->get('slug') . '_timeline_options');
                do_settings_sections($this->shared->get('slug') . '_timeline_options');

            }

            if ($active_tab == 'comment_options') {

                settings_fields($this->shared->get('slug') . '_comment_options');
                do_settings_sections($this->shared->get('slug') . '_comment_options');

            }

            if ($active_tab == 'stat_options') {

                settings_fields($this->shared->get('slug') . '_stat_options');
                do_settings_sections($this->shared->get('slug') . '_stat_options');

            }

            if ($active_tab == 'social_options') {

                settings_fields($this->shared->get('slug') . '_social_options');
                do_settings_sections($this->shared->get('slug') . '_social_options');

            }

            if ($active_tab == 'advanced_options') {

                settings_fields($this->shared->get('slug') . '_advanced_options');
                do_settings_sections($this->shared->get('slug') . '_advanced_options');

            }

            ?>

            <div class="daext-options-action">
                <input type="submit" name="submit" id="submit" class="button"
                       value="<?php esc_attr_e('Save Changes', 'dale'); ?>">
            </div>

        </form>

    </div>

</div>