<?php

if ( ! current_user_can(get_option($this->shared->get('slug') . '_advanced_comment_items_menu_capability'))) {
    wp_die(esc_attr__('You do not have sufficient permissions to access this page.', 'dale'));
}

?>

<!-- process data -->

<?php

if (isset($_POST['update_id']) or isset($_POST['form_submitted'])) {

    extract($_POST);

    $invalid_data_message = '';

    //prepare data -----------------------------------------------------------------------------------------------------
    $comment_id = intval($comment_id, 10);
    $user_id    = intval($user_id, 10);
    $content    = trim($content);
    $approved   = intval($approved, 10) === 1 ? 1 : 0;

    //validation -------------------------------------------------------------------------------------------------------

    //validation on "content"
    if (strlen(trim($content)) === 0 or strlen($content) > 65535) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Content" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

}

//update ---------------------------------------------------------------
if (isset($_POST['update_id']) and ! isset($invalid_data)) {

    //update the database
    global $wpdb;
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_comment_item";
    $safe_sql   = $wpdb->prepare("UPDATE $table_name SET
                comment_id = %d,
                user_id = %d,
                content = %s,
                approved = %d
                WHERE comment_item_id = %d",
        $comment_id,
        $user_id,
        $content,
        $approved,
        $update_id);

    $query_result = $wpdb->query($safe_sql);

    if ($query_result !== false) {
        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The comment item has been successfully updated.',
                'dale') . '</p></div>';
    }

} else {

    //add ------------------------------------------------------------------
    if (isset($_POST['form_submitted']) and ! isset($invalid_data)) {

        //insert into the database
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_comment_item";
        $safe_sql   = $wpdb->prepare("INSERT INTO $table_name SET 
                comment_id = %d,
                user_id = %d,
                content = %s,
                approved = %d,
                date = %s,
                date_gmt = %s",
            $comment_id,
            $user_id,
            $content,
            $approved,
            current_time('mysql', 0),
            current_time('mysql', 1)
        );

        $query_result = $wpdb->query($safe_sql);

        if ($query_result !== false) {
            $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The comment item has been successfully added.',
                    'dale') . '</p></div>';
        }

    }

}

//delete a comment item
if (isset($_POST['delete_id'])) {

    global $wpdb;
    $delete_id = intval($_POST['delete_id'], 10);

    //delete this comment item
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_comment_item";
    $safe_sql   = $wpdb->prepare("DELETE FROM $table_name WHERE comment_item_id = %d ", $delete_id);

    $query_result = $wpdb->query($safe_sql);

    if ($query_result !== false) {
        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The comment item has been successfully deleted.',
                'dale') . '</p></div>';
    }

}

//get the comment item data
if (isset($_GET['edit_id'])) {
    $edit_id = intval($_GET['edit_id'], 10);
    global $wpdb;
    $table_name       = $wpdb->prefix . $this->shared->get('slug') . "_comment_item";
    $safe_sql         = $wpdb->prepare("SELECT * FROM $table_name WHERE comment_item_id = %d ", $edit_id);
    $comment_item_obj = $wpdb->get_row($safe_sql);
}

//Get the value of the custom filter
if (isset($_GET['cf']) and $_GET['cf'] != 'all') {
    $comment_id_in_cf = intval($_GET['cf'], 10);
} else {
    $comment_id_in_cf = false;
}

?>

<!-- output -->

<div class="wrap">

    <div id="daext-header-wrapper" class="daext-clearfix">

        <h2><?php esc_attr_e('Live Events - Comment Items', 'dale'); ?></h2>

        <!-- Search Form -->

        <form action="admin.php" method="get" id="daext-search-form">

            <input type="hidden" name="page" value="dale-comment-items">

            <p><?php esc_attr_e('Perform your Search', 'dale'); ?></p>

            <?php

            //Search
            if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {
                $search_string = $_GET['s'];
            } else {
                $search_string = '';
            }

            //Custom Filter
            if ($comment_id_in_cf !== false) {
                echo '<input type="hidden" name="cf" value="' . $comment_id_in_cf . '">';
            }

            ?>

            <input type="text" name="s" value="<?php echo esc_attr(stripslashes($search_string)); ?>" autocomplete="off"
                   maxlength="255">
            <input type="submit" value="">

        </form>

        <!-- Filter Form -->

        <form method="GET" action="admin.php" id="daext-filter-form">

            <input type="hidden" name="page" value="<?php echo $this->shared->get('slug'); ?>-comment-items">

            <p><?php esc_attr_e('Filter by Comment Section', 'dale'); ?></p>

            <select id="cf" name="cf" class="daext-display-none">

                <option value="all" <?php if (isset($_GET['cf'])) {
                    selected($_GET['cf'], 'all');
                } ?>><?php esc_attr_e('All', 'dale'); ?></option>

                <?php

                global $wpdb;
                $table_name = $wpdb->prefix . $this->shared->get('slug') . "_comment";
                $safe_sql   = "SELECT comment_id, name FROM $table_name ORDER BY comment_id DESC";
                $comments_a = $wpdb->get_results($safe_sql, ARRAY_A);

                foreach ($comments_a as $key => $comment) {

                    if (isset($_GET['cf'])) {
                        echo '<option value="' . $comment['comment_id'] . '" ' . selected($_GET['cf'],
                                $comment['comment_id'],
                                false) . '>' . esc_attr(stripslashes($comment['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_comment($comment['comment_id'])))) . '</option>';
                    } else {
                        echo '<option value="' . $comment['comment_id'] . '">' . esc_attr(stripslashes($comment['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_comment($comment['comment_id'])))) . '</option>';

                    }

                }

                ?>

            </select>

        </form>

    </div>

    <div id="daext-menu-wrapper">

        <?php if (isset($invalid_data_message)) {
            echo $invalid_data_message;
        } ?>
        <?php if (isset($process_data_message)) {
            echo $process_data_message;
        } ?>

        <!-- table -->

        <?php

        //Prevent the creation of a comment item if there are no comment sections
        if ($this->shared->get_number_of_comment_sections() > 0){

        //custom filter
        if ($comment_id_in_cf === false) {
            $filter = '';
        } else {
            global $wpdb;
            $filter = $wpdb->prepare("WHERE comment_id = %d", $comment_id_in_cf);
        }

        //create the query part used to filter the results when a search is performed
        if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {

            $search_string = $_GET['s'];
            global $wpdb;

            if (strlen(trim($filter)) > 0) {
                $filter .= $wpdb->prepare(' AND (content LIKE %s)', '%' . $search_string . '%');
            } else {
                $filter = $wpdb->prepare('WHERE (content LIKE %s)', '%' . $search_string . '%');
            }

        }

        //retrieve the total number of comments
        global $wpdb;
        $table_name  = $wpdb->prefix . $this->shared->get('slug') . "_comment_item";
        $total_items = $wpdb->get_var("SELECT COUNT(*) FROM $table_name $filter");

        //Initialize the pagination class
        require_once($this->shared->get('dir') . '/admin/inc/class-dale-pagination.php');
        $pag = new dale_pagination();
        $pag->set_total_items($total_items);//Set the total number of items
        $pag->set_record_per_page(intval(get_option($this->shared->get('slug') . '_advanced_comment_items_menu_pagination'))); //Set records per page
        $pag->set_target_page("admin.php?page=" . $this->shared->get('slug') . "-comment-items");//Set target page
        $pag->set_current_page();//set the current page number from $_GET

        ?>

        <!-- Query the database -->
        <?php
        $query_limit = $pag->query_limit();
        $results     = $wpdb->get_results("SELECT * FROM $table_name $filter ORDER BY comment_item_id DESC $query_limit",
            ARRAY_A); ?>

        <?php if (count($results) > 0) : ?>

            <div class="daext-items-container">

                <!-- list of tables -->
                <table class="daext-items">
                    <thead>
                    <tr>
                        <th><?php esc_attr_e('Author', 'dale'); ?></th>
                        <th><?php esc_attr_e('Date', 'dale'); ?></th>
                        <th><?php esc_attr_e('Comment Section', 'dale'); ?></th>
                        <th><?php esc_attr_e('Event', 'dale'); ?></th>
                        <th><?php esc_attr_e('Approved', 'dale'); ?></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach ($results as $result) : ?>
                        <tr>
                            <td>
                                <?php
                                $user_info = get_userdata($result['user_id']);
                                $user_link = get_edit_user_link($result['user_id']);
                                echo '<a href="' . $user_link . '">' . esc_attr(stripslashes($user_info->display_name)) . '</a>';
                                ?>
                            </td>
                            <td><?php echo esc_attr(mysql2date(get_option('date_format') . ' ' . get_option('time_format'),
                                    $result['date'])); ?></td>
                            <td>
                                <?php
                                $comment_obj = $this->shared->get_comment_data($result['comment_id']);
                                echo esc_attr(stripslashes($comment_obj->name));
                                ?>
                            </td>
                            <td><?php echo esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_comment($result['comment_id'])))); ?></td>
                            <td><?php echo $result['approved'] == 1 ? esc_attr__('Yes', 'dale') : esc_attr__('No',
                                    'dale'); ?></td>
                            <td class="icons-container">

                                <?php

                                //Edit -----------------------------------------------------------------------------
                                if ($comment_id_in_cf === false) {
                                    echo '<a class="menu-icon edit" href="admin.php?page=' . $this->shared->get('slug') . '-comment-items&edit_id=' . $result['comment_item_id'] . '"></a>';
                                } else {
                                    echo '<a class="menu-icon edit" href="admin.php?page=' . $this->shared->get('slug') . '-comment-items&edit_id=' . $result['comment_item_id'] . '&cf=' . $comment_id_in_cf . '"></a>';
                                }

                                //Delete ---------------------------------------------------------------------------
                                if ($comment_id_in_cf === false) {

                                    ?>
                                    <form method="POST"
                                          action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-comment-items">
                                        <input type="hidden" value="<?php echo $result['comment_item_id']; ?>"
                                               name="delete_id">
                                        <input class="menu-icon delete" type="submit" value="">
                                    </form>
                                    <?php

                                } else {

                                    ?>
                                    <form method="POST"
                                          action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-comment-items&cf=<?php echo $comment_id_in_cf; ?>">
                                        <input type="hidden" value="<?php echo $result['comment_item_id']; ?>"
                                               name="delete_id">
                                        <input class="menu-icon delete" type="submit" value="">
                                    </form>
                                    <?php

                                }

                                ?>

                            </td>
                        </tr>
                    <?php endforeach; ?>

                    </tbody>

                </table>

            </div>

            <!-- Display the pagination -->
            <?php if ($pag->total_items > 0) : ?>
                <div class="daext-tablenav daext-clearfix">
                    <div class="daext-tablenav-pages">
                        <span class="daext-displaying-num"><?php echo $pag->total_items; ?>&nbsp<?php esc_attr_e('items',
                                'dale'); ?></span>
                        <?php $pag->show(); ?>
                    </div>
                </div>
            <?php endif; ?>

        <?php else : ?>

            <?php

            if (strlen(trim($filter)) > 0) {
                echo '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('There are no results that match your filter.',
                        'dale') . '</p></div>';
            }

            ?>

        <?php endif; ?>

        <?php

        if ($comment_id_in_cf === false) {
            echo '<form method="POST" action="admin.php?page=' . $this->shared->get('slug') . '-comment-items" autocomplete="off">';
        } else {
            echo '<form method="POST" action="admin.php?page=' . $this->shared->get('slug') . '-comment-items&cf=' . $comment_id_in_cf . '" autocomplete="off">';
        }

        ?>

        <input type="hidden" value="1" name="form_submitted">

        <?php if (isset($_GET['edit_id'])) : ?>

        <!-- Edit a Comment -->

        <div class="daext-form-container">

            <h3 class="daext-form-title"><?php esc_attr_e('Edit Comment Item',
                    'dale'); ?>&nbsp<?php echo $comment_item_obj->comment_item_id; ?></h3>

            <table class="daext-form">

                <input type="hidden" name="update_id" value="<?php echo $comment_item_obj->comment_item_id; ?>"/>

                <!-- Comment -->
                <tr>
                    <th scope="row"><?php esc_attr_e('Comment Section', 'dale'); ?></th>
                    <td>
                        <select id="comment-id" name="comment_id" class="daext-display-none">
                            <?php

                            global $wpdb;
                            $table_name  = $wpdb->prefix . $this->shared->get('slug') . "_comment";
                            $timelines_a = $wpdb->get_results("SELECT * FROM $table_name ORDER BY comment_id DESC",
                                ARRAY_A);

                            foreach ($comments_a as $single_comment) {
                                echo '<option value="' . $single_comment['comment_id'] . '" ' . selected($single_comment['comment_id'],
                                        $comment_item_obj->comment_id,
                                        false) . '>' . esc_attr(stripslashes($single_comment['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_comment($single_comment['comment_id'])))) . '</option>';
                            }

                            ?>
                        </select>
                        <div class="help-icon"
                             title='<?php esc_attr_e('The comment section that includes this comment item.',
                                 'dale'); ?>'></div>
                    </td>
                </tr>

                <!-- User -->
                <tr valign="top">
                    <th scope="row"><label for="name"><?php esc_attr_e('Author', 'dale'); ?></label></th>
                    <td>

                        <select id="user-id" name="user_id" class="daext-display-none">
                            <?php

                            $user_info = get_userdata($comment_item_obj->user_id);
                            $users     = get_users();
                            foreach ($users as $user) {
                                $user_info = get_userdata($user->ID);
                                echo '<option value="' . $user->ID . '" ' . selected($user->ID,
                                        $comment_item_obj->user_id) . '>' . esc_attr($user_info->display_name) . '</option>';
                            }

                            ?>
                        </select>
                        <div class="help-icon"
                             title='<?php esc_attr_e('The author of the comment item.', 'dale'); ?>'></div>
                    </td>
                </tr>

                <!-- Content -->
                <tr valign="top">
                    <th scope="row"><label for="content"><?php esc_attr_e('Content', 'dale'); ?></label></th>
                    <td>
                        <textarea type="text" id="content" maxlength="65535" rows="8" cols="60"
                                  name="content"><?php echo esc_attr(stripslashes($comment_item_obj->content)); ?></textarea>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The content of the comment item.', 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Approved -->
                <tr>
                    <th scope="row"><?php esc_attr_e('Approved', 'dale'); ?></th>
                    <td>
                        <select id="approved" name="approved" class="daext-display-none">
                            <option value="0" <?php selected($comment_item_obj->approved, 0); ?>><?php esc_attr_e('No',
                                    'dale'); ?></option>
                            <option value="1" <?php selected($comment_item_obj->approved, 1); ?>><?php esc_attr_e('Yes',
                                    'dale'); ?></option>
                        </select>
                        <div class="help-icon"
                             title='<?php esc_attr_e('The moderation status of the comment item.', 'dale'); ?>'></div>
                    </td>
                </tr>

            </table>

            <!-- submit button -->
            <div class="daext-form-action">
                <input class="button" type="submit" value="<?php esc_attr_e('Update Comment Item', 'dale'); ?>">
                <input id="cancel" class="button" type="submit" value="<?php esc_attr_e( 'Cancel', 'dale'); ?>">
            </div>

            <?php else : ?>

            <!-- Create New Comment Section -->

            <div class="daext-form-container">

                <h3 class="daext-form-title"><?php esc_attr_e('Create New Comment Item', 'dale'); ?></h3>

                <table class="daext-form">

                    <!-- Comment -->
                    <tr>
                        <th scope="row"><?php esc_attr_e('Comment Section', 'dale'); ?></th>
                        <td>
                            <select id="comment-id" name="comment_id" class="daext-display-none">
                                <?php

                                global $wpdb;
                                $table_name = $wpdb->prefix . $this->shared->get('slug') . "_comment";
                                $comments_a = $wpdb->get_results("SELECT * FROM $table_name ORDER BY comment_id DESC",
                                    ARRAY_A);

                                if ($comment_id_in_cf === false) {

                                    foreach ($comments_a as $single_comment) {
                                        echo '<option value="' . $single_comment['comment_id'] . '">' . esc_attr(stripslashes($single_comment['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_comment($single_comment['comment_id'])))) . '</option>';
                                    }

                                } else {

                                    foreach ($comments_a as $single_comment) {
                                        echo '<option value="' . $single_comment['comment_id'] . '" ' . selected($comment_id_in_cf,
                                                $single_comment['comment_id'],
                                                false) . '>' . esc_attr(stripslashes($single_comment['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_comment($single_comment['comment_id'])))) . '</option>';
                                    }

                                }

                                ?>
                            </select>
                            <div class="help-icon"
                                 title='<?php esc_attr_e('The comment section that includes this comment item.',
                                     'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- User -->
                    <tr valign="top">
                        <th scope="row"><label for="name"><?php esc_attr_e('Author', 'dale'); ?></label></th>
                        <td>

                            <select id="user-id" name="user_id" class="daext-display-none">
                                <?php

                                $users = get_users();
                                foreach ($users as $user) {
                                    $user_info = get_userdata($user->ID);
                                    echo '<option value="' . $user->ID . '">' . esc_attr($user_info->display_name) . '</option>';
                                }

                                ?>
                            </select>
                            <div class="help-icon"
                                 title='<?php esc_attr_e('The author of the comment item.', 'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- Content -->
                    <tr valign="top">
                        <th scope="row"><label for="content"><?php esc_attr_e('Content', 'dale'); ?></label></th>
                        <td>
                            <textarea type="text" id="content" maxlength="65535" rows="8" cols="60"
                                      name="content"></textarea>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The content of the comment item.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Approved -->
                    <tr>
                        <th scope="row"><?php esc_attr_e('Approved', 'dale'); ?></th>
                        <td>
                            <select id="approved" name="approved" class="daext-display-none">
                                <option value="0"><?php esc_attr_e('No', 'dale'); ?></option>
                                <option value="1"><?php esc_attr_e('Yes', 'dale'); ?></option>
                            </select>
                            <div class="help-icon" title='<?php esc_attr_e('The moderation status of the comment item.',
                                'dale'); ?>'></div>
                        </td>
                    </tr>

                </table>

                <!-- submit button -->
                <div class="daext-form-action">
                    <input class="button" type="submit" value="<?php esc_attr_e('Add Comment Item', 'dale'); ?>">
                </div>

                <?php endif; ?>

            </div>

            </form>

            <?php

            } else {

                echo '<p>' . esc_attr__('Please add at least one comment section with the ',
                        'dale') . '<a href="' . get_admin_url() . 'admin.php?page=dale-comment-sections">' . esc_attr('Comment Sections',
                        'dale') . '</a> ' . esc_attr__('menu', 'dale') . '.</p>';

            }

            ?>

        </div>