(function($) {

  'use strict';

  /**
   * Show or Hide specific time fields based on the Time Mode associated with the Event
   */
  function showHideTimeFields(timelineId){

    'use strict';

    //send ajax request to return the timeline data
    var data = {
      "action": "dale_get_timeline_data",
      "security": window.dale_nonce,
      "timeline_id": timelineId
    };

    //send ajax request
    $.post(window.dale_ajax_url, data, function(response) {

      'use strict';

      var timelineData = JSON.parse(response);

      //Display or hide the #show-icon-container
      switch(parseInt(timelineData.show_icon, 10)){

        case 0:

          //Disabled
          $('#show-icon-container').hide();

          break;

        case 1:

          //Enabled
          $('#show-icon-container').show();

          break;

      }

      //Display or hide the #manual-time-container
      switch(parseInt(timelineData.time_mode, 10)){

        case 0:

          //Auto
          $('#manual-time-container').hide();

          break;

        case 1:

          //Manual
          $('#manual-time-container').show();

          break;

      }

    });

  }

  function showHideExtraFields(layoutId){

    'use strict';

    switch(parseInt(layoutId, 10)){

      case 0:

        //None
        $('#html-container').hide();
        $('#image-container').hide();
        $('#tweet-id-container').hide();
        $('#content-container th, #content-container td').css('border-bottom-width', '0');

        break;

      case 1:

        //Image
        $('#html-container').hide();
        $('#image-container').show();
        $('#tweet-id-container').hide();
        $('#content-container th, #content-container td').css('border-bottom-width', '1px');

        break;

      case 2:

        //Tweet
        $('#html-container').hide();
        $('#image-container').hide();
        $('#tweet-id-container').show();
        $('#content-container th, #content-container td').css('border-bottom-width', '1px');

        break;

      case 3:

        //HTML
        $('#html-container').show();
        $('#image-container').hide();
        $('#tweet-id-container').hide();
        $('#content-container th, #content-container td').css('border-bottom-width', '1px');

        break;

    }

  }

  $(document).ready(function() {

    'use strict';

    //if the form is not displayed (this happens when there are not timeline sections) do nothing
    if($('.daext-form-container').length === 0){return;}

    showHideTimeFields($('#timeline-id').val());

    showHideExtraFields($('#extra').val());

    $('#timeline-id').on('change', function() {
      showHideTimeFields(this.value);
    });

    $('#extra').on('change', function() {
      showHideExtraFields(this.value);
    });

    $('#daext-filter-form select').on('change', function() {
      $('#daext-filter-form').submit();
    });

    //Reload the menu when the "Cancel" button is clicked
    $(document.body).on('click', '#cancel', function(event) {

      'use strict';

      event.preventDefault();
      window.location.replace(window.dale_admin_url +
          'admin.php?page=dale-timeline-items');

    });

  });

}(window.jQuery));