<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$all_data_coin = str_replace(' ','', get_post_meta( $post_id, 'currency_pairs' , true ) );
$design = get_post_meta( $post_id, 'design_binance_live_widget' , true );
$isChart = $design == 'style-1' ? 'false' : 'true';
$bg_color = get_post_meta( $post_id, 'back_color' , true );
$font_color = get_post_meta($post_id, 'font_color', true);
$class = "ccpwp-binance-live-widget board " . $design;
$all_data_coin = explode("," , $all_data_coin ) ;
$dataApi = array();
foreach( $all_data_coin as $index=>$value ){
    $coin_pairs = explode("/", $value );
    // Skip if base or quote is empty
    if (empty($coin_pairs[0]) || empty($coin_pairs[1])) {
        continue;
    }
    $coin_id = ccpwp_get_coin_ids( $coin_pairs[0] );
    if (is_string($coin_id) && $coin_id !== '') {
        $coin_id = ucwords($coin_id);
    } else {
        $coin_id = '';
    }
    $dataApi[] =  array(
        "name"=> $coin_id,
        "symbol"=>$coin_pairs[0].$coin_pairs[1],
        "quote"=>$coin_pairs[1],
        "base"=>$coin_pairs[0],
        "logo"=>CCPWP_URL . 'assets/coin-logos/',
        "ischart"=> $isChart,
        "bgColor"=> $bg_color,
        "fontColor"=> $font_color
    );
}

$vuiWidgetId = "ccpwp_vui_widget_". $post_id ."_".$widget_unique_id;
wp_localize_script( 'ccpw-binance-live-widget' , $vuiWidgetId ,  $dataApi );


ob_start();

?>

<!---------- CCPWP Version:-'. CCPWP_VERSION  .' By Cool Plugins Team -------------->

    <div class='<?php echo $class; ?>' id="<?php echo $vuiWidgetId; ?>" data-logo-url="<?php echo CCPWP_URL . 'assets/coin-logos/'; ?>">
    <div class='card-block' v-for="(value,index) in coins">
    <ccpw-vueWidget v-bind:ischart="<?php echo $isChart; ?>" v-bind:ticker="tickers[value.symbol] || {}" v-bind:info='value'></ccpw-vueWidget>
    </div>
    </div>

<?php
$crypto_html = ob_get_clean();