<?php
if (!defined('ABSPATH')) {
    exit;
}

function ccpw_get_translations()
{
    $static = [];
    $static = array(
        'list-widget' => array(
            'name' => __('Name', 'ccpw'),
            'price' => __('Price', 'ccpw'),
            'priceUSD' => __('Price(USD)', 'ccpw'),
            'priceEUR' => __('Price(EUR)', 'ccpw'),
            'priceGBP' => __('Price(GBP)', 'ccpw'),
            'supply' => __('Supply', 'ccpw'),
            'volume' => __('Volume', 'ccpw'),
            'marketcap' => __('Market Cap', 'ccpw'),
            'mcap' => __('Marketcap', 'ccpw'),
            'h24' => __('24H %', 'ccpw'),
            'changes7d' => __('7D %', 'ccpw'),
            'changes30d' => __('30D %', 'ccpw'),
            'chart7d' => __('Chart (7D)', 'ccpw'),
            'changes24h' => __('24H Change', 'ccpw'),
        ),
        'price-block' => array(
            'volume' => __('(24H Vol)', 'ccpw'),
            'priceUSD' => __('USD', 'ccpw'),
            'priceEUR' => __('EUR', 'ccpw'),
            'priceGBP' => __('GBP', 'ccpw'),
            'volumeH' => __('24H', 'ccpw'),
            'chart7d' => __('7D Chart', 'ccpw'),
        ),
        'accordion-block' => array(
            'price' => __('Price', 'ccpw'),
            'symbol' => __('Symbol', 'ccpw'),
            'changes_24h' => __('Changes 24h', 'ccpw'),
            'total_volume' => __('Total Volume', 'ccpw'),
            'market_cap' => __('Market Cap', 'ccpw'),
            'circulating_supply' => __('Circulating Supply', 'ccpw'),
            'chart7D' => __('7D Chart', 'ccpw'),
        ),
        'common' => array(
            'graphDataNotFound' => __('No Graphical Data', 'ccpw'),
            'usd' => __('USD ', 'ccpw'),
            'gbp' => __('GBP ', 'ccpw'),
            'eur' => __('EUR ', 'ccpw'),
        ),
        'metamask' => array(
            // Checkout&validate fields static messages start here
            'metamask_address' => __('Please enter your  Payment address', 'ccpw'),
            'valid_wallet_address' => __('Please enter valid  Payment address', 'ccpw'),
            'required_fiat_key' => __('Please enter price conversion API key', 'ccpw'),
            'valid_fiat_key' => __('Please enter valid price conversion API key', 'ccpw'),
            'required_currency' => __('Please select a currency', 'ccpw'),
            'required_network_check' => __('Please select a payment network', 'ccpw'),
            'payment_network' => __('Select Payment Network', 'ccpw'),
            'switch_network_msg' => __('Please switch to the network below inside your wallet to complete this payment.', 'ccpw'),
            'connected_to' => __('Connected to', 'ccpw'),
            'disconnect' => __('Disconnect Wallet', 'ccpw'),
            'wallet' => __('Wallet', 'ccpw'),
            'network' => __('Network', 'ccpw'),
            'insufficent' => __('Insufficient balance in your wallet for this order. Try different network, coin.', 'ccpw'),
            'payment_notice' => __('Please proceed with the payment below.', 'ccpw'),
            'notice_msg' => __('Please dont change the payment amount in your wallet, it could lead to order failure.', 'ccpw'),
            'payment_notice_msg' => __('Please wait while we check your transaction confirmation on the block explorer. Do not change the gas fee until the transaction is complete to avoid order failure.', 'ccpw'),
            'cancel_order' => __('If you want to pay with a different cryptocurrency, network, or wallet, please', 'ccpw'),
            'cancel_this_order' => __('cancel this order', 'ccpw'),
            'create_new_one' => __('and create a new one.', 'ccpw'),
            'to_complete' => __('to complete this order', 'ccpw'),
            'through' => __('through ', 'ccpw'),
            'processing' => __('Processing', 'ccpw'),
            'connected' => __('Connected', 'ccpw'),
            'not_connected' => __('Not Connected', 'ccpw'),
            'order_price' => __('Order price: ', 'ccpw'),
            'pay_with' => __('Please pay', 'ccpw'),
            'payment_status' => __('Payment Status', 'ccpw'),
            'in_process' => __('In Process...', 'ccpw'),
            'pending' => __('Pending', 'ccpw'),
            'failed' => __('Failed', 'ccpw'),
            'donate' => __('Donate', 'ccpw'),
            'completed' => __('Completed', 'ccpw'),
            'check_in_explorer' => __('Check in explorer', 'ccpw'),
            'rejected_msg' => __('Your payment has been rejected. Please try to make payment again.', 'ccpw'),
            'confirmed_payments_msg' => __('Thank you for making the payment. Your transaction has been confirmed by the explorer.', 'ccpw'),
            'connect_wallet' => __('Connect Wallet', 'ccpw'),
            'select_network' => __('Payment Network', 'ccpw'),
            'success_payment' => __('Payment completed successfully', 'ccpw'),
            'success_payment_msg' => __('Donation completed successfully', 'ccpw'),
            'payment_process' => __('Payment in process', 'ccpw'),
            'payment_confimation' => __('Confirm Payment Inside Your Wallet!', 'ccpw'),
            'select_currency' => __('Please select a currency', 'ccpw'),
            'select_cryptocurrency' => __('Select Cryptocurrency..', 'ccpw'),
            'valid_amount' => __('Please enter a valid amount', 'ccpw'),

        ),

    );
    return $static;
}

function ccpw_load_assets($type, $post_id)
{

    if (!wp_script_is('jquery', 'done')) {
        wp_enqueue_script('jquery', 'true');
    }
    $filePaths = glob(CCPWP_PATH . 'includes/react-widget/build/' . '/*.php');
    $fileName = pathinfo($filePaths[0], PATHINFO_FILENAME);
    $jsbuildUrl = str_replace('.asset', '', $fileName);

    // global assets
    wp_register_script('ccpw_react-wdgets', CCPWP_URL . 'includes/react-widget/build/' . $jsbuildUrl . '.js', array('wp-element'), CCPWP_VERSION, true);
    wp_register_script('fear-greed-widget', CCPWP_URL.'assets/js/cs-widget.js', array('wp-element'), CCPWP_VERSION, true);
    wp_register_script('ccpw-lscache', CCPWP_URL . 'assets/js/lscache.min.js', array('jquery'), CCPWP_VERSION, true);
    wp_enqueue_script('ccpw-numeral', CCPWP_URL . 'assets/js/numeral.min.js', array('jquery'), CCPWP_VERSION);
    wp_register_style('ctl-bootstrap', CCPWP_URL . 'assets/css/min/bootstrap.min.css', array(), CCPWP_VERSION, null);
    wp_enqueue_style('ccpwp-styles', CCPWP_URL . 'assets/css/min/ccpwp-styles.min.css', array(), CCPWP_VERSION, null, 'all');
    wp_enqueue_style('ccpwp-icons', CCPWP_URL . 'assets/css/ccpw-icons.css', array(), CCPWP_VERSION, null, 'all');
    wp_enqueue_style('dashicons');

    $is_live_changes = get_post_meta($post_id, 'live_changes', true);
    $binance_url = get_post_meta($post_id, 'binance_url', true);
    $api_option = get_option("openexchange-api-settings");
    $coingecko_api_cache_time = isset($api_option['select_cache_time']) ? (int) $api_option['select_cache_time'] : 10;
    $api_type = (isset($api_option['select_api'])) ? $api_option['select_api'] : "coingecko";

    $localize_data = array(
        'restUrl' => get_rest_url(),
        'bUrl' => $binance_url,
        'home_url' => home_url(),
        'url' => CCPWP_URL,
        'cmc_slug' => get_cmc_single_page_slug(),
        'translations' => ccpw_get_translations(),
        'cmc_enabled' => get_option('cmc-dynamic-links'),
        'cacheTime' => $coingecko_api_cache_time * 60000,
        'api_type' => $api_type,
        'nonce' => wp_create_nonce('wp_rest'),
    );

    if ($type == 'binance-live-widget') {
        if ($is_live_changes == "on") {
            wp_enqueue_script('ccpw-jquery-number', CCPWP_URL . 'assets/js/jquery.number.min.js', array('jquery'), CCPWP_VERSION, true);

            wp_enqueue_script('ccpw_stream', CCPWP_URL . 'assets/js/stream.js', array('jquery'), CCPWP_VERSION, true);
            $binance_url = get_post_meta($post_id, 'binance_url', true);
            wp_localize_script('ccpw_stream', 'ccpw_data', array('bUrl' => $binance_url));
        }
        wp_enqueue_script('ccpw-binance-live-widget', CCPWP_URL . 'assets/js/ccpw-binance-live-widget.js', array('jquery'), CCPWP_VERSION, true);
        $binance_url = get_post_meta($post_id, 'binance_url', true);
        wp_localize_script('ccpw-binance-live-widget', 'ccpw_data', array('bUrl' => $binance_url));
        wp_enqueue_style('ccpwp-vue-widget-style', CCPWP_URL . 'assets/css/vue-widget-style.css', array(), CCPWP_VERSION, null, 'all');
    } else if ($type == 'price-block') {
        $binance_url = get_post_meta($post_id, 'binance_url', true);
        wp_enqueue_style('ccpw-price-block', CCPWP_URL . 'assets/css/ccpw-price-block.css', null, CCPWP_VERSION);
        wp_enqueue_script('ccpw_react-wdgets');
        wp_localize_script(
            'ccpw_react-wdgets',
            'ccpw_react_data',
            $localize_data
        );
        $disable_bootstrap = get_post_meta($post_id, 'disable_bootstrap', true);
        $design_block = get_post_meta($post_id, 'design_block', true);
        if ($disable_bootstrap != true) {
            wp_enqueue_style('ctl-bootstrap');
        }

        //  else if ($design_block == 'style-5') {
        //     wp_enqueue_style('ccpw_block_odometer_style', CCPWP_URL . 'assets/css/ccpw-odometer-theme-default.css', null, CCPWP_VERSION);

        // }
    } else if ($type == 'accordion-block') {
        $binance_url = get_post_meta($post_id, 'binance_url', true);
        wp_enqueue_style('ccpw-price-block', CCPWP_URL . 'assets/css/ccpw-price-block.css', null, CCPWP_VERSION);
        // wp_enqueue_style('ccpw-price-block', CCPWP_URL . 'assets/css/min/ccpw-price-block.min.css', null, CCPWP_VERSION);
        wp_enqueue_script('ccpw_react-wdgets');
        wp_localize_script(
            'ccpw_react-wdgets',
            'ccpw_react_data',
            $localize_data
        );

    } else if ($type == "ticker") {
        // wp_enqueue_style('ccpw-tooltip-css', CCPWP_URL . 'assets/css/min/tooltipster.bundle.min.css', null, CCPWP_VERSION);
        wp_enqueue_style('ccpw-ticker', CCPWP_URL . 'assets/css/ccpw-ticker.css', null, CCPWP_VERSION);
        wp_enqueue_script('ccpw_react-wdgets');
        wp_localize_script(
            'ccpw_react-wdgets',
            'ccpw_react_data',
            $localize_data
        );
    } else if ($type == "list-widget") {
        $disable_bootstrap = get_post_meta($post_id, 'disable_bootstrap', true);
        // list widget styles
        if ($disable_bootstrap != true) {
            wp_enqueue_style('ctl-bootstrap');
        }
        $binance_url = get_post_meta($post_id, 'binance_url', true);

        wp_enqueue_style('ccpw-list-widget', CCPWP_URL . 'assets/css/ccpw-list-widget.css', null, CCPWP_VERSION);
        wp_enqueue_script('ccpw_react-wdgets');
        wp_localize_script(
            'ccpw_react-wdgets',
            'ccpw_react_data',
            $localize_data
        );

    } else if ($type == "price-label") {
        wp_enqueue_style('ccpw-price-label', CCPWP_URL . 'assets/css/ccpw-price-label.css', null, CCPWP_VERSION);
        wp_enqueue_script('ccpw_react-wdgets');
        wp_localize_script(
            'ccpw_react-wdgets',
            'ccpw_react_data',
            $localize_data
        );
    } else if ($type == "chart") {
        wp_enqueue_style('ccpw-charts-style', CCPWP_URL . 'assets/css/ccpw-charts.css', null, CCPWP_VERSION);
        // dynamic chart assets
        wp_enqueue_script('amcharts51', CCPWP_URL . 'assets/js/index.js', array(), CCPWP_VERSION, true);
        wp_enqueue_script('amcharts52', CCPWP_URL . 'assets/js/xy.js', array(), CCPWP_VERSION, true);
        wp_enqueue_script('amcharts23', CCPWP_URL . 'assets/js/stock.js', array(), CCPWP_VERSION, true);
        wp_enqueue_script('amcharts54', CCPWP_URL . 'assets/js/Animated5.js', array(), CCPWP_VERSION, true);
        wp_enqueue_script('ccpw-lscache');
        wp_enqueue_script('ccpw-jquery-number', CCPWP_URL . 'assets/js/jquery.number.min.js', array('jquery'), CCPWP_VERSION, true);
        wp_enqueue_script('ccpw-chart-js', CCPWP_URL . 'assets/js/create-charts.js', array('jquery'), CCPWP_VERSION, true);
        wp_localize_script(
            'ccpw-chart-js',
            'ccpw_data_object',
            array('ajax_url' => admin_url('admin-ajax.php'),
                'nonce' => wp_create_nonce('ccpw-chart-ajax-nonce'),
            )
        );

    } else if ($type == "price-card") {
        $disable_bootstrap = get_post_meta($post_id, 'disable_bootstrap', true);
        if ($disable_bootstrap != true) {
            wp_enqueue_style('ctl-bootstrap');
        }
        wp_enqueue_style('ccpw-price-card', CCPWP_URL . 'assets/css/ccpw-price-card.css', null, CCPWP_VERSION);
        wp_enqueue_script('ccpw_react-wdgets');
        wp_localize_script(
            'ccpw_react-wdgets',
            'ccpw_react_data',
            $localize_data
        );

    } else if ($type == "slider-widget") {
        wp_enqueue_script('ccpw_react-wdgets');
        wp_localize_script(
            'ccpw_react-wdgets',
            'ccpw_react_data',
            $localize_data
        );
        wp_enqueue_style('ccpw-slider-widget', CCPWP_URL . 'assets/css/ccpw-slider-widget.css', null, CCPWP_VERSION);
        wp_enqueue_style('ctl-bootstrap');

    } else if ($type == "rss-feed") {
        $rss_style = get_post_meta($post_id, 'rss_style', true);
        if ($rss_style == "ticker-rss") {
            $rss_ticker_speed = get_post_meta($post_id, 'rss_ticker_speed', true);
            $speed_rss_ticker = !empty($rss_ticker_speed) ? $rss_ticker_speed : 15;
            $id = "ccpw-" . $type . "-" . $post_id;
            wp_enqueue_style('ccpw-news-ticker', CCPWP_URL . 'assets/css/min/ccpw-news-ticker.min.css', null, CCPWP_VERSION);
            wp_enqueue_script('ccpw_bxslider_js', CCPWP_URL . 'assets/js/jquery.bxslider.min.js', array('jquery'), CCPWP_VERSION, true);
            wp_add_inline_script('ccpw_bxslider_js', 'jQuery(document).ready(function($){
		   $(".ccpw-news-ticker #' . $id . '").each(function(index){
                    $(this).bxSlider({
                        ticker:true,
                        minSlides:1,
                        maxSlides:12,
                        slideWidth:"auto",
                        tickerHover:true,
                        wrapperClass:"tickercontainer",
                        speed:' . $speed_rss_ticker . '*4000,
                    });
		   });

	   });');
        } else if ($rss_style == "list-rss") {
            wp_enqueue_style('ccpw-news-ticker', CCPWP_URL . 'assets/css/min/ccpw-news-ticker.min.css', null, CCPWP_VERSION);
        }

    } else if ($type == "multi-currency-tab") {
        wp_enqueue_script('ccpw_react-wdgets');
        wp_localize_script(
            'ccpw_react-wdgets',
            'ccpw_react_data',
            $localize_data
        );
        wp_enqueue_style('ccpw-multi-currency-tabs', CCPWP_URL . 'assets/css/ccpw-multi-currency-tabs.css', null, CCPWP_VERSION);

    } 
    else if ($type == "fear-greed") {
        wp_enqueue_script('fear-greed-widget');
   
        wp_enqueue_script('ccpw-fear-greed-script', CCPWP_URL . 'assets/js/fear-greed.js', array('jquery'), CCPWP_VERSION);
        wp_enqueue_style('ccpw-fear-greed-widget', CCPWP_URL . 'assets/css/ccpw-fear-greed.css', null, CCPWP_VERSION);
   }
    else if ($type == 'calculator') {
        wp_enqueue_script('ccpw_react-wdgets');
        wp_localize_script(
            'ccpw_react-wdgets',
            'ccpw_react_data',
            $localize_data
        );

        wp_enqueue_style('ccpw-calculator-style', CCPWP_URL . 'assets/css/min/ccpw-calculator.min.css', null, CCPWP_VERSION);

    } else if ($type == 'table-widget') {
        if ($is_live_changes == "on") {
            wp_enqueue_script('ccpw-jquery-number', CCPWP_URL . 'assets/js/jquery.number.min.js', array('jquery'), CCPWP_VERSION, true);

            wp_enqueue_script('ccpw_stream', CCPWP_URL . 'assets/js/stream.js', array('jquery'), CCPWP_VERSION, true);
            $binance_url = get_post_meta($post_id, 'binance_url', true);
            wp_localize_script('ccpw_stream', 'ccpw_data', array('bUrl' => $binance_url));
        }

        wp_enqueue_script('ccpw-datatable', CCPWP_URL . 'assets/js/jquery.dataTables.min.js', null, CCPWP_VERSION);
        wp_enqueue_script('ccpw-headFixer', CCPWP_URL . 'assets/js/tableHeadFixer.js', null, CCPWP_VERSION);
        wp_enqueue_style('ccpw-custom-datatable-style', CCPWP_URL . 'assets/css/ccpw-custom-datatable.css', null, CCPWP_VERSION);
        wp_enqueue_script('ccpw-table-script', CCPWP_URL . 'assets/js/ccpw-table-widget.js', array('jquery'), CCPWP_VERSION);
        wp_enqueue_script('ccpw-table-sort', CCPWP_URL . 'assets/js/tablesort.min.js', array('jquery'), CCPWP_VERSION);
        wp_localize_script(
            'ccpw-table-script',
            'ccpw_js_objects',
            array('ajax_url' => admin_url('admin-ajax.php'),
                'wp_nonce' => wp_create_nonce('ccpwf-tbl-widget'),
            )
        );
    } else if ($type == "coingecko-widget") {
        wp_enqueue_style('coingecko-widget-style', CCPWP_URL . 'assets/css/coingecko-widget.css', null, CCPWP_VERSION);
        wp_enqueue_script('ccpw-coingecko-marketlist', 'https://widgets.coingecko.com/gecko-coin-market-ticker-list-widget.js', null, null);
        wp_enqueue_script('ccpw-coingecko-heatmap', 'https://widgets.coingecko.com/gecko-coin-heatmap-widget.js', null, null);
        wp_enqueue_script('ccpw-coingecko-comparsion-chart', 'https://widgets.coingecko.com/gecko-coin-compare-chart-widget.js', null, null);

    } else if ($type == "donation-widget") {
        wp_enqueue_style('donation-widget-style', CCPWP_URL . 'assets/css/donation-style.css', null, CCPWP_VERSION);
        wp_enqueue_style('donation-widget-styleSS', CCPWP_URL . 'assets/css/ccpw-donation-styles.css', null, CCPWP_VERSION);

        // wp_enqueue_script('ccpw-metamask-script', CCPWP_URL . 'assets/js/ccpw-donation-metamask.js', array('jquery'),CCPWP_VERSION, true);
        // wp_enqueue_script('ccpw-ether', CCPWP_URL . 'assets/js/ethers-5.2.umd.min.js', array('jquery'),CCPWP_VERSION, true);
        // wp_enqueue_script('ccpw-sweetalert2', CCPWP_URL . 'assets/js/sweetalert2.js', array('jquery'),CCPWP_VERSION, true);
        wp_enqueue_script('ccpw_react-wdgets');
        wp_localize_script(
            'ccpw_react-wdgets',
            'ccpw_react_data',
            $localize_data
        );

    }

}
// Apply RTl css
add_action('init', 'ccpw_rtl_check');

function ccpw_rtl_check()
{
    global $wp_locale;
    $check = $wp_locale->is_rtl();
    if ($check == true) {
        wp_enqueue_style('ccpw_rtl_css', CCPWP_URL . 'assets/css/ccpw-rtl.css', null, CCPWP_VERSION);
    }
}
