document.addEventListener("DOMContentLoaded", function () {
    const widgetContainers = document.querySelectorAll("[id^='fear-greed-widget-']"); 

    widgetContainers.forEach(function (widgetContainer) {
        const fngStyle = widgetContainer.getAttribute("data-fng-style");
        const backgroundColor = widgetContainer.getAttribute("data-background-color");
        const arrowColor = widgetContainer.getAttribute("data-arrow-color");
        const fontColor = widgetContainer.getAttribute("data-font-color");
        const marketSentiment = widgetContainer.getAttribute("data-market-sentiment");
        const lastUpdate = widgetContainer.getAttribute("data-last-update");

        widgetContainer.innerHTML = `
            <cs-widget type="fear-and-greed"
                theme="light"
                direction="${fngStyle}"
                background="${backgroundColor}"
                is-market-sentiment-visible="${marketSentiment}"
                is-last-updated-visible="${lastUpdate}"
                title-color="${fontColor}"
                chart-indicator-one-color="#F02934"
                chart-indicator-two-color="#F07D29"
                chart-indicator-three-color="#9ACB82"
                chart-indicator-four-color="#34B349"
                subtitle-color="${fontColor}"
                last-updated-color="${fontColor}"
                arrow-color="${arrowColor}">
            </cs-widget>`;
    });
});
