import Vue from './vue.js';
import currencycards from './vue-card.js';
import store from './store.js';
import "./vuex.js";
import { subscribeSymbol } from './binance.js';

Vue.config.productionTip = false;

jQuery(document).ready(function($) {
    let vue_widgets = $('.ccpwp-binance-live-widget');
    if (vue_widgets.length > 0) {
        vue_widgets.each(function(index, el) {
            let element = $(this).attr('id');
            let data = window[element];
            let CoinData = data;

            // Explicitly convert isChart to a boolean
            let isChart = CoinData[0].ischart === true || CoinData[0].ischart === "true";
            let bgColor = CoinData[0].bgColor;
            let fontColor = CoinData[0].fontColor;
            
            // Create the Vue instance and set the data dynamically
            let vueWidget = new Vue({
                store,
                data: {
                    quote: 'BNB',
                    quoteOptions: ['BNB', 'BTC', 'ETH', 'USDT'],
                    baseCurrency: {},
                    coins: CoinData,
                    isChart: isChart, // Ensure isChart is a boolean
                    bgColor: bgColor,
                    fontColor: fontColor
                },
                components: {
                    'ccpw-vuewidget': currencycards,
                },
                mounted() {
                    if (this.coins) {
                        this.coins.forEach(coin => {
                            // Subscribe to symbol updates
                            subscribeSymbol(coin.symbol);
                        });
                    }
                },
                computed: {
                    ...Vuex.mapState(['tickers']),
                    tickers() {
                        // Compute the tickers for all coins in the list
                        return this.coins.map(coin => this.$store.state.tickers[coin.symbol] || {});
                    }
                },
                template: `
                    <div class="card-block-main-container" id="${element}">
                        <div class="card-block" v-for="(coin, index) in coins" :key="coin.symbol">
                            <ccpw-vuewidget 
                                :coins="[coin]" 
                                :info="coin" 
                                :ticker="tickers[index]" 
                                :quote="quote" 
                                :ischart="isChart"
                                :bgColor="bgColor" 
                                :fontColor="fontColor" /> <!-- Properly pass the boolean value -->
                            </ccpw-vuewidget>
                        </div>
                    </div>
                `
            }).$mount("#" + element);
        });
    }
});
