jQuery(document).ready(function ($) {
    const $deleteCacheBtn = $("#cmc_delete_cache");
    const ajaxUrl = $deleteCacheBtn.data('ajax-url');
    const nonce = $deleteCacheBtn.data('cmc-nonce');
    $deleteCacheBtn.prop("disabled", false).on("click", function (e) {
        e.preventDefault();
        $(this).text('Purging...').prop("disabled", true);
        const requestData = {
            action: 'purge_transient_button',
            nonce: nonce
        };
        $.ajax({
            type: 'POST',
            url: ajaxUrl,
            data: requestData,
            success: function (response) {
                if (response !== undefined && response.success == true) {
                    $deleteCacheBtn.text('Purged Cache').prop("disabled", true);
                }
            },
            error: function (error) {
                console.log(error);
            }
        });
    });
});