<?php
if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('CCPWP_Review_Notice')):
    class CCPWP_Review_Notice
{
        const PLUGIN = 'Cryptocurrency Widgets PRO';
        
        /**
         * Get sanitized plugin name
         * @return string Sanitized plugin name
         */
        public static function get_plugin_name() {
            return sanitize_text_field(self::PLUGIN);
        }
        const SLUG = 'ccpwp';
        const LOGO = CCPWP_URL . 'images/crypto-widget-pro.png';
        const SPARE_ME = 'ccpwp_spare_me';
        const ACTIVATE_TIME = 'ccpw_activation_time';
        const REVIEW_LINK = 'https://wordpress.org/support/plugin/cryptocurrency-price-ticker-widget/reviews/#new-post';
        const AJAX_REQUEST = 'ccpwp_dismiss_notice';
    }
endif;

if (!class_exists('CCPWP_Review_Class')) {
    class CCPWP_Review_Class
    {
        /**
         * The Constructor
         */
        public function __construct()
        {
            // register actions

            if (is_admin()) {
                add_action('admin_notices', array($this, 'atlt_admin_notice_for_reviews'));
                add_action('wp_ajax_' . CCPWP_Review_Notice::AJAX_REQUEST, array($this, 'atlt_dismiss_review_notice'));
                add_action('admin_enqueue_scripts', array($this, 'enqueue_feedback_notice_assets'));
            }
        }

        // enqueue feedback notice assets
        public function enqueue_feedback_notice_assets()
        {
            wp_enqueue_style(
                'ccpw-feedback-notice-style',
                CCPWP_URL . 'admin/feedback-notice/css/ccpw-feedback-notice.css',
                [],
                CCPWP_VERSION
            );
            
            wp_enqueue_script(
                'ccpw-feedback-notice-script',
                CCPWP_URL . 'admin/feedback-notice/js/ccpw-feedback-notice.js',
                ['jquery'],
                CCPWP_VERSION,
                true
            );
        }

        // ajax callback for review notice
        public function atlt_dismiss_review_notice()
        {
            check_ajax_referer('atlt_dismiss_notice_nonce', 'nonce');
            $rs = update_option(CCPWP_Review_Notice::SPARE_ME, 'yes');
            echo json_encode(array("success" => "true"));
            exit;
        }
        // admin notice
        public function atlt_admin_notice_for_reviews()
        {

            if (!current_user_can('update_plugins')) {
                return;
            }
            if (get_option(CCPWP_Review_Notice::ACTIVATE_TIME)) {
                // get installation dates and rated settings
                $installation_date = date('Y-m-d h:i:s', (int) get_option(CCPWP_Review_Notice::ACTIVATE_TIME));
            }

            // check user already rated
            if (get_option(CCPWP_Review_Notice::SPARE_ME)) {
                return;
            }

            // grab plugin installation date and compare it with current date
            $display_date = date('Y-m-d h:i:s');
            $install_date = new DateTime($installation_date);
            $current_date = new DateTime($display_date);
            $difference = $install_date->diff($current_date);
            $diff_days = $difference->days;

            // check if installation days is greator then week
            if (isset($diff_days) && $diff_days >= 3) {
                echo $this->atlt_create_notice_content();
            }
        }

        // generated review notice HTML
        public function atlt_create_notice_content()
        {

            $ajax_url = esc_url(admin_url('admin-ajax.php'));
            $ajax_callback = CCPWP_Review_Notice::AJAX_REQUEST;
            $wrap_cls = esc_attr("notice notice-info is-dismissible");
            $img_path = esc_url(CCPWP_Review_Notice::LOGO);
            $nonce = wp_create_nonce('atlt_dismiss_notice_nonce');
            $p_name = CCPWP_Review_Notice::get_plugin_name();
            $like_it_text = esc_html__('Rate Now! ★★★★★', 'atlt2');
            $already_rated_text = esc_html__('Already Reviewed', 'atlt2');
            $not_like_it_text = esc_html__('Not Interested', 'atlt2');
            $p_link = esc_url(CCPWP_Review_Notice::REVIEW_LINK);

            $message = sprintf(
                "Thanks for using <b>%s</b> - WordPress plugin. We hope you liked it! <br/>Please give us a quick rating, it works as a boost for us to keep working on more <a href='%s' target='_blank'><strong>Cool Plugins</strong></a>!<br/>",
                esc_html($p_name),
                esc_url('https://coolplugins.net')
            );

            $sanitized_slug = esc_attr(CCPWP_Review_Notice::SLUG);
            $html = '<div data-ajax-url="%8$s"  data-ajax-callback="%9$s" data-ajax-nonce="%11$s" class="' . $sanitized_slug . '-feedback-notice-wrapper %1$s">
        <div class="message_container">%4$s
        <div class="callto_action">
        <ul>
            <li class="love_it"><a href="%5$s" class="like_it_btn button button-primary" target="_new" title="%6$s">%6$s</a></li>
            <li class="already_rated"><a href="javascript:void(0);" class="already_rated_btn button ' . $sanitized_slug . '_dismiss_notice" title="%7$s">%7$s</a></li>
            <li class="already_rated"><a href="javascript:void(0);" class="already_rated_btn button ' . $sanitized_slug . '_dismiss_notice" title="%10$s">%10$s</a></li>
        </ul>
        <div class="clrfix"></div>
        </div>
        </div>
        </div>';


            return sprintf($html,
                $wrap_cls,
                $img_path,
                $p_name,
                $message,
                $p_link,
                $like_it_text,
                $already_rated_text,
                $ajax_url, // 8
                $ajax_callback, //9
                $not_like_it_text, //10
                $nonce
            );

        }

    } //class end
    new CCPWP_Review_Class();
}
